/***************************************************************************
                          event.h  -  description
                             -------------------
    begin                : Sun Jan 6 2002
    copyright            : (C) 2002 by 
    email                : 
 ***************************************************************************/

#ifndef EVENT_H
#define EVENT_H

#include "rcobject.h"

enum EventType{
	ET_NONE         = 0,
	ET_ERROR        = 1,
	ET_WARNING      = 2,
	ET_MESSAGE      = 3,
	ET_STATUSUPDATE = 4
};

enum EventSeverity{
	ES_NONE        = 0,
	ES_DEBUG       = 1,
	ES_UNIMPORTANT = 2,
	ES_JUSTINCASE  = 3,
	ES_GOODTOKNOW  = 4,
	ES_IMPORTANT   = 5,
	ES_CRITICAL    = 8
};

#define POST_MESSAGE(__severity, __string) EQ().PostEvent(new MStringEvent(ET_MESSAGE, __severity, __string));
#define POST_WARNING(__severity, __string) EQ().PostEvent(new MStringEvent(ET_MESSAGE, __severity, __string));
#define POST_ERROR(__severity, __string) EQ().PostEvent(new MStringEvent(ET_ERROR, __severity, __string));

#ifdef _DEBUG
#define POST_DMESSAGE(__string) EQ().PostEvent(new MStringEvent(ET_MESSAGE, ES_DEBUG, __string));
#else
#define POST_DMESSAGE(__string)
#endif //_DEBUG

class MEvent : public MRCObject  {
public: 
	MEvent(int type, int severity, DWORD ID = 0);
	virtual ~MEvent();
	// pure virtual functions
	virtual int GetMemUsage() = 0;
	virtual CString Format()  = 0;
	// general service
	int GetType(){return m_nType;}
	int GetSeverity(){return m_nSeverity;}
	int GetTime(){return m_nTime;}
	DWORD GetID(){return m_dwID;}
protected:
	int m_nType;
	int m_nSeverity;
	int m_nTime;
	DWORD m_dwID; // have to think of the method for generating such IDs
private:
	// no default constructor
	MEvent();
	MEvent(const MEvent&);
	const MEvent& operator=(const MEvent&);
};

template<class T>
class TSimpleEvent : public MEvent {
public:
	TSimpleEvent(int type, int severity, const T& value, DWORD ID = 0) : MEvent(type, severity, ID), m_value(value) {}
	virtual ~TSimpleEvent(){}
	// pure virtual functions
	virtual int GetMemUsage(){return sizeof(TSimpleEvent<T>);}
protected:
	T m_value;
};

class MStringEvent : public TSimpleEvent<CString>{
public:
	MStringEvent(int type, int severity, const CString& value, DWORD ID = 0);
	virtual int GetMemUsage();
	virtual CString Format();
};

// event receiver interface
class MEventReceiver {
public:
	virtual ~MEventReceiver();
	virtual bool IsOfInterest(MEvent* pEvent) = 0;
	virtual bool IsSync() = 0;
	virtual void OnEvent(MEvent* pEvent) = 0;
};

// event queue
class MEventQueue {
	// Post event, Send event, Add-RemoveReceiver, EnumReceivers, etc.
	friend MEventQueue& EQ();
public:
	//
	void PostEvent(MEvent* pEvent);
	bool SendEvent(MEvent* pEvent);// same as
	     // post but waits for async receivers to receive
	     // returns true if the event was delivered
	void AddReceiver(MEventReceiver*);
	void RemoveReceiver(MEventReceiver*);
protected:
	std::list<MEventReceiver*> m_receivers;
	MMutex m_mutex;
private:
	MEventQueue();
	~MEventQueue();
	static MEventQueue ms_EventQueue;
};
extern MEventQueue& EQ();

class MSyncEventReceiver : public MEventReceiver
{
public:
private:
	virtual bool IsSync(){return true;}
};

class MAsyncEventReceiver : public MEventReceiver
{
	// bool bHaveMessages
	// bool bMissedMessages
	// poll()
public:
	MAsyncEventReceiver(int nMaxTime, int nMaxMem = INT_MAX);
	virtual ~MAsyncEventReceiver();
	// getting events
	bool HaveEvents();
	int MissedEvents();
	void ResetMissedEvents();
	MEvent* Front();
	void Pop();
	// wait for an event
	bool Poll(u_long time = ULONG_MAX);
protected:
	std::deque<TSmartPtr<MEvent> > m_queue;
	MMutex m_mutex;
	MWaitCondition m_wait;
	int m_nMaxTime;
	int m_nMaxMem;
	int m_nMemUsed;
	int m_nMissedEvents;
	// virtual methods
	virtual void OnEvent(MEvent* pEvent);
	virtual bool IsOfInterest(MEvent* pEvent){return true;}
private:
	virtual bool IsSync(){return false;}
};

#endif
