/***************************************************************************
                          mprintf.cpp  -  description
                             -------------------
    begin                : Wed Oct 31 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "mprintf.h"
#include "tstring.h"
#include "term_help.h"
#include "ansicolor.h"

MPrintf::MPrintf(int nCPL = -1)
{
	m_nCPL = nCPL;
	m_nCaret = 0;
	m_nTabSize = 8;
	m_bWordwrap = true;
}

MPrintf::~MPrintf()
{
}

bool MPrintf::IsWhite(char c)
{
	return c==' ' || c=='\t';
}

bool MPrintf::OnNewLine(int nCharsLeft)
{
	return true;
}

//int operator()(LPCSZ szFormat, ...)
int MPrintf::print(const char * szFormat, ...)
{
	CString s;
	va_list ap;
	va_start(ap, szFormat);
	s.format(szFormat, ap);
	va_end(ap);
	// entry point to enable post-processing
	PrePrint(s);
	// now the fun starts...
	return PrintBuf(s.c_str(), s.length());
}

int MPrintf::PrintBuf(const char * buf, int nSize)
{
	int nLastWhite = -1;
	int nLinesUsed = 0;
	int n;
	bool bEsc = false;
	bool bEscBracket = false;
	bool bForcedNewline = false;
	for (int i = 0; i<nSize; ++i)
	{
		switch (buf[i]){
			case '\n':
				if (bForcedNewline && m_nCaret == 0)
				{
					bForcedNewline = false;
					break;
				}
				++nLinesUsed;
			case '\r':
				m_nCaret = 0;
				if (EOF == putchar(buf[i]))
					return nLinesUsed;
				if (buf[i]=='\n')
					if (!OnNewLine(nSize-i-1))
						return nLinesUsed;
				bEsc = false;
				bEscBracket = false;
				break;
			case '\t':
				for (n = m_nTabSize - (m_nCaret+m_nTabSize) % m_nTabSize; n>0; --n)
				{
					if (EOF == putchar(' '))
						return nLinesUsed;
					++m_nCaret;
				}
				bEsc = false;
				bEscBracket = false;
				break;
			case ' ':
				nLastWhite = m_nCaret;
				bEsc = false;
				bEscBracket = false;
			default:
				if (EOF == putchar(buf[i]))
					return nLinesUsed;
				
				// recognise some simple escapes
				if (buf[i] == ESC_CHAR)
					bEsc = true;
				else if (bEsc)
				{
					if (buf[i] == '[')
					{
						// asni-begin
						bEscBracket = true;
					}
					bEsc = false;
				}
					
				// escapes -- suppress them from the position calculation
				if (!(bEsc || bEscBracket))
				{
					++m_nCaret;
					bForcedNewline = false;
				}
				
				// escape escapes
				if (bEscBracket && buf[i] == 'm')
					bEscBracket = false;
				//
		}
		if (m_nCPL>0 && m_nCaret >= m_nCPL)
		{
			// it might be that the next symbol is '\n', then we dont need it all
			if (EOF == putchar('\n')) //??? will it work? remmember, we are at last position
				return nLinesUsed;
			++nLinesUsed;
			m_nCaret = 0;
			bForcedNewline = true;
			if (!OnNewLine(nSize-i-1))
				return nLinesUsed;
		}
	}
	return nLinesUsed;
}

int MPrintf::GuessTermCols()
{
	int nC, nL;
	guess_term_size(&nC, &nL);
	return nC;
}

/////////////////////////////////////////////////////////////////////////////

MPrintfMore::MPrintfMore(int nCPL = -1, int nLPP = -1) : MPrintf(nCPL)
{
	m_nLPP = nLPP;
	m_nLines = 0;
	m_bBreak = true;
}

MPrintfMore::~MPrintfMore()
{
}

int MPrintfMore::PrintBuf(const char * buf, int nSize)
{
	m_sBuffer += CString(buf,nSize);
	return 0;
}

int MPrintfMore::Flush()
{
	int nLines = MPrintf::PrintBuf(m_sBuffer.c_str(), m_sBuffer.length());
	m_sBuffer.clear();
	m_nLines = 0;
	return nLines;
}

void MPrintfMore::Discard()
{
	m_sBuffer.clear();
	m_nLines = 0;
}

bool MPrintfMore::OnNewLine(int nCharsLeft)
{
	++m_nLines;
	if (m_bBreak && m_nLPP>0 && m_nLines >= m_nLPP-1 && nCharsLeft)
	{
		m_nLines = 0;
		printf(ANSI_NORMAL "--more--");
		fflush(stdout);
		char c = read_key();
		printf("\r        \r");
		if (c == 'q' || c == 'Q')
			return false;
	}
	return true;
}

int MPrintfMore::GuessTermLines()
{
	int nC, nL;
	guess_term_size(&nC, &nL);
	return nL;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

