/***************************************************************************
                          mprintf.h  -  description
                             -------------------
    begin                : Wed Oct 31 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef MPRINTF_H
#define MPRINTF_H


class MPrintf {
public: 
	MPrintf(int nCPL = -1);
	virtual ~MPrintf();
	
	//int operator()(LPCSZ szFormat, ...); // synonym for print
	int print(const char * szFormat, ...); //returns number of lines used
	
	int GetCaretPos(){ return m_nCaret;}
	void SetWordwrap(bool bWrap = true){m_bWordwrap = bWrap;}
	void SetTabSize(int nSize){m_nTabSize = nSize;}
	void SetPageWidth(int nCPL){m_nCPL = nCPL;}
	static int GuessTermCols();
protected:	
	virtual bool IsWhite(char c);
	virtual int PrintBuf(const char *, int);
	virtual bool OnNewLine(int nCharsLeft);
	virtual void PrePrint(CString& s){}
protected:
	int m_nCaret;
	int m_nTabSize;
	bool m_bWordwrap;
public:
	int m_nCPL;
};

class MPrintfMore : public MPrintf {
public:
	MPrintfMore(int nCPL = -1, int nLPP = -1);
	virtual ~MPrintfMore();
	void SetPageHeight(int nLPP){m_nLPP = nLPP;}
	int Flush();
	void Discard();
	static int GuessTermLines();
protected:
	virtual int PrintBuf(const char *, int);
	virtual bool OnNewLine(int nCharsLeft);
protected:
	int m_nLines;
	CString m_sBuffer;
public:
	int m_nLPP;
	bool m_bBreak;
};

#endif
