/***************************************************************************
                          preferences.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "controller.h"
#include "gnudirector.h"
#include "gnushare.h"


#include "preferences.h"
#include "property.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MGnuPreferences::MGnuPreferences(MController* pController)
{
	m_pController = pController;
	
	m_pContainer = new MPropertyContainer;

	// Default Settings
	// Local
	m_pContainer->AddSection("LocalHost");
	m_pContainer->AddProperty("LocalIP",     &m_ipLocalHost,  StrtoIP("127.0.0.1"));
	m_pContainer->AddProperty("ForceIP",     &m_ipForcedHost, StrtoIP("0.0.0.0"));
	m_pContainer->AddProperty("LocalPort",   &m_dwLocalPort,    6346);
	m_pContainer->AddProperty("ForcePort",   &m_dwForcedPort,   0);
	m_pContainer->AddProperty("SpeedStatic", &m_dwSpeedStat,    33);
	m_pContainer->AddProperty("SpeedDynamic",&m_dwSpeedDyn,     33);
	// Local Firewall
	m_pContainer->AddProperty("Firewall",         &m_bBehindFirewall,   true); // this flag will be automatically reset on incoming connection
	m_pContainer->AddProperty("ReachableForPush", &m_bReachableForPush, true);

	// Connect
	m_pContainer->AddSection("Connections");
	m_pContainer->AddProperty("QuietMode",         &m_bQuietMode,   false);
	m_pContainer->AddProperty("MinConnections",    &m_nMinConnects, 4);
	m_pContainer->AddProperty("MaxConnections",    &m_nMaxConnects, 10);
	m_pContainer->AddProperty("MaxConnPerSubnetA", &m_nMaxConnPerSubnetA, -1);
	m_pContainer->AddProperty("MaxConnPerSubnetB", &m_nMaxConnPerSubnetB, 4);
	m_pContainer->AddProperty("MaxConnPerSubnetC", &m_nMaxConnPerSubnetC, 2);
	m_pContainer->AddProperty("MinFriends",        &m_nFriendsMin,  5);

	// AutoConnect Servers
	m_pContainer->AddSection("HostServers");
	m_pContainer->AddProperty("AutoConnectSrv1", m_szAutoConnectSrv1, MAX_URL, "public.bearshare.net");
	m_pContainer->AddProperty("AutoConnectSrv2", m_szAutoConnectSrv2, MAX_URL, "router.limewire.com");
	m_pContainer->AddProperty("AutoConnectSrv3", m_szAutoConnectSrv3, MAX_URL, "gnutella.hostscache.com");
	m_pContainer->AddProperty("AutoConnectSrv4", m_szAutoConnectSrv4, MAX_URL, "");

	// Connect Screen
	//m_pContainer->AddProperty("", &m_ScreenedNodes);
	
	// Timeouts
	m_pContainer->AddSection("Timeouts");
	m_pContainer->AddProperty("ConnectTimeout",  &m_dwConnectTimeout,  30);
	m_pContainer->AddProperty("PushTimeout",     &m_dwPushTimeout,     60);
	m_pContainer->AddProperty("SpeedTimeout",    &m_dwSpeedTimeout,    60);
	m_pContainer->AddProperty("TransferTimeout", &m_dwTransferTimeout, 60);
	
	// paths
	m_pContainer->AddSection("Paths");
	m_pContainer->AddProperty("DownloadPath", m_szDownloadPath, MAX_PATH, GetDefaultDir().c_str());
	m_pContainer->AddProperty("SharePath", m_szSharePath, MAX_PATH, ""); //TODO: make it to be a list of directories

	// Search
	m_pContainer->AddSection("SearchOptions");
	m_pContainer->AddProperty("SearchScreenNodes", &m_bSearchScreenNodes, false);
	m_pContainer->AddProperty("StrictSearch",      &m_bStrictSearch,        false);
	m_pContainer->AddProperty("GroupBySize",       &m_bGroupbySize,         true);
	m_pContainer->AddProperty("GroupByName",       &m_bGroupbyName,         true);
	m_pContainer->AddProperty("GroupFuzzy",        &m_bGroupbyFuzzyRules,   true);
	m_pContainer->AddProperty("ScreenBusy",        &m_bScreenBusy,          false);
	m_pContainer->AddProperty("MinFileSize",       &m_nMinFileKSize,        1024); //1M
	m_pContainer->AddProperty("MaxFileSize",       &m_nMaxFileKSize,        2097152); //2G (spam protection)
	m_pContainer->AddProperty("ResubmitTime",      &m_nResubmitSearches,    60); // resubmit all the searches in 60 secs
	m_pContainer->AddProperty("MaxSearches",       &m_nMaxSearches,         64); // performance limitations
	m_pContainer->AddProperty("MaxResults",        &m_nMaxPerSearchResults, 256);// performance limitations
	m_pContainer->AddProperty("SaveSearches",      &m_bSaveSearches,        true);// save/load searches between sessions

	// Search Screen
	//m_pContainer->AddProperty("", &m_ScreenedWords);

	// Share
	m_pContainer->AddSection("ShareOptions");
	m_pContainer->AddProperty("ReplyFilePath", &m_bReplyFilePath, true); // include relative path to the share names
	m_pContainer->AddProperty("MaxReplies",    &m_nMaxReplies,    64);
	m_pContainer->AddProperty("ReplyIfAlail",  &m_bSendOnlyAvail, true); // makes sense if sharing only big files

	// Transfer
	m_pContainer->AddSection("TransferOptions");
	m_pContainer->AddProperty("MaxDownloads",        &m_nMaxDownloads,        20);
	m_pContainer->AddProperty("MaxUploads",          &m_nMaxUploads,          10);
	m_pContainer->AddProperty("RetryDelay",          &m_nRetryWait,           10); // delay between download retries
	m_pContainer->AddProperty("MaxPerHostDownloads", &m_nMaxPerHostDownloads, 2);
	m_pContainer->AddProperty("MaxPerHostUploads",   &m_nMaxPerHostUploads,   2);
	m_pContainer->AddProperty("MinDownloadSpeed",  &m_dMinDownSpeed,      -1); // drop download if it is slower than that
	m_pContainer->AddProperty("MinUploadSpeed",    &m_dMinUpSpeed,        -1); // same about uploads

	// Bandwidth
	m_pContainer->AddSection("Bandwidth");
	m_pContainer->AddProperty("BandwidthTotal",    &m_dBandwidthTotal,    -1); // not really functional
	m_pContainer->AddProperty("BandwidthTransfer", &m_dBandwidthTransfer, 10); // 10 K/sec
	m_pContainer->AddProperty("BandwidthConnects", &m_dBandwidthConnects, -1); // unlimited
	
	m_pContainer->SetCurrentSection(NULL);
}

MGnuPreferences::~MGnuPreferences()
{
	delete m_pContainer;
}

/*void MGnuPreferences::LoadServers(CString ServerFile)
{
	
	// Hostcache Servers
	char buffer[256];
	CString KeyName;

	for(int i = 1; ; i++)
	{
		KeyName.Format("Server%ld", i);

		if(GetPrivateProfileString( "Connect Servers", KeyName, "",	buffer, 256, ServerFile) > 0)
		{
			int     pos;
			CString Host(buffer);

			if( (pos = Host.Find(":", 0)) != -1)
			{
				Node Server;
				Server.Port		  = atoi(Host.Mid(pos + 1, Host.GetLength() - pos));
				Server.Host		  = StrtoIP(Host.Mid(0, pos));
				Server.Ping		  = 0;
				Server.Speed      = 0;
				Server.Distance   = 0;
				Server.ShareCount = 0;
				Server.ShareSize  = 0;
				
				m_HostServers.push_back(Server);
			}
		}
		else
			break;
	}


	// IRC Servers
	GetPrivateProfileString("Chat Servers",	"Preferred Net", "EFnet",	buffer, 256, ServerFile);
	m_PrefNet = buffer;
	GetPrivateProfileString("Chat Servers",	"Preferred Channel", "",	buffer, 256, ServerFile);
	m_PrefChannel = buffer;

	for(i = 1; ; i++)
	{
		KeyName.Format("n%ld", i);

		if(GetPrivateProfileString( "Chat Servers", KeyName, "",	buffer, 256, ServerFile) > 0)
		{
			CString Parse(buffer);

			int pos = Parse.Find(":"),
				endpos = Parse.Find(";");
			

			if(pos != -1)
			{
				CString Network = Parse.Left(pos);

				pos++;
				CString Server  = Parse.Mid(pos, endpos - pos);

				AddServer(Network, Server);
			}
		}
		else
			break;
	}
}

void MGnuPreferences::SaveServers(CString ServerFile)
{
	// Hostcache Servers
	WritePrivateProfileString("Connect Servers", NULL, NULL, ServerFile); 
	
	CString KeyName;
	std::vector<Node>::iterator itNode;
	
	int i;
	for (i = 1, itNode = m_HostServers.begin(); itNode != m_HostServers.end(); i++, itNode++)
	{
		KeyName.Format("Server%ld", i);
		
		CString Insert = IPtoStr((*itNode).Host);
				Insert += ":" + DWrdtoStr((*itNode).Port);
		
		WritePrivateProfileString ("Connect Servers", KeyName, Insert, ServerFile);
	}


	// IRC Servers
	WritePrivateProfileString("Chat Servers",	"Preferred Net",		m_PrefNet,		ServerFile);
	WritePrivateProfileString("Chat Servers",	"Preferred Channel",	m_PrefChannel,	ServerFile);
	
	int Item = 1;
	for (i = 0; i < m_ChatNets.size(); i++)
		for(int j = 0; j < m_ChatNets[i].Servers.size(); j++)
		{
			KeyName.Format("n%ld", Item); 

			CString Line = m_ChatNets[i].Name + ":" + m_ChatNets[i].Servers[j] + ";";

			WritePrivateProfileString ("Chat Servers", KeyName, Line, ServerFile);
		
			Item++;
		}
}*/



CString MGnuPreferences::GetDefaultDir()
{
	/*LPITEMIDLIST lp_itemid_list;
	LPMALLOC lp_sh_malloc;

	SHGetMalloc(&lp_sh_malloc);

	char* default_dir = new char[MAX_PATH];  
	SHGetSpecialFolderLocation(NULL, CSIDL_DESKTOPDIRECTORY, &lp_itemid_list);
	SHGetPathFromIDList(lp_itemid_list, default_dir);
	CString Dir(default_dir);

	lp_sh_malloc->Free(lp_itemid_list);    
	lp_sh_malloc->Release();

	delete [] default_dir;

	return Dir;*/
	// TODO: something more appropriate
	return "~/mutella";
}
