// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GCPnts_UniformAbscissa_HeaderFile
#define _GCPnts_UniformAbscissa_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
class TColStd_HArray1OfReal;
class Standard_DomainError;
class Standard_ConstructionError;
class Standard_OutOfRange;
class StdFail_NotDone;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;


//! This class allows to compute a uniform distribution of points <br>
//!          on a curve (ie the points will all be equally distant). <br>
class GCPnts_UniformAbscissa  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! creation of a indefinite UniformAbscissa <br>
  Standard_EXPORT   GCPnts_UniformAbscissa();
  //! Computes a uniform abscissa distribution of points on <br>
//!  the Curve <C>. Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real Toler = -1);
  //! Computes a Uniform abscissa distribution of points <br>
//!  on a part of the Curve <C>. Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1);
  //! Computes a uniform abscissa distribution of points on <br>
//!  the Curve <C>. <br>
//!  <NbPoints> defines the nomber of desired points. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor3d_Curve& C,const Standard_Integer NbPoints,const Standard_Real Toler = -1);
  //! Computes a Uniform abscissa distribution of points <br>
//!  on a part of the Curve <C>. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor3d_Curve& C,const Standard_Integer NbPoints,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1);
  //! Initialize the algoritms with <C>, <Abscissa>, <Toler> <br>
  Standard_EXPORT     void Initialize(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>, <br>
//!          <U2>, <Toler> <br>
  Standard_EXPORT     void Initialize(Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <NbPoints>, <Toler> and <br>
  Standard_EXPORT     void Initialize(Adaptor3d_Curve& C,const Standard_Integer NbPoints,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>, <br>
//!          <U2>, <Toler>. <br>
  Standard_EXPORT     void Initialize(Adaptor3d_Curve& C,const Standard_Integer NbPoints,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1) ;
  //! Computes a uniform abscissa distribution of points on <br>
//!  the Curve2d <C>. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real Toler = -1);
  //! Computes a Uniform abscissa distribution of points <br>
//!  on a part of the Curve2d <C>. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1);
  //! Computes a uniform abscissa distribution of points on <br>
//!  the Curve2d <C>. <br>
//!  <NbPoints> defines the nomber of desired points. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C,const Standard_Integer NbPoints,const Standard_Real Toler = -1);
  //! Computes a Uniform abscissa distribution of points <br>
//!  on a part of the Curve2d <C>. <br>
//!  Parameter Toler is equal Precision::Confusion by default. <br>
//!  It Is used for more precise calculation of curve length <br>
  Standard_EXPORT   GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C,const Standard_Integer NbPoints,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1);
  //! Initialize the algoritms with <C>, <Abscissa>, <Toler> <br>
  Standard_EXPORT     void Initialize(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>, <br>
//!          <U2>, <Toler> <br>
  Standard_EXPORT     void Initialize(Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <NbPoints>, <Toler> and <br>
  Standard_EXPORT     void Initialize(Adaptor2d_Curve2d& C,const Standard_Integer NbPoints,const Standard_Real Toler = -1) ;
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>, <br>
//!          <U2>, <Toler>. <br>
  Standard_EXPORT     void Initialize(Adaptor2d_Curve2d& C,const Standard_Integer NbPoints,const Standard_Real U1,const Standard_Real U2,const Standard_Real Toler = -1) ;
  
        Standard_Boolean IsDone() const;
  
        Standard_Integer NbPoints() const;
  //! returns the computed Parameter of index <Index>. <br>
        Standard_Real Parameter(const Standard_Integer Index) const;
  //! returne the current abscissa <br>
//! ie the distance between two consecutive points <br>
        Standard_Real Abscissa() const;





protected:





private:



Standard_Boolean myDone;
Standard_Integer myNbPoints;
Standard_Real myAbscissa;
Handle_TColStd_HArray1OfReal myParams;


};


#include <GCPnts_UniformAbscissa.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
