/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef PATCHVIEW_H
#define PATCHVIEW_H

#include <qobject.h>
#include <qguardedptr.h>
#include <qregexp.h>
#include <qvaluevector.h>
#include "patchbase.h" // needed by moc_* file to understand tab() function
#include "domain.h"

class QTextEdit;
class QLineEdit;
class QRadioButton;
class DiffHighlighter;
class Git;
class MyProcess;
class StateInfo;
class Domain;
class DiffHighlighter;
class ListBoxFiles;
class TabPatch;
class RevFile;

class PatchView :public Domain {
Q_OBJECT
public:
	PatchView() {}
	PatchView(MainImpl* mi, Git* g);
	~PatchView();
	void clear(bool complete = true);
	virtual TabPatch* tab() { return patchTab; }

signals:
	void diffTo(const QString&);
	void diffViewerDocked();

public slots:
	void on_lineEditDiff_returnPressed();
	void on_buttonGroupDiff_clicked(int);
	void on_procDataReady(const QString& data);
	void on_eof();
	void on_highlightPatch(const QString&, bool);

protected slots:
	virtual void on_contextMenu(const QString&, int);

protected:
	virtual bool doUpdate();

private:
	friend class DiffHighlighter;

	void updatePatch();
	void centerOnFileHeader(const QString& fileName);
	void centerTarget();
	void saveRestoreSizes(bool startup = false);
	int doSearch(const QString& txt, int pos);
	void computeMatches();
	bool getMatch(int para, int* indexFrom, int* indexTo);
	void centerMatch(uint id = 0);

	TabPatch* patchTab;
	DiffHighlighter* diffHighlighter;
	ListBoxFiles* listBoxFiles;
	QGuardedPtr<MyProcess> proc;
	QString target;
	QString partialParagraphs;
	QString normalizedSha;
	bool seekTarget;
	bool diffLoaded;
	bool isRegExp;
	QRegExp pickAxeRE;

	struct MatchSelection {
		int paraFrom;
		int indexFrom;
		int paraTo;
		int indexTo;
	};
	typedef QValueVector<MatchSelection> Matches;
	Matches matches;
};

#endif
