% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMLBenchObjToTask.R
\name{convertMLBenchObjToTask}
\alias{convertMLBenchObjToTask}
\title{Convert a machine learning benchmark / demo object from package mlbench to a task.}
\usage{
convertMLBenchObjToTask(x, n = 100L, ...)
}
\arguments{
\item{x}{(\code{character(1)})\cr
Name of an mlbench function or dataset.}

\item{n}{(\code{integer(1)})\cr
Number of observations for data simul functions.
Note that for a few mlbench function this setting is not exactly respected by mlbench.
Default is 100.}

\item{...}{(any)\cr
Passed on to data simul functions.}
}
\description{
We auto-set the target column, drop any column which is called \dQuote{Id} and
convert logicals to factors.
}
\examples{
print(convertMLBenchObjToTask("Ionosphere"))
print(convertMLBenchObjToTask("mlbench.spirals", n = 100, sd = 0.1))
}
