use v6.c;
# Normal Form Grapheme .chars tests, generated from NormalizationTests.txt in
# the Unicode database by S15-nfg/test-gen.p6. Check that a string in NFG form
# gets the right number of characters.

use Test;

plan 500;

is Uni.new(0x1E0A, 0x0323).Str.chars, 1, '1E0A 0323';
is Uni.new(0x1E0C, 0x0307).Str.chars, 1, '1E0C 0307';
is Uni.new(0x0044, 0x0307, 0x0323).Str.chars, 1, '0044 0307 0323';
is Uni.new(0x0044, 0x0323, 0x0307).Str.chars, 1, '0044 0323 0307';
is Uni.new(0x1E0A, 0x031B).Str.chars, 1, '1E0A 031B';
is Uni.new(0x1E0C, 0x031B).Str.chars, 1, '1E0C 031B';
is Uni.new(0x1E0A, 0x031B, 0x0323).Str.chars, 1, '1E0A 031B 0323';
is Uni.new(0x1E0C, 0x031B, 0x0307).Str.chars, 1, '1E0C 031B 0307';
is Uni.new(0x0044, 0x031B, 0x0307, 0x0323).Str.chars, 1, '0044 031B 0307 0323';
is Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str.chars, 1, '0044 031B 0323 0307';
is Uni.new(0x1E14, 0x0304).Str.chars, 1, '1E14 0304';
is Uni.new(0x0045, 0x0300, 0x0304).Str.chars, 1, '0045 0300 0304';
is Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).Str.chars, 2, '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F';
is Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).Str.chars, 2, '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD';
is Uni.new(0x0344).Str.chars, 1, '0344';
is Uni.new(0x0958).Str.chars, 1, '0958';
is Uni.new(0x0959).Str.chars, 1, '0959';
is Uni.new(0x095A).Str.chars, 1, '095A';
is Uni.new(0x095B).Str.chars, 1, '095B';
is Uni.new(0x095C).Str.chars, 1, '095C';
is Uni.new(0x095D).Str.chars, 1, '095D';
is Uni.new(0x095E).Str.chars, 1, '095E';
is Uni.new(0x095F).Str.chars, 1, '095F';
is Uni.new(0x09DC).Str.chars, 1, '09DC';
is Uni.new(0x09DD).Str.chars, 1, '09DD';
is Uni.new(0x09DF).Str.chars, 1, '09DF';
is Uni.new(0x0A33).Str.chars, 1, '0A33';
is Uni.new(0x0A36).Str.chars, 1, '0A36';
is Uni.new(0x0A59).Str.chars, 1, '0A59';
is Uni.new(0x0A5A).Str.chars, 1, '0A5A';
is Uni.new(0x0A5B).Str.chars, 1, '0A5B';
is Uni.new(0x0A5E).Str.chars, 1, '0A5E';
is Uni.new(0x0B5C).Str.chars, 1, '0B5C';
is Uni.new(0x0B5D).Str.chars, 1, '0B5D';
is Uni.new(0x0F73).Str.chars, 1, '0F73';
is Uni.new(0x0F75).Str.chars, 1, '0F75';
is Uni.new(0x0F76).Str.chars, 1, '0F76';
is Uni.new(0x0F78).Str.chars, 1, '0F78';
is Uni.new(0x0F81).Str.chars, 1, '0F81';
is Uni.new(0x2ADC).Str.chars, 1, '2ADC';
is Uni.new(0xFB1D).Str.chars, 1, 'FB1D';
is Uni.new(0xFB1F).Str.chars, 1, 'FB1F';
is Uni.new(0xFB2A).Str.chars, 1, 'FB2A';
is Uni.new(0xFB2B).Str.chars, 1, 'FB2B';
is Uni.new(0xFB2C).Str.chars, 1, 'FB2C';
is Uni.new(0xFB2D).Str.chars, 1, 'FB2D';
is Uni.new(0xFB2E).Str.chars, 1, 'FB2E';
is Uni.new(0xFB2F).Str.chars, 1, 'FB2F';
is Uni.new(0xFB30).Str.chars, 1, 'FB30';
is Uni.new(0xFB31).Str.chars, 1, 'FB31';
is Uni.new(0xFB32).Str.chars, 1, 'FB32';
is Uni.new(0xFB33).Str.chars, 1, 'FB33';
is Uni.new(0xFB34).Str.chars, 1, 'FB34';
is Uni.new(0xFB35).Str.chars, 1, 'FB35';
is Uni.new(0xFB36).Str.chars, 1, 'FB36';
is Uni.new(0xFB38).Str.chars, 1, 'FB38';
is Uni.new(0xFB39).Str.chars, 1, 'FB39';
is Uni.new(0xFB3A).Str.chars, 1, 'FB3A';
is Uni.new(0xFB3B).Str.chars, 1, 'FB3B';
is Uni.new(0xFB3C).Str.chars, 1, 'FB3C';
is Uni.new(0xFB3E).Str.chars, 1, 'FB3E';
is Uni.new(0xFB40).Str.chars, 1, 'FB40';
is Uni.new(0xFB41).Str.chars, 1, 'FB41';
is Uni.new(0xFB43).Str.chars, 1, 'FB43';
is Uni.new(0xFB44).Str.chars, 1, 'FB44';
is Uni.new(0xFB46).Str.chars, 1, 'FB46';
is Uni.new(0xFB47).Str.chars, 1, 'FB47';
is Uni.new(0xFB48).Str.chars, 1, 'FB48';
is Uni.new(0xFB49).Str.chars, 1, 'FB49';
is Uni.new(0xFB4A).Str.chars, 1, 'FB4A';
is Uni.new(0xFB4B).Str.chars, 1, 'FB4B';
is Uni.new(0xFB4C).Str.chars, 1, 'FB4C';
is Uni.new(0xFB4D).Str.chars, 1, 'FB4D';
is Uni.new(0xFB4E).Str.chars, 1, 'FB4E';
is Uni.new(0x1D15E).Str.chars, 1, '1D15E';
is Uni.new(0x1D15F).Str.chars, 1, '1D15F';
is Uni.new(0x1D160).Str.chars, 1, '1D160';
is Uni.new(0x1D161).Str.chars, 1, '1D161';
is Uni.new(0x1D162).Str.chars, 1, '1D162';
is Uni.new(0x1D163).Str.chars, 1, '1D163';
is Uni.new(0x1D164).Str.chars, 1, '1D164';
is Uni.new(0x1D1BB).Str.chars, 1, '1D1BB';
is Uni.new(0x1D1BC).Str.chars, 1, '1D1BC';
is Uni.new(0x1D1BD).Str.chars, 1, '1D1BD';
is Uni.new(0x1D1BE).Str.chars, 1, '1D1BE';
is Uni.new(0x1D1BF).Str.chars, 1, '1D1BF';
is Uni.new(0x1D1C0).Str.chars, 1, '1D1C0';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0300, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0300 0062';
is Uni.new(0x0061, 0x0300, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0300 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0301, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0301 0062';
is Uni.new(0x0061, 0x0301, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0301 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0302, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0302 0062';
is Uni.new(0x0061, 0x0302, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0302 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0303, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0303 0062';
is Uni.new(0x0061, 0x0303, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0303 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0304, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0304 0062';
is Uni.new(0x0061, 0x0304, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0304 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0305, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0305 0062';
is Uni.new(0x0061, 0x0305, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0305 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0306, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0306 0062';
is Uni.new(0x0061, 0x0306, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0306 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0307, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0307 0062';
is Uni.new(0x0061, 0x0307, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0307 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0308, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0308 0062';
is Uni.new(0x0061, 0x0308, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0308 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0309, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0309 0062';
is Uni.new(0x0061, 0x0309, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0309 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030A, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030A 0062';
is Uni.new(0x0061, 0x030A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030A 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030B, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030B 0062';
is Uni.new(0x0061, 0x030B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030B 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030C, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030C 0062';
is Uni.new(0x0061, 0x030C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030C 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030D, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030D 0062';
is Uni.new(0x0061, 0x030D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030D 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030E, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030E 0062';
is Uni.new(0x0061, 0x030E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030E 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030F, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 030F 0062';
is Uni.new(0x0061, 0x030F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 030F 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0310, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0310 0062';
is Uni.new(0x0061, 0x0310, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0310 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0311, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0311 0062';
is Uni.new(0x0061, 0x0311, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0311 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0312, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0312 0062';
is Uni.new(0x0061, 0x0312, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0312 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0313, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0313 0062';
is Uni.new(0x0061, 0x0313, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0313 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0314, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0314 0062';
is Uni.new(0x0061, 0x0314, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0314 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x0315, 0x0062).Str.chars, 2, '0061 035C 0315 0300 0315 0062';
is Uni.new(0x0061, 0x0315, 0x035C, 0x0315, 0x0300, 0x0062).Str.chars, 2, '0061 0315 035C 0315 0300 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0316, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0316 0062';
is Uni.new(0x0061, 0x0316, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0316 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0317, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0317 0062';
is Uni.new(0x0061, 0x0317, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0317 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0318, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0318 0062';
is Uni.new(0x0061, 0x0318, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0318 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0319, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0319 0062';
is Uni.new(0x0061, 0x0319, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0319 059A 0316 302A 0062';
is Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x031A, 0x0062).Str.chars, 2, '0061 035C 0315 0300 031A 0062';
is Uni.new(0x0061, 0x031A, 0x035C, 0x0315, 0x0300, 0x0062).Str.chars, 2, '0061 031A 035C 0315 0300 0062';
is Uni.new(0x0061, 0x302A, 0x031B, 0x1DCE, 0x031B, 0x0062).Str.chars, 2, '0061 302A 031B 1DCE 031B 0062';
is Uni.new(0x0061, 0x031B, 0x302A, 0x031B, 0x1DCE, 0x0062).Str.chars, 2, '0061 031B 302A 031B 1DCE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031C, 0x0062).Str.chars, 2, '0061 059A 0316 302A 031C 0062';
is Uni.new(0x0061, 0x031C, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 031C 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031D, 0x0062).Str.chars, 2, '0061 059A 0316 302A 031D 0062';
is Uni.new(0x0061, 0x031D, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 031D 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031E, 0x0062).Str.chars, 2, '0061 059A 0316 302A 031E 0062';
is Uni.new(0x0061, 0x031E, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 031E 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031F, 0x0062).Str.chars, 2, '0061 059A 0316 302A 031F 0062';
is Uni.new(0x0061, 0x031F, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 031F 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0320, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0320 0062';
is Uni.new(0x0061, 0x0320, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0320 059A 0316 302A 0062';
is Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0321, 0x0062).Str.chars, 2, '0061 1DCE 0321 0F74 0321 0062';
is Uni.new(0x0061, 0x0321, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.chars, 2, '0061 0321 1DCE 0321 0F74 0062';
is Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0322, 0x0062).Str.chars, 2, '0061 1DCE 0321 0F74 0322 0062';
is Uni.new(0x0061, 0x0322, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.chars, 2, '0061 0322 1DCE 0321 0F74 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0323, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0323 0062';
is Uni.new(0x0061, 0x0323, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0323 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0324, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0324 0062';
is Uni.new(0x0061, 0x0324, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0324 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0325, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0325 0062';
is Uni.new(0x0061, 0x0325, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0325 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0326, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0326 0062';
is Uni.new(0x0061, 0x0326, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0326 059A 0316 302A 0062';
is Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0327, 0x0062).Str.chars, 2, '0061 1DCE 0321 0F74 0327 0062';
is Uni.new(0x0061, 0x0327, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.chars, 2, '0061 0327 1DCE 0321 0F74 0062';
is Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0328, 0x0062).Str.chars, 2, '0061 1DCE 0321 0F74 0328 0062';
is Uni.new(0x0061, 0x0328, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.chars, 2, '0061 0328 1DCE 0321 0F74 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0329, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0329 0062';
is Uni.new(0x0061, 0x0329, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0329 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032A, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032A 0062';
is Uni.new(0x0061, 0x032A, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032A 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032B, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032B 0062';
is Uni.new(0x0061, 0x032B, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032B 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032C, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032C 0062';
is Uni.new(0x0061, 0x032C, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032C 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032D, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032D 0062';
is Uni.new(0x0061, 0x032D, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032D 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032E, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032E 0062';
is Uni.new(0x0061, 0x032E, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032E 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032F, 0x0062).Str.chars, 2, '0061 059A 0316 302A 032F 0062';
is Uni.new(0x0061, 0x032F, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 032F 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0330, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0330 0062';
is Uni.new(0x0061, 0x0330, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0330 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0331, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0331 0062';
is Uni.new(0x0061, 0x0331, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0331 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0332, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0332 0062';
is Uni.new(0x0061, 0x0332, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0332 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0333, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0333 0062';
is Uni.new(0x0061, 0x0333, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0333 059A 0316 302A 0062';
is Uni.new(0x0061, 0x093C, 0x0334, 0x0334, 0x0062).Str.chars, 2, '0061 093C 0334 0334 0062';
is Uni.new(0x0061, 0x0334, 0x093C, 0x0334, 0x0062).Str.chars, 2, '0061 0334 093C 0334 0062';
is Uni.new(0x0061, 0x093C, 0x0334, 0x0335, 0x0062).Str.chars, 2, '0061 093C 0334 0335 0062';
is Uni.new(0x0061, 0x0335, 0x093C, 0x0334, 0x0062).Str.chars, 2, '0061 0335 093C 0334 0062';
is Uni.new(0x0061, 0x093C, 0x0334, 0x0336, 0x0062).Str.chars, 2, '0061 093C 0334 0336 0062';
is Uni.new(0x0061, 0x0336, 0x093C, 0x0334, 0x0062).Str.chars, 2, '0061 0336 093C 0334 0062';
is Uni.new(0x0061, 0x093C, 0x0334, 0x0337, 0x0062).Str.chars, 2, '0061 093C 0334 0337 0062';
is Uni.new(0x0061, 0x0337, 0x093C, 0x0334, 0x0062).Str.chars, 2, '0061 0337 093C 0334 0062';
is Uni.new(0x0061, 0x093C, 0x0334, 0x0338, 0x0062).Str.chars, 2, '0061 093C 0334 0338 0062';
is Uni.new(0x0061, 0x0338, 0x093C, 0x0334, 0x0062).Str.chars, 2, '0061 0338 093C 0334 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0339, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0339 0062';
is Uni.new(0x0061, 0x0339, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0339 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033A, 0x0062).Str.chars, 2, '0061 059A 0316 302A 033A 0062';
is Uni.new(0x0061, 0x033A, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 033A 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033B, 0x0062).Str.chars, 2, '0061 059A 0316 302A 033B 0062';
is Uni.new(0x0061, 0x033B, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 033B 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033C, 0x0062).Str.chars, 2, '0061 059A 0316 302A 033C 0062';
is Uni.new(0x0061, 0x033C, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 033C 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033D, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 033D 0062';
is Uni.new(0x0061, 0x033D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 033D 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033E, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 033E 0062';
is Uni.new(0x0061, 0x033E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 033E 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033F, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 033F 0062';
is Uni.new(0x0061, 0x033F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 033F 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0340, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0340 0062';
is Uni.new(0x0061, 0x0340, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0340 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0341, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0341 0062';
is Uni.new(0x0061, 0x0341, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0341 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0342, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0342 0062';
is Uni.new(0x0061, 0x0342, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0342 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0343, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0343 0062';
is Uni.new(0x0061, 0x0343, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0343 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0344, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0344 0062';
is Uni.new(0x0061, 0x0344, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0344 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0345, 0x035D, 0x0345, 0x0062).Str.chars, 2, '0061 0345 035D 0345 0062';
is Uni.new(0x0061, 0x0345, 0x0345, 0x035D, 0x0062).Str.chars, 2, '0061 0345 0345 035D 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0346, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0346 0062';
is Uni.new(0x0061, 0x0346, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0346 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0347, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0347 0062';
is Uni.new(0x0061, 0x0347, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0347 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0348, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0348 0062';
is Uni.new(0x0061, 0x0348, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0348 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0349, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0349 0062';
is Uni.new(0x0061, 0x0349, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0349 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034A, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 034A 0062';
is Uni.new(0x0061, 0x034A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 034A 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034B, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 034B 0062';
is Uni.new(0x0061, 0x034B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 034B 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034C, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 034C 0062';
is Uni.new(0x0061, 0x034C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 034C 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x034D, 0x0062).Str.chars, 2, '0061 059A 0316 302A 034D 0062';
is Uni.new(0x0061, 0x034D, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 034D 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x034E, 0x0062).Str.chars, 2, '0061 059A 0316 302A 034E 0062';
is Uni.new(0x0061, 0x034E, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 034E 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0350, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0350 0062';
is Uni.new(0x0061, 0x0350, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0350 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0351, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0351 0062';
is Uni.new(0x0061, 0x0351, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0351 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0352, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0352 0062';
is Uni.new(0x0061, 0x0352, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0352 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0353, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0353 0062';
is Uni.new(0x0061, 0x0353, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0353 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0354, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0354 0062';
is Uni.new(0x0061, 0x0354, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0354 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0355, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0355 0062';
is Uni.new(0x0061, 0x0355, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0355 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0356, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0356 0062';
is Uni.new(0x0061, 0x0356, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0356 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0357, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0357 0062';
is Uni.new(0x0061, 0x0357, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0357 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x0358, 0x0062).Str.chars, 2, '0061 035C 0315 0300 0358 0062';
is Uni.new(0x0061, 0x0358, 0x035C, 0x0315, 0x0300, 0x0062).Str.chars, 2, '0061 0358 035C 0315 0300 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0359, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0359 0062';
is Uni.new(0x0061, 0x0359, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0359 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x035A, 0x0062).Str.chars, 2, '0061 059A 0316 302A 035A 0062';
is Uni.new(0x0061, 0x035A, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 035A 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x035B, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 035B 0062';
is Uni.new(0x0061, 0x035B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 035B 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x035C, 0x0062).Str.chars, 2, '0061 035D 035C 0315 035C 0062';
is Uni.new(0x0061, 0x035C, 0x035D, 0x035C, 0x0315, 0x0062).Str.chars, 2, '0061 035C 035D 035C 0315 0062';
is Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x035D, 0x0062).Str.chars, 2, '0061 0345 035D 035C 035D 0062';
is Uni.new(0x0061, 0x035D, 0x0345, 0x035D, 0x035C, 0x0062).Str.chars, 2, '0061 035D 0345 035D 035C 0062';
is Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x035E, 0x0062).Str.chars, 2, '0061 0345 035D 035C 035E 0062';
is Uni.new(0x0061, 0x035E, 0x0345, 0x035D, 0x035C, 0x0062).Str.chars, 2, '0061 035E 0345 035D 035C 0062';
is Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x035F, 0x0062).Str.chars, 2, '0061 035D 035C 0315 035F 0062';
is Uni.new(0x0061, 0x035F, 0x035D, 0x035C, 0x0315, 0x0062).Str.chars, 2, '0061 035F 035D 035C 0315 0062';
is Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x0360, 0x0062).Str.chars, 2, '0061 0345 035D 035C 0360 0062';
is Uni.new(0x0061, 0x0360, 0x0345, 0x035D, 0x035C, 0x0062).Str.chars, 2, '0061 0360 0345 035D 035C 0062';
is Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x0361, 0x0062).Str.chars, 2, '0061 0345 035D 035C 0361 0062';
is Uni.new(0x0061, 0x0361, 0x0345, 0x035D, 0x035C, 0x0062).Str.chars, 2, '0061 0361 0345 035D 035C 0062';
is Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x0362, 0x0062).Str.chars, 2, '0061 035D 035C 0315 0362 0062';
is Uni.new(0x0061, 0x0362, 0x035D, 0x035C, 0x0315, 0x0062).Str.chars, 2, '0061 0362 035D 035C 0315 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0363, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0363 0062';
is Uni.new(0x0061, 0x0363, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0363 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0364, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0364 0062';
is Uni.new(0x0061, 0x0364, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0364 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0365, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0365 0062';
is Uni.new(0x0061, 0x0365, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0365 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0366, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0366 0062';
is Uni.new(0x0061, 0x0366, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0366 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0367, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0367 0062';
is Uni.new(0x0061, 0x0367, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0367 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0368, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0368 0062';
is Uni.new(0x0061, 0x0368, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0368 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0369, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0369 0062';
is Uni.new(0x0061, 0x0369, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0369 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036A, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036A 0062';
is Uni.new(0x0061, 0x036A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036A 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036B, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036B 0062';
is Uni.new(0x0061, 0x036B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036B 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036C, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036C 0062';
is Uni.new(0x0061, 0x036C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036C 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036D, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036D 0062';
is Uni.new(0x0061, 0x036D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036D 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036E, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036E 0062';
is Uni.new(0x0061, 0x036E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036E 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036F, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 036F 0062';
is Uni.new(0x0061, 0x036F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 036F 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0483, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0483 0062';
is Uni.new(0x0061, 0x0483, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0483 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0484, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0484 0062';
is Uni.new(0x0061, 0x0484, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0484 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0485, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0485 0062';
is Uni.new(0x0061, 0x0485, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0485 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0486, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0486 0062';
is Uni.new(0x0061, 0x0486, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0486 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0487, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0487 0062';
is Uni.new(0x0061, 0x0487, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0487 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0591, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0591 0062';
is Uni.new(0x0061, 0x0591, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0591 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0592, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0592 0062';
is Uni.new(0x0061, 0x0592, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0592 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0593, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0593 0062';
is Uni.new(0x0061, 0x0593, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0593 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0594, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0594 0062';
is Uni.new(0x0061, 0x0594, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0594 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0595, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0595 0062';
is Uni.new(0x0061, 0x0595, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0595 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0596, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0596 0062';
is Uni.new(0x0061, 0x0596, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0596 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0597, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0597 0062';
is Uni.new(0x0061, 0x0597, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0597 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0598, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0598 0062';
is Uni.new(0x0061, 0x0598, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0598 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0599, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0599 0062';
is Uni.new(0x0061, 0x0599, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0599 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x302E, 0x059A, 0x0316, 0x059A, 0x0062).Str.chars, 2, '0061 302E 059A 0316 059A 0062';
is Uni.new(0x0061, 0x059A, 0x302E, 0x059A, 0x0316, 0x0062).Str.chars, 2, '0061 059A 302E 059A 0316 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x059B, 0x0062).Str.chars, 2, '0061 059A 0316 302A 059B 0062';
is Uni.new(0x0061, 0x059B, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 059B 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059C, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 059C 0062';
is Uni.new(0x0061, 0x059C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 059C 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059D, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 059D 0062';
is Uni.new(0x0061, 0x059D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 059D 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059E, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 059E 0062';
is Uni.new(0x0061, 0x059E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 059E 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059F, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 059F 0062';
is Uni.new(0x0061, 0x059F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 059F 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A0, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05A0 0062';
is Uni.new(0x0061, 0x05A0, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05A0 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A1, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05A1 0062';
is Uni.new(0x0061, 0x05A1, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05A1 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A2, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A2 0062';
is Uni.new(0x0061, 0x05A2, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A2 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A3, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A3 0062';
is Uni.new(0x0061, 0x05A3, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A3 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A4, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A4 0062';
is Uni.new(0x0061, 0x05A4, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A4 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A5, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A5 0062';
is Uni.new(0x0061, 0x05A5, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A5 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A6, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A6 0062';
is Uni.new(0x0061, 0x05A6, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A6 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A7, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05A7 0062';
is Uni.new(0x0061, 0x05A7, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05A7 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A8, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05A8 0062';
is Uni.new(0x0061, 0x05A8, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05A8 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A9, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05A9 0062';
is Uni.new(0x0061, 0x05A9, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05A9 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05AA, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05AA 0062';
is Uni.new(0x0061, 0x05AA, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05AA 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AB, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05AB 0062';
is Uni.new(0x0061, 0x05AB, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05AB 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AC, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05AC 0062';
is Uni.new(0x0061, 0x05AC, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05AC 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x302E, 0x059A, 0x0316, 0x05AD, 0x0062).Str.chars, 2, '0061 302E 059A 0316 05AD 0062';
is Uni.new(0x0061, 0x05AD, 0x302E, 0x059A, 0x0316, 0x0062).Str.chars, 2, '0061 05AD 302E 059A 0316 0062';
is Uni.new(0x0061, 0x0300, 0x05AE, 0x1D16D, 0x05AE, 0x0062).Str.chars, 2, '0061 0300 05AE 1D16D 05AE 0062';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05AE, 0x1D16D, 0x0062).Str.chars, 2, '0061 05AE 0300 05AE 1D16D 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AF, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05AF 0062';
is Uni.new(0x0061, 0x05AF, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05AF 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x05B1, 0x05B0, 0x094D, 0x05B0, 0x0062).Str.chars, 2, '0061 05B1 05B0 094D 05B0 0062';
is Uni.new(0x0061, 0x05B0, 0x05B1, 0x05B0, 0x094D, 0x0062).Str.chars, 2, '0061 05B0 05B1 05B0 094D 0062';
is Uni.new(0x0061, 0x05B2, 0x05B1, 0x05B0, 0x05B1, 0x0062).Str.chars, 2, '0061 05B2 05B1 05B0 05B1 0062';
is Uni.new(0x0061, 0x05B1, 0x05B2, 0x05B1, 0x05B0, 0x0062).Str.chars, 2, '0061 05B1 05B2 05B1 05B0 0062';
is Uni.new(0x0061, 0x05B3, 0x05B2, 0x05B1, 0x05B2, 0x0062).Str.chars, 2, '0061 05B3 05B2 05B1 05B2 0062';
is Uni.new(0x0061, 0x05B2, 0x05B3, 0x05B2, 0x05B1, 0x0062).Str.chars, 2, '0061 05B2 05B3 05B2 05B1 0062';
is Uni.new(0x0061, 0x05B4, 0x05B3, 0x05B2, 0x05B3, 0x0062).Str.chars, 2, '0061 05B4 05B3 05B2 05B3 0062';
is Uni.new(0x0061, 0x05B3, 0x05B4, 0x05B3, 0x05B2, 0x0062).Str.chars, 2, '0061 05B3 05B4 05B3 05B2 0062';
is Uni.new(0x0061, 0x05B5, 0x05B4, 0x05B3, 0x05B4, 0x0062).Str.chars, 2, '0061 05B5 05B4 05B3 05B4 0062';
is Uni.new(0x0061, 0x05B4, 0x05B5, 0x05B4, 0x05B3, 0x0062).Str.chars, 2, '0061 05B4 05B5 05B4 05B3 0062';
is Uni.new(0x0061, 0x05B6, 0x05B5, 0x05B4, 0x05B5, 0x0062).Str.chars, 2, '0061 05B6 05B5 05B4 05B5 0062';
is Uni.new(0x0061, 0x05B5, 0x05B6, 0x05B5, 0x05B4, 0x0062).Str.chars, 2, '0061 05B5 05B6 05B5 05B4 0062';
is Uni.new(0x0061, 0x05B7, 0x05B6, 0x05B5, 0x05B6, 0x0062).Str.chars, 2, '0061 05B7 05B6 05B5 05B6 0062';
is Uni.new(0x0061, 0x05B6, 0x05B7, 0x05B6, 0x05B5, 0x0062).Str.chars, 2, '0061 05B6 05B7 05B6 05B5 0062';
is Uni.new(0x0061, 0x05B8, 0x05B7, 0x05B6, 0x05B7, 0x0062).Str.chars, 2, '0061 05B8 05B7 05B6 05B7 0062';
is Uni.new(0x0061, 0x05B7, 0x05B8, 0x05B7, 0x05B6, 0x0062).Str.chars, 2, '0061 05B7 05B8 05B7 05B6 0062';
is Uni.new(0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05B8, 0x0062).Str.chars, 2, '0061 05B9 05B8 05B7 05B8 0062';
is Uni.new(0x0061, 0x05B8, 0x05B9, 0x05B8, 0x05B7, 0x0062).Str.chars, 2, '0061 05B8 05B9 05B8 05B7 0062';
is Uni.new(0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05B9, 0x0062).Str.chars, 2, '0061 05BB 05B9 05B8 05B9 0062';
is Uni.new(0x0061, 0x05B9, 0x05BB, 0x05B9, 0x05B8, 0x0062).Str.chars, 2, '0061 05B9 05BB 05B9 05B8 0062';
is Uni.new(0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05BA, 0x0062).Str.chars, 2, '0061 05BB 05B9 05B8 05BA 0062';
is Uni.new(0x0061, 0x05BA, 0x05BB, 0x05B9, 0x05B8, 0x0062).Str.chars, 2, '0061 05BA 05BB 05B9 05B8 0062';
is Uni.new(0x0061, 0x05BC, 0x05BB, 0x05B9, 0x05BB, 0x0062).Str.chars, 2, '0061 05BC 05BB 05B9 05BB 0062';
is Uni.new(0x0061, 0x05BB, 0x05BC, 0x05BB, 0x05B9, 0x0062).Str.chars, 2, '0061 05BB 05BC 05BB 05B9 0062';
is Uni.new(0x0061, 0x05BD, 0x05BC, 0x05BB, 0x05BC, 0x0062).Str.chars, 2, '0061 05BD 05BC 05BB 05BC 0062';
is Uni.new(0x0061, 0x05BC, 0x05BD, 0x05BC, 0x05BB, 0x0062).Str.chars, 2, '0061 05BC 05BD 05BC 05BB 0062';
is Uni.new(0x0061, 0x05BF, 0x05BD, 0x05BC, 0x05BD, 0x0062).Str.chars, 2, '0061 05BF 05BD 05BC 05BD 0062';
is Uni.new(0x0061, 0x05BD, 0x05BF, 0x05BD, 0x05BC, 0x0062).Str.chars, 2, '0061 05BD 05BF 05BD 05BC 0062';
is Uni.new(0x0061, 0x05C1, 0x05BF, 0x05BD, 0x05BF, 0x0062).Str.chars, 2, '0061 05C1 05BF 05BD 05BF 0062';
is Uni.new(0x0061, 0x05BF, 0x05C1, 0x05BF, 0x05BD, 0x0062).Str.chars, 2, '0061 05BF 05C1 05BF 05BD 0062';
is Uni.new(0x0061, 0x05C2, 0x05C1, 0x05BF, 0x05C1, 0x0062).Str.chars, 2, '0061 05C2 05C1 05BF 05C1 0062';
is Uni.new(0x0061, 0x05C1, 0x05C2, 0x05C1, 0x05BF, 0x0062).Str.chars, 2, '0061 05C1 05C2 05C1 05BF 0062';
is Uni.new(0x0061, 0xFB1E, 0x05C2, 0x05C1, 0x05C2, 0x0062).Str.chars, 2, '0061 FB1E 05C2 05C1 05C2 0062';
is Uni.new(0x0061, 0x05C2, 0xFB1E, 0x05C2, 0x05C1, 0x0062).Str.chars, 2, '0061 05C2 FB1E 05C2 05C1 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05C4, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 05C4 0062';
is Uni.new(0x0061, 0x05C4, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 05C4 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05C5, 0x0062).Str.chars, 2, '0061 059A 0316 302A 05C5 0062';
is Uni.new(0x0061, 0x05C5, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 05C5 059A 0316 302A 0062';
is Uni.new(0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05C7, 0x0062).Str.chars, 2, '0061 05B9 05B8 05B7 05C7 0062';
is Uni.new(0x0061, 0x05C7, 0x05B9, 0x05B8, 0x05B7, 0x0062).Str.chars, 2, '0061 05C7 05B9 05B8 05B7 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0610, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0610 0062';
is Uni.new(0x0061, 0x0610, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0610 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0611, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0611 0062';
is Uni.new(0x0061, 0x0611, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0611 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0612, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0612 0062';
is Uni.new(0x0061, 0x0612, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0612 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0613, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0613 0062';
is Uni.new(0x0061, 0x0613, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0613 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0614, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0614 0062';
is Uni.new(0x0061, 0x0614, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0614 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0615, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0615 0062';
is Uni.new(0x0061, 0x0615, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0615 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0616, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0616 0062';
is Uni.new(0x0061, 0x0616, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0616 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0617, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0617 0062';
is Uni.new(0x0061, 0x0617, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0617 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0619, 0x0618, 0x064D, 0x0618, 0x0062).Str.chars, 2, '0061 0619 0618 064D 0618 0062';
is Uni.new(0x0061, 0x0618, 0x0619, 0x0618, 0x064D, 0x0062).Str.chars, 2, '0061 0618 0619 0618 064D 0062';
is Uni.new(0x0061, 0x061A, 0x0619, 0x0618, 0x0619, 0x0062).Str.chars, 2, '0061 061A 0619 0618 0619 0062';
is Uni.new(0x0061, 0x0619, 0x061A, 0x0619, 0x0618, 0x0062).Str.chars, 2, '0061 0619 061A 0619 0618 0062';
is Uni.new(0x0061, 0x0651, 0x061A, 0x0619, 0x061A, 0x0062).Str.chars, 2, '0061 0651 061A 0619 061A 0062';
is Uni.new(0x0061, 0x061A, 0x0651, 0x061A, 0x0619, 0x0062).Str.chars, 2, '0061 061A 0651 061A 0619 0062';
is Uni.new(0x0061, 0x064C, 0x064B, 0xFB1E, 0x064B, 0x0062).Str.chars, 2, '0061 064C 064B FB1E 064B 0062';
is Uni.new(0x0061, 0x064B, 0x064C, 0x064B, 0xFB1E, 0x0062).Str.chars, 2, '0061 064B 064C 064B FB1E 0062';
is Uni.new(0x0061, 0x064D, 0x064C, 0x064B, 0x064C, 0x0062).Str.chars, 2, '0061 064D 064C 064B 064C 0062';
is Uni.new(0x0061, 0x064C, 0x064D, 0x064C, 0x064B, 0x0062).Str.chars, 2, '0061 064C 064D 064C 064B 0062';
is Uni.new(0x0061, 0x0618, 0x064D, 0x064C, 0x064D, 0x0062).Str.chars, 2, '0061 0618 064D 064C 064D 0062';
is Uni.new(0x0061, 0x064D, 0x0618, 0x064D, 0x064C, 0x0062).Str.chars, 2, '0061 064D 0618 064D 064C 0062';
is Uni.new(0x0061, 0x0619, 0x0618, 0x064D, 0x064E, 0x0062).Str.chars, 2, '0061 0619 0618 064D 064E 0062';
is Uni.new(0x0061, 0x064E, 0x0619, 0x0618, 0x064D, 0x0062).Str.chars, 2, '0061 064E 0619 0618 064D 0062';
is Uni.new(0x0061, 0x061A, 0x0619, 0x0618, 0x064F, 0x0062).Str.chars, 2, '0061 061A 0619 0618 064F 0062';
is Uni.new(0x0061, 0x064F, 0x061A, 0x0619, 0x0618, 0x0062).Str.chars, 2, '0061 064F 061A 0619 0618 0062';
is Uni.new(0x0061, 0x0651, 0x061A, 0x0619, 0x0650, 0x0062).Str.chars, 2, '0061 0651 061A 0619 0650 0062';
is Uni.new(0x0061, 0x0650, 0x0651, 0x061A, 0x0619, 0x0062).Str.chars, 2, '0061 0650 0651 061A 0619 0062';
is Uni.new(0x0061, 0x0652, 0x0651, 0x061A, 0x0651, 0x0062).Str.chars, 2, '0061 0652 0651 061A 0651 0062';
is Uni.new(0x0061, 0x0651, 0x0652, 0x0651, 0x061A, 0x0062).Str.chars, 2, '0061 0651 0652 0651 061A 0062';
is Uni.new(0x0061, 0x0670, 0x0652, 0x0651, 0x0652, 0x0062).Str.chars, 2, '0061 0670 0652 0651 0652 0062';
is Uni.new(0x0061, 0x0652, 0x0670, 0x0652, 0x0651, 0x0062).Str.chars, 2, '0061 0652 0670 0652 0651 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0653, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0653 0062';
is Uni.new(0x0061, 0x0653, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0653 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0654, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0654 0062';
is Uni.new(0x0061, 0x0654, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0654 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0655, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0655 0062';
is Uni.new(0x0061, 0x0655, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0655 059A 0316 302A 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0656, 0x0062).Str.chars, 2, '0061 059A 0316 302A 0656 0062';
is Uni.new(0x0061, 0x0656, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 0656 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0657, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0657 0062';
is Uni.new(0x0061, 0x0657, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0657 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0658, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0658 0062';
is Uni.new(0x0061, 0x0658, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0658 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0659, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 0659 0062';
is Uni.new(0x0061, 0x0659, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 0659 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065A, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 065A 0062';
is Uni.new(0x0061, 0x065A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 065A 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065B, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 065B 0062';
is Uni.new(0x0061, 0x065B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 065B 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x065C, 0x0062).Str.chars, 2, '0061 059A 0316 302A 065C 0062';
is Uni.new(0x0061, 0x065C, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 065C 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065D, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 065D 0062';
is Uni.new(0x0061, 0x065D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 065D 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065E, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 065E 0062';
is Uni.new(0x0061, 0x065E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 065E 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x065F, 0x0062).Str.chars, 2, '0061 059A 0316 302A 065F 0062';
is Uni.new(0x0061, 0x065F, 0x059A, 0x0316, 0x302A, 0x0062).Str.chars, 2, '0061 065F 059A 0316 302A 0062';
is Uni.new(0x0061, 0x0711, 0x0670, 0x0652, 0x0670, 0x0062).Str.chars, 2, '0061 0711 0670 0652 0670 0062';
is Uni.new(0x0061, 0x0670, 0x0711, 0x0670, 0x0652, 0x0062).Str.chars, 2, '0061 0670 0711 0670 0652 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D6, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06D6 0062';
is Uni.new(0x0061, 0x06D6, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06D6 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D7, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06D7 0062';
is Uni.new(0x0061, 0x06D7, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06D7 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D8, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06D8 0062';
is Uni.new(0x0061, 0x06D8, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06D8 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D9, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06D9 0062';
is Uni.new(0x0061, 0x06D9, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06D9 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DA, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06DA 0062';
is Uni.new(0x0061, 0x06DA, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06DA 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DB, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06DB 0062';
is Uni.new(0x0061, 0x06DB, 0x0315, 0x0300, 0x05AE, 0x0062).Str.chars, 2, '0061 06DB 0315 0300 05AE 0062';
is Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DC, 0x0062).Str.chars, 2, '0061 0315 0300 05AE 06DC 0062';
