/* tab-utils.h - Utility functions dealing with strings and tabs.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __TAB_UTILS_H__
#define __TAB_UTILS_H__

#include <stdio.h>

void tab_to(FILE *out, int from, int to, int tabsize);
size_t tab_len(const char *string, int tabsize);
char tab_char_at(const char *string, int pos, int tabsize);
int tab_index(const char *string, int pos, int tabsize);

extern inline char
tab_char_at(const char *string, int pos, int tabsize)
{
	return string[tab_index(string, pos, tabsize)];
}

#endif
