struct sensor {
	gchar *displayName;
        gchar *chipName;
        gchar *sensorName;
        gint sensorNum;
        struct sensors_chip_name nameStruct;
        gdouble value;
};

struct addModifySensorInfo {
	GtkWidget *displayName;
	GtkWidget *chipName;
	GtkWidget *sensorName;
	GtkWidget *clist;
	GtkWidget *window;
	GtkWidget *propertiesBox;
	gint position;
	GList **startList;
};

struct deleteSensorInfo {
	GtkWidget *clist;
	GtkWidget *propertiesBox;
	struct tempAppletInfo *tai;
};

struct drawAddSensorInfo {
	GtkWidget *clist;
	GtkWidget *propertiesBox;
	/*GList *list;*/
	GList **startList;
};

struct propDisplayInfo {
	struct appletInfo *ai;
	GtkWidget *propertiesBox;
	struct tempAppletInfo *tai;
};

struct appletInfo {
	/* GtkWidget's we need access to */
        GtkWidget *applet;
	GtkWidget *eventbox;
        GtkWidget *frame;
        GtkWidget *align;
        GtkWidget *vbox;
	GtkWidget *sensorsCList;
	GtkTooltips *tooltip;

	/* Label for the display */
	GtkWidget *label;

	/* Used to keep track of where we are in the senors list */
	gint displayPos;

	/* list of sensors that we are monitoring */
	GList *sensorList;

	/* Current Panel - Orientation and Size*/
	PanelOrientType orient;
	int panelSize;

	/* Applet display settings */
	gint height;
	gint width;
	gint sensorFreq;
	gint displayFreq;

	/* Tags for the gtk_timeout functions that update the sensors and GUI */
	gint sensorsTimeoutTag;
	gint GUITimeoutTag;

};

struct tempAppletInfo {
	/* Holds variables before they are commited in the Properties */
	gint height;
	gint width;
	gint sensorFreq;
	gint displayFreq;
	gint listModified; /* 0 if not 1 if modified */
	GList *temp; /* Grr... This is horrible */

	GList **sensorList;
};

struct makeChangesInfo {
	/* Structure with pointers to the 2 main structs */
	/* used by the makeChanges function that applys config changes */
	struct appletInfo *ai;
	struct tempAppletInfo *tai;
};

struct cancelConfigInfo {
	struct tempAppletInfo *tai;
	struct makeChangesInfo *minfo;
	struct deleteSensorInfo *deleteInfo;
	struct drawAddSensorInfo *drawInfo;
};
