# $Id: filetransfer.tcl,v 1.29 2006/01/20 03:08:00 aleksey Exp $

namespace eval ft {
    
    custom::defgroup FileTransfer [::msgcat::mc "File Transfer options."] \
	-group Tkabber -tag "File Transfer"

    switch -- $::tcl_platform(platform) {
	windows {
	    if {[info exists $::env(TEMP)]} {
		set default_dir $::env(TEMP)
	    } else {
		set default_dir "C:\\TEMP"
	    }
	}
	default {
	    set default_dir "/tmp"
	}
    }
    # TODO macintosh?
    custom::defvar options(download_dir) $default_dir \
	[::msgcat::mc "Default directory for downloaded files."] \
	-type string -group FileTransfer

    custom::defvar options(cascaded_menu) 0 \
	[::msgcat::mc "Use cascaded (otherwise flat) file transfer menu."] \
	-type boolean -group FileTransfer

    plugins::load [file join plugins filetransfer] -uplevel 1
}


proc ft::create_menu {m connid jid} {
    variable options
    
    if {$options(cascaded_menu)} {
	set mm [menu $m.filetransfer -tearoff 0]
	hook::run create_filetransfer_menu_hook $mm 1 $jid -connection $connid
	if {![hook::is_flag create_filetransfer_menu_hook transport]} {
	    $m add cascad -label [::msgcat::mc "Send file"] -menu $mm
	}
    } else {
	hook::run create_filetransfer_menu_hook $m 0 $jid -connection $connid
    }
    
}

hook::add chat_create_user_menu_hook \
    [namespace current]::ft::create_menu 46
hook::add roster_create_groupchat_user_menu_hook \
    [namespace current]::ft::create_menu 46
hook::add roster_jid_popup_menu_hook \
    [namespace current]::ft::create_menu 46
hook::add message_dialog_menu_hook \
    [namespace current]::ft::create_menu 46
hook::add search_popup_menu_hook \
    [namespace current]::ft::create_menu 46

