# $Id: search.tcl,v 1.4 2005/08/28 20:46:15 aleksey Exp $

proc open_search_panel {sf chatw} {
    set sentry $sf.search

    pack $sf -side bottom -anchor w -fill x -before [winfo parent $chatw].csw
    focus $sentry

    update idletasks
    $chatw see end
}

proc close_search_panel {sf chatid} {
    set cw [chat::winid $chatid]
    set chatw [chat::chat_win $chatid]
    set sentry $sf.search

    $chatw tag remove search_highlight 0.0 end
    pack forget $sf
    focus $cw.input
}

proc setup_search_panel {chatid type} {
    set cw [chat::winid $chatid]
    set chatw [chat::chat_win $chatid]

    $chatw mark set sel_start end
    $chatw mark set sel_end 0.0

    set sf [frame [winfo parent $chatw].search]

    #set slabel [label $sf.slabel -text [::msgcat::mc "Search:"]]
    #pack $slabel -side left

    set sentry [entry $sf.search]
    pack $sentry -padx 1m -side left

    set sbox [ButtonBox $sf.sbox -spacing 0]
    $sbox add -text [::msgcat::mc "Search up"] \
         -command [list ::logger::do_search $chatw $sentry 1]
    $sbox add -text [::msgcat::mc "Search down"] \
         -command [list ::logger::do_search $chatw $sentry 0]
    pack $sbox -side left -padx 1m
    
    set cbox [ButtonBox $sf.cbox -spacing 0]
    $cbox add -text [::msgcat::mc "Close"] \
         -command [list [namespace current]::close_search_panel $sf $chatid]
    pack $cbox -side right -padx 1m

    bind $sentry <Key-Return> [double% [list $sbox invoke 0]]
    bind $sentry <Shift-Key-Return> [double% [list $sbox invoke 1]]
    bind $sentry <Escape> \
	[double% [list [namespace current]::close_search_panel $sf $chatid]]

    event add <<OpenSearchPanel>> <Control-s>
    bind $cw.input <<OpenSearchPanel>> \
	[double% [list [namespace current]::open_search_panel $sf $chatw]]
}

hook::add open_chat_post_hook [namespace current]::setup_search_panel

