/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.AlphaFilter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;

class AlphaBackground {
    Image offi;
    Image filteredi = null;
    AlphaFilter filter = null;
    Color background = null;
    int x;
    int y;
    int width;
    int height;
    int alpha;

    AlphaBackground(Image image, int n) {
        this.offi = image;
        this.alpha = n;
        this.filter = new AlphaFilter(n);
    }

    void setImage(Image image) {
        this.offi = image;
        this.freeImage();
        this.filteredi = null;
    }

    void setCrop(int n, int n2, int n3, int n4) {
        if (n == this.x && n2 == this.y && n3 == this.width && n4 == this.height) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.freeImage();
        this.filteredi = null;
    }

    void setColor(Color color, int n) {
        if (this.background != null && this.background.equals(color)) {
            return;
        }
        this.background = color;
        this.alpha = n;
        this.filter.setColor(color, n);
        this.freeImage();
        this.filteredi = null;
    }

    synchronized void freeImage() {
        if (this.filteredi != null) {
            this.filteredi.flush();
        }
    }

    Image getImage() {
        if (this.filteredi == null) {
            if (this.filter == null) {
                this.filter = new AlphaFilter(this.alpha);
            }
            this.filteredi = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.offi.getSource(), this.filter));
        }
        return this.filteredi;
    }

    void dispose() {
        this.finalize();
    }

    synchronized void drawImage(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        Rectangle rectangle = graphics.getClipBounds();
        Image image = this.getImage();
        graphics.drawImage(image, n, n2, imageObserver);
    }

    public void finalize() {
        this.offi = null;
        this.freeImage();
        this.filteredi = null;
    }
}

