/*
    Wn: A Server for the HTTP
    File: wn/chkauth.c
    Version 2.2.5

    Copyright (C) 1996-2000  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include "wn.h"
#include "auth.h"


static void	sendauth(),
		decode64();

static int	send_noauth();

static
WN_CONST
short int tr[128]={
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,62,-1,-1,-1,63,
    52,53,54,55,56,57,58,59,60,61,-1,-1,-1,-1,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,
    10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,
    28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,
    -1,-1,-1,-1,-1
};



static void
decode64( bufcoded, out)
char	*bufcoded,
	*out;
{

	register char	*in;
	char		buf[SMALLLEN + TINYLEN];

	
	while( isspace(*bufcoded))
		bufcoded++;

	mystrncpy( buf, bufcoded, SMALLLEN);
	in = buf;

	while( *in && (tr[(unsigned) (*in &= 0177)] >= 0))
		in++;
	*in++ = 0;
	*in++ = 0;
	*in++ = 0;
	*in = 0;
    
	in = buf;
    
	while ( in[3] ) {
        	*out++ = (unsigned char) (tr[(unsigned)in[0]] << 2 
						| tr[(unsigned)in[1]] >> 4);
	        *out++ = (unsigned char) (tr[(unsigned)in[1]] << 4 
						| tr[(unsigned)in[2]] >> 2);
        	*out++ = (unsigned char) (tr[(unsigned)in[2]] << 6 
						| tr[(unsigned)in[3]]);
		in += 4;
	}
	
    	if ( in[2] ) {
        	*out++ = (unsigned char) (tr[(unsigned)in[0]] << 2 
						| tr[(unsigned)in[1]] >> 4);
	        *out++ = (unsigned char) (tr[(unsigned)in[1]] << 4 
						| tr[(unsigned)in[2]] >> 2);
        	*out++ = (unsigned char) tr[(unsigned)in[2]] << 6;
	}
	else if ( in[1]) {
        	*out++ = (unsigned char) (tr[(unsigned)in[0]] << 2 
						| tr[(unsigned)in[1]] >> 4);
	        *out++ = (unsigned char) tr[(unsigned)in[1]] << 4;
	}
	else if ( in[0] ) {
        	*out++ = (unsigned char) tr[(unsigned)in[0]] << 2;
	}
	*out = '\0';
}


/*
 * chkauth( ip) check whether authorization is in use and whether the
 * client is authenticated.
 */

int
chkauth( ip )
Request	*ip;
{
	register char	*cp,
			*cp2;

	char	*authmod,
		*authtype,
		*authrealm,
		*authheadp = NULL,
		authcmd[MIDLEN + 2*SMALLLEN],
		buf[MIDLEN];

	int	status,
		result;

	FILE	*fp = NULL;

	signal( _WN_SIGCHLD, SIG_DFL);

	result = AUTH_UNTESTED;

	authmod = dir_p->authmodule;
	authtype = dir_p->authtype;
	authrealm = dir_p->authrealm;

	mystrncpy( authcmd, authmod, SMALLLEN);

	cp = inheadp->authorization;

	if ( *cp ) {
		if ( strncasecmp( cp, "Basic", 5) == 0 &&
				strcasecmp( authtype, "Basic") == 0) {

			if ( ip->attributes & WN_CGI )
				cgi_env( ip, FALSE);
			else
				cgi_env( ip, TRUE);  /* Small (auth) CGI environ */


			if ((fp = popen( authcmd, "w"))  == (FILE *) NULL ) {
				senderr( SERV_ERR, err_m[14], authcmd);
				wn_exit( 2);   /* senderr: SERV_ERR */
			}
			strcpy( buf, "Basic ");
			cp += 5;
			cp2 = buf + 6;
			decode64( cp, cp2);
			mystrncpy( ip->authuser, cp2, SMALLLEN);
			if ( ( cp = strchr( ip->authuser, ':')) != NULL)
				*cp = '\0';

			authheadp = buf;
			fprintf( fp, "%.500s\n", authheadp);
		}
		else if ( strncasecmp( cp, "cert", 4) == 0 &&
			strcasecmp( authtype, "Certificate") == 0) {

			strcpy(  inheadp->authorization, "cert");
			if ((fp = popen( authcmd, "w"))  == (FILE *) NULL ) {
				senderr( SERV_ERR, err_m[14], authcmd);
				wn_exit( 2);   /* senderr: SERV_ERR */
			}
			strcpy( buf, "Client Cert");
			authheadp = buf;
			if ( ip->attributes & WN_CGI )
				cgi_env( ip, FALSE);
			else
				cgi_env( ip, TRUE);  /* Small (auth) CGI environ */

			fprintf( fp, "%.500s\n", authheadp);
		}
#ifdef DIGEST_AUTHENTICATION
		else if ( strncasecmp( cp, "Digest", 6) == 0 &&
				strcasecmp( authtype, "Digest") == 0 ) {
			char	auth_uri[MIDLEN];

			mystrncat( authcmd, " -r ", SMALLLEN);
			mystrncat( authcmd, authrealm, SMALLLEN);

			cp2 = inheadp->authorization;
			if ( (cp = strstr( cp2, "username")) == NULL)
				cp = strstr( cp2, "Username");
			if ( cp != NULL) {
				cp2 = strchr( cp, '"');
				cp2++;
				mystrncpy( ip->authuser, cp2, SMALLLEN);
				if ( (cp = strchr( ip->authuser, '"'))
								!= NULL)
					*cp = '\0';
			}

			if ( ip->attributes & WN_CGI )
				cgi_env( ip, FALSE);
			else
				cgi_env( ip, TRUE);  /* Small (auth) CGI environ */

			if ((fp = popen( authcmd, "r"))  == (FILE *) NULL ) {
				senderr( SERV_ERR, err_m[14], authcmd);
				wn_exit( 2);   /* senderr: SERV_ERR */
			}
			authheadp = inheadp->authorization;
			/* For digest compare the URI and auth header URI */
			if ( ( cp = strstr( authheadp, "uri=\"")) ||
					(cp = strstr( authheadp, "URI=\""))) {
				cp += 5;
				mystrncpy( auth_uri, cp, MIDLEN);
				if ( (cp = strchr( auth_uri, '"')) != NULL ) 
					*cp = '\0';
				if ( !streq( auth_uri, inheadp->auth_url_path))
					result = AUTH_DENIED;
			}
		}
#endif
		else {
			mystrncpy( buf, inheadp->authorization, SMALLLEN);
			cp = buf;
			while( *cp && !isspace( *cp))
				cp++;
			*cp = '\0';
			senderr( SERV_ERR, autherr_m[9], buf);
			wn_exit( 2);   /* senderr: SERV_ERR */
		}


		if ( authheadp == NULL) {
			sendauth( ip, "-s false", autherr_m[10]);
			return FALSE;
		}


		if ( (result == AUTH_UNTESTED) && (fp != NULL)) {
			status = pclose( fp);

#ifdef NEXT
			if ( (status != 0) && WIFEXITED( (union wait) status))
				result = ((status >> 8) & 0377);
#else
			if ( (status != 0) && WIFEXITED( status))
				result = WEXITSTATUS( status);
#endif
			else
				result = status;
		}

		switch (result) {
		case (-1):
			logerr( autherr_m[11], "");
			sendauth( ip, "-s false", autherr_m[11]);
			return FALSE;
		case AUTH_GRANTED:
			return TRUE;
		case AUTH_DENIED:
			sendauth( ip, "-s false", autherr_m[13]);
			return FALSE;
		case AUTH_EXPIRED:
			sendauth( ip, "-s true", autherr_m[14]);
			return FALSE;
		case (3):
			logerr( autherr_m[result], buf);
			sendauth( ip, "-s false", autherr_m[3]);
			return FALSE;
		case (4):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[4]);
			return FALSE;
		case (5):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[5]);
			return FALSE;
		case (6):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[6]);
			return FALSE;
		case (7):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[7]);
			return FALSE;
		case (8):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[8]);
			return FALSE;
		case (9):
			logerr( autherr_m[result], "");
			senderr( "406", autherr_m[9], "");
			return FALSE;
		case (10):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[10]);
			return FALSE;
		case (11):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[11]);
			return FALSE;
		case (12):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[12]);
			return FALSE;
		case (13):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[13]);
			return FALSE;
		case (14):
			logerr( autherr_m[result], "");
			sendauth( ip, "-s false", autherr_m[14]);
			return FALSE;
		case (15):
			logerr( autherr_m[result], "");
			senderr( "406", autherr_m[15], "");
			return FALSE;
		case (16):
		case (19):
			logerr( autherr_m[result], "");
			wn_exit( 2);  /* error */
		case (17):
		case (18):
			senderr( "500", autherr_m[result], "");
			return FALSE;
		default:
			Snprintf2( buf, MIDLEN,  "%.100s %d", 
				   autherr_m[0], result);
			logerr( err_m[42], buf);
			sendauth( ip, "-s false", buf);
			return FALSE;
		}
	}
	sendauth( ip, "-s false", "");
	return FALSE;
}


static void
sendauth( ip, noncearg, logmsg)
Request	*ip;
char	*noncearg,
	*logmsg;
{
	char	*authtype,
		*authrealm,
		buf[MIDLEN];

	if ( inheadp->method == POST ) {
		this_conp->keepalive = FALSE;
	}

	authtype = dir_p->authtype;
	authrealm = dir_p->authrealm;

	mystrncpy( outheadp->status, "401 Unauthorized", SMALLLEN);
	if ( strcasecmp( authtype, "Certificate") == 0)
		mystrncpy( outheadp->status, "403 Forbidden", SMALLLEN);

	else if ( strcasecmp( authtype, "basic") == 0) {
		Snprintf1( outheadp->list, MIDLEN,
				"WWW-Authenticate: Basic realm=\"%.200s\"\r\n",
				authrealm);
	}
#ifdef DIGEST_AUTHENTICATION
	else if ( strcasecmp( authtype, "Digest") == 0) {
		char	authcmd[MIDLEN];
		FILE	*fp;

		if ( ip->attributes & WN_CGI )
			cgi_env( ip, FALSE);
		else
			cgi_env( ip, TRUE);  /* Small (auth) CGI environ */

		Snprintf3( authcmd, MIDLEN, "%.200s -r %.200s %.100s",
			dir_p->authmodule, authrealm, noncearg);
		if ((fp = popen( authcmd, "r"))  == (FILE *) NULL ) {
			senderr( SERV_ERR, err_m[14], authcmd);
			wn_exit( 2);   /* senderr: SERV_ERR */
		}
		if ( fgets( outheadp->list, MIDLEN, fp) == NULL) {
			senderr( SERV_ERR, err_m[50], authcmd);
			pclose( fp);
			wn_exit( 2);   /* senderr: SERV_ERR */
		}
		pclose( fp);
	}
#endif
	else {
		senderr( SERV_ERR, autherr_m[19], "");
		wn_exit( 2);   /* senderr: SERV_ERR */
	}

	ip->encoding =  NULL;
	ip->mod_time = 0;
	ip->content_type = "text/html; charset=iso-8859-1";

	if ( *(dir_p->authdenied_file) ) {
		if ( send_noauth( ) ) {
			writelog( ip, log_m[1], logmsg);
			return;
		}
	}
		
	Snprintf1( buf, MIDLEN/4,
		   "<head>\n<title>%.100s</title>\n</head>\n<body>\n",
		   	autherr_m[1]);
	Snprintf1( buf + strlen(buf), MIDLEN/4,
		   "<h2>%.100s</h2>\n", autherr_m[1]);

	Snprintf2( buf + strlen(buf), MIDLEN/2, "%.200s\n%.100s\n </body>\n", 
			 logmsg, SERVER_LOGO);
	ip->datalen = strlen( buf);
	Snprintf1( ip->length, TINYLEN, "%lu", ip->datalen);
	ip->status |= WN_HAS_BODY;
	http_prolog( );
	send_text_line(buf);

	writelog( ip, log_m[1], logmsg);
	return;
}


static int
send_noauth( )
{
	FILE	*fp;
	char	buf[MIDLEN];
	struct stat stat_buf;

	if ( getfpath2( buf, dir_p->authdenied_file,
						this_rp->cachepath) == FALSE) {
		logerr( err_m[86], dir_p->authdenied_file);
		return FALSE;
	}
	if ( stat( buf, &stat_buf) != 0 ) {
		logerr( err_m[12], buf);
		return FALSE;
	}
	if ( (fp = fopen( buf, "r")) == (FILE *) NULL ) {
		logerr( err_m[1], buf);
		return FALSE;
	}

	this_rp->datalen = (long) stat_buf.st_size;

	Snprintf1( this_rp->length, TINYLEN, "%lu",  this_rp->datalen);
	set_etag( &stat_buf);

	http_prolog();
	while ( fgets( buf, MIDLEN, fp)) {
		send_text_line( buf);
	}
	return TRUE;
}


