///////////////////////////////////////////////////////////////////////////////
//
// Wall Paper Changer for GNOME
// Copyright (C) 2000-2001  Kenichi Shibata <ken_s@cat.zero.ad.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// Please read the file "COPYING" for more information.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////
//
// ken_s@cat.zero.ad.jp
// http://www3.might.co.jp/~sibata/top/
//
///////////////////////////////////////////////////////////////////////////////

#define __APPLET_H
#include "global.h"

//--- Global -----------------------------------------------------
GtkWidget *gApplet;

////////////////////////////////////////////////////////
//                                                    //
//  Create GNOME Applet                               //
//                                                    //
//    Parameter                                       //
//       argc : Command line Parameter count          //
//       argv : Command line parameter                //
//    Return                                          //
//       void                                         //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget *create_applet(int argc, char *argv[])
{
  GtkWidget *applet, *pixmap_widget, *button;
  GtkTooltips *tooltips;

  // Applet Create
  applet_widget_init( PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
  if ((applet = applet_widget_new(PACKAGE)) == NULL)
    g_error( _("Can't create applet!\n" ) );
  gtk_widget_realize(applet);
  
  gtk_signal_connect (GTK_OBJECT (applet), "delete_event",
		      GTK_SIGNAL_FUNC (on_applet_delete_event),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (applet), "destroy",
		      GTK_SIGNAL_FUNC (on_applet_destroy),
		      NULL);

  tooltips = gtk_tooltips_new();

  pixmap_widget = create_pixmap (applet, "wpac_applet/wpac_c.xpm", TRUE);
  button = gtk_button_new();
  gtk_object_set_data (GTK_OBJECT (applet), "applet_button1", button);

  gtk_container_add(GTK_CONTAINER(button), pixmap_widget);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (on_applet_button1_clicked),
		      NULL);
  gtk_widget_show(pixmap_widget);
  gtk_widget_set_usize(button, 24, 24);
  gtk_widget_show(button);
  gtk_tooltips_set_tip (tooltips, button, _(" Change Wall Paper "), NULL);
  
  applet_widget_add(APPLET_WIDGET(applet), button);
  gtk_object_set_data (GTK_OBJECT (applet), "tooltips", tooltips);

  // Pop up menu
  applet_widget_register_callback (APPLET_WIDGET(applet), "wpac_property", _("Property"), on_applet_property_button, NULL);
  //  applet_widget_register_callback (APPLET_WIDGET(applet), "wpac_exit", _("Exit"), on_applet_exit_button, NULL);

  gtk_widget_show(applet);
  
  gApplet = applet;
  return (applet);
}

////////////////////////////////////////////////////////
//                                                    //
//  Change Wall Paper button "clicked" event          //
//                                                    //
////////////////////////////////////////////////////////
void on_applet_button1_clicked (GtkButton *button, gpointer user_data)
{
  wpac_change_wallpaper();
}

////////////////////////////////////////////////////////
//                                                    //
//  Applet delete event                               //
//                                                    //
////////////////////////////////////////////////////////
gboolean on_applet_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  return (FALSE);
}

////////////////////////////////////////////////////////
//                                                    //
//  Applet destroy event                              //
//                                                    //
////////////////////////////////////////////////////////
void on_applet_destroy(GtkObject *object, gpointer user_data)
{
  applet_widget_gtk_main_quit();
}
