/*
 * paper type
 *
 * Copyright (c) 1995
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Cardinals.h>

/* #include "xdvi.h" */
#include "xdvi-config.h"	/* added by Masahito Yamaga */
#include "chardef.h"
#include "paper.h"

static char          paper_type[PAPERTYPELEN];

void
  SetPaperSize(type)
char *type;
{
  if (type == NULL)
    paper_type[0] = CHAR_NULL;
  else
    strcpy(paper_type, type);
}

char
  *GetPaperSize()
{ 
  return paper_type;
}

#ifdef	PAPERMENU
static int           paper_types_num          = 0;

void
  InitPaperType(num)
int num;
{
  paper_types_num = num;
}

static Boolean       PaperEnd     = False;
static Boolean       PaperChanged = False;

static void
  SetPaperType(paper)
char* paper;
{
  char* p                       = paper;
  char  paperType[PAPERTYPELEN];
  char* q                       = paperType;

  /* skip white spaces (except newline) */
  while(*p==CHAR_SPACE || *p==CHAR_TAB)
    p++;

  /* reduce newline */
  while(*p!=CHAR_NULL) {
    if(*p==CHAR_NEWLINE) {
      p++;
    } else {
      *q++ = *p++;
    }
  }

  /* temporal terminate symbol */
  *q = CHAR_NULL;

  /* truncate whitespaces at the tail of paper type */
  --q;
  while(q>=paperType && ISWHITESPACE(*q))
    *q-- = CHAR_NULL;

  /* compare the current page type with input */
  /* if page type will not changed, do nothing */
  q = paperType;
  if(*q==CHAR_NULL) {
    PaperEnd = True;
    /* Paper Type popup shell should be closed */
  } else {
    if(strcmp(paperType, GetPaperSize())==0) {
      PaperEnd = True;
      /* Paper Type popup shell should be closed */
    } else {
      if (! set_paper_type(paperType)) {
        Fprintf(stderr, "Don't recognize paper type %s\n", paperType);
      } else {
        PaperEnd = True;
        /* Paper Type popup shell should be closed */
        PaperChanged = True;
      }
    }
  }
}

static void
  SelectPaperType(widget, client_data, call_data)
Widget    widget;
XtPointer client_data, call_data;
{
  int    Type      = (int)client_data;
  char*  paperType = (char *)paper_types[Type];

  SetPaperType(paperType);
}

static Widget        popup, dialog, select_button, select_menu;

static void
  SetPaper(widget, client_data, call_data)
Widget    widget;
XtPointer client_data, call_data;
{
  char  buff[PAPERTYPELEN];

  strcpy(buff, (char *)XawDialogGetValueString(dialog));
  SetPaperType(buff);
}

static void 
  DestroyPaperPopupPrompt(widget, client_data, call_data)
Widget    widget;
XtPointer client_data, call_data;
{
  PaperEnd = True;
  /* Paper Type popup shell should be closed */
}

static XtActionsRec  actionsTable[] = {
  {"SetPaper", SetPaper},
};

static char          defaultTranslations[] =
  "Ctrl<Key>J:     SetPaper()\n\
   Ctrl<Key>O:     SetPaper()\n\
   Ctrl<Key>M:     SetPaper()\n\
   <Key>Return:    SetPaper()";

Boolean
  PopupPaperType(top_level)
Widget top_level;
{
  Widget         entry;
  Position       x, y;
  Dimension      width, height;
  XtAppContext   PaperApp;
  XEvent         event;
  XtTranslations trans_table;
  int            i;
  
  XtVaGetValues(top_level,
		XtNwidth, &width,
		XtNheight, &height,
		NULL);

  XtTranslateCoords(top_level,
		    (Position) (width / 3), (Position) (height / 3),
		    &x, &y);

  popup = XtVaCreatePopupShell(LBLPAPERSH,
			       transientShellWidgetClass,
			       top_level,
			       XtNx, x,
			       XtNy, y,
			       XtNdepth, our_depth,
			       XtNvisual, our_visual,
#ifdef GREY
			       XtNcolormap, our_colormap,
#endif
			       NULL);

  XtAddActions(actionsTable, XtNumber(actionsTable));
  trans_table = XtParseTranslationTable(defaultTranslations);
  XtOverrideTranslations(popup, trans_table);

  /* 
   * The popup will contain a dialog box, prompting the user for input. 
   */
  
  dialog = XtVaCreateManagedWidget(LBLPAPERTYPE,
				   dialogWidgetClass,
				   popup,
				   XtNlabel,        (String)LBLPAPERTYPE,
				   XtNvalue,        (String)GetPaperSize(),
				   NULL);

  /*
   * The prompting message's size is dynamic; allow it to request resize. 
   */
  
  /*** Select button ***/
  select_button = XtVaCreateManagedWidget(LBLSELECT,
					  menuButtonWidgetClass,
					  dialog,
					  NULL);
  XtVaSetValues(select_button,
		XtNmenuName, LBLSELECTMENU,
		NULL);
  
  select_menu = XtVaCreatePopupShell(LBLSELECTMENU,
				     simpleMenuWidgetClass,
				     select_button,
				     XtNdepth, our_depth,
				     XtNvisual, our_visual,
#ifdef GREY
				     XtNcolormap, our_colormap,
#endif
				     NULL);
  
  for(i = 0; i<paper_types_num; i += 2) {
    entry = XtVaCreateManagedWidget(paper_types[i],
				    smeBSBObjectClass,
				    select_menu,
				    NULL);
    XtAddCallback(entry, XtNcallback, SelectPaperType, (XtPointer)i);
  }

  /*** Ok button ***/
  XawDialogAddButton(dialog,
		     LBLOK,
		     SetPaper,
		     (XtPointer)dialog);
  
  /*** Cancel button ***/
  XawDialogAddButton(dialog,
		     LBLCANCEL,
		     DestroyPaperPopupPrompt,
		     (XtPointer)dialog);
  
  XtPopup(popup, XtGrabNone);

  PaperEnd = False;
  PaperChanged = False;

  XtAddGrab(popup, True, True);

  PaperApp = XtWidgetToApplicationContext(popup);

  while(! PaperEnd) {
    XtAppNextEvent(PaperApp, &event);
    XtDispatchEvent(&event);
  };

  XtDestroyWidget(popup);

  return PaperChanged;
}
#endif	/* PAPERMENU */
