/*
 * print-out DVI
 *
 * Copyright (c) 1993, 1994, 1995
 *      MATSUURA Syun           syun@fuka.info.waseda.ac.jp
 *      HIRAHARA Atsushi        hirahara@fuka.info.waseda.ac.jp
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#ifndef _PRINT_H_
#define _PRINT_H_

#include "chardef.h"

#ifndef DVISEL
/*
 * Internal variables for print-out command string
 *
 * %% : a character '%' itself
 * %f : filename of DVI file (full pathname)
 * %F : filename of DVI file (basename of pathname)
 * %d : directory where DVI file is placed (directory of pathname)
 * %D : temp directory (if the environment variable TMPDIR is defined, use it)
 * %p : printer name (if the environment variable PRINTER is defined, use it)
 * %P : print command string
        (if the environment variable PRINTCMD is defined, use it)
 * %z : paper size specified with -paper option (lower case)
 * %Z : paper size translated from -paper option
 * %r : proces id
 * %R : DVI filter command string
        (if the environment variable DVIFILTER is defined, use it)
 *
 * The following variables denote absolute page number.
 * %c : current page number
#ifdef MARKPAGE
 * %m : last marked page number
 * %s : start page number of region; minimum of %c and %m
 * %e : end page number of region; maximum of %c and %m
 * %l : marked page list; marked order; separated by ","
 * %L : marked page list; marked order; separated by " "
 * %t : marked page list; sorted; separated by ","
 * %T : marked page list; sorted; separated by " "
 * %o : marked page list; sorted; page-to-page form (p1-p2); separated by ","
 * %O : marked page list; sorted; page-to-page form (p1-p2); separated by " "
 * %k : like %l; "=" is put on each page number (assumed dviselect)
 * %K : like %L; "=" is put on each page number (assumed dviselect)
 * %a : like %t; "=" is put on each page number (assumed dviselect)
 * %A : like %T; "=" is put on each page number (assumed dviselect)
 * %g : like %o; page-to-page form (=p1:p2) (assumed dviselect)
 * %G : like %O; page-to-page form (=p1:p2) (assumed dviselect)
#endif
 */

#define CHAR_COMMENT    CHAR_SHARP
#define ISCOMMENT(c)    (c==CHAR_COMMENT)

#define PATH_DELIMITER  CHAR_SLASH
#endif /* ! DVISEL */

#define DEFAULTPRINTER  "lp"
#ifndef	DVIPRINTER
#define	DVIPRINTER      DEFAULTPRINTER
#endif	/* DVIPRINTER */
#define ENVVARPRINTER   "PRINTER"
#ifdef DVISEL
#define ENVVARXDVIPRINTCMD "XDVIPRINTCMD"
#endif
#define PRINTERNAMELEN  (32)

#ifndef DVISEL
#define VARMARK    CHAR_PERCENT

#define VARDVIFILEFULLPATH      'f'
          /* filename of DVI file (full pathname) */
#define VARDVIFILEBASENAME      'F'
          /* filename of DVI file (basename of pathname) */
#define VARDVIFILEDIRNAME       'd'
          /* directory where DVI file is placed (directory of pathname) */
#define VARTEMPDIRECTORY        'D'
          /* temp directory */
          /* (if the environment variable TMPDIR is defined, use it) */
#define VARPRINTERNAME          'p'
          /* printer name */
          /* (if the environment variable PRINTER is defined, use it) */
#define VARPRINTCOMMAND         'P'
          /* print command string */
          /* (if the environment variable PRINTCMD is defined, use it) */
#define VARPAPERSIZE            'z'
          /* paper size specified with -paper option (lower case) */
#define VARPAPERSIZEFORFILTER   'Z'
          /* paper size translated from -paper option */
#define VARPROCESSID            'r'
          /* proces id */
#define VARDVIFILTERCOMMAND     'R'
          /* DVI filter command string */
          /* (if the environment variable DVIFILTER is defined, use it) */
#define VARCURRENTPAGENUMBER    'c'
          /* current page number */
#ifdef MARKPAGE
#define VARLASTMARKEDPAGENUMBER 'm'
          /* last marked page number */
#define VARSTARTPAGENUMBEROFREGION      's'
          /* start page number of region; minimum of %c and %m */
#define VARENDPAGENUMBEROFREGION        'e'
          /* end page number of region; maximum of %c and %m */
#define VARMARKEDPAGELISTMARKEDORDERBYCOMMA     'l'
          /* marked page list; marked order; separated by "," */
#define VARMARKEDPAGELISTMARKEDORDERBYSPACE     'L'
          /* marked page list; marked order; separated by " " */
#define VARMARKEDPAGELISTSORTEDBYCOMMA  't'
          /* marked page list; sorted; separated by "," */
#define VARMARKEDPAGELISTSORTEDBYSPACE  'T'
          /* marked page list; sorted; separated by " " */
#define VARMARKEDPAGETOPAGELISTSORTEDBYCOMMA    'o'
          /* marked page list; sorted; page-to-page form (p1-p2) */
          /* separated by "," */
#define VARMARKEDPAGETOPAGELISTSORTEDBYSPACE    'O'
          /* marked page list; sorted; page-to-page form (p1-p2) */
          /* separated by " " */
#define VARMARKEDABSOLUTEPAGELISTMARKEDORDERBYCOMMA     'k'
          /* like %l; "=" is put on each page number (assumed dviselect) */
#define VARMARKEDABSOLUTEPAGELISTMARKEDORDERBYSPACE     'K'
          /* like %L; "=" is put on each page number (assumed dviselect) */
#define VARMARKEDABSOLUTEPAGELISTSORTEDBYCOMMA  'a'
          /* like %t; "=" is put on each page number (assumed dviselect) */
#define VARMARKEDABSOLUTEPAGELISTSORTEDBYSPACE  'A'
          /* like %T; "=" is put on each page number (assumed dviselect) */
#define VARMARKEDABSOLUTEPAGETOPAGELISTSORTEDBYCOMMA    'g'
          /* like %o; page-to-page form (=p1:p2) (assumed dviselect) */
#define VARMARKEDABSOLUTEPAGETOPAGELISTSORTEDBYSPACE    'G'
          /* like %O; page-to-page form (=p1:p2) (assumed dviselect) */
#endif  /* MARKPAGE */

/* Print-out command templates */
#ifndef PRCMDALL
#define	PRCMDALL   "cd %d; %R %F > %D/%F:All@%r.ps; %P -J'%F' %D/%F:All@%r.ps"
/* all pages of DVI file */
#endif /* PRCMDALL */
#ifndef PRCMDCUR
#define	PRCMDCUR   "cd %d; dviselect -i %F -o %D/%F:%c@%r.dvi =%c; %R %D/%F:%c@%r.dvi > %D/%F:%c@%r.ps; /bin/rm %D/%F:%c@%r.dvi; %P -J'%F (Page %c)' %D/%F:%c@%r.ps"
/* the current page */
#endif /* PRCMDCUR */
#ifdef MARKPAGE
#ifndef PRCMDMRK
#define	PRCMDMRK   "cd %d; dviselect -i %F -o %D/%F:%m@%r.dvi =%m; %R %D/%F:%m@%r.dvi > %D/%F:%m@%r.ps; /bin/rm %D/%F:%m@%r.dvi; %P -J'%F (Page %m)' %D/%F:%m@%r.ps"
/* the last marked page */
#endif /* PRCMDMRK */
#ifndef PRCMDRGN
#define	PRCMDRGN   "cd %d; dviselect -i %F -o %D/%F:%s-%e@%r.dvi =%s:%e; %R %D/%F:%s-%e@%r.dvi > %D/%F:%s-%e@%r.ps; /bin/rm %D/%F:%s-%e@%r.dvi; %P -J'%F (Page %s-%e)' %D/%F:%s-%e@%r.ps"
/* pages in the region, between the current page and the last marked page */
#endif /* PRCMDRGN */
#ifndef PRCMDLST
#define	PRCMDLST   "cd %d; dviselect -i %F -o %D/%F:%o@%r.dvi %G; %R %D/%F:%o@%r.dvi > %D/%F:%o@%r.ps; /bin/rm %D/%F:%o@%r.dvi; %P -J'%F (Page %o)' %D/%F:%o@%r.ps"
/* all marked pages */
#endif /* PRCMDLST */
#endif /* MARKPAGE */
#endif /* ! DVISEL */

enum PRINTSTYLE
#ifdef MARKPAGE
{PRINTALL, PRINTCUR, PRINTMARKED, PRINTREGION, PRINTALLMARKED};
#else
{PRINTALL, PRINTCUR};
#endif /* MARKPAGE */

#define LBLPRINTSH             "Print-out"

#define LBLPRINTER             "Printer name"

#define LBLPRINTOUT            "Print"
#define LBLCANCEL              "Cancel"

#define LBLPRINTMENU           "Print menu"

#define LBLPRINTALL            "All pages"
#define LBLPRINTCUR            "Current page"
#ifdef MARKPAGE
#define LBLPRINTMRK            "Last marked page"
#define LBLPRINTRGN            "Region"
#define LBLPRINTAMK            "All marked pages"
#endif /* MARKPAGE */

#ifdef MARKPAGE
#define MIN(i, j)       ( (i) < (j) ? (i) : (j) )
#define MAX(i, j)       ( (i) > (j) ? (i) : (j) )
#endif /* MARKPAGE */

typedef struct {
  int           print_style;
  Widget        widget;
} PrintOrder;

#ifndef DVISEL
/* translation file from xdvi paper type into dvi filter paper size option */
#ifndef FILTOPTTBLFILE
#define FILTOPTTBLFILE  "/usr/local/share/texmf/xdvi/xdvipaper.dvi2ps-j"
/* #define FILTOPTTBLFILE  "/usr/local/lib/TeX/xdvipaper.dvi2ps-j" */
/* #define FILTOPTTBLFILE  "/usr/local/lib/TeX/xdvipaper.jdvi2kps" */
#endif  /* FILTOPTTBLFILE */
#define FILTOPTTBLFILEENVVARNAME        "XDVIFILTOPTTBL"

/* work directory for temporal files */
#ifndef TEMPDIR
#define TEMPDIR "/tmp"
#endif  /* TEMPDIR */
#define TEMPDIRENVVARNAME       "TMPDIR"

/* DVI filter command string */
#ifndef DVIFILTERCMD
#define DVIFILTERCMD    "dvi2ps -o %Z"
/* #define DVIFILTERCMD    "jdvi2kps -p%Z" */
#endif  /* DVIFILTERCMD */
#define DVIFILTERCMDENVVARNAME  "DVIFILTER"

/* print command string */
#ifndef PRINTCMD
#define PRINTCMD        "lpr -s -r -P%p"
#endif  /* PRINTCMD */
#define PRINTCMDENVVARNAME      "PRINTCMD"
#endif /* ! DVISEL */

extern void     InitPrintMenu();
extern void     print_DVI_file();

#endif  /* _PRINT_H_ */
