/*
    Copyright (C) 2000  Tamas Pal <tpal@egon.gyaloglo.hu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
  save_xmms.c - two little functions to save playlist and some configuration 
  options to the default configfiles (~/.xmms/xmms.m3u and ~/.xmms/config)
*/

#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include "xmmsctrl.h"
#include "configfile.h"

#include "util.h"

#include "config.h"

#include "save_xmms.h"

void save_cfgfile(gint xmms_session)
{
    gchar *configfile, *skin = NULL;
    ConfigFile *mycfg;

    configfile = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);

    mycfg = (*xmms_cfg_open_default_file) ();
    xmms_cfg_write_int(mycfg, "xmms", "playlist_position",
		       xmms_remote_get_playlist_pos(xmms_session));
    xmms_cfg_write_boolean(mycfg, "xmms", "playlist_visible",
			   xmms_remote_is_pl_win(xmms_session));
    xmms_cfg_write_boolean(mycfg, "xmms", "equalizer_visible",
			   xmms_remote_is_eq_win(xmms_session));
    if ((skin = xmms_remote_get_skin(xmms_session)))
	xmms_cfg_write_string(mycfg, "xmms", "skin", skin);

#ifdef HAVE_XMMS_REMOTE_IS_REPEAT
    xmms_cfg_write_boolean(mycfg, "xmms", "repeat",
			   xmms_remote_is_repeat(xmms_session));
#endif
#ifdef HAVE_XMMS_REMOTE_IS_SHUFFLE
    xmms_cfg_write_boolean(mycfg, "xmms", "shuffle",
			   xmms_remote_is_shuffle(xmms_session));
#endif
    xmms_cfg_write_file(mycfg, configfile);

    xmms_cfg_free(mycfg);
    g_free(configfile);
}

void save_playlist(gint xmms_session)
{
    gint playlist_length, playlst_pos;
    FILE *playlist;
    gchar *playlist_file, *playlist_m3u;

    playlist_m3u = g_strconcat(g_get_home_dir(), "/.xmms/xmms.m3u", NULL);
    playlist_length = xmms_remote_get_playlist_length(xmms_session);
    playlist = fopen(playlist_m3u, "w");
    for (playlst_pos = 0; playlst_pos < playlist_length; playlst_pos++) {
	playlist_file =
	    (*xmms_remote_get_playlist_file) (xmms_session, playlst_pos);
	fprintf(playlist, "%s\n", playlist_file);
	g_free(playlist_file);
    }
    fclose(playlist);
    g_free(playlist_m3u);

}
