###################################################################################################
# _scormlib.py
#
# $Id: _scormlib.py,v 1.2 2003/11/21 07:29:46 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.2 $
#
# Implementation of class SCORMLib (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################


# Product Imports.
import zmscontainerobject
import _xmllib

encoding = 'utf-8'

# ---------------------------------------------------------------------------------------------
#  getIMSManifestItems:
# ---------------------------------------------------------------------------------------------
def getIMSManifestItems(self, REQUEST):
  obs = self.filteredChildNodes(REQUEST)
  xml = []
  xml.append('<item')
  xml.append(' identifier="%s"'%self.id)
  if self.meta_type=='ZMSCustom' or zmscontainerobject.isPageWithElements(obs):
    xml.append(' identifierref="R_%s"'%self.id)
  if self.getObjProperty('attr_ims_isvisible',REQUEST)==0:
    xml.append(' isvisible="false"')
  else:
    xml.append(' isvisible="true"')
  xml.append('>')
  # Sequencing-Rules
  self.initObjChildren(REQUEST)
  for ob in self.getObjChildren('',REQUEST):
    if ob.meta_type == 'ZMSCustom' and  \
       'imsmanifest' in self.getMetaobjAttrIds(ob.meta_id):
      xml.append(ob.getObjProperty('imsmanifest',REQUEST))
  xml.append('<title><![CDATA[%s]]></title>\n'%_xmllib.xml_quote(self.getTitlealt(REQUEST),encoding))
  for ob in obs:
    if ob.isPage():
      xml.extend(getIMSManifestItems(ob,REQUEST))
  xml.append('</item>')
  return ''.join(xml)

# ---------------------------------------------------------------------------------------------
#  getIMSManifestResources:
# ---------------------------------------------------------------------------------------------
def getIMSManifestResources(base, self, REQUEST):
  obs = self.filteredChildNodes(REQUEST)
  xml = ''
  if self.meta_type=='ZMSCustom' or zmscontainerobject.isPageWithElements(obs):
    href =  self.getHref2IndexHtml(REQUEST)[len(base.absolute_url())+1:]
    xml += '<resource'
    xml += ' identifier="R_%s"'%self.id
    xml += ' type="webcontent"'
    xml += ' adlcp:scormtype="sco"'
    xml += ' href="%s"'%href
    xml += '>\n'
    xml += '<metadata>\n'
    xml += '<schema>ADL SCORM</schema>\n'
    xml += '<schemaversion>1.2</schemaversion>\n'
    xml += '</metadata>\n'
    xml += '<file href="%s" />'%href
    xml += '</resource>\n'
  for ob in obs:
    if ob.isPage():
      xml += getIMSManifestResources(base,ob,REQUEST)
  return xml


###################################################################################################
###################################################################################################
###
###   class SCORMLib
###
###################################################################################################
###################################################################################################
class SCORMLib:

  # ---------------------------------------------------------------------------------------------
  #  parseIMSManifest:
  #
  #  Parse IMSManifest.xml
  # ---------------------------------------------------------------------------------------------
  def parseIMSManifest(self, xml):
    IMSManifest = []
    NodeSet = self.xmlParse(xml)
    ResourceDict = {}
    for nResources in self.xmlNodeSet(NodeSet,'resources'):
      for nResource in self.xmlNodeSet(nResources,'resource'):
        attrs = nResource['attrs']
        identifier = attrs['identifier']
        ResourceDict[identifier] = attrs
    for nOrganizations in self.xmlNodeSet(NodeSet,'organizations'):
      for nOrganization in self.xmlNodeSet(nOrganizations,'organization'):
        level_offs = nOrganization['level']
        for nItem in self.xmlNodeSet(nOrganization,'item',1):
          attrs = nItem['attrs']
          level = nItem['level']
          identifier = attrs['identifier']
          identifierref = attrs.get('identifierref',None)
          isvisible = attrs.get('isvisible','true')=='true'
          item = {}
          item['id'] = identifier
          item['visible'] = isvisible
          item['level'] = level-level_offs
	  # Sequencing-Rules
          item['rule_condition'] = None 
          for nSequencing in self.xmlNodeSet(nItem,'sequencing'):
            for nSequencingRules in self.xmlNodeSet(nSequencing,'sequencingRules'):
              for nPreConditionRule in self.xmlNodeSet(nSequencingRules,'preConditionRule'):
                for nRuleConditions in self.xmlNodeSet(nPreConditionRule,'ruleConditions'):
                  for nRuleCondition in self.xmlNodeSet(nRuleConditions,'ruleCondition'):
                    attrs = nRuleCondition['attrs']
                    item['rule_condition'] = attrs.get('condition') 
                    item['rule_condition_op'] = attrs.get('operator','') 
                    item['rule_condition_ref'] = attrs.get('referencedObjective','') 
                for nRuleAction in self.xmlNodeSet(nPreConditionRule,'ruleAction'):
                  attrs = nRuleAction['attrs']
                  item['rule_action'] = attrs.get('action')
          # Title
          item['title'] = None
          for nTitle in self.xmlNodeSet(nItem,'title'):
            item['title'] = nTitle['cdata']
          item['href'] = None
          if identifierref in ResourceDict.keys():
            item['href'] = ResourceDict[identifierref]['href']
          IMSManifest.append(item)
    return IMSManifest

  # ---------------------------------------------------------------------------------------------
  #  getIMSManifest:
  #
  #  Returns IMSManifest.xml
  # ---------------------------------------------------------------------------------------------
  def getIMSManifest(self, REQUEST):
    xml = self.getXmlHeader()
    xml += '<manifest identifier="%sManifest" version="1.1"\n'%self.id
    xml += 'xmlns="http://www.imsproject.org/xsd/imscp_rootv1p1p2"\n'
    xml += 'xmlns:adlcp="http://www.adlnet.org/xsd/adlcp_rootv1p2"\n'
    xml += 'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"\n'
    xml += 'xsi:schemaLocation="http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd\n'
    xml += 'http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd\n'
    xml += 'http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd">\n'
    xml += '<metadata/>\n'
    xml += '<organizations default="%s">\n'%self.id
    xml += '<organization default="%s">\n'%self.id
    xml += '<title><![CDATA[%s]]></title>\n'%_xmllib.xml_quote(self.getTitlealt(REQUEST),encoding)
    xml += getIMSManifestItems(self,REQUEST)
    xml += '</organization>\n'
    xml += '</organizations>\n'
    xml += '<resources>\n'
    xml += getIMSManifestResources(self,self,REQUEST)
    xml += '</resources>\n'
    xml += '</manifest>\n'
    return xml;
  
  
###################################################################################################
