#include "DBManagementMO.hh"
#include "../conn_pool/DBPooledConnection.hh"
#include "../conn_pool/DBPoolContainer.hh"
#include "../thread_pool/DBThreadPool.hh"
#include "../DBBalancer.hh"

DBManagementMO::DBManagementMO (DBBalancer *db, unsigned int delay, bool connTest=true, bool threadTest=true) {


  ACE_DEBUG((LM_DEBUG,"(%t) Constructed DBManagementMO\n"));
  db_ = db;
  _delay = delay;
  _connTest = connTest;
  _threadTest = threadTest;

}

DBManagementMO::~DBManagementMO() {


  ACE_DEBUG((LM_DEBUG,"(%t) Destroyed DBManagementMO\n"));


}

int DBManagementMO::call () {
  
  int result;

  // Let's give some time to startup connections.
  ACE_OS::sleep(5);

  while (1) {

    if (_threadTest)
      result = checkThreads(db_->getPoolContainer()->getPoolNumber());
 
    if (_connTest)
      checkConnections(result);

    ACE_OS::sleep(_delay);
   

  }
  return 0;

}

void DBManagementMO::checkConnections(int threadGain) {


  // If we had changes in thread number (threadGain != 0) we also make changes to the db connection number.
  
  if (threadGain!=0)
    db_->getPoolContainer()->adjustConnections(threadGain);


  // Routine check to one of the connections.
  
  DBPooledConnection *dbpc = db_->getPoolContainer()->getConnectionForTest();
  
  if (dbpc) {    
    ACE_DEBUG((LM_DEBUG,"(%D, %t) Conn test,  connection %s, delay %d\n",dbpc->getId().c_str(),_delay));
    dbpc->checkConnection();
    
  } else {
    ACE_DEBUG((LM_DEBUG,"(%D, %t) Conn test, NO connection to test.\n"));
  }
      


}


int DBManagementMO::checkThreads(unsigned int poolNumber) {

  return db_->getThreadPool()->reviewThreads(poolNumber);

}

