% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimability.R
\name{nullspace}
\alias{nullspace}
\title{Nullspace}
\usage{
nullspace(A, type = c("right", "left"), tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{A}{a numeric matrix.}

\item{type}{\code{"right"} (default) gives is the standard nullspace,
\code{"left"} gives left nullspace of \code{A}.}

\item{tol}{tolerance multiple of the first singular value to determine if
subsequent singular values are (sufficiently) positive to be determined
greater than zero.}
}
\value{
a matrix with as many rows as there are columns in \code{A}. The
number of columns (which may be zero) determine the dimensionality of the
nullspace of \code{A}.
}
\description{
Compute the (right or left) nullspace of matrix using a (semi-complete)
Singular Value Decomposition.
}
\details{
This implementation is fastest on matrices with more rows
than columns such as a typical design matrix for a linear model.
}
\examples{

# FIXME: We need some examples here

}
\author{
Rune Haubo B. Christensen
}
\keyword{internal}
