package datafactory

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AmazonRdsForOraclePartitionOption enumerates the values for amazon rds for oracle partition option.
type AmazonRdsForOraclePartitionOption string

const (
	// AmazonRdsForOraclePartitionOptionDynamicRange ...
	AmazonRdsForOraclePartitionOptionDynamicRange AmazonRdsForOraclePartitionOption = "DynamicRange"
	// AmazonRdsForOraclePartitionOptionNone ...
	AmazonRdsForOraclePartitionOptionNone AmazonRdsForOraclePartitionOption = "None"
	// AmazonRdsForOraclePartitionOptionPhysicalPartitionsOfTable ...
	AmazonRdsForOraclePartitionOptionPhysicalPartitionsOfTable AmazonRdsForOraclePartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleAmazonRdsForOraclePartitionOptionValues returns an array of possible values for the AmazonRdsForOraclePartitionOption const type.
func PossibleAmazonRdsForOraclePartitionOptionValues() []AmazonRdsForOraclePartitionOption {
	return []AmazonRdsForOraclePartitionOption{AmazonRdsForOraclePartitionOptionDynamicRange, AmazonRdsForOraclePartitionOptionNone, AmazonRdsForOraclePartitionOptionPhysicalPartitionsOfTable}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAnonymous ...
	AuthenticationTypeAnonymous AuthenticationType = "Anonymous"
	// AuthenticationTypeBasic ...
	AuthenticationTypeBasic AuthenticationType = "Basic"
	// AuthenticationTypeClientCertificate ...
	AuthenticationTypeClientCertificate AuthenticationType = "ClientCertificate"
	// AuthenticationTypeWebLinkedServiceTypeProperties ...
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = "WebLinkedServiceTypeProperties"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAnonymous, AuthenticationTypeBasic, AuthenticationTypeClientCertificate, AuthenticationTypeWebLinkedServiceTypeProperties}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// AvroCompressionCodec enumerates the values for avro compression codec.
type AvroCompressionCodec string

const (
	// AvroCompressionCodecBzip2 ...
	AvroCompressionCodecBzip2 AvroCompressionCodec = "bzip2"
	// AvroCompressionCodecDeflate ...
	AvroCompressionCodecDeflate AvroCompressionCodec = "deflate"
	// AvroCompressionCodecNone ...
	AvroCompressionCodecNone AvroCompressionCodec = "none"
	// AvroCompressionCodecSnappy ...
	AvroCompressionCodecSnappy AvroCompressionCodec = "snappy"
	// AvroCompressionCodecXz ...
	AvroCompressionCodecXz AvroCompressionCodec = "xz"
)

// PossibleAvroCompressionCodecValues returns an array of possible values for the AvroCompressionCodec const type.
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return []AvroCompressionCodec{AvroCompressionCodecBzip2, AvroCompressionCodecDeflate, AvroCompressionCodecNone, AvroCompressionCodecSnappy, AvroCompressionCodecXz}
}

// AzureFunctionActivityMethod enumerates the values for azure function activity method.
type AzureFunctionActivityMethod string

const (
	// AzureFunctionActivityMethodDELETE ...
	AzureFunctionActivityMethodDELETE AzureFunctionActivityMethod = "DELETE"
	// AzureFunctionActivityMethodGET ...
	AzureFunctionActivityMethodGET AzureFunctionActivityMethod = "GET"
	// AzureFunctionActivityMethodHEAD ...
	AzureFunctionActivityMethodHEAD AzureFunctionActivityMethod = "HEAD"
	// AzureFunctionActivityMethodOPTIONS ...
	AzureFunctionActivityMethodOPTIONS AzureFunctionActivityMethod = "OPTIONS"
	// AzureFunctionActivityMethodPOST ...
	AzureFunctionActivityMethodPOST AzureFunctionActivityMethod = "POST"
	// AzureFunctionActivityMethodPUT ...
	AzureFunctionActivityMethodPUT AzureFunctionActivityMethod = "PUT"
	// AzureFunctionActivityMethodTRACE ...
	AzureFunctionActivityMethodTRACE AzureFunctionActivityMethod = "TRACE"
)

// PossibleAzureFunctionActivityMethodValues returns an array of possible values for the AzureFunctionActivityMethod const type.
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return []AzureFunctionActivityMethod{AzureFunctionActivityMethodDELETE, AzureFunctionActivityMethodGET, AzureFunctionActivityMethodHEAD, AzureFunctionActivityMethodOPTIONS, AzureFunctionActivityMethodPOST, AzureFunctionActivityMethodPUT, AzureFunctionActivityMethodTRACE}
}

// AzureSearchIndexWriteBehaviorType enumerates the values for azure search index write behavior type.
type AzureSearchIndexWriteBehaviorType string

const (
	// AzureSearchIndexWriteBehaviorTypeMerge ...
	AzureSearchIndexWriteBehaviorTypeMerge AzureSearchIndexWriteBehaviorType = "Merge"
	// AzureSearchIndexWriteBehaviorTypeUpload ...
	AzureSearchIndexWriteBehaviorTypeUpload AzureSearchIndexWriteBehaviorType = "Upload"
)

// PossibleAzureSearchIndexWriteBehaviorTypeValues returns an array of possible values for the AzureSearchIndexWriteBehaviorType const type.
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return []AzureSearchIndexWriteBehaviorType{AzureSearchIndexWriteBehaviorTypeMerge, AzureSearchIndexWriteBehaviorTypeUpload}
}

// BlobEventTypes enumerates the values for blob event types.
type BlobEventTypes string

const (
	// BlobEventTypesMicrosoftStorageBlobCreated ...
	BlobEventTypesMicrosoftStorageBlobCreated BlobEventTypes = "Microsoft.Storage.BlobCreated"
	// BlobEventTypesMicrosoftStorageBlobDeleted ...
	BlobEventTypesMicrosoftStorageBlobDeleted BlobEventTypes = "Microsoft.Storage.BlobDeleted"
)

// PossibleBlobEventTypesValues returns an array of possible values for the BlobEventTypes const type.
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return []BlobEventTypes{BlobEventTypesMicrosoftStorageBlobCreated, BlobEventTypesMicrosoftStorageBlobDeleted}
}

// CassandraSourceReadConsistencyLevels enumerates the values for cassandra source read consistency levels.
type CassandraSourceReadConsistencyLevels string

const (
	// CassandraSourceReadConsistencyLevelsALL ...
	CassandraSourceReadConsistencyLevelsALL CassandraSourceReadConsistencyLevels = "ALL"
	// CassandraSourceReadConsistencyLevelsEACHQUORUM ...
	CassandraSourceReadConsistencyLevelsEACHQUORUM CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	// CassandraSourceReadConsistencyLevelsLOCALONE ...
	CassandraSourceReadConsistencyLevelsLOCALONE CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	// CassandraSourceReadConsistencyLevelsLOCALQUORUM ...
	CassandraSourceReadConsistencyLevelsLOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	// CassandraSourceReadConsistencyLevelsLOCALSERIAL ...
	CassandraSourceReadConsistencyLevelsLOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	// CassandraSourceReadConsistencyLevelsONE ...
	CassandraSourceReadConsistencyLevelsONE CassandraSourceReadConsistencyLevels = "ONE"
	// CassandraSourceReadConsistencyLevelsQUORUM ...
	CassandraSourceReadConsistencyLevelsQUORUM CassandraSourceReadConsistencyLevels = "QUORUM"
	// CassandraSourceReadConsistencyLevelsSERIAL ...
	CassandraSourceReadConsistencyLevelsSERIAL CassandraSourceReadConsistencyLevels = "SERIAL"
	// CassandraSourceReadConsistencyLevelsTHREE ...
	CassandraSourceReadConsistencyLevelsTHREE CassandraSourceReadConsistencyLevels = "THREE"
	// CassandraSourceReadConsistencyLevelsTWO ...
	CassandraSourceReadConsistencyLevelsTWO CassandraSourceReadConsistencyLevels = "TWO"
)

// PossibleCassandraSourceReadConsistencyLevelsValues returns an array of possible values for the CassandraSourceReadConsistencyLevels const type.
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return []CassandraSourceReadConsistencyLevels{CassandraSourceReadConsistencyLevelsALL, CassandraSourceReadConsistencyLevelsEACHQUORUM, CassandraSourceReadConsistencyLevelsLOCALONE, CassandraSourceReadConsistencyLevelsLOCALQUORUM, CassandraSourceReadConsistencyLevelsLOCALSERIAL, CassandraSourceReadConsistencyLevelsONE, CassandraSourceReadConsistencyLevelsQUORUM, CassandraSourceReadConsistencyLevelsSERIAL, CassandraSourceReadConsistencyLevelsTHREE, CassandraSourceReadConsistencyLevelsTWO}
}

// CompressionCodec enumerates the values for compression codec.
type CompressionCodec string

const (
	// CompressionCodecBzip2 ...
	CompressionCodecBzip2 CompressionCodec = "bzip2"
	// CompressionCodecDeflate ...
	CompressionCodecDeflate CompressionCodec = "deflate"
	// CompressionCodecGzip ...
	CompressionCodecGzip CompressionCodec = "gzip"
	// CompressionCodecLz4 ...
	CompressionCodecLz4 CompressionCodec = "lz4"
	// CompressionCodecLzo ...
	CompressionCodecLzo CompressionCodec = "lzo"
	// CompressionCodecNone ...
	CompressionCodecNone CompressionCodec = "none"
	// CompressionCodecSnappy ...
	CompressionCodecSnappy CompressionCodec = "snappy"
	// CompressionCodecTar ...
	CompressionCodecTar CompressionCodec = "tar"
	// CompressionCodecTarGZip ...
	CompressionCodecTarGZip CompressionCodec = "tarGZip"
	// CompressionCodecZipDeflate ...
	CompressionCodecZipDeflate CompressionCodec = "zipDeflate"
)

// PossibleCompressionCodecValues returns an array of possible values for the CompressionCodec const type.
func PossibleCompressionCodecValues() []CompressionCodec {
	return []CompressionCodec{CompressionCodecBzip2, CompressionCodecDeflate, CompressionCodecGzip, CompressionCodecLz4, CompressionCodecLzo, CompressionCodecNone, CompressionCodecSnappy, CompressionCodecTar, CompressionCodecTarGZip, CompressionCodecZipDeflate}
}

// CopyBehaviorType enumerates the values for copy behavior type.
type CopyBehaviorType string

const (
	// CopyBehaviorTypeFlattenHierarchy ...
	CopyBehaviorTypeFlattenHierarchy CopyBehaviorType = "FlattenHierarchy"
	// CopyBehaviorTypeMergeFiles ...
	CopyBehaviorTypeMergeFiles CopyBehaviorType = "MergeFiles"
	// CopyBehaviorTypePreserveHierarchy ...
	CopyBehaviorTypePreserveHierarchy CopyBehaviorType = "PreserveHierarchy"
)

// PossibleCopyBehaviorTypeValues returns an array of possible values for the CopyBehaviorType const type.
func PossibleCopyBehaviorTypeValues() []CopyBehaviorType {
	return []CopyBehaviorType{CopyBehaviorTypeFlattenHierarchy, CopyBehaviorTypeMergeFiles, CopyBehaviorTypePreserveHierarchy}
}

// CosmosDbConnectionMode enumerates the values for cosmos db connection mode.
type CosmosDbConnectionMode string

const (
	// CosmosDbConnectionModeDirect ...
	CosmosDbConnectionModeDirect CosmosDbConnectionMode = "Direct"
	// CosmosDbConnectionModeGateway ...
	CosmosDbConnectionModeGateway CosmosDbConnectionMode = "Gateway"
)

// PossibleCosmosDbConnectionModeValues returns an array of possible values for the CosmosDbConnectionMode const type.
func PossibleCosmosDbConnectionModeValues() []CosmosDbConnectionMode {
	return []CosmosDbConnectionMode{CosmosDbConnectionModeDirect, CosmosDbConnectionModeGateway}
}

// CosmosDbServicePrincipalCredentialType enumerates the values for cosmos db service principal credential
// type.
type CosmosDbServicePrincipalCredentialType string

const (
	// CosmosDbServicePrincipalCredentialTypeServicePrincipalCert ...
	CosmosDbServicePrincipalCredentialTypeServicePrincipalCert CosmosDbServicePrincipalCredentialType = "ServicePrincipalCert"
	// CosmosDbServicePrincipalCredentialTypeServicePrincipalKey ...
	CosmosDbServicePrincipalCredentialTypeServicePrincipalKey CosmosDbServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleCosmosDbServicePrincipalCredentialTypeValues returns an array of possible values for the CosmosDbServicePrincipalCredentialType const type.
func PossibleCosmosDbServicePrincipalCredentialTypeValues() []CosmosDbServicePrincipalCredentialType {
	return []CosmosDbServicePrincipalCredentialType{CosmosDbServicePrincipalCredentialTypeServicePrincipalCert, CosmosDbServicePrincipalCredentialTypeServicePrincipalKey}
}

// DataFlowComputeType enumerates the values for data flow compute type.
type DataFlowComputeType string

const (
	// DataFlowComputeTypeComputeOptimized ...
	DataFlowComputeTypeComputeOptimized DataFlowComputeType = "ComputeOptimized"
	// DataFlowComputeTypeGeneral ...
	DataFlowComputeTypeGeneral DataFlowComputeType = "General"
	// DataFlowComputeTypeMemoryOptimized ...
	DataFlowComputeTypeMemoryOptimized DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns an array of possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{DataFlowComputeTypeComputeOptimized, DataFlowComputeTypeGeneral, DataFlowComputeTypeMemoryOptimized}
}

// DataFlowDebugCommandType enumerates the values for data flow debug command type.
type DataFlowDebugCommandType string

const (
	// DataFlowDebugCommandTypeExecuteExpressionQuery ...
	DataFlowDebugCommandTypeExecuteExpressionQuery DataFlowDebugCommandType = "executeExpressionQuery"
	// DataFlowDebugCommandTypeExecutePreviewQuery ...
	DataFlowDebugCommandTypeExecutePreviewQuery DataFlowDebugCommandType = "executePreviewQuery"
	// DataFlowDebugCommandTypeExecuteStatisticsQuery ...
	DataFlowDebugCommandTypeExecuteStatisticsQuery DataFlowDebugCommandType = "executeStatisticsQuery"
)

// PossibleDataFlowDebugCommandTypeValues returns an array of possible values for the DataFlowDebugCommandType const type.
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return []DataFlowDebugCommandType{DataFlowDebugCommandTypeExecuteExpressionQuery, DataFlowDebugCommandTypeExecutePreviewQuery, DataFlowDebugCommandTypeExecuteStatisticsQuery}
}

// DatasetCompressionLevel enumerates the values for dataset compression level.
type DatasetCompressionLevel string

const (
	// DatasetCompressionLevelFastest ...
	DatasetCompressionLevelFastest DatasetCompressionLevel = "Fastest"
	// DatasetCompressionLevelOptimal ...
	DatasetCompressionLevelOptimal DatasetCompressionLevel = "Optimal"
)

// PossibleDatasetCompressionLevelValues returns an array of possible values for the DatasetCompressionLevel const type.
func PossibleDatasetCompressionLevelValues() []DatasetCompressionLevel {
	return []DatasetCompressionLevel{DatasetCompressionLevelFastest, DatasetCompressionLevelOptimal}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// DayOfWeekFriday ...
	DayOfWeekFriday DayOfWeek = "Friday"
	// DayOfWeekMonday ...
	DayOfWeekMonday DayOfWeek = "Monday"
	// DayOfWeekSaturday ...
	DayOfWeekSaturday DayOfWeek = "Saturday"
	// DayOfWeekSunday ...
	DayOfWeekSunday DayOfWeek = "Sunday"
	// DayOfWeekThursday ...
	DayOfWeekThursday DayOfWeek = "Thursday"
	// DayOfWeekTuesday ...
	DayOfWeekTuesday DayOfWeek = "Tuesday"
	// DayOfWeekWednesday ...
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{DayOfWeekFriday, DayOfWeekMonday, DayOfWeekSaturday, DayOfWeekSunday, DayOfWeekThursday, DayOfWeekTuesday, DayOfWeekWednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// Db2AuthenticationType enumerates the values for db 2 authentication type.
type Db2AuthenticationType string

const (
	// Db2AuthenticationTypeBasic ...
	Db2AuthenticationTypeBasic Db2AuthenticationType = "Basic"
)

// PossibleDb2AuthenticationTypeValues returns an array of possible values for the Db2AuthenticationType const type.
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return []Db2AuthenticationType{Db2AuthenticationTypeBasic}
}

// DependencyCondition enumerates the values for dependency condition.
type DependencyCondition string

const (
	// DependencyConditionCompleted ...
	DependencyConditionCompleted DependencyCondition = "Completed"
	// DependencyConditionFailed ...
	DependencyConditionFailed DependencyCondition = "Failed"
	// DependencyConditionSkipped ...
	DependencyConditionSkipped DependencyCondition = "Skipped"
	// DependencyConditionSucceeded ...
	DependencyConditionSucceeded DependencyCondition = "Succeeded"
)

// PossibleDependencyConditionValues returns an array of possible values for the DependencyCondition const type.
func PossibleDependencyConditionValues() []DependencyCondition {
	return []DependencyCondition{DependencyConditionCompleted, DependencyConditionFailed, DependencyConditionSkipped, DependencyConditionSucceeded}
}

// DynamicsAuthenticationType enumerates the values for dynamics authentication type.
type DynamicsAuthenticationType string

const (
	// DynamicsAuthenticationTypeAADServicePrincipal ...
	DynamicsAuthenticationTypeAADServicePrincipal DynamicsAuthenticationType = "AADServicePrincipal"
	// DynamicsAuthenticationTypeIfd ...
	DynamicsAuthenticationTypeIfd DynamicsAuthenticationType = "Ifd"
	// DynamicsAuthenticationTypeOffice365 ...
	DynamicsAuthenticationTypeOffice365 DynamicsAuthenticationType = "Office365"
)

// PossibleDynamicsAuthenticationTypeValues returns an array of possible values for the DynamicsAuthenticationType const type.
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return []DynamicsAuthenticationType{DynamicsAuthenticationTypeAADServicePrincipal, DynamicsAuthenticationTypeIfd, DynamicsAuthenticationTypeOffice365}
}

// DynamicsDeploymentType enumerates the values for dynamics deployment type.
type DynamicsDeploymentType string

const (
	// DynamicsDeploymentTypeOnline ...
	DynamicsDeploymentTypeOnline DynamicsDeploymentType = "Online"
	// DynamicsDeploymentTypeOnPremisesWithIfd ...
	DynamicsDeploymentTypeOnPremisesWithIfd DynamicsDeploymentType = "OnPremisesWithIfd"
)

// PossibleDynamicsDeploymentTypeValues returns an array of possible values for the DynamicsDeploymentType const type.
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return []DynamicsDeploymentType{DynamicsDeploymentTypeOnline, DynamicsDeploymentTypeOnPremisesWithIfd}
}

// DynamicsSinkWriteBehavior enumerates the values for dynamics sink write behavior.
type DynamicsSinkWriteBehavior string

const (
	// DynamicsSinkWriteBehaviorUpsert ...
	DynamicsSinkWriteBehaviorUpsert DynamicsSinkWriteBehavior = "Upsert"
)

// PossibleDynamicsSinkWriteBehaviorValues returns an array of possible values for the DynamicsSinkWriteBehavior const type.
func PossibleDynamicsSinkWriteBehaviorValues() []DynamicsSinkWriteBehavior {
	return []DynamicsSinkWriteBehavior{DynamicsSinkWriteBehaviorUpsert}
}

// EventSubscriptionStatus enumerates the values for event subscription status.
type EventSubscriptionStatus string

const (
	// EventSubscriptionStatusDeprovisioning ...
	EventSubscriptionStatusDeprovisioning EventSubscriptionStatus = "Deprovisioning"
	// EventSubscriptionStatusDisabled ...
	EventSubscriptionStatusDisabled EventSubscriptionStatus = "Disabled"
	// EventSubscriptionStatusEnabled ...
	EventSubscriptionStatusEnabled EventSubscriptionStatus = "Enabled"
	// EventSubscriptionStatusProvisioning ...
	EventSubscriptionStatusProvisioning EventSubscriptionStatus = "Provisioning"
	// EventSubscriptionStatusUnknown ...
	EventSubscriptionStatusUnknown EventSubscriptionStatus = "Unknown"
)

// PossibleEventSubscriptionStatusValues returns an array of possible values for the EventSubscriptionStatus const type.
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return []EventSubscriptionStatus{EventSubscriptionStatusDeprovisioning, EventSubscriptionStatusDisabled, EventSubscriptionStatusEnabled, EventSubscriptionStatusProvisioning, EventSubscriptionStatusUnknown}
}

// FactoryIdentityType enumerates the values for factory identity type.
type FactoryIdentityType string

const (
	// FactoryIdentityTypeSystemAssigned ...
	FactoryIdentityTypeSystemAssigned FactoryIdentityType = "SystemAssigned"
	// FactoryIdentityTypeSystemAssignedUserAssigned ...
	FactoryIdentityTypeSystemAssignedUserAssigned FactoryIdentityType = "SystemAssigned,UserAssigned"
	// FactoryIdentityTypeUserAssigned ...
	FactoryIdentityTypeUserAssigned FactoryIdentityType = "UserAssigned"
)

// PossibleFactoryIdentityTypeValues returns an array of possible values for the FactoryIdentityType const type.
func PossibleFactoryIdentityTypeValues() []FactoryIdentityType {
	return []FactoryIdentityType{FactoryIdentityTypeSystemAssigned, FactoryIdentityTypeSystemAssignedUserAssigned, FactoryIdentityTypeUserAssigned}
}

// FtpAuthenticationType enumerates the values for ftp authentication type.
type FtpAuthenticationType string

const (
	// FtpAuthenticationTypeAnonymous ...
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	// FtpAuthenticationTypeBasic ...
	FtpAuthenticationTypeBasic FtpAuthenticationType = "Basic"
)

// PossibleFtpAuthenticationTypeValues returns an array of possible values for the FtpAuthenticationType const type.
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return []FtpAuthenticationType{FtpAuthenticationTypeAnonymous, FtpAuthenticationTypeBasic}
}

// GlobalParameterType enumerates the values for global parameter type.
type GlobalParameterType string

const (
	// GlobalParameterTypeArray ...
	GlobalParameterTypeArray GlobalParameterType = "Array"
	// GlobalParameterTypeBool ...
	GlobalParameterTypeBool GlobalParameterType = "Bool"
	// GlobalParameterTypeFloat ...
	GlobalParameterTypeFloat GlobalParameterType = "Float"
	// GlobalParameterTypeInt ...
	GlobalParameterTypeInt GlobalParameterType = "Int"
	// GlobalParameterTypeObject ...
	GlobalParameterTypeObject GlobalParameterType = "Object"
	// GlobalParameterTypeString ...
	GlobalParameterTypeString GlobalParameterType = "String"
)

// PossibleGlobalParameterTypeValues returns an array of possible values for the GlobalParameterType const type.
func PossibleGlobalParameterTypeValues() []GlobalParameterType {
	return []GlobalParameterType{GlobalParameterTypeArray, GlobalParameterTypeBool, GlobalParameterTypeFloat, GlobalParameterTypeInt, GlobalParameterTypeObject, GlobalParameterTypeString}
}

// GoogleAdWordsAuthenticationType enumerates the values for google ad words authentication type.
type GoogleAdWordsAuthenticationType string

const (
	// GoogleAdWordsAuthenticationTypeServiceAuthentication ...
	GoogleAdWordsAuthenticationTypeServiceAuthentication GoogleAdWordsAuthenticationType = "ServiceAuthentication"
	// GoogleAdWordsAuthenticationTypeUserAuthentication ...
	GoogleAdWordsAuthenticationTypeUserAuthentication GoogleAdWordsAuthenticationType = "UserAuthentication"
)

// PossibleGoogleAdWordsAuthenticationTypeValues returns an array of possible values for the GoogleAdWordsAuthenticationType const type.
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return []GoogleAdWordsAuthenticationType{GoogleAdWordsAuthenticationTypeServiceAuthentication, GoogleAdWordsAuthenticationTypeUserAuthentication}
}

// GoogleBigQueryAuthenticationType enumerates the values for google big query authentication type.
type GoogleBigQueryAuthenticationType string

const (
	// GoogleBigQueryAuthenticationTypeServiceAuthentication ...
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	// GoogleBigQueryAuthenticationTypeUserAuthentication ...
	GoogleBigQueryAuthenticationTypeUserAuthentication GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// PossibleGoogleBigQueryAuthenticationTypeValues returns an array of possible values for the GoogleBigQueryAuthenticationType const type.
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return []GoogleBigQueryAuthenticationType{GoogleBigQueryAuthenticationTypeServiceAuthentication, GoogleBigQueryAuthenticationTypeUserAuthentication}
}

// HBaseAuthenticationType enumerates the values for h base authentication type.
type HBaseAuthenticationType string

const (
	// HBaseAuthenticationTypeAnonymous ...
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	// HBaseAuthenticationTypeBasic ...
	HBaseAuthenticationTypeBasic HBaseAuthenticationType = "Basic"
)

// PossibleHBaseAuthenticationTypeValues returns an array of possible values for the HBaseAuthenticationType const type.
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return []HBaseAuthenticationType{HBaseAuthenticationTypeAnonymous, HBaseAuthenticationTypeBasic}
}

// HdiNodeTypes enumerates the values for hdi node types.
type HdiNodeTypes string

const (
	// HdiNodeTypesHeadnode ...
	HdiNodeTypesHeadnode HdiNodeTypes = "Headnode"
	// HdiNodeTypesWorkernode ...
	HdiNodeTypesWorkernode HdiNodeTypes = "Workernode"
	// HdiNodeTypesZookeeper ...
	HdiNodeTypesZookeeper HdiNodeTypes = "Zookeeper"
)

// PossibleHdiNodeTypesValues returns an array of possible values for the HdiNodeTypes const type.
func PossibleHdiNodeTypesValues() []HdiNodeTypes {
	return []HdiNodeTypes{HdiNodeTypesHeadnode, HdiNodeTypesWorkernode, HdiNodeTypesZookeeper}
}

// HDInsightActivityDebugInfoOption enumerates the values for hd insight activity debug info option.
type HDInsightActivityDebugInfoOption string

const (
	// HDInsightActivityDebugInfoOptionAlways ...
	HDInsightActivityDebugInfoOptionAlways HDInsightActivityDebugInfoOption = "Always"
	// HDInsightActivityDebugInfoOptionFailure ...
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = "Failure"
	// HDInsightActivityDebugInfoOptionNone ...
	HDInsightActivityDebugInfoOptionNone HDInsightActivityDebugInfoOption = "None"
)

// PossibleHDInsightActivityDebugInfoOptionValues returns an array of possible values for the HDInsightActivityDebugInfoOption const type.
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return []HDInsightActivityDebugInfoOption{HDInsightActivityDebugInfoOptionAlways, HDInsightActivityDebugInfoOptionFailure, HDInsightActivityDebugInfoOptionNone}
}

// HiveAuthenticationType enumerates the values for hive authentication type.
type HiveAuthenticationType string

const (
	// HiveAuthenticationTypeAnonymous ...
	HiveAuthenticationTypeAnonymous HiveAuthenticationType = "Anonymous"
	// HiveAuthenticationTypeUsername ...
	HiveAuthenticationTypeUsername HiveAuthenticationType = "Username"
	// HiveAuthenticationTypeUsernameAndPassword ...
	HiveAuthenticationTypeUsernameAndPassword HiveAuthenticationType = "UsernameAndPassword"
	// HiveAuthenticationTypeWindowsAzureHDInsightService ...
	HiveAuthenticationTypeWindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleHiveAuthenticationTypeValues returns an array of possible values for the HiveAuthenticationType const type.
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return []HiveAuthenticationType{HiveAuthenticationTypeAnonymous, HiveAuthenticationTypeUsername, HiveAuthenticationTypeUsernameAndPassword, HiveAuthenticationTypeWindowsAzureHDInsightService}
}

// HiveServerType enumerates the values for hive server type.
type HiveServerType string

const (
	// HiveServerTypeHiveServer1 ...
	HiveServerTypeHiveServer1 HiveServerType = "HiveServer1"
	// HiveServerTypeHiveServer2 ...
	HiveServerTypeHiveServer2 HiveServerType = "HiveServer2"
	// HiveServerTypeHiveThriftServer ...
	HiveServerTypeHiveThriftServer HiveServerType = "HiveThriftServer"
)

// PossibleHiveServerTypeValues returns an array of possible values for the HiveServerType const type.
func PossibleHiveServerTypeValues() []HiveServerType {
	return []HiveServerType{HiveServerTypeHiveServer1, HiveServerTypeHiveServer2, HiveServerTypeHiveThriftServer}
}

// HiveThriftTransportProtocol enumerates the values for hive thrift transport protocol.
type HiveThriftTransportProtocol string

const (
	// HiveThriftTransportProtocolBinary ...
	HiveThriftTransportProtocolBinary HiveThriftTransportProtocol = "Binary"
	// HiveThriftTransportProtocolHTTP ...
	HiveThriftTransportProtocolHTTP HiveThriftTransportProtocol = "HTTP "
	// HiveThriftTransportProtocolSASL ...
	HiveThriftTransportProtocolSASL HiveThriftTransportProtocol = "SASL"
)

// PossibleHiveThriftTransportProtocolValues returns an array of possible values for the HiveThriftTransportProtocol const type.
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return []HiveThriftTransportProtocol{HiveThriftTransportProtocolBinary, HiveThriftTransportProtocolHTTP, HiveThriftTransportProtocolSASL}
}

// HTTPAuthenticationType enumerates the values for http authentication type.
type HTTPAuthenticationType string

const (
	// HTTPAuthenticationTypeAnonymous ...
	HTTPAuthenticationTypeAnonymous HTTPAuthenticationType = "Anonymous"
	// HTTPAuthenticationTypeBasic ...
	HTTPAuthenticationTypeBasic HTTPAuthenticationType = "Basic"
	// HTTPAuthenticationTypeClientCertificate ...
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	// HTTPAuthenticationTypeDigest ...
	HTTPAuthenticationTypeDigest HTTPAuthenticationType = "Digest"
	// HTTPAuthenticationTypeWindows ...
	HTTPAuthenticationTypeWindows HTTPAuthenticationType = "Windows"
)

// PossibleHTTPAuthenticationTypeValues returns an array of possible values for the HTTPAuthenticationType const type.
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return []HTTPAuthenticationType{HTTPAuthenticationTypeAnonymous, HTTPAuthenticationTypeBasic, HTTPAuthenticationTypeClientCertificate, HTTPAuthenticationTypeDigest, HTTPAuthenticationTypeWindows}
}

// ImpalaAuthenticationType enumerates the values for impala authentication type.
type ImpalaAuthenticationType string

const (
	// ImpalaAuthenticationTypeAnonymous ...
	ImpalaAuthenticationTypeAnonymous ImpalaAuthenticationType = "Anonymous"
	// ImpalaAuthenticationTypeSASLUsername ...
	ImpalaAuthenticationTypeSASLUsername ImpalaAuthenticationType = "SASLUsername"
	// ImpalaAuthenticationTypeUsernameAndPassword ...
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// PossibleImpalaAuthenticationTypeValues returns an array of possible values for the ImpalaAuthenticationType const type.
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return []ImpalaAuthenticationType{ImpalaAuthenticationTypeAnonymous, ImpalaAuthenticationTypeSASLUsername, ImpalaAuthenticationTypeUsernameAndPassword}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// IntegrationRuntimeAuthKeyNameAuthKey1 ...
	IntegrationRuntimeAuthKeyNameAuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// IntegrationRuntimeAuthKeyNameAuthKey2 ...
	IntegrationRuntimeAuthKeyNameAuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{IntegrationRuntimeAuthKeyNameAuthKey1, IntegrationRuntimeAuthKeyNameAuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// IntegrationRuntimeAutoUpdateOff ...
	IntegrationRuntimeAutoUpdateOff IntegrationRuntimeAutoUpdate = "Off"
	// IntegrationRuntimeAutoUpdateOn ...
	IntegrationRuntimeAutoUpdateOn IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{IntegrationRuntimeAutoUpdateOff, IntegrationRuntimeAutoUpdateOn}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// IntegrationRuntimeEditionEnterprise ...
	IntegrationRuntimeEditionEnterprise IntegrationRuntimeEdition = "Enterprise"
	// IntegrationRuntimeEditionStandard ...
	IntegrationRuntimeEditionStandard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{IntegrationRuntimeEditionEnterprise, IntegrationRuntimeEditionStandard}
}

// IntegrationRuntimeEntityReferenceType enumerates the values for integration runtime entity reference type.
type IntegrationRuntimeEntityReferenceType string

const (
	// IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference ...
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	// IntegrationRuntimeEntityReferenceTypeLinkedServiceReference ...
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns an array of possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference, IntegrationRuntimeEntityReferenceTypeLinkedServiceReference}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted ...
	IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// IntegrationRuntimeInternalChannelEncryptionModeNotSet ...
	IntegrationRuntimeInternalChannelEncryptionModeNotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted ...
	IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted, IntegrationRuntimeInternalChannelEncryptionModeNotSet, IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// IntegrationRuntimeLicenseTypeBasePrice ...
	IntegrationRuntimeLicenseTypeBasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// IntegrationRuntimeLicenseTypeLicenseIncluded ...
	IntegrationRuntimeLicenseTypeLicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{IntegrationRuntimeLicenseTypeBasePrice, IntegrationRuntimeLicenseTypeLicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// IntegrationRuntimeStateAccessDenied ...
	IntegrationRuntimeStateAccessDenied IntegrationRuntimeState = "AccessDenied"
	// IntegrationRuntimeStateInitial ...
	IntegrationRuntimeStateInitial IntegrationRuntimeState = "Initial"
	// IntegrationRuntimeStateLimited ...
	IntegrationRuntimeStateLimited IntegrationRuntimeState = "Limited"
	// IntegrationRuntimeStateNeedRegistration ...
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// IntegrationRuntimeStateOffline ...
	IntegrationRuntimeStateOffline IntegrationRuntimeState = "Offline"
	// IntegrationRuntimeStateOnline ...
	IntegrationRuntimeStateOnline IntegrationRuntimeState = "Online"
	// IntegrationRuntimeStateStarted ...
	IntegrationRuntimeStateStarted IntegrationRuntimeState = "Started"
	// IntegrationRuntimeStateStarting ...
	IntegrationRuntimeStateStarting IntegrationRuntimeState = "Starting"
	// IntegrationRuntimeStateStopped ...
	IntegrationRuntimeStateStopped IntegrationRuntimeState = "Stopped"
	// IntegrationRuntimeStateStopping ...
	IntegrationRuntimeStateStopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{IntegrationRuntimeStateAccessDenied, IntegrationRuntimeStateInitial, IntegrationRuntimeStateLimited, IntegrationRuntimeStateNeedRegistration, IntegrationRuntimeStateOffline, IntegrationRuntimeStateOnline, IntegrationRuntimeStateStarted, IntegrationRuntimeStateStarting, IntegrationRuntimeStateStopped, IntegrationRuntimeStateStopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// IntegrationRuntimeTypeManaged ...
	IntegrationRuntimeTypeManaged IntegrationRuntimeType = "Managed"
	// IntegrationRuntimeTypeSelfHosted ...
	IntegrationRuntimeTypeSelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{IntegrationRuntimeTypeManaged, IntegrationRuntimeTypeSelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// IntegrationRuntimeUpdateResultFail ...
	IntegrationRuntimeUpdateResultFail IntegrationRuntimeUpdateResult = "Fail"
	// IntegrationRuntimeUpdateResultNone ...
	IntegrationRuntimeUpdateResultNone IntegrationRuntimeUpdateResult = "None"
	// IntegrationRuntimeUpdateResultSucceed ...
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{IntegrationRuntimeUpdateResultFail, IntegrationRuntimeUpdateResultNone, IntegrationRuntimeUpdateResultSucceed}
}

// JSONFormatFilePattern enumerates the values for json format file pattern.
type JSONFormatFilePattern string

const (
	// JSONFormatFilePatternArrayOfObjects ...
	JSONFormatFilePatternArrayOfObjects JSONFormatFilePattern = "arrayOfObjects"
	// JSONFormatFilePatternSetOfObjects ...
	JSONFormatFilePatternSetOfObjects JSONFormatFilePattern = "setOfObjects"
)

// PossibleJSONFormatFilePatternValues returns an array of possible values for the JSONFormatFilePattern const type.
func PossibleJSONFormatFilePatternValues() []JSONFormatFilePattern {
	return []JSONFormatFilePattern{JSONFormatFilePatternArrayOfObjects, JSONFormatFilePatternSetOfObjects}
}

// JSONWriteFilePattern enumerates the values for json write file pattern.
type JSONWriteFilePattern string

const (
	// JSONWriteFilePatternArrayOfObjects ...
	JSONWriteFilePatternArrayOfObjects JSONWriteFilePattern = "arrayOfObjects"
	// JSONWriteFilePatternSetOfObjects ...
	JSONWriteFilePatternSetOfObjects JSONWriteFilePattern = "setOfObjects"
)

// PossibleJSONWriteFilePatternValues returns an array of possible values for the JSONWriteFilePattern const type.
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return []JSONWriteFilePattern{JSONWriteFilePatternArrayOfObjects, JSONWriteFilePatternSetOfObjects}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// ManagedIntegrationRuntimeNodeStatusAvailable ...
	ManagedIntegrationRuntimeNodeStatusAvailable ManagedIntegrationRuntimeNodeStatus = "Available"
	// ManagedIntegrationRuntimeNodeStatusRecycling ...
	ManagedIntegrationRuntimeNodeStatusRecycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// ManagedIntegrationRuntimeNodeStatusStarting ...
	ManagedIntegrationRuntimeNodeStatusStarting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// ManagedIntegrationRuntimeNodeStatusUnavailable ...
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{ManagedIntegrationRuntimeNodeStatusAvailable, ManagedIntegrationRuntimeNodeStatusRecycling, ManagedIntegrationRuntimeNodeStatusStarting, ManagedIntegrationRuntimeNodeStatusUnavailable}
}

// MongoDbAuthenticationType enumerates the values for mongo db authentication type.
type MongoDbAuthenticationType string

const (
	// MongoDbAuthenticationTypeAnonymous ...
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	// MongoDbAuthenticationTypeBasic ...
	MongoDbAuthenticationTypeBasic MongoDbAuthenticationType = "Basic"
)

// PossibleMongoDbAuthenticationTypeValues returns an array of possible values for the MongoDbAuthenticationType const type.
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return []MongoDbAuthenticationType{MongoDbAuthenticationTypeAnonymous, MongoDbAuthenticationTypeBasic}
}

// NetezzaPartitionOption enumerates the values for netezza partition option.
type NetezzaPartitionOption string

const (
	// NetezzaPartitionOptionDataSlice ...
	NetezzaPartitionOptionDataSlice NetezzaPartitionOption = "DataSlice"
	// NetezzaPartitionOptionDynamicRange ...
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = "DynamicRange"
	// NetezzaPartitionOptionNone ...
	NetezzaPartitionOptionNone NetezzaPartitionOption = "None"
)

// PossibleNetezzaPartitionOptionValues returns an array of possible values for the NetezzaPartitionOption const type.
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return []NetezzaPartitionOption{NetezzaPartitionOptionDataSlice, NetezzaPartitionOptionDynamicRange, NetezzaPartitionOptionNone}
}

// ODataAadServicePrincipalCredentialType enumerates the values for o data aad service principal credential
// type.
type ODataAadServicePrincipalCredentialType string

const (
	// ODataAadServicePrincipalCredentialTypeServicePrincipalCert ...
	ODataAadServicePrincipalCredentialTypeServicePrincipalCert ODataAadServicePrincipalCredentialType = "ServicePrincipalCert"
	// ODataAadServicePrincipalCredentialTypeServicePrincipalKey ...
	ODataAadServicePrincipalCredentialTypeServicePrincipalKey ODataAadServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleODataAadServicePrincipalCredentialTypeValues returns an array of possible values for the ODataAadServicePrincipalCredentialType const type.
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return []ODataAadServicePrincipalCredentialType{ODataAadServicePrincipalCredentialTypeServicePrincipalCert, ODataAadServicePrincipalCredentialTypeServicePrincipalKey}
}

// ODataAuthenticationType enumerates the values for o data authentication type.
type ODataAuthenticationType string

const (
	// ODataAuthenticationTypeAadServicePrincipal ...
	ODataAuthenticationTypeAadServicePrincipal ODataAuthenticationType = "AadServicePrincipal"
	// ODataAuthenticationTypeAnonymous ...
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = "Anonymous"
	// ODataAuthenticationTypeBasic ...
	ODataAuthenticationTypeBasic ODataAuthenticationType = "Basic"
	// ODataAuthenticationTypeManagedServiceIdentity ...
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = "ManagedServiceIdentity"
	// ODataAuthenticationTypeWindows ...
	ODataAuthenticationTypeWindows ODataAuthenticationType = "Windows"
)

// PossibleODataAuthenticationTypeValues returns an array of possible values for the ODataAuthenticationType const type.
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return []ODataAuthenticationType{ODataAuthenticationTypeAadServicePrincipal, ODataAuthenticationTypeAnonymous, ODataAuthenticationTypeBasic, ODataAuthenticationTypeManagedServiceIdentity, ODataAuthenticationTypeWindows}
}

// OraclePartitionOption enumerates the values for oracle partition option.
type OraclePartitionOption string

const (
	// OraclePartitionOptionDynamicRange ...
	OraclePartitionOptionDynamicRange OraclePartitionOption = "DynamicRange"
	// OraclePartitionOptionNone ...
	OraclePartitionOptionNone OraclePartitionOption = "None"
	// OraclePartitionOptionPhysicalPartitionsOfTable ...
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleOraclePartitionOptionValues returns an array of possible values for the OraclePartitionOption const type.
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return []OraclePartitionOption{OraclePartitionOptionDynamicRange, OraclePartitionOptionNone, OraclePartitionOptionPhysicalPartitionsOfTable}
}

// OrcCompressionCodec enumerates the values for orc compression codec.
type OrcCompressionCodec string

const (
	// OrcCompressionCodecLzo ...
	OrcCompressionCodecLzo OrcCompressionCodec = "lzo"
	// OrcCompressionCodecNone ...
	OrcCompressionCodecNone OrcCompressionCodec = "none"
	// OrcCompressionCodecSnappy ...
	OrcCompressionCodecSnappy OrcCompressionCodec = "snappy"
	// OrcCompressionCodecZlib ...
	OrcCompressionCodecZlib OrcCompressionCodec = "zlib"
)

// PossibleOrcCompressionCodecValues returns an array of possible values for the OrcCompressionCodec const type.
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return []OrcCompressionCodec{OrcCompressionCodecLzo, OrcCompressionCodecNone, OrcCompressionCodecSnappy, OrcCompressionCodecZlib}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeObject, ParameterTypeSecureString, ParameterTypeString}
}

// PhoenixAuthenticationType enumerates the values for phoenix authentication type.
type PhoenixAuthenticationType string

const (
	// PhoenixAuthenticationTypeAnonymous ...
	PhoenixAuthenticationTypeAnonymous PhoenixAuthenticationType = "Anonymous"
	// PhoenixAuthenticationTypeUsernameAndPassword ...
	PhoenixAuthenticationTypeUsernameAndPassword PhoenixAuthenticationType = "UsernameAndPassword"
	// PhoenixAuthenticationTypeWindowsAzureHDInsightService ...
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PossiblePhoenixAuthenticationTypeValues returns an array of possible values for the PhoenixAuthenticationType const type.
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return []PhoenixAuthenticationType{PhoenixAuthenticationTypeAnonymous, PhoenixAuthenticationTypeUsernameAndPassword, PhoenixAuthenticationTypeWindowsAzureHDInsightService}
}

// PolybaseSettingsRejectType enumerates the values for polybase settings reject type.
type PolybaseSettingsRejectType string

const (
	// PolybaseSettingsRejectTypePercentage ...
	PolybaseSettingsRejectTypePercentage PolybaseSettingsRejectType = "percentage"
	// PolybaseSettingsRejectTypeValue ...
	PolybaseSettingsRejectTypeValue PolybaseSettingsRejectType = "value"
)

// PossiblePolybaseSettingsRejectTypeValues returns an array of possible values for the PolybaseSettingsRejectType const type.
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return []PolybaseSettingsRejectType{PolybaseSettingsRejectTypePercentage, PolybaseSettingsRejectTypeValue}
}

// PrestoAuthenticationType enumerates the values for presto authentication type.
type PrestoAuthenticationType string

const (
	// PrestoAuthenticationTypeAnonymous ...
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	// PrestoAuthenticationTypeLDAP ...
	PrestoAuthenticationTypeLDAP PrestoAuthenticationType = "LDAP"
)

// PossiblePrestoAuthenticationTypeValues returns an array of possible values for the PrestoAuthenticationType const type.
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return []PrestoAuthenticationType{PrestoAuthenticationTypeAnonymous, PrestoAuthenticationTypeLDAP}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNotSpecified ...
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNotSpecified, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// RestServiceAuthenticationType enumerates the values for rest service authentication type.
type RestServiceAuthenticationType string

const (
	// RestServiceAuthenticationTypeAadServicePrincipal ...
	RestServiceAuthenticationTypeAadServicePrincipal RestServiceAuthenticationType = "AadServicePrincipal"
	// RestServiceAuthenticationTypeAnonymous ...
	RestServiceAuthenticationTypeAnonymous RestServiceAuthenticationType = "Anonymous"
	// RestServiceAuthenticationTypeBasic ...
	RestServiceAuthenticationTypeBasic RestServiceAuthenticationType = "Basic"
	// RestServiceAuthenticationTypeManagedServiceIdentity ...
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = "ManagedServiceIdentity"
)

// PossibleRestServiceAuthenticationTypeValues returns an array of possible values for the RestServiceAuthenticationType const type.
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return []RestServiceAuthenticationType{RestServiceAuthenticationTypeAadServicePrincipal, RestServiceAuthenticationTypeAnonymous, RestServiceAuthenticationTypeBasic, RestServiceAuthenticationTypeManagedServiceIdentity}
}

// RunQueryFilterOperand enumerates the values for run query filter operand.
type RunQueryFilterOperand string

const (
	// RunQueryFilterOperandActivityName ...
	RunQueryFilterOperandActivityName RunQueryFilterOperand = "ActivityName"
	// RunQueryFilterOperandActivityRunEnd ...
	RunQueryFilterOperandActivityRunEnd RunQueryFilterOperand = "ActivityRunEnd"
	// RunQueryFilterOperandActivityRunStart ...
	RunQueryFilterOperandActivityRunStart RunQueryFilterOperand = "ActivityRunStart"
	// RunQueryFilterOperandActivityType ...
	RunQueryFilterOperandActivityType RunQueryFilterOperand = "ActivityType"
	// RunQueryFilterOperandLatestOnly ...
	RunQueryFilterOperandLatestOnly RunQueryFilterOperand = "LatestOnly"
	// RunQueryFilterOperandPipelineName ...
	RunQueryFilterOperandPipelineName RunQueryFilterOperand = "PipelineName"
	// RunQueryFilterOperandRunEnd ...
	RunQueryFilterOperandRunEnd RunQueryFilterOperand = "RunEnd"
	// RunQueryFilterOperandRunGroupID ...
	RunQueryFilterOperandRunGroupID RunQueryFilterOperand = "RunGroupId"
	// RunQueryFilterOperandRunStart ...
	RunQueryFilterOperandRunStart RunQueryFilterOperand = "RunStart"
	// RunQueryFilterOperandStatus ...
	RunQueryFilterOperandStatus RunQueryFilterOperand = "Status"
	// RunQueryFilterOperandTriggerName ...
	RunQueryFilterOperandTriggerName RunQueryFilterOperand = "TriggerName"
	// RunQueryFilterOperandTriggerRunTimestamp ...
	RunQueryFilterOperandTriggerRunTimestamp RunQueryFilterOperand = "TriggerRunTimestamp"
)

// PossibleRunQueryFilterOperandValues returns an array of possible values for the RunQueryFilterOperand const type.
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return []RunQueryFilterOperand{RunQueryFilterOperandActivityName, RunQueryFilterOperandActivityRunEnd, RunQueryFilterOperandActivityRunStart, RunQueryFilterOperandActivityType, RunQueryFilterOperandLatestOnly, RunQueryFilterOperandPipelineName, RunQueryFilterOperandRunEnd, RunQueryFilterOperandRunGroupID, RunQueryFilterOperandRunStart, RunQueryFilterOperandStatus, RunQueryFilterOperandTriggerName, RunQueryFilterOperandTriggerRunTimestamp}
}

// RunQueryFilterOperator enumerates the values for run query filter operator.
type RunQueryFilterOperator string

const (
	// RunQueryFilterOperatorEquals ...
	RunQueryFilterOperatorEquals RunQueryFilterOperator = "Equals"
	// RunQueryFilterOperatorIn ...
	RunQueryFilterOperatorIn RunQueryFilterOperator = "In"
	// RunQueryFilterOperatorNotEquals ...
	RunQueryFilterOperatorNotEquals RunQueryFilterOperator = "NotEquals"
	// RunQueryFilterOperatorNotIn ...
	RunQueryFilterOperatorNotIn RunQueryFilterOperator = "NotIn"
)

// PossibleRunQueryFilterOperatorValues returns an array of possible values for the RunQueryFilterOperator const type.
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return []RunQueryFilterOperator{RunQueryFilterOperatorEquals, RunQueryFilterOperatorIn, RunQueryFilterOperatorNotEquals, RunQueryFilterOperatorNotIn}
}

// RunQueryOrder enumerates the values for run query order.
type RunQueryOrder string

const (
	// RunQueryOrderASC ...
	RunQueryOrderASC RunQueryOrder = "ASC"
	// RunQueryOrderDESC ...
	RunQueryOrderDESC RunQueryOrder = "DESC"
)

// PossibleRunQueryOrderValues returns an array of possible values for the RunQueryOrder const type.
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return []RunQueryOrder{RunQueryOrderASC, RunQueryOrderDESC}
}

// RunQueryOrderByField enumerates the values for run query order by field.
type RunQueryOrderByField string

const (
	// RunQueryOrderByFieldActivityName ...
	RunQueryOrderByFieldActivityName RunQueryOrderByField = "ActivityName"
	// RunQueryOrderByFieldActivityRunEnd ...
	RunQueryOrderByFieldActivityRunEnd RunQueryOrderByField = "ActivityRunEnd"
	// RunQueryOrderByFieldActivityRunStart ...
	RunQueryOrderByFieldActivityRunStart RunQueryOrderByField = "ActivityRunStart"
	// RunQueryOrderByFieldPipelineName ...
	RunQueryOrderByFieldPipelineName RunQueryOrderByField = "PipelineName"
	// RunQueryOrderByFieldRunEnd ...
	RunQueryOrderByFieldRunEnd RunQueryOrderByField = "RunEnd"
	// RunQueryOrderByFieldRunStart ...
	RunQueryOrderByFieldRunStart RunQueryOrderByField = "RunStart"
	// RunQueryOrderByFieldStatus ...
	RunQueryOrderByFieldStatus RunQueryOrderByField = "Status"
	// RunQueryOrderByFieldTriggerName ...
	RunQueryOrderByFieldTriggerName RunQueryOrderByField = "TriggerName"
	// RunQueryOrderByFieldTriggerRunTimestamp ...
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = "TriggerRunTimestamp"
)

// PossibleRunQueryOrderByFieldValues returns an array of possible values for the RunQueryOrderByField const type.
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return []RunQueryOrderByField{RunQueryOrderByFieldActivityName, RunQueryOrderByFieldActivityRunEnd, RunQueryOrderByFieldActivityRunStart, RunQueryOrderByFieldPipelineName, RunQueryOrderByFieldRunEnd, RunQueryOrderByFieldRunStart, RunQueryOrderByFieldStatus, RunQueryOrderByFieldTriggerName, RunQueryOrderByFieldTriggerRunTimestamp}
}

// SalesforceSinkWriteBehavior enumerates the values for salesforce sink write behavior.
type SalesforceSinkWriteBehavior string

const (
	// SalesforceSinkWriteBehaviorInsert ...
	SalesforceSinkWriteBehaviorInsert SalesforceSinkWriteBehavior = "Insert"
	// SalesforceSinkWriteBehaviorUpsert ...
	SalesforceSinkWriteBehaviorUpsert SalesforceSinkWriteBehavior = "Upsert"
)

// PossibleSalesforceSinkWriteBehaviorValues returns an array of possible values for the SalesforceSinkWriteBehavior const type.
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return []SalesforceSinkWriteBehavior{SalesforceSinkWriteBehaviorInsert, SalesforceSinkWriteBehaviorUpsert}
}

// SalesforceSourceReadBehavior enumerates the values for salesforce source read behavior.
type SalesforceSourceReadBehavior string

const (
	// SalesforceSourceReadBehaviorQuery ...
	SalesforceSourceReadBehaviorQuery SalesforceSourceReadBehavior = "Query"
	// SalesforceSourceReadBehaviorQueryAll ...
	SalesforceSourceReadBehaviorQueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// PossibleSalesforceSourceReadBehaviorValues returns an array of possible values for the SalesforceSourceReadBehavior const type.
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return []SalesforceSourceReadBehavior{SalesforceSourceReadBehaviorQuery, SalesforceSourceReadBehaviorQueryAll}
}

// SapCloudForCustomerSinkWriteBehavior enumerates the values for sap cloud for customer sink write behavior.
type SapCloudForCustomerSinkWriteBehavior string

const (
	// SapCloudForCustomerSinkWriteBehaviorInsert ...
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	// SapCloudForCustomerSinkWriteBehaviorUpdate ...
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// PossibleSapCloudForCustomerSinkWriteBehaviorValues returns an array of possible values for the SapCloudForCustomerSinkWriteBehavior const type.
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return []SapCloudForCustomerSinkWriteBehavior{SapCloudForCustomerSinkWriteBehaviorInsert, SapCloudForCustomerSinkWriteBehaviorUpdate}
}

// SapHanaAuthenticationType enumerates the values for sap hana authentication type.
type SapHanaAuthenticationType string

const (
	// SapHanaAuthenticationTypeBasic ...
	SapHanaAuthenticationTypeBasic SapHanaAuthenticationType = "Basic"
	// SapHanaAuthenticationTypeWindows ...
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// PossibleSapHanaAuthenticationTypeValues returns an array of possible values for the SapHanaAuthenticationType const type.
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return []SapHanaAuthenticationType{SapHanaAuthenticationTypeBasic, SapHanaAuthenticationTypeWindows}
}

// SapHanaPartitionOption enumerates the values for sap hana partition option.
type SapHanaPartitionOption string

const (
	// SapHanaPartitionOptionNone ...
	SapHanaPartitionOptionNone SapHanaPartitionOption = "None"
	// SapHanaPartitionOptionPhysicalPartitionsOfTable ...
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = "PhysicalPartitionsOfTable"
	// SapHanaPartitionOptionSapHanaDynamicRange ...
	SapHanaPartitionOptionSapHanaDynamicRange SapHanaPartitionOption = "SapHanaDynamicRange"
)

// PossibleSapHanaPartitionOptionValues returns an array of possible values for the SapHanaPartitionOption const type.
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return []SapHanaPartitionOption{SapHanaPartitionOptionNone, SapHanaPartitionOptionPhysicalPartitionsOfTable, SapHanaPartitionOptionSapHanaDynamicRange}
}

// SapTablePartitionOption enumerates the values for sap table partition option.
type SapTablePartitionOption string

const (
	// SapTablePartitionOptionNone ...
	SapTablePartitionOptionNone SapTablePartitionOption = "None"
	// SapTablePartitionOptionPartitionOnCalendarDate ...
	SapTablePartitionOptionPartitionOnCalendarDate SapTablePartitionOption = "PartitionOnCalendarDate"
	// SapTablePartitionOptionPartitionOnCalendarMonth ...
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = "PartitionOnCalendarMonth"
	// SapTablePartitionOptionPartitionOnCalendarYear ...
	SapTablePartitionOptionPartitionOnCalendarYear SapTablePartitionOption = "PartitionOnCalendarYear"
	// SapTablePartitionOptionPartitionOnInt ...
	SapTablePartitionOptionPartitionOnInt SapTablePartitionOption = "PartitionOnInt"
	// SapTablePartitionOptionPartitionOnTime ...
	SapTablePartitionOptionPartitionOnTime SapTablePartitionOption = "PartitionOnTime"
)

// PossibleSapTablePartitionOptionValues returns an array of possible values for the SapTablePartitionOption const type.
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return []SapTablePartitionOption{SapTablePartitionOptionNone, SapTablePartitionOptionPartitionOnCalendarDate, SapTablePartitionOptionPartitionOnCalendarMonth, SapTablePartitionOptionPartitionOnCalendarYear, SapTablePartitionOptionPartitionOnInt, SapTablePartitionOptionPartitionOnTime}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// ServiceNowAuthenticationType enumerates the values for service now authentication type.
type ServiceNowAuthenticationType string

const (
	// ServiceNowAuthenticationTypeBasic ...
	ServiceNowAuthenticationTypeBasic ServiceNowAuthenticationType = "Basic"
	// ServiceNowAuthenticationTypeOAuth2 ...
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// PossibleServiceNowAuthenticationTypeValues returns an array of possible values for the ServiceNowAuthenticationType const type.
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return []ServiceNowAuthenticationType{ServiceNowAuthenticationTypeBasic, ServiceNowAuthenticationTypeOAuth2}
}

// ServicePrincipalCredentialType enumerates the values for service principal credential type.
type ServicePrincipalCredentialType string

const (
	// ServicePrincipalCredentialTypeServicePrincipalCert ...
	ServicePrincipalCredentialTypeServicePrincipalCert ServicePrincipalCredentialType = "ServicePrincipalCert"
	// ServicePrincipalCredentialTypeServicePrincipalKey ...
	ServicePrincipalCredentialTypeServicePrincipalKey ServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleServicePrincipalCredentialTypeValues returns an array of possible values for the ServicePrincipalCredentialType const type.
func PossibleServicePrincipalCredentialTypeValues() []ServicePrincipalCredentialType {
	return []ServicePrincipalCredentialType{ServicePrincipalCredentialTypeServicePrincipalCert, ServicePrincipalCredentialTypeServicePrincipalKey}
}

// SftpAuthenticationType enumerates the values for sftp authentication type.
type SftpAuthenticationType string

const (
	// SftpAuthenticationTypeBasic ...
	SftpAuthenticationTypeBasic SftpAuthenticationType = "Basic"
	// SftpAuthenticationTypeMultiFactor ...
	SftpAuthenticationTypeMultiFactor SftpAuthenticationType = "MultiFactor"
	// SftpAuthenticationTypeSSHPublicKey ...
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// PossibleSftpAuthenticationTypeValues returns an array of possible values for the SftpAuthenticationType const type.
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return []SftpAuthenticationType{SftpAuthenticationTypeBasic, SftpAuthenticationTypeMultiFactor, SftpAuthenticationTypeSSHPublicKey}
}

// SparkAuthenticationType enumerates the values for spark authentication type.
type SparkAuthenticationType string

const (
	// SparkAuthenticationTypeAnonymous ...
	SparkAuthenticationTypeAnonymous SparkAuthenticationType = "Anonymous"
	// SparkAuthenticationTypeUsername ...
	SparkAuthenticationTypeUsername SparkAuthenticationType = "Username"
	// SparkAuthenticationTypeUsernameAndPassword ...
	SparkAuthenticationTypeUsernameAndPassword SparkAuthenticationType = "UsernameAndPassword"
	// SparkAuthenticationTypeWindowsAzureHDInsightService ...
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleSparkAuthenticationTypeValues returns an array of possible values for the SparkAuthenticationType const type.
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return []SparkAuthenticationType{SparkAuthenticationTypeAnonymous, SparkAuthenticationTypeUsername, SparkAuthenticationTypeUsernameAndPassword, SparkAuthenticationTypeWindowsAzureHDInsightService}
}

// SparkServerType enumerates the values for spark server type.
type SparkServerType string

const (
	// SparkServerTypeSharkServer ...
	SparkServerTypeSharkServer SparkServerType = "SharkServer"
	// SparkServerTypeSharkServer2 ...
	SparkServerTypeSharkServer2 SparkServerType = "SharkServer2"
	// SparkServerTypeSparkThriftServer ...
	SparkServerTypeSparkThriftServer SparkServerType = "SparkThriftServer"
)

// PossibleSparkServerTypeValues returns an array of possible values for the SparkServerType const type.
func PossibleSparkServerTypeValues() []SparkServerType {
	return []SparkServerType{SparkServerTypeSharkServer, SparkServerTypeSharkServer2, SparkServerTypeSparkThriftServer}
}

// SparkThriftTransportProtocol enumerates the values for spark thrift transport protocol.
type SparkThriftTransportProtocol string

const (
	// SparkThriftTransportProtocolBinary ...
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	// SparkThriftTransportProtocolHTTP ...
	SparkThriftTransportProtocolHTTP SparkThriftTransportProtocol = "HTTP "
	// SparkThriftTransportProtocolSASL ...
	SparkThriftTransportProtocolSASL SparkThriftTransportProtocol = "SASL"
)

// PossibleSparkThriftTransportProtocolValues returns an array of possible values for the SparkThriftTransportProtocol const type.
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return []SparkThriftTransportProtocol{SparkThriftTransportProtocolBinary, SparkThriftTransportProtocolHTTP, SparkThriftTransportProtocolSASL}
}

// SQLAlwaysEncryptedAkvAuthType enumerates the values for sql always encrypted akv auth type.
type SQLAlwaysEncryptedAkvAuthType string

const (
	// SQLAlwaysEncryptedAkvAuthTypeManagedIdentity ...
	SQLAlwaysEncryptedAkvAuthTypeManagedIdentity SQLAlwaysEncryptedAkvAuthType = "ManagedIdentity"
	// SQLAlwaysEncryptedAkvAuthTypeServicePrincipal ...
	SQLAlwaysEncryptedAkvAuthTypeServicePrincipal SQLAlwaysEncryptedAkvAuthType = "ServicePrincipal"
	// SQLAlwaysEncryptedAkvAuthTypeUserAssignedManagedIdentity ...
	SQLAlwaysEncryptedAkvAuthTypeUserAssignedManagedIdentity SQLAlwaysEncryptedAkvAuthType = "UserAssignedManagedIdentity"
)

// PossibleSQLAlwaysEncryptedAkvAuthTypeValues returns an array of possible values for the SQLAlwaysEncryptedAkvAuthType const type.
func PossibleSQLAlwaysEncryptedAkvAuthTypeValues() []SQLAlwaysEncryptedAkvAuthType {
	return []SQLAlwaysEncryptedAkvAuthType{SQLAlwaysEncryptedAkvAuthTypeManagedIdentity, SQLAlwaysEncryptedAkvAuthTypeServicePrincipal, SQLAlwaysEncryptedAkvAuthTypeUserAssignedManagedIdentity}
}

// SQLDWWriteBehaviorEnum enumerates the values for sqldw write behavior enum.
type SQLDWWriteBehaviorEnum string

const (
	// SQLDWWriteBehaviorEnumInsert ...
	SQLDWWriteBehaviorEnumInsert SQLDWWriteBehaviorEnum = "Insert"
	// SQLDWWriteBehaviorEnumUpsert ...
	SQLDWWriteBehaviorEnumUpsert SQLDWWriteBehaviorEnum = "Upsert"
)

// PossibleSQLDWWriteBehaviorEnumValues returns an array of possible values for the SQLDWWriteBehaviorEnum const type.
func PossibleSQLDWWriteBehaviorEnumValues() []SQLDWWriteBehaviorEnum {
	return []SQLDWWriteBehaviorEnum{SQLDWWriteBehaviorEnumInsert, SQLDWWriteBehaviorEnumUpsert}
}

// SQLPartitionOption enumerates the values for sql partition option.
type SQLPartitionOption string

const (
	// SQLPartitionOptionDynamicRange ...
	SQLPartitionOptionDynamicRange SQLPartitionOption = "DynamicRange"
	// SQLPartitionOptionNone ...
	SQLPartitionOptionNone SQLPartitionOption = "None"
	// SQLPartitionOptionPhysicalPartitionsOfTable ...
	SQLPartitionOptionPhysicalPartitionsOfTable SQLPartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleSQLPartitionOptionValues returns an array of possible values for the SQLPartitionOption const type.
func PossibleSQLPartitionOptionValues() []SQLPartitionOption {
	return []SQLPartitionOption{SQLPartitionOptionDynamicRange, SQLPartitionOptionNone, SQLPartitionOptionPhysicalPartitionsOfTable}
}

// SQLWriteBehaviorEnum enumerates the values for sql write behavior enum.
type SQLWriteBehaviorEnum string

const (
	// SQLWriteBehaviorEnumInsert ...
	SQLWriteBehaviorEnumInsert SQLWriteBehaviorEnum = "Insert"
	// SQLWriteBehaviorEnumStoredProcedure ...
	SQLWriteBehaviorEnumStoredProcedure SQLWriteBehaviorEnum = "StoredProcedure"
	// SQLWriteBehaviorEnumUpsert ...
	SQLWriteBehaviorEnumUpsert SQLWriteBehaviorEnum = "Upsert"
)

// PossibleSQLWriteBehaviorEnumValues returns an array of possible values for the SQLWriteBehaviorEnum const type.
func PossibleSQLWriteBehaviorEnumValues() []SQLWriteBehaviorEnum {
	return []SQLWriteBehaviorEnum{SQLWriteBehaviorEnumInsert, SQLWriteBehaviorEnumStoredProcedure, SQLWriteBehaviorEnumUpsert}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// SsisObjectMetadataTypeEnvironment ...
	SsisObjectMetadataTypeEnvironment SsisObjectMetadataType = "Environment"
	// SsisObjectMetadataTypeFolder ...
	SsisObjectMetadataTypeFolder SsisObjectMetadataType = "Folder"
	// SsisObjectMetadataTypePackage ...
	SsisObjectMetadataTypePackage SsisObjectMetadataType = "Package"
	// SsisObjectMetadataTypeProject ...
	SsisObjectMetadataTypeProject SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{SsisObjectMetadataTypeEnvironment, SsisObjectMetadataTypeFolder, SsisObjectMetadataTypePackage, SsisObjectMetadataTypeProject}
}

// SsisPackageLocationType enumerates the values for ssis package location type.
type SsisPackageLocationType string

const (
	// SsisPackageLocationTypeFile ...
	SsisPackageLocationTypeFile SsisPackageLocationType = "File"
	// SsisPackageLocationTypeInlinePackage ...
	SsisPackageLocationTypeInlinePackage SsisPackageLocationType = "InlinePackage"
	// SsisPackageLocationTypePackageStore ...
	SsisPackageLocationTypePackageStore SsisPackageLocationType = "PackageStore"
	// SsisPackageLocationTypeSSISDB ...
	SsisPackageLocationTypeSSISDB SsisPackageLocationType = "SSISDB"
)

// PossibleSsisPackageLocationTypeValues returns an array of possible values for the SsisPackageLocationType const type.
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return []SsisPackageLocationType{SsisPackageLocationTypeFile, SsisPackageLocationTypeInlinePackage, SsisPackageLocationTypePackageStore, SsisPackageLocationTypeSSISDB}
}

// StoredProcedureParameterType enumerates the values for stored procedure parameter type.
type StoredProcedureParameterType string

const (
	// StoredProcedureParameterTypeBoolean ...
	StoredProcedureParameterTypeBoolean StoredProcedureParameterType = "Boolean"
	// StoredProcedureParameterTypeDate ...
	StoredProcedureParameterTypeDate StoredProcedureParameterType = "Date"
	// StoredProcedureParameterTypeDecimal ...
	StoredProcedureParameterTypeDecimal StoredProcedureParameterType = "Decimal"
	// StoredProcedureParameterTypeGUID ...
	StoredProcedureParameterTypeGUID StoredProcedureParameterType = "Guid"
	// StoredProcedureParameterTypeInt ...
	StoredProcedureParameterTypeInt StoredProcedureParameterType = "Int"
	// StoredProcedureParameterTypeInt64 ...
	StoredProcedureParameterTypeInt64 StoredProcedureParameterType = "Int64"
	// StoredProcedureParameterTypeString ...
	StoredProcedureParameterTypeString StoredProcedureParameterType = "String"
)

// PossibleStoredProcedureParameterTypeValues returns an array of possible values for the StoredProcedureParameterType const type.
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return []StoredProcedureParameterType{StoredProcedureParameterTypeBoolean, StoredProcedureParameterTypeDate, StoredProcedureParameterTypeDecimal, StoredProcedureParameterTypeGUID, StoredProcedureParameterTypeInt, StoredProcedureParameterTypeInt64, StoredProcedureParameterTypeString}
}

// SybaseAuthenticationType enumerates the values for sybase authentication type.
type SybaseAuthenticationType string

const (
	// SybaseAuthenticationTypeBasic ...
	SybaseAuthenticationTypeBasic SybaseAuthenticationType = "Basic"
	// SybaseAuthenticationTypeWindows ...
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// PossibleSybaseAuthenticationTypeValues returns an array of possible values for the SybaseAuthenticationType const type.
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return []SybaseAuthenticationType{SybaseAuthenticationTypeBasic, SybaseAuthenticationTypeWindows}
}

// TeradataAuthenticationType enumerates the values for teradata authentication type.
type TeradataAuthenticationType string

const (
	// TeradataAuthenticationTypeBasic ...
	TeradataAuthenticationTypeBasic TeradataAuthenticationType = "Basic"
	// TeradataAuthenticationTypeWindows ...
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// PossibleTeradataAuthenticationTypeValues returns an array of possible values for the TeradataAuthenticationType const type.
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return []TeradataAuthenticationType{TeradataAuthenticationTypeBasic, TeradataAuthenticationTypeWindows}
}

// TeradataPartitionOption enumerates the values for teradata partition option.
type TeradataPartitionOption string

const (
	// TeradataPartitionOptionDynamicRange ...
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = "DynamicRange"
	// TeradataPartitionOptionHash ...
	TeradataPartitionOptionHash TeradataPartitionOption = "Hash"
	// TeradataPartitionOptionNone ...
	TeradataPartitionOptionNone TeradataPartitionOption = "None"
)

// PossibleTeradataPartitionOptionValues returns an array of possible values for the TeradataPartitionOption const type.
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return []TeradataPartitionOption{TeradataPartitionOptionDynamicRange, TeradataPartitionOptionHash, TeradataPartitionOptionNone}
}

// TriggerRunStatus enumerates the values for trigger run status.
type TriggerRunStatus string

const (
	// TriggerRunStatusFailed ...
	TriggerRunStatusFailed TriggerRunStatus = "Failed"
	// TriggerRunStatusInprogress ...
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	// TriggerRunStatusSucceeded ...
	TriggerRunStatusSucceeded TriggerRunStatus = "Succeeded"
)

// PossibleTriggerRunStatusValues returns an array of possible values for the TriggerRunStatus const type.
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return []TriggerRunStatus{TriggerRunStatusFailed, TriggerRunStatusInprogress, TriggerRunStatusSucceeded}
}

// TriggerRuntimeState enumerates the values for trigger runtime state.
type TriggerRuntimeState string

const (
	// TriggerRuntimeStateDisabled ...
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	// TriggerRuntimeStateStarted ...
	TriggerRuntimeStateStarted TriggerRuntimeState = "Started"
	// TriggerRuntimeStateStopped ...
	TriggerRuntimeStateStopped TriggerRuntimeState = "Stopped"
)

// PossibleTriggerRuntimeStateValues returns an array of possible values for the TriggerRuntimeState const type.
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return []TriggerRuntimeState{TriggerRuntimeStateDisabled, TriggerRuntimeStateStarted, TriggerRuntimeStateStopped}
}

// TumblingWindowFrequency enumerates the values for tumbling window frequency.
type TumblingWindowFrequency string

const (
	// TumblingWindowFrequencyHour ...
	TumblingWindowFrequencyHour TumblingWindowFrequency = "Hour"
	// TumblingWindowFrequencyMinute ...
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
	// TumblingWindowFrequencyMonth ...
	TumblingWindowFrequencyMonth TumblingWindowFrequency = "Month"
)

// PossibleTumblingWindowFrequencyValues returns an array of possible values for the TumblingWindowFrequency const type.
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return []TumblingWindowFrequency{TumblingWindowFrequencyHour, TumblingWindowFrequencyMinute, TumblingWindowFrequencyMonth}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureKeyVaultSecret ...
	TypeAzureKeyVaultSecret Type = "AzureKeyVaultSecret"
	// TypeSecretBase ...
	TypeSecretBase Type = "SecretBase"
	// TypeSecureString ...
	TypeSecureString Type = "SecureString"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAzureKeyVaultSecret, TypeSecretBase, TypeSecureString}
}

// TypeBasicActivity enumerates the values for type basic activity.
type TypeBasicActivity string

const (
	// TypeBasicActivityTypeActivity ...
	TypeBasicActivityTypeActivity TypeBasicActivity = "Activity"
	// TypeBasicActivityTypeAppendVariable ...
	TypeBasicActivityTypeAppendVariable TypeBasicActivity = "AppendVariable"
	// TypeBasicActivityTypeAzureDataExplorerCommand ...
	TypeBasicActivityTypeAzureDataExplorerCommand TypeBasicActivity = "AzureDataExplorerCommand"
	// TypeBasicActivityTypeAzureFunctionActivity ...
	TypeBasicActivityTypeAzureFunctionActivity TypeBasicActivity = "AzureFunctionActivity"
	// TypeBasicActivityTypeAzureMLBatchExecution ...
	TypeBasicActivityTypeAzureMLBatchExecution TypeBasicActivity = "AzureMLBatchExecution"
	// TypeBasicActivityTypeAzureMLExecutePipeline ...
	TypeBasicActivityTypeAzureMLExecutePipeline TypeBasicActivity = "AzureMLExecutePipeline"
	// TypeBasicActivityTypeAzureMLUpdateResource ...
	TypeBasicActivityTypeAzureMLUpdateResource TypeBasicActivity = "AzureMLUpdateResource"
	// TypeBasicActivityTypeContainer ...
	TypeBasicActivityTypeContainer TypeBasicActivity = "Container"
	// TypeBasicActivityTypeCopy ...
	TypeBasicActivityTypeCopy TypeBasicActivity = "Copy"
	// TypeBasicActivityTypeCustom ...
	TypeBasicActivityTypeCustom TypeBasicActivity = "Custom"
	// TypeBasicActivityTypeDatabricksNotebook ...
	TypeBasicActivityTypeDatabricksNotebook TypeBasicActivity = "DatabricksNotebook"
	// TypeBasicActivityTypeDatabricksSparkJar ...
	TypeBasicActivityTypeDatabricksSparkJar TypeBasicActivity = "DatabricksSparkJar"
	// TypeBasicActivityTypeDatabricksSparkPython ...
	TypeBasicActivityTypeDatabricksSparkPython TypeBasicActivity = "DatabricksSparkPython"
	// TypeBasicActivityTypeDataLakeAnalyticsUSQL ...
	TypeBasicActivityTypeDataLakeAnalyticsUSQL TypeBasicActivity = "DataLakeAnalyticsU-SQL"
	// TypeBasicActivityTypeDelete ...
	TypeBasicActivityTypeDelete TypeBasicActivity = "Delete"
	// TypeBasicActivityTypeExecuteDataFlow ...
	TypeBasicActivityTypeExecuteDataFlow TypeBasicActivity = "ExecuteDataFlow"
	// TypeBasicActivityTypeExecutePipeline ...
	TypeBasicActivityTypeExecutePipeline TypeBasicActivity = "ExecutePipeline"
	// TypeBasicActivityTypeExecuteSSISPackage ...
	TypeBasicActivityTypeExecuteSSISPackage TypeBasicActivity = "ExecuteSSISPackage"
	// TypeBasicActivityTypeExecuteWranglingDataflow ...
	TypeBasicActivityTypeExecuteWranglingDataflow TypeBasicActivity = "ExecuteWranglingDataflow"
	// TypeBasicActivityTypeExecution ...
	TypeBasicActivityTypeExecution TypeBasicActivity = "Execution"
	// TypeBasicActivityTypeFilter ...
	TypeBasicActivityTypeFilter TypeBasicActivity = "Filter"
	// TypeBasicActivityTypeForEach ...
	TypeBasicActivityTypeForEach TypeBasicActivity = "ForEach"
	// TypeBasicActivityTypeGetMetadata ...
	TypeBasicActivityTypeGetMetadata TypeBasicActivity = "GetMetadata"
	// TypeBasicActivityTypeHDInsightHive ...
	TypeBasicActivityTypeHDInsightHive TypeBasicActivity = "HDInsightHive"
	// TypeBasicActivityTypeHDInsightMapReduce ...
	TypeBasicActivityTypeHDInsightMapReduce TypeBasicActivity = "HDInsightMapReduce"
	// TypeBasicActivityTypeHDInsightPig ...
	TypeBasicActivityTypeHDInsightPig TypeBasicActivity = "HDInsightPig"
	// TypeBasicActivityTypeHDInsightSpark ...
	TypeBasicActivityTypeHDInsightSpark TypeBasicActivity = "HDInsightSpark"
	// TypeBasicActivityTypeHDInsightStreaming ...
	TypeBasicActivityTypeHDInsightStreaming TypeBasicActivity = "HDInsightStreaming"
	// TypeBasicActivityTypeIfCondition ...
	TypeBasicActivityTypeIfCondition TypeBasicActivity = "IfCondition"
	// TypeBasicActivityTypeLookup ...
	TypeBasicActivityTypeLookup TypeBasicActivity = "Lookup"
	// TypeBasicActivityTypeSetVariable ...
	TypeBasicActivityTypeSetVariable TypeBasicActivity = "SetVariable"
	// TypeBasicActivityTypeSQLServerStoredProcedure ...
	TypeBasicActivityTypeSQLServerStoredProcedure TypeBasicActivity = "SqlServerStoredProcedure"
	// TypeBasicActivityTypeSwitch ...
	TypeBasicActivityTypeSwitch TypeBasicActivity = "Switch"
	// TypeBasicActivityTypeUntil ...
	TypeBasicActivityTypeUntil TypeBasicActivity = "Until"
	// TypeBasicActivityTypeValidation ...
	TypeBasicActivityTypeValidation TypeBasicActivity = "Validation"
	// TypeBasicActivityTypeWait ...
	TypeBasicActivityTypeWait TypeBasicActivity = "Wait"
	// TypeBasicActivityTypeWebActivity ...
	TypeBasicActivityTypeWebActivity TypeBasicActivity = "WebActivity"
	// TypeBasicActivityTypeWebHook ...
	TypeBasicActivityTypeWebHook TypeBasicActivity = "WebHook"
)

// PossibleTypeBasicActivityValues returns an array of possible values for the TypeBasicActivity const type.
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return []TypeBasicActivity{TypeBasicActivityTypeActivity, TypeBasicActivityTypeAppendVariable, TypeBasicActivityTypeAzureDataExplorerCommand, TypeBasicActivityTypeAzureFunctionActivity, TypeBasicActivityTypeAzureMLBatchExecution, TypeBasicActivityTypeAzureMLExecutePipeline, TypeBasicActivityTypeAzureMLUpdateResource, TypeBasicActivityTypeContainer, TypeBasicActivityTypeCopy, TypeBasicActivityTypeCustom, TypeBasicActivityTypeDatabricksNotebook, TypeBasicActivityTypeDatabricksSparkJar, TypeBasicActivityTypeDatabricksSparkPython, TypeBasicActivityTypeDataLakeAnalyticsUSQL, TypeBasicActivityTypeDelete, TypeBasicActivityTypeExecuteDataFlow, TypeBasicActivityTypeExecutePipeline, TypeBasicActivityTypeExecuteSSISPackage, TypeBasicActivityTypeExecuteWranglingDataflow, TypeBasicActivityTypeExecution, TypeBasicActivityTypeFilter, TypeBasicActivityTypeForEach, TypeBasicActivityTypeGetMetadata, TypeBasicActivityTypeHDInsightHive, TypeBasicActivityTypeHDInsightMapReduce, TypeBasicActivityTypeHDInsightPig, TypeBasicActivityTypeHDInsightSpark, TypeBasicActivityTypeHDInsightStreaming, TypeBasicActivityTypeIfCondition, TypeBasicActivityTypeLookup, TypeBasicActivityTypeSetVariable, TypeBasicActivityTypeSQLServerStoredProcedure, TypeBasicActivityTypeSwitch, TypeBasicActivityTypeUntil, TypeBasicActivityTypeValidation, TypeBasicActivityTypeWait, TypeBasicActivityTypeWebActivity, TypeBasicActivityTypeWebHook}
}

// TypeBasicCompressionReadSettings enumerates the values for type basic compression read settings.
type TypeBasicCompressionReadSettings string

const (
	// TypeBasicCompressionReadSettingsTypeCompressionReadSettings ...
	TypeBasicCompressionReadSettingsTypeCompressionReadSettings TypeBasicCompressionReadSettings = "CompressionReadSettings"
	// TypeBasicCompressionReadSettingsTypeTarGZipReadSettings ...
	TypeBasicCompressionReadSettingsTypeTarGZipReadSettings TypeBasicCompressionReadSettings = "TarGZipReadSettings"
	// TypeBasicCompressionReadSettingsTypeTarReadSettings ...
	TypeBasicCompressionReadSettingsTypeTarReadSettings TypeBasicCompressionReadSettings = "TarReadSettings"
	// TypeBasicCompressionReadSettingsTypeZipDeflateReadSettings ...
	TypeBasicCompressionReadSettingsTypeZipDeflateReadSettings TypeBasicCompressionReadSettings = "ZipDeflateReadSettings"
)

// PossibleTypeBasicCompressionReadSettingsValues returns an array of possible values for the TypeBasicCompressionReadSettings const type.
func PossibleTypeBasicCompressionReadSettingsValues() []TypeBasicCompressionReadSettings {
	return []TypeBasicCompressionReadSettings{TypeBasicCompressionReadSettingsTypeCompressionReadSettings, TypeBasicCompressionReadSettingsTypeTarGZipReadSettings, TypeBasicCompressionReadSettingsTypeTarReadSettings, TypeBasicCompressionReadSettingsTypeZipDeflateReadSettings}
}

// TypeBasicCopySink enumerates the values for type basic copy sink.
type TypeBasicCopySink string

const (
	// TypeBasicCopySinkTypeAvroSink ...
	TypeBasicCopySinkTypeAvroSink TypeBasicCopySink = "AvroSink"
	// TypeBasicCopySinkTypeAzureBlobFSSink ...
	TypeBasicCopySinkTypeAzureBlobFSSink TypeBasicCopySink = "AzureBlobFSSink"
	// TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink ...
	TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink TypeBasicCopySink = "AzureDatabricksDeltaLakeSink"
	// TypeBasicCopySinkTypeAzureDataExplorerSink ...
	TypeBasicCopySinkTypeAzureDataExplorerSink TypeBasicCopySink = "AzureDataExplorerSink"
	// TypeBasicCopySinkTypeAzureDataLakeStoreSink ...
	TypeBasicCopySinkTypeAzureDataLakeStoreSink TypeBasicCopySink = "AzureDataLakeStoreSink"
	// TypeBasicCopySinkTypeAzureMySQLSink ...
	TypeBasicCopySinkTypeAzureMySQLSink TypeBasicCopySink = "AzureMySqlSink"
	// TypeBasicCopySinkTypeAzurePostgreSQLSink ...
	TypeBasicCopySinkTypeAzurePostgreSQLSink TypeBasicCopySink = "AzurePostgreSqlSink"
	// TypeBasicCopySinkTypeAzureQueueSink ...
	TypeBasicCopySinkTypeAzureQueueSink TypeBasicCopySink = "AzureQueueSink"
	// TypeBasicCopySinkTypeAzureSearchIndexSink ...
	TypeBasicCopySinkTypeAzureSearchIndexSink TypeBasicCopySink = "AzureSearchIndexSink"
	// TypeBasicCopySinkTypeAzureSQLSink ...
	TypeBasicCopySinkTypeAzureSQLSink TypeBasicCopySink = "AzureSqlSink"
	// TypeBasicCopySinkTypeAzureTableSink ...
	TypeBasicCopySinkTypeAzureTableSink TypeBasicCopySink = "AzureTableSink"
	// TypeBasicCopySinkTypeBinarySink ...
	TypeBasicCopySinkTypeBinarySink TypeBasicCopySink = "BinarySink"
	// TypeBasicCopySinkTypeBlobSink ...
	TypeBasicCopySinkTypeBlobSink TypeBasicCopySink = "BlobSink"
	// TypeBasicCopySinkTypeCommonDataServiceForAppsSink ...
	TypeBasicCopySinkTypeCommonDataServiceForAppsSink TypeBasicCopySink = "CommonDataServiceForAppsSink"
	// TypeBasicCopySinkTypeCopySink ...
	TypeBasicCopySinkTypeCopySink TypeBasicCopySink = "CopySink"
	// TypeBasicCopySinkTypeCosmosDbMongoDbAPISink ...
	TypeBasicCopySinkTypeCosmosDbMongoDbAPISink TypeBasicCopySink = "CosmosDbMongoDbApiSink"
	// TypeBasicCopySinkTypeCosmosDbSQLAPISink ...
	TypeBasicCopySinkTypeCosmosDbSQLAPISink TypeBasicCopySink = "CosmosDbSqlApiSink"
	// TypeBasicCopySinkTypeDelimitedTextSink ...
	TypeBasicCopySinkTypeDelimitedTextSink TypeBasicCopySink = "DelimitedTextSink"
	// TypeBasicCopySinkTypeDocumentDbCollectionSink ...
	TypeBasicCopySinkTypeDocumentDbCollectionSink TypeBasicCopySink = "DocumentDbCollectionSink"
	// TypeBasicCopySinkTypeDynamicsCrmSink ...
	TypeBasicCopySinkTypeDynamicsCrmSink TypeBasicCopySink = "DynamicsCrmSink"
	// TypeBasicCopySinkTypeDynamicsSink ...
	TypeBasicCopySinkTypeDynamicsSink TypeBasicCopySink = "DynamicsSink"
	// TypeBasicCopySinkTypeFileSystemSink ...
	TypeBasicCopySinkTypeFileSystemSink TypeBasicCopySink = "FileSystemSink"
	// TypeBasicCopySinkTypeInformixSink ...
	TypeBasicCopySinkTypeInformixSink TypeBasicCopySink = "InformixSink"
	// TypeBasicCopySinkTypeJSONSink ...
	TypeBasicCopySinkTypeJSONSink TypeBasicCopySink = "JsonSink"
	// TypeBasicCopySinkTypeMicrosoftAccessSink ...
	TypeBasicCopySinkTypeMicrosoftAccessSink TypeBasicCopySink = "MicrosoftAccessSink"
	// TypeBasicCopySinkTypeMongoDbAtlasSink ...
	TypeBasicCopySinkTypeMongoDbAtlasSink TypeBasicCopySink = "MongoDbAtlasSink"
	// TypeBasicCopySinkTypeMongoDbV2Sink ...
	TypeBasicCopySinkTypeMongoDbV2Sink TypeBasicCopySink = "MongoDbV2Sink"
	// TypeBasicCopySinkTypeOdbcSink ...
	TypeBasicCopySinkTypeOdbcSink TypeBasicCopySink = "OdbcSink"
	// TypeBasicCopySinkTypeOracleSink ...
	TypeBasicCopySinkTypeOracleSink TypeBasicCopySink = "OracleSink"
	// TypeBasicCopySinkTypeOrcSink ...
	TypeBasicCopySinkTypeOrcSink TypeBasicCopySink = "OrcSink"
	// TypeBasicCopySinkTypeParquetSink ...
	TypeBasicCopySinkTypeParquetSink TypeBasicCopySink = "ParquetSink"
	// TypeBasicCopySinkTypeRestSink ...
	TypeBasicCopySinkTypeRestSink TypeBasicCopySink = "RestSink"
	// TypeBasicCopySinkTypeSalesforceServiceCloudSink ...
	TypeBasicCopySinkTypeSalesforceServiceCloudSink TypeBasicCopySink = "SalesforceServiceCloudSink"
	// TypeBasicCopySinkTypeSalesforceSink ...
	TypeBasicCopySinkTypeSalesforceSink TypeBasicCopySink = "SalesforceSink"
	// TypeBasicCopySinkTypeSapCloudForCustomerSink ...
	TypeBasicCopySinkTypeSapCloudForCustomerSink TypeBasicCopySink = "SapCloudForCustomerSink"
	// TypeBasicCopySinkTypeSnowflakeSink ...
	TypeBasicCopySinkTypeSnowflakeSink TypeBasicCopySink = "SnowflakeSink"
	// TypeBasicCopySinkTypeSQLDWSink ...
	TypeBasicCopySinkTypeSQLDWSink TypeBasicCopySink = "SqlDWSink"
	// TypeBasicCopySinkTypeSQLMISink ...
	TypeBasicCopySinkTypeSQLMISink TypeBasicCopySink = "SqlMISink"
	// TypeBasicCopySinkTypeSQLServerSink ...
	TypeBasicCopySinkTypeSQLServerSink TypeBasicCopySink = "SqlServerSink"
	// TypeBasicCopySinkTypeSQLSink ...
	TypeBasicCopySinkTypeSQLSink TypeBasicCopySink = "SqlSink"
)

// PossibleTypeBasicCopySinkValues returns an array of possible values for the TypeBasicCopySink const type.
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return []TypeBasicCopySink{TypeBasicCopySinkTypeAvroSink, TypeBasicCopySinkTypeAzureBlobFSSink, TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink, TypeBasicCopySinkTypeAzureDataExplorerSink, TypeBasicCopySinkTypeAzureDataLakeStoreSink, TypeBasicCopySinkTypeAzureMySQLSink, TypeBasicCopySinkTypeAzurePostgreSQLSink, TypeBasicCopySinkTypeAzureQueueSink, TypeBasicCopySinkTypeAzureSearchIndexSink, TypeBasicCopySinkTypeAzureSQLSink, TypeBasicCopySinkTypeAzureTableSink, TypeBasicCopySinkTypeBinarySink, TypeBasicCopySinkTypeBlobSink, TypeBasicCopySinkTypeCommonDataServiceForAppsSink, TypeBasicCopySinkTypeCopySink, TypeBasicCopySinkTypeCosmosDbMongoDbAPISink, TypeBasicCopySinkTypeCosmosDbSQLAPISink, TypeBasicCopySinkTypeDelimitedTextSink, TypeBasicCopySinkTypeDocumentDbCollectionSink, TypeBasicCopySinkTypeDynamicsCrmSink, TypeBasicCopySinkTypeDynamicsSink, TypeBasicCopySinkTypeFileSystemSink, TypeBasicCopySinkTypeInformixSink, TypeBasicCopySinkTypeJSONSink, TypeBasicCopySinkTypeMicrosoftAccessSink, TypeBasicCopySinkTypeMongoDbAtlasSink, TypeBasicCopySinkTypeMongoDbV2Sink, TypeBasicCopySinkTypeOdbcSink, TypeBasicCopySinkTypeOracleSink, TypeBasicCopySinkTypeOrcSink, TypeBasicCopySinkTypeParquetSink, TypeBasicCopySinkTypeRestSink, TypeBasicCopySinkTypeSalesforceServiceCloudSink, TypeBasicCopySinkTypeSalesforceSink, TypeBasicCopySinkTypeSapCloudForCustomerSink, TypeBasicCopySinkTypeSnowflakeSink, TypeBasicCopySinkTypeSQLDWSink, TypeBasicCopySinkTypeSQLMISink, TypeBasicCopySinkTypeSQLServerSink, TypeBasicCopySinkTypeSQLSink}
}

// TypeBasicCopySource enumerates the values for type basic copy source.
type TypeBasicCopySource string

const (
	// TypeBasicCopySourceTypeAmazonMWSSource ...
	TypeBasicCopySourceTypeAmazonMWSSource TypeBasicCopySource = "AmazonMWSSource"
	// TypeBasicCopySourceTypeAmazonRdsForOracleSource ...
	TypeBasicCopySourceTypeAmazonRdsForOracleSource TypeBasicCopySource = "AmazonRdsForOracleSource"
	// TypeBasicCopySourceTypeAmazonRdsForSQLServerSource ...
	TypeBasicCopySourceTypeAmazonRdsForSQLServerSource TypeBasicCopySource = "AmazonRdsForSqlServerSource"
	// TypeBasicCopySourceTypeAmazonRedshiftSource ...
	TypeBasicCopySourceTypeAmazonRedshiftSource TypeBasicCopySource = "AmazonRedshiftSource"
	// TypeBasicCopySourceTypeAvroSource ...
	TypeBasicCopySourceTypeAvroSource TypeBasicCopySource = "AvroSource"
	// TypeBasicCopySourceTypeAzureBlobFSSource ...
	TypeBasicCopySourceTypeAzureBlobFSSource TypeBasicCopySource = "AzureBlobFSSource"
	// TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource ...
	TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource TypeBasicCopySource = "AzureDatabricksDeltaLakeSource"
	// TypeBasicCopySourceTypeAzureDataExplorerSource ...
	TypeBasicCopySourceTypeAzureDataExplorerSource TypeBasicCopySource = "AzureDataExplorerSource"
	// TypeBasicCopySourceTypeAzureDataLakeStoreSource ...
	TypeBasicCopySourceTypeAzureDataLakeStoreSource TypeBasicCopySource = "AzureDataLakeStoreSource"
	// TypeBasicCopySourceTypeAzureMariaDBSource ...
	TypeBasicCopySourceTypeAzureMariaDBSource TypeBasicCopySource = "AzureMariaDBSource"
	// TypeBasicCopySourceTypeAzureMySQLSource ...
	TypeBasicCopySourceTypeAzureMySQLSource TypeBasicCopySource = "AzureMySqlSource"
	// TypeBasicCopySourceTypeAzurePostgreSQLSource ...
	TypeBasicCopySourceTypeAzurePostgreSQLSource TypeBasicCopySource = "AzurePostgreSqlSource"
	// TypeBasicCopySourceTypeAzureSQLSource ...
	TypeBasicCopySourceTypeAzureSQLSource TypeBasicCopySource = "AzureSqlSource"
	// TypeBasicCopySourceTypeAzureTableSource ...
	TypeBasicCopySourceTypeAzureTableSource TypeBasicCopySource = "AzureTableSource"
	// TypeBasicCopySourceTypeBinarySource ...
	TypeBasicCopySourceTypeBinarySource TypeBasicCopySource = "BinarySource"
	// TypeBasicCopySourceTypeBlobSource ...
	TypeBasicCopySourceTypeBlobSource TypeBasicCopySource = "BlobSource"
	// TypeBasicCopySourceTypeCassandraSource ...
	TypeBasicCopySourceTypeCassandraSource TypeBasicCopySource = "CassandraSource"
	// TypeBasicCopySourceTypeCommonDataServiceForAppsSource ...
	TypeBasicCopySourceTypeCommonDataServiceForAppsSource TypeBasicCopySource = "CommonDataServiceForAppsSource"
	// TypeBasicCopySourceTypeConcurSource ...
	TypeBasicCopySourceTypeConcurSource TypeBasicCopySource = "ConcurSource"
	// TypeBasicCopySourceTypeCopySource ...
	TypeBasicCopySourceTypeCopySource TypeBasicCopySource = "CopySource"
	// TypeBasicCopySourceTypeCosmosDbMongoDbAPISource ...
	TypeBasicCopySourceTypeCosmosDbMongoDbAPISource TypeBasicCopySource = "CosmosDbMongoDbApiSource"
	// TypeBasicCopySourceTypeCosmosDbSQLAPISource ...
	TypeBasicCopySourceTypeCosmosDbSQLAPISource TypeBasicCopySource = "CosmosDbSqlApiSource"
	// TypeBasicCopySourceTypeCouchbaseSource ...
	TypeBasicCopySourceTypeCouchbaseSource TypeBasicCopySource = "CouchbaseSource"
	// TypeBasicCopySourceTypeDb2Source ...
	TypeBasicCopySourceTypeDb2Source TypeBasicCopySource = "Db2Source"
	// TypeBasicCopySourceTypeDelimitedTextSource ...
	TypeBasicCopySourceTypeDelimitedTextSource TypeBasicCopySource = "DelimitedTextSource"
	// TypeBasicCopySourceTypeDocumentDbCollectionSource ...
	TypeBasicCopySourceTypeDocumentDbCollectionSource TypeBasicCopySource = "DocumentDbCollectionSource"
	// TypeBasicCopySourceTypeDrillSource ...
	TypeBasicCopySourceTypeDrillSource TypeBasicCopySource = "DrillSource"
	// TypeBasicCopySourceTypeDynamicsAXSource ...
	TypeBasicCopySourceTypeDynamicsAXSource TypeBasicCopySource = "DynamicsAXSource"
	// TypeBasicCopySourceTypeDynamicsCrmSource ...
	TypeBasicCopySourceTypeDynamicsCrmSource TypeBasicCopySource = "DynamicsCrmSource"
	// TypeBasicCopySourceTypeDynamicsSource ...
	TypeBasicCopySourceTypeDynamicsSource TypeBasicCopySource = "DynamicsSource"
	// TypeBasicCopySourceTypeEloquaSource ...
	TypeBasicCopySourceTypeEloquaSource TypeBasicCopySource = "EloquaSource"
	// TypeBasicCopySourceTypeExcelSource ...
	TypeBasicCopySourceTypeExcelSource TypeBasicCopySource = "ExcelSource"
	// TypeBasicCopySourceTypeFileSystemSource ...
	TypeBasicCopySourceTypeFileSystemSource TypeBasicCopySource = "FileSystemSource"
	// TypeBasicCopySourceTypeGoogleAdWordsSource ...
	TypeBasicCopySourceTypeGoogleAdWordsSource TypeBasicCopySource = "GoogleAdWordsSource"
	// TypeBasicCopySourceTypeGoogleBigQuerySource ...
	TypeBasicCopySourceTypeGoogleBigQuerySource TypeBasicCopySource = "GoogleBigQuerySource"
	// TypeBasicCopySourceTypeGreenplumSource ...
	TypeBasicCopySourceTypeGreenplumSource TypeBasicCopySource = "GreenplumSource"
	// TypeBasicCopySourceTypeHBaseSource ...
	TypeBasicCopySourceTypeHBaseSource TypeBasicCopySource = "HBaseSource"
	// TypeBasicCopySourceTypeHdfsSource ...
	TypeBasicCopySourceTypeHdfsSource TypeBasicCopySource = "HdfsSource"
	// TypeBasicCopySourceTypeHiveSource ...
	TypeBasicCopySourceTypeHiveSource TypeBasicCopySource = "HiveSource"
	// TypeBasicCopySourceTypeHTTPSource ...
	TypeBasicCopySourceTypeHTTPSource TypeBasicCopySource = "HttpSource"
	// TypeBasicCopySourceTypeHubspotSource ...
	TypeBasicCopySourceTypeHubspotSource TypeBasicCopySource = "HubspotSource"
	// TypeBasicCopySourceTypeImpalaSource ...
	TypeBasicCopySourceTypeImpalaSource TypeBasicCopySource = "ImpalaSource"
	// TypeBasicCopySourceTypeInformixSource ...
	TypeBasicCopySourceTypeInformixSource TypeBasicCopySource = "InformixSource"
	// TypeBasicCopySourceTypeJiraSource ...
	TypeBasicCopySourceTypeJiraSource TypeBasicCopySource = "JiraSource"
	// TypeBasicCopySourceTypeJSONSource ...
	TypeBasicCopySourceTypeJSONSource TypeBasicCopySource = "JsonSource"
	// TypeBasicCopySourceTypeMagentoSource ...
	TypeBasicCopySourceTypeMagentoSource TypeBasicCopySource = "MagentoSource"
	// TypeBasicCopySourceTypeMariaDBSource ...
	TypeBasicCopySourceTypeMariaDBSource TypeBasicCopySource = "MariaDBSource"
	// TypeBasicCopySourceTypeMarketoSource ...
	TypeBasicCopySourceTypeMarketoSource TypeBasicCopySource = "MarketoSource"
	// TypeBasicCopySourceTypeMicrosoftAccessSource ...
	TypeBasicCopySourceTypeMicrosoftAccessSource TypeBasicCopySource = "MicrosoftAccessSource"
	// TypeBasicCopySourceTypeMongoDbAtlasSource ...
	TypeBasicCopySourceTypeMongoDbAtlasSource TypeBasicCopySource = "MongoDbAtlasSource"
	// TypeBasicCopySourceTypeMongoDbSource ...
	TypeBasicCopySourceTypeMongoDbSource TypeBasicCopySource = "MongoDbSource"
	// TypeBasicCopySourceTypeMongoDbV2Source ...
	TypeBasicCopySourceTypeMongoDbV2Source TypeBasicCopySource = "MongoDbV2Source"
	// TypeBasicCopySourceTypeMySQLSource ...
	TypeBasicCopySourceTypeMySQLSource TypeBasicCopySource = "MySqlSource"
	// TypeBasicCopySourceTypeNetezzaSource ...
	TypeBasicCopySourceTypeNetezzaSource TypeBasicCopySource = "NetezzaSource"
	// TypeBasicCopySourceTypeODataSource ...
	TypeBasicCopySourceTypeODataSource TypeBasicCopySource = "ODataSource"
	// TypeBasicCopySourceTypeOdbcSource ...
	TypeBasicCopySourceTypeOdbcSource TypeBasicCopySource = "OdbcSource"
	// TypeBasicCopySourceTypeOffice365Source ...
	TypeBasicCopySourceTypeOffice365Source TypeBasicCopySource = "Office365Source"
	// TypeBasicCopySourceTypeOracleServiceCloudSource ...
	TypeBasicCopySourceTypeOracleServiceCloudSource TypeBasicCopySource = "OracleServiceCloudSource"
	// TypeBasicCopySourceTypeOracleSource ...
	TypeBasicCopySourceTypeOracleSource TypeBasicCopySource = "OracleSource"
	// TypeBasicCopySourceTypeOrcSource ...
	TypeBasicCopySourceTypeOrcSource TypeBasicCopySource = "OrcSource"
	// TypeBasicCopySourceTypeParquetSource ...
	TypeBasicCopySourceTypeParquetSource TypeBasicCopySource = "ParquetSource"
	// TypeBasicCopySourceTypePaypalSource ...
	TypeBasicCopySourceTypePaypalSource TypeBasicCopySource = "PaypalSource"
	// TypeBasicCopySourceTypePhoenixSource ...
	TypeBasicCopySourceTypePhoenixSource TypeBasicCopySource = "PhoenixSource"
	// TypeBasicCopySourceTypePostgreSQLSource ...
	TypeBasicCopySourceTypePostgreSQLSource TypeBasicCopySource = "PostgreSqlSource"
	// TypeBasicCopySourceTypePrestoSource ...
	TypeBasicCopySourceTypePrestoSource TypeBasicCopySource = "PrestoSource"
	// TypeBasicCopySourceTypeQuickBooksSource ...
	TypeBasicCopySourceTypeQuickBooksSource TypeBasicCopySource = "QuickBooksSource"
	// TypeBasicCopySourceTypeRelationalSource ...
	TypeBasicCopySourceTypeRelationalSource TypeBasicCopySource = "RelationalSource"
	// TypeBasicCopySourceTypeResponsysSource ...
	TypeBasicCopySourceTypeResponsysSource TypeBasicCopySource = "ResponsysSource"
	// TypeBasicCopySourceTypeRestSource ...
	TypeBasicCopySourceTypeRestSource TypeBasicCopySource = "RestSource"
	// TypeBasicCopySourceTypeSalesforceMarketingCloudSource ...
	TypeBasicCopySourceTypeSalesforceMarketingCloudSource TypeBasicCopySource = "SalesforceMarketingCloudSource"
	// TypeBasicCopySourceTypeSalesforceServiceCloudSource ...
	TypeBasicCopySourceTypeSalesforceServiceCloudSource TypeBasicCopySource = "SalesforceServiceCloudSource"
	// TypeBasicCopySourceTypeSalesforceSource ...
	TypeBasicCopySourceTypeSalesforceSource TypeBasicCopySource = "SalesforceSource"
	// TypeBasicCopySourceTypeSapBwSource ...
	TypeBasicCopySourceTypeSapBwSource TypeBasicCopySource = "SapBwSource"
	// TypeBasicCopySourceTypeSapCloudForCustomerSource ...
	TypeBasicCopySourceTypeSapCloudForCustomerSource TypeBasicCopySource = "SapCloudForCustomerSource"
	// TypeBasicCopySourceTypeSapEccSource ...
	TypeBasicCopySourceTypeSapEccSource TypeBasicCopySource = "SapEccSource"
	// TypeBasicCopySourceTypeSapHanaSource ...
	TypeBasicCopySourceTypeSapHanaSource TypeBasicCopySource = "SapHanaSource"
	// TypeBasicCopySourceTypeSapOpenHubSource ...
	TypeBasicCopySourceTypeSapOpenHubSource TypeBasicCopySource = "SapOpenHubSource"
	// TypeBasicCopySourceTypeSapTableSource ...
	TypeBasicCopySourceTypeSapTableSource TypeBasicCopySource = "SapTableSource"
	// TypeBasicCopySourceTypeServiceNowSource ...
	TypeBasicCopySourceTypeServiceNowSource TypeBasicCopySource = "ServiceNowSource"
	// TypeBasicCopySourceTypeSharePointOnlineListSource ...
	TypeBasicCopySourceTypeSharePointOnlineListSource TypeBasicCopySource = "SharePointOnlineListSource"
	// TypeBasicCopySourceTypeShopifySource ...
	TypeBasicCopySourceTypeShopifySource TypeBasicCopySource = "ShopifySource"
	// TypeBasicCopySourceTypeSnowflakeSource ...
	TypeBasicCopySourceTypeSnowflakeSource TypeBasicCopySource = "SnowflakeSource"
	// TypeBasicCopySourceTypeSparkSource ...
	TypeBasicCopySourceTypeSparkSource TypeBasicCopySource = "SparkSource"
	// TypeBasicCopySourceTypeSQLDWSource ...
	TypeBasicCopySourceTypeSQLDWSource TypeBasicCopySource = "SqlDWSource"
	// TypeBasicCopySourceTypeSQLMISource ...
	TypeBasicCopySourceTypeSQLMISource TypeBasicCopySource = "SqlMISource"
	// TypeBasicCopySourceTypeSQLServerSource ...
	TypeBasicCopySourceTypeSQLServerSource TypeBasicCopySource = "SqlServerSource"
	// TypeBasicCopySourceTypeSQLSource ...
	TypeBasicCopySourceTypeSQLSource TypeBasicCopySource = "SqlSource"
	// TypeBasicCopySourceTypeSquareSource ...
	TypeBasicCopySourceTypeSquareSource TypeBasicCopySource = "SquareSource"
	// TypeBasicCopySourceTypeSybaseSource ...
	TypeBasicCopySourceTypeSybaseSource TypeBasicCopySource = "SybaseSource"
	// TypeBasicCopySourceTypeTabularSource ...
	TypeBasicCopySourceTypeTabularSource TypeBasicCopySource = "TabularSource"
	// TypeBasicCopySourceTypeTeradataSource ...
	TypeBasicCopySourceTypeTeradataSource TypeBasicCopySource = "TeradataSource"
	// TypeBasicCopySourceTypeVerticaSource ...
	TypeBasicCopySourceTypeVerticaSource TypeBasicCopySource = "VerticaSource"
	// TypeBasicCopySourceTypeWebSource ...
	TypeBasicCopySourceTypeWebSource TypeBasicCopySource = "WebSource"
	// TypeBasicCopySourceTypeXeroSource ...
	TypeBasicCopySourceTypeXeroSource TypeBasicCopySource = "XeroSource"
	// TypeBasicCopySourceTypeXMLSource ...
	TypeBasicCopySourceTypeXMLSource TypeBasicCopySource = "XmlSource"
	// TypeBasicCopySourceTypeZohoSource ...
	TypeBasicCopySourceTypeZohoSource TypeBasicCopySource = "ZohoSource"
)

// PossibleTypeBasicCopySourceValues returns an array of possible values for the TypeBasicCopySource const type.
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return []TypeBasicCopySource{TypeBasicCopySourceTypeAmazonMWSSource, TypeBasicCopySourceTypeAmazonRdsForOracleSource, TypeBasicCopySourceTypeAmazonRdsForSQLServerSource, TypeBasicCopySourceTypeAmazonRedshiftSource, TypeBasicCopySourceTypeAvroSource, TypeBasicCopySourceTypeAzureBlobFSSource, TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource, TypeBasicCopySourceTypeAzureDataExplorerSource, TypeBasicCopySourceTypeAzureDataLakeStoreSource, TypeBasicCopySourceTypeAzureMariaDBSource, TypeBasicCopySourceTypeAzureMySQLSource, TypeBasicCopySourceTypeAzurePostgreSQLSource, TypeBasicCopySourceTypeAzureSQLSource, TypeBasicCopySourceTypeAzureTableSource, TypeBasicCopySourceTypeBinarySource, TypeBasicCopySourceTypeBlobSource, TypeBasicCopySourceTypeCassandraSource, TypeBasicCopySourceTypeCommonDataServiceForAppsSource, TypeBasicCopySourceTypeConcurSource, TypeBasicCopySourceTypeCopySource, TypeBasicCopySourceTypeCosmosDbMongoDbAPISource, TypeBasicCopySourceTypeCosmosDbSQLAPISource, TypeBasicCopySourceTypeCouchbaseSource, TypeBasicCopySourceTypeDb2Source, TypeBasicCopySourceTypeDelimitedTextSource, TypeBasicCopySourceTypeDocumentDbCollectionSource, TypeBasicCopySourceTypeDrillSource, TypeBasicCopySourceTypeDynamicsAXSource, TypeBasicCopySourceTypeDynamicsCrmSource, TypeBasicCopySourceTypeDynamicsSource, TypeBasicCopySourceTypeEloquaSource, TypeBasicCopySourceTypeExcelSource, TypeBasicCopySourceTypeFileSystemSource, TypeBasicCopySourceTypeGoogleAdWordsSource, TypeBasicCopySourceTypeGoogleBigQuerySource, TypeBasicCopySourceTypeGreenplumSource, TypeBasicCopySourceTypeHBaseSource, TypeBasicCopySourceTypeHdfsSource, TypeBasicCopySourceTypeHiveSource, TypeBasicCopySourceTypeHTTPSource, TypeBasicCopySourceTypeHubspotSource, TypeBasicCopySourceTypeImpalaSource, TypeBasicCopySourceTypeInformixSource, TypeBasicCopySourceTypeJiraSource, TypeBasicCopySourceTypeJSONSource, TypeBasicCopySourceTypeMagentoSource, TypeBasicCopySourceTypeMariaDBSource, TypeBasicCopySourceTypeMarketoSource, TypeBasicCopySourceTypeMicrosoftAccessSource, TypeBasicCopySourceTypeMongoDbAtlasSource, TypeBasicCopySourceTypeMongoDbSource, TypeBasicCopySourceTypeMongoDbV2Source, TypeBasicCopySourceTypeMySQLSource, TypeBasicCopySourceTypeNetezzaSource, TypeBasicCopySourceTypeODataSource, TypeBasicCopySourceTypeOdbcSource, TypeBasicCopySourceTypeOffice365Source, TypeBasicCopySourceTypeOracleServiceCloudSource, TypeBasicCopySourceTypeOracleSource, TypeBasicCopySourceTypeOrcSource, TypeBasicCopySourceTypeParquetSource, TypeBasicCopySourceTypePaypalSource, TypeBasicCopySourceTypePhoenixSource, TypeBasicCopySourceTypePostgreSQLSource, TypeBasicCopySourceTypePrestoSource, TypeBasicCopySourceTypeQuickBooksSource, TypeBasicCopySourceTypeRelationalSource, TypeBasicCopySourceTypeResponsysSource, TypeBasicCopySourceTypeRestSource, TypeBasicCopySourceTypeSalesforceMarketingCloudSource, TypeBasicCopySourceTypeSalesforceServiceCloudSource, TypeBasicCopySourceTypeSalesforceSource, TypeBasicCopySourceTypeSapBwSource, TypeBasicCopySourceTypeSapCloudForCustomerSource, TypeBasicCopySourceTypeSapEccSource, TypeBasicCopySourceTypeSapHanaSource, TypeBasicCopySourceTypeSapOpenHubSource, TypeBasicCopySourceTypeSapTableSource, TypeBasicCopySourceTypeServiceNowSource, TypeBasicCopySourceTypeSharePointOnlineListSource, TypeBasicCopySourceTypeShopifySource, TypeBasicCopySourceTypeSnowflakeSource, TypeBasicCopySourceTypeSparkSource, TypeBasicCopySourceTypeSQLDWSource, TypeBasicCopySourceTypeSQLMISource, TypeBasicCopySourceTypeSQLServerSource, TypeBasicCopySourceTypeSQLSource, TypeBasicCopySourceTypeSquareSource, TypeBasicCopySourceTypeSybaseSource, TypeBasicCopySourceTypeTabularSource, TypeBasicCopySourceTypeTeradataSource, TypeBasicCopySourceTypeVerticaSource, TypeBasicCopySourceTypeWebSource, TypeBasicCopySourceTypeXeroSource, TypeBasicCopySourceTypeXMLSource, TypeBasicCopySourceTypeZohoSource}
}

// TypeBasicCopyTranslator enumerates the values for type basic copy translator.
type TypeBasicCopyTranslator string

const (
	// TypeBasicCopyTranslatorTypeCopyTranslator ...
	TypeBasicCopyTranslatorTypeCopyTranslator TypeBasicCopyTranslator = "CopyTranslator"
	// TypeBasicCopyTranslatorTypeTabularTranslator ...
	TypeBasicCopyTranslatorTypeTabularTranslator TypeBasicCopyTranslator = "TabularTranslator"
)

// PossibleTypeBasicCopyTranslatorValues returns an array of possible values for the TypeBasicCopyTranslator const type.
func PossibleTypeBasicCopyTranslatorValues() []TypeBasicCopyTranslator {
	return []TypeBasicCopyTranslator{TypeBasicCopyTranslatorTypeCopyTranslator, TypeBasicCopyTranslatorTypeTabularTranslator}
}

// TypeBasicCredential enumerates the values for type basic credential.
type TypeBasicCredential string

const (
	// TypeBasicCredentialTypeCredential ...
	TypeBasicCredentialTypeCredential TypeBasicCredential = "Credential"
	// TypeBasicCredentialTypeManagedIdentity ...
	TypeBasicCredentialTypeManagedIdentity TypeBasicCredential = "ManagedIdentity"
	// TypeBasicCredentialTypeServicePrincipal ...
	TypeBasicCredentialTypeServicePrincipal TypeBasicCredential = "ServicePrincipal"
)

// PossibleTypeBasicCredentialValues returns an array of possible values for the TypeBasicCredential const type.
func PossibleTypeBasicCredentialValues() []TypeBasicCredential {
	return []TypeBasicCredential{TypeBasicCredentialTypeCredential, TypeBasicCredentialTypeManagedIdentity, TypeBasicCredentialTypeServicePrincipal}
}

// TypeBasicCustomSetupBase enumerates the values for type basic custom setup base.
type TypeBasicCustomSetupBase string

const (
	// TypeBasicCustomSetupBaseTypeAzPowerShellSetup ...
	TypeBasicCustomSetupBaseTypeAzPowerShellSetup TypeBasicCustomSetupBase = "AzPowerShellSetup"
	// TypeBasicCustomSetupBaseTypeCmdkeySetup ...
	TypeBasicCustomSetupBaseTypeCmdkeySetup TypeBasicCustomSetupBase = "CmdkeySetup"
	// TypeBasicCustomSetupBaseTypeComponentSetup ...
	TypeBasicCustomSetupBaseTypeComponentSetup TypeBasicCustomSetupBase = "ComponentSetup"
	// TypeBasicCustomSetupBaseTypeCustomSetupBase ...
	TypeBasicCustomSetupBaseTypeCustomSetupBase TypeBasicCustomSetupBase = "CustomSetupBase"
	// TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup ...
	TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup TypeBasicCustomSetupBase = "EnvironmentVariableSetup"
)

// PossibleTypeBasicCustomSetupBaseValues returns an array of possible values for the TypeBasicCustomSetupBase const type.
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return []TypeBasicCustomSetupBase{TypeBasicCustomSetupBaseTypeAzPowerShellSetup, TypeBasicCustomSetupBaseTypeCmdkeySetup, TypeBasicCustomSetupBaseTypeComponentSetup, TypeBasicCustomSetupBaseTypeCustomSetupBase, TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup}
}

// TypeBasicDataFlow enumerates the values for type basic data flow.
type TypeBasicDataFlow string

const (
	// TypeBasicDataFlowTypeDataFlow ...
	TypeBasicDataFlowTypeDataFlow TypeBasicDataFlow = "DataFlow"
	// TypeBasicDataFlowTypeMappingDataFlow ...
	TypeBasicDataFlowTypeMappingDataFlow TypeBasicDataFlow = "MappingDataFlow"
	// TypeBasicDataFlowTypeWranglingDataFlow ...
	TypeBasicDataFlowTypeWranglingDataFlow TypeBasicDataFlow = "WranglingDataFlow"
)

// PossibleTypeBasicDataFlowValues returns an array of possible values for the TypeBasicDataFlow const type.
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return []TypeBasicDataFlow{TypeBasicDataFlowTypeDataFlow, TypeBasicDataFlowTypeMappingDataFlow, TypeBasicDataFlowTypeWranglingDataFlow}
}

// TypeBasicDataset enumerates the values for type basic dataset.
type TypeBasicDataset string

const (
	// TypeBasicDatasetTypeAmazonMWSObject ...
	TypeBasicDatasetTypeAmazonMWSObject TypeBasicDataset = "AmazonMWSObject"
	// TypeBasicDatasetTypeAmazonRdsForOracleTable ...
	TypeBasicDatasetTypeAmazonRdsForOracleTable TypeBasicDataset = "AmazonRdsForOracleTable"
	// TypeBasicDatasetTypeAmazonRdsForSQLServerTable ...
	TypeBasicDatasetTypeAmazonRdsForSQLServerTable TypeBasicDataset = "AmazonRdsForSqlServerTable"
	// TypeBasicDatasetTypeAmazonRedshiftTable ...
	TypeBasicDatasetTypeAmazonRedshiftTable TypeBasicDataset = "AmazonRedshiftTable"
	// TypeBasicDatasetTypeAmazonS3Object ...
	TypeBasicDatasetTypeAmazonS3Object TypeBasicDataset = "AmazonS3Object"
	// TypeBasicDatasetTypeAvro ...
	TypeBasicDatasetTypeAvro TypeBasicDataset = "Avro"
	// TypeBasicDatasetTypeAzureBlob ...
	TypeBasicDatasetTypeAzureBlob TypeBasicDataset = "AzureBlob"
	// TypeBasicDatasetTypeAzureBlobFSFile ...
	TypeBasicDatasetTypeAzureBlobFSFile TypeBasicDataset = "AzureBlobFSFile"
	// TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset ...
	TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset TypeBasicDataset = "AzureDatabricksDeltaLakeDataset"
	// TypeBasicDatasetTypeAzureDataExplorerTable ...
	TypeBasicDatasetTypeAzureDataExplorerTable TypeBasicDataset = "AzureDataExplorerTable"
	// TypeBasicDatasetTypeAzureDataLakeStoreFile ...
	TypeBasicDatasetTypeAzureDataLakeStoreFile TypeBasicDataset = "AzureDataLakeStoreFile"
	// TypeBasicDatasetTypeAzureMariaDBTable ...
	TypeBasicDatasetTypeAzureMariaDBTable TypeBasicDataset = "AzureMariaDBTable"
	// TypeBasicDatasetTypeAzureMySQLTable ...
	TypeBasicDatasetTypeAzureMySQLTable TypeBasicDataset = "AzureMySqlTable"
	// TypeBasicDatasetTypeAzurePostgreSQLTable ...
	TypeBasicDatasetTypeAzurePostgreSQLTable TypeBasicDataset = "AzurePostgreSqlTable"
	// TypeBasicDatasetTypeAzureSearchIndex ...
	TypeBasicDatasetTypeAzureSearchIndex TypeBasicDataset = "AzureSearchIndex"
	// TypeBasicDatasetTypeAzureSQLDWTable ...
	TypeBasicDatasetTypeAzureSQLDWTable TypeBasicDataset = "AzureSqlDWTable"
	// TypeBasicDatasetTypeAzureSQLMITable ...
	TypeBasicDatasetTypeAzureSQLMITable TypeBasicDataset = "AzureSqlMITable"
	// TypeBasicDatasetTypeAzureSQLTable ...
	TypeBasicDatasetTypeAzureSQLTable TypeBasicDataset = "AzureSqlTable"
	// TypeBasicDatasetTypeAzureTable ...
	TypeBasicDatasetTypeAzureTable TypeBasicDataset = "AzureTable"
	// TypeBasicDatasetTypeBinary ...
	TypeBasicDatasetTypeBinary TypeBasicDataset = "Binary"
	// TypeBasicDatasetTypeCassandraTable ...
	TypeBasicDatasetTypeCassandraTable TypeBasicDataset = "CassandraTable"
	// TypeBasicDatasetTypeCommonDataServiceForAppsEntity ...
	TypeBasicDatasetTypeCommonDataServiceForAppsEntity TypeBasicDataset = "CommonDataServiceForAppsEntity"
	// TypeBasicDatasetTypeConcurObject ...
	TypeBasicDatasetTypeConcurObject TypeBasicDataset = "ConcurObject"
	// TypeBasicDatasetTypeCosmosDbMongoDbAPICollection ...
	TypeBasicDatasetTypeCosmosDbMongoDbAPICollection TypeBasicDataset = "CosmosDbMongoDbApiCollection"
	// TypeBasicDatasetTypeCosmosDbSQLAPICollection ...
	TypeBasicDatasetTypeCosmosDbSQLAPICollection TypeBasicDataset = "CosmosDbSqlApiCollection"
	// TypeBasicDatasetTypeCouchbaseTable ...
	TypeBasicDatasetTypeCouchbaseTable TypeBasicDataset = "CouchbaseTable"
	// TypeBasicDatasetTypeCustomDataset ...
	TypeBasicDatasetTypeCustomDataset TypeBasicDataset = "CustomDataset"
	// TypeBasicDatasetTypeDataset ...
	TypeBasicDatasetTypeDataset TypeBasicDataset = "Dataset"
	// TypeBasicDatasetTypeDb2Table ...
	TypeBasicDatasetTypeDb2Table TypeBasicDataset = "Db2Table"
	// TypeBasicDatasetTypeDelimitedText ...
	TypeBasicDatasetTypeDelimitedText TypeBasicDataset = "DelimitedText"
	// TypeBasicDatasetTypeDocumentDbCollection ...
	TypeBasicDatasetTypeDocumentDbCollection TypeBasicDataset = "DocumentDbCollection"
	// TypeBasicDatasetTypeDrillTable ...
	TypeBasicDatasetTypeDrillTable TypeBasicDataset = "DrillTable"
	// TypeBasicDatasetTypeDynamicsAXResource ...
	TypeBasicDatasetTypeDynamicsAXResource TypeBasicDataset = "DynamicsAXResource"
	// TypeBasicDatasetTypeDynamicsCrmEntity ...
	TypeBasicDatasetTypeDynamicsCrmEntity TypeBasicDataset = "DynamicsCrmEntity"
	// TypeBasicDatasetTypeDynamicsEntity ...
	TypeBasicDatasetTypeDynamicsEntity TypeBasicDataset = "DynamicsEntity"
	// TypeBasicDatasetTypeEloquaObject ...
	TypeBasicDatasetTypeEloquaObject TypeBasicDataset = "EloquaObject"
	// TypeBasicDatasetTypeExcel ...
	TypeBasicDatasetTypeExcel TypeBasicDataset = "Excel"
	// TypeBasicDatasetTypeFileShare ...
	TypeBasicDatasetTypeFileShare TypeBasicDataset = "FileShare"
	// TypeBasicDatasetTypeGoogleAdWordsObject ...
	TypeBasicDatasetTypeGoogleAdWordsObject TypeBasicDataset = "GoogleAdWordsObject"
	// TypeBasicDatasetTypeGoogleBigQueryObject ...
	TypeBasicDatasetTypeGoogleBigQueryObject TypeBasicDataset = "GoogleBigQueryObject"
	// TypeBasicDatasetTypeGreenplumTable ...
	TypeBasicDatasetTypeGreenplumTable TypeBasicDataset = "GreenplumTable"
	// TypeBasicDatasetTypeHBaseObject ...
	TypeBasicDatasetTypeHBaseObject TypeBasicDataset = "HBaseObject"
	// TypeBasicDatasetTypeHiveObject ...
	TypeBasicDatasetTypeHiveObject TypeBasicDataset = "HiveObject"
	// TypeBasicDatasetTypeHTTPFile ...
	TypeBasicDatasetTypeHTTPFile TypeBasicDataset = "HttpFile"
	// TypeBasicDatasetTypeHubspotObject ...
	TypeBasicDatasetTypeHubspotObject TypeBasicDataset = "HubspotObject"
	// TypeBasicDatasetTypeImpalaObject ...
	TypeBasicDatasetTypeImpalaObject TypeBasicDataset = "ImpalaObject"
	// TypeBasicDatasetTypeInformixTable ...
	TypeBasicDatasetTypeInformixTable TypeBasicDataset = "InformixTable"
	// TypeBasicDatasetTypeJiraObject ...
	TypeBasicDatasetTypeJiraObject TypeBasicDataset = "JiraObject"
	// TypeBasicDatasetTypeJSON ...
	TypeBasicDatasetTypeJSON TypeBasicDataset = "Json"
	// TypeBasicDatasetTypeMagentoObject ...
	TypeBasicDatasetTypeMagentoObject TypeBasicDataset = "MagentoObject"
	// TypeBasicDatasetTypeMariaDBTable ...
	TypeBasicDatasetTypeMariaDBTable TypeBasicDataset = "MariaDBTable"
	// TypeBasicDatasetTypeMarketoObject ...
	TypeBasicDatasetTypeMarketoObject TypeBasicDataset = "MarketoObject"
	// TypeBasicDatasetTypeMicrosoftAccessTable ...
	TypeBasicDatasetTypeMicrosoftAccessTable TypeBasicDataset = "MicrosoftAccessTable"
	// TypeBasicDatasetTypeMongoDbAtlasCollection ...
	TypeBasicDatasetTypeMongoDbAtlasCollection TypeBasicDataset = "MongoDbAtlasCollection"
	// TypeBasicDatasetTypeMongoDbCollection ...
	TypeBasicDatasetTypeMongoDbCollection TypeBasicDataset = "MongoDbCollection"
	// TypeBasicDatasetTypeMongoDbV2Collection ...
	TypeBasicDatasetTypeMongoDbV2Collection TypeBasicDataset = "MongoDbV2Collection"
	// TypeBasicDatasetTypeMySQLTable ...
	TypeBasicDatasetTypeMySQLTable TypeBasicDataset = "MySqlTable"
	// TypeBasicDatasetTypeNetezzaTable ...
	TypeBasicDatasetTypeNetezzaTable TypeBasicDataset = "NetezzaTable"
	// TypeBasicDatasetTypeODataResource ...
	TypeBasicDatasetTypeODataResource TypeBasicDataset = "ODataResource"
	// TypeBasicDatasetTypeOdbcTable ...
	TypeBasicDatasetTypeOdbcTable TypeBasicDataset = "OdbcTable"
	// TypeBasicDatasetTypeOffice365Table ...
	TypeBasicDatasetTypeOffice365Table TypeBasicDataset = "Office365Table"
	// TypeBasicDatasetTypeOracleServiceCloudObject ...
	TypeBasicDatasetTypeOracleServiceCloudObject TypeBasicDataset = "OracleServiceCloudObject"
	// TypeBasicDatasetTypeOracleTable ...
	TypeBasicDatasetTypeOracleTable TypeBasicDataset = "OracleTable"
	// TypeBasicDatasetTypeOrc ...
	TypeBasicDatasetTypeOrc TypeBasicDataset = "Orc"
	// TypeBasicDatasetTypeParquet ...
	TypeBasicDatasetTypeParquet TypeBasicDataset = "Parquet"
	// TypeBasicDatasetTypePaypalObject ...
	TypeBasicDatasetTypePaypalObject TypeBasicDataset = "PaypalObject"
	// TypeBasicDatasetTypePhoenixObject ...
	TypeBasicDatasetTypePhoenixObject TypeBasicDataset = "PhoenixObject"
	// TypeBasicDatasetTypePostgreSQLTable ...
	TypeBasicDatasetTypePostgreSQLTable TypeBasicDataset = "PostgreSqlTable"
	// TypeBasicDatasetTypePrestoObject ...
	TypeBasicDatasetTypePrestoObject TypeBasicDataset = "PrestoObject"
	// TypeBasicDatasetTypeQuickBooksObject ...
	TypeBasicDatasetTypeQuickBooksObject TypeBasicDataset = "QuickBooksObject"
	// TypeBasicDatasetTypeRelationalTable ...
	TypeBasicDatasetTypeRelationalTable TypeBasicDataset = "RelationalTable"
	// TypeBasicDatasetTypeResponsysObject ...
	TypeBasicDatasetTypeResponsysObject TypeBasicDataset = "ResponsysObject"
	// TypeBasicDatasetTypeRestResource ...
	TypeBasicDatasetTypeRestResource TypeBasicDataset = "RestResource"
	// TypeBasicDatasetTypeSalesforceMarketingCloudObject ...
	TypeBasicDatasetTypeSalesforceMarketingCloudObject TypeBasicDataset = "SalesforceMarketingCloudObject"
	// TypeBasicDatasetTypeSalesforceObject ...
	TypeBasicDatasetTypeSalesforceObject TypeBasicDataset = "SalesforceObject"
	// TypeBasicDatasetTypeSalesforceServiceCloudObject ...
	TypeBasicDatasetTypeSalesforceServiceCloudObject TypeBasicDataset = "SalesforceServiceCloudObject"
	// TypeBasicDatasetTypeSapBwCube ...
	TypeBasicDatasetTypeSapBwCube TypeBasicDataset = "SapBwCube"
	// TypeBasicDatasetTypeSapCloudForCustomerResource ...
	TypeBasicDatasetTypeSapCloudForCustomerResource TypeBasicDataset = "SapCloudForCustomerResource"
	// TypeBasicDatasetTypeSapEccResource ...
	TypeBasicDatasetTypeSapEccResource TypeBasicDataset = "SapEccResource"
	// TypeBasicDatasetTypeSapHanaTable ...
	TypeBasicDatasetTypeSapHanaTable TypeBasicDataset = "SapHanaTable"
	// TypeBasicDatasetTypeSapOpenHubTable ...
	TypeBasicDatasetTypeSapOpenHubTable TypeBasicDataset = "SapOpenHubTable"
	// TypeBasicDatasetTypeSapTableResource ...
	TypeBasicDatasetTypeSapTableResource TypeBasicDataset = "SapTableResource"
	// TypeBasicDatasetTypeServiceNowObject ...
	TypeBasicDatasetTypeServiceNowObject TypeBasicDataset = "ServiceNowObject"
	// TypeBasicDatasetTypeSharePointOnlineListResource ...
	TypeBasicDatasetTypeSharePointOnlineListResource TypeBasicDataset = "SharePointOnlineListResource"
	// TypeBasicDatasetTypeShopifyObject ...
	TypeBasicDatasetTypeShopifyObject TypeBasicDataset = "ShopifyObject"
	// TypeBasicDatasetTypeSnowflakeTable ...
	TypeBasicDatasetTypeSnowflakeTable TypeBasicDataset = "SnowflakeTable"
	// TypeBasicDatasetTypeSparkObject ...
	TypeBasicDatasetTypeSparkObject TypeBasicDataset = "SparkObject"
	// TypeBasicDatasetTypeSQLServerTable ...
	TypeBasicDatasetTypeSQLServerTable TypeBasicDataset = "SqlServerTable"
	// TypeBasicDatasetTypeSquareObject ...
	TypeBasicDatasetTypeSquareObject TypeBasicDataset = "SquareObject"
	// TypeBasicDatasetTypeSybaseTable ...
	TypeBasicDatasetTypeSybaseTable TypeBasicDataset = "SybaseTable"
	// TypeBasicDatasetTypeTeradataTable ...
	TypeBasicDatasetTypeTeradataTable TypeBasicDataset = "TeradataTable"
	// TypeBasicDatasetTypeVerticaTable ...
	TypeBasicDatasetTypeVerticaTable TypeBasicDataset = "VerticaTable"
	// TypeBasicDatasetTypeWebTable ...
	TypeBasicDatasetTypeWebTable TypeBasicDataset = "WebTable"
	// TypeBasicDatasetTypeXeroObject ...
	TypeBasicDatasetTypeXeroObject TypeBasicDataset = "XeroObject"
	// TypeBasicDatasetTypeXML ...
	TypeBasicDatasetTypeXML TypeBasicDataset = "Xml"
	// TypeBasicDatasetTypeZohoObject ...
	TypeBasicDatasetTypeZohoObject TypeBasicDataset = "ZohoObject"
)

// PossibleTypeBasicDatasetValues returns an array of possible values for the TypeBasicDataset const type.
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return []TypeBasicDataset{TypeBasicDatasetTypeAmazonMWSObject, TypeBasicDatasetTypeAmazonRdsForOracleTable, TypeBasicDatasetTypeAmazonRdsForSQLServerTable, TypeBasicDatasetTypeAmazonRedshiftTable, TypeBasicDatasetTypeAmazonS3Object, TypeBasicDatasetTypeAvro, TypeBasicDatasetTypeAzureBlob, TypeBasicDatasetTypeAzureBlobFSFile, TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset, TypeBasicDatasetTypeAzureDataExplorerTable, TypeBasicDatasetTypeAzureDataLakeStoreFile, TypeBasicDatasetTypeAzureMariaDBTable, TypeBasicDatasetTypeAzureMySQLTable, TypeBasicDatasetTypeAzurePostgreSQLTable, TypeBasicDatasetTypeAzureSearchIndex, TypeBasicDatasetTypeAzureSQLDWTable, TypeBasicDatasetTypeAzureSQLMITable, TypeBasicDatasetTypeAzureSQLTable, TypeBasicDatasetTypeAzureTable, TypeBasicDatasetTypeBinary, TypeBasicDatasetTypeCassandraTable, TypeBasicDatasetTypeCommonDataServiceForAppsEntity, TypeBasicDatasetTypeConcurObject, TypeBasicDatasetTypeCosmosDbMongoDbAPICollection, TypeBasicDatasetTypeCosmosDbSQLAPICollection, TypeBasicDatasetTypeCouchbaseTable, TypeBasicDatasetTypeCustomDataset, TypeBasicDatasetTypeDataset, TypeBasicDatasetTypeDb2Table, TypeBasicDatasetTypeDelimitedText, TypeBasicDatasetTypeDocumentDbCollection, TypeBasicDatasetTypeDrillTable, TypeBasicDatasetTypeDynamicsAXResource, TypeBasicDatasetTypeDynamicsCrmEntity, TypeBasicDatasetTypeDynamicsEntity, TypeBasicDatasetTypeEloquaObject, TypeBasicDatasetTypeExcel, TypeBasicDatasetTypeFileShare, TypeBasicDatasetTypeGoogleAdWordsObject, TypeBasicDatasetTypeGoogleBigQueryObject, TypeBasicDatasetTypeGreenplumTable, TypeBasicDatasetTypeHBaseObject, TypeBasicDatasetTypeHiveObject, TypeBasicDatasetTypeHTTPFile, TypeBasicDatasetTypeHubspotObject, TypeBasicDatasetTypeImpalaObject, TypeBasicDatasetTypeInformixTable, TypeBasicDatasetTypeJiraObject, TypeBasicDatasetTypeJSON, TypeBasicDatasetTypeMagentoObject, TypeBasicDatasetTypeMariaDBTable, TypeBasicDatasetTypeMarketoObject, TypeBasicDatasetTypeMicrosoftAccessTable, TypeBasicDatasetTypeMongoDbAtlasCollection, TypeBasicDatasetTypeMongoDbCollection, TypeBasicDatasetTypeMongoDbV2Collection, TypeBasicDatasetTypeMySQLTable, TypeBasicDatasetTypeNetezzaTable, TypeBasicDatasetTypeODataResource, TypeBasicDatasetTypeOdbcTable, TypeBasicDatasetTypeOffice365Table, TypeBasicDatasetTypeOracleServiceCloudObject, TypeBasicDatasetTypeOracleTable, TypeBasicDatasetTypeOrc, TypeBasicDatasetTypeParquet, TypeBasicDatasetTypePaypalObject, TypeBasicDatasetTypePhoenixObject, TypeBasicDatasetTypePostgreSQLTable, TypeBasicDatasetTypePrestoObject, TypeBasicDatasetTypeQuickBooksObject, TypeBasicDatasetTypeRelationalTable, TypeBasicDatasetTypeResponsysObject, TypeBasicDatasetTypeRestResource, TypeBasicDatasetTypeSalesforceMarketingCloudObject, TypeBasicDatasetTypeSalesforceObject, TypeBasicDatasetTypeSalesforceServiceCloudObject, TypeBasicDatasetTypeSapBwCube, TypeBasicDatasetTypeSapCloudForCustomerResource, TypeBasicDatasetTypeSapEccResource, TypeBasicDatasetTypeSapHanaTable, TypeBasicDatasetTypeSapOpenHubTable, TypeBasicDatasetTypeSapTableResource, TypeBasicDatasetTypeServiceNowObject, TypeBasicDatasetTypeSharePointOnlineListResource, TypeBasicDatasetTypeShopifyObject, TypeBasicDatasetTypeSnowflakeTable, TypeBasicDatasetTypeSparkObject, TypeBasicDatasetTypeSQLServerTable, TypeBasicDatasetTypeSquareObject, TypeBasicDatasetTypeSybaseTable, TypeBasicDatasetTypeTeradataTable, TypeBasicDatasetTypeVerticaTable, TypeBasicDatasetTypeWebTable, TypeBasicDatasetTypeXeroObject, TypeBasicDatasetTypeXML, TypeBasicDatasetTypeZohoObject}
}

// TypeBasicDatasetCompression enumerates the values for type basic dataset compression.
type TypeBasicDatasetCompression string

const (
	// TypeBasicDatasetCompressionTypeBZip2 ...
	TypeBasicDatasetCompressionTypeBZip2 TypeBasicDatasetCompression = "BZip2"
	// TypeBasicDatasetCompressionTypeDatasetCompression ...
	TypeBasicDatasetCompressionTypeDatasetCompression TypeBasicDatasetCompression = "DatasetCompression"
	// TypeBasicDatasetCompressionTypeDeflate ...
	TypeBasicDatasetCompressionTypeDeflate TypeBasicDatasetCompression = "Deflate"
	// TypeBasicDatasetCompressionTypeGZip ...
	TypeBasicDatasetCompressionTypeGZip TypeBasicDatasetCompression = "GZip"
	// TypeBasicDatasetCompressionTypeTar ...
	TypeBasicDatasetCompressionTypeTar TypeBasicDatasetCompression = "Tar"
	// TypeBasicDatasetCompressionTypeTarGZip ...
	TypeBasicDatasetCompressionTypeTarGZip TypeBasicDatasetCompression = "TarGZip"
	// TypeBasicDatasetCompressionTypeZipDeflate ...
	TypeBasicDatasetCompressionTypeZipDeflate TypeBasicDatasetCompression = "ZipDeflate"
)

// PossibleTypeBasicDatasetCompressionValues returns an array of possible values for the TypeBasicDatasetCompression const type.
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return []TypeBasicDatasetCompression{TypeBasicDatasetCompressionTypeBZip2, TypeBasicDatasetCompressionTypeDatasetCompression, TypeBasicDatasetCompressionTypeDeflate, TypeBasicDatasetCompressionTypeGZip, TypeBasicDatasetCompressionTypeTar, TypeBasicDatasetCompressionTypeTarGZip, TypeBasicDatasetCompressionTypeZipDeflate}
}

// TypeBasicDatasetLocation enumerates the values for type basic dataset location.
type TypeBasicDatasetLocation string

const (
	// TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation ...
	TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation TypeBasicDatasetLocation = "AmazonS3CompatibleLocation"
	// TypeBasicDatasetLocationTypeAmazonS3Location ...
	TypeBasicDatasetLocationTypeAmazonS3Location TypeBasicDatasetLocation = "AmazonS3Location"
	// TypeBasicDatasetLocationTypeAzureBlobFSLocation ...
	TypeBasicDatasetLocationTypeAzureBlobFSLocation TypeBasicDatasetLocation = "AzureBlobFSLocation"
	// TypeBasicDatasetLocationTypeAzureBlobStorageLocation ...
	TypeBasicDatasetLocationTypeAzureBlobStorageLocation TypeBasicDatasetLocation = "AzureBlobStorageLocation"
	// TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation ...
	TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation TypeBasicDatasetLocation = "AzureDataLakeStoreLocation"
	// TypeBasicDatasetLocationTypeAzureFileStorageLocation ...
	TypeBasicDatasetLocationTypeAzureFileStorageLocation TypeBasicDatasetLocation = "AzureFileStorageLocation"
	// TypeBasicDatasetLocationTypeDatasetLocation ...
	TypeBasicDatasetLocationTypeDatasetLocation TypeBasicDatasetLocation = "DatasetLocation"
	// TypeBasicDatasetLocationTypeFileServerLocation ...
	TypeBasicDatasetLocationTypeFileServerLocation TypeBasicDatasetLocation = "FileServerLocation"
	// TypeBasicDatasetLocationTypeFtpServerLocation ...
	TypeBasicDatasetLocationTypeFtpServerLocation TypeBasicDatasetLocation = "FtpServerLocation"
	// TypeBasicDatasetLocationTypeGoogleCloudStorageLocation ...
	TypeBasicDatasetLocationTypeGoogleCloudStorageLocation TypeBasicDatasetLocation = "GoogleCloudStorageLocation"
	// TypeBasicDatasetLocationTypeHdfsLocation ...
	TypeBasicDatasetLocationTypeHdfsLocation TypeBasicDatasetLocation = "HdfsLocation"
	// TypeBasicDatasetLocationTypeHTTPServerLocation ...
	TypeBasicDatasetLocationTypeHTTPServerLocation TypeBasicDatasetLocation = "HttpServerLocation"
	// TypeBasicDatasetLocationTypeOracleCloudStorageLocation ...
	TypeBasicDatasetLocationTypeOracleCloudStorageLocation TypeBasicDatasetLocation = "OracleCloudStorageLocation"
	// TypeBasicDatasetLocationTypeSftpLocation ...
	TypeBasicDatasetLocationTypeSftpLocation TypeBasicDatasetLocation = "SftpLocation"
)

// PossibleTypeBasicDatasetLocationValues returns an array of possible values for the TypeBasicDatasetLocation const type.
func PossibleTypeBasicDatasetLocationValues() []TypeBasicDatasetLocation {
	return []TypeBasicDatasetLocation{TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation, TypeBasicDatasetLocationTypeAmazonS3Location, TypeBasicDatasetLocationTypeAzureBlobFSLocation, TypeBasicDatasetLocationTypeAzureBlobStorageLocation, TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation, TypeBasicDatasetLocationTypeAzureFileStorageLocation, TypeBasicDatasetLocationTypeDatasetLocation, TypeBasicDatasetLocationTypeFileServerLocation, TypeBasicDatasetLocationTypeFtpServerLocation, TypeBasicDatasetLocationTypeGoogleCloudStorageLocation, TypeBasicDatasetLocationTypeHdfsLocation, TypeBasicDatasetLocationTypeHTTPServerLocation, TypeBasicDatasetLocationTypeOracleCloudStorageLocation, TypeBasicDatasetLocationTypeSftpLocation}
}

// TypeBasicDatasetStorageFormat enumerates the values for type basic dataset storage format.
type TypeBasicDatasetStorageFormat string

const (
	// TypeBasicDatasetStorageFormatTypeAvroFormat ...
	TypeBasicDatasetStorageFormatTypeAvroFormat TypeBasicDatasetStorageFormat = "AvroFormat"
	// TypeBasicDatasetStorageFormatTypeDatasetStorageFormat ...
	TypeBasicDatasetStorageFormatTypeDatasetStorageFormat TypeBasicDatasetStorageFormat = "DatasetStorageFormat"
	// TypeBasicDatasetStorageFormatTypeJSONFormat ...
	TypeBasicDatasetStorageFormatTypeJSONFormat TypeBasicDatasetStorageFormat = "JsonFormat"
	// TypeBasicDatasetStorageFormatTypeOrcFormat ...
	TypeBasicDatasetStorageFormatTypeOrcFormat TypeBasicDatasetStorageFormat = "OrcFormat"
	// TypeBasicDatasetStorageFormatTypeParquetFormat ...
	TypeBasicDatasetStorageFormatTypeParquetFormat TypeBasicDatasetStorageFormat = "ParquetFormat"
	// TypeBasicDatasetStorageFormatTypeTextFormat ...
	TypeBasicDatasetStorageFormatTypeTextFormat TypeBasicDatasetStorageFormat = "TextFormat"
)

// PossibleTypeBasicDatasetStorageFormatValues returns an array of possible values for the TypeBasicDatasetStorageFormat const type.
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return []TypeBasicDatasetStorageFormat{TypeBasicDatasetStorageFormatTypeAvroFormat, TypeBasicDatasetStorageFormatTypeDatasetStorageFormat, TypeBasicDatasetStorageFormatTypeJSONFormat, TypeBasicDatasetStorageFormatTypeOrcFormat, TypeBasicDatasetStorageFormatTypeParquetFormat, TypeBasicDatasetStorageFormatTypeTextFormat}
}

// TypeBasicDependencyReference enumerates the values for type basic dependency reference.
type TypeBasicDependencyReference string

const (
	// TypeBasicDependencyReferenceTypeDependencyReference ...
	TypeBasicDependencyReferenceTypeDependencyReference TypeBasicDependencyReference = "DependencyReference"
	// TypeBasicDependencyReferenceTypeSelfDependencyTumblingWindowTriggerReference ...
	TypeBasicDependencyReferenceTypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = "SelfDependencyTumblingWindowTriggerReference"
	// TypeBasicDependencyReferenceTypeTriggerDependencyReference ...
	TypeBasicDependencyReferenceTypeTriggerDependencyReference TypeBasicDependencyReference = "TriggerDependencyReference"
	// TypeBasicDependencyReferenceTypeTumblingWindowTriggerDependencyReference ...
	TypeBasicDependencyReferenceTypeTumblingWindowTriggerDependencyReference TypeBasicDependencyReference = "TumblingWindowTriggerDependencyReference"
)

// PossibleTypeBasicDependencyReferenceValues returns an array of possible values for the TypeBasicDependencyReference const type.
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return []TypeBasicDependencyReference{TypeBasicDependencyReferenceTypeDependencyReference, TypeBasicDependencyReferenceTypeSelfDependencyTumblingWindowTriggerReference, TypeBasicDependencyReferenceTypeTriggerDependencyReference, TypeBasicDependencyReferenceTypeTumblingWindowTriggerDependencyReference}
}

// TypeBasicExportSettings enumerates the values for type basic export settings.
type TypeBasicExportSettings string

const (
	// TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand ...
	TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand TypeBasicExportSettings = "AzureDatabricksDeltaLakeExportCommand"
	// TypeBasicExportSettingsTypeExportSettings ...
	TypeBasicExportSettingsTypeExportSettings TypeBasicExportSettings = "ExportSettings"
	// TypeBasicExportSettingsTypeSnowflakeExportCopyCommand ...
	TypeBasicExportSettingsTypeSnowflakeExportCopyCommand TypeBasicExportSettings = "SnowflakeExportCopyCommand"
)

// PossibleTypeBasicExportSettingsValues returns an array of possible values for the TypeBasicExportSettings const type.
func PossibleTypeBasicExportSettingsValues() []TypeBasicExportSettings {
	return []TypeBasicExportSettings{TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand, TypeBasicExportSettingsTypeExportSettings, TypeBasicExportSettingsTypeSnowflakeExportCopyCommand}
}

// TypeBasicFactoryRepoConfiguration enumerates the values for type basic factory repo configuration.
type TypeBasicFactoryRepoConfiguration string

const (
	// TypeBasicFactoryRepoConfigurationTypeFactoryGitHubConfiguration ...
	TypeBasicFactoryRepoConfigurationTypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = "FactoryGitHubConfiguration"
	// TypeBasicFactoryRepoConfigurationTypeFactoryRepoConfiguration ...
	TypeBasicFactoryRepoConfigurationTypeFactoryRepoConfiguration TypeBasicFactoryRepoConfiguration = "FactoryRepoConfiguration"
	// TypeBasicFactoryRepoConfigurationTypeFactoryVSTSConfiguration ...
	TypeBasicFactoryRepoConfigurationTypeFactoryVSTSConfiguration TypeBasicFactoryRepoConfiguration = "FactoryVSTSConfiguration"
)

// PossibleTypeBasicFactoryRepoConfigurationValues returns an array of possible values for the TypeBasicFactoryRepoConfiguration const type.
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return []TypeBasicFactoryRepoConfiguration{TypeBasicFactoryRepoConfigurationTypeFactoryGitHubConfiguration, TypeBasicFactoryRepoConfigurationTypeFactoryRepoConfiguration, TypeBasicFactoryRepoConfigurationTypeFactoryVSTSConfiguration}
}

// TypeBasicFormatReadSettings enumerates the values for type basic format read settings.
type TypeBasicFormatReadSettings string

const (
	// TypeBasicFormatReadSettingsTypeBinaryReadSettings ...
	TypeBasicFormatReadSettingsTypeBinaryReadSettings TypeBasicFormatReadSettings = "BinaryReadSettings"
	// TypeBasicFormatReadSettingsTypeDelimitedTextReadSettings ...
	TypeBasicFormatReadSettingsTypeDelimitedTextReadSettings TypeBasicFormatReadSettings = "DelimitedTextReadSettings"
	// TypeBasicFormatReadSettingsTypeFormatReadSettings ...
	TypeBasicFormatReadSettingsTypeFormatReadSettings TypeBasicFormatReadSettings = "FormatReadSettings"
	// TypeBasicFormatReadSettingsTypeJSONReadSettings ...
	TypeBasicFormatReadSettingsTypeJSONReadSettings TypeBasicFormatReadSettings = "JsonReadSettings"
	// TypeBasicFormatReadSettingsTypeXMLReadSettings ...
	TypeBasicFormatReadSettingsTypeXMLReadSettings TypeBasicFormatReadSettings = "XmlReadSettings"
)

// PossibleTypeBasicFormatReadSettingsValues returns an array of possible values for the TypeBasicFormatReadSettings const type.
func PossibleTypeBasicFormatReadSettingsValues() []TypeBasicFormatReadSettings {
	return []TypeBasicFormatReadSettings{TypeBasicFormatReadSettingsTypeBinaryReadSettings, TypeBasicFormatReadSettingsTypeDelimitedTextReadSettings, TypeBasicFormatReadSettingsTypeFormatReadSettings, TypeBasicFormatReadSettingsTypeJSONReadSettings, TypeBasicFormatReadSettingsTypeXMLReadSettings}
}

// TypeBasicFormatWriteSettings enumerates the values for type basic format write settings.
type TypeBasicFormatWriteSettings string

const (
	// TypeBasicFormatWriteSettingsTypeAvroWriteSettings ...
	TypeBasicFormatWriteSettingsTypeAvroWriteSettings TypeBasicFormatWriteSettings = "AvroWriteSettings"
	// TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings ...
	TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings TypeBasicFormatWriteSettings = "DelimitedTextWriteSettings"
	// TypeBasicFormatWriteSettingsTypeFormatWriteSettings ...
	TypeBasicFormatWriteSettingsTypeFormatWriteSettings TypeBasicFormatWriteSettings = "FormatWriteSettings"
	// TypeBasicFormatWriteSettingsTypeJSONWriteSettings ...
	TypeBasicFormatWriteSettingsTypeJSONWriteSettings TypeBasicFormatWriteSettings = "JsonWriteSettings"
	// TypeBasicFormatWriteSettingsTypeOrcWriteSettings ...
	TypeBasicFormatWriteSettingsTypeOrcWriteSettings TypeBasicFormatWriteSettings = "OrcWriteSettings"
	// TypeBasicFormatWriteSettingsTypeParquetWriteSettings ...
	TypeBasicFormatWriteSettingsTypeParquetWriteSettings TypeBasicFormatWriteSettings = "ParquetWriteSettings"
)

// PossibleTypeBasicFormatWriteSettingsValues returns an array of possible values for the TypeBasicFormatWriteSettings const type.
func PossibleTypeBasicFormatWriteSettingsValues() []TypeBasicFormatWriteSettings {
	return []TypeBasicFormatWriteSettings{TypeBasicFormatWriteSettingsTypeAvroWriteSettings, TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings, TypeBasicFormatWriteSettingsTypeFormatWriteSettings, TypeBasicFormatWriteSettingsTypeJSONWriteSettings, TypeBasicFormatWriteSettingsTypeOrcWriteSettings, TypeBasicFormatWriteSettingsTypeParquetWriteSettings}
}

// TypeBasicImportSettings enumerates the values for type basic import settings.
type TypeBasicImportSettings string

const (
	// TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand ...
	TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand TypeBasicImportSettings = "AzureDatabricksDeltaLakeImportCommand"
	// TypeBasicImportSettingsTypeImportSettings ...
	TypeBasicImportSettingsTypeImportSettings TypeBasicImportSettings = "ImportSettings"
	// TypeBasicImportSettingsTypeSnowflakeImportCopyCommand ...
	TypeBasicImportSettingsTypeSnowflakeImportCopyCommand TypeBasicImportSettings = "SnowflakeImportCopyCommand"
)

// PossibleTypeBasicImportSettingsValues returns an array of possible values for the TypeBasicImportSettings const type.
func PossibleTypeBasicImportSettingsValues() []TypeBasicImportSettings {
	return []TypeBasicImportSettings{TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand, TypeBasicImportSettingsTypeImportSettings, TypeBasicImportSettingsTypeSnowflakeImportCopyCommand}
}

// TypeBasicIntegrationRuntime enumerates the values for type basic integration runtime.
type TypeBasicIntegrationRuntime string

const (
	// TypeBasicIntegrationRuntimeTypeIntegrationRuntime ...
	TypeBasicIntegrationRuntimeTypeIntegrationRuntime TypeBasicIntegrationRuntime = "IntegrationRuntime"
	// TypeBasicIntegrationRuntimeTypeManaged ...
	TypeBasicIntegrationRuntimeTypeManaged TypeBasicIntegrationRuntime = "Managed"
	// TypeBasicIntegrationRuntimeTypeSelfHosted ...
	TypeBasicIntegrationRuntimeTypeSelfHosted TypeBasicIntegrationRuntime = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeValues returns an array of possible values for the TypeBasicIntegrationRuntime const type.
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return []TypeBasicIntegrationRuntime{TypeBasicIntegrationRuntimeTypeIntegrationRuntime, TypeBasicIntegrationRuntimeTypeManaged, TypeBasicIntegrationRuntimeTypeSelfHosted}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicLinkedService enumerates the values for type basic linked service.
type TypeBasicLinkedService string

const (
	// TypeBasicLinkedServiceTypeAmazonMWS ...
	TypeBasicLinkedServiceTypeAmazonMWS TypeBasicLinkedService = "AmazonMWS"
	// TypeBasicLinkedServiceTypeAmazonRdsForOracle ...
	TypeBasicLinkedServiceTypeAmazonRdsForOracle TypeBasicLinkedService = "AmazonRdsForOracle"
	// TypeBasicLinkedServiceTypeAmazonRdsForSQLServer ...
	TypeBasicLinkedServiceTypeAmazonRdsForSQLServer TypeBasicLinkedService = "AmazonRdsForSqlServer"
	// TypeBasicLinkedServiceTypeAmazonRedshift ...
	TypeBasicLinkedServiceTypeAmazonRedshift TypeBasicLinkedService = "AmazonRedshift"
	// TypeBasicLinkedServiceTypeAmazonS3 ...
	TypeBasicLinkedServiceTypeAmazonS3 TypeBasicLinkedService = "AmazonS3"
	// TypeBasicLinkedServiceTypeAmazonS3Compatible ...
	TypeBasicLinkedServiceTypeAmazonS3Compatible TypeBasicLinkedService = "AmazonS3Compatible"
	// TypeBasicLinkedServiceTypeAzureBatch ...
	TypeBasicLinkedServiceTypeAzureBatch TypeBasicLinkedService = "AzureBatch"
	// TypeBasicLinkedServiceTypeAzureBlobFS ...
	TypeBasicLinkedServiceTypeAzureBlobFS TypeBasicLinkedService = "AzureBlobFS"
	// TypeBasicLinkedServiceTypeAzureBlobStorage ...
	TypeBasicLinkedServiceTypeAzureBlobStorage TypeBasicLinkedService = "AzureBlobStorage"
	// TypeBasicLinkedServiceTypeAzureDatabricks ...
	TypeBasicLinkedServiceTypeAzureDatabricks TypeBasicLinkedService = "AzureDatabricks"
	// TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake ...
	TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake TypeBasicLinkedService = "AzureDatabricksDeltaLake"
	// TypeBasicLinkedServiceTypeAzureDataExplorer ...
	TypeBasicLinkedServiceTypeAzureDataExplorer TypeBasicLinkedService = "AzureDataExplorer"
	// TypeBasicLinkedServiceTypeAzureDataLakeAnalytics ...
	TypeBasicLinkedServiceTypeAzureDataLakeAnalytics TypeBasicLinkedService = "AzureDataLakeAnalytics"
	// TypeBasicLinkedServiceTypeAzureDataLakeStore ...
	TypeBasicLinkedServiceTypeAzureDataLakeStore TypeBasicLinkedService = "AzureDataLakeStore"
	// TypeBasicLinkedServiceTypeAzureFileStorage ...
	TypeBasicLinkedServiceTypeAzureFileStorage TypeBasicLinkedService = "AzureFileStorage"
	// TypeBasicLinkedServiceTypeAzureFunction ...
	TypeBasicLinkedServiceTypeAzureFunction TypeBasicLinkedService = "AzureFunction"
	// TypeBasicLinkedServiceTypeAzureKeyVault ...
	TypeBasicLinkedServiceTypeAzureKeyVault TypeBasicLinkedService = "AzureKeyVault"
	// TypeBasicLinkedServiceTypeAzureMariaDB ...
	TypeBasicLinkedServiceTypeAzureMariaDB TypeBasicLinkedService = "AzureMariaDB"
	// TypeBasicLinkedServiceTypeAzureML ...
	TypeBasicLinkedServiceTypeAzureML TypeBasicLinkedService = "AzureML"
	// TypeBasicLinkedServiceTypeAzureMLService ...
	TypeBasicLinkedServiceTypeAzureMLService TypeBasicLinkedService = "AzureMLService"
	// TypeBasicLinkedServiceTypeAzureMySQL ...
	TypeBasicLinkedServiceTypeAzureMySQL TypeBasicLinkedService = "AzureMySql"
	// TypeBasicLinkedServiceTypeAzurePostgreSQL ...
	TypeBasicLinkedServiceTypeAzurePostgreSQL TypeBasicLinkedService = "AzurePostgreSql"
	// TypeBasicLinkedServiceTypeAzureSearch ...
	TypeBasicLinkedServiceTypeAzureSearch TypeBasicLinkedService = "AzureSearch"
	// TypeBasicLinkedServiceTypeAzureSQLDatabase ...
	TypeBasicLinkedServiceTypeAzureSQLDatabase TypeBasicLinkedService = "AzureSqlDatabase"
	// TypeBasicLinkedServiceTypeAzureSQLDW ...
	TypeBasicLinkedServiceTypeAzureSQLDW TypeBasicLinkedService = "AzureSqlDW"
	// TypeBasicLinkedServiceTypeAzureSQLMI ...
	TypeBasicLinkedServiceTypeAzureSQLMI TypeBasicLinkedService = "AzureSqlMI"
	// TypeBasicLinkedServiceTypeAzureStorage ...
	TypeBasicLinkedServiceTypeAzureStorage TypeBasicLinkedService = "AzureStorage"
	// TypeBasicLinkedServiceTypeAzureTableStorage ...
	TypeBasicLinkedServiceTypeAzureTableStorage TypeBasicLinkedService = "AzureTableStorage"
	// TypeBasicLinkedServiceTypeCassandra ...
	TypeBasicLinkedServiceTypeCassandra TypeBasicLinkedService = "Cassandra"
	// TypeBasicLinkedServiceTypeCommonDataServiceForApps ...
	TypeBasicLinkedServiceTypeCommonDataServiceForApps TypeBasicLinkedService = "CommonDataServiceForApps"
	// TypeBasicLinkedServiceTypeConcur ...
	TypeBasicLinkedServiceTypeConcur TypeBasicLinkedService = "Concur"
	// TypeBasicLinkedServiceTypeCosmosDb ...
	TypeBasicLinkedServiceTypeCosmosDb TypeBasicLinkedService = "CosmosDb"
	// TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI ...
	TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI TypeBasicLinkedService = "CosmosDbMongoDbApi"
	// TypeBasicLinkedServiceTypeCouchbase ...
	TypeBasicLinkedServiceTypeCouchbase TypeBasicLinkedService = "Couchbase"
	// TypeBasicLinkedServiceTypeCustomDataSource ...
	TypeBasicLinkedServiceTypeCustomDataSource TypeBasicLinkedService = "CustomDataSource"
	// TypeBasicLinkedServiceTypeDb2 ...
	TypeBasicLinkedServiceTypeDb2 TypeBasicLinkedService = "Db2"
	// TypeBasicLinkedServiceTypeDrill ...
	TypeBasicLinkedServiceTypeDrill TypeBasicLinkedService = "Drill"
	// TypeBasicLinkedServiceTypeDynamics ...
	TypeBasicLinkedServiceTypeDynamics TypeBasicLinkedService = "Dynamics"
	// TypeBasicLinkedServiceTypeDynamicsAX ...
	TypeBasicLinkedServiceTypeDynamicsAX TypeBasicLinkedService = "DynamicsAX"
	// TypeBasicLinkedServiceTypeDynamicsCrm ...
	TypeBasicLinkedServiceTypeDynamicsCrm TypeBasicLinkedService = "DynamicsCrm"
	// TypeBasicLinkedServiceTypeEloqua ...
	TypeBasicLinkedServiceTypeEloqua TypeBasicLinkedService = "Eloqua"
	// TypeBasicLinkedServiceTypeFileServer ...
	TypeBasicLinkedServiceTypeFileServer TypeBasicLinkedService = "FileServer"
	// TypeBasicLinkedServiceTypeFtpServer ...
	TypeBasicLinkedServiceTypeFtpServer TypeBasicLinkedService = "FtpServer"
	// TypeBasicLinkedServiceTypeGoogleAdWords ...
	TypeBasicLinkedServiceTypeGoogleAdWords TypeBasicLinkedService = "GoogleAdWords"
	// TypeBasicLinkedServiceTypeGoogleBigQuery ...
	TypeBasicLinkedServiceTypeGoogleBigQuery TypeBasicLinkedService = "GoogleBigQuery"
	// TypeBasicLinkedServiceTypeGoogleCloudStorage ...
	TypeBasicLinkedServiceTypeGoogleCloudStorage TypeBasicLinkedService = "GoogleCloudStorage"
	// TypeBasicLinkedServiceTypeGreenplum ...
	TypeBasicLinkedServiceTypeGreenplum TypeBasicLinkedService = "Greenplum"
	// TypeBasicLinkedServiceTypeHBase ...
	TypeBasicLinkedServiceTypeHBase TypeBasicLinkedService = "HBase"
	// TypeBasicLinkedServiceTypeHdfs ...
	TypeBasicLinkedServiceTypeHdfs TypeBasicLinkedService = "Hdfs"
	// TypeBasicLinkedServiceTypeHDInsight ...
	TypeBasicLinkedServiceTypeHDInsight TypeBasicLinkedService = "HDInsight"
	// TypeBasicLinkedServiceTypeHDInsightOnDemand ...
	TypeBasicLinkedServiceTypeHDInsightOnDemand TypeBasicLinkedService = "HDInsightOnDemand"
	// TypeBasicLinkedServiceTypeHive ...
	TypeBasicLinkedServiceTypeHive TypeBasicLinkedService = "Hive"
	// TypeBasicLinkedServiceTypeHTTPServer ...
	TypeBasicLinkedServiceTypeHTTPServer TypeBasicLinkedService = "HttpServer"
	// TypeBasicLinkedServiceTypeHubspot ...
	TypeBasicLinkedServiceTypeHubspot TypeBasicLinkedService = "Hubspot"
	// TypeBasicLinkedServiceTypeImpala ...
	TypeBasicLinkedServiceTypeImpala TypeBasicLinkedService = "Impala"
	// TypeBasicLinkedServiceTypeInformix ...
	TypeBasicLinkedServiceTypeInformix TypeBasicLinkedService = "Informix"
	// TypeBasicLinkedServiceTypeJira ...
	TypeBasicLinkedServiceTypeJira TypeBasicLinkedService = "Jira"
	// TypeBasicLinkedServiceTypeLinkedService ...
	TypeBasicLinkedServiceTypeLinkedService TypeBasicLinkedService = "LinkedService"
	// TypeBasicLinkedServiceTypeMagento ...
	TypeBasicLinkedServiceTypeMagento TypeBasicLinkedService = "Magento"
	// TypeBasicLinkedServiceTypeMariaDB ...
	TypeBasicLinkedServiceTypeMariaDB TypeBasicLinkedService = "MariaDB"
	// TypeBasicLinkedServiceTypeMarketo ...
	TypeBasicLinkedServiceTypeMarketo TypeBasicLinkedService = "Marketo"
	// TypeBasicLinkedServiceTypeMicrosoftAccess ...
	TypeBasicLinkedServiceTypeMicrosoftAccess TypeBasicLinkedService = "MicrosoftAccess"
	// TypeBasicLinkedServiceTypeMongoDb ...
	TypeBasicLinkedServiceTypeMongoDb TypeBasicLinkedService = "MongoDb"
	// TypeBasicLinkedServiceTypeMongoDbAtlas ...
	TypeBasicLinkedServiceTypeMongoDbAtlas TypeBasicLinkedService = "MongoDbAtlas"
	// TypeBasicLinkedServiceTypeMongoDbV2 ...
	TypeBasicLinkedServiceTypeMongoDbV2 TypeBasicLinkedService = "MongoDbV2"
	// TypeBasicLinkedServiceTypeMySQL ...
	TypeBasicLinkedServiceTypeMySQL TypeBasicLinkedService = "MySql"
	// TypeBasicLinkedServiceTypeNetezza ...
	TypeBasicLinkedServiceTypeNetezza TypeBasicLinkedService = "Netezza"
	// TypeBasicLinkedServiceTypeOData ...
	TypeBasicLinkedServiceTypeOData TypeBasicLinkedService = "OData"
	// TypeBasicLinkedServiceTypeOdbc ...
	TypeBasicLinkedServiceTypeOdbc TypeBasicLinkedService = "Odbc"
	// TypeBasicLinkedServiceTypeOffice365 ...
	TypeBasicLinkedServiceTypeOffice365 TypeBasicLinkedService = "Office365"
	// TypeBasicLinkedServiceTypeOracle ...
	TypeBasicLinkedServiceTypeOracle TypeBasicLinkedService = "Oracle"
	// TypeBasicLinkedServiceTypeOracleCloudStorage ...
	TypeBasicLinkedServiceTypeOracleCloudStorage TypeBasicLinkedService = "OracleCloudStorage"
	// TypeBasicLinkedServiceTypeOracleServiceCloud ...
	TypeBasicLinkedServiceTypeOracleServiceCloud TypeBasicLinkedService = "OracleServiceCloud"
	// TypeBasicLinkedServiceTypePaypal ...
	TypeBasicLinkedServiceTypePaypal TypeBasicLinkedService = "Paypal"
	// TypeBasicLinkedServiceTypePhoenix ...
	TypeBasicLinkedServiceTypePhoenix TypeBasicLinkedService = "Phoenix"
	// TypeBasicLinkedServiceTypePostgreSQL ...
	TypeBasicLinkedServiceTypePostgreSQL TypeBasicLinkedService = "PostgreSql"
	// TypeBasicLinkedServiceTypePresto ...
	TypeBasicLinkedServiceTypePresto TypeBasicLinkedService = "Presto"
	// TypeBasicLinkedServiceTypeQuickBooks ...
	TypeBasicLinkedServiceTypeQuickBooks TypeBasicLinkedService = "QuickBooks"
	// TypeBasicLinkedServiceTypeResponsys ...
	TypeBasicLinkedServiceTypeResponsys TypeBasicLinkedService = "Responsys"
	// TypeBasicLinkedServiceTypeRestService ...
	TypeBasicLinkedServiceTypeRestService TypeBasicLinkedService = "RestService"
	// TypeBasicLinkedServiceTypeSalesforce ...
	TypeBasicLinkedServiceTypeSalesforce TypeBasicLinkedService = "Salesforce"
	// TypeBasicLinkedServiceTypeSalesforceMarketingCloud ...
	TypeBasicLinkedServiceTypeSalesforceMarketingCloud TypeBasicLinkedService = "SalesforceMarketingCloud"
	// TypeBasicLinkedServiceTypeSalesforceServiceCloud ...
	TypeBasicLinkedServiceTypeSalesforceServiceCloud TypeBasicLinkedService = "SalesforceServiceCloud"
	// TypeBasicLinkedServiceTypeSapBW ...
	TypeBasicLinkedServiceTypeSapBW TypeBasicLinkedService = "SapBW"
	// TypeBasicLinkedServiceTypeSapCloudForCustomer ...
	TypeBasicLinkedServiceTypeSapCloudForCustomer TypeBasicLinkedService = "SapCloudForCustomer"
	// TypeBasicLinkedServiceTypeSapEcc ...
	TypeBasicLinkedServiceTypeSapEcc TypeBasicLinkedService = "SapEcc"
	// TypeBasicLinkedServiceTypeSapHana ...
	TypeBasicLinkedServiceTypeSapHana TypeBasicLinkedService = "SapHana"
	// TypeBasicLinkedServiceTypeSapOpenHub ...
	TypeBasicLinkedServiceTypeSapOpenHub TypeBasicLinkedService = "SapOpenHub"
	// TypeBasicLinkedServiceTypeSapTable ...
	TypeBasicLinkedServiceTypeSapTable TypeBasicLinkedService = "SapTable"
	// TypeBasicLinkedServiceTypeServiceNow ...
	TypeBasicLinkedServiceTypeServiceNow TypeBasicLinkedService = "ServiceNow"
	// TypeBasicLinkedServiceTypeSftp ...
	TypeBasicLinkedServiceTypeSftp TypeBasicLinkedService = "Sftp"
	// TypeBasicLinkedServiceTypeSharePointOnlineList ...
	TypeBasicLinkedServiceTypeSharePointOnlineList TypeBasicLinkedService = "SharePointOnlineList"
	// TypeBasicLinkedServiceTypeShopify ...
	TypeBasicLinkedServiceTypeShopify TypeBasicLinkedService = "Shopify"
	// TypeBasicLinkedServiceTypeSnowflake ...
	TypeBasicLinkedServiceTypeSnowflake TypeBasicLinkedService = "Snowflake"
	// TypeBasicLinkedServiceTypeSpark ...
	TypeBasicLinkedServiceTypeSpark TypeBasicLinkedService = "Spark"
	// TypeBasicLinkedServiceTypeSQLServer ...
	TypeBasicLinkedServiceTypeSQLServer TypeBasicLinkedService = "SqlServer"
	// TypeBasicLinkedServiceTypeSquare ...
	TypeBasicLinkedServiceTypeSquare TypeBasicLinkedService = "Square"
	// TypeBasicLinkedServiceTypeSybase ...
	TypeBasicLinkedServiceTypeSybase TypeBasicLinkedService = "Sybase"
	// TypeBasicLinkedServiceTypeTeradata ...
	TypeBasicLinkedServiceTypeTeradata TypeBasicLinkedService = "Teradata"
	// TypeBasicLinkedServiceTypeVertica ...
	TypeBasicLinkedServiceTypeVertica TypeBasicLinkedService = "Vertica"
	// TypeBasicLinkedServiceTypeWeb ...
	TypeBasicLinkedServiceTypeWeb TypeBasicLinkedService = "Web"
	// TypeBasicLinkedServiceTypeXero ...
	TypeBasicLinkedServiceTypeXero TypeBasicLinkedService = "Xero"
	// TypeBasicLinkedServiceTypeZoho ...
	TypeBasicLinkedServiceTypeZoho TypeBasicLinkedService = "Zoho"
)

// PossibleTypeBasicLinkedServiceValues returns an array of possible values for the TypeBasicLinkedService const type.
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return []TypeBasicLinkedService{TypeBasicLinkedServiceTypeAmazonMWS, TypeBasicLinkedServiceTypeAmazonRdsForOracle, TypeBasicLinkedServiceTypeAmazonRdsForSQLServer, TypeBasicLinkedServiceTypeAmazonRedshift, TypeBasicLinkedServiceTypeAmazonS3, TypeBasicLinkedServiceTypeAmazonS3Compatible, TypeBasicLinkedServiceTypeAzureBatch, TypeBasicLinkedServiceTypeAzureBlobFS, TypeBasicLinkedServiceTypeAzureBlobStorage, TypeBasicLinkedServiceTypeAzureDatabricks, TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake, TypeBasicLinkedServiceTypeAzureDataExplorer, TypeBasicLinkedServiceTypeAzureDataLakeAnalytics, TypeBasicLinkedServiceTypeAzureDataLakeStore, TypeBasicLinkedServiceTypeAzureFileStorage, TypeBasicLinkedServiceTypeAzureFunction, TypeBasicLinkedServiceTypeAzureKeyVault, TypeBasicLinkedServiceTypeAzureMariaDB, TypeBasicLinkedServiceTypeAzureML, TypeBasicLinkedServiceTypeAzureMLService, TypeBasicLinkedServiceTypeAzureMySQL, TypeBasicLinkedServiceTypeAzurePostgreSQL, TypeBasicLinkedServiceTypeAzureSearch, TypeBasicLinkedServiceTypeAzureSQLDatabase, TypeBasicLinkedServiceTypeAzureSQLDW, TypeBasicLinkedServiceTypeAzureSQLMI, TypeBasicLinkedServiceTypeAzureStorage, TypeBasicLinkedServiceTypeAzureTableStorage, TypeBasicLinkedServiceTypeCassandra, TypeBasicLinkedServiceTypeCommonDataServiceForApps, TypeBasicLinkedServiceTypeConcur, TypeBasicLinkedServiceTypeCosmosDb, TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI, TypeBasicLinkedServiceTypeCouchbase, TypeBasicLinkedServiceTypeCustomDataSource, TypeBasicLinkedServiceTypeDb2, TypeBasicLinkedServiceTypeDrill, TypeBasicLinkedServiceTypeDynamics, TypeBasicLinkedServiceTypeDynamicsAX, TypeBasicLinkedServiceTypeDynamicsCrm, TypeBasicLinkedServiceTypeEloqua, TypeBasicLinkedServiceTypeFileServer, TypeBasicLinkedServiceTypeFtpServer, TypeBasicLinkedServiceTypeGoogleAdWords, TypeBasicLinkedServiceTypeGoogleBigQuery, TypeBasicLinkedServiceTypeGoogleCloudStorage, TypeBasicLinkedServiceTypeGreenplum, TypeBasicLinkedServiceTypeHBase, TypeBasicLinkedServiceTypeHdfs, TypeBasicLinkedServiceTypeHDInsight, TypeBasicLinkedServiceTypeHDInsightOnDemand, TypeBasicLinkedServiceTypeHive, TypeBasicLinkedServiceTypeHTTPServer, TypeBasicLinkedServiceTypeHubspot, TypeBasicLinkedServiceTypeImpala, TypeBasicLinkedServiceTypeInformix, TypeBasicLinkedServiceTypeJira, TypeBasicLinkedServiceTypeLinkedService, TypeBasicLinkedServiceTypeMagento, TypeBasicLinkedServiceTypeMariaDB, TypeBasicLinkedServiceTypeMarketo, TypeBasicLinkedServiceTypeMicrosoftAccess, TypeBasicLinkedServiceTypeMongoDb, TypeBasicLinkedServiceTypeMongoDbAtlas, TypeBasicLinkedServiceTypeMongoDbV2, TypeBasicLinkedServiceTypeMySQL, TypeBasicLinkedServiceTypeNetezza, TypeBasicLinkedServiceTypeOData, TypeBasicLinkedServiceTypeOdbc, TypeBasicLinkedServiceTypeOffice365, TypeBasicLinkedServiceTypeOracle, TypeBasicLinkedServiceTypeOracleCloudStorage, TypeBasicLinkedServiceTypeOracleServiceCloud, TypeBasicLinkedServiceTypePaypal, TypeBasicLinkedServiceTypePhoenix, TypeBasicLinkedServiceTypePostgreSQL, TypeBasicLinkedServiceTypePresto, TypeBasicLinkedServiceTypeQuickBooks, TypeBasicLinkedServiceTypeResponsys, TypeBasicLinkedServiceTypeRestService, TypeBasicLinkedServiceTypeSalesforce, TypeBasicLinkedServiceTypeSalesforceMarketingCloud, TypeBasicLinkedServiceTypeSalesforceServiceCloud, TypeBasicLinkedServiceTypeSapBW, TypeBasicLinkedServiceTypeSapCloudForCustomer, TypeBasicLinkedServiceTypeSapEcc, TypeBasicLinkedServiceTypeSapHana, TypeBasicLinkedServiceTypeSapOpenHub, TypeBasicLinkedServiceTypeSapTable, TypeBasicLinkedServiceTypeServiceNow, TypeBasicLinkedServiceTypeSftp, TypeBasicLinkedServiceTypeSharePointOnlineList, TypeBasicLinkedServiceTypeShopify, TypeBasicLinkedServiceTypeSnowflake, TypeBasicLinkedServiceTypeSpark, TypeBasicLinkedServiceTypeSQLServer, TypeBasicLinkedServiceTypeSquare, TypeBasicLinkedServiceTypeSybase, TypeBasicLinkedServiceTypeTeradata, TypeBasicLinkedServiceTypeVertica, TypeBasicLinkedServiceTypeWeb, TypeBasicLinkedServiceTypeXero, TypeBasicLinkedServiceTypeZoho}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeBasicSsisObjectMetadataTypeEnvironment ...
	TypeBasicSsisObjectMetadataTypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeBasicSsisObjectMetadataTypeFolder ...
	TypeBasicSsisObjectMetadataTypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypeBasicSsisObjectMetadataTypePackage ...
	TypeBasicSsisObjectMetadataTypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeBasicSsisObjectMetadataTypeProject ...
	TypeBasicSsisObjectMetadataTypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeBasicSsisObjectMetadataTypeSsisObjectMetadata ...
	TypeBasicSsisObjectMetadataTypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeBasicSsisObjectMetadataTypeEnvironment, TypeBasicSsisObjectMetadataTypeFolder, TypeBasicSsisObjectMetadataTypePackage, TypeBasicSsisObjectMetadataTypeProject, TypeBasicSsisObjectMetadataTypeSsisObjectMetadata}
}

// TypeBasicStoreReadSettings enumerates the values for type basic store read settings.
type TypeBasicStoreReadSettings string

const (
	// TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings ...
	TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings TypeBasicStoreReadSettings = "AmazonS3CompatibleReadSettings"
	// TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings ...
	TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings TypeBasicStoreReadSettings = "AmazonS3ReadSettings"
	// TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings ...
	TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings TypeBasicStoreReadSettings = "AzureBlobFSReadSettings"
	// TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings ...
	TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings TypeBasicStoreReadSettings = "AzureBlobStorageReadSettings"
	// TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings ...
	TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings TypeBasicStoreReadSettings = "AzureDataLakeStoreReadSettings"
	// TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings ...
	TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings TypeBasicStoreReadSettings = "AzureFileStorageReadSettings"
	// TypeBasicStoreReadSettingsTypeFileServerReadSettings ...
	TypeBasicStoreReadSettingsTypeFileServerReadSettings TypeBasicStoreReadSettings = "FileServerReadSettings"
	// TypeBasicStoreReadSettingsTypeFtpReadSettings ...
	TypeBasicStoreReadSettingsTypeFtpReadSettings TypeBasicStoreReadSettings = "FtpReadSettings"
	// TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings ...
	TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings TypeBasicStoreReadSettings = "GoogleCloudStorageReadSettings"
	// TypeBasicStoreReadSettingsTypeHdfsReadSettings ...
	TypeBasicStoreReadSettingsTypeHdfsReadSettings TypeBasicStoreReadSettings = "HdfsReadSettings"
	// TypeBasicStoreReadSettingsTypeHTTPReadSettings ...
	TypeBasicStoreReadSettingsTypeHTTPReadSettings TypeBasicStoreReadSettings = "HttpReadSettings"
	// TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings ...
	TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings TypeBasicStoreReadSettings = "OracleCloudStorageReadSettings"
	// TypeBasicStoreReadSettingsTypeSftpReadSettings ...
	TypeBasicStoreReadSettingsTypeSftpReadSettings TypeBasicStoreReadSettings = "SftpReadSettings"
	// TypeBasicStoreReadSettingsTypeStoreReadSettings ...
	TypeBasicStoreReadSettingsTypeStoreReadSettings TypeBasicStoreReadSettings = "StoreReadSettings"
)

// PossibleTypeBasicStoreReadSettingsValues returns an array of possible values for the TypeBasicStoreReadSettings const type.
func PossibleTypeBasicStoreReadSettingsValues() []TypeBasicStoreReadSettings {
	return []TypeBasicStoreReadSettings{TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings, TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings, TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings, TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings, TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings, TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings, TypeBasicStoreReadSettingsTypeFileServerReadSettings, TypeBasicStoreReadSettingsTypeFtpReadSettings, TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings, TypeBasicStoreReadSettingsTypeHdfsReadSettings, TypeBasicStoreReadSettingsTypeHTTPReadSettings, TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings, TypeBasicStoreReadSettingsTypeSftpReadSettings, TypeBasicStoreReadSettingsTypeStoreReadSettings}
}

// TypeBasicStoreWriteSettings enumerates the values for type basic store write settings.
type TypeBasicStoreWriteSettings string

const (
	// TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings ...
	TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings TypeBasicStoreWriteSettings = "AzureBlobFSWriteSettings"
	// TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings ...
	TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings TypeBasicStoreWriteSettings = "AzureBlobStorageWriteSettings"
	// TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings ...
	TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = "AzureDataLakeStoreWriteSettings"
	// TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings ...
	TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings TypeBasicStoreWriteSettings = "AzureFileStorageWriteSettings"
	// TypeBasicStoreWriteSettingsTypeFileServerWriteSettings ...
	TypeBasicStoreWriteSettingsTypeFileServerWriteSettings TypeBasicStoreWriteSettings = "FileServerWriteSettings"
	// TypeBasicStoreWriteSettingsTypeSftpWriteSettings ...
	TypeBasicStoreWriteSettingsTypeSftpWriteSettings TypeBasicStoreWriteSettings = "SftpWriteSettings"
	// TypeBasicStoreWriteSettingsTypeStoreWriteSettings ...
	TypeBasicStoreWriteSettingsTypeStoreWriteSettings TypeBasicStoreWriteSettings = "StoreWriteSettings"
)

// PossibleTypeBasicStoreWriteSettingsValues returns an array of possible values for the TypeBasicStoreWriteSettings const type.
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return []TypeBasicStoreWriteSettings{TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings, TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings, TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings, TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings, TypeBasicStoreWriteSettingsTypeFileServerWriteSettings, TypeBasicStoreWriteSettingsTypeSftpWriteSettings, TypeBasicStoreWriteSettingsTypeStoreWriteSettings}
}

// TypeBasicTrigger enumerates the values for type basic trigger.
type TypeBasicTrigger string

const (
	// TypeBasicTriggerTypeBlobEventsTrigger ...
	TypeBasicTriggerTypeBlobEventsTrigger TypeBasicTrigger = "BlobEventsTrigger"
	// TypeBasicTriggerTypeBlobTrigger ...
	TypeBasicTriggerTypeBlobTrigger TypeBasicTrigger = "BlobTrigger"
	// TypeBasicTriggerTypeChainingTrigger ...
	TypeBasicTriggerTypeChainingTrigger TypeBasicTrigger = "ChainingTrigger"
	// TypeBasicTriggerTypeCustomEventsTrigger ...
	TypeBasicTriggerTypeCustomEventsTrigger TypeBasicTrigger = "CustomEventsTrigger"
	// TypeBasicTriggerTypeMultiplePipelineTrigger ...
	TypeBasicTriggerTypeMultiplePipelineTrigger TypeBasicTrigger = "MultiplePipelineTrigger"
	// TypeBasicTriggerTypeRerunTumblingWindowTrigger ...
	TypeBasicTriggerTypeRerunTumblingWindowTrigger TypeBasicTrigger = "RerunTumblingWindowTrigger"
	// TypeBasicTriggerTypeScheduleTrigger ...
	TypeBasicTriggerTypeScheduleTrigger TypeBasicTrigger = "ScheduleTrigger"
	// TypeBasicTriggerTypeTrigger ...
	TypeBasicTriggerTypeTrigger TypeBasicTrigger = "Trigger"
	// TypeBasicTriggerTypeTumblingWindowTrigger ...
	TypeBasicTriggerTypeTumblingWindowTrigger TypeBasicTrigger = "TumblingWindowTrigger"
)

// PossibleTypeBasicTriggerValues returns an array of possible values for the TypeBasicTrigger const type.
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return []TypeBasicTrigger{TypeBasicTriggerTypeBlobEventsTrigger, TypeBasicTriggerTypeBlobTrigger, TypeBasicTriggerTypeChainingTrigger, TypeBasicTriggerTypeCustomEventsTrigger, TypeBasicTriggerTypeMultiplePipelineTrigger, TypeBasicTriggerTypeRerunTumblingWindowTrigger, TypeBasicTriggerTypeScheduleTrigger, TypeBasicTriggerTypeTrigger, TypeBasicTriggerTypeTumblingWindowTrigger}
}

// VariableType enumerates the values for variable type.
type VariableType string

const (
	// VariableTypeArray ...
	VariableTypeArray VariableType = "Array"
	// VariableTypeBool ...
	VariableTypeBool VariableType = "Bool"
	// VariableTypeString ...
	VariableTypeString VariableType = "String"
)

// PossibleVariableTypeValues returns an array of possible values for the VariableType const type.
func PossibleVariableTypeValues() []VariableType {
	return []VariableType{VariableTypeArray, VariableTypeBool, VariableTypeString}
}

// WebActivityMethod enumerates the values for web activity method.
type WebActivityMethod string

const (
	// WebActivityMethodDELETE ...
	WebActivityMethodDELETE WebActivityMethod = "DELETE"
	// WebActivityMethodGET ...
	WebActivityMethodGET WebActivityMethod = "GET"
	// WebActivityMethodPOST ...
	WebActivityMethodPOST WebActivityMethod = "POST"
	// WebActivityMethodPUT ...
	WebActivityMethodPUT WebActivityMethod = "PUT"
)

// PossibleWebActivityMethodValues returns an array of possible values for the WebActivityMethod const type.
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return []WebActivityMethod{WebActivityMethodDELETE, WebActivityMethodGET, WebActivityMethodPOST, WebActivityMethodPUT}
}

// WebHookActivityMethod enumerates the values for web hook activity method.
type WebHookActivityMethod string

const (
	// WebHookActivityMethodPOST ...
	WebHookActivityMethodPOST WebHookActivityMethod = "POST"
)

// PossibleWebHookActivityMethodValues returns an array of possible values for the WebHookActivityMethod const type.
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return []WebHookActivityMethod{WebHookActivityMethodPOST}
}
