package blueprint

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AssignmentDeleteBehavior enumerates the values for assignment delete behavior.
type AssignmentDeleteBehavior string

const (
	// All ...
	All AssignmentDeleteBehavior = "all"
	// None ...
	None AssignmentDeleteBehavior = "none"
)

// PossibleAssignmentDeleteBehaviorValues returns an array of possible values for the AssignmentDeleteBehavior const type.
func PossibleAssignmentDeleteBehaviorValues() []AssignmentDeleteBehavior {
	return []AssignmentDeleteBehavior{All, None}
}

// AssignmentLockMode enumerates the values for assignment lock mode.
type AssignmentLockMode string

const (
	// AssignmentLockModeAllResourcesDoNotDelete ...
	AssignmentLockModeAllResourcesDoNotDelete AssignmentLockMode = "AllResourcesDoNotDelete"
	// AssignmentLockModeAllResourcesReadOnly ...
	AssignmentLockModeAllResourcesReadOnly AssignmentLockMode = "AllResourcesReadOnly"
	// AssignmentLockModeNone ...
	AssignmentLockModeNone AssignmentLockMode = "None"
)

// PossibleAssignmentLockModeValues returns an array of possible values for the AssignmentLockMode const type.
func PossibleAssignmentLockModeValues() []AssignmentLockMode {
	return []AssignmentLockMode{AssignmentLockModeAllResourcesDoNotDelete, AssignmentLockModeAllResourcesReadOnly, AssignmentLockModeNone}
}

// AssignmentProvisioningState enumerates the values for assignment provisioning state.
type AssignmentProvisioningState string

const (
	// Canceled ...
	Canceled AssignmentProvisioningState = "canceled"
	// Cancelling ...
	Cancelling AssignmentProvisioningState = "cancelling"
	// Creating ...
	Creating AssignmentProvisioningState = "creating"
	// Deleting ...
	Deleting AssignmentProvisioningState = "deleting"
	// Deploying ...
	Deploying AssignmentProvisioningState = "deploying"
	// Failed ...
	Failed AssignmentProvisioningState = "failed"
	// Locking ...
	Locking AssignmentProvisioningState = "locking"
	// Succeeded ...
	Succeeded AssignmentProvisioningState = "succeeded"
	// Validating ...
	Validating AssignmentProvisioningState = "validating"
	// Waiting ...
	Waiting AssignmentProvisioningState = "waiting"
)

// PossibleAssignmentProvisioningStateValues returns an array of possible values for the AssignmentProvisioningState const type.
func PossibleAssignmentProvisioningStateValues() []AssignmentProvisioningState {
	return []AssignmentProvisioningState{Canceled, Cancelling, Creating, Deleting, Deploying, Failed, Locking, Succeeded, Validating, Waiting}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindArtifact ...
	KindArtifact Kind = "Artifact"
	// KindPolicyAssignment ...
	KindPolicyAssignment Kind = "policyAssignment"
	// KindRoleAssignment ...
	KindRoleAssignment Kind = "roleAssignment"
	// KindTemplate ...
	KindTemplate Kind = "template"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindArtifact, KindPolicyAssignment, KindRoleAssignment, KindTemplate}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// ManagedServiceIdentityTypeNone ...
	ManagedServiceIdentityTypeNone ManagedServiceIdentityType = "None"
	// ManagedServiceIdentityTypeSystemAssigned ...
	ManagedServiceIdentityTypeSystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	// ManagedServiceIdentityTypeUserAssigned ...
	ManagedServiceIdentityTypeUserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{ManagedServiceIdentityTypeNone, ManagedServiceIdentityTypeSystemAssigned, ManagedServiceIdentityTypeUserAssigned}
}

// TargetScope enumerates the values for target scope.
type TargetScope string

const (
	// ManagementGroup The blueprint targets a management group during blueprint assignment. This is reserved
	// for future use.
	ManagementGroup TargetScope = "managementGroup"
	// Subscription The blueprint targets a subscription during blueprint assignment.
	Subscription TargetScope = "subscription"
)

// PossibleTargetScopeValues returns an array of possible values for the TargetScope const type.
func PossibleTargetScopeValues() []TargetScope {
	return []TargetScope{ManagementGroup, Subscription}
}

// TemplateParameterType enumerates the values for template parameter type.
type TemplateParameterType string

const (
	// Array ...
	Array TemplateParameterType = "array"
	// Bool ...
	Bool TemplateParameterType = "bool"
	// Int ...
	Int TemplateParameterType = "int"
	// Object ...
	Object TemplateParameterType = "object"
	// SecureObject ...
	SecureObject TemplateParameterType = "secureObject"
	// SecureString ...
	SecureString TemplateParameterType = "secureString"
	// String ...
	String TemplateParameterType = "string"
)

// PossibleTemplateParameterTypeValues returns an array of possible values for the TemplateParameterType const type.
func PossibleTemplateParameterTypeValues() []TemplateParameterType {
	return []TemplateParameterType{Array, Bool, Int, Object, SecureObject, SecureString, String}
}
