package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServerGroupAttribute invokes the alb.UpdateServerGroupAttribute API synchronously
func (client *Client) UpdateServerGroupAttribute(request *UpdateServerGroupAttributeRequest) (response *UpdateServerGroupAttributeResponse, err error) {
	response = CreateUpdateServerGroupAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServerGroupAttributeWithChan invokes the alb.UpdateServerGroupAttribute API asynchronously
func (client *Client) UpdateServerGroupAttributeWithChan(request *UpdateServerGroupAttributeRequest) (<-chan *UpdateServerGroupAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateServerGroupAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServerGroupAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServerGroupAttributeWithCallback invokes the alb.UpdateServerGroupAttribute API asynchronously
func (client *Client) UpdateServerGroupAttributeWithCallback(request *UpdateServerGroupAttributeRequest, callback func(response *UpdateServerGroupAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServerGroupAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateServerGroupAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServerGroupAttributeRequest is the request struct for api UpdateServerGroupAttribute
type UpdateServerGroupAttributeRequest struct {
	*requests.RpcRequest
	ServerGroupName          string                                        `position:"Query" name:"ServerGroupName"`
	ClientToken              string                                        `position:"Query" name:"ClientToken"`
	HealthCheckConfig        UpdateServerGroupAttributeHealthCheckConfig   `position:"Query" name:"HealthCheckConfig"  type:"Struct"`
	Scheduler                string                                        `position:"Query" name:"Scheduler"`
	ServerGroupId            string                                        `position:"Query" name:"ServerGroupId"`
	UpstreamKeepaliveEnabled requests.Boolean                              `position:"Query" name:"UpstreamKeepaliveEnabled"`
	ServiceName              string                                        `position:"Query" name:"ServiceName"`
	StickySessionConfig      UpdateServerGroupAttributeStickySessionConfig `position:"Query" name:"StickySessionConfig"  type:"Struct"`
	DryRun                   requests.Boolean                              `position:"Query" name:"DryRun"`
	UchConfig                UpdateServerGroupAttributeUchConfig           `position:"Query" name:"UchConfig"  type:"Struct"`
}

// UpdateServerGroupAttributeHealthCheckConfig is a repeated param struct in UpdateServerGroupAttributeRequest
type UpdateServerGroupAttributeHealthCheckConfig struct {
	HealthCheckCodes               *[]string `name:"HealthCheckCodes" type:"Repeated"`
	HealthCheckEnabled             string    `name:"HealthCheckEnabled"`
	HealthCheckTimeout             string    `name:"HealthCheckTimeout"`
	HealthCheckMethod              string    `name:"HealthCheckMethod"`
	HealthCheckHost                string    `name:"HealthCheckHost"`
	HealthCheckProtocol            string    `name:"HealthCheckProtocol"`
	UnhealthyThreshold             string    `name:"UnhealthyThreshold"`
	HealthyThreshold               string    `name:"HealthyThreshold"`
	HealthCheckTcpFastCloseEnabled string    `name:"HealthCheckTcpFastCloseEnabled"`
	HealthCheckPath                string    `name:"HealthCheckPath"`
	HealthCheckInterval            string    `name:"HealthCheckInterval"`
	HealthCheckHttpCodes           *[]string `name:"HealthCheckHttpCodes" type:"Repeated"`
	HealthCheckHttpVersion         string    `name:"HealthCheckHttpVersion"`
	HealthCheckConnectPort         string    `name:"HealthCheckConnectPort"`
}

// UpdateServerGroupAttributeStickySessionConfig is a repeated param struct in UpdateServerGroupAttributeRequest
type UpdateServerGroupAttributeStickySessionConfig struct {
	StickySessionEnabled string `name:"StickySessionEnabled"`
	Cookie               string `name:"Cookie"`
	CookieTimeout        string `name:"CookieTimeout"`
	StickySessionType    string `name:"StickySessionType"`
}

// UpdateServerGroupAttributeUchConfig is a repeated param struct in UpdateServerGroupAttributeRequest
type UpdateServerGroupAttributeUchConfig struct {
	Type  string `name:"Type"`
	Value string `name:"Value"`
}

// UpdateServerGroupAttributeResponse is the response struct for api UpdateServerGroupAttribute
type UpdateServerGroupAttributeResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateServerGroupAttributeRequest creates a request to invoke UpdateServerGroupAttribute API
func CreateUpdateServerGroupAttributeRequest() (request *UpdateServerGroupAttributeRequest) {
	request = &UpdateServerGroupAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateServerGroupAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateServerGroupAttributeResponse creates a response to parse from UpdateServerGroupAttribute response
func CreateUpdateServerGroupAttributeResponse() (response *UpdateServerGroupAttributeResponse) {
	response = &UpdateServerGroupAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
