package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDispatchRule invokes the arms.DescribeDispatchRule API synchronously
func (client *Client) DescribeDispatchRule(request *DescribeDispatchRuleRequest) (response *DescribeDispatchRuleResponse, err error) {
	response = CreateDescribeDispatchRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDispatchRuleWithChan invokes the arms.DescribeDispatchRule API asynchronously
func (client *Client) DescribeDispatchRuleWithChan(request *DescribeDispatchRuleRequest) (<-chan *DescribeDispatchRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeDispatchRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDispatchRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDispatchRuleWithCallback invokes the arms.DescribeDispatchRule API asynchronously
func (client *Client) DescribeDispatchRuleWithCallback(request *DescribeDispatchRuleRequest, callback func(response *DescribeDispatchRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDispatchRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeDispatchRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDispatchRuleRequest is the request struct for api DescribeDispatchRule
type DescribeDispatchRuleRequest struct {
	*requests.RpcRequest
	Id          string `position:"Query" name:"Id"`
	ProxyUserId string `position:"Query" name:"ProxyUserId"`
}

// DescribeDispatchRuleResponse is the response struct for api DescribeDispatchRule
type DescribeDispatchRuleResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DispatchRule DispatchRule `json:"DispatchRule" xml:"DispatchRule"`
}

// CreateDescribeDispatchRuleRequest creates a request to invoke DescribeDispatchRule API
func CreateDescribeDispatchRuleRequest() (request *DescribeDispatchRuleRequest) {
	request = &DescribeDispatchRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DescribeDispatchRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDispatchRuleResponse creates a response to parse from DescribeDispatchRule response
func CreateDescribeDispatchRuleResponse() (response *DescribeDispatchRuleResponse) {
	response = &DescribeDispatchRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
