package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCampaign invokes the ccc.CreateCampaign API synchronously
func (client *Client) CreateCampaign(request *CreateCampaignRequest) (response *CreateCampaignResponse, err error) {
	response = CreateCreateCampaignResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCampaignWithChan invokes the ccc.CreateCampaign API asynchronously
func (client *Client) CreateCampaignWithChan(request *CreateCampaignRequest) (<-chan *CreateCampaignResponse, <-chan error) {
	responseChan := make(chan *CreateCampaignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCampaign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCampaignWithCallback invokes the ccc.CreateCampaign API asynchronously
func (client *Client) CreateCampaignWithCallback(request *CreateCampaignRequest, callback func(response *CreateCampaignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCampaignResponse
		var err error
		defer close(result)
		response, err = client.CreateCampaign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCampaignRequest is the request struct for api CreateCampaign
type CreateCampaignRequest struct {
	*requests.RpcRequest
	QueueId              string           `position:"Query" name:"QueueId"`
	ContactFlowId        string           `position:"Query" name:"ContactFlowId"`
	Simulation           requests.Boolean `position:"Query" name:"Simulation"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	MaxAttemptCount      requests.Integer `position:"Query" name:"MaxAttemptCount"`
	StrategyParameters   string           `position:"Query" name:"StrategyParameters"`
	CaseFileKey          string           `position:"Query" name:"CaseFileKey"`
	MinAttemptInterval   requests.Integer `position:"Query" name:"MinAttemptInterval"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SimulationParameters string           `position:"Query" name:"SimulationParameters"`
	Name                 string           `position:"Query" name:"Name"`
	StrategyType         string           `position:"Query" name:"StrategyType"`
	CaseList             string           `position:"Query" name:"CaseList"`
	CallableTime         string           `position:"Query" name:"CallableTime"`
}

// CreateCampaignResponse is the response struct for api CreateCampaign
type CreateCampaignResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           string `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateCampaignRequest creates a request to invoke CreateCampaign API
func CreateCreateCampaignRequest() (request *CreateCampaignRequest) {
	request = &CreateCampaignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "CreateCampaign", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCampaignResponse creates a response to parse from CreateCampaign response
func CreateCreateCampaignResponse() (response *CreateCampaignResponse) {
	response = &CreateCampaignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
