package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVnConversationDetails invokes the cloudcallcenter.ListVnConversationDetails API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnconversationdetails.html
func (client *Client) ListVnConversationDetails(request *ListVnConversationDetailsRequest) (response *ListVnConversationDetailsResponse, err error) {
	response = CreateListVnConversationDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVnConversationDetailsWithChan invokes the cloudcallcenter.ListVnConversationDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnconversationdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnConversationDetailsWithChan(request *ListVnConversationDetailsRequest) (<-chan *ListVnConversationDetailsResponse, <-chan error) {
	responseChan := make(chan *ListVnConversationDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVnConversationDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVnConversationDetailsWithCallback invokes the cloudcallcenter.ListVnConversationDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnconversationdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnConversationDetailsWithCallback(request *ListVnConversationDetailsRequest, callback func(response *ListVnConversationDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVnConversationDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListVnConversationDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVnConversationDetailsRequest is the request struct for api ListVnConversationDetails
type ListVnConversationDetailsRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// ListVnConversationDetailsResponse is the response struct for api ListVnConversationDetails
type ListVnConversationDetailsResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	ConversationDetails []ConversationDetail `json:"ConversationDetails" xml:"ConversationDetails"`
}

// CreateListVnConversationDetailsRequest creates a request to invoke ListVnConversationDetails API
func CreateListVnConversationDetailsRequest() (request *ListVnConversationDetailsRequest) {
	request = &ListVnConversationDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListVnConversationDetails", "", "")
	request.Method = requests.GET
	return
}

// CreateListVnConversationDetailsResponse creates a response to parse from ListVnConversationDetails response
func CreateListVnConversationDetailsResponse() (response *ListVnConversationDetailsResponse) {
	response = &ListVnConversationDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
