package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApDevices invokes the cloudesl.DescribeApDevices API synchronously
func (client *Client) DescribeApDevices(request *DescribeApDevicesRequest) (response *DescribeApDevicesResponse, err error) {
	response = CreateDescribeApDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApDevicesWithChan invokes the cloudesl.DescribeApDevices API asynchronously
func (client *Client) DescribeApDevicesWithChan(request *DescribeApDevicesRequest) (<-chan *DescribeApDevicesResponse, <-chan error) {
	responseChan := make(chan *DescribeApDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApDevicesWithCallback invokes the cloudesl.DescribeApDevices API asynchronously
func (client *Client) DescribeApDevicesWithCallback(request *DescribeApDevicesRequest, callback func(response *DescribeApDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApDevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeApDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApDevicesRequest is the request struct for api DescribeApDevices
type DescribeApDevicesRequest struct {
	*requests.RpcRequest
	ExtraParams string           `position:"Body" name:"ExtraParams"`
	ApMac       string           `position:"Body" name:"ApMac"`
	StoreId     string           `position:"Body" name:"StoreId"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	Model       string           `position:"Body" name:"Model"`
	BeActivate  requests.Boolean `position:"Body" name:"BeActivate"`
	Status      requests.Boolean `position:"Body" name:"Status"`
}

// DescribeApDevicesResponse is the response struct for api DescribeApDevices
type DescribeApDevicesResponse struct {
	*responses.BaseResponse
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	TotalCount     int      `json:"TotalCount" xml:"TotalCount"`
	Message        string   `json:"Message" xml:"Message"`
	PageSize       int      `json:"PageSize" xml:"PageSize"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	Code           string   `json:"Code" xml:"Code"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	PageNumber     int      `json:"PageNumber" xml:"PageNumber"`
	ApDevices      []ApInfo `json:"ApDevices" xml:"ApDevices"`
}

// CreateDescribeApDevicesRequest creates a request to invoke DescribeApDevices API
func CreateDescribeApDevicesRequest() (request *DescribeApDevicesRequest) {
	request = &DescribeApDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeApDevices", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApDevicesResponse creates a response to parse from DescribeApDevices response
func CreateDescribeApDevicesResponse() (response *DescribeApDevicesResponse) {
	response = &DescribeApDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
