package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateStore invokes the cloudesl.UpdateStore API synchronously
func (client *Client) UpdateStore(request *UpdateStoreRequest) (response *UpdateStoreResponse, err error) {
	response = CreateUpdateStoreResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateStoreWithChan invokes the cloudesl.UpdateStore API asynchronously
func (client *Client) UpdateStoreWithChan(request *UpdateStoreRequest) (<-chan *UpdateStoreResponse, <-chan error) {
	responseChan := make(chan *UpdateStoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateStore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateStoreWithCallback invokes the cloudesl.UpdateStore API asynchronously
func (client *Client) UpdateStoreWithCallback(request *UpdateStoreRequest, callback func(response *UpdateStoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateStoreResponse
		var err error
		defer close(result)
		response, err = client.UpdateStore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateStoreRequest is the request struct for api UpdateStore
type UpdateStoreRequest struct {
	*requests.RpcRequest
	ExtraParams     string `position:"Body" name:"ExtraParams"`
	Timezone        string `position:"Body" name:"Timezone"`
	StoreName       string `position:"Body" name:"StoreName"`
	StoreId         string `position:"Body" name:"StoreId"`
	TemplateVersion string `position:"Body" name:"TemplateVersion"`
	UserStoreCode   string `position:"Body" name:"UserStoreCode"`
	Phone           string `position:"Body" name:"Phone"`
}

// UpdateStoreResponse is the response struct for api UpdateStore
type UpdateStoreResponse struct {
	*responses.BaseResponse
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateStoreRequest creates a request to invoke UpdateStore API
func CreateUpdateStoreRequest() (request *UpdateStoreRequest) {
	request = &UpdateStoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "UpdateStore", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateStoreResponse creates a response to parse from UpdateStore response
func CreateUpdateStoreResponse() (response *UpdateStoreResponse) {
	response = &UpdateStoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
