package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TurnOffAutoResourceOptimize invokes the das.TurnOffAutoResourceOptimize API synchronously
func (client *Client) TurnOffAutoResourceOptimize(request *TurnOffAutoResourceOptimizeRequest) (response *TurnOffAutoResourceOptimizeResponse, err error) {
	response = CreateTurnOffAutoResourceOptimizeResponse()
	err = client.DoAction(request, response)
	return
}

// TurnOffAutoResourceOptimizeWithChan invokes the das.TurnOffAutoResourceOptimize API asynchronously
func (client *Client) TurnOffAutoResourceOptimizeWithChan(request *TurnOffAutoResourceOptimizeRequest) (<-chan *TurnOffAutoResourceOptimizeResponse, <-chan error) {
	responseChan := make(chan *TurnOffAutoResourceOptimizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TurnOffAutoResourceOptimize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TurnOffAutoResourceOptimizeWithCallback invokes the das.TurnOffAutoResourceOptimize API asynchronously
func (client *Client) TurnOffAutoResourceOptimizeWithCallback(request *TurnOffAutoResourceOptimizeRequest, callback func(response *TurnOffAutoResourceOptimizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TurnOffAutoResourceOptimizeResponse
		var err error
		defer close(result)
		response, err = client.TurnOffAutoResourceOptimize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TurnOffAutoResourceOptimizeRequest is the request struct for api TurnOffAutoResourceOptimize
type TurnOffAutoResourceOptimizeRequest struct {
	*requests.RpcRequest
	Context    string `position:"Query" name:"__context"`
	Signature  string `position:"Query" name:"Signature"`
	UserId     string `position:"Query" name:"UserId"`
	Uid        string `position:"Query" name:"Uid"`
	InstanceId string `position:"Query" name:"InstanceId"`
	AccessKey  string `position:"Query" name:"AccessKey"`
}

// TurnOffAutoResourceOptimizeResponse is the response struct for api TurnOffAutoResourceOptimize
type TurnOffAutoResourceOptimizeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateTurnOffAutoResourceOptimizeRequest creates a request to invoke TurnOffAutoResourceOptimize API
func CreateTurnOffAutoResourceOptimizeRequest() (request *TurnOffAutoResourceOptimizeRequest) {
	request = &TurnOffAutoResourceOptimizeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "TurnOffAutoResourceOptimize", "", "")
	request.Method = requests.POST
	return
}

// CreateTurnOffAutoResourceOptimizeResponse creates a response to parse from TurnOffAutoResourceOptimize response
func CreateTurnOffAutoResourceOptimizeResponse() (response *TurnOffAutoResourceOptimizeResponse) {
	response = &TurnOffAutoResourceOptimizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
