package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteQualityRelativeNode invokes the dataworks_public.DeleteQualityRelativeNode API synchronously
func (client *Client) DeleteQualityRelativeNode(request *DeleteQualityRelativeNodeRequest) (response *DeleteQualityRelativeNodeResponse, err error) {
	response = CreateDeleteQualityRelativeNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteQualityRelativeNodeWithChan invokes the dataworks_public.DeleteQualityRelativeNode API asynchronously
func (client *Client) DeleteQualityRelativeNodeWithChan(request *DeleteQualityRelativeNodeRequest) (<-chan *DeleteQualityRelativeNodeResponse, <-chan error) {
	responseChan := make(chan *DeleteQualityRelativeNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteQualityRelativeNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteQualityRelativeNodeWithCallback invokes the dataworks_public.DeleteQualityRelativeNode API asynchronously
func (client *Client) DeleteQualityRelativeNodeWithCallback(request *DeleteQualityRelativeNodeRequest, callback func(response *DeleteQualityRelativeNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteQualityRelativeNodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteQualityRelativeNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteQualityRelativeNodeRequest is the request struct for api DeleteQualityRelativeNode
type DeleteQualityRelativeNodeRequest struct {
	*requests.RpcRequest
	ProjectName           string           `position:"Body" name:"ProjectName"`
	TargetNodeProjectId   requests.Integer `position:"Body" name:"TargetNodeProjectId"`
	MatchExpression       string           `position:"Body" name:"MatchExpression"`
	EnvType               string           `position:"Body" name:"EnvType"`
	TargetNodeProjectName string           `position:"Body" name:"TargetNodeProjectName"`
	TableName             string           `position:"Body" name:"TableName"`
	NodeId                requests.Integer `position:"Body" name:"NodeId"`
	ProjectId             requests.Integer `position:"Body" name:"ProjectId"`
}

// DeleteQualityRelativeNodeResponse is the response struct for api DeleteQualityRelativeNode
type DeleteQualityRelativeNodeResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteQualityRelativeNodeRequest creates a request to invoke DeleteQualityRelativeNode API
func CreateDeleteQualityRelativeNodeRequest() (request *DeleteQualityRelativeNodeRequest) {
	request = &DeleteQualityRelativeNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteQualityRelativeNode", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteQualityRelativeNodeResponse creates a response to parse from DeleteQualityRelativeNode response
func CreateDeleteQualityRelativeNodeResponse() (response *DeleteQualityRelativeNodeResponse) {
	response = &DeleteQualityRelativeNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
