package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateK8sService invokes the edas.CreateK8sService API synchronously
func (client *Client) CreateK8sService(request *CreateK8sServiceRequest) (response *CreateK8sServiceResponse, err error) {
	response = CreateCreateK8sServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateK8sServiceWithChan invokes the edas.CreateK8sService API asynchronously
func (client *Client) CreateK8sServiceWithChan(request *CreateK8sServiceRequest) (<-chan *CreateK8sServiceResponse, <-chan error) {
	responseChan := make(chan *CreateK8sServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateK8sService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateK8sServiceWithCallback invokes the edas.CreateK8sService API asynchronously
func (client *Client) CreateK8sServiceWithCallback(request *CreateK8sServiceRequest, callback func(response *CreateK8sServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateK8sServiceResponse
		var err error
		defer close(result)
		response, err = client.CreateK8sService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateK8sServiceRequest is the request struct for api CreateK8sService
type CreateK8sServiceRequest struct {
	*requests.RoaRequest
	AppId        string `position:"Query" name:"AppId"`
	Name         string `position:"Query" name:"Name"`
	Type         string `position:"Query" name:"Type"`
	ServicePorts string `position:"Query" name:"ServicePorts"`
}

// CreateK8sServiceResponse is the response struct for api CreateK8sService
type CreateK8sServiceResponse struct {
	*responses.BaseResponse
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
	Code          int    `json:"Code" xml:"Code"`
	Message       string `json:"Message" xml:"Message"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateK8sServiceRequest creates a request to invoke CreateK8sService API
func CreateCreateK8sServiceRequest() (request *CreateK8sServiceRequest) {
	request = &CreateK8sServiceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateK8sService", "/pop/v5/k8s/acs/k8s_service", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateK8sServiceResponse creates a response to parse from CreateK8sService response
func CreateCreateK8sServiceResponse() (response *CreateK8sServiceResponse) {
	response = &CreateK8sServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
