package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDeviceInternetPort invokes the ens.AddDeviceInternetPort API synchronously
func (client *Client) AddDeviceInternetPort(request *AddDeviceInternetPortRequest) (response *AddDeviceInternetPortResponse, err error) {
	response = CreateAddDeviceInternetPortResponse()
	err = client.DoAction(request, response)
	return
}

// AddDeviceInternetPortWithChan invokes the ens.AddDeviceInternetPort API asynchronously
func (client *Client) AddDeviceInternetPortWithChan(request *AddDeviceInternetPortRequest) (<-chan *AddDeviceInternetPortResponse, <-chan error) {
	responseChan := make(chan *AddDeviceInternetPortResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDeviceInternetPort(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDeviceInternetPortWithCallback invokes the ens.AddDeviceInternetPort API asynchronously
func (client *Client) AddDeviceInternetPortWithCallback(request *AddDeviceInternetPortRequest, callback func(response *AddDeviceInternetPortResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDeviceInternetPortResponse
		var err error
		defer close(result)
		response, err = client.AddDeviceInternetPort(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDeviceInternetPortRequest is the request struct for api AddDeviceInternetPort
type AddDeviceInternetPortRequest struct {
	*requests.RpcRequest
	ISP          string `position:"Query" name:"ISP"`
	InternalIp   string `position:"Query" name:"InternalIp"`
	NatType      string `position:"Query" name:"NatType"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	InternalPort string `position:"Query" name:"InternalPort"`
}

// AddDeviceInternetPortResponse is the response struct for api AddDeviceInternetPort
type AddDeviceInternetPortResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	RuleIds   []string `json:"RuleIds" xml:"RuleIds"`
}

// CreateAddDeviceInternetPortRequest creates a request to invoke AddDeviceInternetPort API
func CreateAddDeviceInternetPortRequest() (request *AddDeviceInternetPortRequest) {
	request = &AddDeviceInternetPortRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "AddDeviceInternetPort", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateAddDeviceInternetPortResponse creates a response to parse from AddDeviceInternetPort response
func CreateAddDeviceInternetPortResponse() (response *AddDeviceInternetPortResponse) {
	response = &AddDeviceInternetPortResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
