package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEdgeInstance invokes the iot.DeleteEdgeInstance API synchronously
func (client *Client) DeleteEdgeInstance(request *DeleteEdgeInstanceRequest) (response *DeleteEdgeInstanceResponse, err error) {
	response = CreateDeleteEdgeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEdgeInstanceWithChan invokes the iot.DeleteEdgeInstance API asynchronously
func (client *Client) DeleteEdgeInstanceWithChan(request *DeleteEdgeInstanceRequest) (<-chan *DeleteEdgeInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteEdgeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEdgeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEdgeInstanceWithCallback invokes the iot.DeleteEdgeInstance API asynchronously
func (client *Client) DeleteEdgeInstanceWithCallback(request *DeleteEdgeInstanceRequest, callback func(response *DeleteEdgeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEdgeInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteEdgeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEdgeInstanceRequest is the request struct for api DeleteEdgeInstance
type DeleteEdgeInstanceRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteEdgeInstanceResponse is the response struct for api DeleteEdgeInstance
type DeleteEdgeInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteEdgeInstanceRequest creates a request to invoke DeleteEdgeInstance API
func CreateDeleteEdgeInstanceRequest() (request *DeleteEdgeInstanceRequest) {
	request = &DeleteEdgeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteEdgeInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEdgeInstanceResponse creates a response to parse from DeleteEdgeInstance response
func CreateDeleteEdgeInstanceResponse() (response *DeleteEdgeInstanceResponse) {
	response = &DeleteEdgeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
