package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScheduledTask invokes the opensearch.CreateScheduledTask API synchronously
func (client *Client) CreateScheduledTask(request *CreateScheduledTaskRequest) (response *CreateScheduledTaskResponse, err error) {
	response = CreateCreateScheduledTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScheduledTaskWithChan invokes the opensearch.CreateScheduledTask API asynchronously
func (client *Client) CreateScheduledTaskWithChan(request *CreateScheduledTaskRequest) (<-chan *CreateScheduledTaskResponse, <-chan error) {
	responseChan := make(chan *CreateScheduledTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScheduledTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScheduledTaskWithCallback invokes the opensearch.CreateScheduledTask API asynchronously
func (client *Client) CreateScheduledTaskWithCallback(request *CreateScheduledTaskRequest, callback func(response *CreateScheduledTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScheduledTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateScheduledTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScheduledTaskRequest is the request struct for api CreateScheduledTask
type CreateScheduledTaskRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// CreateScheduledTaskResponse is the response struct for api CreateScheduledTask
type CreateScheduledTaskResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"requestId" xml:"requestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreateCreateScheduledTaskRequest creates a request to invoke CreateScheduledTask API
func CreateCreateScheduledTaskRequest() (request *CreateScheduledTaskRequest) {
	request = &CreateScheduledTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateScheduledTask", "/v4/openapi/app-groups/[appGroupIdentity]/scheduled-tasks", "opensearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateScheduledTaskResponse creates a response to parse from CreateScheduledTask response
func CreateCreateScheduledTaskResponse() (response *CreateScheduledTaskResponse) {
	response = &CreateScheduledTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
