package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotlineGroupDetailReport invokes the scsp.GetHotlineGroupDetailReport API synchronously
func (client *Client) GetHotlineGroupDetailReport(request *GetHotlineGroupDetailReportRequest) (response *GetHotlineGroupDetailReportResponse, err error) {
	response = CreateGetHotlineGroupDetailReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotlineGroupDetailReportWithChan invokes the scsp.GetHotlineGroupDetailReport API asynchronously
func (client *Client) GetHotlineGroupDetailReportWithChan(request *GetHotlineGroupDetailReportRequest) (<-chan *GetHotlineGroupDetailReportResponse, <-chan error) {
	responseChan := make(chan *GetHotlineGroupDetailReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotlineGroupDetailReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotlineGroupDetailReportWithCallback invokes the scsp.GetHotlineGroupDetailReport API asynchronously
func (client *Client) GetHotlineGroupDetailReportWithCallback(request *GetHotlineGroupDetailReportRequest, callback func(response *GetHotlineGroupDetailReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotlineGroupDetailReportResponse
		var err error
		defer close(result)
		response, err = client.GetHotlineGroupDetailReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotlineGroupDetailReportRequest is the request struct for api GetHotlineGroupDetailReport
type GetHotlineGroupDetailReportRequest struct {
	*requests.RpcRequest
	DepIds      *[]string        `position:"Query" name:"DepIds"  type:"Repeated"`
	EndDate     requests.Integer `position:"Query"`
	InstanceId  string           `position:"Query"`
	GroupIds    *[]string        `position:"Query" name:"GroupIds"  type:"Repeated"`
	PageSize    requests.Integer `position:"Query"`
	CurrentPage requests.Integer `position:"Query"`
	StartDate   requests.Integer `position:"Query"`
}

// GetHotlineGroupDetailReportResponse is the response struct for api GetHotlineGroupDetailReport
type GetHotlineGroupDetailReportResponse struct {
	*responses.BaseResponse
	Message   string                            `json:"Message" xml:"Message"`
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	Code      string                            `json:"Code" xml:"Code"`
	Success   string                            `json:"Success" xml:"Success"`
	Data      DataInGetHotlineGroupDetailReport `json:"Data" xml:"Data"`
}

// CreateGetHotlineGroupDetailReportRequest creates a request to invoke GetHotlineGroupDetailReport API
func CreateGetHotlineGroupDetailReportRequest() (request *GetHotlineGroupDetailReportRequest) {
	request = &GetHotlineGroupDetailReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetHotlineGroupDetailReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHotlineGroupDetailReportResponse creates a response to parse from GetHotlineGroupDetailReport response
func CreateGetHotlineGroupDetailReportResponse() (response *GetHotlineGroupDetailReportResponse) {
	response = &GetHotlineGroupDetailReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
