package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateVideo invokes the videoenhan.GenerateVideo API synchronously
func (client *Client) GenerateVideo(request *GenerateVideoRequest) (response *GenerateVideoResponse, err error) {
	response = CreateGenerateVideoResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateVideoWithChan invokes the videoenhan.GenerateVideo API asynchronously
func (client *Client) GenerateVideoWithChan(request *GenerateVideoRequest) (<-chan *GenerateVideoResponse, <-chan error) {
	responseChan := make(chan *GenerateVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateVideoWithCallback invokes the videoenhan.GenerateVideo API asynchronously
func (client *Client) GenerateVideoWithCallback(request *GenerateVideoRequest, callback func(response *GenerateVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateVideoResponse
		var err error
		defer close(result)
		response, err = client.GenerateVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateVideoRequest is the request struct for api GenerateVideo
type GenerateVideoRequest struct {
	*requests.RpcRequest
	TransitionStyle  string                   `position:"Body" name:"TransitionStyle"`
	Scene            string                   `position:"Body" name:"Scene"`
	Duration         requests.Float           `position:"Body" name:"Duration"`
	PuzzleEffect     requests.Boolean         `position:"Body" name:"PuzzleEffect"`
	Height           requests.Integer         `position:"Body" name:"Height"`
	DurationAdaption requests.Boolean         `position:"Body" name:"DurationAdaption"`
	FileList         *[]GenerateVideoFileList `position:"Body" name:"FileList"  type:"Repeated"`
	Mute             requests.Boolean         `position:"Body" name:"Mute"`
	Async            requests.Boolean         `position:"Body" name:"Async"`
	SmartEffect      requests.Boolean         `position:"Body" name:"SmartEffect"`
	Width            requests.Integer         `position:"Body" name:"Width"`
	Style            string                   `position:"Body" name:"Style"`
}

// GenerateVideoFileList is a repeated param struct in GenerateVideoRequest
type GenerateVideoFileList struct {
	FileName string `name:"FileName"`
	FileUrl  string `name:"FileUrl"`
	Type     string `name:"Type"`
}

// GenerateVideoResponse is the response struct for api GenerateVideo
type GenerateVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateVideoRequest creates a request to invoke GenerateVideo API
func CreateGenerateVideoRequest() (request *GenerateVideoRequest) {
	request = &GenerateVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "GenerateVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateVideoResponse creates a response to parse from GenerateVideo response
func CreateGenerateVideoResponse() (response *GenerateVideoResponse) {
	response = &GenerateVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
