//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package datafactory

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/datafactory/mgmt/2017-09-01-preview/datafactory"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAnonymous                      AuthenticationType = original.AuthenticationTypeAnonymous
	AuthenticationTypeBasic                          AuthenticationType = original.AuthenticationTypeBasic
	AuthenticationTypeClientCertificate              AuthenticationType = original.AuthenticationTypeClientCertificate
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = original.AuthenticationTypeWebLinkedServiceTypeProperties
)

type AuthorizationType = original.AuthorizationType

const (
	AuthorizationTypeKey                                AuthorizationType = original.AuthorizationTypeKey
	AuthorizationTypeLinkedIntegrationRuntimeProperties AuthorizationType = original.AuthorizationTypeLinkedIntegrationRuntimeProperties
	AuthorizationTypeRBAC                               AuthorizationType = original.AuthorizationTypeRBAC
)

type BlobEventTypes = original.BlobEventTypes

const (
	MicrosoftStorageBlobCreated BlobEventTypes = original.MicrosoftStorageBlobCreated
	MicrosoftStorageBlobDeleted BlobEventTypes = original.MicrosoftStorageBlobDeleted
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type DaysOfWeek = original.DaysOfWeek

const (
	DaysOfWeekFriday    DaysOfWeek = original.DaysOfWeekFriday
	DaysOfWeekMonday    DaysOfWeek = original.DaysOfWeekMonday
	DaysOfWeekSaturday  DaysOfWeek = original.DaysOfWeekSaturday
	DaysOfWeekSunday    DaysOfWeek = original.DaysOfWeekSunday
	DaysOfWeekThursday  DaysOfWeek = original.DaysOfWeekThursday
	DaysOfWeekTuesday   DaysOfWeek = original.DaysOfWeekTuesday
	DaysOfWeekWednesday DaysOfWeek = original.DaysOfWeekWednesday
)

type Db2AuthenticationType = original.Db2AuthenticationType

const (
	Basic Db2AuthenticationType = original.Basic
)

type DependencyCondition = original.DependencyCondition

const (
	Completed DependencyCondition = original.Completed
	Failed    DependencyCondition = original.Failed
	Skipped   DependencyCondition = original.Skipped
	Succeeded DependencyCondition = original.Succeeded
)

type FtpAuthenticationType = original.FtpAuthenticationType

const (
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = original.FtpAuthenticationTypeAnonymous
	FtpAuthenticationTypeBasic     FtpAuthenticationType = original.FtpAuthenticationTypeBasic
)

type GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationType

const (
	ServiceAuthentication GoogleBigQueryAuthenticationType = original.ServiceAuthentication
	UserAuthentication    GoogleBigQueryAuthenticationType = original.UserAuthentication
)

type HBaseAuthenticationType = original.HBaseAuthenticationType

const (
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = original.HBaseAuthenticationTypeAnonymous
	HBaseAuthenticationTypeBasic     HBaseAuthenticationType = original.HBaseAuthenticationTypeBasic
)

type HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOption

const (
	Always  HDInsightActivityDebugInfoOption = original.Always
	Failure HDInsightActivityDebugInfoOption = original.Failure
	None    HDInsightActivityDebugInfoOption = original.None
)

type HTTPAuthenticationType = original.HTTPAuthenticationType

const (
	HTTPAuthenticationTypeAnonymous         HTTPAuthenticationType = original.HTTPAuthenticationTypeAnonymous
	HTTPAuthenticationTypeBasic             HTTPAuthenticationType = original.HTTPAuthenticationTypeBasic
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = original.HTTPAuthenticationTypeClientCertificate
	HTTPAuthenticationTypeDigest            HTTPAuthenticationType = original.HTTPAuthenticationTypeDigest
	HTTPAuthenticationTypeWindows           HTTPAuthenticationType = original.HTTPAuthenticationTypeWindows
)

type HiveAuthenticationType = original.HiveAuthenticationType

const (
	Anonymous                    HiveAuthenticationType = original.Anonymous
	Username                     HiveAuthenticationType = original.Username
	UsernameAndPassword          HiveAuthenticationType = original.UsernameAndPassword
	WindowsAzureHDInsightService HiveAuthenticationType = original.WindowsAzureHDInsightService
)

type HiveServerType = original.HiveServerType

const (
	HiveServer1      HiveServerType = original.HiveServer1
	HiveServer2      HiveServerType = original.HiveServer2
	HiveThriftServer HiveServerType = original.HiveThriftServer
)

type HiveThriftTransportProtocol = original.HiveThriftTransportProtocol

const (
	Binary HiveThriftTransportProtocol = original.Binary
	HTTP   HiveThriftTransportProtocol = original.HTTP
	SASL   HiveThriftTransportProtocol = original.SASL
)

type ImpalaAuthenticationType = original.ImpalaAuthenticationType

const (
	ImpalaAuthenticationTypeAnonymous           ImpalaAuthenticationType = original.ImpalaAuthenticationTypeAnonymous
	ImpalaAuthenticationTypeSASLUsername        ImpalaAuthenticationType = original.ImpalaAuthenticationTypeSASLUsername
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = original.ImpalaAuthenticationTypeUsernameAndPassword
)

type IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyName

const (
	AuthKey1 IntegrationRuntimeAuthKeyName = original.AuthKey1
	AuthKey2 IntegrationRuntimeAuthKeyName = original.AuthKey2
)

type IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdate

const (
	Off IntegrationRuntimeAutoUpdate = original.Off
	On  IntegrationRuntimeAutoUpdate = original.On
)

type IntegrationRuntimeEdition = original.IntegrationRuntimeEdition

const (
	Enterprise IntegrationRuntimeEdition = original.Enterprise
	Standard   IntegrationRuntimeEdition = original.Standard
)

type IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceType

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeLinkedServiceReference
)

type IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionMode

const (
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.NotEncrypted
	NotSet       IntegrationRuntimeInternalChannelEncryptionMode = original.NotSet
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.SslEncrypted
)

type IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseType

const (
	BasePrice       IntegrationRuntimeLicenseType = original.BasePrice
	LicenseIncluded IntegrationRuntimeLicenseType = original.LicenseIncluded
)

type IntegrationRuntimeState = original.IntegrationRuntimeState

const (
	Initial          IntegrationRuntimeState = original.Initial
	Limited          IntegrationRuntimeState = original.Limited
	NeedRegistration IntegrationRuntimeState = original.NeedRegistration
	Offline          IntegrationRuntimeState = original.Offline
	Online           IntegrationRuntimeState = original.Online
	Started          IntegrationRuntimeState = original.Started
	Starting         IntegrationRuntimeState = original.Starting
	Stopped          IntegrationRuntimeState = original.Stopped
	Stopping         IntegrationRuntimeState = original.Stopping
)

type IntegrationRuntimeType = original.IntegrationRuntimeType

const (
	Managed    IntegrationRuntimeType = original.Managed
	SelfHosted IntegrationRuntimeType = original.SelfHosted
)

type IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResult

const (
	Fail    IntegrationRuntimeUpdateResult = original.Fail
	Succeed IntegrationRuntimeUpdateResult = original.Succeed
)

type JSONFormatFilePattern = original.JSONFormatFilePattern

const (
	ArrayOfObjects JSONFormatFilePattern = original.ArrayOfObjects
	SetOfObjects   JSONFormatFilePattern = original.SetOfObjects
)

type ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatus

const (
	ManagedIntegrationRuntimeNodeStatusAvailable   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusAvailable
	ManagedIntegrationRuntimeNodeStatusRecycling   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusRecycling
	ManagedIntegrationRuntimeNodeStatusStarting    ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusStarting
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusUnavailable
)

type MongoDbAuthenticationType = original.MongoDbAuthenticationType

const (
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = original.MongoDbAuthenticationTypeAnonymous
	MongoDbAuthenticationTypeBasic     MongoDbAuthenticationType = original.MongoDbAuthenticationTypeBasic
)

type ODataAuthenticationType = original.ODataAuthenticationType

const (
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = original.ODataAuthenticationTypeAnonymous
	ODataAuthenticationTypeBasic     ODataAuthenticationType = original.ODataAuthenticationTypeBasic
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray        ParameterType = original.ParameterTypeArray
	ParameterTypeBool         ParameterType = original.ParameterTypeBool
	ParameterTypeFloat        ParameterType = original.ParameterTypeFloat
	ParameterTypeInt          ParameterType = original.ParameterTypeInt
	ParameterTypeObject       ParameterType = original.ParameterTypeObject
	ParameterTypeSecureString ParameterType = original.ParameterTypeSecureString
	ParameterTypeString       ParameterType = original.ParameterTypeString
)

type PhoenixAuthenticationType = original.PhoenixAuthenticationType

const (
	PhoenixAuthenticationTypeAnonymous                    PhoenixAuthenticationType = original.PhoenixAuthenticationTypeAnonymous
	PhoenixAuthenticationTypeUsernameAndPassword          PhoenixAuthenticationType = original.PhoenixAuthenticationTypeUsernameAndPassword
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = original.PhoenixAuthenticationTypeWindowsAzureHDInsightService
)

type PipelineRunQueryFilterOperand = original.PipelineRunQueryFilterOperand

const (
	PipelineName PipelineRunQueryFilterOperand = original.PipelineName
	RunEnd       PipelineRunQueryFilterOperand = original.RunEnd
	RunStart     PipelineRunQueryFilterOperand = original.RunStart
	Status       PipelineRunQueryFilterOperand = original.Status
)

type PipelineRunQueryFilterOperator = original.PipelineRunQueryFilterOperator

const (
	Equals    PipelineRunQueryFilterOperator = original.Equals
	In        PipelineRunQueryFilterOperator = original.In
	NotEquals PipelineRunQueryFilterOperator = original.NotEquals
	NotIn     PipelineRunQueryFilterOperator = original.NotIn
)

type PipelineRunQueryOrder = original.PipelineRunQueryOrder

const (
	ASC  PipelineRunQueryOrder = original.ASC
	DESC PipelineRunQueryOrder = original.DESC
)

type PipelineRunQueryOrderByField = original.PipelineRunQueryOrderByField

const (
	PipelineRunQueryOrderByFieldRunEnd   PipelineRunQueryOrderByField = original.PipelineRunQueryOrderByFieldRunEnd
	PipelineRunQueryOrderByFieldRunStart PipelineRunQueryOrderByField = original.PipelineRunQueryOrderByFieldRunStart
)

type PrestoAuthenticationType = original.PrestoAuthenticationType

const (
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = original.PrestoAuthenticationTypeAnonymous
	PrestoAuthenticationTypeLDAP      PrestoAuthenticationType = original.PrestoAuthenticationTypeLDAP
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	Day          RecurrenceFrequency = original.Day
	Hour         RecurrenceFrequency = original.Hour
	Minute       RecurrenceFrequency = original.Minute
	Month        RecurrenceFrequency = original.Month
	NotSpecified RecurrenceFrequency = original.NotSpecified
	Week         RecurrenceFrequency = original.Week
	Year         RecurrenceFrequency = original.Year
)

type SapHanaAuthenticationType = original.SapHanaAuthenticationType

const (
	SapHanaAuthenticationTypeBasic   SapHanaAuthenticationType = original.SapHanaAuthenticationTypeBasic
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = original.SapHanaAuthenticationTypeWindows
)

type SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatus

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializeFailed
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializing
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusLimited
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusNeedRegistration
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOffline
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOnline
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusUpgrading
)

type ServiceNowAuthenticationType = original.ServiceNowAuthenticationType

const (
	ServiceNowAuthenticationTypeBasic  ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeBasic
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeOAuth2
)

type SftpAuthenticationType = original.SftpAuthenticationType

const (
	SftpAuthenticationTypeBasic        SftpAuthenticationType = original.SftpAuthenticationTypeBasic
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = original.SftpAuthenticationTypeSSHPublicKey
)

type SparkAuthenticationType = original.SparkAuthenticationType

const (
	SparkAuthenticationTypeAnonymous                    SparkAuthenticationType = original.SparkAuthenticationTypeAnonymous
	SparkAuthenticationTypeUsername                     SparkAuthenticationType = original.SparkAuthenticationTypeUsername
	SparkAuthenticationTypeUsernameAndPassword          SparkAuthenticationType = original.SparkAuthenticationTypeUsernameAndPassword
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = original.SparkAuthenticationTypeWindowsAzureHDInsightService
)

type SparkServerType = original.SparkServerType

const (
	SharkServer       SparkServerType = original.SharkServer
	SharkServer2      SparkServerType = original.SharkServer2
	SparkThriftServer SparkServerType = original.SparkThriftServer
)

type SparkThriftTransportProtocol = original.SparkThriftTransportProtocol

const (
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = original.SparkThriftTransportProtocolBinary
	SparkThriftTransportProtocolHTTP   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolHTTP
	SparkThriftTransportProtocolSASL   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolSASL
)

type SsisPackageLocationType = original.SsisPackageLocationType

const (
	File   SsisPackageLocationType = original.File
	SSISDB SsisPackageLocationType = original.SSISDB
)

type SybaseAuthenticationType = original.SybaseAuthenticationType

const (
	SybaseAuthenticationTypeBasic   SybaseAuthenticationType = original.SybaseAuthenticationTypeBasic
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = original.SybaseAuthenticationTypeWindows
)

type TeradataAuthenticationType = original.TeradataAuthenticationType

const (
	TeradataAuthenticationTypeBasic   TeradataAuthenticationType = original.TeradataAuthenticationTypeBasic
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = original.TeradataAuthenticationTypeWindows
)

type TriggerRunStatus = original.TriggerRunStatus

const (
	TriggerRunStatusFailed     TriggerRunStatus = original.TriggerRunStatusFailed
	TriggerRunStatusInprogress TriggerRunStatus = original.TriggerRunStatusInprogress
	TriggerRunStatusSucceeded  TriggerRunStatus = original.TriggerRunStatusSucceeded
)

type TriggerRuntimeState = original.TriggerRuntimeState

const (
	TriggerRuntimeStateDisabled TriggerRuntimeState = original.TriggerRuntimeStateDisabled
	TriggerRuntimeStateStarted  TriggerRuntimeState = original.TriggerRuntimeStateStarted
	TriggerRuntimeStateStopped  TriggerRuntimeState = original.TriggerRuntimeStateStopped
)

type TumblingWindowFrequency = original.TumblingWindowFrequency

const (
	TumblingWindowFrequencyHour   TumblingWindowFrequency = original.TumblingWindowFrequencyHour
	TumblingWindowFrequencyMinute TumblingWindowFrequency = original.TumblingWindowFrequencyMinute
)

type Type = original.Type

const (
	TypeAzureKeyVaultSecret Type = original.TypeAzureKeyVaultSecret
	TypeSecretBase          Type = original.TypeSecretBase
	TypeSecureString        Type = original.TypeSecureString
)

type TypeBasicActivity = original.TypeBasicActivity

const (
	TypeActivity                 TypeBasicActivity = original.TypeActivity
	TypeAzureMLBatchExecution    TypeBasicActivity = original.TypeAzureMLBatchExecution
	TypeAzureMLUpdateResource    TypeBasicActivity = original.TypeAzureMLUpdateResource
	TypeContainer                TypeBasicActivity = original.TypeContainer
	TypeCopy                     TypeBasicActivity = original.TypeCopy
	TypeCustom                   TypeBasicActivity = original.TypeCustom
	TypeDatabricksNotebook       TypeBasicActivity = original.TypeDatabricksNotebook
	TypeDataLakeAnalyticsUSQL    TypeBasicActivity = original.TypeDataLakeAnalyticsUSQL
	TypeExecutePipeline          TypeBasicActivity = original.TypeExecutePipeline
	TypeExecuteSSISPackage       TypeBasicActivity = original.TypeExecuteSSISPackage
	TypeExecution                TypeBasicActivity = original.TypeExecution
	TypeFilter                   TypeBasicActivity = original.TypeFilter
	TypeForEach                  TypeBasicActivity = original.TypeForEach
	TypeGetMetadata              TypeBasicActivity = original.TypeGetMetadata
	TypeHDInsightHive            TypeBasicActivity = original.TypeHDInsightHive
	TypeHDInsightMapReduce       TypeBasicActivity = original.TypeHDInsightMapReduce
	TypeHDInsightPig             TypeBasicActivity = original.TypeHDInsightPig
	TypeHDInsightSpark           TypeBasicActivity = original.TypeHDInsightSpark
	TypeHDInsightStreaming       TypeBasicActivity = original.TypeHDInsightStreaming
	TypeIfCondition              TypeBasicActivity = original.TypeIfCondition
	TypeLookup                   TypeBasicActivity = original.TypeLookup
	TypeSQLServerStoredProcedure TypeBasicActivity = original.TypeSQLServerStoredProcedure
	TypeUntil                    TypeBasicActivity = original.TypeUntil
	TypeWait                     TypeBasicActivity = original.TypeWait
	TypeWebActivity              TypeBasicActivity = original.TypeWebActivity
)

type TypeBasicCopySink = original.TypeBasicCopySink

const (
	TypeAzureDataLakeStoreSink   TypeBasicCopySink = original.TypeAzureDataLakeStoreSink
	TypeAzureQueueSink           TypeBasicCopySink = original.TypeAzureQueueSink
	TypeAzureSearchIndexSink     TypeBasicCopySink = original.TypeAzureSearchIndexSink
	TypeAzureTableSink           TypeBasicCopySink = original.TypeAzureTableSink
	TypeBlobSink                 TypeBasicCopySink = original.TypeBlobSink
	TypeCopySink                 TypeBasicCopySink = original.TypeCopySink
	TypeDocumentDbCollectionSink TypeBasicCopySink = original.TypeDocumentDbCollectionSink
	TypeDynamicsSink             TypeBasicCopySink = original.TypeDynamicsSink
	TypeFileSystemSink           TypeBasicCopySink = original.TypeFileSystemSink
	TypeOdbcSink                 TypeBasicCopySink = original.TypeOdbcSink
	TypeOracleSink               TypeBasicCopySink = original.TypeOracleSink
	TypeSalesforceSink           TypeBasicCopySink = original.TypeSalesforceSink
	TypeSapCloudForCustomerSink  TypeBasicCopySink = original.TypeSapCloudForCustomerSink
	TypeSQLDWSink                TypeBasicCopySink = original.TypeSQLDWSink
	TypeSQLSink                  TypeBasicCopySink = original.TypeSQLSink
)

type TypeBasicCopySource = original.TypeBasicCopySource

const (
	TypeAmazonMWSSource                TypeBasicCopySource = original.TypeAmazonMWSSource
	TypeAmazonRedshiftSource           TypeBasicCopySource = original.TypeAmazonRedshiftSource
	TypeAzureDataLakeStoreSource       TypeBasicCopySource = original.TypeAzureDataLakeStoreSource
	TypeAzureMySQLSource               TypeBasicCopySource = original.TypeAzureMySQLSource
	TypeAzurePostgreSQLSource          TypeBasicCopySource = original.TypeAzurePostgreSQLSource
	TypeAzureTableSource               TypeBasicCopySource = original.TypeAzureTableSource
	TypeBlobSource                     TypeBasicCopySource = original.TypeBlobSource
	TypeCassandraSource                TypeBasicCopySource = original.TypeCassandraSource
	TypeConcurSource                   TypeBasicCopySource = original.TypeConcurSource
	TypeCopySource                     TypeBasicCopySource = original.TypeCopySource
	TypeCouchbaseSource                TypeBasicCopySource = original.TypeCouchbaseSource
	TypeDocumentDbCollectionSource     TypeBasicCopySource = original.TypeDocumentDbCollectionSource
	TypeDrillSource                    TypeBasicCopySource = original.TypeDrillSource
	TypeDynamicsSource                 TypeBasicCopySource = original.TypeDynamicsSource
	TypeEloquaSource                   TypeBasicCopySource = original.TypeEloquaSource
	TypeFileSystemSource               TypeBasicCopySource = original.TypeFileSystemSource
	TypeGoogleBigQuerySource           TypeBasicCopySource = original.TypeGoogleBigQuerySource
	TypeGreenplumSource                TypeBasicCopySource = original.TypeGreenplumSource
	TypeHBaseSource                    TypeBasicCopySource = original.TypeHBaseSource
	TypeHdfsSource                     TypeBasicCopySource = original.TypeHdfsSource
	TypeHiveSource                     TypeBasicCopySource = original.TypeHiveSource
	TypeHTTPSource                     TypeBasicCopySource = original.TypeHTTPSource
	TypeHubspotSource                  TypeBasicCopySource = original.TypeHubspotSource
	TypeImpalaSource                   TypeBasicCopySource = original.TypeImpalaSource
	TypeJiraSource                     TypeBasicCopySource = original.TypeJiraSource
	TypeMagentoSource                  TypeBasicCopySource = original.TypeMagentoSource
	TypeMariaDBSource                  TypeBasicCopySource = original.TypeMariaDBSource
	TypeMarketoSource                  TypeBasicCopySource = original.TypeMarketoSource
	TypeMongoDbSource                  TypeBasicCopySource = original.TypeMongoDbSource
	TypeNetezzaSource                  TypeBasicCopySource = original.TypeNetezzaSource
	TypeOracleSource                   TypeBasicCopySource = original.TypeOracleSource
	TypePaypalSource                   TypeBasicCopySource = original.TypePaypalSource
	TypePhoenixSource                  TypeBasicCopySource = original.TypePhoenixSource
	TypePrestoSource                   TypeBasicCopySource = original.TypePrestoSource
	TypeQuickBooksSource               TypeBasicCopySource = original.TypeQuickBooksSource
	TypeRelationalSource               TypeBasicCopySource = original.TypeRelationalSource
	TypeResponsysSource                TypeBasicCopySource = original.TypeResponsysSource
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = original.TypeSalesforceMarketingCloudSource
	TypeSalesforceSource               TypeBasicCopySource = original.TypeSalesforceSource
	TypeSapCloudForCustomerSource      TypeBasicCopySource = original.TypeSapCloudForCustomerSource
	TypeSapEccSource                   TypeBasicCopySource = original.TypeSapEccSource
	TypeServiceNowSource               TypeBasicCopySource = original.TypeServiceNowSource
	TypeShopifySource                  TypeBasicCopySource = original.TypeShopifySource
	TypeSparkSource                    TypeBasicCopySource = original.TypeSparkSource
	TypeSQLDWSource                    TypeBasicCopySource = original.TypeSQLDWSource
	TypeSQLSource                      TypeBasicCopySource = original.TypeSQLSource
	TypeSquareSource                   TypeBasicCopySource = original.TypeSquareSource
	TypeVerticaSource                  TypeBasicCopySource = original.TypeVerticaSource
	TypeWebSource                      TypeBasicCopySource = original.TypeWebSource
	TypeXeroSource                     TypeBasicCopySource = original.TypeXeroSource
	TypeZohoSource                     TypeBasicCopySource = original.TypeZohoSource
)

type TypeBasicDataset = original.TypeBasicDataset

const (
	TypeAmazonMWSObject                TypeBasicDataset = original.TypeAmazonMWSObject
	TypeAmazonS3Object                 TypeBasicDataset = original.TypeAmazonS3Object
	TypeAzureBlob                      TypeBasicDataset = original.TypeAzureBlob
	TypeAzureDataLakeStoreFile         TypeBasicDataset = original.TypeAzureDataLakeStoreFile
	TypeAzureMySQLTable                TypeBasicDataset = original.TypeAzureMySQLTable
	TypeAzurePostgreSQLTable           TypeBasicDataset = original.TypeAzurePostgreSQLTable
	TypeAzureSearchIndex               TypeBasicDataset = original.TypeAzureSearchIndex
	TypeAzureSQLDWTable                TypeBasicDataset = original.TypeAzureSQLDWTable
	TypeAzureSQLTable                  TypeBasicDataset = original.TypeAzureSQLTable
	TypeAzureTable                     TypeBasicDataset = original.TypeAzureTable
	TypeCassandraTable                 TypeBasicDataset = original.TypeCassandraTable
	TypeConcurObject                   TypeBasicDataset = original.TypeConcurObject
	TypeCouchbaseTable                 TypeBasicDataset = original.TypeCouchbaseTable
	TypeCustomDataset                  TypeBasicDataset = original.TypeCustomDataset
	TypeDataset                        TypeBasicDataset = original.TypeDataset
	TypeDocumentDbCollection           TypeBasicDataset = original.TypeDocumentDbCollection
	TypeDrillTable                     TypeBasicDataset = original.TypeDrillTable
	TypeDynamicsEntity                 TypeBasicDataset = original.TypeDynamicsEntity
	TypeEloquaObject                   TypeBasicDataset = original.TypeEloquaObject
	TypeFileShare                      TypeBasicDataset = original.TypeFileShare
	TypeGoogleBigQueryObject           TypeBasicDataset = original.TypeGoogleBigQueryObject
	TypeGreenplumTable                 TypeBasicDataset = original.TypeGreenplumTable
	TypeHBaseObject                    TypeBasicDataset = original.TypeHBaseObject
	TypeHiveObject                     TypeBasicDataset = original.TypeHiveObject
	TypeHTTPFile                       TypeBasicDataset = original.TypeHTTPFile
	TypeHubspotObject                  TypeBasicDataset = original.TypeHubspotObject
	TypeImpalaObject                   TypeBasicDataset = original.TypeImpalaObject
	TypeJiraObject                     TypeBasicDataset = original.TypeJiraObject
	TypeMagentoObject                  TypeBasicDataset = original.TypeMagentoObject
	TypeMariaDBTable                   TypeBasicDataset = original.TypeMariaDBTable
	TypeMarketoObject                  TypeBasicDataset = original.TypeMarketoObject
	TypeMongoDbCollection              TypeBasicDataset = original.TypeMongoDbCollection
	TypeNetezzaTable                   TypeBasicDataset = original.TypeNetezzaTable
	TypeODataResource                  TypeBasicDataset = original.TypeODataResource
	TypeOracleTable                    TypeBasicDataset = original.TypeOracleTable
	TypePaypalObject                   TypeBasicDataset = original.TypePaypalObject
	TypePhoenixObject                  TypeBasicDataset = original.TypePhoenixObject
	TypePrestoObject                   TypeBasicDataset = original.TypePrestoObject
	TypeQuickBooksObject               TypeBasicDataset = original.TypeQuickBooksObject
	TypeRelationalTable                TypeBasicDataset = original.TypeRelationalTable
	TypeResponsysObject                TypeBasicDataset = original.TypeResponsysObject
	TypeSalesforceMarketingCloudObject TypeBasicDataset = original.TypeSalesforceMarketingCloudObject
	TypeSalesforceObject               TypeBasicDataset = original.TypeSalesforceObject
	TypeSapCloudForCustomerResource    TypeBasicDataset = original.TypeSapCloudForCustomerResource
	TypeSapEccResource                 TypeBasicDataset = original.TypeSapEccResource
	TypeServiceNowObject               TypeBasicDataset = original.TypeServiceNowObject
	TypeShopifyObject                  TypeBasicDataset = original.TypeShopifyObject
	TypeSparkObject                    TypeBasicDataset = original.TypeSparkObject
	TypeSQLServerTable                 TypeBasicDataset = original.TypeSQLServerTable
	TypeSquareObject                   TypeBasicDataset = original.TypeSquareObject
	TypeVerticaTable                   TypeBasicDataset = original.TypeVerticaTable
	TypeWebTable                       TypeBasicDataset = original.TypeWebTable
	TypeXeroObject                     TypeBasicDataset = original.TypeXeroObject
	TypeZohoObject                     TypeBasicDataset = original.TypeZohoObject
)

type TypeBasicDatasetCompression = original.TypeBasicDatasetCompression

const (
	TypeBZip2              TypeBasicDatasetCompression = original.TypeBZip2
	TypeDatasetCompression TypeBasicDatasetCompression = original.TypeDatasetCompression
	TypeDeflate            TypeBasicDatasetCompression = original.TypeDeflate
	TypeGZip               TypeBasicDatasetCompression = original.TypeGZip
	TypeZipDeflate         TypeBasicDatasetCompression = original.TypeZipDeflate
)

type TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormat

const (
	TypeAvroFormat           TypeBasicDatasetStorageFormat = original.TypeAvroFormat
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = original.TypeDatasetStorageFormat
	TypeJSONFormat           TypeBasicDatasetStorageFormat = original.TypeJSONFormat
	TypeOrcFormat            TypeBasicDatasetStorageFormat = original.TypeOrcFormat
	TypeParquetFormat        TypeBasicDatasetStorageFormat = original.TypeParquetFormat
	TypeTextFormat           TypeBasicDatasetStorageFormat = original.TypeTextFormat
)

type TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntime

const (
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = original.TypeIntegrationRuntime
	TypeManaged            TypeBasicIntegrationRuntime = original.TypeManaged
	TypeSelfHosted         TypeBasicIntegrationRuntime = original.TypeSelfHosted
)

type TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatus

const (
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus
	TypeBasicIntegrationRuntimeStatusTypeManaged                  TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeManaged
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted               TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeSelfHosted
)

type TypeBasicLinkedService = original.TypeBasicLinkedService

const (
	TypeAmazonMWS                TypeBasicLinkedService = original.TypeAmazonMWS
	TypeAmazonRedshift           TypeBasicLinkedService = original.TypeAmazonRedshift
	TypeAmazonS3                 TypeBasicLinkedService = original.TypeAmazonS3
	TypeAzureBatch               TypeBasicLinkedService = original.TypeAzureBatch
	TypeAzureDatabricks          TypeBasicLinkedService = original.TypeAzureDatabricks
	TypeAzureDataLakeAnalytics   TypeBasicLinkedService = original.TypeAzureDataLakeAnalytics
	TypeAzureDataLakeStore       TypeBasicLinkedService = original.TypeAzureDataLakeStore
	TypeAzureKeyVault            TypeBasicLinkedService = original.TypeAzureKeyVault
	TypeAzureML                  TypeBasicLinkedService = original.TypeAzureML
	TypeAzureMySQL               TypeBasicLinkedService = original.TypeAzureMySQL
	TypeAzurePostgreSQL          TypeBasicLinkedService = original.TypeAzurePostgreSQL
	TypeAzureSearch              TypeBasicLinkedService = original.TypeAzureSearch
	TypeAzureSQLDatabase         TypeBasicLinkedService = original.TypeAzureSQLDatabase
	TypeAzureSQLDW               TypeBasicLinkedService = original.TypeAzureSQLDW
	TypeAzureStorage             TypeBasicLinkedService = original.TypeAzureStorage
	TypeCassandra                TypeBasicLinkedService = original.TypeCassandra
	TypeConcur                   TypeBasicLinkedService = original.TypeConcur
	TypeCosmosDb                 TypeBasicLinkedService = original.TypeCosmosDb
	TypeCouchbase                TypeBasicLinkedService = original.TypeCouchbase
	TypeCustomDataSource         TypeBasicLinkedService = original.TypeCustomDataSource
	TypeDb2                      TypeBasicLinkedService = original.TypeDb2
	TypeDrill                    TypeBasicLinkedService = original.TypeDrill
	TypeDynamics                 TypeBasicLinkedService = original.TypeDynamics
	TypeEloqua                   TypeBasicLinkedService = original.TypeEloqua
	TypeFileServer               TypeBasicLinkedService = original.TypeFileServer
	TypeFtpServer                TypeBasicLinkedService = original.TypeFtpServer
	TypeGoogleBigQuery           TypeBasicLinkedService = original.TypeGoogleBigQuery
	TypeGreenplum                TypeBasicLinkedService = original.TypeGreenplum
	TypeHBase                    TypeBasicLinkedService = original.TypeHBase
	TypeHdfs                     TypeBasicLinkedService = original.TypeHdfs
	TypeHDInsight                TypeBasicLinkedService = original.TypeHDInsight
	TypeHDInsightOnDemand        TypeBasicLinkedService = original.TypeHDInsightOnDemand
	TypeHive                     TypeBasicLinkedService = original.TypeHive
	TypeHTTPServer               TypeBasicLinkedService = original.TypeHTTPServer
	TypeHubspot                  TypeBasicLinkedService = original.TypeHubspot
	TypeImpala                   TypeBasicLinkedService = original.TypeImpala
	TypeJira                     TypeBasicLinkedService = original.TypeJira
	TypeLinkedService            TypeBasicLinkedService = original.TypeLinkedService
	TypeMagento                  TypeBasicLinkedService = original.TypeMagento
	TypeMariaDB                  TypeBasicLinkedService = original.TypeMariaDB
	TypeMarketo                  TypeBasicLinkedService = original.TypeMarketo
	TypeMongoDb                  TypeBasicLinkedService = original.TypeMongoDb
	TypeMySQL                    TypeBasicLinkedService = original.TypeMySQL
	TypeNetezza                  TypeBasicLinkedService = original.TypeNetezza
	TypeOData                    TypeBasicLinkedService = original.TypeOData
	TypeOdbc                     TypeBasicLinkedService = original.TypeOdbc
	TypeOracle                   TypeBasicLinkedService = original.TypeOracle
	TypePaypal                   TypeBasicLinkedService = original.TypePaypal
	TypePhoenix                  TypeBasicLinkedService = original.TypePhoenix
	TypePostgreSQL               TypeBasicLinkedService = original.TypePostgreSQL
	TypePresto                   TypeBasicLinkedService = original.TypePresto
	TypeQuickBooks               TypeBasicLinkedService = original.TypeQuickBooks
	TypeResponsys                TypeBasicLinkedService = original.TypeResponsys
	TypeSalesforce               TypeBasicLinkedService = original.TypeSalesforce
	TypeSalesforceMarketingCloud TypeBasicLinkedService = original.TypeSalesforceMarketingCloud
	TypeSapBW                    TypeBasicLinkedService = original.TypeSapBW
	TypeSapCloudForCustomer      TypeBasicLinkedService = original.TypeSapCloudForCustomer
	TypeSapEcc                   TypeBasicLinkedService = original.TypeSapEcc
	TypeSapHana                  TypeBasicLinkedService = original.TypeSapHana
	TypeServiceNow               TypeBasicLinkedService = original.TypeServiceNow
	TypeSftp                     TypeBasicLinkedService = original.TypeSftp
	TypeShopify                  TypeBasicLinkedService = original.TypeShopify
	TypeSpark                    TypeBasicLinkedService = original.TypeSpark
	TypeSQLServer                TypeBasicLinkedService = original.TypeSQLServer
	TypeSquare                   TypeBasicLinkedService = original.TypeSquare
	TypeSybase                   TypeBasicLinkedService = original.TypeSybase
	TypeTeradata                 TypeBasicLinkedService = original.TypeTeradata
	TypeVertica                  TypeBasicLinkedService = original.TypeVertica
	TypeWeb                      TypeBasicLinkedService = original.TypeWeb
	TypeXero                     TypeBasicLinkedService = original.TypeXero
	TypeZoho                     TypeBasicLinkedService = original.TypeZoho
)

type TypeBasicTrigger = original.TypeBasicTrigger

const (
	TypeBlobEventsTrigger       TypeBasicTrigger = original.TypeBlobEventsTrigger
	TypeBlobTrigger             TypeBasicTrigger = original.TypeBlobTrigger
	TypeMultiplePipelineTrigger TypeBasicTrigger = original.TypeMultiplePipelineTrigger
	TypeScheduleTrigger         TypeBasicTrigger = original.TypeScheduleTrigger
	TypeTrigger                 TypeBasicTrigger = original.TypeTrigger
	TypeTumblingWindowTrigger   TypeBasicTrigger = original.TypeTumblingWindowTrigger
)

type WebActivityMethod = original.WebActivityMethod

const (
	DELETE WebActivityMethod = original.DELETE
	GET    WebActivityMethod = original.GET
	POST   WebActivityMethod = original.POST
	PUT    WebActivityMethod = original.PUT
)

type Activity = original.Activity
type ActivityDependency = original.ActivityDependency
type ActivityPolicy = original.ActivityPolicy
type ActivityRun = original.ActivityRun
type ActivityRunsClient = original.ActivityRunsClient
type ActivityRunsListResponse = original.ActivityRunsListResponse
type ActivityRunsListResponseIterator = original.ActivityRunsListResponseIterator
type ActivityRunsListResponsePage = original.ActivityRunsListResponsePage
type AmazonMWSLinkedService = original.AmazonMWSLinkedService
type AmazonMWSLinkedServiceTypeProperties = original.AmazonMWSLinkedServiceTypeProperties
type AmazonMWSObjectDataset = original.AmazonMWSObjectDataset
type AmazonMWSSource = original.AmazonMWSSource
type AmazonRedshiftLinkedService = original.AmazonRedshiftLinkedService
type AmazonRedshiftLinkedServiceTypeProperties = original.AmazonRedshiftLinkedServiceTypeProperties
type AmazonRedshiftSource = original.AmazonRedshiftSource
type AmazonS3Dataset = original.AmazonS3Dataset
type AmazonS3DatasetTypeProperties = original.AmazonS3DatasetTypeProperties
type AmazonS3LinkedService = original.AmazonS3LinkedService
type AmazonS3LinkedServiceTypeProperties = original.AmazonS3LinkedServiceTypeProperties
type AvroFormat = original.AvroFormat
type AzureBatchLinkedService = original.AzureBatchLinkedService
type AzureBatchLinkedServiceTypeProperties = original.AzureBatchLinkedServiceTypeProperties
type AzureBlobDataset = original.AzureBlobDataset
type AzureBlobDatasetTypeProperties = original.AzureBlobDatasetTypeProperties
type AzureDataLakeAnalyticsLinkedService = original.AzureDataLakeAnalyticsLinkedService
type AzureDataLakeAnalyticsLinkedServiceTypeProperties = original.AzureDataLakeAnalyticsLinkedServiceTypeProperties
type AzureDataLakeStoreDataset = original.AzureDataLakeStoreDataset
type AzureDataLakeStoreDatasetTypeProperties = original.AzureDataLakeStoreDatasetTypeProperties
type AzureDataLakeStoreLinkedService = original.AzureDataLakeStoreLinkedService
type AzureDataLakeStoreLinkedServiceTypeProperties = original.AzureDataLakeStoreLinkedServiceTypeProperties
type AzureDataLakeStoreSink = original.AzureDataLakeStoreSink
type AzureDataLakeStoreSource = original.AzureDataLakeStoreSource
type AzureDatabricksLinkedService = original.AzureDatabricksLinkedService
type AzureDatabricksLinkedServiceTypeProperties = original.AzureDatabricksLinkedServiceTypeProperties
type AzureKeyVaultLinkedService = original.AzureKeyVaultLinkedService
type AzureKeyVaultLinkedServiceTypeProperties = original.AzureKeyVaultLinkedServiceTypeProperties
type AzureKeyVaultSecretReference = original.AzureKeyVaultSecretReference
type AzureMLBatchExecutionActivity = original.AzureMLBatchExecutionActivity
type AzureMLBatchExecutionActivityTypeProperties = original.AzureMLBatchExecutionActivityTypeProperties
type AzureMLLinkedService = original.AzureMLLinkedService
type AzureMLLinkedServiceTypeProperties = original.AzureMLLinkedServiceTypeProperties
type AzureMLUpdateResourceActivity = original.AzureMLUpdateResourceActivity
type AzureMLUpdateResourceActivityTypeProperties = original.AzureMLUpdateResourceActivityTypeProperties
type AzureMLWebServiceFile = original.AzureMLWebServiceFile
type AzureMySQLLinkedService = original.AzureMySQLLinkedService
type AzureMySQLLinkedServiceTypeProperties = original.AzureMySQLLinkedServiceTypeProperties
type AzureMySQLSource = original.AzureMySQLSource
type AzureMySQLTableDataset = original.AzureMySQLTableDataset
type AzureMySQLTableDatasetTypeProperties = original.AzureMySQLTableDatasetTypeProperties
type AzurePostgreSQLLinkedService = original.AzurePostgreSQLLinkedService
type AzurePostgreSQLLinkedServiceTypeProperties = original.AzurePostgreSQLLinkedServiceTypeProperties
type AzurePostgreSQLSource = original.AzurePostgreSQLSource
type AzurePostgreSQLTableDataset = original.AzurePostgreSQLTableDataset
type AzureQueueSink = original.AzureQueueSink
type AzureSQLDWLinkedService = original.AzureSQLDWLinkedService
type AzureSQLDWLinkedServiceTypeProperties = original.AzureSQLDWLinkedServiceTypeProperties
type AzureSQLDWTableDataset = original.AzureSQLDWTableDataset
type AzureSQLDWTableDatasetTypeProperties = original.AzureSQLDWTableDatasetTypeProperties
type AzureSQLDatabaseLinkedService = original.AzureSQLDatabaseLinkedService
type AzureSQLDatabaseLinkedServiceTypeProperties = original.AzureSQLDatabaseLinkedServiceTypeProperties
type AzureSQLTableDataset = original.AzureSQLTableDataset
type AzureSQLTableDatasetTypeProperties = original.AzureSQLTableDatasetTypeProperties
type AzureSearchIndexDataset = original.AzureSearchIndexDataset
type AzureSearchIndexDatasetTypeProperties = original.AzureSearchIndexDatasetTypeProperties
type AzureSearchIndexSink = original.AzureSearchIndexSink
type AzureSearchLinkedService = original.AzureSearchLinkedService
type AzureSearchLinkedServiceTypeProperties = original.AzureSearchLinkedServiceTypeProperties
type AzureStorageLinkedService = original.AzureStorageLinkedService
type AzureStorageLinkedServiceTypeProperties = original.AzureStorageLinkedServiceTypeProperties
type AzureTableDataset = original.AzureTableDataset
type AzureTableDatasetTypeProperties = original.AzureTableDatasetTypeProperties
type AzureTableSink = original.AzureTableSink
type AzureTableSource = original.AzureTableSource
type BaseClient = original.BaseClient
type BasicActivity = original.BasicActivity
type BasicControlActivity = original.BasicControlActivity
type BasicCopySink = original.BasicCopySink
type BasicCopySource = original.BasicCopySource
type BasicDataset = original.BasicDataset
type BasicDatasetCompression = original.BasicDatasetCompression
type BasicDatasetStorageFormat = original.BasicDatasetStorageFormat
type BasicExecutionActivity = original.BasicExecutionActivity
type BasicIntegrationRuntime = original.BasicIntegrationRuntime
type BasicIntegrationRuntimeStatus = original.BasicIntegrationRuntimeStatus
type BasicLinkedIntegrationRuntimeProperties = original.BasicLinkedIntegrationRuntimeProperties
type BasicLinkedService = original.BasicLinkedService
type BasicMultiplePipelineTrigger = original.BasicMultiplePipelineTrigger
type BasicSecretBase = original.BasicSecretBase
type BasicTrigger = original.BasicTrigger
type BasicWebLinkedServiceTypeProperties = original.BasicWebLinkedServiceTypeProperties
type BlobEventsTrigger = original.BlobEventsTrigger
type BlobEventsTriggerTypeProperties = original.BlobEventsTriggerTypeProperties
type BlobSink = original.BlobSink
type BlobSource = original.BlobSource
type BlobTrigger = original.BlobTrigger
type BlobTriggerTypeProperties = original.BlobTriggerTypeProperties
type CassandraLinkedService = original.CassandraLinkedService
type CassandraLinkedServiceTypeProperties = original.CassandraLinkedServiceTypeProperties
type CassandraSource = original.CassandraSource
type CassandraTableDataset = original.CassandraTableDataset
type CassandraTableDatasetTypeProperties = original.CassandraTableDatasetTypeProperties
type ConcurLinkedService = original.ConcurLinkedService
type ConcurLinkedServiceTypeProperties = original.ConcurLinkedServiceTypeProperties
type ConcurObjectDataset = original.ConcurObjectDataset
type ConcurSource = original.ConcurSource
type ControlActivity = original.ControlActivity
type CopyActivity = original.CopyActivity
type CopyActivityTypeProperties = original.CopyActivityTypeProperties
type CopySink = original.CopySink
type CopySource = original.CopySource
type CosmosDbLinkedService = original.CosmosDbLinkedService
type CosmosDbLinkedServiceTypeProperties = original.CosmosDbLinkedServiceTypeProperties
type CouchbaseLinkedService = original.CouchbaseLinkedService
type CouchbaseLinkedServiceTypeProperties = original.CouchbaseLinkedServiceTypeProperties
type CouchbaseSource = original.CouchbaseSource
type CouchbaseTableDataset = original.CouchbaseTableDataset
type CreateRunResponse = original.CreateRunResponse
type CustomActivity = original.CustomActivity
type CustomActivityReferenceObject = original.CustomActivityReferenceObject
type CustomActivityTypeProperties = original.CustomActivityTypeProperties
type CustomDataSourceLinkedService = original.CustomDataSourceLinkedService
type CustomDataset = original.CustomDataset
type DataLakeAnalyticsUSQLActivity = original.DataLakeAnalyticsUSQLActivity
type DataLakeAnalyticsUSQLActivityTypeProperties = original.DataLakeAnalyticsUSQLActivityTypeProperties
type DatabricksNotebookActivity = original.DatabricksNotebookActivity
type DatabricksNotebookActivityTypeProperties = original.DatabricksNotebookActivityTypeProperties
type Dataset = original.Dataset
type DatasetBZip2Compression = original.DatasetBZip2Compression
type DatasetCompression = original.DatasetCompression
type DatasetDeflateCompression = original.DatasetDeflateCompression
type DatasetGZipCompression = original.DatasetGZipCompression
type DatasetListResponse = original.DatasetListResponse
type DatasetListResponseIterator = original.DatasetListResponseIterator
type DatasetListResponsePage = original.DatasetListResponsePage
type DatasetReference = original.DatasetReference
type DatasetResource = original.DatasetResource
type DatasetStorageFormat = original.DatasetStorageFormat
type DatasetZipDeflateCompression = original.DatasetZipDeflateCompression
type DatasetsClient = original.DatasetsClient
type Db2LinkedService = original.Db2LinkedService
type Db2LinkedServiceTypeProperties = original.Db2LinkedServiceTypeProperties
type DistcpSettings = original.DistcpSettings
type DocumentDbCollectionDataset = original.DocumentDbCollectionDataset
type DocumentDbCollectionDatasetTypeProperties = original.DocumentDbCollectionDatasetTypeProperties
type DocumentDbCollectionSink = original.DocumentDbCollectionSink
type DocumentDbCollectionSource = original.DocumentDbCollectionSource
type DrillLinkedService = original.DrillLinkedService
type DrillLinkedServiceTypeProperties = original.DrillLinkedServiceTypeProperties
type DrillSource = original.DrillSource
type DrillTableDataset = original.DrillTableDataset
type DynamicsEntityDataset = original.DynamicsEntityDataset
type DynamicsEntityDatasetTypeProperties = original.DynamicsEntityDatasetTypeProperties
type DynamicsLinkedService = original.DynamicsLinkedService
type DynamicsLinkedServiceTypeProperties = original.DynamicsLinkedServiceTypeProperties
type DynamicsSink = original.DynamicsSink
type DynamicsSource = original.DynamicsSource
type EloquaLinkedService = original.EloquaLinkedService
type EloquaLinkedServiceTypeProperties = original.EloquaLinkedServiceTypeProperties
type EloquaObjectDataset = original.EloquaObjectDataset
type EloquaSource = original.EloquaSource
type EntityReference = original.EntityReference
type ErrorResponse = original.ErrorResponse
type ExecutePipelineActivity = original.ExecutePipelineActivity
type ExecutePipelineActivityTypeProperties = original.ExecutePipelineActivityTypeProperties
type ExecuteSSISPackageActivity = original.ExecuteSSISPackageActivity
type ExecuteSSISPackageActivityTypeProperties = original.ExecuteSSISPackageActivityTypeProperties
type ExecutionActivity = original.ExecutionActivity
type Expression = original.Expression
type FactoriesClient = original.FactoriesClient
type Factory = original.Factory
type FactoryIdentity = original.FactoryIdentity
type FactoryListResponse = original.FactoryListResponse
type FactoryListResponseIterator = original.FactoryListResponseIterator
type FactoryListResponsePage = original.FactoryListResponsePage
type FactoryProperties = original.FactoryProperties
type FactoryRepoUpdate = original.FactoryRepoUpdate
type FactoryUpdateParameters = original.FactoryUpdateParameters
type FactoryVSTSConfiguration = original.FactoryVSTSConfiguration
type FileServerLinkedService = original.FileServerLinkedService
type FileServerLinkedServiceTypeProperties = original.FileServerLinkedServiceTypeProperties
type FileShareDataset = original.FileShareDataset
type FileShareDatasetTypeProperties = original.FileShareDatasetTypeProperties
type FileSystemSink = original.FileSystemSink
type FileSystemSource = original.FileSystemSource
type FilterActivity = original.FilterActivity
type FilterActivityTypeProperties = original.FilterActivityTypeProperties
type ForEachActivity = original.ForEachActivity
type ForEachActivityTypeProperties = original.ForEachActivityTypeProperties
type FtpServerLinkedService = original.FtpServerLinkedService
type FtpServerLinkedServiceTypeProperties = original.FtpServerLinkedServiceTypeProperties
type GetMetadataActivity = original.GetMetadataActivity
type GetMetadataActivityTypeProperties = original.GetMetadataActivityTypeProperties
type GoogleBigQueryLinkedService = original.GoogleBigQueryLinkedService
type GoogleBigQueryLinkedServiceTypeProperties = original.GoogleBigQueryLinkedServiceTypeProperties
type GoogleBigQueryObjectDataset = original.GoogleBigQueryObjectDataset
type GoogleBigQuerySource = original.GoogleBigQuerySource
type GreenplumLinkedService = original.GreenplumLinkedService
type GreenplumLinkedServiceTypeProperties = original.GreenplumLinkedServiceTypeProperties
type GreenplumSource = original.GreenplumSource
type GreenplumTableDataset = original.GreenplumTableDataset
type HBaseLinkedService = original.HBaseLinkedService
type HBaseLinkedServiceTypeProperties = original.HBaseLinkedServiceTypeProperties
type HBaseObjectDataset = original.HBaseObjectDataset
type HBaseSource = original.HBaseSource
type HDInsightHiveActivity = original.HDInsightHiveActivity
type HDInsightHiveActivityTypeProperties = original.HDInsightHiveActivityTypeProperties
type HDInsightLinkedService = original.HDInsightLinkedService
type HDInsightLinkedServiceTypeProperties = original.HDInsightLinkedServiceTypeProperties
type HDInsightMapReduceActivity = original.HDInsightMapReduceActivity
type HDInsightMapReduceActivityTypeProperties = original.HDInsightMapReduceActivityTypeProperties
type HDInsightOnDemandLinkedService = original.HDInsightOnDemandLinkedService
type HDInsightOnDemandLinkedServiceTypeProperties = original.HDInsightOnDemandLinkedServiceTypeProperties
type HDInsightPigActivity = original.HDInsightPigActivity
type HDInsightPigActivityTypeProperties = original.HDInsightPigActivityTypeProperties
type HDInsightSparkActivity = original.HDInsightSparkActivity
type HDInsightSparkActivityTypeProperties = original.HDInsightSparkActivityTypeProperties
type HDInsightStreamingActivity = original.HDInsightStreamingActivity
type HDInsightStreamingActivityTypeProperties = original.HDInsightStreamingActivityTypeProperties
type HTTPDataset = original.HTTPDataset
type HTTPDatasetTypeProperties = original.HTTPDatasetTypeProperties
type HTTPLinkedService = original.HTTPLinkedService
type HTTPLinkedServiceTypeProperties = original.HTTPLinkedServiceTypeProperties
type HTTPSource = original.HTTPSource
type HdfsLinkedService = original.HdfsLinkedService
type HdfsLinkedServiceTypeProperties = original.HdfsLinkedServiceTypeProperties
type HdfsSource = original.HdfsSource
type HiveLinkedService = original.HiveLinkedService
type HiveLinkedServiceTypeProperties = original.HiveLinkedServiceTypeProperties
type HiveObjectDataset = original.HiveObjectDataset
type HiveSource = original.HiveSource
type HubspotLinkedService = original.HubspotLinkedService
type HubspotLinkedServiceTypeProperties = original.HubspotLinkedServiceTypeProperties
type HubspotObjectDataset = original.HubspotObjectDataset
type HubspotSource = original.HubspotSource
type IfConditionActivity = original.IfConditionActivity
type IfConditionActivityTypeProperties = original.IfConditionActivityTypeProperties
type ImpalaLinkedService = original.ImpalaLinkedService
type ImpalaLinkedServiceTypeProperties = original.ImpalaLinkedServiceTypeProperties
type ImpalaObjectDataset = original.ImpalaObjectDataset
type ImpalaSource = original.ImpalaSource
type IntegrationRuntime = original.IntegrationRuntime
type IntegrationRuntimeAuthKeys = original.IntegrationRuntimeAuthKeys
type IntegrationRuntimeComputeProperties = original.IntegrationRuntimeComputeProperties
type IntegrationRuntimeConnectionInfo = original.IntegrationRuntimeConnectionInfo
type IntegrationRuntimeCustomSetupScriptProperties = original.IntegrationRuntimeCustomSetupScriptProperties
type IntegrationRuntimeDataProxyProperties = original.IntegrationRuntimeDataProxyProperties
type IntegrationRuntimeListResponse = original.IntegrationRuntimeListResponse
type IntegrationRuntimeListResponseIterator = original.IntegrationRuntimeListResponseIterator
type IntegrationRuntimeListResponsePage = original.IntegrationRuntimeListResponsePage
type IntegrationRuntimeMonitoringData = original.IntegrationRuntimeMonitoringData
type IntegrationRuntimeNodeIPAddress = original.IntegrationRuntimeNodeIPAddress
type IntegrationRuntimeNodeMonitoringData = original.IntegrationRuntimeNodeMonitoringData
type IntegrationRuntimeNodesClient = original.IntegrationRuntimeNodesClient
type IntegrationRuntimeReference = original.IntegrationRuntimeReference
type IntegrationRuntimeRegenerateKeyParameters = original.IntegrationRuntimeRegenerateKeyParameters
type IntegrationRuntimeRemoveNodeRequest = original.IntegrationRuntimeRemoveNodeRequest
type IntegrationRuntimeResource = original.IntegrationRuntimeResource
type IntegrationRuntimeSsisCatalogInfo = original.IntegrationRuntimeSsisCatalogInfo
type IntegrationRuntimeSsisProperties = original.IntegrationRuntimeSsisProperties
type IntegrationRuntimeStatus = original.IntegrationRuntimeStatus
type IntegrationRuntimeStatusListResponse = original.IntegrationRuntimeStatusListResponse
type IntegrationRuntimeStatusResponse = original.IntegrationRuntimeStatusResponse
type IntegrationRuntimeVNetProperties = original.IntegrationRuntimeVNetProperties
type IntegrationRuntimesClient = original.IntegrationRuntimesClient
type IntegrationRuntimesStartFuture = original.IntegrationRuntimesStartFuture
type IntegrationRuntimesStopFuture = original.IntegrationRuntimesStopFuture
type JSONFormat = original.JSONFormat
type JiraLinkedService = original.JiraLinkedService
type JiraLinkedServiceTypeProperties = original.JiraLinkedServiceTypeProperties
type JiraObjectDataset = original.JiraObjectDataset
type JiraSource = original.JiraSource
type LinkedIntegrationRuntime = original.LinkedIntegrationRuntime
type LinkedIntegrationRuntimeKey = original.LinkedIntegrationRuntimeKey
type LinkedIntegrationRuntimeProperties = original.LinkedIntegrationRuntimeProperties
type LinkedIntegrationRuntimeRbac = original.LinkedIntegrationRuntimeRbac
type LinkedIntegrationRuntimeTypeProperties = original.LinkedIntegrationRuntimeTypeProperties
type LinkedService = original.LinkedService
type LinkedServiceListResponse = original.LinkedServiceListResponse
type LinkedServiceListResponseIterator = original.LinkedServiceListResponseIterator
type LinkedServiceListResponsePage = original.LinkedServiceListResponsePage
type LinkedServiceReference = original.LinkedServiceReference
type LinkedServiceResource = original.LinkedServiceResource
type LinkedServicesClient = original.LinkedServicesClient
type LookupActivity = original.LookupActivity
type LookupActivityTypeProperties = original.LookupActivityTypeProperties
type MagentoLinkedService = original.MagentoLinkedService
type MagentoLinkedServiceTypeProperties = original.MagentoLinkedServiceTypeProperties
type MagentoObjectDataset = original.MagentoObjectDataset
type MagentoSource = original.MagentoSource
type ManagedIntegrationRuntime = original.ManagedIntegrationRuntime
type ManagedIntegrationRuntimeError = original.ManagedIntegrationRuntimeError
type ManagedIntegrationRuntimeNode = original.ManagedIntegrationRuntimeNode
type ManagedIntegrationRuntimeOperationResult = original.ManagedIntegrationRuntimeOperationResult
type ManagedIntegrationRuntimeStatus = original.ManagedIntegrationRuntimeStatus
type ManagedIntegrationRuntimeStatusTypeProperties = original.ManagedIntegrationRuntimeStatusTypeProperties
type ManagedIntegrationRuntimeTypeProperties = original.ManagedIntegrationRuntimeTypeProperties
type MariaDBLinkedService = original.MariaDBLinkedService
type MariaDBLinkedServiceTypeProperties = original.MariaDBLinkedServiceTypeProperties
type MariaDBSource = original.MariaDBSource
type MariaDBTableDataset = original.MariaDBTableDataset
type MarketoLinkedService = original.MarketoLinkedService
type MarketoLinkedServiceTypeProperties = original.MarketoLinkedServiceTypeProperties
type MarketoObjectDataset = original.MarketoObjectDataset
type MarketoSource = original.MarketoSource
type MongoDbCollectionDataset = original.MongoDbCollectionDataset
type MongoDbCollectionDatasetTypeProperties = original.MongoDbCollectionDatasetTypeProperties
type MongoDbLinkedService = original.MongoDbLinkedService
type MongoDbLinkedServiceTypeProperties = original.MongoDbLinkedServiceTypeProperties
type MongoDbSource = original.MongoDbSource
type MultiplePipelineTrigger = original.MultiplePipelineTrigger
type MySQLLinkedService = original.MySQLLinkedService
type MySQLLinkedServiceTypeProperties = original.MySQLLinkedServiceTypeProperties
type NetezzaLinkedService = original.NetezzaLinkedService
type NetezzaLinkedServiceTypeProperties = original.NetezzaLinkedServiceTypeProperties
type NetezzaSource = original.NetezzaSource
type NetezzaTableDataset = original.NetezzaTableDataset
type ODataLinkedService = original.ODataLinkedService
type ODataLinkedServiceTypeProperties = original.ODataLinkedServiceTypeProperties
type ODataResourceDataset = original.ODataResourceDataset
type ODataResourceDatasetTypeProperties = original.ODataResourceDatasetTypeProperties
type OdbcLinkedService = original.OdbcLinkedService
type OdbcLinkedServiceTypeProperties = original.OdbcLinkedServiceTypeProperties
type OdbcSink = original.OdbcSink
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResponse = original.OperationListResponse
type OperationLogSpecification = original.OperationLogSpecification
type OperationMetricAvailability = original.OperationMetricAvailability
type OperationMetricSpecification = original.OperationMetricSpecification
type OperationProperties = original.OperationProperties
type OperationServiceSpecification = original.OperationServiceSpecification
type OperationsClient = original.OperationsClient
type OracleLinkedService = original.OracleLinkedService
type OracleLinkedServiceTypeProperties = original.OracleLinkedServiceTypeProperties
type OracleSink = original.OracleSink
type OracleSource = original.OracleSource
type OracleTableDataset = original.OracleTableDataset
type OracleTableDatasetTypeProperties = original.OracleTableDatasetTypeProperties
type OrcFormat = original.OrcFormat
type ParameterSpecification = original.ParameterSpecification
type ParquetFormat = original.ParquetFormat
type PaypalLinkedService = original.PaypalLinkedService
type PaypalLinkedServiceTypeProperties = original.PaypalLinkedServiceTypeProperties
type PaypalObjectDataset = original.PaypalObjectDataset
type PaypalSource = original.PaypalSource
type PhoenixLinkedService = original.PhoenixLinkedService
type PhoenixLinkedServiceTypeProperties = original.PhoenixLinkedServiceTypeProperties
type PhoenixObjectDataset = original.PhoenixObjectDataset
type PhoenixSource = original.PhoenixSource
type Pipeline = original.Pipeline
type PipelineListResponse = original.PipelineListResponse
type PipelineListResponseIterator = original.PipelineListResponseIterator
type PipelineListResponsePage = original.PipelineListResponsePage
type PipelineReference = original.PipelineReference
type PipelineResource = original.PipelineResource
type PipelineRun = original.PipelineRun
type PipelineRunFilterParameters = original.PipelineRunFilterParameters
type PipelineRunInvokedBy = original.PipelineRunInvokedBy
type PipelineRunQueryFilter = original.PipelineRunQueryFilter
type PipelineRunQueryOrderBy = original.PipelineRunQueryOrderBy
type PipelineRunQueryResponse = original.PipelineRunQueryResponse
type PipelineRunsClient = original.PipelineRunsClient
type PipelinesClient = original.PipelinesClient
type PolybaseSettings = original.PolybaseSettings
type PostgreSQLLinkedService = original.PostgreSQLLinkedService
type PostgreSQLLinkedServiceTypeProperties = original.PostgreSQLLinkedServiceTypeProperties
type PrestoLinkedService = original.PrestoLinkedService
type PrestoLinkedServiceTypeProperties = original.PrestoLinkedServiceTypeProperties
type PrestoObjectDataset = original.PrestoObjectDataset
type PrestoSource = original.PrestoSource
type QuickBooksLinkedService = original.QuickBooksLinkedService
type QuickBooksLinkedServiceTypeProperties = original.QuickBooksLinkedServiceTypeProperties
type QuickBooksObjectDataset = original.QuickBooksObjectDataset
type QuickBooksSource = original.QuickBooksSource
type RecurrenceSchedule = original.RecurrenceSchedule
type RecurrenceScheduleOccurrence = original.RecurrenceScheduleOccurrence
type RedirectIncompatibleRowSettings = original.RedirectIncompatibleRowSettings
type RedshiftUnloadSettings = original.RedshiftUnloadSettings
type RelationalSource = original.RelationalSource
type RelationalTableDataset = original.RelationalTableDataset
type RelationalTableDatasetTypeProperties = original.RelationalTableDatasetTypeProperties
type Resource = original.Resource
type ResponsysLinkedService = original.ResponsysLinkedService
type ResponsysLinkedServiceTypeProperties = original.ResponsysLinkedServiceTypeProperties
type ResponsysObjectDataset = original.ResponsysObjectDataset
type ResponsysSource = original.ResponsysSource
type RetryPolicy = original.RetryPolicy
type SQLDWSink = original.SQLDWSink
type SQLDWSource = original.SQLDWSource
type SQLServerLinkedService = original.SQLServerLinkedService
type SQLServerLinkedServiceTypeProperties = original.SQLServerLinkedServiceTypeProperties
type SQLServerStoredProcedureActivity = original.SQLServerStoredProcedureActivity
type SQLServerStoredProcedureActivityTypeProperties = original.SQLServerStoredProcedureActivityTypeProperties
type SQLServerTableDataset = original.SQLServerTableDataset
type SQLServerTableDatasetTypeProperties = original.SQLServerTableDatasetTypeProperties
type SQLSink = original.SQLSink
type SQLSource = original.SQLSource
type SSISAccessCredential = original.SSISAccessCredential
type SSISExecutionCredential = original.SSISExecutionCredential
type SSISExecutionParameter = original.SSISExecutionParameter
type SSISLogLocation = original.SSISLogLocation
type SSISLogLocationTypeProperties = original.SSISLogLocationTypeProperties
type SSISPackageLocation = original.SSISPackageLocation
type SSISPackageLocationTypeProperties = original.SSISPackageLocationTypeProperties
type SSISPropertyOverride = original.SSISPropertyOverride
type SalesforceLinkedService = original.SalesforceLinkedService
type SalesforceLinkedServiceTypeProperties = original.SalesforceLinkedServiceTypeProperties
type SalesforceMarketingCloudLinkedService = original.SalesforceMarketingCloudLinkedService
type SalesforceMarketingCloudLinkedServiceTypeProperties = original.SalesforceMarketingCloudLinkedServiceTypeProperties
type SalesforceMarketingCloudObjectDataset = original.SalesforceMarketingCloudObjectDataset
type SalesforceMarketingCloudSource = original.SalesforceMarketingCloudSource
type SalesforceObjectDataset = original.SalesforceObjectDataset
type SalesforceObjectDatasetTypeProperties = original.SalesforceObjectDatasetTypeProperties
type SalesforceSink = original.SalesforceSink
type SalesforceSource = original.SalesforceSource
type SapBWLinkedService = original.SapBWLinkedService
type SapBWLinkedServiceTypeProperties = original.SapBWLinkedServiceTypeProperties
type SapCloudForCustomerLinkedService = original.SapCloudForCustomerLinkedService
type SapCloudForCustomerLinkedServiceTypeProperties = original.SapCloudForCustomerLinkedServiceTypeProperties
type SapCloudForCustomerResourceDataset = original.SapCloudForCustomerResourceDataset
type SapCloudForCustomerResourceDatasetTypeProperties = original.SapCloudForCustomerResourceDatasetTypeProperties
type SapCloudForCustomerSink = original.SapCloudForCustomerSink
type SapCloudForCustomerSource = original.SapCloudForCustomerSource
type SapEccLinkedService = original.SapEccLinkedService
type SapEccLinkedServiceTypeProperties = original.SapEccLinkedServiceTypeProperties
type SapEccResourceDataset = original.SapEccResourceDataset
type SapEccResourceDatasetTypeProperties = original.SapEccResourceDatasetTypeProperties
type SapEccSource = original.SapEccSource
type SapHanaLinkedService = original.SapHanaLinkedService
type SapHanaLinkedServiceProperties = original.SapHanaLinkedServiceProperties
type ScheduleTrigger = original.ScheduleTrigger
type ScheduleTriggerRecurrence = original.ScheduleTriggerRecurrence
type ScheduleTriggerTypeProperties = original.ScheduleTriggerTypeProperties
type SecretBase = original.SecretBase
type SecureString = original.SecureString
type SelfHostedIntegrationRuntime = original.SelfHostedIntegrationRuntime
type SelfHostedIntegrationRuntimeNode = original.SelfHostedIntegrationRuntimeNode
type SelfHostedIntegrationRuntimeStatus = original.SelfHostedIntegrationRuntimeStatus
type SelfHostedIntegrationRuntimeStatusTypeProperties = original.SelfHostedIntegrationRuntimeStatusTypeProperties
type ServiceNowLinkedService = original.ServiceNowLinkedService
type ServiceNowLinkedServiceTypeProperties = original.ServiceNowLinkedServiceTypeProperties
type ServiceNowObjectDataset = original.ServiceNowObjectDataset
type ServiceNowSource = original.ServiceNowSource
type SftpServerLinkedService = original.SftpServerLinkedService
type SftpServerLinkedServiceTypeProperties = original.SftpServerLinkedServiceTypeProperties
type ShopifyLinkedService = original.ShopifyLinkedService
type ShopifyLinkedServiceTypeProperties = original.ShopifyLinkedServiceTypeProperties
type ShopifyObjectDataset = original.ShopifyObjectDataset
type ShopifySource = original.ShopifySource
type SparkLinkedService = original.SparkLinkedService
type SparkLinkedServiceTypeProperties = original.SparkLinkedServiceTypeProperties
type SparkObjectDataset = original.SparkObjectDataset
type SparkSource = original.SparkSource
type SquareLinkedService = original.SquareLinkedService
type SquareLinkedServiceTypeProperties = original.SquareLinkedServiceTypeProperties
type SquareObjectDataset = original.SquareObjectDataset
type SquareSource = original.SquareSource
type StagingSettings = original.StagingSettings
type StoredProcedureParameter = original.StoredProcedureParameter
type SubResource = original.SubResource
type SybaseLinkedService = original.SybaseLinkedService
type SybaseLinkedServiceTypeProperties = original.SybaseLinkedServiceTypeProperties
type TeradataLinkedService = original.TeradataLinkedService
type TeradataLinkedServiceTypeProperties = original.TeradataLinkedServiceTypeProperties
type TextFormat = original.TextFormat
type Trigger = original.Trigger
type TriggerListResponse = original.TriggerListResponse
type TriggerListResponseIterator = original.TriggerListResponseIterator
type TriggerListResponsePage = original.TriggerListResponsePage
type TriggerPipelineReference = original.TriggerPipelineReference
type TriggerResource = original.TriggerResource
type TriggerRun = original.TriggerRun
type TriggerRunListResponse = original.TriggerRunListResponse
type TriggerRunListResponseIterator = original.TriggerRunListResponseIterator
type TriggerRunListResponsePage = original.TriggerRunListResponsePage
type TriggersClient = original.TriggersClient
type TriggersStartFuture = original.TriggersStartFuture
type TriggersStopFuture = original.TriggersStopFuture
type TumblingWindowTrigger = original.TumblingWindowTrigger
type TumblingWindowTriggerTypeProperties = original.TumblingWindowTriggerTypeProperties
type UntilActivity = original.UntilActivity
type UntilActivityTypeProperties = original.UntilActivityTypeProperties
type UpdateIntegrationRuntimeNodeRequest = original.UpdateIntegrationRuntimeNodeRequest
type UpdateIntegrationRuntimeRequest = original.UpdateIntegrationRuntimeRequest
type VerticaLinkedService = original.VerticaLinkedService
type VerticaLinkedServiceTypeProperties = original.VerticaLinkedServiceTypeProperties
type VerticaSource = original.VerticaSource
type VerticaTableDataset = original.VerticaTableDataset
type WaitActivity = original.WaitActivity
type WaitActivityTypeProperties = original.WaitActivityTypeProperties
type WebActivity = original.WebActivity
type WebActivityAuthentication = original.WebActivityAuthentication
type WebActivityTypeProperties = original.WebActivityTypeProperties
type WebAnonymousAuthentication = original.WebAnonymousAuthentication
type WebBasicAuthentication = original.WebBasicAuthentication
type WebClientCertificateAuthentication = original.WebClientCertificateAuthentication
type WebLinkedService = original.WebLinkedService
type WebLinkedServiceTypeProperties = original.WebLinkedServiceTypeProperties
type WebSource = original.WebSource
type WebTableDataset = original.WebTableDataset
type WebTableDatasetTypeProperties = original.WebTableDatasetTypeProperties
type XeroLinkedService = original.XeroLinkedService
type XeroLinkedServiceTypeProperties = original.XeroLinkedServiceTypeProperties
type XeroObjectDataset = original.XeroObjectDataset
type XeroSource = original.XeroSource
type ZohoLinkedService = original.ZohoLinkedService
type ZohoLinkedServiceTypeProperties = original.ZohoLinkedServiceTypeProperties
type ZohoObjectDataset = original.ZohoObjectDataset
type ZohoSource = original.ZohoSource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActivityRunsClient(subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClient(subscriptionID)
}
func NewActivityRunsClientWithBaseURI(baseURI string, subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewActivityRunsListResponseIterator(page ActivityRunsListResponsePage) ActivityRunsListResponseIterator {
	return original.NewActivityRunsListResponseIterator(page)
}
func NewActivityRunsListResponsePage(cur ActivityRunsListResponse, getNextPage func(context.Context, ActivityRunsListResponse) (ActivityRunsListResponse, error)) ActivityRunsListResponsePage {
	return original.NewActivityRunsListResponsePage(cur, getNextPage)
}
func NewDatasetListResponseIterator(page DatasetListResponsePage) DatasetListResponseIterator {
	return original.NewDatasetListResponseIterator(page)
}
func NewDatasetListResponsePage(cur DatasetListResponse, getNextPage func(context.Context, DatasetListResponse) (DatasetListResponse, error)) DatasetListResponsePage {
	return original.NewDatasetListResponsePage(cur, getNextPage)
}
func NewDatasetsClient(subscriptionID string) DatasetsClient {
	return original.NewDatasetsClient(subscriptionID)
}
func NewDatasetsClientWithBaseURI(baseURI string, subscriptionID string) DatasetsClient {
	return original.NewDatasetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoriesClient(subscriptionID string) FactoriesClient {
	return original.NewFactoriesClient(subscriptionID)
}
func NewFactoriesClientWithBaseURI(baseURI string, subscriptionID string) FactoriesClient {
	return original.NewFactoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoryListResponseIterator(page FactoryListResponsePage) FactoryListResponseIterator {
	return original.NewFactoryListResponseIterator(page)
}
func NewFactoryListResponsePage(cur FactoryListResponse, getNextPage func(context.Context, FactoryListResponse) (FactoryListResponse, error)) FactoryListResponsePage {
	return original.NewFactoryListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimeListResponseIterator(page IntegrationRuntimeListResponsePage) IntegrationRuntimeListResponseIterator {
	return original.NewIntegrationRuntimeListResponseIterator(page)
}
func NewIntegrationRuntimeListResponsePage(cur IntegrationRuntimeListResponse, getNextPage func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)) IntegrationRuntimeListResponsePage {
	return original.NewIntegrationRuntimeListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimeNodesClient(subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClient(subscriptionID)
}
func NewIntegrationRuntimeNodesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimesClient(subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClient(subscriptionID)
}
func NewIntegrationRuntimesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLinkedServiceListResponseIterator(page LinkedServiceListResponsePage) LinkedServiceListResponseIterator {
	return original.NewLinkedServiceListResponseIterator(page)
}
func NewLinkedServiceListResponsePage(cur LinkedServiceListResponse, getNextPage func(context.Context, LinkedServiceListResponse) (LinkedServiceListResponse, error)) LinkedServiceListResponsePage {
	return original.NewLinkedServiceListResponsePage(cur, getNextPage)
}
func NewLinkedServicesClient(subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClient(subscriptionID)
}
func NewLinkedServicesClientWithBaseURI(baseURI string, subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelineListResponseIterator(page PipelineListResponsePage) PipelineListResponseIterator {
	return original.NewPipelineListResponseIterator(page)
}
func NewPipelineListResponsePage(cur PipelineListResponse, getNextPage func(context.Context, PipelineListResponse) (PipelineListResponse, error)) PipelineListResponsePage {
	return original.NewPipelineListResponsePage(cur, getNextPage)
}
func NewPipelineRunsClient(subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClient(subscriptionID)
}
func NewPipelineRunsClientWithBaseURI(baseURI string, subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelinesClient(subscriptionID string) PipelinesClient {
	return original.NewPipelinesClient(subscriptionID)
}
func NewPipelinesClientWithBaseURI(baseURI string, subscriptionID string) PipelinesClient {
	return original.NewPipelinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggerListResponseIterator(page TriggerListResponsePage) TriggerListResponseIterator {
	return original.NewTriggerListResponseIterator(page)
}
func NewTriggerListResponsePage(cur TriggerListResponse, getNextPage func(context.Context, TriggerListResponse) (TriggerListResponse, error)) TriggerListResponsePage {
	return original.NewTriggerListResponsePage(cur, getNextPage)
}
func NewTriggerRunListResponseIterator(page TriggerRunListResponsePage) TriggerRunListResponseIterator {
	return original.NewTriggerRunListResponseIterator(page)
}
func NewTriggerRunListResponsePage(cur TriggerRunListResponse, getNextPage func(context.Context, TriggerRunListResponse) (TriggerRunListResponse, error)) TriggerRunListResponsePage {
	return original.NewTriggerRunListResponsePage(cur, getNextPage)
}
func NewTriggersClient(subscriptionID string) TriggersClient {
	return original.NewTriggersClient(subscriptionID)
}
func NewTriggersClientWithBaseURI(baseURI string, subscriptionID string) TriggersClient {
	return original.NewTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return original.PossibleAuthorizationTypeValues()
}
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return original.PossibleBlobEventTypesValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return original.PossibleDaysOfWeekValues()
}
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return original.PossibleDb2AuthenticationTypeValues()
}
func PossibleDependencyConditionValues() []DependencyCondition {
	return original.PossibleDependencyConditionValues()
}
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return original.PossibleFtpAuthenticationTypeValues()
}
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return original.PossibleGoogleBigQueryAuthenticationTypeValues()
}
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return original.PossibleHBaseAuthenticationTypeValues()
}
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return original.PossibleHDInsightActivityDebugInfoOptionValues()
}
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return original.PossibleHTTPAuthenticationTypeValues()
}
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return original.PossibleHiveAuthenticationTypeValues()
}
func PossibleHiveServerTypeValues() []HiveServerType {
	return original.PossibleHiveServerTypeValues()
}
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return original.PossibleHiveThriftTransportProtocolValues()
}
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return original.PossibleImpalaAuthenticationTypeValues()
}
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return original.PossibleIntegrationRuntimeAuthKeyNameValues()
}
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return original.PossibleIntegrationRuntimeAutoUpdateValues()
}
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return original.PossibleIntegrationRuntimeEditionValues()
}
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return original.PossibleIntegrationRuntimeEntityReferenceTypeValues()
}
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return original.PossibleIntegrationRuntimeInternalChannelEncryptionModeValues()
}
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return original.PossibleIntegrationRuntimeLicenseTypeValues()
}
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return original.PossibleIntegrationRuntimeStateValues()
}
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return original.PossibleIntegrationRuntimeTypeValues()
}
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return original.PossibleIntegrationRuntimeUpdateResultValues()
}
func PossibleJSONFormatFilePatternValues() []JSONFormatFilePattern {
	return original.PossibleJSONFormatFilePatternValues()
}
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return original.PossibleManagedIntegrationRuntimeNodeStatusValues()
}
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return original.PossibleMongoDbAuthenticationTypeValues()
}
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return original.PossibleODataAuthenticationTypeValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return original.PossiblePhoenixAuthenticationTypeValues()
}
func PossiblePipelineRunQueryFilterOperandValues() []PipelineRunQueryFilterOperand {
	return original.PossiblePipelineRunQueryFilterOperandValues()
}
func PossiblePipelineRunQueryFilterOperatorValues() []PipelineRunQueryFilterOperator {
	return original.PossiblePipelineRunQueryFilterOperatorValues()
}
func PossiblePipelineRunQueryOrderByFieldValues() []PipelineRunQueryOrderByField {
	return original.PossiblePipelineRunQueryOrderByFieldValues()
}
func PossiblePipelineRunQueryOrderValues() []PipelineRunQueryOrder {
	return original.PossiblePipelineRunQueryOrderValues()
}
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return original.PossiblePrestoAuthenticationTypeValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return original.PossibleSapHanaAuthenticationTypeValues()
}
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return original.PossibleSelfHostedIntegrationRuntimeNodeStatusValues()
}
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return original.PossibleServiceNowAuthenticationTypeValues()
}
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return original.PossibleSftpAuthenticationTypeValues()
}
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return original.PossibleSparkAuthenticationTypeValues()
}
func PossibleSparkServerTypeValues() []SparkServerType {
	return original.PossibleSparkServerTypeValues()
}
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return original.PossibleSparkThriftTransportProtocolValues()
}
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return original.PossibleSsisPackageLocationTypeValues()
}
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return original.PossibleSybaseAuthenticationTypeValues()
}
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return original.PossibleTeradataAuthenticationTypeValues()
}
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return original.PossibleTriggerRunStatusValues()
}
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return original.PossibleTriggerRuntimeStateValues()
}
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return original.PossibleTumblingWindowFrequencyValues()
}
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return original.PossibleTypeBasicActivityValues()
}
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return original.PossibleTypeBasicCopySinkValues()
}
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return original.PossibleTypeBasicCopySourceValues()
}
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return original.PossibleTypeBasicDatasetCompressionValues()
}
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return original.PossibleTypeBasicDatasetStorageFormatValues()
}
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return original.PossibleTypeBasicDatasetValues()
}
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return original.PossibleTypeBasicIntegrationRuntimeStatusValues()
}
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return original.PossibleTypeBasicIntegrationRuntimeValues()
}
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return original.PossibleTypeBasicLinkedServiceValues()
}
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return original.PossibleTypeBasicTriggerValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return original.PossibleWebActivityMethodValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
