//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package hdinsight

import original "github.com/Azure/azure-sdk-for-go/services/preview/hdinsight/2018-11-01-preview/hdinsight"

type ApplicationState = original.ApplicationState

const (
	ACCEPTED  ApplicationState = original.ACCEPTED
	FAILED    ApplicationState = original.FAILED
	FINISHED  ApplicationState = original.FINISHED
	FINISHING ApplicationState = original.FINISHING
	KILLED    ApplicationState = original.KILLED
	NEW       ApplicationState = original.NEW
	NEWSAVING ApplicationState = original.NEWSAVING
	RUNNING   ApplicationState = original.RUNNING
	SUBMITTED ApplicationState = original.SUBMITTED
)

type JobState = original.JobState

const (
	Busy         JobState = original.Busy
	Dead         JobState = original.Dead
	Error        JobState = original.Error
	Idle         JobState = original.Idle
	Killed       JobState = original.Killed
	NotStarted   JobState = original.NotStarted
	Recovering   JobState = original.Recovering
	Running      JobState = original.Running
	ShuttingDown JobState = original.ShuttingDown
	Starting     JobState = original.Starting
	Success      JobState = original.Success
)

type SessionJobKind = original.SessionJobKind

const (
	Pyspark SessionJobKind = original.Pyspark
	Spark   SessionJobKind = original.Spark
	Sparkr  SessionJobKind = original.Sparkr
	SQL     SessionJobKind = original.SQL
)

type StatementExecutionStatus = original.StatementExecutionStatus

const (
	StatementExecutionStatusAbort StatementExecutionStatus = original.StatementExecutionStatusAbort
	StatementExecutionStatusError StatementExecutionStatus = original.StatementExecutionStatusError
	StatementExecutionStatusOk    StatementExecutionStatus = original.StatementExecutionStatusOk
)

type StatementState = original.StatementState

const (
	StatementStateAvailable  StatementState = original.StatementStateAvailable
	StatementStateCancelled  StatementState = original.StatementStateCancelled
	StatementStateCancelling StatementState = original.StatementStateCancelling
	StatementStateError      StatementState = original.StatementStateError
	StatementStateRunning    StatementState = original.StatementStateRunning
	StatementStateWaiting    StatementState = original.StatementStateWaiting
)

type AppState = original.AppState
type BaseClient = original.BaseClient
type JobClient = original.JobClient
type JobDetailRootJSONObject = original.JobDetailRootJSONObject
type JobID = original.JobID
type JobListJSONObject = original.JobListJSONObject
type JobOperationsErrorResponse = original.JobOperationsErrorResponse
type JobSubmissionJSONResponse = original.JobSubmissionJSONResponse
type ListJobListJSONObject = original.ListJobListJSONObject
type Profile = original.Profile
type SparkBatchJob = original.SparkBatchJob
type SparkBatchJobCollection = original.SparkBatchJobCollection
type SparkBatchJobRequest = original.SparkBatchJobRequest
type SparkJobDeletedResult = original.SparkJobDeletedResult
type SparkJobLog = original.SparkJobLog
type SparkJobState = original.SparkJobState
type SparkSessionCollection = original.SparkSessionCollection
type SparkSessionJob = original.SparkSessionJob
type SparkSessionJobRequest = original.SparkSessionJobRequest
type SparkStatement = original.SparkStatement
type SparkStatementCancellationResult = original.SparkStatementCancellationResult
type SparkStatementCollection = original.SparkStatementCollection
type SparkStatementOutput = original.SparkStatementOutput
type SparkStatementRequest = original.SparkStatementRequest
type Status = original.Status
type Userargs = original.Userargs

func New(endpoint string, userName string) BaseClient {
	return original.New(endpoint, userName)
}
func NewJobClient(endpoint string, userName string) JobClient {
	return original.NewJobClient(endpoint, userName)
}
func NewWithoutDefaults(endpoint string, userName string) BaseClient {
	return original.NewWithoutDefaults(endpoint, userName)
}
func PossibleApplicationStateValues() []ApplicationState {
	return original.PossibleApplicationStateValues()
}
func PossibleJobStateValues() []JobState {
	return original.PossibleJobStateValues()
}
func PossibleSessionJobKindValues() []SessionJobKind {
	return original.PossibleSessionJobKindValues()
}
func PossibleStatementExecutionStatusValues() []StatementExecutionStatus {
	return original.PossibleStatementExecutionStatusValues()
}
func PossibleStatementStateValues() []StatementState {
	return original.PossibleStatementStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
