//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package securityinsight

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/securityinsight/mgmt/2019-01-01-preview/securityinsight"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionType = original.ActionType

const (
	ActionTypeAutomationRuleAction ActionType = original.ActionTypeAutomationRuleAction
	ActionTypeModifyProperties     ActionType = original.ActionTypeModifyProperties
	ActionTypeRunPlaybook          ActionType = original.ActionTypeRunPlaybook
)

type AlertRuleKind = original.AlertRuleKind

const (
	AlertRuleKindFusion                            AlertRuleKind = original.AlertRuleKindFusion
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = original.AlertRuleKindMicrosoftSecurityIncidentCreation
	AlertRuleKindMLBehaviorAnalytics               AlertRuleKind = original.AlertRuleKindMLBehaviorAnalytics
	AlertRuleKindScheduled                         AlertRuleKind = original.AlertRuleKindScheduled
	AlertRuleKindThreatIntelligence                AlertRuleKind = original.AlertRuleKindThreatIntelligence
)

type AlertSeverity = original.AlertSeverity

const (
	AlertSeverityHigh          AlertSeverity = original.AlertSeverityHigh
	AlertSeverityInformational AlertSeverity = original.AlertSeverityInformational
	AlertSeverityLow           AlertSeverity = original.AlertSeverityLow
	AlertSeverityMedium        AlertSeverity = original.AlertSeverityMedium
)

type AlertStatus = original.AlertStatus

const (
	AlertStatusDismissed  AlertStatus = original.AlertStatusDismissed
	AlertStatusInProgress AlertStatus = original.AlertStatusInProgress
	AlertStatusNew        AlertStatus = original.AlertStatusNew
	AlertStatusResolved   AlertStatus = original.AlertStatusResolved
	AlertStatusUnknown    AlertStatus = original.AlertStatusUnknown
)

type AntispamMailDirection = original.AntispamMailDirection

const (
	AntispamMailDirectionInbound  AntispamMailDirection = original.AntispamMailDirectionInbound
	AntispamMailDirectionIntraorg AntispamMailDirection = original.AntispamMailDirectionIntraorg
	AntispamMailDirectionOutbound AntispamMailDirection = original.AntispamMailDirectionOutbound
	AntispamMailDirectionUnknown  AntispamMailDirection = original.AntispamMailDirectionUnknown
)

type AttackTactic = original.AttackTactic

const (
	AttackTacticCollection          AttackTactic = original.AttackTacticCollection
	AttackTacticCommandAndControl   AttackTactic = original.AttackTacticCommandAndControl
	AttackTacticCredentialAccess    AttackTactic = original.AttackTacticCredentialAccess
	AttackTacticDefenseEvasion      AttackTactic = original.AttackTacticDefenseEvasion
	AttackTacticDiscovery           AttackTactic = original.AttackTacticDiscovery
	AttackTacticExecution           AttackTactic = original.AttackTacticExecution
	AttackTacticExfiltration        AttackTactic = original.AttackTacticExfiltration
	AttackTacticImpact              AttackTactic = original.AttackTacticImpact
	AttackTacticInitialAccess       AttackTactic = original.AttackTacticInitialAccess
	AttackTacticLateralMovement     AttackTactic = original.AttackTacticLateralMovement
	AttackTacticPersistence         AttackTactic = original.AttackTacticPersistence
	AttackTacticPreAttack           AttackTactic = original.AttackTacticPreAttack
	AttackTacticPrivilegeEscalation AttackTactic = original.AttackTacticPrivilegeEscalation
)

type AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperator

const (
	AutomationRulePropertyConditionSupportedOperatorContains      AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorContains
	AutomationRulePropertyConditionSupportedOperatorEndsWith      AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorEndsWith
	AutomationRulePropertyConditionSupportedOperatorEquals        AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorEquals
	AutomationRulePropertyConditionSupportedOperatorNotContains   AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorNotContains
	AutomationRulePropertyConditionSupportedOperatorNotEndsWith   AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorNotEndsWith
	AutomationRulePropertyConditionSupportedOperatorNotEquals     AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorNotEquals
	AutomationRulePropertyConditionSupportedOperatorNotStartsWith AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorNotStartsWith
	AutomationRulePropertyConditionSupportedOperatorStartsWith    AutomationRulePropertyConditionSupportedOperator = original.AutomationRulePropertyConditionSupportedOperatorStartsWith
)

type AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedProperty

const (
	AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID             AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID
	AutomationRulePropertyConditionSupportedPropertyAccountAadUserID               AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountAadUserID
	AutomationRulePropertyConditionSupportedPropertyAccountName                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountName
	AutomationRulePropertyConditionSupportedPropertyAccountNTDomain                AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountNTDomain
	AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID              AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID
	AutomationRulePropertyConditionSupportedPropertyAccountPUID                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountPUID
	AutomationRulePropertyConditionSupportedPropertyAccountSid                     AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountSid
	AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix               AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix
	AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID        AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID
	AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID          AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName        AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName
	AutomationRulePropertyConditionSupportedPropertyDNSDomainName                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyDNSDomainName
	AutomationRulePropertyConditionSupportedPropertyFileDirectory                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyFileDirectory
	AutomationRulePropertyConditionSupportedPropertyFileHashValue                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyFileHashValue
	AutomationRulePropertyConditionSupportedPropertyFileName                       AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyFileName
	AutomationRulePropertyConditionSupportedPropertyHostAzureID                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyHostAzureID
	AutomationRulePropertyConditionSupportedPropertyHostName                       AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyHostName
	AutomationRulePropertyConditionSupportedPropertyHostNetBiosName                AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyHostNetBiosName
	AutomationRulePropertyConditionSupportedPropertyHostNTDomain                   AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyHostNTDomain
	AutomationRulePropertyConditionSupportedPropertyHostOSVersion                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyHostOSVersion
	AutomationRulePropertyConditionSupportedPropertyIncidentDescription            AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentDescription
	AutomationRulePropertyConditionSupportedPropertyIncidentProviderName           AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentProviderName
	AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds
	AutomationRulePropertyConditionSupportedPropertyIncidentSeverity               AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentSeverity
	AutomationRulePropertyConditionSupportedPropertyIncidentStatus                 AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentStatus
	AutomationRulePropertyConditionSupportedPropertyIncidentTactics                AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentTactics
	AutomationRulePropertyConditionSupportedPropertyIncidentTitle                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIncidentTitle
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceID                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceID
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel                 AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceName                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceName
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem       AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceType                  AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceType
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor                AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor
	AutomationRulePropertyConditionSupportedPropertyIPAddress                      AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyIPAddress
	AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName             AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName
	AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress          AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress
	AutomationRulePropertyConditionSupportedPropertyMailboxUPN                     AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailboxUPN
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction      AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation
	AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender            AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender            AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient           AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient
	AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP            AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP
	AutomationRulePropertyConditionSupportedPropertyMailMessageSubject             AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMailMessageSubject
	AutomationRulePropertyConditionSupportedPropertyMalwareCategory                AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMalwareCategory
	AutomationRulePropertyConditionSupportedPropertyMalwareName                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyMalwareName
	AutomationRulePropertyConditionSupportedPropertyProcessCommandLine             AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyProcessCommandLine
	AutomationRulePropertyConditionSupportedPropertyProcessID                      AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyProcessID
	AutomationRulePropertyConditionSupportedPropertyRegistryKey                    AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyRegistryKey
	AutomationRulePropertyConditionSupportedPropertyRegistryValueData              AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyRegistryValueData
	AutomationRulePropertyConditionSupportedPropertyURL                            AutomationRulePropertyConditionSupportedProperty = original.AutomationRulePropertyConditionSupportedPropertyURL
)

type CaseSeverity = original.CaseSeverity

const (
	CaseSeverityCritical      CaseSeverity = original.CaseSeverityCritical
	CaseSeverityHigh          CaseSeverity = original.CaseSeverityHigh
	CaseSeverityInformational CaseSeverity = original.CaseSeverityInformational
	CaseSeverityLow           CaseSeverity = original.CaseSeverityLow
	CaseSeverityMedium        CaseSeverity = original.CaseSeverityMedium
)

type CaseStatus = original.CaseStatus

const (
	CaseStatusClosed     CaseStatus = original.CaseStatusClosed
	CaseStatusDraft      CaseStatus = original.CaseStatusDraft
	CaseStatusInProgress CaseStatus = original.CaseStatusInProgress
	CaseStatusNew        CaseStatus = original.CaseStatusNew
)

type CloseReason = original.CloseReason

const (
	CloseReasonDismissed     CloseReason = original.CloseReasonDismissed
	CloseReasonFalsePositive CloseReason = original.CloseReasonFalsePositive
	CloseReasonOther         CloseReason = original.CloseReasonOther
	CloseReasonResolved      CloseReason = original.CloseReasonResolved
	CloseReasonTruePositive  CloseReason = original.CloseReasonTruePositive
)

type ConditionType = original.ConditionType

const (
	ConditionTypeAutomationRuleCondition ConditionType = original.ConditionTypeAutomationRuleCondition
	ConditionTypeProperty                ConditionType = original.ConditionTypeProperty
)

type ConfidenceLevel = original.ConfidenceLevel

const (
	ConfidenceLevelHigh    ConfidenceLevel = original.ConfidenceLevelHigh
	ConfidenceLevelLow     ConfidenceLevel = original.ConfidenceLevelLow
	ConfidenceLevelUnknown ConfidenceLevel = original.ConfidenceLevelUnknown
)

type ConfidenceScoreStatus = original.ConfidenceScoreStatus

const (
	ConfidenceScoreStatusFinal         ConfidenceScoreStatus = original.ConfidenceScoreStatusFinal
	ConfidenceScoreStatusInProcess     ConfidenceScoreStatus = original.ConfidenceScoreStatusInProcess
	ConfidenceScoreStatusNotApplicable ConfidenceScoreStatus = original.ConfidenceScoreStatusNotApplicable
	ConfidenceScoreStatusNotFinal      ConfidenceScoreStatus = original.ConfidenceScoreStatusNotFinal
)

type DataConnectorAuthorizationState = original.DataConnectorAuthorizationState

const (
	DataConnectorAuthorizationStateInvalid DataConnectorAuthorizationState = original.DataConnectorAuthorizationStateInvalid
	DataConnectorAuthorizationStateValid   DataConnectorAuthorizationState = original.DataConnectorAuthorizationStateValid
)

type DataConnectorKind = original.DataConnectorKind

const (
	DataConnectorKindAmazonWebServicesCloudTrail               DataConnectorKind = original.DataConnectorKindAmazonWebServicesCloudTrail
	DataConnectorKindAzureActiveDirectory                      DataConnectorKind = original.DataConnectorKindAzureActiveDirectory
	DataConnectorKindAzureAdvancedThreatProtection             DataConnectorKind = original.DataConnectorKindAzureAdvancedThreatProtection
	DataConnectorKindAzureSecurityCenter                       DataConnectorKind = original.DataConnectorKindAzureSecurityCenter
	DataConnectorKindDynamics365                               DataConnectorKind = original.DataConnectorKindDynamics365
	DataConnectorKindMicrosoftCloudAppSecurity                 DataConnectorKind = original.DataConnectorKindMicrosoftCloudAppSecurity
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = original.DataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	DataConnectorKindMicrosoftThreatIntelligence               DataConnectorKind = original.DataConnectorKindMicrosoftThreatIntelligence
	DataConnectorKindMicrosoftThreatProtection                 DataConnectorKind = original.DataConnectorKindMicrosoftThreatProtection
	DataConnectorKindOffice365                                 DataConnectorKind = original.DataConnectorKindOffice365
	DataConnectorKindOfficeATP                                 DataConnectorKind = original.DataConnectorKindOfficeATP
	DataConnectorKindThreatIntelligence                        DataConnectorKind = original.DataConnectorKindThreatIntelligence
	DataConnectorKindThreatIntelligenceTaxii                   DataConnectorKind = original.DataConnectorKindThreatIntelligenceTaxii
)

type DataConnectorLicenseState = original.DataConnectorLicenseState

const (
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = original.DataConnectorLicenseStateInvalid
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = original.DataConnectorLicenseStateUnknown
	DataConnectorLicenseStateValid   DataConnectorLicenseState = original.DataConnectorLicenseStateValid
)

type DataTypeState = original.DataTypeState

const (
	DataTypeStateDisabled DataTypeState = original.DataTypeStateDisabled
	DataTypeStateEnabled  DataTypeState = original.DataTypeStateEnabled
)

type DeliveryAction = original.DeliveryAction

const (
	DeliveryActionBlocked         DeliveryAction = original.DeliveryActionBlocked
	DeliveryActionDelivered       DeliveryAction = original.DeliveryActionDelivered
	DeliveryActionDeliveredAsSpam DeliveryAction = original.DeliveryActionDeliveredAsSpam
	DeliveryActionReplaced        DeliveryAction = original.DeliveryActionReplaced
	DeliveryActionUnknown         DeliveryAction = original.DeliveryActionUnknown
)

type DeliveryLocation = original.DeliveryLocation

const (
	DeliveryLocationDeletedFolder DeliveryLocation = original.DeliveryLocationDeletedFolder
	DeliveryLocationDropped       DeliveryLocation = original.DeliveryLocationDropped
	DeliveryLocationExternal      DeliveryLocation = original.DeliveryLocationExternal
	DeliveryLocationFailed        DeliveryLocation = original.DeliveryLocationFailed
	DeliveryLocationForwarded     DeliveryLocation = original.DeliveryLocationForwarded
	DeliveryLocationInbox         DeliveryLocation = original.DeliveryLocationInbox
	DeliveryLocationJunkFolder    DeliveryLocation = original.DeliveryLocationJunkFolder
	DeliveryLocationQuarantine    DeliveryLocation = original.DeliveryLocationQuarantine
	DeliveryLocationUnknown       DeliveryLocation = original.DeliveryLocationUnknown
)

type ElevationToken = original.ElevationToken

const (
	ElevationTokenDefault ElevationToken = original.ElevationTokenDefault
	ElevationTokenFull    ElevationToken = original.ElevationTokenFull
	ElevationTokenLimited ElevationToken = original.ElevationTokenLimited
)

type EntitiesMatchingMethod = original.EntitiesMatchingMethod

const (
	EntitiesMatchingMethodAll    EntitiesMatchingMethod = original.EntitiesMatchingMethodAll
	EntitiesMatchingMethodCustom EntitiesMatchingMethod = original.EntitiesMatchingMethodCustom
	EntitiesMatchingMethodNone   EntitiesMatchingMethod = original.EntitiesMatchingMethodNone
)

type EntityKind = original.EntityKind

const (
	EntityKindAccount          EntityKind = original.EntityKindAccount
	EntityKindAzureResource    EntityKind = original.EntityKindAzureResource
	EntityKindBookmark         EntityKind = original.EntityKindBookmark
	EntityKindCloudApplication EntityKind = original.EntityKindCloudApplication
	EntityKindDNSResolution    EntityKind = original.EntityKindDNSResolution
	EntityKindFile             EntityKind = original.EntityKindFile
	EntityKindFileHash         EntityKind = original.EntityKindFileHash
	EntityKindHost             EntityKind = original.EntityKindHost
	EntityKindIoTDevice        EntityKind = original.EntityKindIoTDevice
	EntityKindIP               EntityKind = original.EntityKindIP
	EntityKindMailbox          EntityKind = original.EntityKindMailbox
	EntityKindMailCluster      EntityKind = original.EntityKindMailCluster
	EntityKindMailMessage      EntityKind = original.EntityKindMailMessage
	EntityKindMalware          EntityKind = original.EntityKindMalware
	EntityKindProcess          EntityKind = original.EntityKindProcess
	EntityKindRegistryKey      EntityKind = original.EntityKindRegistryKey
	EntityKindRegistryValue    EntityKind = original.EntityKindRegistryValue
	EntityKindSecurityAlert    EntityKind = original.EntityKindSecurityAlert
	EntityKindSecurityGroup    EntityKind = original.EntityKindSecurityGroup
	EntityKindSubmissionMail   EntityKind = original.EntityKindSubmissionMail
	EntityKindURL              EntityKind = original.EntityKindURL
)

type EntityQueryKind = original.EntityQueryKind

const (
	EntityQueryKindExpansion EntityQueryKind = original.EntityQueryKindExpansion
	EntityQueryKindInsight   EntityQueryKind = original.EntityQueryKindInsight
)

type EntityTimelineKind = original.EntityTimelineKind

const (
	EntityTimelineKindActivity      EntityTimelineKind = original.EntityTimelineKindActivity
	EntityTimelineKindBookmark      EntityTimelineKind = original.EntityTimelineKindBookmark
	EntityTimelineKindSecurityAlert EntityTimelineKind = original.EntityTimelineKindSecurityAlert
)

type EntityType = original.EntityType

const (
	EntityTypeAccount          EntityType = original.EntityTypeAccount
	EntityTypeAzureResource    EntityType = original.EntityTypeAzureResource
	EntityTypeCloudApplication EntityType = original.EntityTypeCloudApplication
	EntityTypeDNS              EntityType = original.EntityTypeDNS
	EntityTypeFile             EntityType = original.EntityTypeFile
	EntityTypeFileHash         EntityType = original.EntityTypeFileHash
	EntityTypeHost             EntityType = original.EntityTypeHost
	EntityTypeHuntingBookmark  EntityType = original.EntityTypeHuntingBookmark
	EntityTypeIoTDevice        EntityType = original.EntityTypeIoTDevice
	EntityTypeIP               EntityType = original.EntityTypeIP
	EntityTypeMailbox          EntityType = original.EntityTypeMailbox
	EntityTypeMailCluster      EntityType = original.EntityTypeMailCluster
	EntityTypeMailMessage      EntityType = original.EntityTypeMailMessage
	EntityTypeMalware          EntityType = original.EntityTypeMalware
	EntityTypeProcess          EntityType = original.EntityTypeProcess
	EntityTypeRegistryKey      EntityType = original.EntityTypeRegistryKey
	EntityTypeRegistryValue    EntityType = original.EntityTypeRegistryValue
	EntityTypeSecurityAlert    EntityType = original.EntityTypeSecurityAlert
	EntityTypeSecurityGroup    EntityType = original.EntityTypeSecurityGroup
	EntityTypeSubmissionMail   EntityType = original.EntityTypeSubmissionMail
	EntityTypeURL              EntityType = original.EntityTypeURL
)

type EventGroupingAggregationKind = original.EventGroupingAggregationKind

const (
	EventGroupingAggregationKindAlertPerResult EventGroupingAggregationKind = original.EventGroupingAggregationKindAlertPerResult
	EventGroupingAggregationKindSingleAlert    EventGroupingAggregationKind = original.EventGroupingAggregationKindSingleAlert
)

type FileHashAlgorithm = original.FileHashAlgorithm

const (
	FileHashAlgorithmMD5      FileHashAlgorithm = original.FileHashAlgorithmMD5
	FileHashAlgorithmSHA1     FileHashAlgorithm = original.FileHashAlgorithmSHA1
	FileHashAlgorithmSHA256   FileHashAlgorithm = original.FileHashAlgorithmSHA256
	FileHashAlgorithmSHA256AC FileHashAlgorithm = original.FileHashAlgorithmSHA256AC
	FileHashAlgorithmUnknown  FileHashAlgorithm = original.FileHashAlgorithmUnknown
)

type GroupingEntityType = original.GroupingEntityType

const (
	GroupingEntityTypeAccount  GroupingEntityType = original.GroupingEntityTypeAccount
	GroupingEntityTypeFileHash GroupingEntityType = original.GroupingEntityTypeFileHash
	GroupingEntityTypeHost     GroupingEntityType = original.GroupingEntityTypeHost
	GroupingEntityTypeIP       GroupingEntityType = original.GroupingEntityTypeIP
	GroupingEntityTypeURL      GroupingEntityType = original.GroupingEntityTypeURL
)

type IncidentClassification = original.IncidentClassification

const (
	IncidentClassificationBenignPositive IncidentClassification = original.IncidentClassificationBenignPositive
	IncidentClassificationFalsePositive  IncidentClassification = original.IncidentClassificationFalsePositive
	IncidentClassificationTruePositive   IncidentClassification = original.IncidentClassificationTruePositive
	IncidentClassificationUndetermined   IncidentClassification = original.IncidentClassificationUndetermined
)

type IncidentClassificationReason = original.IncidentClassificationReason

const (
	IncidentClassificationReasonInaccurateData        IncidentClassificationReason = original.IncidentClassificationReasonInaccurateData
	IncidentClassificationReasonIncorrectAlertLogic   IncidentClassificationReason = original.IncidentClassificationReasonIncorrectAlertLogic
	IncidentClassificationReasonSuspiciousActivity    IncidentClassificationReason = original.IncidentClassificationReasonSuspiciousActivity
	IncidentClassificationReasonSuspiciousButExpected IncidentClassificationReason = original.IncidentClassificationReasonSuspiciousButExpected
)

type IncidentLabelType = original.IncidentLabelType

const (
	IncidentLabelTypeSystem IncidentLabelType = original.IncidentLabelTypeSystem
	IncidentLabelTypeUser   IncidentLabelType = original.IncidentLabelTypeUser
)

type IncidentSeverity = original.IncidentSeverity

const (
	IncidentSeverityHigh          IncidentSeverity = original.IncidentSeverityHigh
	IncidentSeverityInformational IncidentSeverity = original.IncidentSeverityInformational
	IncidentSeverityLow           IncidentSeverity = original.IncidentSeverityLow
	IncidentSeverityMedium        IncidentSeverity = original.IncidentSeverityMedium
)

type IncidentStatus = original.IncidentStatus

const (
	IncidentStatusActive IncidentStatus = original.IncidentStatusActive
	IncidentStatusClosed IncidentStatus = original.IncidentStatusClosed
	IncidentStatusNew    IncidentStatus = original.IncidentStatusNew
)

type KillChainIntent = original.KillChainIntent

const (
	KillChainIntentCollection          KillChainIntent = original.KillChainIntentCollection
	KillChainIntentCommandAndControl   KillChainIntent = original.KillChainIntentCommandAndControl
	KillChainIntentCredentialAccess    KillChainIntent = original.KillChainIntentCredentialAccess
	KillChainIntentDefenseEvasion      KillChainIntent = original.KillChainIntentDefenseEvasion
	KillChainIntentDiscovery           KillChainIntent = original.KillChainIntentDiscovery
	KillChainIntentExecution           KillChainIntent = original.KillChainIntentExecution
	KillChainIntentExfiltration        KillChainIntent = original.KillChainIntentExfiltration
	KillChainIntentExploitation        KillChainIntent = original.KillChainIntentExploitation
	KillChainIntentImpact              KillChainIntent = original.KillChainIntentImpact
	KillChainIntentLateralMovement     KillChainIntent = original.KillChainIntentLateralMovement
	KillChainIntentPersistence         KillChainIntent = original.KillChainIntentPersistence
	KillChainIntentPrivilegeEscalation KillChainIntent = original.KillChainIntentPrivilegeEscalation
	KillChainIntentProbing             KillChainIntent = original.KillChainIntentProbing
	KillChainIntentUnknown             KillChainIntent = original.KillChainIntentUnknown
)

type Kind = original.Kind

const (
	KindAggregations     Kind = original.KindAggregations
	KindCasesAggregation Kind = original.KindCasesAggregation
)

type KindBasicAlertRule = original.KindBasicAlertRule

const (
	KindBasicAlertRuleKindAlertRule                         KindBasicAlertRule = original.KindBasicAlertRuleKindAlertRule
	KindBasicAlertRuleKindFusion                            KindBasicAlertRule = original.KindBasicAlertRuleKindFusion
	KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation KindBasicAlertRule = original.KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation
	KindBasicAlertRuleKindMLBehaviorAnalytics               KindBasicAlertRule = original.KindBasicAlertRuleKindMLBehaviorAnalytics
	KindBasicAlertRuleKindScheduled                         KindBasicAlertRule = original.KindBasicAlertRuleKindScheduled
	KindBasicAlertRuleKindThreatIntelligence                KindBasicAlertRule = original.KindBasicAlertRuleKindThreatIntelligence
)

type KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplate

const (
	KindBasicAlertRuleTemplateKindAlertRuleTemplate                 KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindAlertRuleTemplate
	KindBasicAlertRuleTemplateKindFusion                            KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindFusion
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation
	KindBasicAlertRuleTemplateKindMLBehaviorAnalytics               KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindMLBehaviorAnalytics
	KindBasicAlertRuleTemplateKindScheduled                         KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindScheduled
	KindBasicAlertRuleTemplateKindThreatIntelligence                KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindThreatIntelligence
)

type KindBasicDataConnector = original.KindBasicDataConnector

const (
	KindBasicDataConnectorKindAmazonWebServicesCloudTrail               KindBasicDataConnector = original.KindBasicDataConnectorKindAmazonWebServicesCloudTrail
	KindBasicDataConnectorKindAzureActiveDirectory                      KindBasicDataConnector = original.KindBasicDataConnectorKindAzureActiveDirectory
	KindBasicDataConnectorKindAzureAdvancedThreatProtection             KindBasicDataConnector = original.KindBasicDataConnectorKindAzureAdvancedThreatProtection
	KindBasicDataConnectorKindAzureSecurityCenter                       KindBasicDataConnector = original.KindBasicDataConnectorKindAzureSecurityCenter
	KindBasicDataConnectorKindDataConnector                             KindBasicDataConnector = original.KindBasicDataConnectorKindDataConnector
	KindBasicDataConnectorKindDynamics365                               KindBasicDataConnector = original.KindBasicDataConnectorKindDynamics365
	KindBasicDataConnectorKindMicrosoftCloudAppSecurity                 KindBasicDataConnector = original.KindBasicDataConnectorKindMicrosoftCloudAppSecurity
	KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = original.KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	KindBasicDataConnectorKindMicrosoftThreatIntelligence               KindBasicDataConnector = original.KindBasicDataConnectorKindMicrosoftThreatIntelligence
	KindBasicDataConnectorKindMicrosoftThreatProtection                 KindBasicDataConnector = original.KindBasicDataConnectorKindMicrosoftThreatProtection
	KindBasicDataConnectorKindOffice365                                 KindBasicDataConnector = original.KindBasicDataConnectorKindOffice365
	KindBasicDataConnectorKindOfficeATP                                 KindBasicDataConnector = original.KindBasicDataConnectorKindOfficeATP
	KindBasicDataConnectorKindThreatIntelligence                        KindBasicDataConnector = original.KindBasicDataConnectorKindThreatIntelligence
	KindBasicDataConnectorKindThreatIntelligenceTaxii                   KindBasicDataConnector = original.KindBasicDataConnectorKindThreatIntelligenceTaxii
)

type KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirements

const (
	KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail               KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail
	KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory                      KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory
	KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection             KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection
	KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter                       KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter
	KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements           KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements
	KindBasicDataConnectorsCheckRequirementsKindDynamics365                               KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindDynamics365
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity                 KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence               KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection                 KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection
	KindBasicDataConnectorsCheckRequirementsKindOfficeATP                                 KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindOfficeATP
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence                        KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii                   KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii
)

type KindBasicEntity = original.KindBasicEntity

const (
	KindBasicEntityKindAccount          KindBasicEntity = original.KindBasicEntityKindAccount
	KindBasicEntityKindAzureResource    KindBasicEntity = original.KindBasicEntityKindAzureResource
	KindBasicEntityKindBookmark         KindBasicEntity = original.KindBasicEntityKindBookmark
	KindBasicEntityKindCloudApplication KindBasicEntity = original.KindBasicEntityKindCloudApplication
	KindBasicEntityKindDNSResolution    KindBasicEntity = original.KindBasicEntityKindDNSResolution
	KindBasicEntityKindEntity           KindBasicEntity = original.KindBasicEntityKindEntity
	KindBasicEntityKindFile             KindBasicEntity = original.KindBasicEntityKindFile
	KindBasicEntityKindFileHash         KindBasicEntity = original.KindBasicEntityKindFileHash
	KindBasicEntityKindHost             KindBasicEntity = original.KindBasicEntityKindHost
	KindBasicEntityKindIoTDevice        KindBasicEntity = original.KindBasicEntityKindIoTDevice
	KindBasicEntityKindIP               KindBasicEntity = original.KindBasicEntityKindIP
	KindBasicEntityKindMailbox          KindBasicEntity = original.KindBasicEntityKindMailbox
	KindBasicEntityKindMailCluster      KindBasicEntity = original.KindBasicEntityKindMailCluster
	KindBasicEntityKindMailMessage      KindBasicEntity = original.KindBasicEntityKindMailMessage
	KindBasicEntityKindMalware          KindBasicEntity = original.KindBasicEntityKindMalware
	KindBasicEntityKindProcess          KindBasicEntity = original.KindBasicEntityKindProcess
	KindBasicEntityKindRegistryKey      KindBasicEntity = original.KindBasicEntityKindRegistryKey
	KindBasicEntityKindRegistryValue    KindBasicEntity = original.KindBasicEntityKindRegistryValue
	KindBasicEntityKindSecurityAlert    KindBasicEntity = original.KindBasicEntityKindSecurityAlert
	KindBasicEntityKindSecurityGroup    KindBasicEntity = original.KindBasicEntityKindSecurityGroup
	KindBasicEntityKindSubmissionMail   KindBasicEntity = original.KindBasicEntityKindSubmissionMail
	KindBasicEntityKindURL              KindBasicEntity = original.KindBasicEntityKindURL
)

type KindBasicEntityQuery = original.KindBasicEntityQuery

const (
	KindBasicEntityQueryKindEntityQuery KindBasicEntityQuery = original.KindBasicEntityQueryKindEntityQuery
	KindBasicEntityQueryKindExpansion   KindBasicEntityQuery = original.KindBasicEntityQueryKindExpansion
)

type KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItem

const (
	KindBasicEntityTimelineItemKindActivity           KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindActivity
	KindBasicEntityTimelineItemKindBookmark           KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindBookmark
	KindBasicEntityTimelineItemKindEntityTimelineItem KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindEntityTimelineItem
	KindBasicEntityTimelineItemKindSecurityAlert      KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindSecurityAlert
)

type KindBasicSettings = original.KindBasicSettings

const (
	KindBasicSettingsKindEntityAnalytics KindBasicSettings = original.KindBasicSettingsKindEntityAnalytics
	KindBasicSettingsKindEyesOn          KindBasicSettings = original.KindBasicSettingsKindEyesOn
	KindBasicSettingsKindIPSyncer        KindBasicSettings = original.KindBasicSettingsKindIPSyncer
	KindBasicSettingsKindSettings        KindBasicSettings = original.KindBasicSettingsKindSettings
	KindBasicSettingsKindUeba            KindBasicSettings = original.KindBasicSettingsKindUeba
)

type KindBasicThreatIntelligenceInformation = original.KindBasicThreatIntelligenceInformation

const (
	KindBasicThreatIntelligenceInformationKindIndicator                     KindBasicThreatIntelligenceInformation = original.KindBasicThreatIntelligenceInformationKindIndicator
	KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation KindBasicThreatIntelligenceInformation = original.KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation
)

type MicrosoftSecurityProductName = original.MicrosoftSecurityProductName

const (
	MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection    MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection
	MicrosoftSecurityProductNameAzureAdvancedThreatProtection             MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameAzureAdvancedThreatProtection
	MicrosoftSecurityProductNameAzureSecurityCenter                       MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameAzureSecurityCenter
	MicrosoftSecurityProductNameAzureSecurityCenterforIoT                 MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameAzureSecurityCenterforIoT
	MicrosoftSecurityProductNameMicrosoftCloudAppSecurity                 MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameMicrosoftCloudAppSecurity
	MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection
	MicrosoftSecurityProductNameOffice365AdvancedThreatProtection         MicrosoftSecurityProductName = original.MicrosoftSecurityProductNameOffice365AdvancedThreatProtection
)

type OSFamily = original.OSFamily

const (
	OSFamilyAndroid OSFamily = original.OSFamilyAndroid
	OSFamilyIOS     OSFamily = original.OSFamilyIOS
	OSFamilyLinux   OSFamily = original.OSFamilyLinux
	OSFamilyUnknown OSFamily = original.OSFamilyUnknown
	OSFamilyWindows OSFamily = original.OSFamilyWindows
)

type OutputType = original.OutputType

const (
	OutputTypeDate   OutputType = original.OutputTypeDate
	OutputTypeEntity OutputType = original.OutputTypeEntity
	OutputTypeNumber OutputType = original.OutputTypeNumber
	OutputTypeString OutputType = original.OutputTypeString
)

type PollingFrequency = original.PollingFrequency

const (
	PollingFrequencyOnceADay    PollingFrequency = original.PollingFrequencyOnceADay
	PollingFrequencyOnceAMinute PollingFrequency = original.PollingFrequencyOnceAMinute
	PollingFrequencyOnceAnHour  PollingFrequency = original.PollingFrequencyOnceAnHour
)

type RegistryHive = original.RegistryHive

const (
	RegistryHiveHKEYA                        RegistryHive = original.RegistryHiveHKEYA
	RegistryHiveHKEYCLASSESROOT              RegistryHive = original.RegistryHiveHKEYCLASSESROOT
	RegistryHiveHKEYCURRENTCONFIG            RegistryHive = original.RegistryHiveHKEYCURRENTCONFIG
	RegistryHiveHKEYCURRENTUSER              RegistryHive = original.RegistryHiveHKEYCURRENTUSER
	RegistryHiveHKEYCURRENTUSERLOCALSETTINGS RegistryHive = original.RegistryHiveHKEYCURRENTUSERLOCALSETTINGS
	RegistryHiveHKEYLOCALMACHINE             RegistryHive = original.RegistryHiveHKEYLOCALMACHINE
	RegistryHiveHKEYPERFORMANCEDATA          RegistryHive = original.RegistryHiveHKEYPERFORMANCEDATA
	RegistryHiveHKEYPERFORMANCENLSTEXT       RegistryHive = original.RegistryHiveHKEYPERFORMANCENLSTEXT
	RegistryHiveHKEYPERFORMANCETEXT          RegistryHive = original.RegistryHiveHKEYPERFORMANCETEXT
	RegistryHiveHKEYUSERS                    RegistryHive = original.RegistryHiveHKEYUSERS
)

type RegistryValueKind = original.RegistryValueKind

const (
	RegistryValueKindBinary       RegistryValueKind = original.RegistryValueKindBinary
	RegistryValueKindDWord        RegistryValueKind = original.RegistryValueKindDWord
	RegistryValueKindExpandString RegistryValueKind = original.RegistryValueKindExpandString
	RegistryValueKindMultiString  RegistryValueKind = original.RegistryValueKindMultiString
	RegistryValueKindNone         RegistryValueKind = original.RegistryValueKindNone
	RegistryValueKindQWord        RegistryValueKind = original.RegistryValueKindQWord
	RegistryValueKindString       RegistryValueKind = original.RegistryValueKindString
	RegistryValueKindUnknown      RegistryValueKind = original.RegistryValueKindUnknown
)

type RelationNodeKind = original.RelationNodeKind

const (
	RelationNodeKindBookmark RelationNodeKind = original.RelationNodeKindBookmark
	RelationNodeKindCase     RelationNodeKind = original.RelationNodeKindCase
)

type RelationTypes = original.RelationTypes

const (
	RelationTypesCasesToBookmarks RelationTypes = original.RelationTypesCasesToBookmarks
)

type SettingKind = original.SettingKind

const (
	SettingKindEntityAnalytics SettingKind = original.SettingKindEntityAnalytics
	SettingKindEyesOn          SettingKind = original.SettingKindEyesOn
	SettingKindUeba            SettingKind = original.SettingKindUeba
)

type Source = original.Source

const (
	SourceLocalfile     Source = original.SourceLocalfile
	SourceRemotestorage Source = original.SourceRemotestorage
)

type TemplateStatus = original.TemplateStatus

const (
	TemplateStatusAvailable    TemplateStatus = original.TemplateStatusAvailable
	TemplateStatusInstalled    TemplateStatus = original.TemplateStatusInstalled
	TemplateStatusNotAvailable TemplateStatus = original.TemplateStatusNotAvailable
)

type ThreatIntelligenceResourceKind = original.ThreatIntelligenceResourceKind

const (
	ThreatIntelligenceResourceKindIndicator ThreatIntelligenceResourceKind = original.ThreatIntelligenceResourceKindIndicator
)

type ThreatIntelligenceSortingCriteria = original.ThreatIntelligenceSortingCriteria

const (
	ThreatIntelligenceSortingCriteriaAscending  ThreatIntelligenceSortingCriteria = original.ThreatIntelligenceSortingCriteriaAscending
	ThreatIntelligenceSortingCriteriaDescending ThreatIntelligenceSortingCriteria = original.ThreatIntelligenceSortingCriteriaDescending
	ThreatIntelligenceSortingCriteriaUnsorted   ThreatIntelligenceSortingCriteria = original.ThreatIntelligenceSortingCriteriaUnsorted
)

type TriggerOperator = original.TriggerOperator

const (
	TriggerOperatorEqual       TriggerOperator = original.TriggerOperatorEqual
	TriggerOperatorGreaterThan TriggerOperator = original.TriggerOperatorGreaterThan
	TriggerOperatorLessThan    TriggerOperator = original.TriggerOperatorLessThan
	TriggerOperatorNotEqual    TriggerOperator = original.TriggerOperatorNotEqual
)

type UebaDataSources = original.UebaDataSources

const (
	UebaDataSourcesAuditLogs     UebaDataSources = original.UebaDataSourcesAuditLogs
	UebaDataSourcesAzureActivity UebaDataSources = original.UebaDataSourcesAzureActivity
	UebaDataSourcesSecurityEvent UebaDataSources = original.UebaDataSourcesSecurityEvent
	UebaDataSourcesSigninLogs    UebaDataSources = original.UebaDataSourcesSigninLogs
)

type AADCheckRequirements = original.AADCheckRequirements
type AADCheckRequirementsProperties = original.AADCheckRequirementsProperties
type AADDataConnector = original.AADDataConnector
type AADDataConnectorProperties = original.AADDataConnectorProperties
type AATPCheckRequirements = original.AATPCheckRequirements
type AATPCheckRequirementsProperties = original.AATPCheckRequirementsProperties
type AATPDataConnector = original.AATPDataConnector
type AATPDataConnectorProperties = original.AATPDataConnectorProperties
type ASCCheckRequirements = original.ASCCheckRequirements
type ASCCheckRequirementsProperties = original.ASCCheckRequirementsProperties
type ASCDataConnector = original.ASCDataConnector
type ASCDataConnectorProperties = original.ASCDataConnectorProperties
type AccountEntity = original.AccountEntity
type AccountEntityProperties = original.AccountEntityProperties
type ActionPropertiesBase = original.ActionPropertiesBase
type ActionRequest = original.ActionRequest
type ActionRequestProperties = original.ActionRequestProperties
type ActionResponse = original.ActionResponse
type ActionResponseProperties = original.ActionResponseProperties
type ActionsClient = original.ActionsClient
type ActionsList = original.ActionsList
type ActionsListIterator = original.ActionsListIterator
type ActionsListPage = original.ActionsListPage
type ActivityTimelineItem = original.ActivityTimelineItem
type Aggregations = original.Aggregations
type AggregationsKind = original.AggregationsKind
type AggregationsModel = original.AggregationsModel
type AlertRule = original.AlertRule
type AlertRuleKind1 = original.AlertRuleKind1
type AlertRuleModel = original.AlertRuleModel
type AlertRuleTemplate = original.AlertRuleTemplate
type AlertRuleTemplateDataSource = original.AlertRuleTemplateDataSource
type AlertRuleTemplateModel = original.AlertRuleTemplateModel
type AlertRuleTemplatePropertiesBase = original.AlertRuleTemplatePropertiesBase
type AlertRuleTemplatesClient = original.AlertRuleTemplatesClient
type AlertRuleTemplatesList = original.AlertRuleTemplatesList
type AlertRuleTemplatesListIterator = original.AlertRuleTemplatesListIterator
type AlertRuleTemplatesListPage = original.AlertRuleTemplatesListPage
type AlertRulesClient = original.AlertRulesClient
type AlertRulesList = original.AlertRulesList
type AlertRulesListIterator = original.AlertRulesListIterator
type AlertRulesListPage = original.AlertRulesListPage
type AlertsDataTypeOfDataConnector = original.AlertsDataTypeOfDataConnector
type AlertsDataTypeOfDataConnectorAlerts = original.AlertsDataTypeOfDataConnectorAlerts
type AutomationRule = original.AutomationRule
type AutomationRuleAction = original.AutomationRuleAction
type AutomationRuleCondition = original.AutomationRuleCondition
type AutomationRuleModifyPropertiesAction = original.AutomationRuleModifyPropertiesAction
type AutomationRuleModifyPropertiesActionActionConfiguration = original.AutomationRuleModifyPropertiesActionActionConfiguration
type AutomationRuleProperties = original.AutomationRuleProperties
type AutomationRulePropertyValuesCondition = original.AutomationRulePropertyValuesCondition
type AutomationRulePropertyValuesConditionConditionProperties = original.AutomationRulePropertyValuesConditionConditionProperties
type AutomationRuleRunPlaybookAction = original.AutomationRuleRunPlaybookAction
type AutomationRuleRunPlaybookActionActionConfiguration = original.AutomationRuleRunPlaybookActionActionConfiguration
type AutomationRuleTriggeringLogic = original.AutomationRuleTriggeringLogic
type AutomationRulesClient = original.AutomationRulesClient
type AutomationRulesList = original.AutomationRulesList
type AutomationRulesListIterator = original.AutomationRulesListIterator
type AutomationRulesListPage = original.AutomationRulesListPage
type AwsCloudTrailCheckRequirements = original.AwsCloudTrailCheckRequirements
type AwsCloudTrailDataConnector = original.AwsCloudTrailDataConnector
type AwsCloudTrailDataConnectorDataTypes = original.AwsCloudTrailDataConnectorDataTypes
type AwsCloudTrailDataConnectorDataTypesLogs = original.AwsCloudTrailDataConnectorDataTypesLogs
type AwsCloudTrailDataConnectorProperties = original.AwsCloudTrailDataConnectorProperties
type AzureResourceEntity = original.AzureResourceEntity
type AzureResourceEntityProperties = original.AzureResourceEntityProperties
type BaseClient = original.BaseClient
type BasicAggregations = original.BasicAggregations
type BasicAlertRule = original.BasicAlertRule
type BasicAlertRuleTemplate = original.BasicAlertRuleTemplate
type BasicAutomationRuleAction = original.BasicAutomationRuleAction
type BasicAutomationRuleCondition = original.BasicAutomationRuleCondition
type BasicDataConnector = original.BasicDataConnector
type BasicDataConnectorsCheckRequirements = original.BasicDataConnectorsCheckRequirements
type BasicEntity = original.BasicEntity
type BasicEntityQuery = original.BasicEntityQuery
type BasicEntityTimelineItem = original.BasicEntityTimelineItem
type BasicSettings = original.BasicSettings
type BasicThreatIntelligenceInformation = original.BasicThreatIntelligenceInformation
type Bookmark = original.Bookmark
type BookmarkClient = original.BookmarkClient
type BookmarkExpandParameters = original.BookmarkExpandParameters
type BookmarkExpandResponse = original.BookmarkExpandResponse
type BookmarkExpandResponseValue = original.BookmarkExpandResponseValue
type BookmarkList = original.BookmarkList
type BookmarkListIterator = original.BookmarkListIterator
type BookmarkListPage = original.BookmarkListPage
type BookmarkProperties = original.BookmarkProperties
type BookmarkRelationsClient = original.BookmarkRelationsClient
type BookmarkTimelineItem = original.BookmarkTimelineItem
type BookmarksClient = original.BookmarksClient
type Case = original.Case
type CaseComment = original.CaseComment
type CaseCommentList = original.CaseCommentList
type CaseCommentListIterator = original.CaseCommentListIterator
type CaseCommentListPage = original.CaseCommentListPage
type CaseCommentProperties = original.CaseCommentProperties
type CaseCommentsClient = original.CaseCommentsClient
type CaseList = original.CaseList
type CaseListIterator = original.CaseListIterator
type CaseListPage = original.CaseListPage
type CaseProperties = original.CaseProperties
type CaseRelation = original.CaseRelation
type CaseRelationList = original.CaseRelationList
type CaseRelationListIterator = original.CaseRelationListIterator
type CaseRelationListPage = original.CaseRelationListPage
type CaseRelationProperties = original.CaseRelationProperties
type CaseRelationsClient = original.CaseRelationsClient
type CasesAggregation = original.CasesAggregation
type CasesAggregationBySeverityProperties = original.CasesAggregationBySeverityProperties
type CasesAggregationByStatusProperties = original.CasesAggregationByStatusProperties
type CasesAggregationProperties = original.CasesAggregationProperties
type CasesAggregationsClient = original.CasesAggregationsClient
type CasesClient = original.CasesClient
type ClientInfo = original.ClientInfo
type CloudApplicationEntity = original.CloudApplicationEntity
type CloudApplicationEntityProperties = original.CloudApplicationEntityProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CommentsClient = original.CommentsClient
type ConnectedEntity = original.ConnectedEntity
type DNSEntity = original.DNSEntity
type DNSEntityProperties = original.DNSEntityProperties
type DataConnector = original.DataConnector
type DataConnectorDataTypeCommon = original.DataConnectorDataTypeCommon
type DataConnectorKind1 = original.DataConnectorKind1
type DataConnectorList = original.DataConnectorList
type DataConnectorListIterator = original.DataConnectorListIterator
type DataConnectorListPage = original.DataConnectorListPage
type DataConnectorModel = original.DataConnectorModel
type DataConnectorRequirementsState = original.DataConnectorRequirementsState
type DataConnectorTenantID = original.DataConnectorTenantID
type DataConnectorWithAlertsProperties = original.DataConnectorWithAlertsProperties
type DataConnectorsCheckRequirements = original.DataConnectorsCheckRequirements
type DataConnectorsCheckRequirementsClient = original.DataConnectorsCheckRequirementsClient
type DataConnectorsClient = original.DataConnectorsClient
type Dynamics365CheckRequirements = original.Dynamics365CheckRequirements
type Dynamics365CheckRequirementsProperties = original.Dynamics365CheckRequirementsProperties
type Dynamics365DataConnector = original.Dynamics365DataConnector
type Dynamics365DataConnectorDataTypes = original.Dynamics365DataConnectorDataTypes
type Dynamics365DataConnectorDataTypesDynamics365CdsActivities = original.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
type Dynamics365DataConnectorProperties = original.Dynamics365DataConnectorProperties
type EntitiesClient = original.EntitiesClient
type EntitiesGetTimelineClient = original.EntitiesGetTimelineClient
type EntitiesRelationsClient = original.EntitiesRelationsClient
type Entity = original.Entity
type EntityAnalytics = original.EntityAnalytics
type EntityAnalyticsProperties = original.EntityAnalyticsProperties
type EntityCommonProperties = original.EntityCommonProperties
type EntityEdges = original.EntityEdges
type EntityExpandParameters = original.EntityExpandParameters
type EntityExpandResponse = original.EntityExpandResponse
type EntityExpandResponseValue = original.EntityExpandResponseValue
type EntityGetInsightsParameters = original.EntityGetInsightsParameters
type EntityGetInsightsResponse = original.EntityGetInsightsResponse
type EntityInsightItem = original.EntityInsightItem
type EntityInsightItemQueryTimeInterval = original.EntityInsightItemQueryTimeInterval
type EntityKind1 = original.EntityKind1
type EntityList = original.EntityList
type EntityListIterator = original.EntityListIterator
type EntityListPage = original.EntityListPage
type EntityModel = original.EntityModel
type EntityQueriesClient = original.EntityQueriesClient
type EntityQuery = original.EntityQuery
type EntityQueryItem = original.EntityQueryItem
type EntityQueryItemProperties = original.EntityQueryItemProperties
type EntityQueryItemPropertiesDataTypesItem = original.EntityQueryItemPropertiesDataTypesItem
type EntityQueryKind1 = original.EntityQueryKind1
type EntityQueryList = original.EntityQueryList
type EntityQueryListIterator = original.EntityQueryListIterator
type EntityQueryListPage = original.EntityQueryListPage
type EntityQueryModel = original.EntityQueryModel
type EntityRelationsClient = original.EntityRelationsClient
type EntityTimelineItem = original.EntityTimelineItem
type EntityTimelineParameters = original.EntityTimelineParameters
type EntityTimelineResponse = original.EntityTimelineResponse
type EventGroupingSettings = original.EventGroupingSettings
type ExpansionEntityQueriesProperties = original.ExpansionEntityQueriesProperties
type ExpansionEntityQuery = original.ExpansionEntityQuery
type ExpansionResultAggregation = original.ExpansionResultAggregation
type ExpansionResultsMetadata = original.ExpansionResultsMetadata
type EyesOn = original.EyesOn
type EyesOnSettingsProperties = original.EyesOnSettingsProperties
type FileEntity = original.FileEntity
type FileEntityProperties = original.FileEntityProperties
type FileHashEntity = original.FileHashEntity
type FileHashEntityProperties = original.FileHashEntityProperties
type FusionAlertRule = original.FusionAlertRule
type FusionAlertRuleProperties = original.FusionAlertRuleProperties
type FusionAlertRuleTemplate = original.FusionAlertRuleTemplate
type FusionAlertRuleTemplateProperties = original.FusionAlertRuleTemplateProperties
type GeoLocation = original.GeoLocation
type GetInsightsError = original.GetInsightsError
type GetInsightsResultsMetadata = original.GetInsightsResultsMetadata
type GetQueriesResponse = original.GetQueriesResponse
type GroupingConfiguration = original.GroupingConfiguration
type HostEntity = original.HostEntity
type HostEntityProperties = original.HostEntityProperties
type HuntingBookmark = original.HuntingBookmark
type HuntingBookmarkProperties = original.HuntingBookmarkProperties
type IPEntity = original.IPEntity
type IPEntityProperties = original.IPEntityProperties
type IPSyncer = original.IPSyncer
type IPSyncerSettingsProperties = original.IPSyncerSettingsProperties
type Incident = original.Incident
type IncidentAdditionalData = original.IncidentAdditionalData
type IncidentAlertList = original.IncidentAlertList
type IncidentBookmarkList = original.IncidentBookmarkList
type IncidentComment = original.IncidentComment
type IncidentCommentList = original.IncidentCommentList
type IncidentCommentListIterator = original.IncidentCommentListIterator
type IncidentCommentListPage = original.IncidentCommentListPage
type IncidentCommentProperties = original.IncidentCommentProperties
type IncidentCommentsClient = original.IncidentCommentsClient
type IncidentConfiguration = original.IncidentConfiguration
type IncidentEntitiesResponse = original.IncidentEntitiesResponse
type IncidentEntitiesResultsMetadata = original.IncidentEntitiesResultsMetadata
type IncidentInfo = original.IncidentInfo
type IncidentLabel = original.IncidentLabel
type IncidentList = original.IncidentList
type IncidentListIterator = original.IncidentListIterator
type IncidentListPage = original.IncidentListPage
type IncidentOwnerInfo = original.IncidentOwnerInfo
type IncidentProperties = original.IncidentProperties
type IncidentRelationsClient = original.IncidentRelationsClient
type IncidentsClient = original.IncidentsClient
type InsightQueryItem = original.InsightQueryItem
type InsightQueryItemProperties = original.InsightQueryItemProperties
type InsightQueryItemPropertiesAdditionalQuery = original.InsightQueryItemPropertiesAdditionalQuery
type InsightQueryItemPropertiesDefaultTimeRange = original.InsightQueryItemPropertiesDefaultTimeRange
type InsightQueryItemPropertiesReferenceTimeRange = original.InsightQueryItemPropertiesReferenceTimeRange
type InsightQueryItemPropertiesTableQuery = original.InsightQueryItemPropertiesTableQuery
type InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem = original.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem = original.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem = original.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem
type InsightsTableResult = original.InsightsTableResult
type InsightsTableResultColumnsItem = original.InsightsTableResultColumnsItem
type IoTDeviceEntity = original.IoTDeviceEntity
type IoTDeviceEntityProperties = original.IoTDeviceEntityProperties
type MCASCheckRequirements = original.MCASCheckRequirements
type MCASCheckRequirementsProperties = original.MCASCheckRequirementsProperties
type MCASDataConnector = original.MCASDataConnector
type MCASDataConnectorDataTypes = original.MCASDataConnectorDataTypes
type MCASDataConnectorDataTypesDiscoveryLogs = original.MCASDataConnectorDataTypesDiscoveryLogs
type MCASDataConnectorProperties = original.MCASDataConnectorProperties
type MDATPCheckRequirements = original.MDATPCheckRequirements
type MDATPCheckRequirementsProperties = original.MDATPCheckRequirementsProperties
type MDATPDataConnector = original.MDATPDataConnector
type MDATPDataConnectorProperties = original.MDATPDataConnectorProperties
type MLBehaviorAnalyticsAlertRule = original.MLBehaviorAnalyticsAlertRule
type MLBehaviorAnalyticsAlertRuleProperties = original.MLBehaviorAnalyticsAlertRuleProperties
type MLBehaviorAnalyticsAlertRuleTemplate = original.MLBehaviorAnalyticsAlertRuleTemplate
type MLBehaviorAnalyticsAlertRuleTemplateProperties = original.MLBehaviorAnalyticsAlertRuleTemplateProperties
type MSTICheckRequirements = original.MSTICheckRequirements
type MSTICheckRequirementsProperties = original.MSTICheckRequirementsProperties
type MSTIDataConnector = original.MSTIDataConnector
type MSTIDataConnectorDataTypes = original.MSTIDataConnectorDataTypes
type MSTIDataConnectorDataTypesBingSafetyPhishingURL = original.MSTIDataConnectorDataTypesBingSafetyPhishingURL
type MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed = original.MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed
type MSTIDataConnectorProperties = original.MSTIDataConnectorProperties
type MTPCheckRequirementsProperties = original.MTPCheckRequirementsProperties
type MTPDataConnector = original.MTPDataConnector
type MTPDataConnectorDataTypes = original.MTPDataConnectorDataTypes
type MTPDataConnectorDataTypesIncidents = original.MTPDataConnectorDataTypesIncidents
type MTPDataConnectorProperties = original.MTPDataConnectorProperties
type MailClusterEntity = original.MailClusterEntity
type MailClusterEntityProperties = original.MailClusterEntityProperties
type MailMessageEntity = original.MailMessageEntity
type MailMessageEntityProperties = original.MailMessageEntityProperties
type MailboxEntity = original.MailboxEntity
type MailboxEntityProperties = original.MailboxEntityProperties
type MalwareEntity = original.MalwareEntity
type MalwareEntityProperties = original.MalwareEntityProperties
type MicrosoftSecurityIncidentCreationAlertRule = original.MicrosoftSecurityIncidentCreationAlertRule
type MicrosoftSecurityIncidentCreationAlertRuleCommonProperties = original.MicrosoftSecurityIncidentCreationAlertRuleCommonProperties
type MicrosoftSecurityIncidentCreationAlertRuleProperties = original.MicrosoftSecurityIncidentCreationAlertRuleProperties
type MicrosoftSecurityIncidentCreationAlertRuleTemplate = original.MicrosoftSecurityIncidentCreationAlertRuleTemplate
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties = original.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
type MtpCheckRequirements = original.MtpCheckRequirements
type OfficeATPCheckRequirements = original.OfficeATPCheckRequirements
type OfficeATPCheckRequirementsProperties = original.OfficeATPCheckRequirementsProperties
type OfficeATPDataConnector = original.OfficeATPDataConnector
type OfficeATPDataConnectorProperties = original.OfficeATPDataConnectorProperties
type OfficeConsent = original.OfficeConsent
type OfficeConsentList = original.OfficeConsentList
type OfficeConsentListIterator = original.OfficeConsentListIterator
type OfficeConsentListPage = original.OfficeConsentListPage
type OfficeConsentProperties = original.OfficeConsentProperties
type OfficeConsentsClient = original.OfficeConsentsClient
type OfficeDataConnector = original.OfficeDataConnector
type OfficeDataConnectorDataTypes = original.OfficeDataConnectorDataTypes
type OfficeDataConnectorDataTypesExchange = original.OfficeDataConnectorDataTypesExchange
type OfficeDataConnectorDataTypesSharePoint = original.OfficeDataConnectorDataTypesSharePoint
type OfficeDataConnectorDataTypesTeams = original.OfficeDataConnectorDataTypesTeams
type OfficeDataConnectorProperties = original.OfficeDataConnectorProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationsClient = original.OperationsClient
type OperationsList = original.OperationsList
type OperationsListIterator = original.OperationsListIterator
type OperationsListPage = original.OperationsListPage
type ProcessEntity = original.ProcessEntity
type ProcessEntityProperties = original.ProcessEntityProperties
type ProductSettingsClient = original.ProductSettingsClient
type RegistryKeyEntity = original.RegistryKeyEntity
type RegistryKeyEntityProperties = original.RegistryKeyEntityProperties
type RegistryValueEntity = original.RegistryValueEntity
type RegistryValueEntityProperties = original.RegistryValueEntityProperties
type Relation = original.Relation
type RelationBase = original.RelationBase
type RelationList = original.RelationList
type RelationListIterator = original.RelationListIterator
type RelationListPage = original.RelationListPage
type RelationNode = original.RelationNode
type RelationProperties = original.RelationProperties
type RelationsModelInput = original.RelationsModelInput
type RelationsModelInputProperties = original.RelationsModelInputProperties
type Resource = original.Resource
type ResourceWithEtag = original.ResourceWithEtag
type ScheduledAlertRule = original.ScheduledAlertRule
type ScheduledAlertRuleCommonProperties = original.ScheduledAlertRuleCommonProperties
type ScheduledAlertRuleProperties = original.ScheduledAlertRuleProperties
type ScheduledAlertRuleTemplate = original.ScheduledAlertRuleTemplate
type ScheduledAlertRuleTemplateProperties = original.ScheduledAlertRuleTemplateProperties
type SecurityAlert = original.SecurityAlert
type SecurityAlertProperties = original.SecurityAlertProperties
type SecurityAlertPropertiesConfidenceReasonsItem = original.SecurityAlertPropertiesConfidenceReasonsItem
type SecurityAlertTimelineItem = original.SecurityAlertTimelineItem
type SecurityGroupEntity = original.SecurityGroupEntity
type SecurityGroupEntityProperties = original.SecurityGroupEntityProperties
type SettingList = original.SettingList
type Settings = original.Settings
type SettingsKind = original.SettingsKind
type SettingsModel = original.SettingsModel
type SubmissionMailEntity = original.SubmissionMailEntity
type SubmissionMailEntityProperties = original.SubmissionMailEntityProperties
type TICheckRequirements = original.TICheckRequirements
type TICheckRequirementsProperties = original.TICheckRequirementsProperties
type TIDataConnector = original.TIDataConnector
type TIDataConnectorDataTypes = original.TIDataConnectorDataTypes
type TIDataConnectorDataTypesIndicators = original.TIDataConnectorDataTypesIndicators
type TIDataConnectorProperties = original.TIDataConnectorProperties
type ThreatIntelligence = original.ThreatIntelligence
type ThreatIntelligenceAlertRule = original.ThreatIntelligenceAlertRule
type ThreatIntelligenceAlertRuleProperties = original.ThreatIntelligenceAlertRuleProperties
type ThreatIntelligenceAlertRuleTemplate = original.ThreatIntelligenceAlertRuleTemplate
type ThreatIntelligenceAlertRuleTemplateProperties = original.ThreatIntelligenceAlertRuleTemplateProperties
type ThreatIntelligenceAppendTags = original.ThreatIntelligenceAppendTags
type ThreatIntelligenceExternalReference = original.ThreatIntelligenceExternalReference
type ThreatIntelligenceFilteringCriteria = original.ThreatIntelligenceFilteringCriteria
type ThreatIntelligenceGranularMarkingModel = original.ThreatIntelligenceGranularMarkingModel
type ThreatIntelligenceIndicatorClient = original.ThreatIntelligenceIndicatorClient
type ThreatIntelligenceIndicatorMetricsClient = original.ThreatIntelligenceIndicatorMetricsClient
type ThreatIntelligenceIndicatorModel = original.ThreatIntelligenceIndicatorModel
type ThreatIntelligenceIndicatorModelForRequestBody = original.ThreatIntelligenceIndicatorModelForRequestBody
type ThreatIntelligenceIndicatorProperties = original.ThreatIntelligenceIndicatorProperties
type ThreatIntelligenceIndicatorsClient = original.ThreatIntelligenceIndicatorsClient
type ThreatIntelligenceInformation = original.ThreatIntelligenceInformation
type ThreatIntelligenceInformationList = original.ThreatIntelligenceInformationList
type ThreatIntelligenceInformationListIterator = original.ThreatIntelligenceInformationListIterator
type ThreatIntelligenceInformationListPage = original.ThreatIntelligenceInformationListPage
type ThreatIntelligenceInformationModel = original.ThreatIntelligenceInformationModel
type ThreatIntelligenceKillChainPhase = original.ThreatIntelligenceKillChainPhase
type ThreatIntelligenceMetric = original.ThreatIntelligenceMetric
type ThreatIntelligenceMetricEntity = original.ThreatIntelligenceMetricEntity
type ThreatIntelligenceMetrics = original.ThreatIntelligenceMetrics
type ThreatIntelligenceMetricsList = original.ThreatIntelligenceMetricsList
type ThreatIntelligenceParsedPattern = original.ThreatIntelligenceParsedPattern
type ThreatIntelligenceParsedPatternTypeValue = original.ThreatIntelligenceParsedPatternTypeValue
type ThreatIntelligenceResourceKind1 = original.ThreatIntelligenceResourceKind1
type ThreatIntelligenceSortingCriteria1 = original.ThreatIntelligenceSortingCriteria1
type TiTaxiiCheckRequirements = original.TiTaxiiCheckRequirements
type TiTaxiiCheckRequirementsProperties = original.TiTaxiiCheckRequirementsProperties
type TiTaxiiDataConnector = original.TiTaxiiDataConnector
type TiTaxiiDataConnectorDataTypes = original.TiTaxiiDataConnectorDataTypes
type TiTaxiiDataConnectorDataTypesTaxiiClient = original.TiTaxiiDataConnectorDataTypesTaxiiClient
type TiTaxiiDataConnectorProperties = original.TiTaxiiDataConnectorProperties
type TimelineAggregation = original.TimelineAggregation
type TimelineError = original.TimelineError
type TimelineResultsMetadata = original.TimelineResultsMetadata
type URLEntity = original.URLEntity
type URLEntityProperties = original.URLEntityProperties
type Ueba = original.Ueba
type UebaProperties = original.UebaProperties
type UserInfo = original.UserInfo
type Watchlist = original.Watchlist
type WatchlistItem = original.WatchlistItem
type WatchlistItemList = original.WatchlistItemList
type WatchlistItemListIterator = original.WatchlistItemListIterator
type WatchlistItemListPage = original.WatchlistItemListPage
type WatchlistItemProperties = original.WatchlistItemProperties
type WatchlistItemsClient = original.WatchlistItemsClient
type WatchlistList = original.WatchlistList
type WatchlistListIterator = original.WatchlistListIterator
type WatchlistListPage = original.WatchlistListPage
type WatchlistProperties = original.WatchlistProperties
type WatchlistsClient = original.WatchlistsClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActionsClient(subscriptionID string) ActionsClient {
	return original.NewActionsClient(subscriptionID)
}
func NewActionsClientWithBaseURI(baseURI string, subscriptionID string) ActionsClient {
	return original.NewActionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return original.NewActionsListIterator(page)
}
func NewActionsListPage(cur ActionsList, getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return original.NewActionsListPage(cur, getNextPage)
}
func NewAlertRuleTemplatesClient(subscriptionID string) AlertRuleTemplatesClient {
	return original.NewAlertRuleTemplatesClient(subscriptionID)
}
func NewAlertRuleTemplatesClientWithBaseURI(baseURI string, subscriptionID string) AlertRuleTemplatesClient {
	return original.NewAlertRuleTemplatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRuleTemplatesListIterator(page AlertRuleTemplatesListPage) AlertRuleTemplatesListIterator {
	return original.NewAlertRuleTemplatesListIterator(page)
}
func NewAlertRuleTemplatesListPage(cur AlertRuleTemplatesList, getNextPage func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)) AlertRuleTemplatesListPage {
	return original.NewAlertRuleTemplatesListPage(cur, getNextPage)
}
func NewAlertRulesClient(subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClient(subscriptionID)
}
func NewAlertRulesClientWithBaseURI(baseURI string, subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return original.NewAlertRulesListIterator(page)
}
func NewAlertRulesListPage(cur AlertRulesList, getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return original.NewAlertRulesListPage(cur, getNextPage)
}
func NewAutomationRulesClient(subscriptionID string) AutomationRulesClient {
	return original.NewAutomationRulesClient(subscriptionID)
}
func NewAutomationRulesClientWithBaseURI(baseURI string, subscriptionID string) AutomationRulesClient {
	return original.NewAutomationRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAutomationRulesListIterator(page AutomationRulesListPage) AutomationRulesListIterator {
	return original.NewAutomationRulesListIterator(page)
}
func NewAutomationRulesListPage(cur AutomationRulesList, getNextPage func(context.Context, AutomationRulesList) (AutomationRulesList, error)) AutomationRulesListPage {
	return original.NewAutomationRulesListPage(cur, getNextPage)
}
func NewBookmarkClient(subscriptionID string) BookmarkClient {
	return original.NewBookmarkClient(subscriptionID)
}
func NewBookmarkClientWithBaseURI(baseURI string, subscriptionID string) BookmarkClient {
	return original.NewBookmarkClientWithBaseURI(baseURI, subscriptionID)
}
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return original.NewBookmarkListIterator(page)
}
func NewBookmarkListPage(cur BookmarkList, getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return original.NewBookmarkListPage(cur, getNextPage)
}
func NewBookmarkRelationsClient(subscriptionID string) BookmarkRelationsClient {
	return original.NewBookmarkRelationsClient(subscriptionID)
}
func NewBookmarkRelationsClientWithBaseURI(baseURI string, subscriptionID string) BookmarkRelationsClient {
	return original.NewBookmarkRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBookmarksClient(subscriptionID string) BookmarksClient {
	return original.NewBookmarksClient(subscriptionID)
}
func NewBookmarksClientWithBaseURI(baseURI string, subscriptionID string) BookmarksClient {
	return original.NewBookmarksClientWithBaseURI(baseURI, subscriptionID)
}
func NewCaseCommentListIterator(page CaseCommentListPage) CaseCommentListIterator {
	return original.NewCaseCommentListIterator(page)
}
func NewCaseCommentListPage(cur CaseCommentList, getNextPage func(context.Context, CaseCommentList) (CaseCommentList, error)) CaseCommentListPage {
	return original.NewCaseCommentListPage(cur, getNextPage)
}
func NewCaseCommentsClient(subscriptionID string) CaseCommentsClient {
	return original.NewCaseCommentsClient(subscriptionID)
}
func NewCaseCommentsClientWithBaseURI(baseURI string, subscriptionID string) CaseCommentsClient {
	return original.NewCaseCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCaseListIterator(page CaseListPage) CaseListIterator {
	return original.NewCaseListIterator(page)
}
func NewCaseListPage(cur CaseList, getNextPage func(context.Context, CaseList) (CaseList, error)) CaseListPage {
	return original.NewCaseListPage(cur, getNextPage)
}
func NewCaseRelationListIterator(page CaseRelationListPage) CaseRelationListIterator {
	return original.NewCaseRelationListIterator(page)
}
func NewCaseRelationListPage(cur CaseRelationList, getNextPage func(context.Context, CaseRelationList) (CaseRelationList, error)) CaseRelationListPage {
	return original.NewCaseRelationListPage(cur, getNextPage)
}
func NewCaseRelationsClient(subscriptionID string) CaseRelationsClient {
	return original.NewCaseRelationsClient(subscriptionID)
}
func NewCaseRelationsClientWithBaseURI(baseURI string, subscriptionID string) CaseRelationsClient {
	return original.NewCaseRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCasesAggregationsClient(subscriptionID string) CasesAggregationsClient {
	return original.NewCasesAggregationsClient(subscriptionID)
}
func NewCasesAggregationsClientWithBaseURI(baseURI string, subscriptionID string) CasesAggregationsClient {
	return original.NewCasesAggregationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCasesClient(subscriptionID string) CasesClient {
	return original.NewCasesClient(subscriptionID)
}
func NewCasesClientWithBaseURI(baseURI string, subscriptionID string) CasesClient {
	return original.NewCasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCommentsClient(subscriptionID string) CommentsClient {
	return original.NewCommentsClient(subscriptionID)
}
func NewCommentsClientWithBaseURI(baseURI string, subscriptionID string) CommentsClient {
	return original.NewCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return original.NewDataConnectorListIterator(page)
}
func NewDataConnectorListPage(cur DataConnectorList, getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return original.NewDataConnectorListPage(cur, getNextPage)
}
func NewDataConnectorsCheckRequirementsClient(subscriptionID string) DataConnectorsCheckRequirementsClient {
	return original.NewDataConnectorsCheckRequirementsClient(subscriptionID)
}
func NewDataConnectorsCheckRequirementsClientWithBaseURI(baseURI string, subscriptionID string) DataConnectorsCheckRequirementsClient {
	return original.NewDataConnectorsCheckRequirementsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataConnectorsClient(subscriptionID string) DataConnectorsClient {
	return original.NewDataConnectorsClient(subscriptionID)
}
func NewDataConnectorsClientWithBaseURI(baseURI string, subscriptionID string) DataConnectorsClient {
	return original.NewDataConnectorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesClient(subscriptionID string) EntitiesClient {
	return original.NewEntitiesClient(subscriptionID)
}
func NewEntitiesClientWithBaseURI(baseURI string, subscriptionID string) EntitiesClient {
	return original.NewEntitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesGetTimelineClient(subscriptionID string) EntitiesGetTimelineClient {
	return original.NewEntitiesGetTimelineClient(subscriptionID)
}
func NewEntitiesGetTimelineClientWithBaseURI(baseURI string, subscriptionID string) EntitiesGetTimelineClient {
	return original.NewEntitiesGetTimelineClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesRelationsClient(subscriptionID string) EntitiesRelationsClient {
	return original.NewEntitiesRelationsClient(subscriptionID)
}
func NewEntitiesRelationsClientWithBaseURI(baseURI string, subscriptionID string) EntitiesRelationsClient {
	return original.NewEntitiesRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntityListIterator(page EntityListPage) EntityListIterator {
	return original.NewEntityListIterator(page)
}
func NewEntityListPage(cur EntityList, getNextPage func(context.Context, EntityList) (EntityList, error)) EntityListPage {
	return original.NewEntityListPage(cur, getNextPage)
}
func NewEntityQueriesClient(subscriptionID string) EntityQueriesClient {
	return original.NewEntityQueriesClient(subscriptionID)
}
func NewEntityQueriesClientWithBaseURI(baseURI string, subscriptionID string) EntityQueriesClient {
	return original.NewEntityQueriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntityQueryListIterator(page EntityQueryListPage) EntityQueryListIterator {
	return original.NewEntityQueryListIterator(page)
}
func NewEntityQueryListPage(cur EntityQueryList, getNextPage func(context.Context, EntityQueryList) (EntityQueryList, error)) EntityQueryListPage {
	return original.NewEntityQueryListPage(cur, getNextPage)
}
func NewEntityRelationsClient(subscriptionID string) EntityRelationsClient {
	return original.NewEntityRelationsClient(subscriptionID)
}
func NewEntityRelationsClientWithBaseURI(baseURI string, subscriptionID string) EntityRelationsClient {
	return original.NewEntityRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentCommentListIterator(page IncidentCommentListPage) IncidentCommentListIterator {
	return original.NewIncidentCommentListIterator(page)
}
func NewIncidentCommentListPage(cur IncidentCommentList, getNextPage func(context.Context, IncidentCommentList) (IncidentCommentList, error)) IncidentCommentListPage {
	return original.NewIncidentCommentListPage(cur, getNextPage)
}
func NewIncidentCommentsClient(subscriptionID string) IncidentCommentsClient {
	return original.NewIncidentCommentsClient(subscriptionID)
}
func NewIncidentCommentsClientWithBaseURI(baseURI string, subscriptionID string) IncidentCommentsClient {
	return original.NewIncidentCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentListIterator(page IncidentListPage) IncidentListIterator {
	return original.NewIncidentListIterator(page)
}
func NewIncidentListPage(cur IncidentList, getNextPage func(context.Context, IncidentList) (IncidentList, error)) IncidentListPage {
	return original.NewIncidentListPage(cur, getNextPage)
}
func NewIncidentRelationsClient(subscriptionID string) IncidentRelationsClient {
	return original.NewIncidentRelationsClient(subscriptionID)
}
func NewIncidentRelationsClientWithBaseURI(baseURI string, subscriptionID string) IncidentRelationsClient {
	return original.NewIncidentRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentsClient(subscriptionID string) IncidentsClient {
	return original.NewIncidentsClient(subscriptionID)
}
func NewIncidentsClientWithBaseURI(baseURI string, subscriptionID string) IncidentsClient {
	return original.NewIncidentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOfficeConsentListIterator(page OfficeConsentListPage) OfficeConsentListIterator {
	return original.NewOfficeConsentListIterator(page)
}
func NewOfficeConsentListPage(cur OfficeConsentList, getNextPage func(context.Context, OfficeConsentList) (OfficeConsentList, error)) OfficeConsentListPage {
	return original.NewOfficeConsentListPage(cur, getNextPage)
}
func NewOfficeConsentsClient(subscriptionID string) OfficeConsentsClient {
	return original.NewOfficeConsentsClient(subscriptionID)
}
func NewOfficeConsentsClientWithBaseURI(baseURI string, subscriptionID string) OfficeConsentsClient {
	return original.NewOfficeConsentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return original.NewOperationsListIterator(page)
}
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return original.NewOperationsListPage(cur, getNextPage)
}
func NewProductSettingsClient(subscriptionID string) ProductSettingsClient {
	return original.NewProductSettingsClient(subscriptionID)
}
func NewProductSettingsClientWithBaseURI(baseURI string, subscriptionID string) ProductSettingsClient {
	return original.NewProductSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRelationListIterator(page RelationListPage) RelationListIterator {
	return original.NewRelationListIterator(page)
}
func NewRelationListPage(cur RelationList, getNextPage func(context.Context, RelationList) (RelationList, error)) RelationListPage {
	return original.NewRelationListPage(cur, getNextPage)
}
func NewThreatIntelligenceIndicatorClient(subscriptionID string) ThreatIntelligenceIndicatorClient {
	return original.NewThreatIntelligenceIndicatorClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorClient {
	return original.NewThreatIntelligenceIndicatorClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceIndicatorMetricsClient(subscriptionID string) ThreatIntelligenceIndicatorMetricsClient {
	return original.NewThreatIntelligenceIndicatorMetricsClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorMetricsClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorMetricsClient {
	return original.NewThreatIntelligenceIndicatorMetricsClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceIndicatorsClient(subscriptionID string) ThreatIntelligenceIndicatorsClient {
	return original.NewThreatIntelligenceIndicatorsClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorsClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorsClient {
	return original.NewThreatIntelligenceIndicatorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceInformationListIterator(page ThreatIntelligenceInformationListPage) ThreatIntelligenceInformationListIterator {
	return original.NewThreatIntelligenceInformationListIterator(page)
}
func NewThreatIntelligenceInformationListPage(cur ThreatIntelligenceInformationList, getNextPage func(context.Context, ThreatIntelligenceInformationList) (ThreatIntelligenceInformationList, error)) ThreatIntelligenceInformationListPage {
	return original.NewThreatIntelligenceInformationListPage(cur, getNextPage)
}
func NewWatchlistItemListIterator(page WatchlistItemListPage) WatchlistItemListIterator {
	return original.NewWatchlistItemListIterator(page)
}
func NewWatchlistItemListPage(cur WatchlistItemList, getNextPage func(context.Context, WatchlistItemList) (WatchlistItemList, error)) WatchlistItemListPage {
	return original.NewWatchlistItemListPage(cur, getNextPage)
}
func NewWatchlistItemsClient(subscriptionID string) WatchlistItemsClient {
	return original.NewWatchlistItemsClient(subscriptionID)
}
func NewWatchlistItemsClientWithBaseURI(baseURI string, subscriptionID string) WatchlistItemsClient {
	return original.NewWatchlistItemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchlistListIterator(page WatchlistListPage) WatchlistListIterator {
	return original.NewWatchlistListIterator(page)
}
func NewWatchlistListPage(cur WatchlistList, getNextPage func(context.Context, WatchlistList) (WatchlistList, error)) WatchlistListPage {
	return original.NewWatchlistListPage(cur, getNextPage)
}
func NewWatchlistsClient(subscriptionID string) WatchlistsClient {
	return original.NewWatchlistsClient(subscriptionID)
}
func NewWatchlistsClientWithBaseURI(baseURI string, subscriptionID string) WatchlistsClient {
	return original.NewWatchlistsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return original.PossibleAlertRuleKindValues()
}
func PossibleAlertSeverityValues() []AlertSeverity {
	return original.PossibleAlertSeverityValues()
}
func PossibleAlertStatusValues() []AlertStatus {
	return original.PossibleAlertStatusValues()
}
func PossibleAntispamMailDirectionValues() []AntispamMailDirection {
	return original.PossibleAntispamMailDirectionValues()
}
func PossibleAttackTacticValues() []AttackTactic {
	return original.PossibleAttackTacticValues()
}
func PossibleAutomationRulePropertyConditionSupportedOperatorValues() []AutomationRulePropertyConditionSupportedOperator {
	return original.PossibleAutomationRulePropertyConditionSupportedOperatorValues()
}
func PossibleAutomationRulePropertyConditionSupportedPropertyValues() []AutomationRulePropertyConditionSupportedProperty {
	return original.PossibleAutomationRulePropertyConditionSupportedPropertyValues()
}
func PossibleCaseSeverityValues() []CaseSeverity {
	return original.PossibleCaseSeverityValues()
}
func PossibleCaseStatusValues() []CaseStatus {
	return original.PossibleCaseStatusValues()
}
func PossibleCloseReasonValues() []CloseReason {
	return original.PossibleCloseReasonValues()
}
func PossibleConditionTypeValues() []ConditionType {
	return original.PossibleConditionTypeValues()
}
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return original.PossibleConfidenceLevelValues()
}
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return original.PossibleConfidenceScoreStatusValues()
}
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return original.PossibleDataConnectorAuthorizationStateValues()
}
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return original.PossibleDataConnectorKindValues()
}
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return original.PossibleDataConnectorLicenseStateValues()
}
func PossibleDataTypeStateValues() []DataTypeState {
	return original.PossibleDataTypeStateValues()
}
func PossibleDeliveryActionValues() []DeliveryAction {
	return original.PossibleDeliveryActionValues()
}
func PossibleDeliveryLocationValues() []DeliveryLocation {
	return original.PossibleDeliveryLocationValues()
}
func PossibleElevationTokenValues() []ElevationToken {
	return original.PossibleElevationTokenValues()
}
func PossibleEntitiesMatchingMethodValues() []EntitiesMatchingMethod {
	return original.PossibleEntitiesMatchingMethodValues()
}
func PossibleEntityKindValues() []EntityKind {
	return original.PossibleEntityKindValues()
}
func PossibleEntityQueryKindValues() []EntityQueryKind {
	return original.PossibleEntityQueryKindValues()
}
func PossibleEntityTimelineKindValues() []EntityTimelineKind {
	return original.PossibleEntityTimelineKindValues()
}
func PossibleEntityTypeValues() []EntityType {
	return original.PossibleEntityTypeValues()
}
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return original.PossibleEventGroupingAggregationKindValues()
}
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return original.PossibleFileHashAlgorithmValues()
}
func PossibleGroupingEntityTypeValues() []GroupingEntityType {
	return original.PossibleGroupingEntityTypeValues()
}
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return original.PossibleIncidentClassificationReasonValues()
}
func PossibleIncidentClassificationValues() []IncidentClassification {
	return original.PossibleIncidentClassificationValues()
}
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return original.PossibleIncidentLabelTypeValues()
}
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return original.PossibleIncidentSeverityValues()
}
func PossibleIncidentStatusValues() []IncidentStatus {
	return original.PossibleIncidentStatusValues()
}
func PossibleKillChainIntentValues() []KillChainIntent {
	return original.PossibleKillChainIntentValues()
}
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return original.PossibleKindBasicAlertRuleTemplateValues()
}
func PossibleKindBasicAlertRuleValues() []KindBasicAlertRule {
	return original.PossibleKindBasicAlertRuleValues()
}
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return original.PossibleKindBasicDataConnectorValues()
}
func PossibleKindBasicDataConnectorsCheckRequirementsValues() []KindBasicDataConnectorsCheckRequirements {
	return original.PossibleKindBasicDataConnectorsCheckRequirementsValues()
}
func PossibleKindBasicEntityQueryValues() []KindBasicEntityQuery {
	return original.PossibleKindBasicEntityQueryValues()
}
func PossibleKindBasicEntityTimelineItemValues() []KindBasicEntityTimelineItem {
	return original.PossibleKindBasicEntityTimelineItemValues()
}
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return original.PossibleKindBasicEntityValues()
}
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return original.PossibleKindBasicSettingsValues()
}
func PossibleKindBasicThreatIntelligenceInformationValues() []KindBasicThreatIntelligenceInformation {
	return original.PossibleKindBasicThreatIntelligenceInformationValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return original.PossibleMicrosoftSecurityProductNameValues()
}
func PossibleOSFamilyValues() []OSFamily {
	return original.PossibleOSFamilyValues()
}
func PossibleOutputTypeValues() []OutputType {
	return original.PossibleOutputTypeValues()
}
func PossiblePollingFrequencyValues() []PollingFrequency {
	return original.PossiblePollingFrequencyValues()
}
func PossibleRegistryHiveValues() []RegistryHive {
	return original.PossibleRegistryHiveValues()
}
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return original.PossibleRegistryValueKindValues()
}
func PossibleRelationNodeKindValues() []RelationNodeKind {
	return original.PossibleRelationNodeKindValues()
}
func PossibleRelationTypesValues() []RelationTypes {
	return original.PossibleRelationTypesValues()
}
func PossibleSettingKindValues() []SettingKind {
	return original.PossibleSettingKindValues()
}
func PossibleSourceValues() []Source {
	return original.PossibleSourceValues()
}
func PossibleTemplateStatusValues() []TemplateStatus {
	return original.PossibleTemplateStatusValues()
}
func PossibleThreatIntelligenceResourceKindValues() []ThreatIntelligenceResourceKind {
	return original.PossibleThreatIntelligenceResourceKindValues()
}
func PossibleThreatIntelligenceSortingCriteriaValues() []ThreatIntelligenceSortingCriteria {
	return original.PossibleThreatIntelligenceSortingCriteriaValues()
}
func PossibleTriggerOperatorValues() []TriggerOperator {
	return original.PossibleTriggerOperatorValues()
}
func PossibleUebaDataSourcesValues() []UebaDataSources {
	return original.PossibleUebaDataSourcesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
