package datafactory

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datafactory/mgmt/2018-06-01/datafactory"

// AccessPolicyResponse get Data Plane read only token response definition.
type AccessPolicyResponse struct {
	autorest.Response `json:"-"`
	// Policy - The user access policy.
	Policy *UserAccessPolicy `json:"policy,omitempty"`
	// AccessToken - Data Plane read only access token.
	AccessToken *string `json:"accessToken,omitempty"`
	// DataPlaneURL - Data Plane service base URL.
	DataPlaneURL *string `json:"dataPlaneUrl,omitempty"`
}

// BasicActivity a pipeline activity.
type BasicActivity interface {
	AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool)
	AsAzureFunctionActivity() (*AzureFunctionActivity, bool)
	AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool)
	AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool)
	AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool)
	AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool)
	AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool)
	AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool)
	AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool)
	AsGetMetadataActivity() (*GetMetadataActivity, bool)
	AsWebActivity() (*WebActivity, bool)
	AsLookupActivity() (*LookupActivity, bool)
	AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool)
	AsDeleteActivity() (*DeleteActivity, bool)
	AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool)
	AsCustomActivity() (*CustomActivity, bool)
	AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool)
	AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool)
	AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool)
	AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool)
	AsHDInsightPigActivity() (*HDInsightPigActivity, bool)
	AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool)
	AsCopyActivity() (*CopyActivity, bool)
	AsExecutionActivity() (*ExecutionActivity, bool)
	AsBasicExecutionActivity() (BasicExecutionActivity, bool)
	AsWebHookActivity() (*WebHookActivity, bool)
	AsAppendVariableActivity() (*AppendVariableActivity, bool)
	AsSetVariableActivity() (*SetVariableActivity, bool)
	AsFilterActivity() (*FilterActivity, bool)
	AsValidationActivity() (*ValidationActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsSwitchActivity() (*SwitchActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
	AsBasicControlActivity() (BasicControlActivity, bool)
	AsActivity() (*Activity, bool)
}

// Activity a pipeline activity.
type Activity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeBasicActivityTypeActivity', 'TypeBasicActivityTypeExecuteDataFlow', 'TypeBasicActivityTypeAzureFunctionActivity', 'TypeBasicActivityTypeDatabricksSparkPython', 'TypeBasicActivityTypeDatabricksSparkJar', 'TypeBasicActivityTypeDatabricksNotebook', 'TypeBasicActivityTypeDataLakeAnalyticsUSQL', 'TypeBasicActivityTypeAzureMLExecutePipeline', 'TypeBasicActivityTypeAzureMLUpdateResource', 'TypeBasicActivityTypeAzureMLBatchExecution', 'TypeBasicActivityTypeGetMetadata', 'TypeBasicActivityTypeWebActivity', 'TypeBasicActivityTypeLookup', 'TypeBasicActivityTypeAzureDataExplorerCommand', 'TypeBasicActivityTypeDelete', 'TypeBasicActivityTypeSQLServerStoredProcedure', 'TypeBasicActivityTypeCustom', 'TypeBasicActivityTypeExecuteSSISPackage', 'TypeBasicActivityTypeHDInsightSpark', 'TypeBasicActivityTypeHDInsightStreaming', 'TypeBasicActivityTypeHDInsightMapReduce', 'TypeBasicActivityTypeHDInsightPig', 'TypeBasicActivityTypeHDInsightHive', 'TypeBasicActivityTypeCopy', 'TypeBasicActivityTypeExecution', 'TypeBasicActivityTypeWebHook', 'TypeBasicActivityTypeAppendVariable', 'TypeBasicActivityTypeSetVariable', 'TypeBasicActivityTypeFilter', 'TypeBasicActivityTypeValidation', 'TypeBasicActivityTypeUntil', 'TypeBasicActivityTypeWait', 'TypeBasicActivityTypeForEach', 'TypeBasicActivityTypeSwitch', 'TypeBasicActivityTypeIfCondition', 'TypeBasicActivityTypeExecutePipeline', 'TypeBasicActivityTypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicActivity(body []byte) (BasicActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicActivityTypeExecuteDataFlow):
		var edfa ExecuteDataFlowActivity
		err := json.Unmarshal(body, &edfa)
		return edfa, err
	case string(TypeBasicActivityTypeAzureFunctionActivity):
		var afa AzureFunctionActivity
		err := json.Unmarshal(body, &afa)
		return afa, err
	case string(TypeBasicActivityTypeDatabricksSparkPython):
		var dspa DatabricksSparkPythonActivity
		err := json.Unmarshal(body, &dspa)
		return dspa, err
	case string(TypeBasicActivityTypeDatabricksSparkJar):
		var dsja DatabricksSparkJarActivity
		err := json.Unmarshal(body, &dsja)
		return dsja, err
	case string(TypeBasicActivityTypeDatabricksNotebook):
		var dna DatabricksNotebookActivity
		err := json.Unmarshal(body, &dna)
		return dna, err
	case string(TypeBasicActivityTypeDataLakeAnalyticsUSQL):
		var dlaua DataLakeAnalyticsUSQLActivity
		err := json.Unmarshal(body, &dlaua)
		return dlaua, err
	case string(TypeBasicActivityTypeAzureMLExecutePipeline):
		var amepa AzureMLExecutePipelineActivity
		err := json.Unmarshal(body, &amepa)
		return amepa, err
	case string(TypeBasicActivityTypeAzureMLUpdateResource):
		var amura AzureMLUpdateResourceActivity
		err := json.Unmarshal(body, &amura)
		return amura, err
	case string(TypeBasicActivityTypeAzureMLBatchExecution):
		var ambea AzureMLBatchExecutionActivity
		err := json.Unmarshal(body, &ambea)
		return ambea, err
	case string(TypeBasicActivityTypeGetMetadata):
		var gma GetMetadataActivity
		err := json.Unmarshal(body, &gma)
		return gma, err
	case string(TypeBasicActivityTypeWebActivity):
		var wa WebActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeBasicActivityTypeLookup):
		var la LookupActivity
		err := json.Unmarshal(body, &la)
		return la, err
	case string(TypeBasicActivityTypeAzureDataExplorerCommand):
		var adeca AzureDataExplorerCommandActivity
		err := json.Unmarshal(body, &adeca)
		return adeca, err
	case string(TypeBasicActivityTypeDelete):
		var da DeleteActivity
		err := json.Unmarshal(body, &da)
		return da, err
	case string(TypeBasicActivityTypeSQLServerStoredProcedure):
		var ssspa SQLServerStoredProcedureActivity
		err := json.Unmarshal(body, &ssspa)
		return ssspa, err
	case string(TypeBasicActivityTypeCustom):
		var ca CustomActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeBasicActivityTypeExecuteSSISPackage):
		var espa ExecuteSSISPackageActivity
		err := json.Unmarshal(body, &espa)
		return espa, err
	case string(TypeBasicActivityTypeHDInsightSpark):
		var hisa HDInsightSparkActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeBasicActivityTypeHDInsightStreaming):
		var hisa HDInsightStreamingActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeBasicActivityTypeHDInsightMapReduce):
		var himra HDInsightMapReduceActivity
		err := json.Unmarshal(body, &himra)
		return himra, err
	case string(TypeBasicActivityTypeHDInsightPig):
		var hipa HDInsightPigActivity
		err := json.Unmarshal(body, &hipa)
		return hipa, err
	case string(TypeBasicActivityTypeHDInsightHive):
		var hiha HDInsightHiveActivity
		err := json.Unmarshal(body, &hiha)
		return hiha, err
	case string(TypeBasicActivityTypeCopy):
		var ca CopyActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeBasicActivityTypeExecution):
		var ea ExecutionActivity
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(TypeBasicActivityTypeWebHook):
		var wha WebHookActivity
		err := json.Unmarshal(body, &wha)
		return wha, err
	case string(TypeBasicActivityTypeAppendVariable):
		var ava AppendVariableActivity
		err := json.Unmarshal(body, &ava)
		return ava, err
	case string(TypeBasicActivityTypeSetVariable):
		var sva SetVariableActivity
		err := json.Unmarshal(body, &sva)
		return sva, err
	case string(TypeBasicActivityTypeFilter):
		var fa FilterActivity
		err := json.Unmarshal(body, &fa)
		return fa, err
	case string(TypeBasicActivityTypeValidation):
		var va ValidationActivity
		err := json.Unmarshal(body, &va)
		return va, err
	case string(TypeBasicActivityTypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeBasicActivityTypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeBasicActivityTypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeBasicActivityTypeSwitch):
		var sa SwitchActivity
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeBasicActivityTypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeBasicActivityTypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	case string(TypeBasicActivityTypeContainer):
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Activity
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActivityArray(body []byte) ([]BasicActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	a.Type = TypeBasicActivityTypeActivity
	objectMap := make(map[string]interface{})
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.DependsOn != nil {
		objectMap["dependsOn"] = a.DependsOn
	}
	if a.UserProperties != nil {
		objectMap["userProperties"] = a.UserProperties
	}
	if a.Type != "" {
		objectMap["type"] = a.Type
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for Activity.
func (a Activity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for Activity.
func (a Activity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for Activity.
func (a Activity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for Activity.
func (a Activity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for Activity.
func (a Activity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for Activity.
func (a Activity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for Activity.
func (a Activity) AsActivity() (*Activity, bool) {
	return &a, true
}

// AsBasicActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicActivity() (BasicActivity, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				a.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				a.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// ActivityDependency activity dependency information.
type ActivityDependency struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Activity - Activity name.
	Activity *string `json:"activity,omitempty"`
	// DependencyConditions - Match-Condition for the dependency.
	DependencyConditions *[]DependencyCondition `json:"dependencyConditions,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityDependency.
func (ad ActivityDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.Activity != nil {
		objectMap["activity"] = ad.Activity
	}
	if ad.DependencyConditions != nil {
		objectMap["dependencyConditions"] = ad.DependencyConditions
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityDependency struct.
func (ad *ActivityDependency) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "activity":
			if v != nil {
				var activity string
				err = json.Unmarshal(*v, &activity)
				if err != nil {
					return err
				}
				ad.Activity = &activity
			}
		case "dependencyConditions":
			if v != nil {
				var dependencyConditions []DependencyCondition
				err = json.Unmarshal(*v, &dependencyConditions)
				if err != nil {
					return err
				}
				ad.DependencyConditions = &dependencyConditions
			}
		}
	}

	return nil
}

// ActivityPolicy execution policy for an activity.
type ActivityPolicy struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Timeout - Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout interface{} `json:"timeout,omitempty"`
	// Retry - Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry interface{} `json:"retry,omitempty"`
	// RetryIntervalInSeconds - Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
	// SecureInput - When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool `json:"secureInput,omitempty"`
	// SecureOutput - When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool `json:"secureOutput,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityPolicy.
func (ap ActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Timeout != nil {
		objectMap["timeout"] = ap.Timeout
	}
	if ap.Retry != nil {
		objectMap["retry"] = ap.Retry
	}
	if ap.RetryIntervalInSeconds != nil {
		objectMap["retryIntervalInSeconds"] = ap.RetryIntervalInSeconds
	}
	if ap.SecureInput != nil {
		objectMap["secureInput"] = ap.SecureInput
	}
	if ap.SecureOutput != nil {
		objectMap["secureOutput"] = ap.SecureOutput
	}
	for k, v := range ap.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityPolicy struct.
func (ap *ActivityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ap.AdditionalProperties == nil {
					ap.AdditionalProperties = make(map[string]interface{})
				}
				ap.AdditionalProperties[k] = additionalProperties
			}
		case "timeout":
			if v != nil {
				var timeout interface{}
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				ap.Timeout = timeout
			}
		case "retry":
			if v != nil {
				var retry interface{}
				err = json.Unmarshal(*v, &retry)
				if err != nil {
					return err
				}
				ap.Retry = retry
			}
		case "retryIntervalInSeconds":
			if v != nil {
				var retryIntervalInSeconds int32
				err = json.Unmarshal(*v, &retryIntervalInSeconds)
				if err != nil {
					return err
				}
				ap.RetryIntervalInSeconds = &retryIntervalInSeconds
			}
		case "secureInput":
			if v != nil {
				var secureInput bool
				err = json.Unmarshal(*v, &secureInput)
				if err != nil {
					return err
				}
				ap.SecureInput = &secureInput
			}
		case "secureOutput":
			if v != nil {
				var secureOutput bool
				err = json.Unmarshal(*v, &secureOutput)
				if err != nil {
					return err
				}
				ap.SecureOutput = &secureOutput
			}
		}
	}

	return nil
}

// ActivityRun information about an activity run in a pipeline.
type ActivityRun struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// PipelineName - READ-ONLY; The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineRunID - READ-ONLY; The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty"`
	// ActivityName - READ-ONLY; The name of the activity.
	ActivityName *string `json:"activityName,omitempty"`
	// ActivityType - READ-ONLY; The type of the activity.
	ActivityType *string `json:"activityType,omitempty"`
	// ActivityRunID - READ-ONLY; The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty"`
	// LinkedServiceName - READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty"`
	// Status - READ-ONLY; The status of the activity run.
	Status *string `json:"status,omitempty"`
	// ActivityRunStart - READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *date.Time `json:"activityRunStart,omitempty"`
	// ActivityRunEnd - READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *date.Time `json:"activityRunEnd,omitempty"`
	// DurationInMs - READ-ONLY; The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty"`
	// Input - READ-ONLY; The input for the activity.
	Input interface{} `json:"input,omitempty"`
	// Output - READ-ONLY; The output for the activity.
	Output interface{} `json:"output,omitempty"`
	// Error - READ-ONLY; The error if any from the activity run.
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityRun.
func (ar ActivityRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ar.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityRun struct.
func (ar *ActivityRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ar.AdditionalProperties == nil {
					ar.AdditionalProperties = make(map[string]interface{})
				}
				ar.AdditionalProperties[k] = additionalProperties
			}
		case "pipelineName":
			if v != nil {
				var pipelineName string
				err = json.Unmarshal(*v, &pipelineName)
				if err != nil {
					return err
				}
				ar.PipelineName = &pipelineName
			}
		case "pipelineRunId":
			if v != nil {
				var pipelineRunID string
				err = json.Unmarshal(*v, &pipelineRunID)
				if err != nil {
					return err
				}
				ar.PipelineRunID = &pipelineRunID
			}
		case "activityName":
			if v != nil {
				var activityName string
				err = json.Unmarshal(*v, &activityName)
				if err != nil {
					return err
				}
				ar.ActivityName = &activityName
			}
		case "activityType":
			if v != nil {
				var activityType string
				err = json.Unmarshal(*v, &activityType)
				if err != nil {
					return err
				}
				ar.ActivityType = &activityType
			}
		case "activityRunId":
			if v != nil {
				var activityRunID string
				err = json.Unmarshal(*v, &activityRunID)
				if err != nil {
					return err
				}
				ar.ActivityRunID = &activityRunID
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName string
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ar.LinkedServiceName = &linkedServiceName
			}
		case "status":
			if v != nil {
				var status string
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ar.Status = &status
			}
		case "activityRunStart":
			if v != nil {
				var activityRunStart date.Time
				err = json.Unmarshal(*v, &activityRunStart)
				if err != nil {
					return err
				}
				ar.ActivityRunStart = &activityRunStart
			}
		case "activityRunEnd":
			if v != nil {
				var activityRunEnd date.Time
				err = json.Unmarshal(*v, &activityRunEnd)
				if err != nil {
					return err
				}
				ar.ActivityRunEnd = &activityRunEnd
			}
		case "durationInMs":
			if v != nil {
				var durationInMs int32
				err = json.Unmarshal(*v, &durationInMs)
				if err != nil {
					return err
				}
				ar.DurationInMs = &durationInMs
			}
		case "input":
			if v != nil {
				var input interface{}
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ar.Input = input
			}
		case "output":
			if v != nil {
				var output interface{}
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ar.Output = output
			}
		case "error":
			if v != nil {
				var errorVar interface{}
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				ar.Error = errorVar
			}
		}
	}

	return nil
}

// ActivityRunsQueryResponse a list activity runs.
type ActivityRunsQueryResponse struct {
	autorest.Response `json:"-"`
	// Value - List of activity runs.
	Value *[]ActivityRun `json:"value,omitempty"`
	// ContinuationToken - The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AddDataFlowToDebugSessionResponse response body structure for starting data flow debug session.
type AddDataFlowToDebugSessionResponse struct {
	autorest.Response `json:"-"`
	// JobVersion - The ID of data flow debug job version.
	JobVersion *string `json:"jobVersion,omitempty"`
}

// AdditionalColumns specify the column name and value of additional columns.
type AdditionalColumns struct {
	// Name - Additional column name. Type: string (or Expression with resultType string).
	Name interface{} `json:"name,omitempty"`
	// Value - Additional column value. Type: string (or Expression with resultType string).
	Value interface{} `json:"value,omitempty"`
}

// AmazonMWSLinkedService amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
	*AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeBasicLinkedServiceTypeAmazonMWS
	objectMap := make(map[string]interface{})
	if amls.AmazonMWSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AmazonMWSLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return &amls, true
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedService struct.
func (amls *AmazonMWSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonMWSLinkedServiceTypeProperties AmazonMWSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonMWSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AmazonMWSLinkedServiceTypeProperties = &amazonMWSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSLinkedServiceTypeProperties amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// MarketplaceID - The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID interface{} `json:"marketplaceID,omitempty"`
	// SellerID - The Amazon seller ID.
	SellerID interface{} `json:"sellerID,omitempty"`
	// MwsAuthToken - The Amazon MWS authentication token.
	MwsAuthToken BasicSecretBase `json:"mwsAuthToken,omitempty"`
	// AccessKeyID - The access key id used to access data.
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretKey - The secret key used to access data.
	SecretKey BasicSecretBase `json:"secretKey,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedServiceTypeProperties struct.
func (amlstp *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				amlstp.Endpoint = endpoint
			}
		case "marketplaceID":
			if v != nil {
				var marketplaceID interface{}
				err = json.Unmarshal(*v, &marketplaceID)
				if err != nil {
					return err
				}
				amlstp.MarketplaceID = marketplaceID
			}
		case "sellerID":
			if v != nil {
				var sellerID interface{}
				err = json.Unmarshal(*v, &sellerID)
				if err != nil {
					return err
				}
				amlstp.SellerID = sellerID
			}
		case "mwsAuthToken":
			if v != nil {
				mwsAuthToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.MwsAuthToken = mwsAuthToken
			}
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				amlstp.AccessKeyID = accessKeyID
			}
		case "secretKey":
			if v != nil {
				secretKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.SecretKey = secretKey
			}
		case "useEncryptedEndpoints":
			if v != nil {
				var useEncryptedEndpoints interface{}
				err = json.Unmarshal(*v, &useEncryptedEndpoints)
				if err != nil {
					return err
				}
				amlstp.UseEncryptedEndpoints = useEncryptedEndpoints
			}
		case "useHostVerification":
			if v != nil {
				var useHostVerification interface{}
				err = json.Unmarshal(*v, &useHostVerification)
				if err != nil {
					return err
				}
				amlstp.UseHostVerification = useHostVerification
			}
		case "usePeerVerification":
			if v != nil {
				var usePeerVerification interface{}
				err = json.Unmarshal(*v, &usePeerVerification)
				if err != nil {
					return err
				}
				amlstp.UsePeerVerification = usePeerVerification
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonMWSObjectDataset amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// GenericDatasetTypeProperties - Properties specific to this dataset type.
	*GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	amod.Type = TypeBasicDatasetTypeAmazonMWSObject
	objectMap := make(map[string]interface{})
	if amod.GenericDatasetTypeProperties != nil {
		objectMap["typeProperties"] = amod.GenericDatasetTypeProperties
	}
	if amod.Description != nil {
		objectMap["description"] = amod.Description
	}
	if amod.Structure != nil {
		objectMap["structure"] = amod.Structure
	}
	if amod.Schema != nil {
		objectMap["schema"] = amod.Schema
	}
	if amod.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amod.LinkedServiceName
	}
	if amod.Parameters != nil {
		objectMap["parameters"] = amod.Parameters
	}
	if amod.Annotations != nil {
		objectMap["annotations"] = amod.Annotations
	}
	if amod.Folder != nil {
		objectMap["folder"] = amod.Folder
	}
	if amod.Type != "" {
		objectMap["type"] = amod.Type
	}
	for k, v := range amod.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return &amod, true
}

// AsHTTPDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amod, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSObjectDataset struct.
func (amod *AmazonMWSObjectDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var genericDatasetTypeProperties GenericDatasetTypeProperties
				err = json.Unmarshal(*v, &genericDatasetTypeProperties)
				if err != nil {
					return err
				}
				amod.GenericDatasetTypeProperties = &genericDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amod.AdditionalProperties == nil {
					amod.AdditionalProperties = make(map[string]interface{})
				}
				amod.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amod.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amod.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				amod.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amod.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amod.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amod.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				amod.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amod.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSSource a copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSSource.
func (ams AmazonMWSSource) MarshalJSON() ([]byte, error) {
	ams.Type = TypeBasicCopySourceTypeAmazonMWSSource
	objectMap := make(map[string]interface{})
	if ams.Query != nil {
		objectMap["query"] = ams.Query
	}
	if ams.QueryTimeout != nil {
		objectMap["queryTimeout"] = ams.QueryTimeout
	}
	if ams.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ams.AdditionalColumns
	}
	if ams.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ams.SourceRetryCount
	}
	if ams.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ams.SourceRetryWait
	}
	if ams.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ams.MaxConcurrentConnections
	}
	if ams.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = ams.DisableMetricsCollection
	}
	if ams.Type != "" {
		objectMap["type"] = ams.Type
	}
	for k, v := range ams.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return &ams, true
}

// AsCassandraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return &ams, true
}

// AsBinarySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ams, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSSource struct.
func (ams *AmazonMWSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ams.Query = query
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ams.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns interface{}
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ams.AdditionalColumns = additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ams.AdditionalProperties == nil {
					ams.AdditionalProperties = make(map[string]interface{})
				}
				ams.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ams.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ams.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ams.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				ams.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ams.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedService linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
	*AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	arls.Type = TypeBasicLinkedServiceTypeAmazonRedshift
	objectMap := make(map[string]interface{})
	if arls.AmazonRedshiftLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = arls.AmazonRedshiftLinkedServiceTypeProperties
	}
	if arls.ConnectVia != nil {
		objectMap["connectVia"] = arls.ConnectVia
	}
	if arls.Description != nil {
		objectMap["description"] = arls.Description
	}
	if arls.Parameters != nil {
		objectMap["parameters"] = arls.Parameters
	}
	if arls.Annotations != nil {
		objectMap["annotations"] = arls.Annotations
	}
	if arls.Type != "" {
		objectMap["type"] = arls.Type
	}
	for k, v := range arls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return &arls, true
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &arls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedService struct.
func (arls *AmazonRedshiftLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftLinkedServiceTypeProperties AmazonRedshiftLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				arls.AmazonRedshiftLinkedServiceTypeProperties = &amazonRedshiftLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if arls.AdditionalProperties == nil {
					arls.AdditionalProperties = make(map[string]interface{})
				}
				arls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				arls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				arls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				arls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				arls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedServiceTypeProperties amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// Server - The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`
	// Username - The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
	// Password - The password of the Amazon Redshift source.
	Password BasicSecretBase `json:"password,omitempty"`
	// Database - The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Port - The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedServiceTypeProperties struct.
func (arlstp *AmazonRedshiftLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "server":
			if v != nil {
				var server interface{}
				err = json.Unmarshal(*v, &server)
				if err != nil {
					return err
				}
				arlstp.Server = server
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				arlstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				arlstp.Password = password
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				arlstp.Database = databaseVar
			}
		case "port":
			if v != nil {
				var port interface{}
				err = json.Unmarshal(*v, &port)
				if err != nil {
					return err
				}
				arlstp.Port = port
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				arlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonRedshiftSource a copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	ars.Type = TypeBasicCopySourceTypeAmazonRedshiftSource
	objectMap := make(map[string]interface{})
	if ars.Query != nil {
		objectMap["query"] = ars.Query
	}
	if ars.RedshiftUnloadSettings != nil {
		objectMap["redshiftUnloadSettings"] = ars.RedshiftUnloadSettings
	}
	if ars.QueryTimeout != nil {
		objectMap["queryTimeout"] = ars.QueryTimeout
	}
	if ars.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ars.AdditionalColumns
	}
	if ars.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ars.SourceRetryCount
	}
	if ars.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ars.SourceRetryWait
	}
	if ars.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ars.MaxConcurrentConnections
	}
	if ars.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = ars.DisableMetricsCollection
	}
	if ars.Type != "" {
		objectMap["type"] = ars.Type
	}
	for k, v := range ars.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return &ars, true
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return &ars, true
}

// AsBinarySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ars, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftSource struct.
func (ars *AmazonRedshiftSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ars.Query = query
			}
		case "redshiftUnloadSettings":
			if v != nil {
				var redshiftUnloadSettings RedshiftUnloadSettings
				err = json.Unmarshal(*v, &redshiftUnloadSettings)
				if err != nil {
					return err
				}
				ars.RedshiftUnloadSettings = &redshiftUnloadSettings
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ars.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns interface{}
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ars.AdditionalColumns = additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ars.AdditionalProperties == nil {
					ars.AdditionalProperties = make(map[string]interface{})
				}
				ars.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ars.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ars.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ars.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				ars.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ars.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftTableDataset the Amazon Redshift table dataset.
type AmazonRedshiftTableDataset struct {
	// AmazonRedshiftTableDatasetTypeProperties - Amazon Redshift table dataset properties.
	*AmazonRedshiftTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) MarshalJSON() ([]byte, error) {
	artd.Type = TypeBasicDatasetTypeAmazonRedshiftTable
	objectMap := make(map[string]interface{})
	if artd.AmazonRedshiftTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = artd.AmazonRedshiftTableDatasetTypeProperties
	}
	if artd.Description != nil {
		objectMap["description"] = artd.Description
	}
	if artd.Structure != nil {
		objectMap["structure"] = artd.Structure
	}
	if artd.Schema != nil {
		objectMap["schema"] = artd.Schema
	}
	if artd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = artd.LinkedServiceName
	}
	if artd.Parameters != nil {
		objectMap["parameters"] = artd.Parameters
	}
	if artd.Annotations != nil {
		objectMap["annotations"] = artd.Annotations
	}
	if artd.Folder != nil {
		objectMap["folder"] = artd.Folder
	}
	if artd.Type != "" {
		objectMap["type"] = artd.Type
	}
	for k, v := range artd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return &artd, true
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &artd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftTableDataset struct.
func (artd *AmazonRedshiftTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftTableDatasetTypeProperties AmazonRedshiftTableDatasetTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				artd.AmazonRedshiftTableDatasetTypeProperties = &amazonRedshiftTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if artd.AdditionalProperties == nil {
					artd.AdditionalProperties = make(map[string]interface{})
				}
				artd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				artd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				artd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				artd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				artd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				artd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				artd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				artd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				artd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftTableDatasetTypeProperties amazon Redshift table dataset properties.
type AmazonRedshiftTableDatasetTypeProperties struct {
	// TableName - This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
	// Table - The Amazon Redshift table name. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
	// Schema - The Amazon Redshift schema name. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`
}

// AmazonS3CompatibleLinkedService linked service for Amazon S3 Compatible.
type AmazonS3CompatibleLinkedService struct {
	// AmazonS3CompatibleLinkedServiceTypeProperties - Amazon S3 Compatible linked service properties.
	*AmazonS3CompatibleLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) MarshalJSON() ([]byte, error) {
	ascls.Type = TypeBasicLinkedServiceTypeAmazonS3Compatible
	objectMap := make(map[string]interface{})
	if ascls.AmazonS3CompatibleLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = ascls.AmazonS3CompatibleLinkedServiceTypeProperties
	}
	if ascls.ConnectVia != nil {
		objectMap["connectVia"] = ascls.ConnectVia
	}
	if ascls.Description != nil {
		objectMap["description"] = ascls.Description
	}
	if ascls.Parameters != nil {
		objectMap["parameters"] = ascls.Parameters
	}
	if ascls.Annotations != nil {
		objectMap["annotations"] = ascls.Annotations
	}
	if ascls.Type != "" {
		objectMap["type"] = ascls.Type
	}
	for k, v := range ascls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return &ascls, true
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3CompatibleLinkedService.
func (ascls AmazonS3CompatibleLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &ascls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3CompatibleLinkedService struct.
func (ascls *AmazonS3CompatibleLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3CompatibleLinkedServiceTypeProperties AmazonS3CompatibleLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonS3CompatibleLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				ascls.AmazonS3CompatibleLinkedServiceTypeProperties = &amazonS3CompatibleLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ascls.AdditionalProperties == nil {
					ascls.AdditionalProperties = make(map[string]interface{})
				}
				ascls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				ascls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ascls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ascls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				ascls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3CompatibleLinkedServiceTypeProperties amazon S3 Compatible linked service properties.
type AmazonS3CompatibleLinkedServiceTypeProperties struct {
	// AccessKeyID - The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
	SecretAccessKey BasicSecretBase `json:"secretAccessKey,omitempty"`
	// ServiceURL - This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
	// ForcePathStyle - If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression with resultType boolean).
	ForcePathStyle interface{} `json:"forcePathStyle,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3CompatibleLinkedServiceTypeProperties struct.
func (asclstp *AmazonS3CompatibleLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				asclstp.AccessKeyID = accessKeyID
			}
		case "secretAccessKey":
			if v != nil {
				secretAccessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				asclstp.SecretAccessKey = secretAccessKey
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL interface{}
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				asclstp.ServiceURL = serviceURL
			}
		case "forcePathStyle":
			if v != nil {
				var forcePathStyle interface{}
				err = json.Unmarshal(*v, &forcePathStyle)
				if err != nil {
					return err
				}
				asclstp.ForcePathStyle = forcePathStyle
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				asclstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonS3CompatibleLocation the location of Amazon S3 Compatible dataset.
type AmazonS3CompatibleLocation struct {
	// BucketName - Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`
	// Version - Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetLocationTypeDatasetLocation', 'TypeBasicDatasetLocationTypeHdfsLocation', 'TypeBasicDatasetLocationTypeHTTPServerLocation', 'TypeBasicDatasetLocationTypeSftpLocation', 'TypeBasicDatasetLocationTypeFtpServerLocation', 'TypeBasicDatasetLocationTypeGoogleCloudStorageLocation', 'TypeBasicDatasetLocationTypeOracleCloudStorageLocation', 'TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation', 'TypeBasicDatasetLocationTypeAzureFileStorageLocation', 'TypeBasicDatasetLocationTypeFileServerLocation', 'TypeBasicDatasetLocationTypeAmazonS3Location', 'TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation', 'TypeBasicDatasetLocationTypeAzureBlobFSLocation', 'TypeBasicDatasetLocationTypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) MarshalJSON() ([]byte, error) {
	ascl.Type = TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation
	objectMap := make(map[string]interface{})
	if ascl.BucketName != nil {
		objectMap["bucketName"] = ascl.BucketName
	}
	if ascl.Version != nil {
		objectMap["version"] = ascl.Version
	}
	if ascl.FolderPath != nil {
		objectMap["folderPath"] = ascl.FolderPath
	}
	if ascl.FileName != nil {
		objectMap["fileName"] = ascl.FileName
	}
	if ascl.Type != "" {
		objectMap["type"] = ascl.Type
	}
	for k, v := range ascl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsOracleCloudStorageLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsOracleCloudStorageLocation() (*OracleCloudStorageLocation, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAmazonS3CompatibleLocation() (*AmazonS3CompatibleLocation, bool) {
	return &ascl, true
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AmazonS3CompatibleLocation.
func (ascl AmazonS3CompatibleLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &ascl, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3CompatibleLocation struct.
func (ascl *AmazonS3CompatibleLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				ascl.BucketName = bucketName
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				ascl.Version = version
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ascl.AdditionalProperties == nil {
					ascl.AdditionalProperties = make(map[string]interface{})
				}
				ascl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				ascl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				ascl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascl.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3CompatibleReadSettings amazon S3 Compatible read settings.
type AmazonS3CompatibleReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - Amazon S3 Compatible wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - Amazon S3 Compatible wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// Prefix - The prefix filter for the S3 Compatible object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// DeleteFilesAfterCompletion - Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreReadSettingsTypeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeHdfsReadSettings', 'TypeBasicStoreReadSettingsTypeHTTPReadSettings', 'TypeBasicStoreReadSettingsTypeSftpReadSettings', 'TypeBasicStoreReadSettingsTypeFtpReadSettings', 'TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings', 'TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings', 'TypeBasicStoreReadSettingsTypeFileServerReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings', 'TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) MarshalJSON() ([]byte, error) {
	ascrs.Type = TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings
	objectMap := make(map[string]interface{})
	if ascrs.Recursive != nil {
		objectMap["recursive"] = ascrs.Recursive
	}
	if ascrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = ascrs.WildcardFolderPath
	}
	if ascrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = ascrs.WildcardFileName
	}
	if ascrs.Prefix != nil {
		objectMap["prefix"] = ascrs.Prefix
	}
	if ascrs.FileListPath != nil {
		objectMap["fileListPath"] = ascrs.FileListPath
	}
	if ascrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = ascrs.EnablePartitionDiscovery
	}
	if ascrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = ascrs.PartitionRootPath
	}
	if ascrs.DeleteFilesAfterCompletion != nil {
		objectMap["deleteFilesAfterCompletion"] = ascrs.DeleteFilesAfterCompletion
	}
	if ascrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = ascrs.ModifiedDatetimeStart
	}
	if ascrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = ascrs.ModifiedDatetimeEnd
	}
	if ascrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ascrs.MaxConcurrentConnections
	}
	if ascrs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = ascrs.DisableMetricsCollection
	}
	if ascrs.Type != "" {
		objectMap["type"] = ascrs.Type
	}
	for k, v := range ascrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsOracleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsOracleCloudStorageReadSettings() (*OracleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAmazonS3CompatibleReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAmazonS3CompatibleReadSettings() (*AmazonS3CompatibleReadSettings, bool) {
	return &ascrs, true
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3CompatibleReadSettings.
func (ascrs AmazonS3CompatibleReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &ascrs, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3CompatibleReadSettings struct.
func (ascrs *AmazonS3CompatibleReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				ascrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				ascrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				ascrs.WildcardFileName = wildcardFileName
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				ascrs.Prefix = prefix
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				ascrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				ascrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				ascrs.PartitionRootPath = partitionRootPath
			}
		case "deleteFilesAfterCompletion":
			if v != nil {
				var deleteFilesAfterCompletion interface{}
				err = json.Unmarshal(*v, &deleteFilesAfterCompletion)
				if err != nil {
					return err
				}
				ascrs.DeleteFilesAfterCompletion = deleteFilesAfterCompletion
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				ascrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				ascrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ascrs.AdditionalProperties == nil {
					ascrs.AdditionalProperties = make(map[string]interface{})
				}
				ascrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ascrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				ascrs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascrs.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3Dataset a single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
	*AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Dataset.
func (asd AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	asd.Type = TypeBasicDatasetTypeAmazonS3Object
	objectMap := make(map[string]interface{})
	if asd.AmazonS3DatasetTypeProperties != nil {
		objectMap["typeProperties"] = asd.AmazonS3DatasetTypeProperties
	}
	if asd.Description != nil {
		objectMap["description"] = asd.Description
	}
	if asd.Structure != nil {
		objectMap["structure"] = asd.Structure
	}
	if asd.Schema != nil {
		objectMap["schema"] = asd.Schema
	}
	if asd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asd.LinkedServiceName
	}
	if asd.Parameters != nil {
		objectMap["parameters"] = asd.Parameters
	}
	if asd.Annotations != nil {
		objectMap["annotations"] = asd.Annotations
	}
	if asd.Folder != nil {
		objectMap["folder"] = asd.Folder
	}
	if asd.Type != "" {
		objectMap["type"] = asd.Type
	}
	for k, v := range asd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return &asd, true
}

// AsDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &asd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Dataset struct.
func (asd *AmazonS3Dataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3DatasetTypeProperties AmazonS3DatasetTypeProperties
				err = json.Unmarshal(*v, &amazonS3DatasetTypeProperties)
				if err != nil {
					return err
				}
				asd.AmazonS3DatasetTypeProperties = &amazonS3DatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asd.AdditionalProperties == nil {
					asd.AdditionalProperties = make(map[string]interface{})
				}
				asd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				asd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				asd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3DatasetTypeProperties amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// BucketName - The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`
	// Key - The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key interface{} `json:"key,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// Version - The version for the S3 object. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// ModifiedDatetimeStart - The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of files.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the Amazon S3 object.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3DatasetTypeProperties struct.
func (asdtp *AmazonS3DatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asdtp.BucketName = bucketName
			}
		case "key":
			if v != nil {
				var key interface{}
				err = json.Unmarshal(*v, &key)
				if err != nil {
					return err
				}
				asdtp.Key = key
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asdtp.Prefix = prefix
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asdtp.Version = version
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				asdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				asdtp.Compression = compression
			}
		}
	}

	return nil
}

// AmazonS3LinkedService linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
	*AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeBasicLinkedServiceTypeAmazonS3
	objectMap := make(map[string]interface{})
	if asls.AmazonS3LinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AmazonS3LinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return &asls, true
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedService struct.
func (asls *AmazonS3LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3LinkedServiceTypeProperties AmazonS3LinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonS3LinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AmazonS3LinkedServiceTypeProperties = &amazonS3LinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3LinkedServiceTypeProperties amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// AuthenticationType - The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`
	// AccessKeyID - The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey BasicSecretBase `json:"secretAccessKey,omitempty"`
	// ServiceURL - This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
	// SessionToken - The session token for the S3 temporary security credential.
	SessionToken BasicSecretBase `json:"sessionToken,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedServiceTypeProperties struct.
func (aslstp *AmazonS3LinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "authenticationType":
			if v != nil {
				var authenticationType interface{}
				err = json.Unmarshal(*v, &authenticationType)
				if err != nil {
					return err
				}
				aslstp.AuthenticationType = authenticationType
			}
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				aslstp.AccessKeyID = accessKeyID
			}
		case "secretAccessKey":
			if v != nil {
				secretAccessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SecretAccessKey = secretAccessKey
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL interface{}
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				aslstp.ServiceURL = serviceURL
			}
		case "sessionToken":
			if v != nil {
				sessionToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SessionToken = sessionToken
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonS3Location the location of amazon S3 dataset.
type AmazonS3Location struct {
	// BucketName - Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`
	// Version - Specify the version of amazon S3. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetLocationTypeDatasetLocation', 'TypeBasicDatasetLocationTypeHdfsLocation', 'TypeBasicDatasetLocationTypeHTTPServerLocation', 'TypeBasicDatasetLocationTypeSftpLocation', 'TypeBasicDatasetLocationTypeFtpServerLocation', 'TypeBasicDatasetLocationTypeGoogleCloudStorageLocation', 'TypeBasicDatasetLocationTypeOracleCloudStorageLocation', 'TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation', 'TypeBasicDatasetLocationTypeAzureFileStorageLocation', 'TypeBasicDatasetLocationTypeFileServerLocation', 'TypeBasicDatasetLocationTypeAmazonS3Location', 'TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation', 'TypeBasicDatasetLocationTypeAzureBlobFSLocation', 'TypeBasicDatasetLocationTypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Location.
func (asl AmazonS3Location) MarshalJSON() ([]byte, error) {
	asl.Type = TypeBasicDatasetLocationTypeAmazonS3Location
	objectMap := make(map[string]interface{})
	if asl.BucketName != nil {
		objectMap["bucketName"] = asl.BucketName
	}
	if asl.Version != nil {
		objectMap["version"] = asl.Version
	}
	if asl.FolderPath != nil {
		objectMap["folderPath"] = asl.FolderPath
	}
	if asl.FileName != nil {
		objectMap["fileName"] = asl.FileName
	}
	if asl.Type != "" {
		objectMap["type"] = asl.Type
	}
	for k, v := range asl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsOracleCloudStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsOracleCloudStorageLocation() (*OracleCloudStorageLocation, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAmazonS3CompatibleLocation() (*AmazonS3CompatibleLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return &asl, true
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &asl, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Location struct.
func (asl *AmazonS3Location) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asl.BucketName = bucketName
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asl.Version = version
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asl.AdditionalProperties == nil {
					asl.AdditionalProperties = make(map[string]interface{})
				}
				asl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				asl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				asl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asl.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3ReadSettings amazon S3 read settings.
type AmazonS3ReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - AmazonS3 wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - AmazonS3 wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// DeleteFilesAfterCompletion - Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreReadSettingsTypeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeHdfsReadSettings', 'TypeBasicStoreReadSettingsTypeHTTPReadSettings', 'TypeBasicStoreReadSettingsTypeSftpReadSettings', 'TypeBasicStoreReadSettingsTypeFtpReadSettings', 'TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings', 'TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings', 'TypeBasicStoreReadSettingsTypeFileServerReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings', 'TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) MarshalJSON() ([]byte, error) {
	asrs.Type = TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings
	objectMap := make(map[string]interface{})
	if asrs.Recursive != nil {
		objectMap["recursive"] = asrs.Recursive
	}
	if asrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = asrs.WildcardFolderPath
	}
	if asrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = asrs.WildcardFileName
	}
	if asrs.Prefix != nil {
		objectMap["prefix"] = asrs.Prefix
	}
	if asrs.FileListPath != nil {
		objectMap["fileListPath"] = asrs.FileListPath
	}
	if asrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = asrs.EnablePartitionDiscovery
	}
	if asrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = asrs.PartitionRootPath
	}
	if asrs.DeleteFilesAfterCompletion != nil {
		objectMap["deleteFilesAfterCompletion"] = asrs.DeleteFilesAfterCompletion
	}
	if asrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = asrs.ModifiedDatetimeStart
	}
	if asrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = asrs.ModifiedDatetimeEnd
	}
	if asrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = asrs.MaxConcurrentConnections
	}
	if asrs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = asrs.DisableMetricsCollection
	}
	if asrs.Type != "" {
		objectMap["type"] = asrs.Type
	}
	for k, v := range asrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsOracleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsOracleCloudStorageReadSettings() (*OracleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAmazonS3CompatibleReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAmazonS3CompatibleReadSettings() (*AmazonS3CompatibleReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return &asrs, true
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &asrs, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3ReadSettings struct.
func (asrs *AmazonS3ReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				asrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				asrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				asrs.WildcardFileName = wildcardFileName
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asrs.Prefix = prefix
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				asrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				asrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				asrs.PartitionRootPath = partitionRootPath
			}
		case "deleteFilesAfterCompletion":
			if v != nil {
				var deleteFilesAfterCompletion interface{}
				err = json.Unmarshal(*v, &deleteFilesAfterCompletion)
				if err != nil {
					return err
				}
				asrs.DeleteFilesAfterCompletion = deleteFilesAfterCompletion
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				asrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				asrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asrs.AdditionalProperties == nil {
					asrs.AdditionalProperties = make(map[string]interface{})
				}
				asrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				asrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				asrs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asrs.Type = typeVar
			}
		}
	}

	return nil
}

// AppendVariableActivity append value for a Variable of type Array.
type AppendVariableActivity struct {
	// AppendVariableActivityTypeProperties - Append Variable activity properties.
	*AppendVariableActivityTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeBasicActivityTypeActivity', 'TypeBasicActivityTypeExecuteDataFlow', 'TypeBasicActivityTypeAzureFunctionActivity', 'TypeBasicActivityTypeDatabricksSparkPython', 'TypeBasicActivityTypeDatabricksSparkJar', 'TypeBasicActivityTypeDatabricksNotebook', 'TypeBasicActivityTypeDataLakeAnalyticsUSQL', 'TypeBasicActivityTypeAzureMLExecutePipeline', 'TypeBasicActivityTypeAzureMLUpdateResource', 'TypeBasicActivityTypeAzureMLBatchExecution', 'TypeBasicActivityTypeGetMetadata', 'TypeBasicActivityTypeWebActivity', 'TypeBasicActivityTypeLookup', 'TypeBasicActivityTypeAzureDataExplorerCommand', 'TypeBasicActivityTypeDelete', 'TypeBasicActivityTypeSQLServerStoredProcedure', 'TypeBasicActivityTypeCustom', 'TypeBasicActivityTypeExecuteSSISPackage', 'TypeBasicActivityTypeHDInsightSpark', 'TypeBasicActivityTypeHDInsightStreaming', 'TypeBasicActivityTypeHDInsightMapReduce', 'TypeBasicActivityTypeHDInsightPig', 'TypeBasicActivityTypeHDInsightHive', 'TypeBasicActivityTypeCopy', 'TypeBasicActivityTypeExecution', 'TypeBasicActivityTypeWebHook', 'TypeBasicActivityTypeAppendVariable', 'TypeBasicActivityTypeSetVariable', 'TypeBasicActivityTypeFilter', 'TypeBasicActivityTypeValidation', 'TypeBasicActivityTypeUntil', 'TypeBasicActivityTypeWait', 'TypeBasicActivityTypeForEach', 'TypeBasicActivityTypeSwitch', 'TypeBasicActivityTypeIfCondition', 'TypeBasicActivityTypeExecutePipeline', 'TypeBasicActivityTypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppendVariableActivity.
func (ava AppendVariableActivity) MarshalJSON() ([]byte, error) {
	ava.Type = TypeBasicActivityTypeAppendVariable
	objectMap := make(map[string]interface{})
	if ava.AppendVariableActivityTypeProperties != nil {
		objectMap["typeProperties"] = ava.AppendVariableActivityTypeProperties
	}
	if ava.Name != nil {
		objectMap["name"] = ava.Name
	}
	if ava.Description != nil {
		objectMap["description"] = ava.Description
	}
	if ava.DependsOn != nil {
		objectMap["dependsOn"] = ava.DependsOn
	}
	if ava.UserProperties != nil {
		objectMap["userProperties"] = ava.UserProperties
	}
	if ava.Type != "" {
		objectMap["type"] = ava.Type
	}
	for k, v := range ava.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return &ava, true
}

// AsSetVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return &ava, true
}

// AsActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ava, true
}

// UnmarshalJSON is the custom unmarshaler for AppendVariableActivity struct.
func (ava *AppendVariableActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var appendVariableActivityTypeProperties AppendVariableActivityTypeProperties
				err = json.Unmarshal(*v, &appendVariableActivityTypeProperties)
				if err != nil {
					return err
				}
				ava.AppendVariableActivityTypeProperties = &appendVariableActivityTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ava.AdditionalProperties == nil {
					ava.AdditionalProperties = make(map[string]interface{})
				}
				ava.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ava.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ava.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ava.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				ava.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ava.Type = typeVar
			}
		}
	}

	return nil
}

// AppendVariableActivityTypeProperties appendVariable activity properties.
type AppendVariableActivityTypeProperties struct {
	// VariableName - Name of the variable whose value needs to be appended to.
	VariableName *string `json:"variableName,omitempty"`
	// Value - Value to be appended. Could be a static value or Expression
	Value interface{} `json:"value,omitempty"`
}

// ArmIDWrapper a wrapper for an ARM resource id
type ArmIDWrapper struct {
	// ID - READ-ONLY
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ArmIDWrapper.
func (aiw ArmIDWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AvroDataset avro dataset.
type AvroDataset struct {
	// AvroDatasetTypeProperties - Avro dataset properties.
	*AvroDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroDataset.
func (ad AvroDataset) MarshalJSON() ([]byte, error) {
	ad.Type = TypeBasicDatasetTypeAvro
	objectMap := make(map[string]interface{})
	if ad.AvroDatasetTypeProperties != nil {
		objectMap["typeProperties"] = ad.AvroDatasetTypeProperties
	}
	if ad.Description != nil {
		objectMap["description"] = ad.Description
	}
	if ad.Structure != nil {
		objectMap["structure"] = ad.Structure
	}
	if ad.Schema != nil {
		objectMap["schema"] = ad.Schema
	}
	if ad.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ad.LinkedServiceName
	}
	if ad.Parameters != nil {
		objectMap["parameters"] = ad.Parameters
	}
	if ad.Annotations != nil {
		objectMap["annotations"] = ad.Annotations
	}
	if ad.Folder != nil {
		objectMap["folder"] = ad.Folder
	}
	if ad.Type != "" {
		objectMap["type"] = ad.Type
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAvroDataset() (*AvroDataset, bool) {
	return &ad, true
}

// AsAmazonS3Dataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ad, true
}

// UnmarshalJSON is the custom unmarshaler for AvroDataset struct.
func (ad *AvroDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var avroDatasetTypeProperties AvroDatasetTypeProperties
				err = json.Unmarshal(*v, &avroDatasetTypeProperties)
				if err != nil {
					return err
				}
				ad.AvroDatasetTypeProperties = &avroDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ad.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				ad.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				ad.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ad.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ad.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				ad.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				ad.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = typeVar
			}
		}
	}

	return nil
}

// AvroDatasetTypeProperties avro dataset properties.
type AvroDatasetTypeProperties struct {
	// Location - The location of the avro storage.
	Location BasicDatasetLocation `json:"location,omitempty"`
	// AvroCompressionCodec - The data avroCompressionCodec. Type: string (or Expression with resultType string).
	AvroCompressionCodec interface{} `json:"avroCompressionCodec,omitempty"`
	AvroCompressionLevel *int32      `json:"avroCompressionLevel,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AvroDatasetTypeProperties struct.
func (adtp *AvroDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				location, err := unmarshalBasicDatasetLocation(*v)
				if err != nil {
					return err
				}
				adtp.Location = location
			}
		case "avroCompressionCodec":
			if v != nil {
				var avroCompressionCodec interface{}
				err = json.Unmarshal(*v, &avroCompressionCodec)
				if err != nil {
					return err
				}
				adtp.AvroCompressionCodec = avroCompressionCodec
			}
		case "avroCompressionLevel":
			if v != nil {
				var avroCompressionLevel int32
				err = json.Unmarshal(*v, &avroCompressionLevel)
				if err != nil {
					return err
				}
				adtp.AvroCompressionLevel = &avroCompressionLevel
			}
		}
	}

	return nil
}

// AvroFormat the data stored in Avro format.
type AvroFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetStorageFormatTypeDatasetStorageFormat', 'TypeBasicDatasetStorageFormatTypeParquetFormat', 'TypeBasicDatasetStorageFormatTypeOrcFormat', 'TypeBasicDatasetStorageFormatTypeAvroFormat', 'TypeBasicDatasetStorageFormatTypeJSONFormat', 'TypeBasicDatasetStorageFormatTypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroFormat.
func (af AvroFormat) MarshalJSON() ([]byte, error) {
	af.Type = TypeBasicDatasetStorageFormatTypeAvroFormat
	objectMap := make(map[string]interface{})
	if af.Serializer != nil {
		objectMap["serializer"] = af.Serializer
	}
	if af.Deserializer != nil {
		objectMap["deserializer"] = af.Deserializer
	}
	if af.Type != "" {
		objectMap["type"] = af.Type
	}
	for k, v := range af.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsAvroFormat() (*AvroFormat, bool) {
	return &af, true
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return nil, false
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &af, true
}

// UnmarshalJSON is the custom unmarshaler for AvroFormat struct.
func (af *AvroFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if af.AdditionalProperties == nil {
					af.AdditionalProperties = make(map[string]interface{})
				}
				af.AdditionalProperties[k] = additionalProperties
			}
		case "serializer":
			if v != nil {
				var serializer interface{}
				err = json.Unmarshal(*v, &serializer)
				if err != nil {
					return err
				}
				af.Serializer = serializer
			}
		case "deserializer":
			if v != nil {
				var deserializer interface{}
				err = json.Unmarshal(*v, &deserializer)
				if err != nil {
					return err
				}
				af.Deserializer = deserializer
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetStorageFormat
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = typeVar
			}
		}
	}

	return nil
}

// AvroSink a copy activity Avro sink.
type AvroSink struct {
	// StoreSettings - Avro store settings.
	StoreSettings BasicStoreWriteSettings `json:"storeSettings,omitempty"`
	// FormatSettings - Avro format settings.
	FormatSettings *AvroWriteSettings `json:"formatSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySinkTypeCopySink', 'TypeBasicCopySinkTypeCosmosDbMongoDbAPISink', 'TypeBasicCopySinkTypeMongoDbV2Sink', 'TypeBasicCopySinkTypeMongoDbAtlasSink', 'TypeBasicCopySinkTypeSalesforceServiceCloudSink', 'TypeBasicCopySinkTypeSalesforceSink', 'TypeBasicCopySinkTypeAzureDataExplorerSink', 'TypeBasicCopySinkTypeCommonDataServiceForAppsSink', 'TypeBasicCopySinkTypeDynamicsCrmSink', 'TypeBasicCopySinkTypeDynamicsSink', 'TypeBasicCopySinkTypeMicrosoftAccessSink', 'TypeBasicCopySinkTypeInformixSink', 'TypeBasicCopySinkTypeOdbcSink', 'TypeBasicCopySinkTypeAzureSearchIndexSink', 'TypeBasicCopySinkTypeAzureBlobFSSink', 'TypeBasicCopySinkTypeAzureDataLakeStoreSink', 'TypeBasicCopySinkTypeOracleSink', 'TypeBasicCopySinkTypeSnowflakeSink', 'TypeBasicCopySinkTypeSQLDWSink', 'TypeBasicCopySinkTypeSQLMISink', 'TypeBasicCopySinkTypeAzureSQLSink', 'TypeBasicCopySinkTypeSQLServerSink', 'TypeBasicCopySinkTypeSQLSink', 'TypeBasicCopySinkTypeCosmosDbSQLAPISink', 'TypeBasicCopySinkTypeDocumentDbCollectionSink', 'TypeBasicCopySinkTypeFileSystemSink', 'TypeBasicCopySinkTypeBlobSink', 'TypeBasicCopySinkTypeBinarySink', 'TypeBasicCopySinkTypeParquetSink', 'TypeBasicCopySinkTypeAvroSink', 'TypeBasicCopySinkTypeAzureTableSink', 'TypeBasicCopySinkTypeAzureQueueSink', 'TypeBasicCopySinkTypeSapCloudForCustomerSink', 'TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink', 'TypeBasicCopySinkTypeAzureMySQLSink', 'TypeBasicCopySinkTypeAzurePostgreSQLSink', 'TypeBasicCopySinkTypeRestSink', 'TypeBasicCopySinkTypeOrcSink', 'TypeBasicCopySinkTypeJSONSink', 'TypeBasicCopySinkTypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSink.
func (as AvroSink) MarshalJSON() ([]byte, error) {
	as.Type = TypeBasicCopySinkTypeAvroSink
	objectMap := make(map[string]interface{})
	objectMap["storeSettings"] = as.StoreSettings
	if as.FormatSettings != nil {
		objectMap["formatSettings"] = as.FormatSettings
	}
	if as.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = as.WriteBatchSize
	}
	if as.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = as.WriteBatchTimeout
	}
	if as.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = as.SinkRetryCount
	}
	if as.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = as.SinkRetryWait
	}
	if as.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = as.MaxConcurrentConnections
	}
	if as.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = as.DisableMetricsCollection
	}
	if as.Type != "" {
		objectMap["type"] = as.Type
	}
	for k, v := range as.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsMongoDbV2Sink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsMongoDbV2Sink() (*MongoDbV2Sink, bool) {
	return nil, false
}

// AsMongoDbAtlasSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsMongoDbAtlasSink() (*MongoDbAtlasSink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAvroSink() (*AvroSink, bool) {
	return &as, true
}

// AsAzureTableSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureDatabricksDeltaLakeSink() (*AzureDatabricksDeltaLakeSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsRestSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsRestSink() (*RestSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &as, true
}

// UnmarshalJSON is the custom unmarshaler for AvroSink struct.
func (as *AvroSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "storeSettings":
			if v != nil {
				storeSettings, err := unmarshalBasicStoreWriteSettings(*v)
				if err != nil {
					return err
				}
				as.StoreSettings = storeSettings
			}
		case "formatSettings":
			if v != nil {
				var formatSettings AvroWriteSettings
				err = json.Unmarshal(*v, &formatSettings)
				if err != nil {
					return err
				}
				as.FormatSettings = &formatSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if as.AdditionalProperties == nil {
					as.AdditionalProperties = make(map[string]interface{})
				}
				as.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				as.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				as.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				as.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				as.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				as.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				as.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = typeVar
			}
		}
	}

	return nil
}

// AvroSource a copy activity Avro source.
type AvroSource struct {
	// StoreSettings - Avro store settings.
	StoreSettings BasicStoreReadSettings `json:"storeSettings,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSource.
func (as AvroSource) MarshalJSON() ([]byte, error) {
	as.Type = TypeBasicCopySourceTypeAvroSource
	objectMap := make(map[string]interface{})
	objectMap["storeSettings"] = as.StoreSettings
	if as.AdditionalColumns != nil {
		objectMap["additionalColumns"] = as.AdditionalColumns
	}
	if as.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = as.SourceRetryCount
	}
	if as.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = as.SourceRetryWait
	}
	if as.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = as.MaxConcurrentConnections
	}
	if as.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = as.DisableMetricsCollection
	}
	if as.Type != "" {
		objectMap["type"] = as.Type
	}
	for k, v := range as.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAvroSource() (*AvroSource, bool) {
	return &as, true
}

// AsCopySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &as, true
}

// UnmarshalJSON is the custom unmarshaler for AvroSource struct.
func (as *AvroSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "storeSettings":
			if v != nil {
				storeSettings, err := unmarshalBasicStoreReadSettings(*v)
				if err != nil {
					return err
				}
				as.StoreSettings = storeSettings
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns interface{}
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				as.AdditionalColumns = additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if as.AdditionalProperties == nil {
					as.AdditionalProperties = make(map[string]interface{})
				}
				as.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				as.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				as.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				as.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				as.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = typeVar
			}
		}
	}

	return nil
}

// AvroWriteSettings avro write settings.
type AvroWriteSettings struct {
	// RecordName - Top level record name in write result, which is required in AVRO spec.
	RecordName *string `json:"recordName,omitempty"`
	// RecordNamespace - Record namespace in the write result.
	RecordNamespace *string `json:"recordNamespace,omitempty"`
	// MaxRowsPerFile - Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
	MaxRowsPerFile interface{} `json:"maxRowsPerFile,omitempty"`
	// FileNamePrefix - Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
	FileNamePrefix interface{} `json:"fileNamePrefix,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - Possible values include: 'TypeBasicFormatWriteSettingsTypeFormatWriteSettings', 'TypeBasicFormatWriteSettingsTypeJSONWriteSettings', 'TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings', 'TypeBasicFormatWriteSettingsTypeOrcWriteSettings', 'TypeBasicFormatWriteSettingsTypeAvroWriteSettings', 'TypeBasicFormatWriteSettingsTypeParquetWriteSettings'
	Type TypeBasicFormatWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroWriteSettings.
func (aws AvroWriteSettings) MarshalJSON() ([]byte, error) {
	aws.Type = TypeBasicFormatWriteSettingsTypeAvroWriteSettings
	objectMap := make(map[string]interface{})
	if aws.RecordName != nil {
		objectMap["recordName"] = aws.RecordName
	}
	if aws.RecordNamespace != nil {
		objectMap["recordNamespace"] = aws.RecordNamespace
	}
	if aws.MaxRowsPerFile != nil {
		objectMap["maxRowsPerFile"] = aws.MaxRowsPerFile
	}
	if aws.FileNamePrefix != nil {
		objectMap["fileNamePrefix"] = aws.FileNamePrefix
	}
	if aws.Type != "" {
		objectMap["type"] = aws.Type
	}
	for k, v := range aws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsJSONWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsJSONWriteSettings() (*JSONWriteSettings, bool) {
	return nil, false
}

// AsDelimitedTextWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsDelimitedTextWriteSettings() (*DelimitedTextWriteSettings, bool) {
	return nil, false
}

// AsOrcWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsOrcWriteSettings() (*OrcWriteSettings, bool) {
	return nil, false
}

// AsAvroWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsAvroWriteSettings() (*AvroWriteSettings, bool) {
	return &aws, true
}

// AsParquetWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsParquetWriteSettings() (*ParquetWriteSettings, bool) {
	return nil, false
}

// AsFormatWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsFormatWriteSettings() (*FormatWriteSettings, bool) {
	return nil, false
}

// AsBasicFormatWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsBasicFormatWriteSettings() (BasicFormatWriteSettings, bool) {
	return &aws, true
}

// UnmarshalJSON is the custom unmarshaler for AvroWriteSettings struct.
func (aws *AvroWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recordName":
			if v != nil {
				var recordName string
				err = json.Unmarshal(*v, &recordName)
				if err != nil {
					return err
				}
				aws.RecordName = &recordName
			}
		case "recordNamespace":
			if v != nil {
				var recordNamespace string
				err = json.Unmarshal(*v, &recordNamespace)
				if err != nil {
					return err
				}
				aws.RecordNamespace = &recordNamespace
			}
		case "maxRowsPerFile":
			if v != nil {
				var maxRowsPerFile interface{}
				err = json.Unmarshal(*v, &maxRowsPerFile)
				if err != nil {
					return err
				}
				aws.MaxRowsPerFile = maxRowsPerFile
			}
		case "fileNamePrefix":
			if v != nil {
				var fileNamePrefix interface{}
				err = json.Unmarshal(*v, &fileNamePrefix)
				if err != nil {
					return err
				}
				aws.FileNamePrefix = fileNamePrefix
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if aws.AdditionalProperties == nil {
					aws.AdditionalProperties = make(map[string]interface{})
				}
				aws.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFormatWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aws.Type = typeVar
			}
		}
	}

	return nil
}

// AzPowerShellSetup the express custom setup of installing Azure PowerShell.
type AzPowerShellSetup struct {
	// AzPowerShellSetupTypeProperties - Install Azure PowerShell type properties.
	*AzPowerShellSetupTypeProperties `json:"typeProperties,omitempty"`
	// Type - Possible values include: 'TypeBasicCustomSetupBaseTypeCustomSetupBase', 'TypeBasicCustomSetupBaseTypeAzPowerShellSetup', 'TypeBasicCustomSetupBaseTypeComponentSetup', 'TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup', 'TypeBasicCustomSetupBaseTypeCmdkeySetup'
	Type TypeBasicCustomSetupBase `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzPowerShellSetup.
func (apss AzPowerShellSetup) MarshalJSON() ([]byte, error) {
	apss.Type = TypeBasicCustomSetupBaseTypeAzPowerShellSetup
	objectMap := make(map[string]interface{})
	if apss.AzPowerShellSetupTypeProperties != nil {
		objectMap["typeProperties"] = apss.AzPowerShellSetupTypeProperties
	}
	if apss.Type != "" {
		objectMap["type"] = apss.Type
	}
	return json.Marshal(objectMap)
}

// AsAzPowerShellSetup is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsAzPowerShellSetup() (*AzPowerShellSetup, bool) {
	return &apss, true
}

// AsComponentSetup is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsComponentSetup() (*ComponentSetup, bool) {
	return nil, false
}

// AsEnvironmentVariableSetup is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsEnvironmentVariableSetup() (*EnvironmentVariableSetup, bool) {
	return nil, false
}

// AsCmdkeySetup is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsCmdkeySetup() (*CmdkeySetup, bool) {
	return nil, false
}

// AsCustomSetupBase is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsCustomSetupBase() (*CustomSetupBase, bool) {
	return nil, false
}

// AsBasicCustomSetupBase is the BasicCustomSetupBase implementation for AzPowerShellSetup.
func (apss AzPowerShellSetup) AsBasicCustomSetupBase() (BasicCustomSetupBase, bool) {
	return &apss, true
}

// UnmarshalJSON is the custom unmarshaler for AzPowerShellSetup struct.
func (apss *AzPowerShellSetup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azPowerShellSetupTypeProperties AzPowerShellSetupTypeProperties
				err = json.Unmarshal(*v, &azPowerShellSetupTypeProperties)
				if err != nil {
					return err
				}
				apss.AzPowerShellSetupTypeProperties = &azPowerShellSetupTypeProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCustomSetupBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apss.Type = typeVar
			}
		}
	}

	return nil
}

// AzPowerShellSetupTypeProperties installation of Azure PowerShell type properties.
type AzPowerShellSetupTypeProperties struct {
	// Version - The required version of Azure PowerShell to install.
	Version *string `json:"version,omitempty"`
}

// AzureBatchLinkedService azure Batch linked service.
type AzureBatchLinkedService struct {
	// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
	*AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	abls.Type = TypeBasicLinkedServiceTypeAzureBatch
	objectMap := make(map[string]interface{})
	if abls.AzureBatchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abls.AzureBatchLinkedServiceTypeProperties
	}
	if abls.ConnectVia != nil {
		objectMap["connectVia"] = abls.ConnectVia
	}
	if abls.Description != nil {
		objectMap["description"] = abls.Description
	}
	if abls.Parameters != nil {
		objectMap["parameters"] = abls.Parameters
	}
	if abls.Annotations != nil {
		objectMap["annotations"] = abls.Annotations
	}
	if abls.Type != "" {
		objectMap["type"] = abls.Type
	}
	for k, v := range abls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return &abls, true
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedService struct.
func (abls *AzureBatchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBatchLinkedServiceTypeProperties AzureBatchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBatchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abls.AzureBatchLinkedServiceTypeProperties = &azureBatchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abls.AdditionalProperties == nil {
					abls.AdditionalProperties = make(map[string]interface{})
				}
				abls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedServiceTypeProperties azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// AccountName - The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// AccessKey - The Azure Batch account access key.
	AccessKey BasicSecretBase `json:"accessKey,omitempty"`
	// BatchURI - The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI interface{} `json:"batchUri,omitempty"`
	// PoolName - The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName interface{} `json:"poolName,omitempty"`
	// LinkedServiceName - The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
	// Credential - The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedServiceTypeProperties struct.
func (ablstp *AzureBatchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				ablstp.AccountName = accountName
			}
		case "accessKey":
			if v != nil {
				accessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				ablstp.AccessKey = accessKey
			}
		case "batchUri":
			if v != nil {
				var batchURI interface{}
				err = json.Unmarshal(*v, &batchURI)
				if err != nil {
					return err
				}
				ablstp.BatchURI = batchURI
			}
		case "poolName":
			if v != nil {
				var poolName interface{}
				err = json.Unmarshal(*v, &poolName)
				if err != nil {
					return err
				}
				ablstp.PoolName = poolName
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ablstp.LinkedServiceName = &linkedServiceName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				ablstp.EncryptedCredential = encryptedCredential
			}
		case "credential":
			if v != nil {
				var credential CredentialReference
				err = json.Unmarshal(*v, &credential)
				if err != nil {
					return err
				}
				ablstp.Credential = &credential
			}
		}
	}

	return nil
}

// AzureBlobDataset the Azure Blob storage.
type AzureBlobDataset struct {
	// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
	*AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobDataset.
func (abd AzureBlobDataset) MarshalJSON() ([]byte, error) {
	abd.Type = TypeBasicDatasetTypeAzureBlob
	objectMap := make(map[string]interface{})
	if abd.AzureBlobDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abd.AzureBlobDatasetTypeProperties
	}
	if abd.Description != nil {
		objectMap["description"] = abd.Description
	}
	if abd.Structure != nil {
		objectMap["structure"] = abd.Structure
	}
	if abd.Schema != nil {
		objectMap["schema"] = abd.Schema
	}
	if abd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abd.LinkedServiceName
	}
	if abd.Parameters != nil {
		objectMap["parameters"] = abd.Parameters
	}
	if abd.Annotations != nil {
		objectMap["annotations"] = abd.Annotations
	}
	if abd.Folder != nil {
		objectMap["folder"] = abd.Folder
	}
	if abd.Type != "" {
		objectMap["type"] = abd.Type
	}
	for k, v := range abd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return &abd, true
}

// AsBinaryDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDataset struct.
func (abd *AzureBlobDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobDatasetTypeProperties AzureBlobDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobDatasetTypeProperties)
				if err != nil {
					return err
				}
				abd.AzureBlobDatasetTypeProperties = &azureBlobDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abd.AdditionalProperties == nil {
					abd.AdditionalProperties = make(map[string]interface{})
				}
				abd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobDatasetTypeProperties azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// TableRootLocation - The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation interface{} `json:"tableRootLocation,omitempty"`
	// FileName - The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// ModifiedDatetimeStart - The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of the Azure Blob storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDatasetTypeProperties struct.
func (abdtp *AzureBlobDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abdtp.FolderPath = folderPath
			}
		case "tableRootLocation":
			if v != nil {
				var tableRootLocation interface{}
				err = json.Unmarshal(*v, &tableRootLocation)
				if err != nil {
					return err
				}
				abdtp.TableRootLocation = tableRootLocation
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abdtp.FileName = fileName
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSDataset the Azure Data Lake Storage Gen2 storage.
type AzureBlobFSDataset struct {
	// AzureBlobFSDatasetTypeProperties - Azure Data Lake Storage Gen2 dataset properties.
	*AzureBlobFSDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) MarshalJSON() ([]byte, error) {
	abfd.Type = TypeBasicDatasetTypeAzureBlobFSFile
	objectMap := make(map[string]interface{})
	if abfd.AzureBlobFSDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abfd.AzureBlobFSDatasetTypeProperties
	}
	if abfd.Description != nil {
		objectMap["description"] = abfd.Description
	}
	if abfd.Structure != nil {
		objectMap["structure"] = abfd.Structure
	}
	if abfd.Schema != nil {
		objectMap["schema"] = abfd.Schema
	}
	if abfd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abfd.LinkedServiceName
	}
	if abfd.Parameters != nil {
		objectMap["parameters"] = abfd.Parameters
	}
	if abfd.Annotations != nil {
		objectMap["annotations"] = abfd.Annotations
	}
	if abfd.Folder != nil {
		objectMap["folder"] = abfd.Folder
	}
	if abfd.Type != "" {
		objectMap["type"] = abfd.Type
	}
	for k, v := range abfd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return &abfd, true
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abfd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDataset struct.
func (abfd *AzureBlobFSDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSDatasetTypeProperties AzureBlobFSDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSDatasetTypeProperties)
				if err != nil {
					return err
				}
				abfd.AzureBlobFSDatasetTypeProperties = &azureBlobFSDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfd.AdditionalProperties == nil {
					abfd.AdditionalProperties = make(map[string]interface{})
				}
				abfd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abfd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abfd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abfd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abfd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSDatasetTypeProperties azure Data Lake Storage Gen2 dataset properties.
type AzureBlobFSDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Azure Data Lake Storage Gen2 storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDatasetTypeProperties struct.
func (abfdtp *AzureBlobFSDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abfdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abfdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abfdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abfdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedService azure Data Lake Storage Gen2 linked service.
type AzureBlobFSLinkedService struct {
	// AzureBlobFSLinkedServiceTypeProperties - Azure Data Lake Storage Gen2 linked service properties.
	*AzureBlobFSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) MarshalJSON() ([]byte, error) {
	abfls.Type = TypeBasicLinkedServiceTypeAzureBlobFS
	objectMap := make(map[string]interface{})
	if abfls.AzureBlobFSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abfls.AzureBlobFSLinkedServiceTypeProperties
	}
	if abfls.ConnectVia != nil {
		objectMap["connectVia"] = abfls.ConnectVia
	}
	if abfls.Description != nil {
		objectMap["description"] = abfls.Description
	}
	if abfls.Parameters != nil {
		objectMap["parameters"] = abfls.Parameters
	}
	if abfls.Annotations != nil {
		objectMap["annotations"] = abfls.Annotations
	}
	if abfls.Type != "" {
		objectMap["type"] = abfls.Type
	}
	for k, v := range abfls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return &abfls, true
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abfls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedService struct.
func (abfls *AzureBlobFSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSLinkedServiceTypeProperties AzureBlobFSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abfls.AzureBlobFSLinkedServiceTypeProperties = &azureBlobFSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfls.AdditionalProperties == nil {
					abfls.AdditionalProperties = make(map[string]interface{})
				}
				abfls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abfls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedServiceTypeProperties azure Data Lake Storage Gen2 linked service properties.
type AzureBlobFSLinkedServiceTypeProperties struct {
	// URL - Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`
	// AccountKey - Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	AccountKey interface{} `json:"accountKey,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Storage Gen2 account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// AzureCloudType - Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
	// Credential - The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedServiceTypeProperties struct.
func (abflstp *AzureBlobFSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL interface{}
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				abflstp.URL = URL
			}
		case "accountKey":
			if v != nil {
				var accountKey interface{}
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abflstp.AccountKey = accountKey
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abflstp.Tenant = tenant
			}
		case "azureCloudType":
			if v != nil {
				var azureCloudType interface{}
				err = json.Unmarshal(*v, &azureCloudType)
				if err != nil {
					return err
				}
				abflstp.AzureCloudType = azureCloudType
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abflstp.EncryptedCredential = encryptedCredential
			}
		case "credential":
			if v != nil {
				var credential CredentialReference
				err = json.Unmarshal(*v, &credential)
				if err != nil {
					return err
				}
				abflstp.Credential = &credential
			}
		}
	}

	return nil
}

// AzureBlobFSLocation the location of azure blobFS dataset.
type AzureBlobFSLocation struct {
	// FileSystem - Specify the fileSystem of azure blobFS. Type: string (or Expression with resultType string).
	FileSystem interface{} `json:"fileSystem,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetLocationTypeDatasetLocation', 'TypeBasicDatasetLocationTypeHdfsLocation', 'TypeBasicDatasetLocationTypeHTTPServerLocation', 'TypeBasicDatasetLocationTypeSftpLocation', 'TypeBasicDatasetLocationTypeFtpServerLocation', 'TypeBasicDatasetLocationTypeGoogleCloudStorageLocation', 'TypeBasicDatasetLocationTypeOracleCloudStorageLocation', 'TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation', 'TypeBasicDatasetLocationTypeAzureFileStorageLocation', 'TypeBasicDatasetLocationTypeFileServerLocation', 'TypeBasicDatasetLocationTypeAmazonS3Location', 'TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation', 'TypeBasicDatasetLocationTypeAzureBlobFSLocation', 'TypeBasicDatasetLocationTypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) MarshalJSON() ([]byte, error) {
	abfl.Type = TypeBasicDatasetLocationTypeAzureBlobFSLocation
	objectMap := make(map[string]interface{})
	if abfl.FileSystem != nil {
		objectMap["fileSystem"] = abfl.FileSystem
	}
	if abfl.FolderPath != nil {
		objectMap["folderPath"] = abfl.FolderPath
	}
	if abfl.FileName != nil {
		objectMap["fileName"] = abfl.FileName
	}
	if abfl.Type != "" {
		objectMap["type"] = abfl.Type
	}
	for k, v := range abfl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsOracleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsOracleCloudStorageLocation() (*OracleCloudStorageLocation, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAmazonS3CompatibleLocation() (*AmazonS3CompatibleLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return &abfl, true
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &abfl, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLocation struct.
func (abfl *AzureBlobFSLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "fileSystem":
			if v != nil {
				var fileSystem interface{}
				err = json.Unmarshal(*v, &fileSystem)
				if err != nil {
					return err
				}
				abfl.FileSystem = fileSystem
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfl.AdditionalProperties == nil {
					abfl.AdditionalProperties = make(map[string]interface{})
				}
				abfl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abfl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abfl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfl.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSReadSettings azure blobFS read settings.
type AzureBlobFSReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - Azure blobFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - Azure blobFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// DeleteFilesAfterCompletion - Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreReadSettingsTypeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeHdfsReadSettings', 'TypeBasicStoreReadSettingsTypeHTTPReadSettings', 'TypeBasicStoreReadSettingsTypeSftpReadSettings', 'TypeBasicStoreReadSettingsTypeFtpReadSettings', 'TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings', 'TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings', 'TypeBasicStoreReadSettingsTypeFileServerReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings', 'TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) MarshalJSON() ([]byte, error) {
	abfrs.Type = TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings
	objectMap := make(map[string]interface{})
	if abfrs.Recursive != nil {
		objectMap["recursive"] = abfrs.Recursive
	}
	if abfrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = abfrs.WildcardFolderPath
	}
	if abfrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = abfrs.WildcardFileName
	}
	if abfrs.FileListPath != nil {
		objectMap["fileListPath"] = abfrs.FileListPath
	}
	if abfrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = abfrs.EnablePartitionDiscovery
	}
	if abfrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = abfrs.PartitionRootPath
	}
	if abfrs.DeleteFilesAfterCompletion != nil {
		objectMap["deleteFilesAfterCompletion"] = abfrs.DeleteFilesAfterCompletion
	}
	if abfrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = abfrs.ModifiedDatetimeStart
	}
	if abfrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = abfrs.ModifiedDatetimeEnd
	}
	if abfrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfrs.MaxConcurrentConnections
	}
	if abfrs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = abfrs.DisableMetricsCollection
	}
	if abfrs.Type != "" {
		objectMap["type"] = abfrs.Type
	}
	for k, v := range abfrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsOracleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsOracleCloudStorageReadSettings() (*OracleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAmazonS3CompatibleReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAmazonS3CompatibleReadSettings() (*AmazonS3CompatibleReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return &abfrs, true
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &abfrs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSReadSettings struct.
func (abfrs *AzureBlobFSReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				abfrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				abfrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				abfrs.WildcardFileName = wildcardFileName
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				abfrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				abfrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				abfrs.PartitionRootPath = partitionRootPath
			}
		case "deleteFilesAfterCompletion":
			if v != nil {
				var deleteFilesAfterCompletion interface{}
				err = json.Unmarshal(*v, &deleteFilesAfterCompletion)
				if err != nil {
					return err
				}
				abfrs.DeleteFilesAfterCompletion = deleteFilesAfterCompletion
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				abfrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				abfrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfrs.AdditionalProperties == nil {
					abfrs.AdditionalProperties = make(map[string]interface{})
				}
				abfrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				abfrs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfrs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSSink a copy activity Azure Data Lake Storage Gen2 sink.
type AzureBlobFSSink struct {
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Metadata - Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySinkTypeCopySink', 'TypeBasicCopySinkTypeCosmosDbMongoDbAPISink', 'TypeBasicCopySinkTypeMongoDbV2Sink', 'TypeBasicCopySinkTypeMongoDbAtlasSink', 'TypeBasicCopySinkTypeSalesforceServiceCloudSink', 'TypeBasicCopySinkTypeSalesforceSink', 'TypeBasicCopySinkTypeAzureDataExplorerSink', 'TypeBasicCopySinkTypeCommonDataServiceForAppsSink', 'TypeBasicCopySinkTypeDynamicsCrmSink', 'TypeBasicCopySinkTypeDynamicsSink', 'TypeBasicCopySinkTypeMicrosoftAccessSink', 'TypeBasicCopySinkTypeInformixSink', 'TypeBasicCopySinkTypeOdbcSink', 'TypeBasicCopySinkTypeAzureSearchIndexSink', 'TypeBasicCopySinkTypeAzureBlobFSSink', 'TypeBasicCopySinkTypeAzureDataLakeStoreSink', 'TypeBasicCopySinkTypeOracleSink', 'TypeBasicCopySinkTypeSnowflakeSink', 'TypeBasicCopySinkTypeSQLDWSink', 'TypeBasicCopySinkTypeSQLMISink', 'TypeBasicCopySinkTypeAzureSQLSink', 'TypeBasicCopySinkTypeSQLServerSink', 'TypeBasicCopySinkTypeSQLSink', 'TypeBasicCopySinkTypeCosmosDbSQLAPISink', 'TypeBasicCopySinkTypeDocumentDbCollectionSink', 'TypeBasicCopySinkTypeFileSystemSink', 'TypeBasicCopySinkTypeBlobSink', 'TypeBasicCopySinkTypeBinarySink', 'TypeBasicCopySinkTypeParquetSink', 'TypeBasicCopySinkTypeAvroSink', 'TypeBasicCopySinkTypeAzureTableSink', 'TypeBasicCopySinkTypeAzureQueueSink', 'TypeBasicCopySinkTypeSapCloudForCustomerSink', 'TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink', 'TypeBasicCopySinkTypeAzureMySQLSink', 'TypeBasicCopySinkTypeAzurePostgreSQLSink', 'TypeBasicCopySinkTypeRestSink', 'TypeBasicCopySinkTypeOrcSink', 'TypeBasicCopySinkTypeJSONSink', 'TypeBasicCopySinkTypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSink.
func (abfs AzureBlobFSSink) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeBasicCopySinkTypeAzureBlobFSSink
	objectMap := make(map[string]interface{})
	if abfs.CopyBehavior != nil {
		objectMap["copyBehavior"] = abfs.CopyBehavior
	}
	if abfs.Metadata != nil {
		objectMap["metadata"] = abfs.Metadata
	}
	if abfs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = abfs.WriteBatchSize
	}
	if abfs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = abfs.WriteBatchTimeout
	}
	if abfs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = abfs.SinkRetryCount
	}
	if abfs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = abfs.SinkRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = abfs.DisableMetricsCollection
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsMongoDbV2Sink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsMongoDbV2Sink() (*MongoDbV2Sink, bool) {
	return nil, false
}

// AsMongoDbAtlasSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsMongoDbAtlasSink() (*MongoDbAtlasSink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDatabricksDeltaLakeSink() (*AzureDatabricksDeltaLakeSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsRestSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsRestSink() (*RestSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSink struct.
func (abfs *AzureBlobFSSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				abfs.CopyBehavior = copyBehavior
			}
		case "metadata":
			if v != nil {
				var metadata []MetadataItem
				err = json.Unmarshal(*v, &metadata)
				if err != nil {
					return err
				}
				abfs.Metadata = &metadata
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				abfs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				abfs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				abfs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				abfs.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				abfs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSSource a copy activity Azure BlobFS source.
type AzureBlobFSSource struct {
	// TreatEmptyAsNull - Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
	// SkipHeaderLineCount - Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSource.
func (abfs AzureBlobFSSource) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeBasicCopySourceTypeAzureBlobFSSource
	objectMap := make(map[string]interface{})
	if abfs.TreatEmptyAsNull != nil {
		objectMap["treatEmptyAsNull"] = abfs.TreatEmptyAsNull
	}
	if abfs.SkipHeaderLineCount != nil {
		objectMap["skipHeaderLineCount"] = abfs.SkipHeaderLineCount
	}
	if abfs.Recursive != nil {
		objectMap["recursive"] = abfs.Recursive
	}
	if abfs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = abfs.SourceRetryCount
	}
	if abfs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = abfs.SourceRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = abfs.DisableMetricsCollection
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSource struct.
func (abfs *AzureBlobFSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "treatEmptyAsNull":
			if v != nil {
				var treatEmptyAsNull interface{}
				err = json.Unmarshal(*v, &treatEmptyAsNull)
				if err != nil {
					return err
				}
				abfs.TreatEmptyAsNull = treatEmptyAsNull
			}
		case "skipHeaderLineCount":
			if v != nil {
				var skipHeaderLineCount interface{}
				err = json.Unmarshal(*v, &skipHeaderLineCount)
				if err != nil {
					return err
				}
				abfs.SkipHeaderLineCount = skipHeaderLineCount
			}
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				abfs.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				abfs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				abfs.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				abfs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSWriteSettings azure blobFS write settings.
type AzureBlobFSWriteSettings struct {
	// BlockSizeInMB - Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreWriteSettingsTypeStoreWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings', 'TypeBasicStoreWriteSettingsTypeFileServerWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings', 'TypeBasicStoreWriteSettingsTypeSftpWriteSettings'
	Type TypeBasicStoreWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) MarshalJSON() ([]byte, error) {
	abfws.Type = TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings
	objectMap := make(map[string]interface{})
	if abfws.BlockSizeInMB != nil {
		objectMap["blockSizeInMB"] = abfws.BlockSizeInMB
	}
	if abfws.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfws.MaxConcurrentConnections
	}
	if abfws.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = abfws.DisableMetricsCollection
	}
	if abfws.CopyBehavior != nil {
		objectMap["copyBehavior"] = abfws.CopyBehavior
	}
	if abfws.Type != "" {
		objectMap["type"] = abfws.Type
	}
	for k, v := range abfws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFileStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureFileStorageWriteSettings() (*AzureFileStorageWriteSettings, bool) {
	return nil, false
}

// AsFileServerWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsFileServerWriteSettings() (*FileServerWriteSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureDataLakeStoreWriteSettings() (*AzureDataLakeStoreWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobFSWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureBlobFSWriteSettings() (*AzureBlobFSWriteSettings, bool) {
	return &abfws, true
}

// AsAzureBlobStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureBlobStorageWriteSettings() (*AzureBlobStorageWriteSettings, bool) {
	return nil, false
}

// AsSftpWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsSftpWriteSettings() (*SftpWriteSettings, bool) {
	return nil, false
}

// AsStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsStoreWriteSettings() (*StoreWriteSettings, bool) {
	return nil, false
}

// AsBasicStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsBasicStoreWriteSettings() (BasicStoreWriteSettings, bool) {
	return &abfws, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSWriteSettings struct.
func (abfws *AzureBlobFSWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "blockSizeInMB":
			if v != nil {
				var blockSizeInMB interface{}
				err = json.Unmarshal(*v, &blockSizeInMB)
				if err != nil {
					return err
				}
				abfws.BlockSizeInMB = blockSizeInMB
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfws.AdditionalProperties == nil {
					abfws.AdditionalProperties = make(map[string]interface{})
				}
				abfws.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfws.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				abfws.DisableMetricsCollection = disableMetricsCollection
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				abfws.CopyBehavior = copyBehavior
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedService the azure blob storage linked service.
type AzureBlobStorageLinkedService struct {
	// AzureBlobStorageLinkedServiceTypeProperties - Azure Blob Storage linked service properties.
	*AzureBlobStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) MarshalJSON() ([]byte, error) {
	absls.Type = TypeBasicLinkedServiceTypeAzureBlobStorage
	objectMap := make(map[string]interface{})
	if absls.AzureBlobStorageLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = absls.AzureBlobStorageLinkedServiceTypeProperties
	}
	if absls.ConnectVia != nil {
		objectMap["connectVia"] = absls.ConnectVia
	}
	if absls.Description != nil {
		objectMap["description"] = absls.Description
	}
	if absls.Parameters != nil {
		objectMap["parameters"] = absls.Parameters
	}
	if absls.Annotations != nil {
		objectMap["annotations"] = absls.Annotations
	}
	if absls.Type != "" {
		objectMap["type"] = absls.Type
	}
	for k, v := range absls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return &absls, true
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &absls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedService struct.
func (absls *AzureBlobStorageLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobStorageLinkedServiceTypeProperties AzureBlobStorageLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobStorageLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				absls.AzureBlobStorageLinkedServiceTypeProperties = &azureBlobStorageLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absls.AdditionalProperties == nil {
					absls.AdditionalProperties = make(map[string]interface{})
				}
				absls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				absls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				absls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				absls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				absls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedServiceTypeProperties azure Blob Storage linked service properties.
type AzureBlobStorageLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// AccountKey - The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`
	// SasURI - SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`
	// SasToken - The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`
	// ServiceEndpoint - Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// AzureCloudType - Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`
	// AccountKind - Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
	AccountKind *string `json:"accountKind,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *string `json:"encryptedCredential,omitempty"`
	// Credential - The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedServiceTypeProperties struct.
func (abslstp *AzureBlobStorageLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				abslstp.ConnectionString = connectionString
			}
		case "accountKey":
			if v != nil {
				var accountKey AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abslstp.AccountKey = &accountKey
			}
		case "sasUri":
			if v != nil {
				var sasURI interface{}
				err = json.Unmarshal(*v, &sasURI)
				if err != nil {
					return err
				}
				abslstp.SasURI = sasURI
			}
		case "sasToken":
			if v != nil {
				var sasToken AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &sasToken)
				if err != nil {
					return err
				}
				abslstp.SasToken = &sasToken
			}
		case "serviceEndpoint":
			if v != nil {
				var serviceEndpoint string
				err = json.Unmarshal(*v, &serviceEndpoint)
				if err != nil {
					return err
				}
				abslstp.ServiceEndpoint = &serviceEndpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abslstp.Tenant = tenant
			}
		case "azureCloudType":
			if v != nil {
				var azureCloudType interface{}
				err = json.Unmarshal(*v, &azureCloudType)
				if err != nil {
					return err
				}
				abslstp.AzureCloudType = azureCloudType
			}
		case "accountKind":
			if v != nil {
				var accountKind string
				err = json.Unmarshal(*v, &accountKind)
				if err != nil {
					return err
				}
				abslstp.AccountKind = &accountKind
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential string
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abslstp.EncryptedCredential = &encryptedCredential
			}
		case "credential":
			if v != nil {
				var credential CredentialReference
				err = json.Unmarshal(*v, &credential)
				if err != nil {
					return err
				}
				abslstp.Credential = &credential
			}
		}
	}

	return nil
}

// AzureBlobStorageLocation the location of azure blob dataset.
type AzureBlobStorageLocation struct {
	// Container - Specify the container of azure blob. Type: string (or Expression with resultType string).
	Container interface{} `json:"container,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetLocationTypeDatasetLocation', 'TypeBasicDatasetLocationTypeHdfsLocation', 'TypeBasicDatasetLocationTypeHTTPServerLocation', 'TypeBasicDatasetLocationTypeSftpLocation', 'TypeBasicDatasetLocationTypeFtpServerLocation', 'TypeBasicDatasetLocationTypeGoogleCloudStorageLocation', 'TypeBasicDatasetLocationTypeOracleCloudStorageLocation', 'TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation', 'TypeBasicDatasetLocationTypeAzureFileStorageLocation', 'TypeBasicDatasetLocationTypeFileServerLocation', 'TypeBasicDatasetLocationTypeAmazonS3Location', 'TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation', 'TypeBasicDatasetLocationTypeAzureBlobFSLocation', 'TypeBasicDatasetLocationTypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) MarshalJSON() ([]byte, error) {
	absl.Type = TypeBasicDatasetLocationTypeAzureBlobStorageLocation
	objectMap := make(map[string]interface{})
	if absl.Container != nil {
		objectMap["container"] = absl.Container
	}
	if absl.FolderPath != nil {
		objectMap["folderPath"] = absl.FolderPath
	}
	if absl.FileName != nil {
		objectMap["fileName"] = absl.FileName
	}
	if absl.Type != "" {
		objectMap["type"] = absl.Type
	}
	for k, v := range absl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsOracleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsOracleCloudStorageLocation() (*OracleCloudStorageLocation, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAmazonS3CompatibleLocation() (*AmazonS3CompatibleLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return &absl, true
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &absl, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLocation struct.
func (absl *AzureBlobStorageLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "container":
			if v != nil {
				var containerVar interface{}
				err = json.Unmarshal(*v, &containerVar)
				if err != nil {
					return err
				}
				absl.Container = containerVar
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absl.AdditionalProperties == nil {
					absl.AdditionalProperties = make(map[string]interface{})
				}
				absl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				absl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				absl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absl.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageReadSettings azure blob read settings.
type AzureBlobStorageReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - Azure blob wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - Azure blob wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// Prefix - The prefix filter for the Azure Blob name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// DeleteFilesAfterCompletion - Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreReadSettingsTypeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeHdfsReadSettings', 'TypeBasicStoreReadSettingsTypeHTTPReadSettings', 'TypeBasicStoreReadSettingsTypeSftpReadSettings', 'TypeBasicStoreReadSettingsTypeFtpReadSettings', 'TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings', 'TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings', 'TypeBasicStoreReadSettingsTypeFileServerReadSettings', 'TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings', 'TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings', 'TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) MarshalJSON() ([]byte, error) {
	absrs.Type = TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings
	objectMap := make(map[string]interface{})
	if absrs.Recursive != nil {
		objectMap["recursive"] = absrs.Recursive
	}
	if absrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = absrs.WildcardFolderPath
	}
	if absrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = absrs.WildcardFileName
	}
	if absrs.Prefix != nil {
		objectMap["prefix"] = absrs.Prefix
	}
	if absrs.FileListPath != nil {
		objectMap["fileListPath"] = absrs.FileListPath
	}
	if absrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = absrs.EnablePartitionDiscovery
	}
	if absrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = absrs.PartitionRootPath
	}
	if absrs.DeleteFilesAfterCompletion != nil {
		objectMap["deleteFilesAfterCompletion"] = absrs.DeleteFilesAfterCompletion
	}
	if absrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = absrs.ModifiedDatetimeStart
	}
	if absrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = absrs.ModifiedDatetimeEnd
	}
	if absrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = absrs.MaxConcurrentConnections
	}
	if absrs.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = absrs.DisableMetricsCollection
	}
	if absrs.Type != "" {
		objectMap["type"] = absrs.Type
	}
	for k, v := range absrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsOracleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsOracleCloudStorageReadSettings() (*OracleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAmazonS3CompatibleReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAmazonS3CompatibleReadSettings() (*AmazonS3CompatibleReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return &absrs, true
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &absrs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageReadSettings struct.
func (absrs *AzureBlobStorageReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				absrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				absrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				absrs.WildcardFileName = wildcardFileName
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				absrs.Prefix = prefix
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				absrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				absrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				absrs.PartitionRootPath = partitionRootPath
			}
		case "deleteFilesAfterCompletion":
			if v != nil {
				var deleteFilesAfterCompletion interface{}
				err = json.Unmarshal(*v, &deleteFilesAfterCompletion)
				if err != nil {
					return err
				}
				absrs.DeleteFilesAfterCompletion = deleteFilesAfterCompletion
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				absrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				absrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absrs.AdditionalProperties == nil {
					absrs.AdditionalProperties = make(map[string]interface{})
				}
				absrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				absrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				absrs.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absrs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageWriteSettings azure blob write settings.
type AzureBlobStorageWriteSettings struct {
	// BlockSizeInMB - Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Type - Possible values include: 'TypeBasicStoreWriteSettingsTypeStoreWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings', 'TypeBasicStoreWriteSettingsTypeFileServerWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings', 'TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings', 'TypeBasicStoreWriteSettingsTypeSftpWriteSettings'
	Type TypeBasicStoreWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) MarshalJSON() ([]byte, error) {
	absws.Type = TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings
	objectMap := make(map[string]interface{})
	if absws.BlockSizeInMB != nil {
		objectMap["blockSizeInMB"] = absws.BlockSizeInMB
	}
	if absws.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = absws.MaxConcurrentConnections
	}
	if absws.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = absws.DisableMetricsCollection
	}
	if absws.CopyBehavior != nil {
		objectMap["copyBehavior"] = absws.CopyBehavior
	}
	if absws.Type != "" {
		objectMap["type"] = absws.Type
	}
	for k, v := range absws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureFileStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureFileStorageWriteSettings() (*AzureFileStorageWriteSettings, bool) {
	return nil, false
}

// AsFileServerWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsFileServerWriteSettings() (*FileServerWriteSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureDataLakeStoreWriteSettings() (*AzureDataLakeStoreWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobFSWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureBlobFSWriteSettings() (*AzureBlobFSWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureBlobStorageWriteSettings() (*AzureBlobStorageWriteSettings, bool) {
	return &absws, true
}

// AsSftpWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsSftpWriteSettings() (*SftpWriteSettings, bool) {
	return nil, false
}

// AsStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsStoreWriteSettings() (*StoreWriteSettings, bool) {
	return nil, false
}

// AsBasicStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsBasicStoreWriteSettings() (BasicStoreWriteSettings, bool) {
	return &absws, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageWriteSettings struct.
func (absws *AzureBlobStorageWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "blockSizeInMB":
			if v != nil {
				var blockSizeInMB interface{}
				err = json.Unmarshal(*v, &blockSizeInMB)
				if err != nil {
					return err
				}
				absws.BlockSizeInMB = blockSizeInMB
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absws.AdditionalProperties == nil {
					absws.AdditionalProperties = make(map[string]interface{})
				}
				absws.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				absws.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				absws.DisableMetricsCollection = disableMetricsCollection
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				absws.CopyBehavior = copyBehavior
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeDataset azure Databricks Delta Lake dataset.
type AzureDatabricksDeltaLakeDataset struct {
	// AzureDatabricksDeltaLakeDatasetTypeProperties - Properties specific to this dataset type.
	*AzureDatabricksDeltaLakeDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) MarshalJSON() ([]byte, error) {
	addld.Type = TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset
	objectMap := make(map[string]interface{})
	if addld.AzureDatabricksDeltaLakeDatasetTypeProperties != nil {
		objectMap["typeProperties"] = addld.AzureDatabricksDeltaLakeDatasetTypeProperties
	}
	if addld.Description != nil {
		objectMap["description"] = addld.Description
	}
	if addld.Structure != nil {
		objectMap["structure"] = addld.Structure
	}
	if addld.Schema != nil {
		objectMap["schema"] = addld.Schema
	}
	if addld.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = addld.LinkedServiceName
	}
	if addld.Parameters != nil {
		objectMap["parameters"] = addld.Parameters
	}
	if addld.Annotations != nil {
		objectMap["annotations"] = addld.Annotations
	}
	if addld.Folder != nil {
		objectMap["folder"] = addld.Folder
	}
	if addld.Type != "" {
		objectMap["type"] = addld.Type
	}
	for k, v := range addld.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return &addld, true
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDatabricksDeltaLakeDataset.
func (addld AzureDatabricksDeltaLakeDataset) AsBasicDataset() (BasicDataset, bool) {
	return &addld, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeDataset struct.
func (addld *AzureDatabricksDeltaLakeDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksDeltaLakeDatasetTypeProperties AzureDatabricksDeltaLakeDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksDeltaLakeDatasetTypeProperties)
				if err != nil {
					return err
				}
				addld.AzureDatabricksDeltaLakeDatasetTypeProperties = &azureDatabricksDeltaLakeDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addld.AdditionalProperties == nil {
					addld.AdditionalProperties = make(map[string]interface{})
				}
				addld.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				addld.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				addld.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				addld.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				addld.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				addld.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				addld.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				addld.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addld.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeDatasetTypeProperties azure Databricks Delta Lake Dataset Properties
type AzureDatabricksDeltaLakeDatasetTypeProperties struct {
	// Table - The name of delta table. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
	// Database - The database name of delta table. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
}

// AzureDatabricksDeltaLakeExportCommand azure Databricks Delta Lake export command settings.
type AzureDatabricksDeltaLakeExportCommand struct {
	// DateFormat - Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat interface{} `json:"dateFormat,omitempty"`
	// TimestampFormat - Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	TimestampFormat interface{} `json:"timestampFormat,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - Possible values include: 'TypeBasicExportSettingsTypeExportSettings', 'TypeBasicExportSettingsTypeSnowflakeExportCopyCommand', 'TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand'
	Type TypeBasicExportSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeExportCommand.
func (addlec AzureDatabricksDeltaLakeExportCommand) MarshalJSON() ([]byte, error) {
	addlec.Type = TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand
	objectMap := make(map[string]interface{})
	if addlec.DateFormat != nil {
		objectMap["dateFormat"] = addlec.DateFormat
	}
	if addlec.TimestampFormat != nil {
		objectMap["timestampFormat"] = addlec.TimestampFormat
	}
	if addlec.Type != "" {
		objectMap["type"] = addlec.Type
	}
	for k, v := range addlec.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSnowflakeExportCopyCommand is the BasicExportSettings implementation for AzureDatabricksDeltaLakeExportCommand.
func (addlec AzureDatabricksDeltaLakeExportCommand) AsSnowflakeExportCopyCommand() (*SnowflakeExportCopyCommand, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeExportCommand is the BasicExportSettings implementation for AzureDatabricksDeltaLakeExportCommand.
func (addlec AzureDatabricksDeltaLakeExportCommand) AsAzureDatabricksDeltaLakeExportCommand() (*AzureDatabricksDeltaLakeExportCommand, bool) {
	return &addlec, true
}

// AsExportSettings is the BasicExportSettings implementation for AzureDatabricksDeltaLakeExportCommand.
func (addlec AzureDatabricksDeltaLakeExportCommand) AsExportSettings() (*ExportSettings, bool) {
	return nil, false
}

// AsBasicExportSettings is the BasicExportSettings implementation for AzureDatabricksDeltaLakeExportCommand.
func (addlec AzureDatabricksDeltaLakeExportCommand) AsBasicExportSettings() (BasicExportSettings, bool) {
	return &addlec, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeExportCommand struct.
func (addlec *AzureDatabricksDeltaLakeExportCommand) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dateFormat":
			if v != nil {
				var dateFormat interface{}
				err = json.Unmarshal(*v, &dateFormat)
				if err != nil {
					return err
				}
				addlec.DateFormat = dateFormat
			}
		case "timestampFormat":
			if v != nil {
				var timestampFormat interface{}
				err = json.Unmarshal(*v, &timestampFormat)
				if err != nil {
					return err
				}
				addlec.TimestampFormat = timestampFormat
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addlec.AdditionalProperties == nil {
					addlec.AdditionalProperties = make(map[string]interface{})
				}
				addlec.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicExportSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addlec.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeImportCommand azure Databricks Delta Lake import command settings.
type AzureDatabricksDeltaLakeImportCommand struct {
	// DateFormat - Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat interface{} `json:"dateFormat,omitempty"`
	// TimestampFormat - Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	TimestampFormat interface{} `json:"timestampFormat,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - Possible values include: 'TypeBasicImportSettingsTypeImportSettings', 'TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand', 'TypeBasicImportSettingsTypeSnowflakeImportCopyCommand'
	Type TypeBasicImportSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeImportCommand.
func (addlic AzureDatabricksDeltaLakeImportCommand) MarshalJSON() ([]byte, error) {
	addlic.Type = TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand
	objectMap := make(map[string]interface{})
	if addlic.DateFormat != nil {
		objectMap["dateFormat"] = addlic.DateFormat
	}
	if addlic.TimestampFormat != nil {
		objectMap["timestampFormat"] = addlic.TimestampFormat
	}
	if addlic.Type != "" {
		objectMap["type"] = addlic.Type
	}
	for k, v := range addlic.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeImportCommand is the BasicImportSettings implementation for AzureDatabricksDeltaLakeImportCommand.
func (addlic AzureDatabricksDeltaLakeImportCommand) AsAzureDatabricksDeltaLakeImportCommand() (*AzureDatabricksDeltaLakeImportCommand, bool) {
	return &addlic, true
}

// AsSnowflakeImportCopyCommand is the BasicImportSettings implementation for AzureDatabricksDeltaLakeImportCommand.
func (addlic AzureDatabricksDeltaLakeImportCommand) AsSnowflakeImportCopyCommand() (*SnowflakeImportCopyCommand, bool) {
	return nil, false
}

// AsImportSettings is the BasicImportSettings implementation for AzureDatabricksDeltaLakeImportCommand.
func (addlic AzureDatabricksDeltaLakeImportCommand) AsImportSettings() (*ImportSettings, bool) {
	return nil, false
}

// AsBasicImportSettings is the BasicImportSettings implementation for AzureDatabricksDeltaLakeImportCommand.
func (addlic AzureDatabricksDeltaLakeImportCommand) AsBasicImportSettings() (BasicImportSettings, bool) {
	return &addlic, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeImportCommand struct.
func (addlic *AzureDatabricksDeltaLakeImportCommand) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dateFormat":
			if v != nil {
				var dateFormat interface{}
				err = json.Unmarshal(*v, &dateFormat)
				if err != nil {
					return err
				}
				addlic.DateFormat = dateFormat
			}
		case "timestampFormat":
			if v != nil {
				var timestampFormat interface{}
				err = json.Unmarshal(*v, &timestampFormat)
				if err != nil {
					return err
				}
				addlic.TimestampFormat = timestampFormat
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addlic.AdditionalProperties == nil {
					addlic.AdditionalProperties = make(map[string]interface{})
				}
				addlic.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicImportSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addlic.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeLinkedService azure Databricks Delta Lake linked service.
type AzureDatabricksDeltaLakeLinkedService struct {
	// AzureDatabricksDetltaLakeLinkedServiceTypeProperties - Azure Databricks Delta Lake linked service properties.
	*AzureDatabricksDetltaLakeLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) MarshalJSON() ([]byte, error) {
	addlls.Type = TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake
	objectMap := make(map[string]interface{})
	if addlls.AzureDatabricksDetltaLakeLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = addlls.AzureDatabricksDetltaLakeLinkedServiceTypeProperties
	}
	if addlls.ConnectVia != nil {
		objectMap["connectVia"] = addlls.ConnectVia
	}
	if addlls.Description != nil {
		objectMap["description"] = addlls.Description
	}
	if addlls.Parameters != nil {
		objectMap["parameters"] = addlls.Parameters
	}
	if addlls.Annotations != nil {
		objectMap["annotations"] = addlls.Annotations
	}
	if addlls.Type != "" {
		objectMap["type"] = addlls.Type
	}
	for k, v := range addlls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return &addlls, true
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDatabricksDeltaLakeLinkedService.
func (addlls AzureDatabricksDeltaLakeLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &addlls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeLinkedService struct.
func (addlls *AzureDatabricksDeltaLakeLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksDetltaLakeLinkedServiceTypeProperties AzureDatabricksDetltaLakeLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksDetltaLakeLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				addlls.AzureDatabricksDetltaLakeLinkedServiceTypeProperties = &azureDatabricksDetltaLakeLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addlls.AdditionalProperties == nil {
					addlls.AdditionalProperties = make(map[string]interface{})
				}
				addlls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				addlls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				addlls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				addlls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				addlls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addlls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeSink a copy activity Azure Databricks Delta Lake sink.
type AzureDatabricksDeltaLakeSink struct {
	// PreCopyScript - SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`
	// ImportSettings - Azure Databricks Delta Lake import settings.
	ImportSettings *AzureDatabricksDeltaLakeImportCommand `json:"importSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySinkTypeCopySink', 'TypeBasicCopySinkTypeCosmosDbMongoDbAPISink', 'TypeBasicCopySinkTypeMongoDbV2Sink', 'TypeBasicCopySinkTypeMongoDbAtlasSink', 'TypeBasicCopySinkTypeSalesforceServiceCloudSink', 'TypeBasicCopySinkTypeSalesforceSink', 'TypeBasicCopySinkTypeAzureDataExplorerSink', 'TypeBasicCopySinkTypeCommonDataServiceForAppsSink', 'TypeBasicCopySinkTypeDynamicsCrmSink', 'TypeBasicCopySinkTypeDynamicsSink', 'TypeBasicCopySinkTypeMicrosoftAccessSink', 'TypeBasicCopySinkTypeInformixSink', 'TypeBasicCopySinkTypeOdbcSink', 'TypeBasicCopySinkTypeAzureSearchIndexSink', 'TypeBasicCopySinkTypeAzureBlobFSSink', 'TypeBasicCopySinkTypeAzureDataLakeStoreSink', 'TypeBasicCopySinkTypeOracleSink', 'TypeBasicCopySinkTypeSnowflakeSink', 'TypeBasicCopySinkTypeSQLDWSink', 'TypeBasicCopySinkTypeSQLMISink', 'TypeBasicCopySinkTypeAzureSQLSink', 'TypeBasicCopySinkTypeSQLServerSink', 'TypeBasicCopySinkTypeSQLSink', 'TypeBasicCopySinkTypeCosmosDbSQLAPISink', 'TypeBasicCopySinkTypeDocumentDbCollectionSink', 'TypeBasicCopySinkTypeFileSystemSink', 'TypeBasicCopySinkTypeBlobSink', 'TypeBasicCopySinkTypeBinarySink', 'TypeBasicCopySinkTypeParquetSink', 'TypeBasicCopySinkTypeAvroSink', 'TypeBasicCopySinkTypeAzureTableSink', 'TypeBasicCopySinkTypeAzureQueueSink', 'TypeBasicCopySinkTypeSapCloudForCustomerSink', 'TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink', 'TypeBasicCopySinkTypeAzureMySQLSink', 'TypeBasicCopySinkTypeAzurePostgreSQLSink', 'TypeBasicCopySinkTypeRestSink', 'TypeBasicCopySinkTypeOrcSink', 'TypeBasicCopySinkTypeJSONSink', 'TypeBasicCopySinkTypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) MarshalJSON() ([]byte, error) {
	addls.Type = TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink
	objectMap := make(map[string]interface{})
	if addls.PreCopyScript != nil {
		objectMap["preCopyScript"] = addls.PreCopyScript
	}
	if addls.ImportSettings != nil {
		objectMap["importSettings"] = addls.ImportSettings
	}
	if addls.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = addls.WriteBatchSize
	}
	if addls.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = addls.WriteBatchTimeout
	}
	if addls.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = addls.SinkRetryCount
	}
	if addls.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = addls.SinkRetryWait
	}
	if addls.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = addls.MaxConcurrentConnections
	}
	if addls.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = addls.DisableMetricsCollection
	}
	if addls.Type != "" {
		objectMap["type"] = addls.Type
	}
	for k, v := range addls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsMongoDbV2Sink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsMongoDbV2Sink() (*MongoDbV2Sink, bool) {
	return nil, false
}

// AsMongoDbAtlasSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsMongoDbAtlasSink() (*MongoDbAtlasSink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureDatabricksDeltaLakeSink() (*AzureDatabricksDeltaLakeSink, bool) {
	return &addls, true
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsRestSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsRestSink() (*RestSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDatabricksDeltaLakeSink.
func (addls AzureDatabricksDeltaLakeSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &addls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeSink struct.
func (addls *AzureDatabricksDeltaLakeSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "preCopyScript":
			if v != nil {
				var preCopyScript interface{}
				err = json.Unmarshal(*v, &preCopyScript)
				if err != nil {
					return err
				}
				addls.PreCopyScript = preCopyScript
			}
		case "importSettings":
			if v != nil {
				var importSettings AzureDatabricksDeltaLakeImportCommand
				err = json.Unmarshal(*v, &importSettings)
				if err != nil {
					return err
				}
				addls.ImportSettings = &importSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addls.AdditionalProperties == nil {
					addls.AdditionalProperties = make(map[string]interface{})
				}
				addls.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				addls.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				addls.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				addls.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				addls.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				addls.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				addls.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDeltaLakeSource a copy activity Azure Databricks Delta Lake source.
type AzureDatabricksDeltaLakeSource struct {
	// Query - Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// ExportSettings - Azure Databricks Delta Lake export settings.
	ExportSettings *AzureDatabricksDeltaLakeExportCommand `json:"exportSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) MarshalJSON() ([]byte, error) {
	addls.Type = TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource
	objectMap := make(map[string]interface{})
	if addls.Query != nil {
		objectMap["query"] = addls.Query
	}
	if addls.ExportSettings != nil {
		objectMap["exportSettings"] = addls.ExportSettings
	}
	if addls.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = addls.SourceRetryCount
	}
	if addls.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = addls.SourceRetryWait
	}
	if addls.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = addls.MaxConcurrentConnections
	}
	if addls.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = addls.DisableMetricsCollection
	}
	if addls.Type != "" {
		objectMap["type"] = addls.Type
	}
	for k, v := range addls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return &addls, true
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDatabricksDeltaLakeSource.
func (addls AzureDatabricksDeltaLakeSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &addls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDeltaLakeSource struct.
func (addls *AzureDatabricksDeltaLakeSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				addls.Query = query
			}
		case "exportSettings":
			if v != nil {
				var exportSettings AzureDatabricksDeltaLakeExportCommand
				err = json.Unmarshal(*v, &exportSettings)
				if err != nil {
					return err
				}
				addls.ExportSettings = &exportSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if addls.AdditionalProperties == nil {
					addls.AdditionalProperties = make(map[string]interface{})
				}
				addls.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				addls.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				addls.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				addls.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				addls.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				addls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksDetltaLakeLinkedServiceTypeProperties azure Databricks Delta Lake linked service
// properties.
type AzureDatabricksDetltaLakeLinkedServiceTypeProperties struct {
	// Domain - <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
	Domain interface{} `json:"domain,omitempty"`
	// AccessToken - Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
	AccessToken BasicSecretBase `json:"accessToken,omitempty"`
	// ClusterID - The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
	ClusterID interface{} `json:"clusterId,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksDetltaLakeLinkedServiceTypeProperties struct.
func (addllstp *AzureDatabricksDetltaLakeLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "domain":
			if v != nil {
				var domain interface{}
				err = json.Unmarshal(*v, &domain)
				if err != nil {
					return err
				}
				addllstp.Domain = domain
			}
		case "accessToken":
			if v != nil {
				accessToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				addllstp.AccessToken = accessToken
			}
		case "clusterId":
			if v != nil {
				var clusterID interface{}
				err = json.Unmarshal(*v, &clusterID)
				if err != nil {
					return err
				}
				addllstp.ClusterID = clusterID
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				addllstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedService azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
	*AzureDatabricksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) MarshalJSON() ([]byte, error) {
	adls.Type = TypeBasicLinkedServiceTypeAzureDatabricks
	objectMap := make(map[string]interface{})
	if adls.AzureDatabricksLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adls.AzureDatabricksLinkedServiceTypeProperties
	}
	if adls.ConnectVia != nil {
		objectMap["connectVia"] = adls.ConnectVia
	}
	if adls.Description != nil {
		objectMap["description"] = adls.Description
	}
	if adls.Parameters != nil {
		objectMap["parameters"] = adls.Parameters
	}
	if adls.Annotations != nil {
		objectMap["annotations"] = adls.Annotations
	}
	if adls.Type != "" {
		objectMap["type"] = adls.Type
	}
	for k, v := range adls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return &adls, true
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedService struct.
func (adls *AzureDatabricksLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksLinkedServiceTypeProperties AzureDatabricksLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adls.AzureDatabricksLinkedServiceTypeProperties = &azureDatabricksLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adls.AdditionalProperties == nil {
					adls.AdditionalProperties = make(map[string]interface{})
				}
				adls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedServiceTypeProperties azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// Domain - <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
	Domain interface{} `json:"domain,omitempty"`
	// AccessToken - Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
	AccessToken BasicSecretBase `json:"accessToken,omitempty"`
	// Authentication - Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	Authentication interface{} `json:"authentication,omitempty"`
	// WorkspaceResourceID - Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	WorkspaceResourceID interface{} `json:"workspaceResourceId,omitempty"`
	// ExistingClusterID - The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string).
	ExistingClusterID interface{} `json:"existingClusterId,omitempty"`
	// InstancePoolID - The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string).
	InstancePoolID interface{} `json:"instancePoolId,omitempty"`
	// NewClusterVersion - If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string).
	NewClusterVersion interface{} `json:"newClusterVersion,omitempty"`
	// NewClusterNumOfWorker - If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker interface{} `json:"newClusterNumOfWorker,omitempty"`
	// NewClusterNodeType - The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string).
	NewClusterNodeType interface{} `json:"newClusterNodeType,omitempty"`
	// NewClusterSparkConf - A set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]interface{} `json:"newClusterSparkConf"`
	// NewClusterSparkEnvVars - A set of optional, user-specified Spark environment variables key-value pairs.
	NewClusterSparkEnvVars map[string]interface{} `json:"newClusterSparkEnvVars"`
	// NewClusterCustomTags - Additional tags for cluster resources. This property is ignored in instance pool configurations.
	NewClusterCustomTags map[string]interface{} `json:"newClusterCustomTags"`
	// NewClusterLogDestination - Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
	NewClusterLogDestination interface{} `json:"newClusterLogDestination,omitempty"`
	// NewClusterDriverNodeType - The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string).
	NewClusterDriverNodeType interface{} `json:"newClusterDriverNodeType,omitempty"`
	// NewClusterInitScripts - User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
	NewClusterInitScripts interface{} `json:"newClusterInitScripts,omitempty"`
	// NewClusterEnableElasticDisk - Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean).
	NewClusterEnableElasticDisk interface{} `json:"newClusterEnableElasticDisk,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
	// PolicyID - The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression with resultType string).
	PolicyID interface{} `json:"policyId,omitempty"`
	// Credential - The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedServiceTypeProperties.
func (adlstp AzureDatabricksLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlstp.Domain != nil {
		objectMap["domain"] = adlstp.Domain
	}
	objectMap["accessToken"] = adlstp.AccessToken
	if adlstp.Authentication != nil {
		objectMap["authentication"] = adlstp.Authentication
	}
	if adlstp.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = adlstp.WorkspaceResourceID
	}
	if adlstp.ExistingClusterID != nil {
		objectMap["existingClusterId"] = adlstp.ExistingClusterID
	}
	if adlstp.InstancePoolID != nil {
		objectMap["instancePoolId"] = adlstp.InstancePoolID
	}
	if adlstp.NewClusterVersion != nil {
		objectMap["newClusterVersion"] = adlstp.NewClusterVersion
	}
	if adlstp.NewClusterNumOfWorker != nil {
		objectMap["newClusterNumOfWorker"] = adlstp.NewClusterNumOfWorker
	}
	if adlstp.NewClusterNodeType != nil {
		objectMap["newClusterNodeType"] = adlstp.NewClusterNodeType
	}
	if adlstp.NewClusterSparkConf != nil {
		objectMap["newClusterSparkConf"] = adlstp.NewClusterSparkConf
	}
	if adlstp.NewClusterSparkEnvVars != nil {
		objectMap["newClusterSparkEnvVars"] = adlstp.NewClusterSparkEnvVars
	}
	if adlstp.NewClusterCustomTags != nil {
		objectMap["newClusterCustomTags"] = adlstp.NewClusterCustomTags
	}
	if adlstp.NewClusterLogDestination != nil {
		objectMap["newClusterLogDestination"] = adlstp.NewClusterLogDestination
	}
	if adlstp.NewClusterDriverNodeType != nil {
		objectMap["newClusterDriverNodeType"] = adlstp.NewClusterDriverNodeType
	}
	if adlstp.NewClusterInitScripts != nil {
		objectMap["newClusterInitScripts"] = adlstp.NewClusterInitScripts
	}
	if adlstp.NewClusterEnableElasticDisk != nil {
		objectMap["newClusterEnableElasticDisk"] = adlstp.NewClusterEnableElasticDisk
	}
	if adlstp.EncryptedCredential != nil {
		objectMap["encryptedCredential"] = adlstp.EncryptedCredential
	}
	if adlstp.PolicyID != nil {
		objectMap["policyId"] = adlstp.PolicyID
	}
	if adlstp.Credential != nil {
		objectMap["credential"] = adlstp.Credential
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedServiceTypeProperties struct.
func (adlstp *AzureDatabricksLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "domain":
			if v != nil {
				var domain interface{}
				err = json.Unmarshal(*v, &domain)
				if err != nil {
					return err
				}
				adlstp.Domain = domain
			}
		case "accessToken":
			if v != nil {
				accessToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlstp.AccessToken = accessToken
			}
		case "authentication":
			if v != nil {
				var authentication interface{}
				err = json.Unmarshal(*v, &authentication)
				if err != nil {
					return err
				}
				adlstp.Authentication = authentication
			}
		case "workspaceResourceId":
			if v != nil {
				var workspaceResourceID interface{}
				err = json.Unmarshal(*v, &workspaceResourceID)
				if err != nil {
					return err
				}
				adlstp.WorkspaceResourceID = workspaceResourceID
			}
		case "existingClusterId":
			if v != nil {
				var existingClusterID interface{}
				err = json.Unmarshal(*v, &existingClusterID)
				if err != nil {
					return err
				}
				adlstp.ExistingClusterID = existingClusterID
			}
		case "instancePoolId":
			if v != nil {
				var instancePoolID interface{}
				err = json.Unmarshal(*v, &instancePoolID)
				if err != nil {
					return err
				}
				adlstp.InstancePoolID = instancePoolID
			}
		case "newClusterVersion":
			if v != nil {
				var newClusterVersion interface{}
				err = json.Unmarshal(*v, &newClusterVersion)
				if err != nil {
					return err
				}
				adlstp.NewClusterVersion = newClusterVersion
			}
		case "newClusterNumOfWorker":
			if v != nil {
				var newClusterNumOfWorker interface{}
				err = json.Unmarshal(*v, &newClusterNumOfWorker)
				if err != nil {
					return err
				}
				adlstp.NewClusterNumOfWorker = newClusterNumOfWorker
			}
		case "newClusterNodeType":
			if v != nil {
				var newClusterNodeType interface{}
				err = json.Unmarshal(*v, &newClusterNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterNodeType = newClusterNodeType
			}
		case "newClusterSparkConf":
			if v != nil {
				var newClusterSparkConf map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkConf)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkConf = newClusterSparkConf
			}
		case "newClusterSparkEnvVars":
			if v != nil {
				var newClusterSparkEnvVars map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkEnvVars)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkEnvVars = newClusterSparkEnvVars
			}
		case "newClusterCustomTags":
			if v != nil {
				var newClusterCustomTags map[string]interface{}
				err = json.Unmarshal(*v, &newClusterCustomTags)
				if err != nil {
					return err
				}
				adlstp.NewClusterCustomTags = newClusterCustomTags
			}
		case "newClusterLogDestination":
			if v != nil {
				var newClusterLogDestination interface{}
				err = json.Unmarshal(*v, &newClusterLogDestination)
				if err != nil {
					return err
				}
				adlstp.NewClusterLogDestination = newClusterLogDestination
			}
		case "newClusterDriverNodeType":
			if v != nil {
				var newClusterDriverNodeType interface{}
				err = json.Unmarshal(*v, &newClusterDriverNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterDriverNodeType = newClusterDriverNodeType
			}
		case "newClusterInitScripts":
			if v != nil {
				var newClusterInitScripts interface{}
				err = json.Unmarshal(*v, &newClusterInitScripts)
				if err != nil {
					return err
				}
				adlstp.NewClusterInitScripts = newClusterInitScripts
			}
		case "newClusterEnableElasticDisk":
			if v != nil {
				var newClusterEnableElasticDisk interface{}
				err = json.Unmarshal(*v, &newClusterEnableElasticDisk)
				if err != nil {
					return err
				}
				adlstp.NewClusterEnableElasticDisk = newClusterEnableElasticDisk
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlstp.EncryptedCredential = encryptedCredential
			}
		case "policyId":
			if v != nil {
				var policyID interface{}
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				adlstp.PolicyID = policyID
			}
		case "credential":
			if v != nil {
				var credential CredentialReference
				err = json.Unmarshal(*v, &credential)
				if err != nil {
					return err
				}
				adlstp.Credential = &credential
			}
		}
	}

	return nil
}

// AzureDataExplorerCommandActivity azure Data Explorer command activity.
type AzureDataExplorerCommandActivity struct {
	// AzureDataExplorerCommandActivityTypeProperties - Azure Data Explorer command activity properties.
	*AzureDataExplorerCommandActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeBasicActivityTypeActivity', 'TypeBasicActivityTypeExecuteDataFlow', 'TypeBasicActivityTypeAzureFunctionActivity', 'TypeBasicActivityTypeDatabricksSparkPython', 'TypeBasicActivityTypeDatabricksSparkJar', 'TypeBasicActivityTypeDatabricksNotebook', 'TypeBasicActivityTypeDataLakeAnalyticsUSQL', 'TypeBasicActivityTypeAzureMLExecutePipeline', 'TypeBasicActivityTypeAzureMLUpdateResource', 'TypeBasicActivityTypeAzureMLBatchExecution', 'TypeBasicActivityTypeGetMetadata', 'TypeBasicActivityTypeWebActivity', 'TypeBasicActivityTypeLookup', 'TypeBasicActivityTypeAzureDataExplorerCommand', 'TypeBasicActivityTypeDelete', 'TypeBasicActivityTypeSQLServerStoredProcedure', 'TypeBasicActivityTypeCustom', 'TypeBasicActivityTypeExecuteSSISPackage', 'TypeBasicActivityTypeHDInsightSpark', 'TypeBasicActivityTypeHDInsightStreaming', 'TypeBasicActivityTypeHDInsightMapReduce', 'TypeBasicActivityTypeHDInsightPig', 'TypeBasicActivityTypeHDInsightHive', 'TypeBasicActivityTypeCopy', 'TypeBasicActivityTypeExecution', 'TypeBasicActivityTypeWebHook', 'TypeBasicActivityTypeAppendVariable', 'TypeBasicActivityTypeSetVariable', 'TypeBasicActivityTypeFilter', 'TypeBasicActivityTypeValidation', 'TypeBasicActivityTypeUntil', 'TypeBasicActivityTypeWait', 'TypeBasicActivityTypeForEach', 'TypeBasicActivityTypeSwitch', 'TypeBasicActivityTypeIfCondition', 'TypeBasicActivityTypeExecutePipeline', 'TypeBasicActivityTypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) MarshalJSON() ([]byte, error) {
	adeca.Type = TypeBasicActivityTypeAzureDataExplorerCommand
	objectMap := make(map[string]interface{})
	if adeca.AzureDataExplorerCommandActivityTypeProperties != nil {
		objectMap["typeProperties"] = adeca.AzureDataExplorerCommandActivityTypeProperties
	}
	if adeca.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adeca.LinkedServiceName
	}
	if adeca.Policy != nil {
		objectMap["policy"] = adeca.Policy
	}
	if adeca.Name != nil {
		objectMap["name"] = adeca.Name
	}
	if adeca.Description != nil {
		objectMap["description"] = adeca.Description
	}
	if adeca.DependsOn != nil {
		objectMap["dependsOn"] = adeca.DependsOn
	}
	if adeca.UserProperties != nil {
		objectMap["userProperties"] = adeca.UserProperties
	}
	if adeca.Type != "" {
		objectMap["type"] = adeca.Type
	}
	for k, v := range adeca.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return &adeca, true
}

// AsDeleteActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &adeca, true
}

// AsWebHookActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicActivity() (BasicActivity, bool) {
	return &adeca, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerCommandActivity struct.
func (adeca *AzureDataExplorerCommandActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerCommandActivityTypeProperties AzureDataExplorerCommandActivityTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerCommandActivityTypeProperties)
				if err != nil {
					return err
				}
				adeca.AzureDataExplorerCommandActivityTypeProperties = &azureDataExplorerCommandActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adeca.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				adeca.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adeca.AdditionalProperties == nil {
					adeca.AdditionalProperties = make(map[string]interface{})
				}
				adeca.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adeca.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adeca.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				adeca.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				adeca.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adeca.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerCommandActivityTypeProperties azure Data Explorer command activity properties.
type AzureDataExplorerCommandActivityTypeProperties struct {
	// Command - A control command, according to the Azure Data Explorer command syntax. Type: string (or Expression with resultType string).
	Command interface{} `json:"command,omitempty"`
	// CommandTimeout - Control command timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..)
	CommandTimeout interface{} `json:"commandTimeout,omitempty"`
}

// AzureDataExplorerDatasetTypeProperties azure Data Explorer (Kusto) dataset properties.
type AzureDataExplorerDatasetTypeProperties struct {
	// Table - The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AzureDataExplorerLinkedService azure Data Explorer (Kusto) linked service.
type AzureDataExplorerLinkedService struct {
	// AzureDataExplorerLinkedServiceTypeProperties - Azure Data Explorer (Kusto) linked service properties.
	*AzureDataExplorerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) MarshalJSON() ([]byte, error) {
	adels.Type = TypeBasicLinkedServiceTypeAzureDataExplorer
	objectMap := make(map[string]interface{})
	if adels.AzureDataExplorerLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adels.AzureDataExplorerLinkedServiceTypeProperties
	}
	if adels.ConnectVia != nil {
		objectMap["connectVia"] = adels.ConnectVia
	}
	if adels.Description != nil {
		objectMap["description"] = adels.Description
	}
	if adels.Parameters != nil {
		objectMap["parameters"] = adels.Parameters
	}
	if adels.Annotations != nil {
		objectMap["annotations"] = adels.Annotations
	}
	if adels.Type != "" {
		objectMap["type"] = adels.Type
	}
	for k, v := range adels.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return &adels, true
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbAtlasLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbAtlasLinkedService() (*MongoDbAtlasLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsOracleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleCloudStorageLinkedService() (*OracleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAmazonS3CompatibleLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonS3CompatibleLinkedService() (*AmazonS3CompatibleLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adels, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedService struct.
func (adels *AzureDataExplorerLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerLinkedServiceTypeProperties AzureDataExplorerLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adels.AzureDataExplorerLinkedServiceTypeProperties = &azureDataExplorerLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adels.AdditionalProperties == nil {
					adels.AdditionalProperties = make(map[string]interface{})
				}
				adels.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adels.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adels.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adels.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adels.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adels.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerLinkedServiceTypeProperties azure Data Explorer (Kusto) linked service properties.
type AzureDataExplorerLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://<clusterName>.<regionName>.kusto.windows.net. Type: string (or Expression with resultType string)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Kusto.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Database - Database name for connection. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// Credential - The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedServiceTypeProperties struct.
func (adelstp *AzureDataExplorerLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				adelstp.Endpoint = endpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				adelstp.Database = databaseVar
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adelstp.Tenant = tenant
			}
		case "credential":
			if v != nil {
				var credential CredentialReference
				err = json.Unmarshal(*v, &credential)
				if err != nil {
					return err
				}
				adelstp.Credential = &credential
			}
		}
	}

	return nil
}

// AzureDataExplorerSink a copy activity Azure Data Explorer sink.
type AzureDataExplorerSink struct {
	// IngestionMappingName - A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
	IngestionMappingName interface{} `json:"ingestionMappingName,omitempty"`
	// IngestionMappingAsJSON - An explicit column mapping description provided in a json format. Type: string.
	IngestionMappingAsJSON interface{} `json:"ingestionMappingAsJson,omitempty"`
	// FlushImmediately - If set to true, any aggregation will be skipped. Default is false. Type: boolean.
	FlushImmediately interface{} `json:"flushImmediately,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySinkTypeCopySink', 'TypeBasicCopySinkTypeCosmosDbMongoDbAPISink', 'TypeBasicCopySinkTypeMongoDbV2Sink', 'TypeBasicCopySinkTypeMongoDbAtlasSink', 'TypeBasicCopySinkTypeSalesforceServiceCloudSink', 'TypeBasicCopySinkTypeSalesforceSink', 'TypeBasicCopySinkTypeAzureDataExplorerSink', 'TypeBasicCopySinkTypeCommonDataServiceForAppsSink', 'TypeBasicCopySinkTypeDynamicsCrmSink', 'TypeBasicCopySinkTypeDynamicsSink', 'TypeBasicCopySinkTypeMicrosoftAccessSink', 'TypeBasicCopySinkTypeInformixSink', 'TypeBasicCopySinkTypeOdbcSink', 'TypeBasicCopySinkTypeAzureSearchIndexSink', 'TypeBasicCopySinkTypeAzureBlobFSSink', 'TypeBasicCopySinkTypeAzureDataLakeStoreSink', 'TypeBasicCopySinkTypeOracleSink', 'TypeBasicCopySinkTypeSnowflakeSink', 'TypeBasicCopySinkTypeSQLDWSink', 'TypeBasicCopySinkTypeSQLMISink', 'TypeBasicCopySinkTypeAzureSQLSink', 'TypeBasicCopySinkTypeSQLServerSink', 'TypeBasicCopySinkTypeSQLSink', 'TypeBasicCopySinkTypeCosmosDbSQLAPISink', 'TypeBasicCopySinkTypeDocumentDbCollectionSink', 'TypeBasicCopySinkTypeFileSystemSink', 'TypeBasicCopySinkTypeBlobSink', 'TypeBasicCopySinkTypeBinarySink', 'TypeBasicCopySinkTypeParquetSink', 'TypeBasicCopySinkTypeAvroSink', 'TypeBasicCopySinkTypeAzureTableSink', 'TypeBasicCopySinkTypeAzureQueueSink', 'TypeBasicCopySinkTypeSapCloudForCustomerSink', 'TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink', 'TypeBasicCopySinkTypeAzureMySQLSink', 'TypeBasicCopySinkTypeAzurePostgreSQLSink', 'TypeBasicCopySinkTypeRestSink', 'TypeBasicCopySinkTypeOrcSink', 'TypeBasicCopySinkTypeJSONSink', 'TypeBasicCopySinkTypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) MarshalJSON() ([]byte, error) {
	ades.Type = TypeBasicCopySinkTypeAzureDataExplorerSink
	objectMap := make(map[string]interface{})
	if ades.IngestionMappingName != nil {
		objectMap["ingestionMappingName"] = ades.IngestionMappingName
	}
	if ades.IngestionMappingAsJSON != nil {
		objectMap["ingestionMappingAsJson"] = ades.IngestionMappingAsJSON
	}
	if ades.FlushImmediately != nil {
		objectMap["flushImmediately"] = ades.FlushImmediately
	}
	if ades.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = ades.WriteBatchSize
	}
	if ades.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = ades.WriteBatchTimeout
	}
	if ades.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = ades.SinkRetryCount
	}
	if ades.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = ades.SinkRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = ades.DisableMetricsCollection
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsMongoDbV2Sink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsMongoDbV2Sink() (*MongoDbV2Sink, bool) {
	return nil, false
}

// AsMongoDbAtlasSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsMongoDbAtlasSink() (*MongoDbAtlasSink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return &ades, true
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDatabricksDeltaLakeSink() (*AzureDatabricksDeltaLakeSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsRestSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsRestSink() (*RestSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSink struct.
func (ades *AzureDataExplorerSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ingestionMappingName":
			if v != nil {
				var ingestionMappingName interface{}
				err = json.Unmarshal(*v, &ingestionMappingName)
				if err != nil {
					return err
				}
				ades.IngestionMappingName = ingestionMappingName
			}
		case "ingestionMappingAsJson":
			if v != nil {
				var ingestionMappingAsJSON interface{}
				err = json.Unmarshal(*v, &ingestionMappingAsJSON)
				if err != nil {
					return err
				}
				ades.IngestionMappingAsJSON = ingestionMappingAsJSON
			}
		case "flushImmediately":
			if v != nil {
				var flushImmediately interface{}
				err = json.Unmarshal(*v, &flushImmediately)
				if err != nil {
					return err
				}
				ades.FlushImmediately = flushImmediately
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				ades.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				ades.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				ades.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				ades.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				ades.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerSource a copy activity Azure Data Explorer (Kusto) source.
type AzureDataExplorerSource struct {
	// Query - Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// NoTruncation - The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count limit.
	NoTruncation interface{} `json:"noTruncation,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// DisableMetricsCollection - If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`
	// Type - Possible values include: 'TypeBasicCopySourceTypeCopySource', 'TypeBasicCopySourceTypeSharePointOnlineListSource', 'TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource', 'TypeBasicCopySourceTypeSnowflakeSource', 'TypeBasicCopySourceTypeHTTPSource', 'TypeBasicCopySourceTypeAzureBlobFSSource', 'TypeBasicCopySourceTypeAzureDataLakeStoreSource', 'TypeBasicCopySourceTypeOffice365Source', 'TypeBasicCopySourceTypeCosmosDbMongoDbAPISource', 'TypeBasicCopySourceTypeMongoDbV2Source', 'TypeBasicCopySourceTypeMongoDbAtlasSource', 'TypeBasicCopySourceTypeMongoDbSource', 'TypeBasicCopySourceTypeWebSource', 'TypeBasicCopySourceTypeOracleSource', 'TypeBasicCopySourceTypeAzureDataExplorerSource', 'TypeBasicCopySourceTypeHdfsSource', 'TypeBasicCopySourceTypeFileSystemSource', 'TypeBasicCopySourceTypeRestSource', 'TypeBasicCopySourceTypeSalesforceServiceCloudSource', 'TypeBasicCopySourceTypeODataSource', 'TypeBasicCopySourceTypeMicrosoftAccessSource', 'TypeBasicCopySourceTypeRelationalSource', 'TypeBasicCopySourceTypeCommonDataServiceForAppsSource', 'TypeBasicCopySourceTypeDynamicsCrmSource', 'TypeBasicCopySourceTypeDynamicsSource', 'TypeBasicCopySourceTypeCosmosDbSQLAPISource', 'TypeBasicCopySourceTypeDocumentDbCollectionSource', 'TypeBasicCopySourceTypeBlobSource', 'TypeBasicCopySourceTypeAmazonRedshiftSource', 'TypeBasicCopySourceTypeGoogleAdWordsSource', 'TypeBasicCopySourceTypeOracleServiceCloudSource', 'TypeBasicCopySourceTypeDynamicsAXSource', 'TypeBasicCopySourceTypeResponsysSource', 'TypeBasicCopySourceTypeSalesforceMarketingCloudSource', 'TypeBasicCopySourceTypeVerticaSource', 'TypeBasicCopySourceTypeNetezzaSource', 'TypeBasicCopySourceTypeZohoSource', 'TypeBasicCopySourceTypeXeroSource', 'TypeBasicCopySourceTypeSquareSource', 'TypeBasicCopySourceTypeSparkSource', 'TypeBasicCopySourceTypeShopifySource', 'TypeBasicCopySourceTypeServiceNowSource', 'TypeBasicCopySourceTypeQuickBooksSource', 'TypeBasicCopySourceTypePrestoSource', 'TypeBasicCopySourceTypePhoenixSource', 'TypeBasicCopySourceTypePaypalSource', 'TypeBasicCopySourceTypeMarketoSource', 'TypeBasicCopySourceTypeAzureMariaDBSource', 'TypeBasicCopySourceTypeMariaDBSource', 'TypeBasicCopySourceTypeMagentoSource', 'TypeBasicCopySourceTypeJiraSource', 'TypeBasicCopySourceTypeImpalaSource', 'TypeBasicCopySourceTypeHubspotSource', 'TypeBasicCopySourceTypeHiveSource', 'TypeBasicCopySourceTypeHBaseSource', 'TypeBasicCopySourceTypeGreenplumSource', 'TypeBasicCopySourceTypeGoogleBigQuerySource', 'TypeBasicCopySourceTypeEloquaSource', 'TypeBasicCopySourceTypeDrillSource', 'TypeBasicCopySourceTypeCouchbaseSource', 'TypeBasicCopySourceTypeConcurSource', 'TypeBasicCopySourceTypeAzurePostgreSQLSource', 'TypeBasicCopySourceTypeAmazonMWSSource', 'TypeBasicCopySourceTypeCassandraSource', 'TypeBasicCopySourceTypeTeradataSource', 'TypeBasicCopySourceTypeAzureMySQLSource', 'TypeBasicCopySourceTypeSQLDWSource', 'TypeBasicCopySourceTypeSQLMISource', 'TypeBasicCopySourceTypeAzureSQLSource', 'TypeBasicCopySourceTypeSQLServerSource', 'TypeBasicCopySourceTypeSQLSource', 'TypeBasicCopySourceTypeSapTableSource', 'TypeBasicCopySourceTypeSapOpenHubSource', 'TypeBasicCopySourceTypeSapHanaSource', 'TypeBasicCopySourceTypeSapEccSource', 'TypeBasicCopySourceTypeSapCloudForCustomerSource', 'TypeBasicCopySourceTypeSalesforceSource', 'TypeBasicCopySourceTypeSapBwSource', 'TypeBasicCopySourceTypeSybaseSource', 'TypeBasicCopySourceTypePostgreSQLSource', 'TypeBasicCopySourceTypeMySQLSource', 'TypeBasicCopySourceTypeOdbcSource', 'TypeBasicCopySourceTypeDb2Source', 'TypeBasicCopySourceTypeInformixSource', 'TypeBasicCopySourceTypeAzureTableSource', 'TypeBasicCopySourceTypeTabularSource', 'TypeBasicCopySourceTypeBinarySource', 'TypeBasicCopySourceTypeOrcSource', 'TypeBasicCopySourceTypeXMLSource', 'TypeBasicCopySourceTypeJSONSource', 'TypeBasicCopySourceTypeDelimitedTextSource', 'TypeBasicCopySourceTypeParquetSource', 'TypeBasicCopySourceTypeExcelSource', 'TypeBasicCopySourceTypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) MarshalJSON() ([]byte, error) {
	ades.Type = TypeBasicCopySourceTypeAzureDataExplorerSource
	objectMap := make(map[string]interface{})
	if ades.Query != nil {
		objectMap["query"] = ades.Query
	}
	if ades.NoTruncation != nil {
		objectMap["noTruncation"] = ades.NoTruncation
	}
	if ades.QueryTimeout != nil {
		objectMap["queryTimeout"] = ades.QueryTimeout
	}
	if ades.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ades.AdditionalColumns
	}
	if ades.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ades.SourceRetryCount
	}
	if ades.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ades.SourceRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.DisableMetricsCollection != nil {
		objectMap["disableMetricsCollection"] = ades.DisableMetricsCollection
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDatabricksDeltaLakeSource() (*AzureDatabricksDeltaLakeSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbAtlasSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbAtlasSource() (*MongoDbAtlasSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return &ades, true
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSource struct.
func (ades *AzureDataExplorerSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ades.Query = query
			}
		case "noTruncation":
			if v != nil {
				var noTruncation interface{}
				err = json.Unmarshal(*v, &noTruncation)
				if err != nil {
					return err
				}
				ades.NoTruncation = noTruncation
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ades.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns interface{}
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ades.AdditionalColumns = additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ades.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ades.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "disableMetricsCollection":
			if v != nil {
				var disableMetricsCollection interface{}
				err = json.Unmarshal(*v, &disableMetricsCollection)
				if err != nil {
					return err
				}
				ades.DisableMetricsCollection = disableMetricsCollection
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerTableDataset the Azure Data Explorer (Kusto) dataset.
type AzureDataExplorerTableDataset struct {
	// AzureDataExplorerDatasetTypeProperties - Azure Data Explorer (Kusto) dataset properties.
	*AzureDataExplorerDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeBasicDatasetTypeDataset', 'TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset', 'TypeBasicDatasetTypeSharePointOnlineListResource', 'TypeBasicDatasetTypeSnowflakeTable', 'TypeBasicDatasetTypeGoogleAdWordsObject', 'TypeBasicDatasetTypeAzureDataExplorerTable', 'TypeBasicDatasetTypeOracleServiceCloudObject', 'TypeBasicDatasetTypeDynamicsAXResource', 'TypeBasicDatasetTypeResponsysObject', 'TypeBasicDatasetTypeSalesforceMarketingCloudObject', 'TypeBasicDatasetTypeVerticaTable', 'TypeBasicDatasetTypeNetezzaTable', 'TypeBasicDatasetTypeZohoObject', 'TypeBasicDatasetTypeXeroObject', 'TypeBasicDatasetTypeSquareObject', 'TypeBasicDatasetTypeSparkObject', 'TypeBasicDatasetTypeShopifyObject', 'TypeBasicDatasetTypeServiceNowObject', 'TypeBasicDatasetTypeQuickBooksObject', 'TypeBasicDatasetTypePrestoObject', 'TypeBasicDatasetTypePhoenixObject', 'TypeBasicDatasetTypePaypalObject', 'TypeBasicDatasetTypeMarketoObject', 'TypeBasicDatasetTypeAzureMariaDBTable', 'TypeBasicDatasetTypeMariaDBTable', 'TypeBasicDatasetTypeMagentoObject', 'TypeBasicDatasetTypeJiraObject', 'TypeBasicDatasetTypeImpalaObject', 'TypeBasicDatasetTypeHubspotObject', 'TypeBasicDatasetTypeHiveObject', 'TypeBasicDatasetTypeHBaseObject', 'TypeBasicDatasetTypeGreenplumTable', 'TypeBasicDatasetTypeGoogleBigQueryObject', 'TypeBasicDatasetTypeEloquaObject', 'TypeBasicDatasetTypeDrillTable', 'TypeBasicDatasetTypeCouchbaseTable', 'TypeBasicDatasetTypeConcurObject', 'TypeBasicDatasetTypeAzurePostgreSQLTable', 'TypeBasicDatasetTypeAmazonMWSObject', 'TypeBasicDatasetTypeHTTPFile', 'TypeBasicDatasetTypeAzureSearchIndex', 'TypeBasicDatasetTypeWebTable', 'TypeBasicDatasetTypeSapTableResource', 'TypeBasicDatasetTypeRestResource', 'TypeBasicDatasetTypeSQLServerTable', 'TypeBasicDatasetTypeSapOpenHubTable', 'TypeBasicDatasetTypeSapHanaTable', 'TypeBasicDatasetTypeSapEccResource', 'TypeBasicDatasetTypeSapCloudForCustomerResource', 'TypeBasicDatasetTypeSapBwCube', 'TypeBasicDatasetTypeSybaseTable', 'TypeBasicDatasetTypeSalesforceServiceCloudObject', 'TypeBasicDatasetTypeSalesforceObject', 'TypeBasicDatasetTypeMicrosoftAccessTable', 'TypeBasicDatasetTypePostgreSQLTable', 'TypeBasicDatasetTypeMySQLTable', 'TypeBasicDatasetTypeOdbcTable', 'TypeBasicDatasetTypeInformixTable', 'TypeBasicDatasetTypeRelationalTable', 'TypeBasicDatasetTypeDb2Table', 'TypeBasicDatasetTypeAmazonRedshiftTable', 'TypeBasicDatasetTypeAzureMySQLTable', 'TypeBasicDatasetTypeTeradataTable', 'TypeBasicDatasetTypeOracleTable', 'TypeBasicDatasetTypeODataResource', 'TypeBasicDatasetTypeCosmosDbMongoDbAPICollection', 'TypeBasicDatasetTypeMongoDbV2Collection', 'TypeBasicDatasetTypeMongoDbAtlasCollection', 'TypeBasicDatasetTypeMongoDbCollection', 'TypeBasicDatasetTypeFileShare', 'TypeBasicDatasetTypeOffice365Table', 'TypeBasicDatasetTypeAzureBlobFSFile', 'TypeBasicDatasetTypeAzureDataLakeStoreFile', 'TypeBasicDatasetTypeCommonDataServiceForAppsEntity', 'TypeBasicDatasetTypeDynamicsCrmEntity', 'TypeBasicDatasetTypeDynamicsEntity', 'TypeBasicDatasetTypeDocumentDbCollection', 'TypeBasicDatasetTypeCosmosDbSQLAPICollection', 'TypeBasicDatasetTypeCustomDataset', 'TypeBasicDatasetTypeCassandraTable', 'TypeBasicDatasetTypeAzureSQLDWTable', 'TypeBasicDatasetTypeAzureSQLMITable', 'TypeBasicDatasetTypeAzureSQLTable', 'TypeBasicDatasetTypeAzureTable', 'TypeBasicDatasetTypeAzureBlob', 'TypeBasicDatasetTypeBinary', 'TypeBasicDatasetTypeOrc', 'TypeBasicDatasetTypeXML', 'TypeBasicDatasetTypeJSON', 'TypeBasicDatasetTypeDelimitedText', 'TypeBasicDatasetTypeParquet', 'TypeBasicDatasetTypeExcel', 'TypeBasicDatasetTypeAvro', 'TypeBasicDatasetTypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) MarshalJSON() ([]byte, error) {
	adetd.Type = TypeBasicDatasetTypeAzureDataExplorerTable
	objectMap := make(map[string]interface{})
	if adetd.AzureDataExplorerDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adetd.AzureDataExplorerDatasetTypeProperties
	}
	if adetd.Description != nil {
		objectMap["description"] = adetd.Description
	}
	if adetd.Structure != nil {
		objectMap["structure"] = adetd.Structure
	}
	if adetd.Schema != nil {
		objectMap["schema"] = adetd.Schema
	}
	if adetd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adetd.LinkedServiceName
	}
	if adetd.Parameters != nil {
		objectMap["parameters"] = adetd.Parameters
	}
	if adetd.Annotations != nil {
		objectMap["annotations"] = adetd.Annotations
	}
	if adetd.Folder != nil {
		objectMap["folder"] = adetd.Folder
	}
	if adetd.Type != "" {
		objectMap["type"] = adetd.Type
	}
	for k, v := range adetd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAzureDatabricksDeltaLakeDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDatabricksDeltaLakeDataset() (*AzureDatabricksDeltaLakeDataset, bool) {
	return nil, false
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return &adetd, true
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbAtlasCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbAtlasCollectionDataset() (*MongoDbAtlasCollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adetd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerTableDataset struct.
func (adetd *AzureDataExplorerTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerDatasetTypeProperties AzureDataExplorerDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerDatasetTypeProperties)
				if err != nil {
					return err
				}
				adetd.AzureDataExplorerDatasetTypeProperties = &azureDataExplorerDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adetd.AdditionalProperties == nil {
					adetd.AdditionalProperties = make(map[string]interface{})
				}
				adetd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adetd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adetd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				adetd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adetd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adetd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adetd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				adetd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adetd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedService azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
	*AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeBasicLinkedServiceTypeLinkedService', 'TypeBasicLinkedServiceTypeSharePointOnlineList', 'TypeBasicLinkedServiceTypeSnowflake', 'TypeBasicLinkedServiceTypeAzureFunction', 'TypeBasicLinkedServiceTypeAzureDataExplorer', 'TypeBasicLinkedServiceTypeSapTable', 'TypeBasicLinkedServiceTypeGoogleAdWords', 'TypeBasicLinkedServiceTypeOracleServiceCloud', 'TypeBasicLinkedServiceTypeDynamicsAX', 'TypeBasicLinkedServiceTypeResponsys', 'TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake', 'TypeBasicLinkedServiceTypeAzureDatabricks', 'TypeBasicLinkedServiceTypeAzureDataLakeAnalytics', 'TypeBasicLinkedServiceTypeHDInsightOnDemand', 'TypeBasicLinkedServiceTypeSalesforceMarketingCloud', 'TypeBasicLinkedServiceTypeNetezza', 'TypeBasicLinkedServiceTypeVertica', 'TypeBasicLinkedServiceTypeZoho', 'TypeBasicLinkedServiceTypeXero', 'TypeBasicLinkedServiceTypeSquare', 'TypeBasicLinkedServiceTypeSpark', 'TypeBasicLinkedServiceTypeShopify', 'TypeBasicLinkedServiceTypeServiceNow', 'TypeBasicLinkedServiceTypeQuickBooks', 'TypeBasicLinkedServiceTypePresto', 'TypeBasicLinkedServiceTypePhoenix', 'TypeBasicLinkedServiceTypePaypal', 'TypeBasicLinkedServiceTypeMarketo', 'TypeBasicLinkedServiceTypeAzureMariaDB', 'TypeBasicLinkedServiceTypeMariaDB', 'TypeBasicLinkedServiceTypeMagento', 'TypeBasicLinkedServiceTypeJira', 'TypeBasicLinkedServiceTypeImpala', 'TypeBasicLinkedServiceTypeHubspot', 'TypeBasicLinkedServiceTypeHive', 'TypeBasicLinkedServiceTypeHBase', 'TypeBasicLinkedServiceTypeGreenplum', 'TypeBasicLinkedServiceTypeGoogleBigQuery', 'TypeBasicLinkedServiceTypeEloqua', 'TypeBasicLinkedServiceTypeDrill', 'TypeBasicLinkedServiceTypeCouchbase', 'TypeBasicLinkedServiceTypeConcur', 'TypeBasicLinkedServiceTypeAzurePostgreSQL', 'TypeBasicLinkedServiceTypeAmazonMWS', 'TypeBasicLinkedServiceTypeSapHana', 'TypeBasicLinkedServiceTypeSapBW', 'TypeBasicLinkedServiceTypeSftp', 'TypeBasicLinkedServiceTypeFtpServer', 'TypeBasicLinkedServiceTypeHTTPServer', 'TypeBasicLinkedServiceTypeAzureSearch', 'TypeBasicLinkedServiceTypeCustomDataSource', 'TypeBasicLinkedServiceTypeAmazonRedshift', 'TypeBasicLinkedServiceTypeAmazonS3', 'TypeBasicLinkedServiceTypeRestService', 'TypeBasicLinkedServiceTypeSapOpenHub', 'TypeBasicLinkedServiceTypeSapEcc', 'TypeBasicLinkedServiceTypeSapCloudForCustomer', 'TypeBasicLinkedServiceTypeSalesforceServiceCloud', 'TypeBasicLinkedServiceTypeSalesforce', 'TypeBasicLinkedServiceTypeOffice365', 'TypeBasicLinkedServiceTypeAzureBlobFS', 'TypeBasicLinkedServiceTypeAzureDataLakeStore', 'TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI', 'TypeBasicLinkedServiceTypeMongoDbV2', 'TypeBasicLinkedServiceTypeMongoDbAtlas', 'TypeBasicLinkedServiceTypeMongoDb', 'TypeBasicLinkedServiceTypeCassandra', 'TypeBasicLinkedServiceTypeWeb', 'TypeBasicLinkedServiceTypeOData', 'TypeBasicLinkedServiceTypeHdfs', 'TypeBasicLinkedServiceTypeMicrosoftAccess', 'TypeBasicLinkedServiceTypeInformix', 'TypeBasicLinkedServiceTypeOdbc', 'TypeBasicLinkedServiceTypeAzureMLService', 'TypeBasicLinkedServiceTypeAzureML', 'TypeBasicLinkedServiceTypeTeradata', 'TypeBasicLinkedServiceTypeDb2', 'TypeBasicLinkedServiceTypeSybase', 'TypeBasicLinkedServiceTypePostgreSQL', 'TypeBasicLinkedServiceTypeMySQL', 'TypeBasicLinkedServiceTypeAzureMySQL', 'TypeBasicLinkedServiceTypeOracle', 'TypeBasicLinkedServiceTypeGoogleCloudStorage', 'TypeBasicLinkedServiceTypeOracleCloudStorage', 'TypeBasicLinkedServiceTypeAmazonS3Compatible', 'TypeBasicLinkedServiceTypeAzureFileStorage', 'TypeBasicLinkedServiceTypeFileServer', 'TypeBasicLinkedServiceTypeHDInsight', 'TypeBasicLinkedServiceTypeCommonDataServiceForApps', 'TypeBasicLinkedServiceTypeDynamicsCrm', 'TypeBasicLinkedServiceTypeDynamics', 'TypeBasicLinkedServiceTypeCosmosDb', 'TypeBasicLinkedServiceTypeAzureKeyVault', 'TypeBasicLinkedServiceTypeAzureBatch', 'TypeBasicLinkedServiceTypeAzureSQLMI', 'TypeBasicLinkedServiceTypeAzureSQLDatabase', 'TypeBasicLinkedServiceTypeSQLServer', 'TypeBasicLinkedServiceTypeAzureSQLDW', 'TypeBasicLinkedServiceTypeAzureTableStorage', 'TypeBasicLinkedServiceTypeAzureBlobStorage', 'TypeBasicLinkedServiceTypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	adlals.Type = TypeBasicLinkedServiceTypeAzureDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties
	}
	if adlals.ConnectVia != nil {
		objectMap["connectVia"] = adlals.ConnectVia
	}
	if adlals.Description != nil {
		objectMap["description"] = adlals.Description
	}
	if adlals.Parameters != nil {
		objectMap["parameters"] = adlals.Parameters
	}
	if adlals.Annotations != nil {
		objectMap["annotations"] = adlals.Annotations
	}
	if adlals.Type != "" {
		objectMap["type"] = adlals.Type
	}
	for k, v := range adlals.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksDeltaLakeLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDatabricksDeltaLakeLinkedService() (*AzureDatabricksDeltaLakeLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return &adlals, true
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinke