// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20210303

import (
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
    tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
)

const APIVersion = "2021-03-03"

type Client struct {
    common.Client
}

// Deprecated
func NewClientWithSecretId(secretId, secretKey, region string) (client *Client, err error) {
    cpf := profile.NewClientProfile()
    client = &Client{}
    client.Init(region).WithSecretId(secretId, secretKey).WithProfile(cpf)
    return
}

func NewClient(credential *common.Credential, region string, clientProfile *profile.ClientProfile) (client *Client, err error) {
    client = &Client{}
    client.Init(region).
        WithCredential(credential).
        WithProfile(clientProfile)
    return
}


func NewCreateAudioDepositRequest() (request *CreateAudioDepositRequest) {
    request = &CreateAudioDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateAudioDeposit")
    return
}

func NewCreateAudioDepositResponse() (response *CreateAudioDepositResponse) {
    response = &CreateAudioDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的音频原文件或下载URL，BTOE对音频原文件存储后，将其Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。音频类型支持格式：mp3、wav、wma、midi、flac；原文件上传大小不超过5 MB，下载URL文件大小不超过25 MB。
func (c *Client) CreateAudioDeposit(request *CreateAudioDepositRequest) (response *CreateAudioDepositResponse, err error) {
    if request == nil {
        request = NewCreateAudioDepositRequest()
    }
    response = NewCreateAudioDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateDataDepositRequest() (request *CreateDataDepositRequest) {
    request = &CreateDataDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateDataDeposit")
    return
}

func NewCreateDataDepositResponse() (response *CreateDataDepositResponse) {
    response = &CreateDataDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的业务数据明文，业务数据明文存证写入后不可修改，BTOE对业务数据明文存证生成含有电子签章的区块链存证电子凭证。
func (c *Client) CreateDataDeposit(request *CreateDataDepositRequest) (response *CreateDataDepositResponse, err error) {
    if request == nil {
        request = NewCreateDataDepositRequest()
    }
    response = NewCreateDataDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateDocDepositRequest() (request *CreateDocDepositRequest) {
    request = &CreateDocDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateDocDeposit")
    return
}

func NewCreateDocDepositResponse() (response *CreateDocDepositResponse) {
    response = &CreateDocDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的文档原文件或下载URL，BTOE对文档原文件存储后，将其Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。文档类型支持格式：doc、docx、xls、xlsx、ppt、pptx、 pdf、html、txt、md、csv；原文件上传大小不超过5 MB，下载URL文件大小不超过10 MB。
func (c *Client) CreateDocDeposit(request *CreateDocDepositRequest) (response *CreateDocDepositResponse, err error) {
    if request == nil {
        request = NewCreateDocDepositRequest()
    }
    response = NewCreateDocDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateHashDepositRequest() (request *CreateHashDepositRequest) {
    request = &CreateHashDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateHashDeposit")
    return
}

func NewCreateHashDepositResponse() (response *CreateHashDepositResponse) {
    response = &CreateHashDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的原文数据Hash值，BTOE对业务数据Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。
func (c *Client) CreateHashDeposit(request *CreateHashDepositRequest) (response *CreateHashDepositResponse, err error) {
    if request == nil {
        request = NewCreateHashDepositRequest()
    }
    response = NewCreateHashDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateHashDepositNoCertRequest() (request *CreateHashDepositNoCertRequest) {
    request = &CreateHashDepositNoCertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateHashDepositNoCert")
    return
}

func NewCreateHashDepositNoCertResponse() (response *CreateHashDepositNoCertResponse) {
    response = &CreateHashDepositNoCertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的原文数据Hash值，BTOE对业务数据Hash值存证上链，本接口不生成区块链存证电子凭证。
func (c *Client) CreateHashDepositNoCert(request *CreateHashDepositNoCertRequest) (response *CreateHashDepositNoCertResponse, err error) {
    if request == nil {
        request = NewCreateHashDepositNoCertRequest()
    }
    response = NewCreateHashDepositNoCertResponse()
    err = c.Send(request, response)
    return
}

func NewCreateHashDepositNoSealRequest() (request *CreateHashDepositNoSealRequest) {
    request = &CreateHashDepositNoSealRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateHashDepositNoSeal")
    return
}

func NewCreateHashDepositNoSealResponse() (response *CreateHashDepositNoSealResponse) {
    response = &CreateHashDepositNoSealResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的原文数据Hash值，BTOE对业务数据Hash值存证上链，并生成无电子签章的区块链存证电子凭证。
func (c *Client) CreateHashDepositNoSeal(request *CreateHashDepositNoSealRequest) (response *CreateHashDepositNoSealResponse, err error) {
    if request == nil {
        request = NewCreateHashDepositNoSealRequest()
    }
    response = NewCreateHashDepositNoSealResponse()
    err = c.Send(request, response)
    return
}

func NewCreateImageDepositRequest() (request *CreateImageDepositRequest) {
    request = &CreateImageDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateImageDeposit")
    return
}

func NewCreateImageDepositResponse() (response *CreateImageDepositResponse) {
    response = &CreateImageDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的图片原文件或下载URL，BTOE对图片原文件存储后，将其Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。图片类型支持格式：png、jpg、jpeg、bmp、gif、svg；原文件上传大小不超过5 MB，下载URL文件大小不超过10 MB。
func (c *Client) CreateImageDeposit(request *CreateImageDepositRequest) (response *CreateImageDepositResponse, err error) {
    if request == nil {
        request = NewCreateImageDepositRequest()
    }
    response = NewCreateImageDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateVideoDepositRequest() (request *CreateVideoDepositRequest) {
    request = &CreateVideoDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateVideoDeposit")
    return
}

func NewCreateVideoDepositResponse() (response *CreateVideoDepositResponse) {
    response = &CreateVideoDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE写入待存证的视频的原文件或下载URL，BTOE对视频原文件存储后，将其Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。视频文件支持格式：mp4、avi、mkv、mov、flv,wmv,rmvb,3gp；文件大小限制：直接上传原文件不大于5MB，下载URL文件大小不大于200 MB。
func (c *Client) CreateVideoDeposit(request *CreateVideoDepositRequest) (response *CreateVideoDepositResponse, err error) {
    if request == nil {
        request = NewCreateVideoDepositRequest()
    }
    response = NewCreateVideoDepositResponse()
    err = c.Send(request, response)
    return
}

func NewCreateWebpageDepositRequest() (request *CreateWebpageDepositRequest) {
    request = &CreateWebpageDepositRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "CreateWebpageDeposit")
    return
}

func NewCreateWebpageDepositResponse() (response *CreateWebpageDepositResponse) {
    response = &CreateWebpageDepositResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过本接口向BTOE提交待存证网页的URL，BTOE对URL进行网页快照，并将快照图片存储，将网页快照Hash值存证上链，并生成含有电子签章的区块链存证电子凭证。URL格式必须以http、https开头。
func (c *Client) CreateWebpageDeposit(request *CreateWebpageDepositRequest) (response *CreateWebpageDepositResponse, err error) {
    if request == nil {
        request = NewCreateWebpageDepositRequest()
    }
    response = NewCreateWebpageDepositResponse()
    err = c.Send(request, response)
    return
}

func NewGetDepositCertRequest() (request *GetDepositCertRequest) {
    request = &GetDepositCertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "GetDepositCert")
    return
}

func NewGetDepositCertResponse() (response *GetDepositCertResponse) {
    response = &GetDepositCertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过存证编码向BTOE查询存证电子凭证信息。
func (c *Client) GetDepositCert(request *GetDepositCertRequest) (response *GetDepositCertResponse, err error) {
    if request == nil {
        request = NewGetDepositCertRequest()
    }
    response = NewGetDepositCertResponse()
    err = c.Send(request, response)
    return
}

func NewGetDepositFileRequest() (request *GetDepositFileRequest) {
    request = &GetDepositFileRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "GetDepositFile")
    return
}

func NewGetDepositFileResponse() (response *GetDepositFileResponse) {
    response = &GetDepositFileResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过存证编码向BTOE获取存证文件的下载URL。
// -注：Hash类存证、业务数据明文存证不产生存证文件。
func (c *Client) GetDepositFile(request *GetDepositFileRequest) (response *GetDepositFileResponse, err error) {
    if request == nil {
        request = NewGetDepositFileRequest()
    }
    response = NewGetDepositFileResponse()
    err = c.Send(request, response)
    return
}

func NewGetDepositInfoRequest() (request *GetDepositInfoRequest) {
    request = &GetDepositInfoRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("btoe", APIVersion, "GetDepositInfo")
    return
}

func NewGetDepositInfoResponse() (response *GetDepositInfoResponse) {
    response = &GetDepositInfoResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 用户通过存证编码向BTOE查询存证基本信息。
func (c *Client) GetDepositInfo(request *GetDepositInfoRequest) (response *GetDepositInfoResponse, err error) {
    if request == nil {
        request = NewGetDepositInfoRequest()
    }
    response = NewGetDepositInfoResponse()
    err = c.Send(request, response)
    return
}
