// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20200709

import (
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
    tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
)

const APIVersion = "2020-07-09"

type Client struct {
    common.Client
}

// Deprecated
func NewClientWithSecretId(secretId, secretKey, region string) (client *Client, err error) {
    cpf := profile.NewClientProfile()
    client = &Client{}
    client.Init(region).WithSecretId(secretId, secretKey).WithProfile(cpf)
    return
}

func NewClient(credential *common.Credential, region string, clientProfile *profile.ClientProfile) (client *Client, err error) {
    client = &Client{}
    client.Init(region).
        WithCredential(credential).
        WithProfile(clientProfile)
    return
}


func NewCancelTaskRequest() (request *CancelTaskRequest) {
    request = &CancelTaskRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("vm", APIVersion, "CancelTask")
    return
}

func NewCancelTaskResponse() (response *CancelTaskResponse) {
    response = &CancelTaskResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 取消任务
func (c *Client) CancelTask(request *CancelTaskRequest) (response *CancelTaskResponse, err error) {
    if request == nil {
        request = NewCancelTaskRequest()
    }
    response = NewCancelTaskResponse()
    err = c.Send(request, response)
    return
}

func NewCreateBizConfigRequest() (request *CreateBizConfigRequest) {
    request = &CreateBizConfigRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("vm", APIVersion, "CreateBizConfig")
    return
}

func NewCreateBizConfigResponse() (response *CreateBizConfigResponse) {
    response = &CreateBizConfigResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 创建业务配置，1个账号最多可以创建20个配置，可定义音频审核的场景，如色情、谩骂等，
// 
// 在创建业务配置之前，你需要以下步骤：
// 1. 开通COS存储捅功能，新建存储桶，例如 cms_segments，用来存储 视频转换过程中生成对音频和图片。
// 2. 然后在COS控制台，授权天御内容安全主账号 对 cms_segments 存储桶对读写权限。具体授权操作，参考https://cloud.tencent.com/document/product/436/38648
func (c *Client) CreateBizConfig(request *CreateBizConfigRequest) (response *CreateBizConfigResponse, err error) {
    if request == nil {
        request = NewCreateBizConfigRequest()
    }
    response = NewCreateBizConfigResponse()
    err = c.Send(request, response)
    return
}

func NewCreateVideoModerationTaskRequest() (request *CreateVideoModerationTaskRequest) {
    request = &CreateVideoModerationTaskRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("vm", APIVersion, "CreateVideoModerationTask")
    return
}

func NewCreateVideoModerationTaskResponse() (response *CreateVideoModerationTaskResponse) {
    response = &CreateVideoModerationTaskResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 通过URL或存储桶创建审核任务
func (c *Client) CreateVideoModerationTask(request *CreateVideoModerationTaskRequest) (response *CreateVideoModerationTaskResponse, err error) {
    if request == nil {
        request = NewCreateVideoModerationTaskRequest()
    }
    response = NewCreateVideoModerationTaskResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeTaskDetailRequest() (request *DescribeTaskDetailRequest) {
    request = &DescribeTaskDetailRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("vm", APIVersion, "DescribeTaskDetail")
    return
}

func NewDescribeTaskDetailResponse() (response *DescribeTaskDetailResponse) {
    response = &DescribeTaskDetailResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 查看任务详情DescribeTaskDetail 
func (c *Client) DescribeTaskDetail(request *DescribeTaskDetailRequest) (response *DescribeTaskDetailResponse, err error) {
    if request == nil {
        request = NewDescribeTaskDetailRequest()
    }
    response = NewDescribeTaskDetailResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeVideoStatRequest() (request *DescribeVideoStatRequest) {
    request = &DescribeVideoStatRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("vm", APIVersion, "DescribeVideoStat")
    return
}

func NewDescribeVideoStatResponse() (response *DescribeVideoStatResponse) {
    response = &DescribeVideoStatResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 控制台识别统计
func (c *Client) DescribeVideoStat(request *DescribeVideoStatRequest) (response *DescribeVideoStatResponse, err error) {
    if request == nil {
        request = NewDescribeVideoStatRequest()
    }
    response = NewDescribeVideoStatResponse()
    err = c.Send(request, response)
    return
}
