// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudbilling provides access to the Cloud Billing API.
//
// For product documentation, see: https://cloud.google.com/billing/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/cloudbilling/v1beta"
//	...
//	ctx := context.Background()
//	cloudbillingService, err := cloudbilling.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithScopes(cloudbilling.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudbilling // import "google.golang.org/api/cloudbilling/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudbilling:v1beta"
const apiName = "cloudbilling"
const apiVersion = "v1beta"
const basePath = "https://cloudbilling.googleapis.com/"
const mtlsBasePath = "https://cloudbilling.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your Google Cloud Platform billing accounts
	CloudBillingScope = "https://www.googleapis.com/auth/cloud-billing"

	// View your Google Cloud Platform billing accounts
	CloudBillingReadonlyScope = "https://www.googleapis.com/auth/cloud-billing.readonly"

	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-billing",
		"https://www.googleapis.com/auth/cloud-billing.readonly",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.BillingAccounts = NewBillingAccountsService(s)
	s.V1beta = NewV1betaService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BillingAccounts *BillingAccountsService

	V1beta *V1betaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBillingAccountsService(s *Service) *BillingAccountsService {
	rs := &BillingAccountsService{s: s}
	return rs
}

type BillingAccountsService struct {
	s *Service
}

func NewV1betaService(s *Service) *V1betaService {
	rs := &V1betaService{s: s}
	return rs
}

type V1betaService struct {
	s *Service
}

// CloudStorageWorkload: Specifies usage of Cloud Storage resources.
type CloudStorageWorkload struct {
	// DataRetrieval: Data retrieval usage. A retrieval cost applies when
	// data or metadata is read, copied, or rewritten . For example: units
	// such as "GiBy/s" or "By/s".
	DataRetrieval *Usage `json:"dataRetrieval,omitempty"`

	// DataStored: Data storage usage. The amount of data stored in buckets.
	// For example: units such as "GiBy/s" or "TBy/mo".
	DataStored *Usage `json:"dataStored,omitempty"`

	// DualRegion: Specify dual regions.
	DualRegion *DualRegional `json:"dualRegion,omitempty"`

	// MultiRegion: Specify multi regions.
	MultiRegion *MultiRegional `json:"multiRegion,omitempty"`

	// OperationA: Class A operation usage in Cloud Storage, such as listing
	// the objects in buckets. See the operations pricing
	// (https://cloud.google.com/storage/pricing#operations-pricing) tables
	// for a list of which operations fall into each class. For example:
	// units such as "1/s".
	OperationA *Usage `json:"operationA,omitempty"`

	// OperationB: Class B operation usage in Cloud Storage, such as
	// `getIamPolicy`. See the operations pricing
	// (https://cloud.google.com/storage/pricing#operations-pricing) tables
	// for a list of which operations fall into each class. For example:
	// units such as "1/s".
	OperationB *Usage `json:"operationB,omitempty"`

	// Region: Specify a single region.
	Region *Regional `json:"region,omitempty"`

	// StorageClass: The storage class
	// (https://cloud.google.com/storage/docs/storage-classes#classes) of
	// the data and operation. For example: "standard" or "nearline".
	StorageClass string `json:"storageClass,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataRetrieval") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataRetrieval") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudStorageWorkload) MarshalJSON() ([]byte, error) {
	type NoMethod CloudStorageWorkload
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Commitment: Commitments give you the ability to pay a recurring fee
// in exchange for a benefit, such as a discount for your use. For
// example, this object might contain details of a spend-based committed
// use discount (CUD)
// (https://cloud.google.com/docs/cuds#spend_based_commitments). Within
// a CostScenario, adding a commitment includes the cost of the
// commitment and any discounts.
type Commitment struct {
	// Name: Required. A name for this commitment. All commitments in a
	// CostScenario must have unique names. Each name must be a maximum of
	// 32 characters.
	Name string `json:"name,omitempty"`

	// VmResourceBasedCud: A resource-based committed use discount (CUD).
	VmResourceBasedCud *VmResourceBasedCud `json:"vmResourceBasedCud,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Commitment) MarshalJSON() ([]byte, error) {
	type NoMethod Commitment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentCostEstimate: Estimated cost for a commitment.
type CommitmentCostEstimate struct {
	// CommitmentTotalCostEstimate: Total estimated costs for the
	// commitment.
	CommitmentTotalCostEstimate *CostEstimate `json:"commitmentTotalCostEstimate,omitempty"`

	// Name: The name of the commitment, as specified in the `CostScenario`.
	Name string `json:"name,omitempty"`

	// SkuCostEstimates: Estimated costs for each SKU in the commitment.
	SkuCostEstimates []*SkuCostEstimate `json:"skuCostEstimates,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CommitmentTotalCostEstimate") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CommitmentTotalCostEstimate") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentCostEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentCostEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ComputeVmWorkload: Specificies usage of a set of identical compute VM
// instances.
type ComputeVmWorkload struct {
	// EnableConfidentialCompute: Defines whether each instance has
	// confidential compute enabled.
	EnableConfidentialCompute bool `json:"enableConfidentialCompute,omitempty"`

	// GuestAccelerator: Guest accelerators attached to each machine.
	GuestAccelerator *GuestAccelerator `json:"guestAccelerator,omitempty"`

	// InstancesRunning: VM usage. This is specified as a unitless quantity
	// which indicates the number of instances running.
	InstancesRunning *Usage `json:"instancesRunning,omitempty"`

	// Licenses: Premium image licenses used by each instance.
	Licenses []string `json:"licenses,omitempty"`

	// MachineType: The machine type.
	MachineType *MachineType `json:"machineType,omitempty"`

	// PersistentDisks: Persistent disks attached to each instance. Must
	// include a boot disk.
	PersistentDisks []*PersistentDisk `json:"persistentDisks,omitempty"`

	// Preemptible: Defines whether each instance is preemptible.
	Preemptible bool `json:"preemptible,omitempty"`

	// Region: The region
	// (https://cloud.google.com/compute/docs/regions-zones) where the VMs
	// run. For example: "us-central1".
	Region string `json:"region,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableConfidentialCompute") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EnableConfidentialCompute") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ComputeVmWorkload) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeVmWorkload
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CostEstimate: An estimated cost.
type CostEstimate struct {
	// CreditEstimates: The estimated credits applied.
	CreditEstimates []*CreditEstimate `json:"creditEstimates,omitempty"`

	// NetCostEstimate: The estimated net cost after applying credits.
	NetCostEstimate *Money `json:"netCostEstimate,omitempty"`

	// PreCreditCostEstimate: The estimated cost prior to applying credits.
	PreCreditCostEstimate *Money `json:"preCreditCostEstimate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreditEstimates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreditEstimates") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CostEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod CostEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CostEstimationResult: The result of a estimating the costs of a
// `CostScenario`.
type CostEstimationResult struct {
	// CurrencyCode: Required. The ISO 4217 currency code for the cost
	// estimate.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// SegmentCostEstimates: Required. Estimated costs for each idealized
	// month of a `CostScenario`.
	SegmentCostEstimates []*SegmentCostEstimate `json:"segmentCostEstimates,omitempty"`

	// Skus: Required. Information about SKUs used in the estimate.
	Skus []*Sku `json:"skus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CostEstimationResult) MarshalJSON() ([]byte, error) {
	type NoMethod CostEstimationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CostScenario: Encapsulates all the information needed to perform a
// cost estimate. It includes a specification of the Google Cloud usage
// whose costs are estimated, and configuration options.
type CostScenario struct {
	// Commitments: New commitments to estimate the costs for. The cost of
	// the commitments will be included in the estimate result and discounts
	// the commitment entitles will be included in the workload cost
	// estimates. A maximum of 100 workloads can be provided.
	Commitments []*Commitment `json:"commitments,omitempty"`

	// ScenarioConfig: Configuration for the scenario.
	ScenarioConfig *ScenarioConfig `json:"scenarioConfig,omitempty"`

	// Workloads: The Google Cloud usage whose costs are estimated. A
	// maximum of 100 workloads can be provided.
	Workloads []*Workload `json:"workloads,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Commitments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Commitments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CostScenario) MarshalJSON() ([]byte, error) {
	type NoMethod CostScenario
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreditEstimate: An estimated credit applied to the costs on a SKU.
type CreditEstimate struct {
	// CreditAmount: The estimated credit amount.
	CreditAmount *Money `json:"creditAmount,omitempty"`

	// CreditDescription: The credit description.
	CreditDescription string `json:"creditDescription,omitempty"`

	// CreditType: The credit type.
	CreditType string `json:"creditType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreditAmount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreditAmount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreditEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod CreditEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomMachineType: Specification of a custom machine type.
type CustomMachineType struct {
	// MachineSeries: Required. The machine series. Only certain machine
	// series
	// (https://cloud.google.com/compute/docs/general-purpose-machines#custom_machine_types)
	// support custom configurations. For example: "n1".
	MachineSeries string `json:"machineSeries,omitempty"`

	// MemorySizeGb: Required. Memory size of the VM in GB (2^30 bytes).
	// Must be an increment of 0.25 (256 MB). Each machine series
	// (https://cloud.google.com/compute/docs/machine-types#machine_type_comparison)
	// has limitations on allowed values for the ratio of memory-to-vCPU
	// count.
	MemorySizeGb float64 `json:"memorySizeGb,omitempty"`

	// VirtualCpuCount: Required. The number of vCPUs. The allowed values
	// depend on the machine series
	// (https://cloud.google.com/compute/docs/machine-types#machine_type_comparison).
	VirtualCpuCount int64 `json:"virtualCpuCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MachineSeries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineSeries") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomMachineType) MarshalJSON() ([]byte, error) {
	type NoMethod CustomMachineType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CustomMachineType) UnmarshalJSON(data []byte) error {
	type NoMethod CustomMachineType
	var s1 struct {
		MemorySizeGb gensupport.JSONFloat64 `json:"memorySizeGb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MemorySizeGb = float64(s1.MemorySizeGb)
	return nil
}

// DualRegional: Area contains dual locations.
type DualRegional struct {
	// Name: The location name
	// (https://cloud.google.com/storage/docs/locations#available-locations)
	// where the data is stored. For example: "asia1" for dual region.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DualRegional) MarshalJSON() ([]byte, error) {
	type NoMethod DualRegional
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EstimateCostScenarioForBillingAccountRequest: Request for
// EstimateCostScenarioForBillingAccount.
type EstimateCostScenarioForBillingAccountRequest struct {
	// CostScenario: The scenario to estimate costs for.
	CostScenario *CostScenario `json:"costScenario,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CostScenario") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CostScenario") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EstimateCostScenarioForBillingAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EstimateCostScenarioForBillingAccountRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EstimateCostScenarioForBillingAccountResponse: Response for
// EstimateCostScenarioForBillingAccount
type EstimateCostScenarioForBillingAccountResponse struct {
	// CostEstimationResult: The result of the cost estimation.
	CostEstimationResult *CostEstimationResult `json:"costEstimationResult,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "CostEstimationResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CostEstimationResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EstimateCostScenarioForBillingAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EstimateCostScenarioForBillingAccountResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EstimateCostScenarioWithListPriceRequest: Request for
// EstimateCostScenarioWithListPrice.
type EstimateCostScenarioWithListPriceRequest struct {
	// CostScenario: The scenario to estimate costs for.
	CostScenario *CostScenario `json:"costScenario,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CostScenario") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CostScenario") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EstimateCostScenarioWithListPriceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EstimateCostScenarioWithListPriceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EstimateCostScenarioWithListPriceResponse: Response for
// EstimateCostScenarioWithListPrice
type EstimateCostScenarioWithListPriceResponse struct {
	// CostEstimationResult: The result of the cost estimation.
	CostEstimationResult *CostEstimationResult `json:"costEstimationResult,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "CostEstimationResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CostEstimationResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EstimateCostScenarioWithListPriceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EstimateCostScenarioWithListPriceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EstimationTimePoint: Represents a point in time.
type EstimationTimePoint struct {
	// EstimationTimeFrameOffset: The point in time, relative to the start
	// of the time frame covered by the cost estimate.
	EstimationTimeFrameOffset string `json:"estimationTimeFrameOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimationTimeFrameOffset") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EstimationTimeFrameOffset") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EstimationTimePoint) MarshalJSON() ([]byte, error) {
	type NoMethod EstimationTimePoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAccelerator: Specification of a set of guest accelerators
// attached to a machine.
type GuestAccelerator struct {
	// AcceleratorCount: The number of the guest accelerator cards exposed
	// to each instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty,string"`

	// AcceleratorType: The type of the guest accelerator cards. For
	// example: "nvidia-tesla-t4".
	AcceleratorType string `json:"acceleratorType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GuestAccelerator) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAccelerator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MachineType: Specification of machine series, memory, and number of
// vCPUs.
type MachineType struct {
	CustomMachineType *CustomMachineType `json:"customMachineType,omitempty"`

	PredefinedMachineType *PredefinedMachineType `json:"predefinedMachineType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomMachineType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomMachineType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MachineType) MarshalJSON() ([]byte, error) {
	type NoMethod MachineType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Nanos: Number of nano (10^-9) units of the amount. The value must be
	// between -999,999,999 and +999,999,999 inclusive. If `units` is
	// positive, `nanos` must be positive or zero. If `units` is zero,
	// `nanos` can be positive, zero, or negative. If `units` is negative,
	// `nanos` must be negative or zero. For example $-1.75 is represented
	// as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`

	// Units: The whole units of the amount. For example if `currencyCode`
	// is "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MultiRegional: Area contains multiple locations.
type MultiRegional struct {
	// Name: The location name
	// (https://cloud.google.com/storage/docs/locations#available-locations)
	// where the data is stored. For example: "us" for multi-region.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MultiRegional) MarshalJSON() ([]byte, error) {
	type NoMethod MultiRegional
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PersistentDisk: Specification of a persistent disk attached to a VM.
type PersistentDisk struct {
	// DiskSize: Specifies the size of disk. Must be at least 10 GB.
	DiskSize *Usage `json:"diskSize,omitempty"`

	// DiskType: The disk type
	// (https://cloud.google.com/compute/docs/disks#disk-types). For
	// example: "pd-standard".
	DiskType string `json:"diskType,omitempty"`

	// ProvisionedIops: Indicates how many IOPS to provision for the disk
	// for extreme persistent disks. This sets the number of I/O operations
	// per second that the disk can handle. Values must be between 10,000
	// and 120,000.
	ProvisionedIops *Usage `json:"provisionedIops,omitempty"`

	// Scope: The geographic scope of the disk. Defaults to `SCOPE_ZONAL` if
	// not specified.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Unspecified.
	//   "SCOPE_ZONAL" - The disk exists in a single zone.
	//   "SCOPE_REGIONAL" - The disk is replicated in a secondary zone
	// within the same region.
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PersistentDisk) MarshalJSON() ([]byte, error) {
	type NoMethod PersistentDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PredefinedMachineType: Specification of a predefined machine type.
type PredefinedMachineType struct {
	// MachineType: The machine type
	// (https://cloud.google.com/compute/docs/machine-types). For example:
	// "n1-standard1".
	MachineType string `json:"machineType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PredefinedMachineType) MarshalJSON() ([]byte, error) {
	type NoMethod PredefinedMachineType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Price: The price of a SKU at a point int time.
type Price struct {
	// EffectiveTime: The timestamp within the estimation time frame when
	// the price was set.
	EffectiveTime *EstimationTimePoint `json:"effectiveTime,omitempty"`

	// PriceType: The type of price. Possible values: "RATE"
	PriceType string `json:"priceType,omitempty"`

	// Rate: A set of tiered rates.
	Rate *Rate `json:"rate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EffectiveTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EffectiveTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Rate: A SKU price consisting of tiered rates.
type Rate struct {
	// Tiers: The service tiers.
	Tiers []*RateTier `json:"tiers,omitempty"`

	// Unit: The SKU's pricing unit. For example, if the tier price is $1
	// per 1000000 Bytes, then this field will show 'By'. The `start_amount`
	// field in each tier will be in this unit.
	Unit string `json:"unit,omitempty"`

	// UnitCount: The SKU's count for the pricing unit. For example, if the
	// tier price is $1 per 1000000 Bytes, then this column will show
	// 1000000.
	UnitCount float64 `json:"unitCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Tiers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Tiers") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Rate) MarshalJSON() ([]byte, error) {
	type NoMethod Rate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Rate) UnmarshalJSON(data []byte) error {
	type NoMethod Rate
	var s1 struct {
		UnitCount gensupport.JSONFloat64 `json:"unitCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UnitCount = float64(s1.UnitCount)
	return nil
}

// RateTier: Pricing details for a service tier.
type RateTier struct {
	// Price: The price for this tier.
	Price *Money `json:"price,omitempty"`

	// StartAmount: The magnitude of usage in which the tier interval
	// begins. Example: "From 100 GiBi the price is $1 per byte" implies
	// `start_amount` = 100
	StartAmount float64 `json:"startAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Price") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Price") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RateTier) MarshalJSON() ([]byte, error) {
	type NoMethod RateTier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *RateTier) UnmarshalJSON(data []byte) error {
	type NoMethod RateTier
	var s1 struct {
		StartAmount gensupport.JSONFloat64 `json:"startAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.StartAmount = float64(s1.StartAmount)
	return nil
}

// Regional: Area contains only one location.
type Regional struct {
	// Name: The location name
	// (https://cloud.google.com/storage/docs/locations#available-locations).
	// For example: "us-central1" for region.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Regional) MarshalJSON() ([]byte, error) {
	type NoMethod Regional
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ScenarioConfig: Configuration for a CostScenario. Specifies how costs
// are calculated.
type ScenarioConfig struct {
	// EstimateDuration: Time frame for the estimate. Workloads must specify
	// usage for this duration. Duration must be at least 1 hour (3,600
	// seconds) and at most 10 years (315,360,000 seconds). The calculations
	// for years and months are based on a 730-hour (2,628,000-second)
	// month.
	EstimateDuration string `json:"estimateDuration,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EstimateDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimateDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ScenarioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ScenarioConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SegmentCostEstimate: Workload cost estimates for a single time
// segment.
type SegmentCostEstimate struct {
	// CommitmentCostEstimates: Estimated costs for each commitment.
	CommitmentCostEstimates []*CommitmentCostEstimate `json:"commitmentCostEstimates,omitempty"`

	// SegmentStartTime: Timestamp for the start of the segment.
	SegmentStartTime *EstimationTimePoint `json:"segmentStartTime,omitempty"`

	// SegmentTotalCostEstimate: Total estimated costs for the time segment.
	SegmentTotalCostEstimate *CostEstimate `json:"segmentTotalCostEstimate,omitempty"`

	// WorkloadCostEstimates: Estimated costs for each workload.
	WorkloadCostEstimates []*WorkloadCostEstimate `json:"workloadCostEstimates,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CommitmentCostEstimates") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommitmentCostEstimates")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SegmentCostEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod SegmentCostEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Sku: Information about SKUs appearing in the cost estimate.
type Sku struct {
	// DisplayName: The display name for the SKU. Example: A2 Instance Core
	// running in Americas
	DisplayName string `json:"displayName,omitempty"`

	// Prices: A timeline of prices for a SKU in chronological order. Note:
	// The API currently only supports using a constant price for the entire
	// estimation time frame so this list will contain a single value.
	Prices []*Price `json:"prices,omitempty"`

	// Sku: The resource name for the SKU. Example:
	// "services/DA34-426B-A397/skus/AA95-CD31-42FE"
	Sku string `json:"sku,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Sku) MarshalJSON() ([]byte, error) {
	type NoMethod Sku
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SkuCostEstimate: Estimated cost for usage on a SKU.
type SkuCostEstimate struct {
	// CostEstimate: The estimated cost for the usage on this SKU.
	CostEstimate *CostEstimate `json:"costEstimate,omitempty"`

	// Sku: The resource name for the SKU. Example:
	// "services/DA34-426B-A397/skus/AA95-CD31-42FE" More information about
	// the SKU can be found in the `skus` field of the
	// `CostEstimationResult`.
	Sku string `json:"sku,omitempty"`

	// UsageAmount: The amount of usage on this SKU.
	UsageAmount float64 `json:"usageAmount,omitempty"`

	// UsageUnit: The unit for the usage on this SKU.
	UsageUnit string `json:"usageUnit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CostEstimate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CostEstimate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SkuCostEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod SkuCostEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *SkuCostEstimate) UnmarshalJSON(data []byte) error {
	type NoMethod SkuCostEstimate
	var s1 struct {
		UsageAmount gensupport.JSONFloat64 `json:"usageAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UsageAmount = float64(s1.UsageAmount)
	return nil
}

// Usage: An amount of usage over a time frame.
type Usage struct {
	// UsageRateTimeline: A timeline of usage rates over the estimate
	// interval.
	UsageRateTimeline *UsageRateTimeline `json:"usageRateTimeline,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UsageRateTimeline")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UsageRateTimeline") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Usage) MarshalJSON() ([]byte, error) {
	type NoMethod Usage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UsageRateTimeline: A timeline of usage rates. Consists of a series of
// entries, each of which specifies a constant rate of usage during a
// time interval. Each entry contains an effective time. The usage rate
// is in effect from that time until the effective time of the
// subsequent entry, or, for the last entry, for the remaining portion
// of estimation time frame. Effective times are specified as an offset
// into the estimation time frame. Usage is considered to be zero until
// the `effective_time` of the first entry. All subsequent entries must
// have an effective time greater than the previous entry and less than
// the estimate time frame. The effective time on all entries must be an
// integer number of hours.
type UsageRateTimeline struct {
	// Unit: The unit for the usage rate in each timeline entry. The
	// supported units are a subset of The Unified Code for Units of Measure
	// (https://ucum.org/ucum.html) standard: * **Time units (TIME-UNIT)** *
	// `s` second * `min` minute * `h` hour * `d` day * `wk` week * `mo`
	// month * `yr` year * `ms` millisecond * `us` microsecond * `ns`
	// nanosecond * **Basic storage units (BASIC-STORAGE-UNIT)** * `bit` bit
	// * `By` byte * **Count units (COUNT-UNIT)** * `count` count *
	// **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga
	// (10^9) * `T` tera (10^12) * `P` peta (10^15) * `Ki` kibi (2^10) *
	// `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi
	// (2^50) **Grammar** The grammar also includes these connectors: * `/`
	// division or ratio (as an infix operator). For example: `kBy/{email}`
	// or `MiBy/10ms`. * `.` multiplication or composition (as an infix
	// operator). For example: `GBy.d` or `k{watt}.h`. The grammar for a
	// unit is as follows: ``` Expression = Component { "." Component } {
	// "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation
	// ] | Annotation | "1" ; UNIT = TIME-UNIT | STORAGE-UNIT | DATA-UNIT |
	// COUNT-UNIT Annotation = "{" NAME "}" ; ``` Examples: * Request per
	// second: `1/s` or `{requests}/s` * GibiBytes: `GiBy` * GibiBytes *
	// seconds: `GiBy.s`
	Unit string `json:"unit,omitempty"`

	// UsageRateTimelineEntries: The timeline entries. Each entry has a
	// start time and usage rate. The start time specifies the effective
	// time of the usage rate. The entries must be sorted by start time in
	// an increasing order.
	UsageRateTimelineEntries []*UsageRateTimelineEntry `json:"usageRateTimelineEntries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Unit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Unit") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UsageRateTimeline) MarshalJSON() ([]byte, error) {
	type NoMethod UsageRateTimeline
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UsageRateTimelineEntry: A usage rate timeline entry. Each entry
// specifies a constant usage rate during a time interval.
type UsageRateTimelineEntry struct {
	// EffectiveTime: The effective time for this entry. The usage rate is
	// in effect starting at this time until the effective time of the
	// subsequent entry in the timeline. The last entry defines the usage
	// rate until the end of the `Usage` time frame. Must correspond to an
	// integer number of hours.
	EffectiveTime *EstimationTimePoint `json:"effectiveTime,omitempty"`

	// UsageRate: The usage rate.
	UsageRate float64 `json:"usageRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EffectiveTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EffectiveTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UsageRateTimelineEntry) MarshalJSON() ([]byte, error) {
	type NoMethod UsageRateTimelineEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *UsageRateTimelineEntry) UnmarshalJSON(data []byte) error {
	type NoMethod UsageRateTimelineEntry
	var s1 struct {
		UsageRate gensupport.JSONFloat64 `json:"usageRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UsageRate = float64(s1.UsageRate)
	return nil
}

// VmResourceBasedCud: Specifies a resource-based committed use discount
// (CUD).
type VmResourceBasedCud struct {
	// GuestAccelerator: Guest accelerator, known as GPU.
	GuestAccelerator *GuestAccelerator `json:"guestAccelerator,omitempty"`

	// MachineSeries: The machine series for CUD. For example: "n1" for
	// general purpose N1 machine type commitments. "n2" for general purpose
	// N2 machine type commitments. "e2" for general purpose E2 machine type
	// commitments. "n2d" for general purpose N2D machine type commitments.
	// "t2d" for general purpose T2D machine type commitments. "c2"/"c2d"
	// for compute-optimized commitments. "m1"/"m2" for the memory-optimized
	// commitments. "a2' for the accelerator-optimized commitments.
	MachineSeries string `json:"machineSeries,omitempty"`

	// MemorySizeGb: Memory size of the VM in GB (2^30 bytes). Must be an
	// increment of 0.25 (256 MB).
	MemorySizeGb float64 `json:"memorySizeGb,omitempty"`

	// Plan: Commitment usage plan.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Not specified commitment plan.
	//   "TWELVE_MONTH" - 1 year commitment.
	//   "THIRTY_SIX_MONTH" - 3 years commitment.
	Plan string `json:"plan,omitempty"`

	// Region: The region where the VM runs. For example: "us-central1"
	Region string `json:"region,omitempty"`

	// VirtualCpuCount: The number of vCPUs. The number of vCPUs must be an
	// integer of 0 or more and can be even or odd.
	VirtualCpuCount int64 `json:"virtualCpuCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GuestAccelerator") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestAccelerator") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmResourceBasedCud) MarshalJSON() ([]byte, error) {
	type NoMethod VmResourceBasedCud
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *VmResourceBasedCud) UnmarshalJSON(data []byte) error {
	type NoMethod VmResourceBasedCud
	var s1 struct {
		MemorySizeGb gensupport.JSONFloat64 `json:"memorySizeGb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MemorySizeGb = float64(s1.MemorySizeGb)
	return nil
}

// Workload: Specifies usage on a single Google Cloud product over a
// time frame. Each Google Cloud product has its own message, containing
// specific product configuration parameters of the product usage
// amounts along each dimension in which the product is billed.
type Workload struct {
	// CloudStorageWorkload: Usage on Google Cloud Storage.
	CloudStorageWorkload *CloudStorageWorkload `json:"cloudStorageWorkload,omitempty"`

	// ComputeVmWorkload: Usage of a Google Compute Engine Virtual Machine.
	ComputeVmWorkload *ComputeVmWorkload `json:"computeVmWorkload,omitempty"`

	// Name: Required. A name for this workload. All workloads in a
	// `CostScenario` must have a unique `name`. Each `name` must be a
	// maximum of 32 characters.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CloudStorageWorkload") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudStorageWorkload") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Workload) MarshalJSON() ([]byte, error) {
	type NoMethod Workload
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WorkloadCostEstimate: Estimated cost for a workload.
type WorkloadCostEstimate struct {
	// Name: The name of the workload, as specified in the `CostScenario`.
	Name string `json:"name,omitempty"`

	// SkuCostEstimates: Estimated costs for each SKU in the workload.
	SkuCostEstimates []*SkuCostEstimate `json:"skuCostEstimates,omitempty"`

	// WorkloadTotalCostEstimate: Total estimated costs for the workload.
	WorkloadTotalCostEstimate *CostEstimate `json:"workloadTotalCostEstimate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WorkloadCostEstimate) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadCostEstimate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "cloudbilling.billingAccounts.estimateCostScenario":

type BillingAccountsEstimateCostScenarioCall struct {
	s                                            *Service
	billingAccount                               string
	estimatecostscenarioforbillingaccountrequest *EstimateCostScenarioForBillingAccountRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// EstimateCostScenario: Use custom pricing in the estimate, using a
// `CostScenario` with a defined `billingAccount`.
//
//   - billingAccount: Resource name of the billing account for the cost
//     estimate. The resource name has the form
//     `billingAccounts/{billing_acount_id}`. For example,
//     `billingAccounts/012345-567890-ABCDEF` is the resource name for
//     billing account `012345-567890-ABCDEF`. Must be specified.
func (r *BillingAccountsService) EstimateCostScenario(billingAccount string, estimatecostscenarioforbillingaccountrequest *EstimateCostScenarioForBillingAccountRequest) *BillingAccountsEstimateCostScenarioCall {
	c := &BillingAccountsEstimateCostScenarioCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.billingAccount = billingAccount
	c.estimatecostscenarioforbillingaccountrequest = estimatecostscenarioforbillingaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsEstimateCostScenarioCall) Fields(s ...googleapi.Field) *BillingAccountsEstimateCostScenarioCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsEstimateCostScenarioCall) Context(ctx context.Context) *BillingAccountsEstimateCostScenarioCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsEstimateCostScenarioCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsEstimateCostScenarioCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.estimatecostscenarioforbillingaccountrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+billingAccount}:estimateCostScenario")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"billingAccount": c.billingAccount,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.estimateCostScenario" call.
// Exactly one of *EstimateCostScenarioForBillingAccountResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *EstimateCostScenarioForBillingAccountResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsEstimateCostScenarioCall) Do(opts ...googleapi.CallOption) (*EstimateCostScenarioForBillingAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EstimateCostScenarioForBillingAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Use custom pricing in the estimate, using a `CostScenario` with a defined `billingAccount`.",
	//   "flatPath": "v1beta/billingAccounts/{billingAccountsId}:estimateCostScenario",
	//   "httpMethod": "POST",
	//   "id": "cloudbilling.billingAccounts.estimateCostScenario",
	//   "parameterOrder": [
	//     "billingAccount"
	//   ],
	//   "parameters": {
	//     "billingAccount": {
	//       "description": "Resource name of the billing account for the cost estimate. The resource name has the form `billingAccounts/{billing_acount_id}`. For example, `billingAccounts/012345-567890-ABCDEF` is the resource name for billing account `012345-567890-ABCDEF`. Must be specified.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+billingAccount}:estimateCostScenario",
	//   "request": {
	//     "$ref": "EstimateCostScenarioForBillingAccountRequest"
	//   },
	//   "response": {
	//     "$ref": "EstimateCostScenarioForBillingAccountResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-billing",
	//     "https://www.googleapis.com/auth/cloud-billing.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudbilling.estimateCostScenario":

type V1betaEstimateCostScenarioCall struct {
	s                                        *Service
	estimatecostscenariowithlistpricerequest *EstimateCostScenarioWithListPriceRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// EstimateCostScenario: Estimate list prices using a `CostScenario`
// without a defined `billingAccount`.
func (r *V1betaService) EstimateCostScenario(estimatecostscenariowithlistpricerequest *EstimateCostScenarioWithListPriceRequest) *V1betaEstimateCostScenarioCall {
	c := &V1betaEstimateCostScenarioCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.estimatecostscenariowithlistpricerequest = estimatecostscenariowithlistpricerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1betaEstimateCostScenarioCall) Fields(s ...googleapi.Field) *V1betaEstimateCostScenarioCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1betaEstimateCostScenarioCall) Context(ctx context.Context) *V1betaEstimateCostScenarioCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1betaEstimateCostScenarioCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1betaEstimateCostScenarioCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.estimatecostscenariowithlistpricerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta:estimateCostScenario")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.estimateCostScenario" call.
// Exactly one of *EstimateCostScenarioWithListPriceResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *EstimateCostScenarioWithListPriceResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *V1betaEstimateCostScenarioCall) Do(opts ...googleapi.CallOption) (*EstimateCostScenarioWithListPriceResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EstimateCostScenarioWithListPriceResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Estimate list prices using a `CostScenario` without a defined `billingAccount`.",
	//   "flatPath": "v1beta:estimateCostScenario",
	//   "httpMethod": "POST",
	//   "id": "cloudbilling.estimateCostScenario",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta:estimateCostScenario",
	//   "request": {
	//     "$ref": "EstimateCostScenarioWithListPriceRequest"
	//   },
	//   "response": {
	//     "$ref": "EstimateCostScenarioWithListPriceResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-billing",
	//     "https://www.googleapis.com/auth/cloud-billing.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
