// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contactcenterinsights provides access to the Contact Center AI Insights API.
//
// For product documentation, see: https://cloud.google.com/contact-center/insights/docs
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contactcenterinsights/v1"
//	...
//	ctx := context.Background()
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package contactcenterinsights // import "google.golang.org/api/contactcenterinsights/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "contactcenterinsights:v1"
const apiName = "contactcenterinsights"
const apiVersion = "v1"
const basePath = "https://contactcenterinsights.googleapis.com/"
const mtlsBasePath = "https://contactcenterinsights.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.Insightsdata = NewProjectsLocationsInsightsdataService(s)
	rs.IssueModels = NewProjectsLocationsIssueModelsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PhraseMatchers = NewProjectsLocationsPhraseMatchersService(s)
	rs.Views = NewProjectsLocationsViewsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Conversations *ProjectsLocationsConversationsService

	Insightsdata *ProjectsLocationsInsightsdataService

	IssueModels *ProjectsLocationsIssueModelsService

	Operations *ProjectsLocationsOperationsService

	PhraseMatchers *ProjectsLocationsPhraseMatchersService

	Views *ProjectsLocationsViewsService
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsConversationsAnalysesService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsConversationsAnalysesService
}

func NewProjectsLocationsConversationsAnalysesService(s *Service) *ProjectsLocationsConversationsAnalysesService {
	rs := &ProjectsLocationsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsInsightsdataService(s *Service) *ProjectsLocationsInsightsdataService {
	rs := &ProjectsLocationsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsIssueModelsService(s *Service) *ProjectsLocationsIssueModelsService {
	rs := &ProjectsLocationsIssueModelsService{s: s}
	rs.Issues = NewProjectsLocationsIssueModelsIssuesService(s)
	return rs
}

type ProjectsLocationsIssueModelsService struct {
	s *Service

	Issues *ProjectsLocationsIssueModelsIssuesService
}

func NewProjectsLocationsIssueModelsIssuesService(s *Service) *ProjectsLocationsIssueModelsIssuesService {
	rs := &ProjectsLocationsIssueModelsIssuesService{s: s}
	return rs
}

type ProjectsLocationsIssueModelsIssuesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPhraseMatchersService(s *Service) *ProjectsLocationsPhraseMatchersService {
	rs := &ProjectsLocationsPhraseMatchersService{s: s}
	return rs
}

type ProjectsLocationsPhraseMatchersService struct {
	s *Service
}

func NewProjectsLocationsViewsService(s *Service) *ProjectsLocationsViewsService {
	rs := &ProjectsLocationsViewsService{s: s}
	return rs
}

type ProjectsLocationsViewsService struct {
	s *Service
}

// GoogleCloudContactcenterinsightsV1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is
	// populated when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1AnalysisResult `json:"analysisResult,omitempty"`

	// CreateTime: Output only. The time at which the analysis was created,
	// which occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`

	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/a
	// nalyses/{analysis}
	Name string `json:"name,omitempty"`

	// RequestTime: Output only. The time at which the analysis was
	// requested.
	RequestTime string `json:"requestTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Analysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResult: The result of an
// analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`

	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CallAnalysisMetadata") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1CallAnnotation `json:"annotations,omitempty"`

	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1Entity `json:"entities,omitempty"`

	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1Intent `json:"intents,omitempty"`

	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1IssueModelResult `json:"issueModelResult,omitempty"`

	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchers,omitempty"`

	// Sentiments: Overall conversation-level sentiment for each channel of
	// the call.
	Sentiments []*GoogleCloudContactcenterinsightsV1ConversationLevelSentiment `json:"sentiments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of
	// the conversation where the boundary is located. This index starts at
	// zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`

	// WordIndex: The word index of this boundary with respect to the first
	// word in the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TranscriptIndex") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotationBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnswerFeedback: The feedback that
// the customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human
	// agent.
	Clicked bool `json:"clicked,omitempty"`

	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`

	// Displayed: Indicates whether an answer or item was displayed to the
	// human agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Clicked") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Clicked") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnswerFeedback
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a
	// good match for this conversation, ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`

	// Metadata: Map that contains metadata about the Article Suggestion and
	// the document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`

	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`

	// Source: The knowledge document that this answer was extracted from.
	// Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document
	// }
	Source string `json:"source,omitempty"`

	// Title: Article title.
	Title string `json:"title,omitempty"`

	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceScore") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse:
// Response of querying an issue model's statistics.
type GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse struct {
	// CurrentStats: The latest label statistics for the queried issue
	// model. Includes results on both training data and data labeled after
	// deployment.
	CurrentStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"currentStats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CurrentStats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentStats") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponse: The
// response for calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponse struct {
	// AverageDuration: The average duration of all conversations. The
	// average is calculated using only conversations that have a time
	// duration.
	AverageDuration string `json:"averageDuration,omitempty"`

	// AverageTurnCount: The average number of turns per conversation.
	AverageTurnCount int64 `json:"averageTurnCount,omitempty"`

	// ConversationCount: The total number of conversations.
	ConversationCount int64 `json:"conversationCount,omitempty"`

	// ConversationCountTimeSeries: A time series representing the count of
	// conversations created over time that match that requested filter
	// criteria.
	ConversationCountTimeSeries *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries `json:"conversationCountTimeSeries,omitempty"`

	// CustomHighlighterMatches: A map associating each custom highlighter
	// resource name with its respective number of matches in the set of
	// conversations.
	CustomHighlighterMatches map[string]int64 `json:"customHighlighterMatches,omitempty"`

	// IssueMatches: A map associating each issue resource name with its
	// respective number of matches in the set of conversations. Key has the
	// format: `projects//locations//issueModels//issues/` Deprecated, use
	// `issue_matches_stats` field instead.
	IssueMatches map[string]int64 `json:"issueMatches,omitempty"`

	// IssueMatchesStats: A map associating each issue resource name with
	// its respective number of matches in the set of conversations. Key has
	// the format: `projects//locations//issueModels//issues/`
	IssueMatchesStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueMatchesStats,omitempty"`

	// SmartHighlighterMatches: A map associating each smart highlighter
	// display name with its respective number of matches in the set of
	// conversations.
	SmartHighlighterMatches map[string]int64 `json:"smartHighlighterMatches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AverageDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AverageDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CalculateStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries: A
// time series representing conversations over time.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries struct {
	// IntervalDuration: The duration of each interval.
	IntervalDuration string `json:"intervalDuration,omitempty"`

	// Points: An ordered list of intervals from earliest to latest, where
	// each interval represents the number of conversations that transpired
	// during the time window.
	Points []*GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval `json:"points,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntervalDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntervalDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInte
// rval: A single interval in a time series.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval struct {
	// ConversationCount: The number of conversations created in this
	// interval.
	ConversationCount int64 `json:"conversationCount,omitempty"`

	// StartTime: The start time of this interval.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConversationCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CallAnnotation: A piece of metadata
// that applies to a window of a call.
type GoogleCloudContactcenterinsightsV1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the
	// annotation ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`

	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`

	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`

	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1EntityMentionData `json:"entityMentionData,omitempty"`

	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1HoldData `json:"holdData,omitempty"`

	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1IntentMatchData `json:"intentMatchData,omitempty"`

	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1InterruptionData `json:"interruptionData,omitempty"`

	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchData,omitempty"`

	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`

	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1SilenceData `json:"silenceData,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnnotationEndBoundary") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CallAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Conversation: The conversation
// resource.
type GoogleCloudContactcenterinsightsV1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human
	// agent who handled the conversation.
	AgentId string `json:"agentId,omitempty"`

	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1ConversationCallMetadata `json:"callMetadata,omitempty"`

	// CreateTime: Output only. The time at which the conversation was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DataSource: The source of the audio and transcription for the
	// conversation.
	DataSource *GoogleCloudContactcenterinsightsV1ConversationDataSource `json:"dataSource,omitempty"`

	// DialogflowIntents: Output only. All the matched Dialogflow intents in
	// the call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1DialogflowIntent `json:"dialogflowIntents,omitempty"`

	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`

	// ExpireTime: The time at which this conversation should expire. After
	// this time, the conversation data and any associated analyses will be
	// deleted.
	ExpireTime string `json:"expireTime,omitempty"`

	// Labels: A map for the user to specify any custom fields. A maximum of
	// 20 labels per conversation is allowed, with a maximum of 256
	// characters per entry.
	Labels map[string]string `json:"labels,omitempty"`

	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`

	// LatestAnalysis: Output only. The conversation's latest analysis, if
	// one exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1Analysis `json:"latestAnalysis,omitempty"`

	// Medium: Immutable. The conversation medium, if unspecified will
	// default to PHONE_CALL.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default
	// to PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over
	// the phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`

	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`

	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`

	// RuntimeAnnotations: Output only. The annotations that were generated
	// during the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`

	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`

	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1ConversationTranscript `json:"transcript,omitempty"`

	// Ttl: Input only. The TTL for this resource. If specified, then this
	// TTL will be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`

	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`

	// UpdateTime: Output only. The most recent time at which the
	// conversation was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AgentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Conversation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCallMetadata:
// Call-specific metadata.
type GoogleCloudContactcenterinsightsV1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`

	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentChannel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCallMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataSource: The
// conversation source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from
	// Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1DialogflowSource `json:"dialogflowSource,omitempty"`

	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1GcsSource `json:"gcsSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DialogflowSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSentiment: One
// channel of conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`

	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelTag") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSentiment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/p
	// articipants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`

	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/p
	// articipants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`

	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`

	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the
	// contact center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`

	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DialogflowParticipant") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationParticipant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that
	// comprise the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TranscriptSegments")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TranscriptSegments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscript
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegm
// ent: A segment of a full transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this
	// is the channel number corresponding to the audio from that channel.
	// For audioChannelCount = N, its output values can range from '1' to
	// 'N'. A channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`

	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity
	// of this segment. A default value of 0.0 indicates that the value is
	// unset.
	Confidence float64 `json:"confidence,omitempty"`

	// DialogflowSegmentMetadata: CCAI metadata relating to the current
	// transcript segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`

	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`

	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`

	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1ConversationParticipant `json:"segmentParticipant,omitempty"`

	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`

	// Text: The text of this segment.
	Text string `json:"text,omitempty"`

	// Words: A list of the word-specific information for each word in the
	// segment.
	Words []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelTag") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegm
// entDialogflowSegmentMetadata: Metadata from Dialogflow relating to
// the current transcript segment.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was
	// covered under the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SmartReplyAllowlistCovered") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SmartReplyAllowlistCovered") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegm
// entWordInfo: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity
	// of this word. A default value of 0.0 indicates that the value is
	// unset.
	Confidence float64 `json:"confidence,omitempty"`

	// EndOffset: Time offset of the end of this word relative to the
	// beginning of the total conversation.
	EndOffset string `json:"endOffset,omitempty"`

	// StartOffset: Time offset of the start of this word relative to the
	// beginning of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`

	// Word: The word itself. Includes punctuation marks that surround the
	// word.
	Word string `json:"word,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata:
// Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata struct {
	// Conversation: Output only. The Conversation that this Analysis
	// Operation belongs to.
	Conversation string `json:"conversation,omitempty"`

	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata: Metadata
// for creating an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelRequest: The
// request to create an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`

	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IssueModel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata: Metadata
// for deleting an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest: The
// request to delete an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata: Metadata
// for deploying an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelRequest: The
// request to deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelResponse: The
// response to deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation,
// e.g. MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowIntent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DialogflowInteractionData:
// Dialogflow interaction data.
type GoogleCloudContactcenterinsightsV1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1DialogflowSource: A Dialogflow
// source of conversation data.
type GoogleCloudContactcenterinsightsV1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`

	// DialogflowConversation: Output only. The name of the Dialogflow
	// conversation that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Entity: The data for an entity
// annotation. Represents a phrase in the conversation that is a known
// entity, such as a person, an organization, or location.
type GoogleCloudContactcenterinsightsV1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`

	// Metadata: Metadata associated with the entity. For most entity types,
	// the metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph
	// MID (`mid`), if they are available. For the metadata associated with
	// other entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`

	// Salience: The salience score associated with the entity in the [0,
	// 1.0] range. The salience score for an entity provides information
	// about the importance or centrality of that entity to the entire
	// document text. Scores closer to 0 are less salient, while scores
	// closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`

	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`

	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken
	// down into sections according to local convention. * `national_prefix`
	// - Country code, if detected. * `area_code` - Region or area code, if
	// detected. * `extension` - Phone extension (to be dialed after
	// connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` -
	// Postal code, if detected. * `country` - Country, if detected. *
	// `broad_region` - Administrative area, such as the state, if detected.
	// * `narrow_region` - Smaller administrative area, such as county, if
	// detected. * `sublocality` - Used in Asian addresses to demark a
	// district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date:
	// * `year` - Four digit year, if detected. * `month` - Two digit month
	// number, if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and
	// `currency`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1EntityMentionData: The data for an
// entity mention annotation. This represents a mention of an `Entity`
// in the conversation.
type GoogleCloudContactcenterinsightsV1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can
	// be used to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`

	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`

	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityUniqueId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EntityMentionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExactMatchConfig: Exact match
// configuration.
type GoogleCloudContactcenterinsightsV1ExactMatchConfig struct {
	// CaseSensitive: Whether to consider case sensitivity when performing
	// an exact match.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ExactMatchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExactMatchConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata:
// Metadata for an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// PartialErrors: Partial errors during export operation that might
	// cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`

	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest: The
// request to export insights.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`

	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`

	// KmsKey: A fully qualified KMS key name for BigQuery tables protected
	// by CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/
	// {key}/cryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`

	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`

	// WriteDisposition: Options for what to do if the destination table
	// already exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not
	// specified. Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will
	// overwrite the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append
	// data to the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDes
// tination: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot
	// result should be exported to. If this dataset does not exist, the
	// export call returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`

	// ProjectId: A project ID or number. If specified, then export will
	// attempt to write data to this project instead of the resource
	// project. Otherwise, the resource project will be used.
	ProjectId string `json:"projectId,omitempty"`

	// Table: The BigQuery table name to which the insights data should be
	// written. If this table does not exist, the export call returns an
	// INVALID_ARGUMENT error.
	Table string `json:"table,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse:
// Response for an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`

	// ConfidenceScore: The system's confidence score that this answer is a
	// good match for this conversation, ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`

	// Metadata: Map that contains metadata about the FAQ answer and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`

	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`

	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`

	// Source: The knowledge document that this answer was extracted from.
	// Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document
	// }.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Answer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1GcsSource: A Cloud Storage source
// of conversation data.
type GoogleCloudContactcenterinsightsV1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`

	// TranscriptUri: Immutable. Cloud Storage URI that points to a file
	// that contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1HoldData: The data for a hold
// annotation.
type GoogleCloudContactcenterinsightsV1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1Intent: The data for an intent.
// Represents a detected intent in the conversation, for example
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`

	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Intent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IntentMatchData: The data for an
// intent match. Represents an intent match for a text segment in the
// conversation. A text segment can be part of a sentence, a complete
// sentence, or an utterance with multiple sentences.
type GoogleCloudContactcenterinsightsV1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve
	// the corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntentUniqueId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IntentMatchData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issu
	// es/{issue}
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The most recent time that this issue was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Issue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueAssignment: Information about
// the issue.
type GoogleCloudContactcenterinsightsV1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This
	// field is set at time of analyis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`

	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`

	// Score: Score indicating the likelihood of the issue assignment.
	// currently bounded on [0,1].
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1IssueModel: The issue model
// resource.
type GoogleCloudContactcenterinsightsV1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`

	// InputDataConfig: Configs for the input data that used to create the
	// issue model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`

	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`

	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can
	// only be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`

	// TrainingStats: Output only. Immutable. The issue model's label
	// statistics on its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"trainingStats,omitempty"`

	// UpdateTime: Output only. The most recent time at which the issue
	// model was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig: Configs
// for the input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the
	// model to a specific subset.
	Filter string `json:"filter,omitempty"`

	// Medium: Medium of conversations used in training data. This field is
	// being deprecated. To specify the medium to be used in training a new
	// issue model, set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default
	// to PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over
	// the phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`

	// TrainingConversationsCount: Output only. Number of conversations used
	// in training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model
	// has analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`

	// IssueStats: Statistics on each issue. Key is the issue's resource
	// name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`

	// UnclassifiedConversationsCount: Number of analyzed conversations for
	// which no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "AnalyzedConversationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnalyzedConversationsCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats:
// Aggregated statistics about an issue.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`

	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issu
	// es/{issue}
	Issue string `json:"issue,omitempty"`

	// LabeledConversationsCount: Number of conversations attached to the
	// issue at this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelResult: Issue Modeling
// result on a conversation.
type GoogleCloudContactcenterinsightsV1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`

	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IssueModel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysesResponse: The response
// to list analyses.
type GoogleCloudContactcenterinsightsV1ListAnalysesResponse struct {
	// Analyses: The analyses that match the request.
	Analyses []*GoogleCloudContactcenterinsightsV1Analysis `json:"analyses,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Analyses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Analyses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListAnalysesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListConversationsResponse: The
// response of listing conversations.
type GoogleCloudContactcenterinsightsV1ListConversationsResponse struct {
	// Conversations: The conversations that match the request.
	Conversations []*GoogleCloudContactcenterinsightsV1Conversation `json:"conversations,omitempty"`

	// NextPageToken: A token which can be sent as `page_token` to retrieve
	// the next page. If this field is set, it means there is another page
	// available. If it is not set, it means no other pages are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListConversationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssueModelsResponse: The
// response of listing issue models.
type GoogleCloudContactcenterinsightsV1ListIssueModelsResponse struct {
	// IssueModels: The issue models that match the request.
	IssueModels []*GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IssueModels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListIssueModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssueModelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssuesResponse: The response of
// listing issues.
type GoogleCloudContactcenterinsightsV1ListIssuesResponse struct {
	// Issues: The issues that match the request.
	Issues []*GoogleCloudContactcenterinsightsV1Issue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Issues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Issues") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssuesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse: The
// response of listing phrase matchers.
type GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PhraseMatchers: The phrase matchers that match the request.
	PhraseMatchers []*GoogleCloudContactcenterinsightsV1PhraseMatcher `json:"phraseMatchers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListViewsResponse: The response of
// listing views.
type GoogleCloudContactcenterinsightsV1ListViewsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Views: The views that match the request.
	Views []*GoogleCloudContactcenterinsightsV1View `json:"views,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1ListViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListViewsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchData: The data for a
// matched phrase matcher. Represents information identifying a phrase
// matcher for a given match.
type GoogleCloudContactcenterinsightsV1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`

	// PhraseMatcher: The unique identifier (the resource name) of the
	// phrase matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRule: The data for a
// phrase match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRule struct {
	// Config: Provides additional information about the rule that specifies
	// how to apply the rule.
	Config *GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig `json:"config,omitempty"`

	// Negated: Specifies whether the phrase must be missing from the
	// transcript segment or present in the transcript segment.
	Negated bool `json:"negated,omitempty"`

	// Query: Required. The phrase to be matched.
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1PhraseMatchRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig:
// Configuration information of a phrase match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig struct {
	// ExactMatchConfig: The configuration for the exact match rule.
	ExactMatchConfig *GoogleCloudContactcenterinsightsV1ExactMatchConfig `json:"exactMatchConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatchConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatchConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup: A message
// representing a rule in the phrase matcher.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup struct {
	// PhraseMatchRules: A list of phase match rules that are included in
	// this group.
	PhraseMatchRules []*GoogleCloudContactcenterinsightsV1PhraseMatchRule `json:"phraseMatchRules,omitempty"`

	// Type: Required. The type of this phrase match rule group.
	//
	// Possible values:
	//   "PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rules or there is no match.
	//   "ANY_OF" - If any of the phrase match rules are met, there is a
	// match.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhraseMatchRules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhraseMatchRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatcher: The phrase matcher
// resource.
type GoogleCloudContactcenterinsightsV1PhraseMatcher struct {
	// ActivationUpdateTime: Output only. The most recent time at which the
	// activation status was updated.
	ActivationUpdateTime string `json:"activationUpdateTime,omitempty"`

	// Active: Applies the phrase matcher only when it is active.
	Active bool `json:"active,omitempty"`

	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The resource name of the phrase matcher. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher
	// }
	Name string `json:"name,omitempty"`

	// PhraseMatchRuleGroups: A list of phase match rule groups that are
	// included in this matcher.
	PhraseMatchRuleGroups []*GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup `json:"phraseMatchRuleGroups,omitempty"`

	// RevisionCreateTime: Output only. The timestamp of when the revision
	// was created. It is also the create time when a new matcher is added.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionId: Output only. Immutable. The revision ID of the phrase
	// matcher. A new revision is committed whenever the matcher is changed,
	// except when it is activated or deactivated. A server generated random
	// ID will be used. Example:
	// locations/global/phraseMatchers/my-first-matcher@1234567
	RevisionId string `json:"revisionId,omitempty"`

	// RoleMatch: The role whose utterances the phrase matcher should be
	// matched against. If the role is ROLE_UNSPECIFIED it will be matched
	// against any utterances in the transcript.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the
	// contact center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	RoleMatch string `json:"roleMatch,omitempty"`

	// Type: Required. The type of this phrase matcher.
	//
	// Possible values:
	//   "PHRASE_MATCHER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rule groups or there is no
	// match.
	//   "ANY_OF" - If any of the phrase match rule groups are met, there is
	// a match.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The most recent time at which the phrase
	// matcher was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// VersionTag: The customized version tag to use for the phrase matcher.
	// If not specified, it will default to `revision_id`.
	VersionTag string `json:"versionTag,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ActivationUpdateTime") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivationUpdateTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1PhraseMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotation: An annotation
// that was generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}
	// /conversationDataItems/{data_item}/conversationAnnotations/{annotation
	// }
	AnnotationId string `json:"annotationId,omitempty"`

	// AnswerFeedback: The feedback that the customer has about the answer
	// in `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1AnswerFeedback `json:"answerFeedback,omitempty"`

	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1ArticleSuggestionData `json:"articleSuggestion,omitempty"`

	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`

	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`

	// EndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"endBoundary,omitempty"`

	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1FaqAnswerData `json:"faqAnswer,omitempty"`

	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`

	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1SmartReplyData `json:"smartReply,omitempty"`

	// StartBoundary: The boundary in the conversation where the annotation
	// starts, inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"startBoundary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnnotationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SentimentData: The data for a
// sentiment annotation.
type GoogleCloudContactcenterinsightsV1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents
	// the abolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: The sentiment score between -1.0 (negative) and 1.0
	// (positive).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1Settings: The settings resource.
type GoogleCloudContactcenterinsightsV1Settings struct {
	// AnalysisConfig: Default analysis settings.
	AnalysisConfig *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig `json:"analysisConfig,omitempty"`

	// ConversationTtl: The default TTL for newly-created conversations. If
	// a conversation has a specified expiration, that value will be used
	// instead. Changing this value will not change the expiration of
	// existing conversations. Conversations with no expire time persist
	// until they are deleted.
	ConversationTtl string `json:"conversationTtl,omitempty"`

	// CreateTime: Output only. The time at which the settings was created.
	CreateTime string `json:"createTime,omitempty"`

	// LanguageCode: A language code to be applied to each transcript
	// segment unless the segment already specifies a language code.
	// Language code defaults to "en-US" if it is neither specified on the
	// segment nor here.
	LanguageCode string `json:"languageCode,omitempty"`

	// Name: Immutable. The resource name of the settings resource. Format:
	// projects/{project}/locations/{location}/settings
	Name string `json:"name,omitempty"`

	// PubsubNotificationSettings: A map that maps a notification trigger to
	// a Pub/Sub topic. Each time a specified trigger occurs, Insights will
	// notify the corresponding Pub/Sub topic. Keys are notification
	// triggers. Supported keys are: * "all-triggers": Notify each time any
	// of the supported triggers occurs. * "create-analysis": Notify each
	// time an analysis is created. * "create-conversation": Notify each
	// time a conversation is created. * "export-insights-data": Notify each
	// time an export is complete. * "update-conversation": Notify each time
	// a conversation is updated via UpdateConversation. Values are Pub/Sub
	// topics. The format of each Pub/Sub topic is:
	// projects/{project}/topics/{topic}
	PubsubNotificationSettings map[string]string `json:"pubsubNotificationSettings,omitempty"`

	// UpdateTime: Output only. The time at which the settings were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AnalysisConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1Settings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Settings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig: Default
// configuration when creating Analyses in Insights.
type GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig struct {
	// RuntimeIntegrationAnalysisPercentage: Percentage of conversations
	// created using Dialogflow runtime integration to analyze
	// automatically, between [0, 100].
	RuntimeIntegrationAnalysisPercentage float64 `json:"runtimeIntegrationAnalysisPercentage,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RuntimeIntegrationAnalysisPercentage") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "RuntimeIntegrationAnalysisPercentage") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	var s1 struct {
		RuntimeIntegrationAnalysisPercentage gensupport.JSONFloat64 `json:"runtimeIntegrationAnalysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RuntimeIntegrationAnalysisPercentage = float64(s1.RuntimeIntegrationAnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData: Agent
// Assist Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion
	// is a good match for this conversation, ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`

	// Metadata: Map that contains metadata about the Smart Compose
	// suggestion and the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`

	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceScore") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SmartReplyData: Agent Assist Smart
// Reply data.
type GoogleCloudContactcenterinsightsV1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a
	// good match for this conversation, ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`

	// Metadata: Map that contains metadata about the Smart Reply and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`

	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceScore") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata:
// Metadata for undeploying an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest: The
// request to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse: The
// response to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1View: The View resource.
type GoogleCloudContactcenterinsightsV1View struct {
	// CreateTime: Output only. The time at which this view was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The human-readable display name of the view.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Immutable. The resource name of the view. Format:
	// projects/{project}/locations/{location}/views/{view}
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The most recent time at which the view was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// Value: String with specific view properties.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1View) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1View
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadat
// a: Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata struct {
	// Conversation: Output only. The Conversation that this Analysis
	// Operation belongs to.
	Conversation string `json:"conversation,omitempty"`

	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata:
// Metadata for creating an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest: The
// request to create an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`

	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IssueModel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata:
// Metadata for deleting an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest: The
// request to delete an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata:
// Metadata for deploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest: The
// request to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse: The
// response to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata:
// Metadata for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// PartialErrors: Partial errors during export operation that might
	// cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`

	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest:
// The request to export insights.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`

	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`

	// KmsKey: A fully qualified KMS key name for BigQuery tables protected
	// by CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/
	// {key}/cryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`

	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`

	// WriteDisposition: Options for what to do if the destination table
	// already exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not
	// specified. Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will
	// overwrite the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append
	// data to the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQu
// eryDestination: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot
	// result should be exported to. If this dataset does not exist, the
	// export call returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`

	// ProjectId: A project ID or number. If specified, then export will
	// attempt to write data to this project instead of the resource
	// project. Otherwise, the resource project will be used.
	ProjectId string `json:"projectId,omitempty"`

	// Table: The BigQuery table name to which the insights data should be
	// written. If this table does not exist, the export call returns an
	// INVALID_ARGUMENT error.
	Table string `json:"table,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse:
// Response for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModel: The issue model
// resource.
type GoogleCloudContactcenterinsightsV1alpha1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`

	// InputDataConfig: Configs for the input data that used to create the
	// issue model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`

	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`

	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can
	// only be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`

	// TrainingStats: Output only. Immutable. The issue model's label
	// statistics on its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats `json:"trainingStats,omitempty"`

	// UpdateTime: Output only. The most recent time at which the issue
	// model was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig:
// Configs for the input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the
	// model to a specific subset.
	Filter string `json:"filter,omitempty"`

	// Medium: Medium of conversations used in training data. This field is
	// being deprecated. To specify the medium to be used in training a new
	// issue model, set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default
	// to PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over
	// the phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`

	// TrainingConversationsCount: Output only. Number of conversations used
	// in training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats:
// Aggregated statistics about an issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model
	// has analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`

	// IssueStats: Statistics on each issue. Key is the issue's resource
	// name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`

	// UnclassifiedConversationsCount: Number of analyzed conversations for
	// which no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "AnalyzedConversationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnalyzedConversationsCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats
// : Aggregated statistics about an issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`

	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issu
	// es/{issue}
	Issue string `json:"issue,omitempty"`

	// LabeledConversationsCount: Number of conversations attached to the
	// issue at this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata:
// Metadata for undeploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest `json:"request,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest:
// The request to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse:
// The response to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "contactcenterinsights.projects.locations.getSettings":

type ProjectsLocationsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets project-level settings.
//
// - name: The name of the settings resource to get.
func (r *ProjectsLocationsService) GetSettings(name string) *ProjectsLocationsGetSettingsCall {
	c := &ProjectsLocationsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetSettingsCall) Context(ctx context.Context) *ProjectsLocationsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.getSettings" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Settings or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGetSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets project-level settings.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/settings",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.getSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings resource to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/settings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Settings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.updateSettings":

type ProjectsLocationsUpdateSettingsCall struct {
	s                                          *Service
	name                                       string
	googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// UpdateSettings: Updates project-level settings.
//
//   - name: Immutable. The resource name of the settings resource.
//     Format: projects/{project}/locations/{location}/settings.
func (r *ProjectsLocationsService) UpdateSettings(name string, googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings) *ProjectsLocationsUpdateSettingsCall {
	c := &ProjectsLocationsUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1settings = googlecloudcontactcenterinsightsv1settings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated.
func (c *ProjectsLocationsUpdateSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsUpdateSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsUpdateSettingsCall) Context(ctx context.Context) *ProjectsLocationsUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1settings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.updateSettings" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Settings or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates project-level settings.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/settings",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.updateSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the settings resource. Format: projects/{project}/locations/{location}/settings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/settings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Settings"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Settings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.calculateStats":

type ProjectsLocationsConversationsCalculateStatsCall struct {
	s            *Service
	location     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateStats: Gets conversation statistics.
//
// - location: The location of the conversations.
func (r *ProjectsLocationsConversationsService) CalculateStats(location string) *ProjectsLocationsConversationsCalculateStatsCall {
	c := &ProjectsLocationsConversationsCalculateStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce
// results to a specific subset. This field is useful for getting
// statistics about conversations with specific properties.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Filter(filter string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConversationsCalculateStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Context(ctx context.Context) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCalculateStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}/conversations:calculateStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.calculateStats" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1CalculateStatsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateStatsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets conversation statistics.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations:calculateStats",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.conversations.calculateStats",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "location": {
	//       "description": "Required. The location of the conversations.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+location}/conversations:calculateStats",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1CalculateStatsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.create":

type ProjectsLocationsConversationsCreateCall struct {
	s                                              *Service
	parent                                         string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a conversation.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) Create(parent string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsCreateCall {
	c := &ProjectsLocationsConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// ConversationId sets the optional parameter "conversationId": A unique
// ID for the new conversation. This ID will become the final component
// of the conversation's resource name. If no ID is specified, a
// server-generated ID will be used. This value should be 4-64
// characters and must match the regular expression `^[a-z0-9-]{4,64}$`.
// Valid characters are `a-z-`
func (c *ProjectsLocationsConversationsCreateCall) ConversationId(conversationId string) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("conversationId", conversationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.create" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Conversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a conversation.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.conversations.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "conversationId": {
	//       "description": "A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid characters are `a-z-`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource of the conversation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/conversations",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Conversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Conversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.delete":

type ProjectsLocationsConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a conversation.
//
// - name: The name of the conversation to delete.
func (r *ProjectsLocationsConversationsService) Delete(name string) *ProjectsLocationsConversationsDeleteCall {
	c := &ProjectsLocationsConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of
// this conversation's analyses will also be deleted. Otherwise, the
// request will only succeed if the conversation has no analyses.
func (c *ProjectsLocationsConversationsDeleteCall) Force(force bool) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a conversation.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "contactcenterinsights.projects.locations.conversations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "force": {
	//       "description": "If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the conversation to delete.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.get":

type ProjectsLocationsConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a conversation.
//
// - name: The name of the conversation to get.
func (r *ProjectsLocationsConversationsService) Get(name string) *ProjectsLocationsConversationsGetCall {
	c := &ProjectsLocationsConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `FULL`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not
//
// specified. * Defaults to `FULL` in `GetConversationRequest`. *
// Defaults to `BASIC` in `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the
//
// transcript.
func (c *ProjectsLocationsConversationsGetCall) View(view string) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Conversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a conversation.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.conversations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the conversation to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The level of details of the conversation. Default is `FULL`.",
	//       "enum": [
	//         "CONVERSATION_VIEW_UNSPECIFIED",
	//         "FULL",
	//         "BASIC"
	//       ],
	//       "enumDescriptions": [
	//         "The conversation view is not specified. * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in `ListConversationsRequest`.",
	//         "Populates all fields in the conversation.",
	//         "Populates all fields in the conversation except the transcript."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Conversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.list":

type ProjectsLocationsConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists conversations.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) List(parent string) *ProjectsLocationsConversationsListCall {
	c := &ProjectsLocationsConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce
// results to a specific subset. Useful for querying conversations with
// specific properties.
func (c *ProjectsLocationsConversationsListCall) Filter(filter string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of conversations to return in the response. A valid page size ranges
// from 0 to 1,000 inclusive. If the page size is zero or unspecified, a
// default page size of 100 will be chosen. Note that a call might
// return fewer results than the requested page size.
func (c *ProjectsLocationsConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListConversationsResponse`. This value indicates that
// this is a continuation of a prior `ListConversations` call and that
// the system should return the next page of data.
func (c *ProjectsLocationsConversationsListCall) PageToken(pageToken string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `BASIC`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not
//
// specified. * Defaults to `FULL` in `GetConversationRequest`. *
// Defaults to `BASIC` in `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the
//
// transcript.
func (c *ProjectsLocationsConversationsListCall) View(view string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsListCall) Context(ctx context.Context) *ProjectsLocationsConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.list" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1ListConversationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1ListConversationsResponse.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists conversations.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.conversations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of conversations to return in the response. A valid page size ranges from 0 to 1,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListConversationsResponse`. This value indicates that this is a continuation of a prior `ListConversations` call and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource of the conversation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The level of details of the conversation. Default is `BASIC`.",
	//       "enum": [
	//         "CONVERSATION_VIEW_UNSPECIFIED",
	//         "FULL",
	//         "BASIC"
	//       ],
	//       "enumDescriptions": [
	//         "The conversation view is not specified. * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in `ListConversationsRequest`.",
	//         "Populates all fields in the conversation.",
	//         "Populates all fields in the conversation except the transcript."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/conversations",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListConversationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "contactcenterinsights.projects.locations.conversations.patch":

type ProjectsLocationsConversationsPatchCall struct {
	s                                              *Service
	name                                           string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a conversation.
//
//   - name: Immutable. The resource name of the conversation. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}.
func (r *ProjectsLocationsConversationsService) Patch(name string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsPatchCall {
	c := &ProjectsLocationsConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.patch" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Conversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a conversation.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.conversations.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the conversation. Format: projects/{project}/locations/{location}/conversations/{conversation}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Conversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Conversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.analyses.create":

type ProjectsLocationsConversationsAnalysesCreateCall struct {
	s                                          *Service
	parent                                     string
	googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates an analysis. The long running operation is done when
// the analysis has completed.
//
// - parent: The parent resource of the analysis.
func (r *ProjectsLocationsConversationsAnalysesService) Create(parent string, googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis) *ProjectsLocationsConversationsAnalysesCreateCall {
	c := &ProjectsLocationsConversationsAnalysesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1analysis = googlecloudcontactcenterinsightsv1analysis
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1analysis)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an analysis. The long running operation is done when the analysis has completed.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}/analyses",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.conversations.analyses.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the analysis.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/analyses",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Analysis"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.analyses.delete":

type ProjectsLocationsConversationsAnalysesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an analysis.
//
// - name: The name of the analysis to delete.
func (r *ProjectsLocationsConversationsAnalysesService) Delete(name string) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c := &ProjectsLocationsConversationsAnalysesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an analysis.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}/analyses/{analysesId}",
	//   "httpMethod": "DELETE",
	//   "id": "contactcenterinsights.projects.locations.conversations.analyses.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the analysis to delete.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+/analyses/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.analyses.get":

type ProjectsLocationsConversationsAnalysesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an analysis.
//
// - name: The name of the analysis to get.
func (r *ProjectsLocationsConversationsAnalysesService) Get(name string) *ProjectsLocationsConversationsAnalysesGetCall {
	c := &ProjectsLocationsConversationsAnalysesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConversationsAnalysesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsAnalysesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Analysis or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1Analysis.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Analysis, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Analysis{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an analysis.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}/analyses/{analysesId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.conversations.analyses.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the analysis to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+/analyses/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Analysis"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.conversations.analyses.list":

type ProjectsLocationsConversationsAnalysesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists analyses.
//
// - parent: The parent resource of the analyses.
func (r *ProjectsLocationsConversationsAnalysesService) List(parent string) *ProjectsLocationsConversationsAnalysesListCall {
	c := &ProjectsLocationsConversationsAnalysesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce
// results to a specific subset. Useful for querying conversations with
// specific properties.
func (c *ProjectsLocationsConversationsAnalysesListCall) Filter(filter string) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of analyses to return in the response. If this value is zero, the
// service will select a default size. A call might return fewer objects
// than requested. A non-empty `next_page_token` in the response
// indicates that more data is available.
func (c *ProjectsLocationsConversationsAnalysesListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListAnalysesResponse`; indicates that this is a
// continuation of a prior `ListAnalyses` call and the system should
// return the next page of data.
func (c *ProjectsLocationsConversationsAnalysesListCall) PageToken(pageToken string) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConversationsAnalysesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConversationsAnalysesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsAnalysesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConversationsAnalysesListCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConversationsAnalysesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.list" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1ListAnalysesResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1ListAnalysesResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsAnalysesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAnalysesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAnalysesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists analyses.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/conversations/{conversationsId}/analyses",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.conversations.analyses.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of analyses to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListAnalysesResponse`; indicates that this is a continuation of a prior `ListAnalyses` call and the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource of the analyses.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/analyses",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListAnalysesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsAnalysesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAnalysesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "contactcenterinsights.projects.locations.insightsdata.export":

type ProjectsLocationsInsightsdataExportCall struct {
	s                                                           *Service
	parent                                                      string
	googlecloudcontactcenterinsightsv1exportinsightsdatarequest *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Export: Export insights data to a destination defined in the request
// body.
//
// - parent: The parent resource to export data from.
func (r *ProjectsLocationsInsightsdataService) Export(parent string, googlecloudcontactcenterinsightsv1exportinsightsdatarequest *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) *ProjectsLocationsInsightsdataExportCall {
	c := &ProjectsLocationsInsightsdataExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1exportinsightsdatarequest = googlecloudcontactcenterinsightsv1exportinsightsdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsInsightsdataExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsInsightsdataExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsInsightsdataExportCall) Context(ctx context.Context) *ProjectsLocationsInsightsdataExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsInsightsdataExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInsightsdataExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1exportinsightsdatarequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insightsdata:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.insightsdata.export" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsInsightsdataExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Export insights data to a destination defined in the request body.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/insightsdata:export",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.insightsdata.export",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource to export data from.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/insightsdata:export",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.calculateIssueModelStats":

type ProjectsLocationsIssueModelsCalculateIssueModelStatsCall struct {
	s            *Service
	issueModel   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateIssueModelStats: Gets an issue model's statistics.
//
// - issueModel: The resource name of the issue model to query against.
func (r *ProjectsLocationsIssueModelsService) CalculateIssueModelStats(issueModel string) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c := &ProjectsLocationsIssueModelsCalculateIssueModelStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.issueModel = issueModel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+issueModel}:calculateIssueModelStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"issueModel": c.issueModel,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.calculateIssueModelStats" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse.Se
// rverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an issue model's statistics.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}:calculateIssueModelStats",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.issueModels.calculateIssueModelStats",
	//   "parameterOrder": [
	//     "issueModel"
	//   ],
	//   "parameters": {
	//     "issueModel": {
	//       "description": "Required. The resource name of the issue model to query against.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+issueModel}:calculateIssueModelStats",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.create":

type ProjectsLocationsIssueModelsCreateCall struct {
	s                                            *Service
	parent                                       string
	googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Create: Creates an issue model.
//
// - parent: The parent resource of the issue model.
func (r *ProjectsLocationsIssueModelsService) Create(parent string, googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel) *ProjectsLocationsIssueModelsCreateCall {
	c := &ProjectsLocationsIssueModelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1issuemodel = googlecloudcontactcenterinsightsv1issuemodel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsCreateCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issuemodel)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issueModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an issue model.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.issueModels.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the issue model.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/issueModels",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1IssueModel"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.delete":

type ProjectsLocationsIssueModelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an issue model.
//
// - name: The name of the issue model to delete.
func (r *ProjectsLocationsIssueModelsService) Delete(name string) *ProjectsLocationsIssueModelsDeleteCall {
	c := &ProjectsLocationsIssueModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an issue model.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}",
	//   "httpMethod": "DELETE",
	//   "id": "contactcenterinsights.projects.locations.issueModels.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the issue model to delete.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.deploy":

type ProjectsLocationsIssueModelsDeployCall struct {
	s                                                         *Service
	name                                                      string
	googlecloudcontactcenterinsightsv1deployissuemodelrequest *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Deploy: Deploys an issue model. Returns an error if a model is
// already deployed. An issue model can only be used in analysis after
// it has been deployed.
//
// - name: The issue model to deploy.
func (r *ProjectsLocationsIssueModelsService) Deploy(name string, googlecloudcontactcenterinsightsv1deployissuemodelrequest *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) *ProjectsLocationsIssueModelsDeployCall {
	c := &ProjectsLocationsIssueModelsDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1deployissuemodelrequest = googlecloudcontactcenterinsightsv1deployissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsDeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsDeployCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1deployissuemodelrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.deploy" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsDeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deploys an issue model. Returns an error if a model is already deployed. An issue model can only be used in analysis after it has been deployed.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}:deploy",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.issueModels.deploy",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The issue model to deploy.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:deploy",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1DeployIssueModelRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.get":

type ProjectsLocationsIssueModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an issue model.
//
// - name: The name of the issue model to get.
func (r *ProjectsLocationsIssueModelsService) Get(name string) *ProjectsLocationsIssueModelsGetCall {
	c := &ProjectsLocationsIssueModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsIssueModelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsGetCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1IssueModel or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1IssueModel.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1IssueModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1IssueModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an issue model.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.issueModels.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the issue model to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1IssueModel"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.list":

type ProjectsLocationsIssueModelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists issue models.
//
// - parent: The parent resource of the issue model.
func (r *ProjectsLocationsIssueModelsService) List(parent string) *ProjectsLocationsIssueModelsListCall {
	c := &ProjectsLocationsIssueModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsIssueModelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsListCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issueModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.list" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1ListIssueModelsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1ListIssueModelsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListIssueModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListIssueModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists issue models.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.issueModels.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the issue model.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/issueModels",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListIssueModelsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.patch":

type ProjectsLocationsIssueModelsPatchCall struct {
	s                                            *Service
	name                                         string
	googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Patch: Updates an issue model.
//
//   - name: Immutable. The resource name of the issue model. Format:
//     projects/{project}/locations/{location}/issueModels/{issue_model}.
func (r *ProjectsLocationsIssueModelsService) Patch(name string, googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel) *ProjectsLocationsIssueModelsPatchCall {
	c := &ProjectsLocationsIssueModelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1issuemodel = googlecloudcontactcenterinsightsv1issuemodel
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsIssueModelsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsIssueModelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsPatchCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issuemodel)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.patch" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1IssueModel or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1IssueModel.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1IssueModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1IssueModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an issue model.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.issueModels.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the issue model. Format: projects/{project}/locations/{location}/issueModels/{issue_model}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1IssueModel"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1IssueModel"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.undeploy":

type ProjectsLocationsIssueModelsUndeployCall struct {
	s                                                           *Service
	name                                                        string
	googlecloudcontactcenterinsightsv1undeployissuemodelrequest *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Undeploy: Undeploys an issue model. An issue model can not be used in
// analysis after it has been undeployed.
//
// - name: The issue model to undeploy.
func (r *ProjectsLocationsIssueModelsService) Undeploy(name string, googlecloudcontactcenterinsightsv1undeployissuemodelrequest *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) *ProjectsLocationsIssueModelsUndeployCall {
	c := &ProjectsLocationsIssueModelsUndeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1undeployissuemodelrequest = googlecloudcontactcenterinsightsv1undeployissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsUndeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsUndeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsUndeployCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsUndeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsUndeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsUndeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1undeployissuemodelrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undeploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.undeploy" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsUndeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Undeploys an issue model. An issue model can not be used in analysis after it has been undeployed.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}:undeploy",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.issueModels.undeploy",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The issue model to undeploy.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:undeploy",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.issues.get":

type ProjectsLocationsIssueModelsIssuesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an issue.
//
// - name: The name of the issue to get.
func (r *ProjectsLocationsIssueModelsIssuesService) Get(name string) *ProjectsLocationsIssueModelsIssuesGetCall {
	c := &ProjectsLocationsIssueModelsIssuesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Issue or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1Issue.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Issue, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Issue{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an issue.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}/issues/{issuesId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.issueModels.issues.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the issue to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+/issues/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Issue"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.issues.list":

type ProjectsLocationsIssueModelsIssuesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists issues.
//
// - parent: The parent resource of the issue.
func (r *ProjectsLocationsIssueModelsIssuesService) List(parent string) *ProjectsLocationsIssueModelsIssuesListCall {
	c := &ProjectsLocationsIssueModelsIssuesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsIssueModelsIssuesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsIssuesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.list" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1ListIssuesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListIssuesResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists issues.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}/issues",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.issueModels.issues.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the issue.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/issues",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListIssuesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.issueModels.issues.patch":

type ProjectsLocationsIssueModelsIssuesPatchCall struct {
	s                                       *Service
	name                                    string
	googlecloudcontactcenterinsightsv1issue *GoogleCloudContactcenterinsightsV1Issue
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates an issue.
//
//   - name: Immutable. The resource name of the issue. Format:
//     projects/{project}/locations/{location}/issueModels/{issue_model}/is
//     sues/{issue}.
func (r *ProjectsLocationsIssueModelsIssuesService) Patch(name string, googlecloudcontactcenterinsightsv1issue *GoogleCloudContactcenterinsightsV1Issue) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c := &ProjectsLocationsIssueModelsIssuesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1issue = googlecloudcontactcenterinsightsv1issue
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issue)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.patch" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1Issue or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1Issue.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Issue, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Issue{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an issue.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/issueModels/{issueModelsId}/issues/{issuesId}",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.issueModels.issues.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the issue. Format: projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/issueModels/[^/]+/issues/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Issue"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1Issue"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.operations.cancel":

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation.
// The server makes a best effort to cancel the operation, but success
// is not guaranteed. If the server doesn't support this method, it
// returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
// Operations.GetOperation or other methods to check whether the
// cancellation succeeded or whether the operation completed despite
// cancellation. On successful cancellation, the operation is not
// deleted; instead, it becomes an operation with an Operation.error
// value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.cancel" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.operations.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be cancelled.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:cancel",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "contactcenterinsights.projects.locations.phraseMatchers.create":

type ProjectsLocationsPhraseMatchersCreateCall struct {
	s                                               *Service
	parent                                          string
	googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Create: Creates a phrase matcher.
//
//   - parent: The parent resource of the phrase matcher. Required. The
//     location to create a phrase matcher for. Format:
//     `projects//locations/` or `projects//locations/`.
func (r *ProjectsLocationsPhraseMatchersService) Create(parent string, googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher) *ProjectsLocationsPhraseMatchersCreateCall {
	c := &ProjectsLocationsPhraseMatchersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1phrasematcher = googlecloudcontactcenterinsightsv1phrasematcher
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1phrasematcher)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/phraseMatchers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.create" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1PhraseMatcher or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a phrase matcher.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/phraseMatchers",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.phraseMatchers.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the phrase matcher. Required. The location to create a phrase matcher for. Format: `projects//locations/` or `projects//locations/`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/phraseMatchers",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1PhraseMatcher"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1PhraseMatcher"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.phraseMatchers.delete":

type ProjectsLocationsPhraseMatchersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a phrase matcher.
//
// - name: The name of the phrase matcher to delete.
func (r *ProjectsLocationsPhraseMatchersService) Delete(name string) *ProjectsLocationsPhraseMatchersDeleteCall {
	c := &ProjectsLocationsPhraseMatchersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a phrase matcher.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/phraseMatchers/{phraseMatchersId}",
	//   "httpMethod": "DELETE",
	//   "id": "contactcenterinsights.projects.locations.phraseMatchers.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the phrase matcher to delete.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/phraseMatchers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.phraseMatchers.get":

type ProjectsLocationsPhraseMatchersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a phrase matcher.
//
// - name: The name of the phrase matcher to get.
func (r *ProjectsLocationsPhraseMatchersService) Get(name string) *ProjectsLocationsPhraseMatchersGetCall {
	c := &ProjectsLocationsPhraseMatchersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPhraseMatchersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPhraseMatchersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPhraseMatchersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPhraseMatchersGetCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPhraseMatchersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1PhraseMatcher or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPhraseMatchersGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a phrase matcher.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/phraseMatchers/{phraseMatchersId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.phraseMatchers.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the phrase matcher to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/phraseMatchers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1PhraseMatcher"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.phraseMatchers.list":

type ProjectsLocationsPhraseMatchersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists phrase matchers.
//
// - parent: The parent resource of the phrase matcher.
func (r *ProjectsLocationsPhraseMatchersService) List(parent string) *ProjectsLocationsPhraseMatchersListCall {
	c := &ProjectsLocationsPhraseMatchersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce
// results to a specific subset. Useful for querying phrase matchers
// with specific properties.
func (c *ProjectsLocationsPhraseMatchersListCall) Filter(filter string) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of phrase matchers to return in the response. If this value is zero,
// the service will select a default size. A call might return fewer
// objects than requested. A non-empty `next_page_token` in the response
// indicates that more data is available.
func (c *ProjectsLocationsPhraseMatchersListCall) PageSize(pageSize int64) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListPhraseMatchersResponse`. This value indicates that
// this is a continuation of a prior `ListPhraseMatchers` call and that
// the system should return the next page of data.
func (c *ProjectsLocationsPhraseMatchersListCall) PageToken(pageToken string) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPhraseMatchersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPhraseMatchersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPhraseMatchersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPhraseMatchersListCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPhraseMatchersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/phraseMatchers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.list" call.
// Exactly one of
// *GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPhraseMatchersListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists phrase matchers.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/phraseMatchers",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.phraseMatchers.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to reduce results to a specific subset. Useful for querying phrase matchers with specific properties.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of phrase matchers to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListPhraseMatchersResponse`. This value indicates that this is a continuation of a prior `ListPhraseMatchers` call and that the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource of the phrase matcher.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/phraseMatchers",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPhraseMatchersListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "contactcenterinsights.projects.locations.phraseMatchers.patch":

type ProjectsLocationsPhraseMatchersPatchCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Updates a phrase matcher.
//
//   - name: The resource name of the phrase matcher. Format:
//     projects/{project}/locations/{location}/phraseMatchers/{phrase_match
//     er}.
func (r *ProjectsLocationsPhraseMatchersService) Patch(name string, googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher) *ProjectsLocationsPhraseMatchersPatchCall {
	c := &ProjectsLocationsPhraseMatchersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1phrasematcher = googlecloudcontactcenterinsightsv1phrasematcher
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsPhraseMatchersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPhraseMatchersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1phrasematcher)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.patch" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1PhraseMatcher or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a phrase matcher.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/phraseMatchers/{phraseMatchersId}",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.phraseMatchers.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/phraseMatchers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1PhraseMatcher"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1PhraseMatcher"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.views.create":

type ProjectsLocationsViewsCreateCall struct {
	s                                      *Service
	parent                                 string
	googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a view.
//
//   - parent: The parent resource of the view. Required. The location to
//     create a view for. Format: `projects//locations/` or
//     `projects//locations/`.
func (r *ProjectsLocationsViewsService) Create(parent string, googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View) *ProjectsLocationsViewsCreateCall {
	c := &ProjectsLocationsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1view = googlecloudcontactcenterinsightsv1view
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsViewsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsViewsCreateCall) Context(ctx context.Context) *ProjectsLocationsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1view)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.create" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1View or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a view.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/views",
	//   "httpMethod": "POST",
	//   "id": "contactcenterinsights.projects.locations.views.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource of the view. Required. The location to create a view for. Format: `projects//locations/` or `projects//locations/`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/views",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1View"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1View"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.views.delete":

type ProjectsLocationsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view.
//
// - name: The name of the view to delete.
func (r *ProjectsLocationsViewsService) Delete(name string) *ProjectsLocationsViewsDeleteCall {
	c := &ProjectsLocationsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsViewsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsViewsDeleteCall) Context(ctx context.Context) *ProjectsLocationsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a view.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/views/{viewsId}",
	//   "httpMethod": "DELETE",
	//   "id": "contactcenterinsights.projects.locations.views.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the view to delete.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/views/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.views.get":

type ProjectsLocationsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view.
//
// - name: The name of the view to get.
func (r *ProjectsLocationsViewsService) Get(name string) *ProjectsLocationsViewsGetCall {
	c := &ProjectsLocationsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsViewsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsViewsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsViewsGetCall) Context(ctx context.Context) *ProjectsLocationsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.get" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1View or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a view.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/views/{viewsId}",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.views.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the view to get.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/views/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1View"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "contactcenterinsights.projects.locations.views.list":

type ProjectsLocationsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views.
//
// - parent: The parent resource of the views.
func (r *ProjectsLocationsViewsService) List(parent string) *ProjectsLocationsViewsListCall {
	c := &ProjectsLocationsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of views to return in the response. If this value is zero, the
// service will select a default size. A call may return fewer objects
// than requested. A non-empty `next_page_token` in the response
// indicates that more data is available.
func (c *ProjectsLocationsViewsListCall) PageSize(pageSize int64) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned
// by the last `ListViewsResponse`; indicates that this is a
// continuation of a prior `ListViews` call and the system should return
// the next page of data.
func (c *ProjectsLocationsViewsListCall) PageToken(pageToken string) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsViewsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsViewsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsViewsListCall) Context(ctx context.Context) *ProjectsLocationsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.list" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1ListViewsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListViewsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsViewsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists views.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/views",
	//   "httpMethod": "GET",
	//   "id": "contactcenterinsights.projects.locations.views.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of views to return in the response. If this value is zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The value returned by the last `ListViewsResponse`; indicates that this is a continuation of a prior `ListViews` call and the system should return the next page of data.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource of the views.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/views",
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1ListViewsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsViewsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "contactcenterinsights.projects.locations.views.patch":

type ProjectsLocationsViewsPatchCall struct {
	s                                      *Service
	name                                   string
	googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates a view.
//
//   - name: Immutable. The resource name of the view. Format:
//     projects/{project}/locations/{location}/views/{view}.
func (r *ProjectsLocationsViewsService) Patch(name string, googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View) *ProjectsLocationsViewsPatchCall {
	c := &ProjectsLocationsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1view = googlecloudcontactcenterinsightsv1view
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsViewsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsViewsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsViewsPatchCall) Context(ctx context.Context) *ProjectsLocationsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1view)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.patch" call.
// Exactly one of *GoogleCloudContactcenterinsightsV1View or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a view.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/views/{viewsId}",
	//   "httpMethod": "PATCH",
	//   "id": "contactcenterinsights.projects.locations.views.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of the view. Format: projects/{project}/locations/{location}/views/{view}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/views/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1View"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudContactcenterinsightsV1View"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
