// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package playdeveloperreporting provides access to the Google Play Developer Reporting API.
//
// For product documentation, see: https://developers.google.com/play/developer/reporting
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/playdeveloperreporting/v1alpha1"
//	...
//	ctx := context.Background()
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package playdeveloperreporting // import "google.golang.org/api/playdeveloperreporting/v1alpha1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "playdeveloperreporting:v1alpha1"
const apiName = "playdeveloperreporting"
const apiVersion = "v1alpha1"
const basePath = "https://playdeveloperreporting.googleapis.com/"
const mtlsBasePath = "https://playdeveloperreporting.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Anomalies = NewAnomaliesService(s)
	s.Vitals = NewVitalsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Anomalies *AnomaliesService

	Vitals *VitalsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAnomaliesService(s *Service) *AnomaliesService {
	rs := &AnomaliesService{s: s}
	return rs
}

type AnomaliesService struct {
	s *Service
}

func NewVitalsService(s *Service) *VitalsService {
	rs := &VitalsService{s: s}
	rs.Anrrate = NewVitalsAnrrateService(s)
	rs.Crashrate = NewVitalsCrashrateService(s)
	rs.Errors = NewVitalsErrorsService(s)
	rs.Excessivewakeuprate = NewVitalsExcessivewakeuprateService(s)
	rs.Stuckbackgroundwakelockrate = NewVitalsStuckbackgroundwakelockrateService(s)
	return rs
}

type VitalsService struct {
	s *Service

	Anrrate *VitalsAnrrateService

	Crashrate *VitalsCrashrateService

	Errors *VitalsErrorsService

	Excessivewakeuprate *VitalsExcessivewakeuprateService

	Stuckbackgroundwakelockrate *VitalsStuckbackgroundwakelockrateService
}

func NewVitalsAnrrateService(s *Service) *VitalsAnrrateService {
	rs := &VitalsAnrrateService{s: s}
	return rs
}

type VitalsAnrrateService struct {
	s *Service
}

func NewVitalsCrashrateService(s *Service) *VitalsCrashrateService {
	rs := &VitalsCrashrateService{s: s}
	return rs
}

type VitalsCrashrateService struct {
	s *Service
}

func NewVitalsErrorsService(s *Service) *VitalsErrorsService {
	rs := &VitalsErrorsService{s: s}
	rs.Counts = NewVitalsErrorsCountsService(s)
	rs.Issues = NewVitalsErrorsIssuesService(s)
	rs.Reports = NewVitalsErrorsReportsService(s)
	return rs
}

type VitalsErrorsService struct {
	s *Service

	Counts *VitalsErrorsCountsService

	Issues *VitalsErrorsIssuesService

	Reports *VitalsErrorsReportsService
}

func NewVitalsErrorsCountsService(s *Service) *VitalsErrorsCountsService {
	rs := &VitalsErrorsCountsService{s: s}
	return rs
}

type VitalsErrorsCountsService struct {
	s *Service
}

func NewVitalsErrorsIssuesService(s *Service) *VitalsErrorsIssuesService {
	rs := &VitalsErrorsIssuesService{s: s}
	return rs
}

type VitalsErrorsIssuesService struct {
	s *Service
}

func NewVitalsErrorsReportsService(s *Service) *VitalsErrorsReportsService {
	rs := &VitalsErrorsReportsService{s: s}
	return rs
}

type VitalsErrorsReportsService struct {
	s *Service
}

func NewVitalsExcessivewakeuprateService(s *Service) *VitalsExcessivewakeuprateService {
	rs := &VitalsExcessivewakeuprateService{s: s}
	return rs
}

type VitalsExcessivewakeuprateService struct {
	s *Service
}

func NewVitalsStuckbackgroundwakelockrateService(s *Service) *VitalsStuckbackgroundwakelockrateService {
	rs := &VitalsStuckbackgroundwakelockrateService{s: s}
	return rs
}

type VitalsStuckbackgroundwakelockrateService struct {
	s *Service
}

// GooglePlayDeveloperReportingV1alpha1Anomaly: Represents an anomaly
// detected in a dataset. Our anomaly detection systems flag datapoints
// in a time series that fall outside of and expected range derived from
// historical data. Although those expected ranges have an upper and a
// lower bound, we only flag anomalies when the data has become
// unexpectedly _worse_, which usually corresponds to the case where the
// metric crosses the upper bound. Multiple contiguous datapoints in a
// timeline outside of the expected range will be grouped into a single
// anomaly. Therefore, an anomaly represents effectively a segment of a
// metric's timeline. The information stored in the `timeline_spec`,
// `dimensions` and `metric` can be used to fetch a full timeline with
// extended ragne for context. **Required permissions**: to access this
// resource, the calling user needs the _View app information
// (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1alpha1Anomaly struct {
	// Dimensions: Combination of dimensions in which the anomaly was
	// detected.
	Dimensions []*GooglePlayDeveloperReportingV1alpha1DimensionValue `json:"dimensions,omitempty"`

	// Metric: Metric where the anomaly was detected, together with the
	// anomalous value.
	Metric *GooglePlayDeveloperReportingV1alpha1MetricValue `json:"metric,omitempty"`

	// MetricSet: Metric set resource where the anomaly was detected.
	MetricSet string `json:"metricSet,omitempty"`

	// Name: Name of the anomaly. Format: apps/{app}/anomalies/{anomaly}
	Name string `json:"name,omitempty"`

	// TimelineSpec: Timeline specification that covers the anomaly period.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1Anomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1Anomaly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet: Singleton
// resource representing the set of ANR (Application not responding)
// metrics. This metric set contains ANRs data combined with usage data
// to produce a normalized metric independent of user counts.
// **Supported aggregation periods:** * DAILY: metrics are aggregated in
// calendar date intervals. Due to historical constraints, the only
// supported timezone is `America/Los_Angeles`. **Supported metrics:** *
// `anrRate` (`google.type.Decimal`): Percentage of distinct users in
// the aggregation period that experienced at least one ANR. *
// `anrRate7dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `anrRate` in the last 7 days. The daily values are weighted
// by the count of distinct users for the day. *
// `anrRate28dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `anrRate` in the last 28 days. The daily values are weighted
// by the count of distinct users for the day. * `userPerceivedAnrRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that experienced at least one user-perceived ANR.
// User-perceived ANRs are currently those of 'Input dispatching' type.
// * `userPerceivedAnrRate7dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedAnrRate` in the last 7 days.
// The daily values are weighted by the count of distinct users for the
// day. * `userPerceivedAnrRate28dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedAnrRate` in the last 28 days.
// The daily values are weighted by the count of distinct users for the
// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
// users in the aggregation period that were used as normalization value
// for the `anrRate` and `userPerceivedAnrRate` metrics. A user is
// counted in this metric if they used the app in the foreground during
// the aggregation period. Care must be taken not to aggregate this
// count further, as it may result in users being counted multiple
// times. **Supported dimensions:** * `apiLevel` (string): the API level
// of Android that was running on the user's device. * `versionCode`
// (int64): version of the app that was running on the user's device. *
// `deviceModel` (string): unique identifier of the user's device model.
// * `deviceType` (string): the type (also known as form factor) of the
// user's device. * `countryCode` (string): the country or region of the
// user's device based on their IP address, represented as a 2-letter
// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
// `deviceSocMake` (string): Make of the device's primary
// system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app. **Related
// metric sets:** * vitals.errors contains unnormalized version
// (absolute counts) of crashes. * vitals.errors contains normalized
// metrics about crashes, another stability metric.
type GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1alpha1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format: apps/{app}/anrRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet: Singleton
// resource representing the set of crashrate metrics. This metric set
// contains crashes data combined with usage data to produce a
// normalized metric independent of user counts. **Supported aggregation
// periods:** * DAILY: metrics are aggregated in calendar date
// intervals. Due to historical constraints, the only supported timezone
// is `America/Los_Angeles`. **Supported metrics:** * `crashRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that experienced at least one crash. *
// `crashRate7dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `crashRate` in the last 7 days. The daily values are
// weighted by the count of distinct users for the day. *
// `crashRate28dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `crashRate` in the last 28 days. The daily values are
// weighted by the count of distinct users for the day. *
// `userPerceivedCrashRate` (`google.type.Decimal`): Percentage of
// distinct users in the aggregation period that experienced at least
// one crash while they were actively using your app (a user-perceived
// crash). An app is considered to be in active use if it is displaying
// any activity or executing any foreground service. *
// `userPerceivedCrashRate7dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedCrashRate` in the last 7 days.
// The daily values are weighted by the count of distinct users for the
// day. * `userPerceivedCrashRate28dUserWeighted`
// (`google.type.Decimal`): Rolling average value of
// `userPerceivedCrashRate` in the last 28 days. The daily values are
// weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `crashRate` and `userPerceivedCrashRate` metrics. A user is counted
// in this metric if they used the app actively during the aggregation
// period. An app is considered to be in active use if it is displaying
// any activity or executing any foreground service. Care must be taken
// not to aggregate this count further, as it may result in users being
// counted multiple times. **Supported dimensions:** * `apiLevel`
// (string): the API level of Android that was running on the user's
// device. * `versionCode` (int64): version of the app that was running
// on the user's device. * `deviceModel` (string): unique identifier of
// the user's device model. * `deviceType` (string): the type (also
// known as form factor) of the user's device. * `countryCode` (string):
// the country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app. **Related
// metric sets:** * vitals.errors contains unnormalized version
// (absolute counts) of crashes. * vitals.errors contains normalized
// metrics about ANRs, another stability metric.
type GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1alpha1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format: apps/{app}/crashRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1DimensionValue: Represents the
// value of a single dimension.
type GooglePlayDeveloperReportingV1alpha1DimensionValue struct {
	// Dimension: Name of the dimension.
	Dimension string `json:"dimension,omitempty"`

	// Int64Value: Actual value, represented as an int64.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// StringValue: Actual value, represented as a string.
	StringValue string `json:"stringValue,omitempty"`

	// ValueLabel: Optional. Human-friendly label for the value, always in
	// English. For example, 'Spain' for the 'ES' country code. Whereas the
	// dimension value is stable, this value label is subject to change. Do
	// not assume that the (value, value_label) relationship is stable. For
	// example, the ISO country code 'MK' changed its name recently to
	// 'North Macedonia'.
	ValueLabel string `json:"valueLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1DimensionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1DimensionValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet: Singleton
// resource representing the set of error report metrics. This metric
// set contains un-normalized error report counts. **Supported
// aggregation periods:** * DAILY: metrics are aggregated in calendar
// date intervals. The default and only supported timezone is
// `America/Los_Angeles`. **Supported metrics:** * `errorReportCount`
// (`google.type.Decimal`): Absolute count of individual error reports
// that have been received for an app. * `distinctUsers`
// (`google.type.Decimal`): Count of distinct users for which reports
// have been received. Care must be taken not to aggregate this count
// further, as it may result in users being counted multiple times.
// **Required dimension:** This dimension must be always specified in
// all requests in the `dimensions` field in query requests. *
// `reportType` (string): the type of error. The value should correspond
// to one of the possible values in ErrorType. **Supported dimensions:**
// * `apiLevel` (string): the API level of Android that was running on
// the user's device. * `versionCode` (int64): version of the app that
// was running on the user's device. * `deviceModel` (string): unique
// identifier of the user's device model. * `deviceType` (string):
// identifier of the device's form factor, e.g., PHONE. * `issueId`
// (string): the id an error was assigned to. The value should
// correspond to the `{issue}` component of the issue name. *
// `deviceRamBucket` (int64): RAM of the device, in MB, in buckets (3GB,
// 4GB, etc.). * `deviceSocMake` (string): Make of the device's primary
// system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app. **Related
// metric sets:** * vitals.errors.counts contains normalized metrics
// about Crashes, another stability metric. * vitals.errors.counts
// contains normalized metrics about ANRs, another stability metric.
type GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1alpha1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format: apps/{app}/errorCountMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1ErrorIssue: A group of related
// ErrorReports received for an app. Similar error reports are grouped
// together into issues with a likely identical root cause. **Please
// note:** this resource is currently in Alpha. There could be changes
// to the issue grouping that would result in similar but more recent
// error reports being assigned to different issues. This could also
// cause some issues disappearing entirely and being replaced by new
// ones. **Required permissions**: to access this resource, the calling
// user needs the _View app information (read-only)_ permission for the
// app.
type GooglePlayDeveloperReportingV1alpha1ErrorIssue struct {
	// Cause: Cause of the issue. Depending on the type this can be either:
	// * APPLICATION_NOT_RESPONDING: the type of ANR that occurred, e.g.,
	// 'Input dispatching timed out'. * CRASH: for Java unhandled exception
	// errors, the type of the innermost exception that was thrown, e.g.,
	// IllegalArgumentException. For signals in native code, the signal that
	// was raised, e.g. SIGSEGV.
	Cause string `json:"cause,omitempty"`

	// Location: Location where the issue happened. Depending on the type
	// this can be either: * APPLICATION_NOT_RESPONDING: the name of the
	// activity or service that stopped responding. * CRASH: the likely
	// method name that caused the error.
	Location string `json:"location,omitempty"`

	// Name: The resource name of the issue. Format:
	// apps/{app}/errorIssues/{issue}
	Name string `json:"name,omitempty"`

	// Type: Type of the errors grouped in this issue.
	//
	// Possible values:
	//   "ERROR_TYPE_UNSPECIFIED" - Unspecified error type.
	//   "APPLICATION_NOT_RESPONDING" - Application Not Responding (ANR)
	// error. To learn more about this type of errors visit the
	// corresponding Android Developers documentation.
	//   "CRASH" - Crash caused by an unhandled exception in Java (or Kotlin
	// or any other JVM language) or a signal in native code such as
	// SIGSEGV.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cause") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cause") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1ErrorIssue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1ErrorIssue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1ErrorReport: An error report
// received for an app. There reports are produced by the Android
// platform code when a (potentially fatal) error condition is detected.
// Identical reports from many users will be deduplicated and coalesced
// into a single ErrorReport. **Required permissions**: to access this
// resource, the calling user needs the _View app information
// (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1alpha1ErrorReport struct {
	// Issue: The issue this report was associated with. **Please note:**
	// this resource is currently in Alpha. There could be changes to the
	// issue grouping that would result in similar but more recent error
	// reports being assigned to a different issue.
	Issue string `json:"issue,omitempty"`

	// Name: The resource name of the report. Format:
	// apps/{app}/errorReports/{report}
	Name string `json:"name,omitempty"`

	// ReportText: Textual representation of the error report. These textual
	// reports are produced by the platform. The reports are then sanitized
	// and filtered to remove any potentially sensitive information.
	// Although their format is fairly stable, they are not entirely meant
	// for machine consumption and we cannot guarantee that there won't be
	// subtle changes to the formatting that may break systems trying to
	// parse information out of the reports.
	ReportText string `json:"reportText,omitempty"`

	// Type: Type of the error for which this report was generated.
	//
	// Possible values:
	//   "ERROR_TYPE_UNSPECIFIED" - Unspecified error type.
	//   "APPLICATION_NOT_RESPONDING" - Application Not Responding (ANR)
	// error. To learn more about this type of errors visit the
	// corresponding Android Developers documentation.
	//   "CRASH" - Crash caused by an unhandled exception in Java (or Kotlin
	// or any other JVM language) or a signal in native code such as
	// SIGSEGV.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Issue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1ErrorReport) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1ErrorReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet:
// Singleton resource representing the set of Excessive Weakeups
// metrics. This metric set contains AlarmManager wakeup counts data
// combined with process state data to produce a normalized metric
// independent of user counts. **Supported aggregation periods:** *
// DAILY: metrics are aggregated in calendar date intervals. Due to
// historical constraints, the only supported timezone is
// `America/Los_Angeles`. **Supported metrics:** * `excessiveWakeupRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that had more than 10 wakeups per hour. *
// `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `excessiveWakeupRate` in the last 7 days. The daily
// values are weighted by the count of distinct users for the day. *
// `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `excessiveWakeupRate` in the last 28 days. The daily
// values are weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `excessiveWakeupRate` metric. A user is counted in this metric if
// they app was doing any work on the device, i.e., not just active
// foreground usage but also background work. Care must be taken not to
// aggregate this count further, as it may result in users being counted
// multiple times. **Supported dimensions:** * `apiLevel` (string): the
// API level of Android that was running on the user's device. *
// `versionCode` (int64): version of the app that was running on the
// user's device. * `deviceModel` (string): unique identifier of the
// user's device model. * `deviceType` (string): the type (also known as
// form factor) of the user's device. * `countryCode` (string): the
// country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1alpha1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format:
	// apps/{app}/excessiveWakeupRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1FreshnessInfo: Represents the
// latest available time that can be requested in a TimelineSpec.
// Different aggregation periods have different freshness. For example,
// `DAILY` aggregation may lag behind `HOURLY` in cases where such
// aggregation is computed only once at the end of the day.
type GooglePlayDeveloperReportingV1alpha1FreshnessInfo struct {
	// Freshnesses: Information about data freshness for every supported
	// aggregation period. This field has set semantics, keyed by the
	// `aggregation_period` field.
	Freshnesses []*GooglePlayDeveloperReportingV1alpha1FreshnessInfoFreshness `json:"freshnesses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Freshnesses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Freshnesses") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1FreshnessInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1FreshnessInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1FreshnessInfoFreshness:
// Information about data freshness for a single aggregation period.
type GooglePlayDeveloperReportingV1alpha1FreshnessInfoFreshness struct {
	// AggregationPeriod: Aggregation period for which data is available.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// LatestEndTime: Latest end time for which data is available, for the
	// aggregation period. The time is specified in the metric set's default
	// timezone. *Note:* time ranges in TimelineSpec are represented as
	// `start_time, end_time)`. For example, if the latest available
	// timeline data point for a `DAILY` aggregation period is `2021-06-23
	// 00:00:00 America/Los_Angeles`, the value of this field would be
	// `2021-06-24 00:00:00 America/Los_Angeles` so it can be easily reused
	// in [TimelineSpec.end_time.
	LatestEndTime *GoogleTypeDateTime `json:"latestEndTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1FreshnessInfoFreshness) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1FreshnessInfoFreshness
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse: Response
// with a list of anomalies in datasets.
type GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse struct {
	// Anomalies: Anomalies that were found.
	Anomalies []*GooglePlayDeveloperReportingV1alpha1Anomaly `json:"anomalies,omitempty"`

	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Anomalies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Anomalies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1MetricValue: Represents the value
// of a metric.
type GooglePlayDeveloperReportingV1alpha1MetricValue struct {
	// DecimalValue: Actual value, represented as a decimal number.
	DecimalValue *GoogleTypeDecimal `json:"decimalValue,omitempty"`

	// Metric: Name of the metric.
	Metric string `json:"metric,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DecimalValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DecimalValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1MetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1MetricValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1MetricsRow: Represents a row of
// dimensions and metrics.
type GooglePlayDeveloperReportingV1alpha1MetricsRow struct {
	// AggregationPeriod: Granularity of the aggregation period of the row.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// Dimensions: Dimension columns in the row.
	Dimensions []*GooglePlayDeveloperReportingV1alpha1DimensionValue `json:"dimensions,omitempty"`

	// Metrics: Metric columns in the row.
	Metrics []*GooglePlayDeveloperReportingV1alpha1MetricValue `json:"metrics,omitempty"`

	// StartTime: Starting date (and time for hourly aggregation) of the
	// period covered by this row.
	StartTime *GoogleTypeDateTime `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1MetricsRow) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1MetricsRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest:
// Request message for QueryAnrRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the metrics by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** * `anrRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one ANR. *
	// `anrRate7dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `anrRate` in the last 7 days. The daily values are weighted
	// by the count of distinct users for the day. *
	// `anrRate28dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `anrRate` in the last 28 days. The daily values are weighted
	// by the count of distinct users for the day. * `userPerceivedAnrRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one user-perceived ANR.
	// User-perceived ANRs are currently those of 'Input dispatching' type.
	// * `userPerceivedAnrRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedAnrRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `userPerceivedAnrRate28dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedAnrRate` in the last 28 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
	// users in the aggregation period that were used as normalization value
	// for the `anrRate` and `userPerceivedAnrRate` metrics. A user is
	// counted in this metric if they used the app in the foreground during
	// the aggregation period. Care must be taken not to aggregate this
	// count further, as it may result in users being counted multiple
	// times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100,000; values
	// above 100,000 will be coerced to 100,000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the default
	// and only supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse:
// Response message for QueryAnrRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1alpha1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest:
// Request message for QueryCrashRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the metrics by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** * `crashRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one crash. *
	// `crashRate7dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `crashRate` in the last 7 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `crashRate28dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `crashRate` in the last 28 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `userPerceivedCrashRate` (`google.type.Decimal`): Percentage of
	// distinct users in the aggregation period that experienced at least
	// one crash while they were actively using your app (a user-perceived
	// crash). An app is considered to be in active use if it is displaying
	// any activity or executing any foreground service. *
	// `userPerceivedCrashRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedCrashRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `userPerceivedCrashRate28dUserWeighted`
	// (`google.type.Decimal`): Rolling average value of
	// `userPerceivedCrashRate` in the last 28 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
	// the aggregation period that were used as normalization value for the
	// `crashRate` and `userPerceivedCrashRate` metrics. A user is counted
	// in this metric if they used the app actively during the aggregation
	// period. An app is considered to be in active use if it is displaying
	// any activity or executing any foreground service. Care must be taken
	// not to aggregate this count further, as it may result in users being
	// counted multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100,000; values
	// above 100,000 will be coerced to 100,000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the default
	// and only supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse:
// Response message for QueryCrashRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1alpha1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest:
// Request message for QueryErrorCountMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest struct {
	// Dimensions: Dimensions to slice the data by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): identifier of the device's form factor, e.g.,
	// PHONE. * `reportType` (string): the type of error. The value should
	// correspond to one of the possible values in ErrorType. * `issueId`
	// (string): the id an error was assigned to. The value should
	// correspond to the `{issue}` component of the issue name. *
	// `deviceRamBucket` (int64): RAM of the device, in MB, in buckets (3GB,
	// 4GB, etc.). * `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** *
	// `errorReportCount` (`google.type.Decimal`): Absolute count of
	// individual error reports that have been received for an app. *
	// `distinctUsers` (`google.type.Decimal`): Count of distinct users for
	// which reports have been received. Care must be taken not to aggregate
	// this count further, as it may result in users being counted multiple
	// times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100000; values above
	// 100000 will be coerced to 100000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. The default and only supported timezone is
	// `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse:
// Error counts query response.
type GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows.
	Rows []*GooglePlayDeveloperReportingV1alpha1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetR
// equest: Request message for QueryExcessiveWakeupRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the data by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** *
	// `excessiveWakeupRate` (`google.type.Decimal`): Percentage of distinct
	// users in the aggregation period that had more than 10 wakeups per
	// hour. * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `excessiveWakeupRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `excessiveWakeupRate` in the last 28 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
	// users in the aggregation period that were used as normalization value
	// for the `excessiveWakeupRate` metric. A user is counted in this
	// metric if they app was doing any work on the device, i.e., not just
	// active foreground usage but also background work. Care must be taken
	// not to aggregate this count further, as it may result in users being
	// counted multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100000; values above
	// 100000 will be coerced to 100000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the only
	// supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetR
// esponse: Response message for QueryExcessiveWakeupRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1alpha1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMe
// tricSetRequest: Request message for
// QueryStuckBackgroundWakelockRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the data by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** *
	// `stuckBgWakelockRate` (`google.type.Decimal`): Percentage of distinct
	// users in the aggregation period that had a wakelock held in the
	// background for longer than 1 hour. *
	// `stuckBgWakelockRate7dUserWeighted` (`google.type.Decimal`): Rolling
	// average value of `stuckBgWakelockRate` in the last 7 days. The daily
	// values are weighted by the count of distinct users for the day. *
	// `stuckBgWakelockRate28dUserWeighted` (`google.type.Decimal`): Rolling
	// average value of `stuckBgWakelockRate` in the last 28 days. The daily
	// values are weighted by the count of distinct users for the day. *
	// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
	// the aggregation period that were used as normalization value for the
	// `stuckBgWakelockRate` metric. A user is counted in this metric if
	// they app was doing any work on the device, i.e., not just active
	// foreground usage but also background work. Care must be taken not to
	// aggregate this count further, as it may result in users being counted
	// multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100000; values above
	// 100000 will be coerced to 100000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the only
	// supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1alpha1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMe
// tricSetResponse: Response message for
// QueryStuckBackgroundWakelockRateMetricSet.
type GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1alpha1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse:
// Response with a paginated list of issues that matched the request.
type GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse struct {
	// ErrorIssues: ErrorIssues that were found.
	ErrorIssues []*GooglePlayDeveloperReportingV1alpha1ErrorIssue `json:"errorIssues,omitempty"`

	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ErrorIssues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorIssues") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse:
// Response with a paginated list of error reports matching the search
// query.
type GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse struct {
	// ErrorReports: Error reports that were found.
	ErrorReports []*GooglePlayDeveloperReportingV1alpha1ErrorReport `json:"errorReports,omitempty"`

	// NextPageToken: Page token to fetch the next page of reports.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ErrorReports") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorReports") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricS
// et: Singleton resource representing the set of Stuck Background
// Wakelocks metrics. This metric set contains PowerManager wakelock
// duration data combined with process state data to produce a
// normalized metric independent of user counts. **Supported aggregation
// periods:** * DAILY: metrics are aggregated in calendar date
// intervals. Due to historical constraints, the only supported timezone
// is `America/Los_Angeles`. **Supported metrics:** *
// `stuckBgWakelockRate` (`google.type.Decimal`): Percentage of distinct
// users in the aggregation period that had a wakelock held in the
// background for longer than 1 hour. *
// `stuckBgWakelockRate7dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `stuckBgWakelockRate` in the last 7 days. The daily
// values are weighted by the count of distinct users for the day. *
// `stuckBgWakelockRate28dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `stuckBgWakelockRate` in the last 28 days. The daily
// values are weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `stuckBgWakelockRate` metric. A user is counted in this metric if
// their app was doing any work on the device, i.e., not just active
// foreground usage but also background work. Care must be taken not to
// aggregate this count further, as it may result in users being counted
// multiple times. **Supported dimensions:** * `apiLevel` (string): the
// API level of Android that was running on the user's device. *
// `versionCode` (int64): version of the app that was running on the
// user's device. * `deviceModel` (string): unique identifier of the
// user's device model. * `deviceType` (string): the type (also known as
// form factor) of the user's device. * `countryCode` (string): the
// country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1alpha1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format:
	// apps/{app}/stuckBackgroundWakelockRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1alpha1TimelineSpec: Specification of
// the time-related aggregation parameters of a timeline. Timelines have
// an aggregation period (`DAILY`, `HOURLY`, etc) which defines how
// events are aggregated in metrics. The points in a timeline are
// defined by the starting DateTime of the aggregation period. The
// duration is implicit in the AggregationPeriod. Hourly aggregation
// periods, when supported by a metric set, are always specified in UTC
// to avoid ambiguities around daylight saving time transitions, where
// an hour is skipped when adopting DST, and repeated when abandoning
// DST. For example, the timestamp '2021-11-07 01:00:00
// America/Los_Angeles' is ambiguous since it can correspond to
// '2021-11-07 08:00:00 UTC' or '2021-11-07 09:00:00 UTC'. Daily
// aggregation periods require specifying a timezone which will
// determine the precise instants of the start and the end of the day.
// Not all metric sets support all timezones, so make sure to check
// which timezones are supported by the metric set you want to query.
type GooglePlayDeveloperReportingV1alpha1TimelineSpec struct {
	// AggregationPeriod: Type of the aggregation period of the datapoints
	// in the timeline. Intervals are identified by the date and time at the
	// start of the interval.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// EndTime: Ending datapoint of the timeline (exclusive). See start_time
	// for restrictions. The timezone of the end point must match the
	// timezone of the start point.
	EndTime *GoogleTypeDateTime `json:"endTime,omitempty"`

	// StartTime: Starting datapoint of the timeline (inclusive). Must be
	// aligned to the aggregation period as follows: * HOURLY: the
	// 'minutes', 'seconds' and 'nanos' fields must be unset. The time_zone
	// can be left unset (defaults to UTC) or set explicitly to "UTC".
	// Setting any other utc_offset or timezone id will result in a
	// validation error. * DAILY: the 'hours', 'minutes', 'seconds' and
	// 'nanos' fields must be unset. Different metric sets support different
	// timezones. It can be left unset to use the default timezone specified
	// by the metric set. The timezone of the end point must match the
	// timezone of the start point.
	StartTime *GoogleTypeDateTime `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1alpha1TimelineSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1alpha1TimelineSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical
// time). This type can represent a civil time in one of a few possible
// ways: * When utc_offset is set and time_zone is unset: a civil time
// on a calendar day with a particular offset from UTC. * When time_zone
// is set and utc_offset is unset: a civil time on a calendar day in a
// particular time zone. * When neither time_zone nor utc_offset is set:
// a civil time on a calendar day in local time. The date is relative to
// the Proleptic Gregorian Calendar. If year, month, or day are 0, the
// DateTime is considered not to have a specific year, month, or day
// respectively. This type may also be used to represent a physical time
// if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for
// physical time instead. If your use case also would like to store the
// user's timezone, that can be done in another field. This type is more
// flexible than some applications may want. Make sure to document and
// validate your application's limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the
	// year and month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`

	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to
	// 23, defaults to 0 (midnight). An API may choose to allow the value
	// "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`

	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59,
	// defaults to 0.
	Minutes int64 `json:"minutes,omitempty"`

	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if
	// specifying a datetime without a month.
	Month int64 `json:"month,omitempty"`

	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0
	// to 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Optional. Seconds of minutes of the time. Must normally be
	// from 0 to 59, defaults to 0. An API may allow the value 60 if it
	// allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`

	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`

	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and
	// +18 hours. For example, a UTC offset of -4:00 would be represented as
	// { seconds: -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`

	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if
	// specifying a datetime without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDecimal: A representation of a decimal value, such as 2.5.
// Clients may convert values into language-native decimal formats, such
// as Java's BigDecimal or Python's decimal.Decimal. [BigDecimal]:
// https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html
// [decimal.Decimal]: https://docs.python.org/3/library/decimal.html
type GoogleTypeDecimal struct {
	// Value: The decimal value, as a string. The string representation
	// consists of an optional sign, `+` (`U+002B`) or `-` (`U+002D`),
	// followed by a sequence of zero or more decimal digits ("the
	// integer"), optionally followed by a fraction, optionally followed by
	// an exponent. An empty string **should** be interpreted as `0`. The
	// fraction consists of a decimal point followed by zero or more decimal
	// digits. The string must contain at least one digit in either the
	// integer or the fraction. The number formed by the sign, the integer
	// and the fraction is referred to as the significand. The exponent
	// consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed
	// by one or more decimal digits. Services **should** normalize decimal
	// values before storing them by: - Removing an explicitly-provided `+`
	// sign (`+2.5` -> `2.5`). - Replacing a zero-length integer value with
	// `0` (`.5` -> `0.5`). - Coercing the exponent character to upper-case,
	// with explicit sign (`2.5e8` -> `2.5E+8`). - Removing an
	// explicitly-provided zero exponent (`2.5E0` -> `2.5`). Services
	// **may** perform additional normalization based on its own needs and
	// the internal decimal implementation selected, such as shifting the
	// decimal point and exponent value together (example: `2.5E-1` <->
	// `0.25`). Additionally, services **may** preserve trailing zeroes in
	// the fraction to indicate increased precision, but are not required to
	// do so. Note that only the `.` character is supported to divide the
	// integer and the fraction; `,` **should not** be supported regardless
	// of locale. Additionally, thousand separators **should not** be
	// supported. If a service does support them, values **must** be
	// normalized. The ENBF grammar is: DecimalString = '' | [Sign]
	// Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' |
	// [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = {
	// '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services
	// **should** clearly document the range of supported values, the
	// maximum supported precision (total number of digits), and, if
	// applicable, the scale (number of digits after the decimal point), as
	// well as how it behaves when receiving out-of-bounds values. Services
	// **may** choose to accept values passed as input even when the value
	// has a higher precision or scale than the service supports, and
	// **should** round the value to fit the supported scale. Alternatively,
	// the service **may** error with `400 Bad Request` (`INVALID_ARGUMENT`
	// in gRPC) if precision would be lost. Services **should** error with
	// `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service
	// receives a value outside of the supported range.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDecimal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDecimal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone
// Database (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`

	// Version: Optional. IANA Time Zone Database version number, e.g.
	// "2019a".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "playdeveloperreporting.anomalies.list":

type AnomaliesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists anomalies in any of the datasets.
//
//   - parent: Parent app for which anomalies were detected. Format:
//     apps/{app}.
func (r *AnomaliesService) List(parent string) *AnomaliesListCall {
	c := &AnomaliesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering criteria for
// anomalies. For basic filter guidance, please check:
// https://google.aip.dev/160. **Supported functions:** *
// `activeBetween(startTime, endTime)`: If specified, only list
// anomalies that were active in between `startTime` (inclusive) and
// `endTime` (exclusive). Both parameters are expected to conform to an
// RFC-3339 formatted string (e.g. `2012-04-21T11:30:00-04:00`). UTC
// offsets are supported. Both `startTime` and `endTime` accept the
// special value `UNBOUNDED`, to signify intervals with no lower or
// upper bound, respectively. Examples: *
// `activeBetween("2021-04-21T11:30:00Z", "2021-07-21T00:00:00Z")` *
// `activeBetween(UNBOUNDED, "2021-11-21T00:00:00-04:00")` *
// `activeBetween("2021-07-21T00:00:00-04:00", UNBOUNDED)`
func (c *AnomaliesListCall) Filter(filter string) *AnomaliesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum size of the
// returned data. If unspecified, at most 10 anomalies will be returned.
// The maximum value is 100; values above 100 will be coerced to 100.
func (c *AnomaliesListCall) PageSize(pageSize int64) *AnomaliesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListErrorReports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListErrorReports` must match the call that provided the
// page token.
func (c *AnomaliesListCall) PageToken(pageToken string) *AnomaliesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AnomaliesListCall) Fields(s ...googleapi.Field) *AnomaliesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AnomaliesListCall) IfNoneMatch(entityTag string) *AnomaliesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AnomaliesListCall) Context(ctx context.Context) *AnomaliesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AnomaliesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AnomaliesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}/anomalies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.anomalies.list" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AnomaliesListCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists anomalies in any of the datasets.",
	//   "flatPath": "v1alpha1/apps/{appsId}/anomalies",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.anomalies.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filtering criteria for anomalies. For basic filter guidance, please check: https://google.aip.dev/160. **Supported functions:** * `activeBetween(startTime, endTime)`: If specified, only list anomalies that were active in between `startTime` (inclusive) and `endTime` (exclusive). Both parameters are expected to conform to an RFC-3339 formatted string (e.g. `2012-04-21T11:30:00-04:00`). UTC offsets are supported. Both `startTime` and `endTime` accept the special value `UNBOUNDED`, to signify intervals with no lower or upper bound, respectively. Examples: * `activeBetween(\"2021-04-21T11:30:00Z\", \"2021-07-21T00:00:00Z\")` * `activeBetween(UNBOUNDED, \"2021-11-21T00:00:00-04:00\")` * `activeBetween(\"2021-07-21T00:00:00-04:00\", UNBOUNDED)`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum size of the returned data. If unspecified, at most 10 anomalies will be returned. The maximum value is 100; values above 100 will be coerced to 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListErrorReports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListErrorReports` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent app for which anomalies were detected. Format: apps/{app}",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+parent}/anomalies",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AnomaliesListCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1ListAnomaliesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "playdeveloperreporting.vitals.anrrate.get":

type VitalsAnrrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
// - name: The resource name. Format: apps/{app}/anrRateMetricSet.
func (r *VitalsAnrrateService) Get(name string) *VitalsAnrrateGetCall {
	c := &VitalsAnrrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsAnrrateGetCall) Fields(s ...googleapi.Field) *VitalsAnrrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsAnrrateGetCall) IfNoneMatch(entityTag string) *VitalsAnrrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsAnrrateGetCall) Context(ctx context.Context) *VitalsAnrrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsAnrrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsAnrrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.anrrate.get" call.
// Exactly one of *GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsAnrrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/anrRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.anrrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/anrRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/anrRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1AnrRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.anrrate.query":

type VitalsAnrrateQueryCall struct {
	s                                                                *Service
	name                                                             string
	googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// Query: Queries the metrics in the metric set.
//
// - name: The resource name. Format: apps/{app}/anrRateMetricSet.
func (r *VitalsAnrrateService) Query(name string, googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest) *VitalsAnrrateQueryCall {
	c := &VitalsAnrrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest = googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsAnrrateQueryCall) Fields(s ...googleapi.Field) *VitalsAnrrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsAnrrateQueryCall) Context(ctx context.Context) *VitalsAnrrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsAnrrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsAnrrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.anrrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse.Ser
// verResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsAnrrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/anrRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.anrrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/anrRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/anrRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsAnrrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1QueryAnrRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest.PageToken = pt }(c.googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1alpha1queryanrratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.crashrate.get":

type VitalsCrashrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
// - name: The resource name. Format: apps/{app}/crashRateMetricSet.
func (r *VitalsCrashrateService) Get(name string) *VitalsCrashrateGetCall {
	c := &VitalsCrashrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsCrashrateGetCall) Fields(s ...googleapi.Field) *VitalsCrashrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsCrashrateGetCall) IfNoneMatch(entityTag string) *VitalsCrashrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsCrashrateGetCall) Context(ctx context.Context) *VitalsCrashrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsCrashrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsCrashrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.crashrate.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsCrashrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/crashRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.crashrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/crashRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/crashRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1CrashRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.crashrate.query":

type VitalsCrashrateQueryCall struct {
	s                                                                  *Service
	name                                                               string
	googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest
	urlParams_                                                         gensupport.URLParams
	ctx_                                                               context.Context
	header_                                                            http.Header
}

// Query: Queries the metrics in the metric set.
//
// - name: The resource name. Format: apps/{app}/crashRateMetricSet.
func (r *VitalsCrashrateService) Query(name string, googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest) *VitalsCrashrateQueryCall {
	c := &VitalsCrashrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest = googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsCrashrateQueryCall) Fields(s ...googleapi.Field) *VitalsCrashrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsCrashrateQueryCall) Context(ctx context.Context) *VitalsCrashrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsCrashrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsCrashrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.crashrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse.S
// erverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsCrashrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/crashRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.crashrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/crashRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/crashRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsCrashrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1QueryCrashRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest.PageToken = pt }(c.googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1alpha1querycrashratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.errors.counts.get":

type VitalsErrorsCountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metrics set.
//
//   - name: Name of the errors metric set. Format:
//     apps/{app}/errorCountMetricSet.
func (r *VitalsErrorsCountsService) Get(name string) *VitalsErrorsCountsGetCall {
	c := &VitalsErrorsCountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsErrorsCountsGetCall) Fields(s ...googleapi.Field) *VitalsErrorsCountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsErrorsCountsGetCall) IfNoneMatch(entityTag string) *VitalsErrorsCountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsErrorsCountsGetCall) Context(ctx context.Context) *VitalsErrorsCountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsErrorsCountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsErrorsCountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.errors.counts.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsErrorsCountsGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metrics set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/errorCountMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.errors.counts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/errorCountMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1ErrorCountMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.errors.counts.query":

type VitalsErrorsCountsQueryCall struct {
	s                                                                   *Service
	name                                                                string
	googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest
	urlParams_                                                          gensupport.URLParams
	ctx_                                                                context.Context
	header_                                                             http.Header
}

// Query: Queries the metrics in the metrics set.
//
// - name: The resource name. Format: apps/{app}/errorCountMetricSet.
func (r *VitalsErrorsCountsService) Query(name string, googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest) *VitalsErrorsCountsQueryCall {
	c := &VitalsErrorsCountsQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest = googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsErrorsCountsQueryCall) Fields(s ...googleapi.Field) *VitalsErrorsCountsQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsErrorsCountsQueryCall) Context(ctx context.Context) *VitalsErrorsCountsQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsErrorsCountsQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsErrorsCountsQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.errors.counts.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse.
// ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsErrorsCountsQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metrics set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/errorCountMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.errors.counts.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/errorCountMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/errorCountMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsErrorsCountsQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1QueryErrorCountMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest.PageToken = pt }(c.googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1alpha1queryerrorcountmetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.errors.issues.search":

type VitalsErrorsIssuesSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches all error issues in which reports have been grouped.
//
//   - parent: Parent resource of the error issues, indicating the
//     application for which they were received. Format: apps/{app}.
func (r *VitalsErrorsIssuesService) Search(parent string) *VitalsErrorsIssuesSearchCall {
	c := &VitalsErrorsIssuesSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A selection predicate to
// retrieve only a subset of the issues. Counts in the returned error
// issues will only reflect occurrences that matched the filter. For
// filtering basics, please check AIP-160 (https://google.aip.dev/160).
// ** Supported field names:** * `apiLevel`: Matches error issues that
// occurred in the requested Android versions (specified as the numeric
// API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. *
// `versionCode`: Matches error issues that occurred in the requested
// app version codes only. Example: `versionCode = 123 OR versionCode =
// 456`. * `deviceModel`: Matches error issues that occurred in the
// requested devices. Example: `deviceModel = "walleye" OR deviceModel =
// "marlin". * `deviceType`: Matches error issues that occurred in the
// requested device types. Example: `deviceType = "PHONE". *
// `errorIssueType`: Matches error issues of the requested types only.
// Valid candidates: `CRASH`, `ANR`. Example: `errorIssueType = CRASH OR
// errorIssueType = ANR`. ** Supported operators:** * Comparison
// operators: The only supported comparison operator is equality. The
// filtered field must appear on the left hand side of the comparison. *
// Logical Operators: Logical operators `AND` and `OR` can be used to
// build complex filters following a conjunctive normal form (CNF),
// i.e., conjunctions of disjunctions. The `OR` operator takes
// precedence over `AND` so the use of parenthesis is not necessary when
// building CNF. The `OR` operator is only supported to build
// disjunctions that apply to the same field, e.g., `versionCode = 123
// OR errorIssueType = ANR` is not a valid filter. ** Examples ** Some
// valid filtering expressions: * `versionCode = 123 AND errorIssueType
// = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType =
// CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType =
// CRASH)`
func (c *VitalsErrorsIssuesSearchCall) Filter(filter string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IntervalEndTimeDay sets the optional parameter
// "interval.endTime.day": Day of month. Must be from 1 to 31 and valid
// for the year and month, or 0 if specifying a datetime without a day.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeDay(intervalEndTimeDay int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.day", fmt.Sprint(intervalEndTimeDay))
	return c
}

// IntervalEndTimeHours sets the optional parameter
// "interval.endTime.hours": Hours of day in 24 hour format. Should be
// from 0 to 23, defaults to 0 (midnight). An API may choose to allow
// the value "24:00:00" for scenarios like business closing time.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeHours(intervalEndTimeHours int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.hours", fmt.Sprint(intervalEndTimeHours))
	return c
}

// IntervalEndTimeMinutes sets the optional parameter
// "interval.endTime.minutes": Minutes of hour of day. Must be from 0 to
// 59, defaults to 0.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeMinutes(intervalEndTimeMinutes int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.minutes", fmt.Sprint(intervalEndTimeMinutes))
	return c
}

// IntervalEndTimeMonth sets the optional parameter
// "interval.endTime.month": Month of year. Must be from 1 to 12, or 0
// if specifying a datetime without a month.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeMonth(intervalEndTimeMonth int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.month", fmt.Sprint(intervalEndTimeMonth))
	return c
}

// IntervalEndTimeNanos sets the optional parameter
// "interval.endTime.nanos": Fractions of seconds in nanoseconds. Must
// be from 0 to 999,999,999, defaults to 0.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeNanos(intervalEndTimeNanos int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.nanos", fmt.Sprint(intervalEndTimeNanos))
	return c
}

// IntervalEndTimeSeconds sets the optional parameter
// "interval.endTime.seconds": Seconds of minutes of the time. Must
// normally be from 0 to 59, defaults to 0. An API may allow the value
// 60 if it allows leap-seconds.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeSeconds(intervalEndTimeSeconds int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.seconds", fmt.Sprint(intervalEndTimeSeconds))
	return c
}

// IntervalEndTimeTimeZoneId sets the optional parameter
// "interval.endTime.timeZone.id": IANA Time Zone Database time zone,
// e.g. "America/New_York".
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeTimeZoneId(intervalEndTimeTimeZoneId string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.timeZone.id", intervalEndTimeTimeZoneId)
	return c
}

// IntervalEndTimeTimeZoneVersion sets the optional parameter
// "interval.endTime.timeZone.version": IANA Time Zone Database version
// number, e.g. "2019a".
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeTimeZoneVersion(intervalEndTimeTimeZoneVersion string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.timeZone.version", intervalEndTimeTimeZoneVersion)
	return c
}

// IntervalEndTimeUtcOffset sets the optional parameter
// "interval.endTime.utcOffset": UTC offset. Must be whole seconds,
// between -18 hours and +18 hours. For example, a UTC offset of -4:00
// would be represented as { seconds: -14400 }.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeUtcOffset(intervalEndTimeUtcOffset string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.utcOffset", intervalEndTimeUtcOffset)
	return c
}

// IntervalEndTimeYear sets the optional parameter
// "interval.endTime.year": Year of date. Must be from 1 to 9999, or 0
// if specifying a datetime without a year.
func (c *VitalsErrorsIssuesSearchCall) IntervalEndTimeYear(intervalEndTimeYear int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.endTime.year", fmt.Sprint(intervalEndTimeYear))
	return c
}

// IntervalStartTimeDay sets the optional parameter
// "interval.startTime.day": Day of month. Must be from 1 to 31 and
// valid for the year and month, or 0 if specifying a datetime without a
// day.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeDay(intervalStartTimeDay int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.day", fmt.Sprint(intervalStartTimeDay))
	return c
}

// IntervalStartTimeHours sets the optional parameter
// "interval.startTime.hours": Hours of day in 24 hour format. Should be
// from 0 to 23, defaults to 0 (midnight). An API may choose to allow
// the value "24:00:00" for scenarios like business closing time.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeHours(intervalStartTimeHours int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.hours", fmt.Sprint(intervalStartTimeHours))
	return c
}

// IntervalStartTimeMinutes sets the optional parameter
// "interval.startTime.minutes": Minutes of hour of day. Must be from 0
// to 59, defaults to 0.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeMinutes(intervalStartTimeMinutes int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.minutes", fmt.Sprint(intervalStartTimeMinutes))
	return c
}

// IntervalStartTimeMonth sets the optional parameter
// "interval.startTime.month": Month of year. Must be from 1 to 12, or 0
// if specifying a datetime without a month.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeMonth(intervalStartTimeMonth int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.month", fmt.Sprint(intervalStartTimeMonth))
	return c
}

// IntervalStartTimeNanos sets the optional parameter
// "interval.startTime.nanos": Fractions of seconds in nanoseconds. Must
// be from 0 to 999,999,999, defaults to 0.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeNanos(intervalStartTimeNanos int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.nanos", fmt.Sprint(intervalStartTimeNanos))
	return c
}

// IntervalStartTimeSeconds sets the optional parameter
// "interval.startTime.seconds": Seconds of minutes of the time. Must
// normally be from 0 to 59, defaults to 0. An API may allow the value
// 60 if it allows leap-seconds.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeSeconds(intervalStartTimeSeconds int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.seconds", fmt.Sprint(intervalStartTimeSeconds))
	return c
}

// IntervalStartTimeTimeZoneId sets the optional parameter
// "interval.startTime.timeZone.id": IANA Time Zone Database time zone,
// e.g. "America/New_York".
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeTimeZoneId(intervalStartTimeTimeZoneId string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.timeZone.id", intervalStartTimeTimeZoneId)
	return c
}

// IntervalStartTimeTimeZoneVersion sets the optional parameter
// "interval.startTime.timeZone.version": IANA Time Zone Database
// version number, e.g. "2019a".
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeTimeZoneVersion(intervalStartTimeTimeZoneVersion string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.timeZone.version", intervalStartTimeTimeZoneVersion)
	return c
}

// IntervalStartTimeUtcOffset sets the optional parameter
// "interval.startTime.utcOffset": UTC offset. Must be whole seconds,
// between -18 hours and +18 hours. For example, a UTC offset of -4:00
// would be represented as { seconds: -14400 }.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeUtcOffset(intervalStartTimeUtcOffset string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.utcOffset", intervalStartTimeUtcOffset)
	return c
}

// IntervalStartTimeYear sets the optional parameter
// "interval.startTime.year": Year of date. Must be from 1 to 9999, or 0
// if specifying a datetime without a year.
func (c *VitalsErrorsIssuesSearchCall) IntervalStartTimeYear(intervalStartTimeYear int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("interval.startTime.year", fmt.Sprint(intervalStartTimeYear))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of error issues to return. The service may return fewer than this
// value. If unspecified, at most 50 error issues will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *VitalsErrorsIssuesSearchCall) PageSize(pageSize int64) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// the request must match the call that provided the page token.
func (c *VitalsErrorsIssuesSearchCall) PageToken(pageToken string) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsErrorsIssuesSearchCall) Fields(s ...googleapi.Field) *VitalsErrorsIssuesSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsErrorsIssuesSearchCall) IfNoneMatch(entityTag string) *VitalsErrorsIssuesSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsErrorsIssuesSearchCall) Context(ctx context.Context) *VitalsErrorsIssuesSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsErrorsIssuesSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsErrorsIssuesSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}/errorIssues:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.errors.issues.search" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse.ServerR
// esponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsErrorsIssuesSearchCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches all error issues in which reports have been grouped.",
	//   "flatPath": "v1alpha1/apps/{appsId}/errorIssues:search",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.errors.issues.search",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A selection predicate to retrieve only a subset of the issues. Counts in the returned error issues will only reflect occurrences that matched the filter. For filtering basics, please check [AIP-160](https://google.aip.dev/160). ** Supported field names:** * `apiLevel`: Matches error issues that occurred in the requested Android versions (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. * `versionCode`: Matches error issues that occurred in the requested app version codes only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error issues that occurred in the requested devices. Example: `deviceModel = \"walleye\" OR deviceModel = \"marlin\"`. * `deviceType`: Matches error issues that occurred in the requested device types. Example: `deviceType = \"PHONE\"`. * `errorIssueType`: Matches error issues of the requested types only. Valid candidates: `CRASH`, `ANR`. Example: `errorIssueType = CRASH OR errorIssueType = ANR`. ** Supported operators:** * Comparison operators: The only supported comparison operator is equality. The filtered field must appear on the left hand side of the comparison. * Logical Operators: Logical operators `AND` and `OR` can be used to build complex filters following a conjunctive normal form (CNF), i.e., conjunctions of disjunctions. The `OR` operator takes precedence over `AND` so the use of parenthesis is not necessary when building CNF. The `OR` operator is only supported to build disjunctions that apply to the same field, e.g., `versionCode = 123 OR errorIssueType = ANR` is not a valid filter. ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType = CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.day": {
	//       "description": "Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.hours": {
	//       "description": "Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value \"24:00:00\" for scenarios like business closing time.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.minutes": {
	//       "description": "Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.month": {
	//       "description": "Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.nanos": {
	//       "description": "Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.seconds": {
	//       "description": "Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.timeZone.id": {
	//       "description": "IANA Time Zone Database time zone, e.g. \"America/New_York\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.timeZone.version": {
	//       "description": "Optional. IANA Time Zone Database version number, e.g. \"2019a\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.utcOffset": {
	//       "description": "UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.year": {
	//       "description": "Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.day": {
	//       "description": "Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.hours": {
	//       "description": "Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value \"24:00:00\" for scenarios like business closing time.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.minutes": {
	//       "description": "Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.month": {
	//       "description": "Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.nanos": {
	//       "description": "Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.seconds": {
	//       "description": "Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.timeZone.id": {
	//       "description": "IANA Time Zone Database time zone, e.g. \"America/New_York\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.timeZone.version": {
	//       "description": "Optional. IANA Time Zone Database version number, e.g. \"2019a\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.utcOffset": {
	//       "description": "UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.year": {
	//       "description": "Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of error issues to return. The service may return fewer than this value. If unspecified, at most 50 error issues will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to the request must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent resource of the error issues, indicating the application for which they were received. Format: apps/{app}",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+parent}/errorIssues:search",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsErrorsIssuesSearchCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1SearchErrorIssuesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "playdeveloperreporting.vitals.errors.reports.search":

type VitalsErrorsReportsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches all error reports received for an app.
//
//   - parent: Parent resource of the reports, indicating the application
//     for which they were received. Format: apps/{app}.
func (r *VitalsErrorsReportsService) Search(parent string) *VitalsErrorsReportsSearchCall {
	c := &VitalsErrorsReportsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A selection predicate to
// retrieve only a subset of the reports. For filtering basics, please
// check AIP-160 (https://google.aip.dev/160). ** Supported field
// names:** * `apiLevel`: Matches error reports that occurred in the
// requested Android versions (specified as the numeric API level) only.
// Example: `apiLevel = 28 OR apiLevel = 29`. * `versionCode`: Matches
// error reports that occurred in the requested app version codes only.
// Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`:
// Matches error reports that occurred in the requested devices.
// Example: `deviceModel = "walleye" OR deviceModel = "marlin". *
// `deviceType`: Matches error reports that occurred in the requested
// device types. Example: `deviceType = "PHONE". * `errorIssueType`:
// Matches error reports of the requested types only. Valid candidates:
// `JAVA_CRASH`, `NATIVE_CRASH`, `ANR`. Example: `errorIssueType =
// JAVA_CRASH OR errorIssueType = NATIVE_CRASH`. * `errorIssueId`:
// Matches error reports belonging to the requested error issue ids
// only. Example: `errorIssueId = 1234 OR errorIssueId = 4567`. **
// Supported operators:** * Comparison operators: The only supported
// comparison operator is equality. The filtered field must appear on
// the left hand side of the comparison. * Logical Operators: Logical
// operators `AND` and `OR` can be used to build complex filters
// following a conjunctive normal form (CNF), i.e., conjunctions of
// disjunctions. The `OR` operator takes precedence over `AND` so the
// use of parenthesis is not necessary when building CNF. The `OR`
// operator is only supported to build disjunctions that apply to the
// same field, e.g., `versionCode = 123 OR versionCode = ANR`. The
// filter expression `versionCode = 123 OR errorIssueType = ANR` is not
// valid. ** Examples ** Some valid filtering expressions: *
// `versionCode = 123 AND errorIssueType = ANR` * `versionCode = 123 AND
// errorIssueType = OR errorIssueType = CRASH` * `versionCode = 123 AND
// (errorIssueType = OR errorIssueType = CRASH)`
func (c *VitalsErrorsReportsSearchCall) Filter(filter string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IntervalEndTimeDay sets the optional parameter
// "interval.endTime.day": Day of month. Must be from 1 to 31 and valid
// for the year and month, or 0 if specifying a datetime without a day.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeDay(intervalEndTimeDay int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.day", fmt.Sprint(intervalEndTimeDay))
	return c
}

// IntervalEndTimeHours sets the optional parameter
// "interval.endTime.hours": Hours of day in 24 hour format. Should be
// from 0 to 23, defaults to 0 (midnight). An API may choose to allow
// the value "24:00:00" for scenarios like business closing time.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeHours(intervalEndTimeHours int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.hours", fmt.Sprint(intervalEndTimeHours))
	return c
}

// IntervalEndTimeMinutes sets the optional parameter
// "interval.endTime.minutes": Minutes of hour of day. Must be from 0 to
// 59, defaults to 0.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeMinutes(intervalEndTimeMinutes int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.minutes", fmt.Sprint(intervalEndTimeMinutes))
	return c
}

// IntervalEndTimeMonth sets the optional parameter
// "interval.endTime.month": Month of year. Must be from 1 to 12, or 0
// if specifying a datetime without a month.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeMonth(intervalEndTimeMonth int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.month", fmt.Sprint(intervalEndTimeMonth))
	return c
}

// IntervalEndTimeNanos sets the optional parameter
// "interval.endTime.nanos": Fractions of seconds in nanoseconds. Must
// be from 0 to 999,999,999, defaults to 0.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeNanos(intervalEndTimeNanos int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.nanos", fmt.Sprint(intervalEndTimeNanos))
	return c
}

// IntervalEndTimeSeconds sets the optional parameter
// "interval.endTime.seconds": Seconds of minutes of the time. Must
// normally be from 0 to 59, defaults to 0. An API may allow the value
// 60 if it allows leap-seconds.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeSeconds(intervalEndTimeSeconds int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.seconds", fmt.Sprint(intervalEndTimeSeconds))
	return c
}

// IntervalEndTimeTimeZoneId sets the optional parameter
// "interval.endTime.timeZone.id": IANA Time Zone Database time zone,
// e.g. "America/New_York".
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeTimeZoneId(intervalEndTimeTimeZoneId string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.timeZone.id", intervalEndTimeTimeZoneId)
	return c
}

// IntervalEndTimeTimeZoneVersion sets the optional parameter
// "interval.endTime.timeZone.version": IANA Time Zone Database version
// number, e.g. "2019a".
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeTimeZoneVersion(intervalEndTimeTimeZoneVersion string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.timeZone.version", intervalEndTimeTimeZoneVersion)
	return c
}

// IntervalEndTimeUtcOffset sets the optional parameter
// "interval.endTime.utcOffset": UTC offset. Must be whole seconds,
// between -18 hours and +18 hours. For example, a UTC offset of -4:00
// would be represented as { seconds: -14400 }.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeUtcOffset(intervalEndTimeUtcOffset string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.utcOffset", intervalEndTimeUtcOffset)
	return c
}

// IntervalEndTimeYear sets the optional parameter
// "interval.endTime.year": Year of date. Must be from 1 to 9999, or 0
// if specifying a datetime without a year.
func (c *VitalsErrorsReportsSearchCall) IntervalEndTimeYear(intervalEndTimeYear int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.endTime.year", fmt.Sprint(intervalEndTimeYear))
	return c
}

// IntervalStartTimeDay sets the optional parameter
// "interval.startTime.day": Day of month. Must be from 1 to 31 and
// valid for the year and month, or 0 if specifying a datetime without a
// day.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeDay(intervalStartTimeDay int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.day", fmt.Sprint(intervalStartTimeDay))
	return c
}

// IntervalStartTimeHours sets the optional parameter
// "interval.startTime.hours": Hours of day in 24 hour format. Should be
// from 0 to 23, defaults to 0 (midnight). An API may choose to allow
// the value "24:00:00" for scenarios like business closing time.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeHours(intervalStartTimeHours int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.hours", fmt.Sprint(intervalStartTimeHours))
	return c
}

// IntervalStartTimeMinutes sets the optional parameter
// "interval.startTime.minutes": Minutes of hour of day. Must be from 0
// to 59, defaults to 0.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeMinutes(intervalStartTimeMinutes int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.minutes", fmt.Sprint(intervalStartTimeMinutes))
	return c
}

// IntervalStartTimeMonth sets the optional parameter
// "interval.startTime.month": Month of year. Must be from 1 to 12, or 0
// if specifying a datetime without a month.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeMonth(intervalStartTimeMonth int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.month", fmt.Sprint(intervalStartTimeMonth))
	return c
}

// IntervalStartTimeNanos sets the optional parameter
// "interval.startTime.nanos": Fractions of seconds in nanoseconds. Must
// be from 0 to 999,999,999, defaults to 0.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeNanos(intervalStartTimeNanos int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.nanos", fmt.Sprint(intervalStartTimeNanos))
	return c
}

// IntervalStartTimeSeconds sets the optional parameter
// "interval.startTime.seconds": Seconds of minutes of the time. Must
// normally be from 0 to 59, defaults to 0. An API may allow the value
// 60 if it allows leap-seconds.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeSeconds(intervalStartTimeSeconds int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.seconds", fmt.Sprint(intervalStartTimeSeconds))
	return c
}

// IntervalStartTimeTimeZoneId sets the optional parameter
// "interval.startTime.timeZone.id": IANA Time Zone Database time zone,
// e.g. "America/New_York".
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeTimeZoneId(intervalStartTimeTimeZoneId string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.timeZone.id", intervalStartTimeTimeZoneId)
	return c
}

// IntervalStartTimeTimeZoneVersion sets the optional parameter
// "interval.startTime.timeZone.version": IANA Time Zone Database
// version number, e.g. "2019a".
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeTimeZoneVersion(intervalStartTimeTimeZoneVersion string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.timeZone.version", intervalStartTimeTimeZoneVersion)
	return c
}

// IntervalStartTimeUtcOffset sets the optional parameter
// "interval.startTime.utcOffset": UTC offset. Must be whole seconds,
// between -18 hours and +18 hours. For example, a UTC offset of -4:00
// would be represented as { seconds: -14400 }.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeUtcOffset(intervalStartTimeUtcOffset string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.utcOffset", intervalStartTimeUtcOffset)
	return c
}

// IntervalStartTimeYear sets the optional parameter
// "interval.startTime.year": Year of date. Must be from 1 to 9999, or 0
// if specifying a datetime without a year.
func (c *VitalsErrorsReportsSearchCall) IntervalStartTimeYear(intervalStartTimeYear int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("interval.startTime.year", fmt.Sprint(intervalStartTimeYear))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of reports to return. The service may return fewer than this value.
// If unspecified, at most 50 reports will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *VitalsErrorsReportsSearchCall) PageSize(pageSize int64) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `SearchErrorReports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `SearchErrorReports` must match the call that provided
// the page token.
func (c *VitalsErrorsReportsSearchCall) PageToken(pageToken string) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsErrorsReportsSearchCall) Fields(s ...googleapi.Field) *VitalsErrorsReportsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsErrorsReportsSearchCall) IfNoneMatch(entityTag string) *VitalsErrorsReportsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsErrorsReportsSearchCall) Context(ctx context.Context) *VitalsErrorsReportsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsErrorsReportsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsErrorsReportsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}/errorReports:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.errors.reports.search" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsErrorsReportsSearchCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches all error reports received for an app.",
	//   "flatPath": "v1alpha1/apps/{appsId}/errorReports:search",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.errors.reports.search",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A selection predicate to retrieve only a subset of the reports. For filtering basics, please check [AIP-160](https://google.aip.dev/160). ** Supported field names:** * `apiLevel`: Matches error reports that occurred in the requested Android versions (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. * `versionCode`: Matches error reports that occurred in the requested app version codes only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error reports that occurred in the requested devices. Example: `deviceModel = \"walleye\" OR deviceModel = \"marlin\"`. * `deviceType`: Matches error reports that occurred in the requested device types. Example: `deviceType = \"PHONE\"`. * `errorIssueType`: Matches error reports of the requested types only. Valid candidates: `JAVA_CRASH`, `NATIVE_CRASH`, `ANR`. Example: `errorIssueType = JAVA_CRASH OR errorIssueType = NATIVE_CRASH`. * `errorIssueId`: Matches error reports belonging to the requested error issue ids only. Example: `errorIssueId = 1234 OR errorIssueId = 4567`. ** Supported operators:** * Comparison operators: The only supported comparison operator is equality. The filtered field must appear on the left hand side of the comparison. * Logical Operators: Logical operators `AND` and `OR` can be used to build complex filters following a conjunctive normal form (CNF), i.e., conjunctions of disjunctions. The `OR` operator takes precedence over `AND` so the use of parenthesis is not necessary when building CNF. The `OR` operator is only supported to build disjunctions that apply to the same field, e.g., `versionCode = 123 OR versionCode = ANR`. The filter expression `versionCode = 123 OR errorIssueType = ANR` is not valid. ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType = CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.day": {
	//       "description": "Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.hours": {
	//       "description": "Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value \"24:00:00\" for scenarios like business closing time.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.minutes": {
	//       "description": "Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.month": {
	//       "description": "Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.nanos": {
	//       "description": "Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.seconds": {
	//       "description": "Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.endTime.timeZone.id": {
	//       "description": "IANA Time Zone Database time zone, e.g. \"America/New_York\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.timeZone.version": {
	//       "description": "Optional. IANA Time Zone Database version number, e.g. \"2019a\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.utcOffset": {
	//       "description": "UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime.year": {
	//       "description": "Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.day": {
	//       "description": "Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.hours": {
	//       "description": "Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value \"24:00:00\" for scenarios like business closing time.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.minutes": {
	//       "description": "Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.month": {
	//       "description": "Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.nanos": {
	//       "description": "Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.seconds": {
	//       "description": "Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "interval.startTime.timeZone.id": {
	//       "description": "IANA Time Zone Database time zone, e.g. \"America/New_York\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.timeZone.version": {
	//       "description": "Optional. IANA Time Zone Database version number, e.g. \"2019a\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.utcOffset": {
	//       "description": "UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime.year": {
	//       "description": "Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of reports to return. The service may return fewer than this value. If unspecified, at most 50 reports will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `SearchErrorReports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `SearchErrorReports` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent resource of the reports, indicating the application for which they were received. Format: apps/{app}",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+parent}/errorReports:search",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsErrorsReportsSearchCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1SearchErrorReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "playdeveloperreporting.vitals.excessivewakeuprate.get":

type VitalsExcessivewakeuprateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/excessiveWakeupRateMetricSet.
func (r *VitalsExcessivewakeuprateService) Get(name string) *VitalsExcessivewakeuprateGetCall {
	c := &VitalsExcessivewakeuprateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsExcessivewakeuprateGetCall) Fields(s ...googleapi.Field) *VitalsExcessivewakeuprateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsExcessivewakeuprateGetCall) IfNoneMatch(entityTag string) *VitalsExcessivewakeuprateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsExcessivewakeuprateGetCall) Context(ctx context.Context) *VitalsExcessivewakeuprateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsExcessivewakeuprateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsExcessivewakeuprateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.excessivewakeuprate.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsExcessivewakeuprateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/excessiveWakeupRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.excessivewakeuprate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/excessiveWakeupRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1ExcessiveWakeupRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.excessivewakeuprate.query":

type VitalsExcessivewakeuprateQueryCall struct {
	s                                                                            *Service
	name                                                                         string
	googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest
	urlParams_                                                                   gensupport.URLParams
	ctx_                                                                         context.Context
	header_                                                                      http.Header
}

// Query: Queries the metrics in the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/excessiveWakeupRateMetricSet.
func (r *VitalsExcessivewakeuprateService) Query(name string, googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest) *VitalsExcessivewakeuprateQueryCall {
	c := &VitalsExcessivewakeuprateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest = googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsExcessivewakeuprateQueryCall) Fields(s ...googleapi.Field) *VitalsExcessivewakeuprateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsExcessivewakeuprateQueryCall) Context(ctx context.Context) *VitalsExcessivewakeuprateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsExcessivewakeuprateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsExcessivewakeuprateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.excessivewakeuprate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSet
// Response or error will be non-nil. Any non-2xx status code is an
// error. Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSet
// Response.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *VitalsExcessivewakeuprateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/excessiveWakeupRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.excessivewakeuprate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/excessiveWakeupRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsExcessivewakeuprateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1QueryExcessiveWakeupRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) {
		c.googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest.PageToken = pt
	}(c.googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1alpha1queryexcessivewakeupratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get":

type VitalsStuckbackgroundwakelockrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/stuckBackgroundWakelockRateMetricSet.
func (r *VitalsStuckbackgroundwakelockrateService) Get(name string) *VitalsStuckbackgroundwakelockrateGetCall {
	c := &VitalsStuckbackgroundwakelockrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Fields(s ...googleapi.Field) *VitalsStuckbackgroundwakelockrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsStuckbackgroundwakelockrateGetCall) IfNoneMatch(entityTag string) *VitalsStuckbackgroundwakelockrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Context(ctx context.Context) *VitalsStuckbackgroundwakelockrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsStuckbackgroundwakelockrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetric
// Set or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetric
// Set.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/stuckBackgroundWakelockRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1StuckBackgroundWakelockRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query":

type VitalsStuckbackgroundwakelockrateQueryCall struct {
	s                                                                                    *Service
	name                                                                                 string
	googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest
	urlParams_                                                                           gensupport.URLParams
	ctx_                                                                                 context.Context
	header_                                                                              http.Header
}

// Query: Queries the metrics in the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/stuckBackgroundWakelockRateMetricSet.
func (r *VitalsStuckbackgroundwakelockrateService) Query(name string, googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest) *VitalsStuckbackgroundwakelockrateQueryCall {
	c := &VitalsStuckbackgroundwakelockrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest = googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Fields(s ...googleapi.Field) *VitalsStuckbackgroundwakelockrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Context(ctx context.Context) *VitalsStuckbackgroundwakelockrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsStuckbackgroundwakelockrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateM
// etricSetResponse or error will be non-nil. Any non-2xx status code is
// an error. Response headers are in either
// *GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateM
// etricSetResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1alpha1/apps/{appsId}/stuckBackgroundWakelockRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1alpha1QueryStuckBackgroundWakelockRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) {
		c.googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest.PageToken = pt
	}(c.googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1alpha1querystuckbackgroundwakelockratemetricsetrequest.PageToken = x.NextPageToken
	}
}
