package libtimetest

// Code generated by http://github.com/gojuno/minimock (dev). DO NOT EDIT.

import (
	"sync"
	mm_atomic "sync/atomic"
	"time"
	mm_time "time"

	"github.com/gojuno/minimock/v3"
)

// ClockMock implements libtime.Clock
type ClockMock struct {
	t minimock.Tester

	funcNow          func() (t1 time.Time)
	inspectFuncNow   func()
	afterNowCounter  uint64
	beforeNowCounter uint64
	NowMock          mClockMockNow

	funcSince          func(t1 time.Time) (d1 time.Duration)
	inspectFuncSince   func(t1 time.Time)
	afterSinceCounter  uint64
	beforeSinceCounter uint64
	SinceMock          mClockMockSince

	funcSinceMS          func(t1 time.Time) (i1 int)
	inspectFuncSinceMS   func(t1 time.Time)
	afterSinceMSCounter  uint64
	beforeSinceMSCounter uint64
	SinceMSMock          mClockMockSinceMS
}

// NewClockMock returns a mock for libtime.Clock
func NewClockMock(t minimock.Tester) *ClockMock {
	m := &ClockMock{t: t}
	if controller, ok := t.(minimock.MockController); ok {
		controller.RegisterMocker(m)
	}

	m.NowMock = mClockMockNow{mock: m}

	m.SinceMock = mClockMockSince{mock: m}
	m.SinceMock.callArgs = []*ClockMockSinceParams{}

	m.SinceMSMock = mClockMockSinceMS{mock: m}
	m.SinceMSMock.callArgs = []*ClockMockSinceMSParams{}

	return m
}

type mClockMockNow struct {
	mock               *ClockMock
	defaultExpectation *ClockMockNowExpectation
	expectations       []*ClockMockNowExpectation
}

// ClockMockNowExpectation specifies expectation struct of the Clock.Now
type ClockMockNowExpectation struct {
	mock *ClockMock

	results *ClockMockNowResults
	Counter uint64
}

// ClockMockNowResults contains results of the Clock.Now
type ClockMockNowResults struct {
	t1 time.Time
}

// Expect sets up expected params for Clock.Now
func (mmNow *mClockMockNow) Expect() *mClockMockNow {
	if mmNow.mock.funcNow != nil {
		mmNow.mock.t.Fatalf("ClockMock.Now mock is already set by Set")
	}

	if mmNow.defaultExpectation == nil {
		mmNow.defaultExpectation = &ClockMockNowExpectation{}
	}

	return mmNow
}

// Inspect accepts an inspector function that has same arguments as the Clock.Now
func (mmNow *mClockMockNow) Inspect(f func()) *mClockMockNow {
	if mmNow.mock.inspectFuncNow != nil {
		mmNow.mock.t.Fatalf("Inspect function is already set for ClockMock.Now")
	}

	mmNow.mock.inspectFuncNow = f

	return mmNow
}

// Return sets up results that will be returned by Clock.Now
func (mmNow *mClockMockNow) Return(t1 time.Time) *ClockMock {
	if mmNow.mock.funcNow != nil {
		mmNow.mock.t.Fatalf("ClockMock.Now mock is already set by Set")
	}

	if mmNow.defaultExpectation == nil {
		mmNow.defaultExpectation = &ClockMockNowExpectation{mock: mmNow.mock}
	}
	mmNow.defaultExpectation.results = &ClockMockNowResults{t1}
	return mmNow.mock
}

//Set uses given function f to mock the Clock.Now method
func (mmNow *mClockMockNow) Set(f func() (t1 time.Time)) *ClockMock {
	if mmNow.defaultExpectation != nil {
		mmNow.mock.t.Fatalf("Default expectation is already set for the Clock.Now method")
	}

	if len(mmNow.expectations) > 0 {
		mmNow.mock.t.Fatalf("Some expectations are already set for the Clock.Now method")
	}

	mmNow.mock.funcNow = f
	return mmNow.mock
}

// Now implements libtime.Clock
func (mmNow *ClockMock) Now() (t1 time.Time) {
	mm_atomic.AddUint64(&mmNow.beforeNowCounter, 1)
	defer mm_atomic.AddUint64(&mmNow.afterNowCounter, 1)

	if mmNow.inspectFuncNow != nil {
		mmNow.inspectFuncNow()
	}

	if mmNow.NowMock.defaultExpectation != nil {
		mm_atomic.AddUint64(&mmNow.NowMock.defaultExpectation.Counter, 1)

		mm_results := mmNow.NowMock.defaultExpectation.results
		if mm_results == nil {
			mmNow.t.Fatal("No results are set for the ClockMock.Now")
		}
		return (*mm_results).t1
	}
	if mmNow.funcNow != nil {
		return mmNow.funcNow()
	}
	mmNow.t.Fatalf("Unexpected call to ClockMock.Now.")
	return
}

// NowAfterCounter returns a count of finished ClockMock.Now invocations
func (mmNow *ClockMock) NowAfterCounter() uint64 {
	return mm_atomic.LoadUint64(&mmNow.afterNowCounter)
}

// NowBeforeCounter returns a count of ClockMock.Now invocations
func (mmNow *ClockMock) NowBeforeCounter() uint64 {
	return mm_atomic.LoadUint64(&mmNow.beforeNowCounter)
}

// MinimockNowDone returns true if the count of the Now invocations corresponds
// the number of defined expectations
func (m *ClockMock) MinimockNowDone() bool {
	for _, e := range m.NowMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			return false
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.NowMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterNowCounter) < 1 {
		return false
	}
	// if func was set then invocations count should be greater than zero
	if m.funcNow != nil && mm_atomic.LoadUint64(&m.afterNowCounter) < 1 {
		return false
	}
	return true
}

// MinimockNowInspect logs each unmet expectation
func (m *ClockMock) MinimockNowInspect() {
	for _, e := range m.NowMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			m.t.Error("Expected call to ClockMock.Now")
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.NowMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterNowCounter) < 1 {
		m.t.Error("Expected call to ClockMock.Now")
	}
	// if func was set then invocations count should be greater than zero
	if m.funcNow != nil && mm_atomic.LoadUint64(&m.afterNowCounter) < 1 {
		m.t.Error("Expected call to ClockMock.Now")
	}
}

type mClockMockSince struct {
	mock               *ClockMock
	defaultExpectation *ClockMockSinceExpectation
	expectations       []*ClockMockSinceExpectation

	callArgs []*ClockMockSinceParams
	mutex    sync.RWMutex
}

// ClockMockSinceExpectation specifies expectation struct of the Clock.Since
type ClockMockSinceExpectation struct {
	mock    *ClockMock
	params  *ClockMockSinceParams
	results *ClockMockSinceResults
	Counter uint64
}

// ClockMockSinceParams contains parameters of the Clock.Since
type ClockMockSinceParams struct {
	t1 time.Time
}

// ClockMockSinceResults contains results of the Clock.Since
type ClockMockSinceResults struct {
	d1 time.Duration
}

// Expect sets up expected params for Clock.Since
func (mmSince *mClockMockSince) Expect(t1 time.Time) *mClockMockSince {
	if mmSince.mock.funcSince != nil {
		mmSince.mock.t.Fatalf("ClockMock.Since mock is already set by Set")
	}

	if mmSince.defaultExpectation == nil {
		mmSince.defaultExpectation = &ClockMockSinceExpectation{}
	}

	mmSince.defaultExpectation.params = &ClockMockSinceParams{t1}
	for _, e := range mmSince.expectations {
		if minimock.Equal(e.params, mmSince.defaultExpectation.params) {
			mmSince.mock.t.Fatalf("Expectation set by When has same params: %#v", *mmSince.defaultExpectation.params)
		}
	}

	return mmSince
}

// Inspect accepts an inspector function that has same arguments as the Clock.Since
func (mmSince *mClockMockSince) Inspect(f func(t1 time.Time)) *mClockMockSince {
	if mmSince.mock.inspectFuncSince != nil {
		mmSince.mock.t.Fatalf("Inspect function is already set for ClockMock.Since")
	}

	mmSince.mock.inspectFuncSince = f

	return mmSince
}

// Return sets up results that will be returned by Clock.Since
func (mmSince *mClockMockSince) Return(d1 time.Duration) *ClockMock {
	if mmSince.mock.funcSince != nil {
		mmSince.mock.t.Fatalf("ClockMock.Since mock is already set by Set")
	}

	if mmSince.defaultExpectation == nil {
		mmSince.defaultExpectation = &ClockMockSinceExpectation{mock: mmSince.mock}
	}
	mmSince.defaultExpectation.results = &ClockMockSinceResults{d1}
	return mmSince.mock
}

//Set uses given function f to mock the Clock.Since method
func (mmSince *mClockMockSince) Set(f func(t1 time.Time) (d1 time.Duration)) *ClockMock {
	if mmSince.defaultExpectation != nil {
		mmSince.mock.t.Fatalf("Default expectation is already set for the Clock.Since method")
	}

	if len(mmSince.expectations) > 0 {
		mmSince.mock.t.Fatalf("Some expectations are already set for the Clock.Since method")
	}

	mmSince.mock.funcSince = f
	return mmSince.mock
}

// When sets expectation for the Clock.Since which will trigger the result defined by the following
// Then helper
func (mmSince *mClockMockSince) When(t1 time.Time) *ClockMockSinceExpectation {
	if mmSince.mock.funcSince != nil {
		mmSince.mock.t.Fatalf("ClockMock.Since mock is already set by Set")
	}

	expectation := &ClockMockSinceExpectation{
		mock:   mmSince.mock,
		params: &ClockMockSinceParams{t1},
	}
	mmSince.expectations = append(mmSince.expectations, expectation)
	return expectation
}

// Then sets up Clock.Since return parameters for the expectation previously defined by the When method
func (e *ClockMockSinceExpectation) Then(d1 time.Duration) *ClockMock {
	e.results = &ClockMockSinceResults{d1}
	return e.mock
}

// Since implements libtime.Clock
func (mmSince *ClockMock) Since(t1 time.Time) (d1 time.Duration) {
	mm_atomic.AddUint64(&mmSince.beforeSinceCounter, 1)
	defer mm_atomic.AddUint64(&mmSince.afterSinceCounter, 1)

	if mmSince.inspectFuncSince != nil {
		mmSince.inspectFuncSince(t1)
	}

	mm_params := &ClockMockSinceParams{t1}

	// Record call args
	mmSince.SinceMock.mutex.Lock()
	mmSince.SinceMock.callArgs = append(mmSince.SinceMock.callArgs, mm_params)
	mmSince.SinceMock.mutex.Unlock()

	for _, e := range mmSince.SinceMock.expectations {
		if minimock.Equal(e.params, mm_params) {
			mm_atomic.AddUint64(&e.Counter, 1)
			return e.results.d1
		}
	}

	if mmSince.SinceMock.defaultExpectation != nil {
		mm_atomic.AddUint64(&mmSince.SinceMock.defaultExpectation.Counter, 1)
		mm_want := mmSince.SinceMock.defaultExpectation.params
		mm_got := ClockMockSinceParams{t1}
		if mm_want != nil && !minimock.Equal(*mm_want, mm_got) {
			mmSince.t.Errorf("ClockMock.Since got unexpected parameters, want: %#v, got: %#v%s\n", *mm_want, mm_got, minimock.Diff(*mm_want, mm_got))
		}

		mm_results := mmSince.SinceMock.defaultExpectation.results
		if mm_results == nil {
			mmSince.t.Fatal("No results are set for the ClockMock.Since")
		}
		return (*mm_results).d1
	}
	if mmSince.funcSince != nil {
		return mmSince.funcSince(t1)
	}
	mmSince.t.Fatalf("Unexpected call to ClockMock.Since. %v", t1)
	return
}

// SinceAfterCounter returns a count of finished ClockMock.Since invocations
func (mmSince *ClockMock) SinceAfterCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSince.afterSinceCounter)
}

// SinceBeforeCounter returns a count of ClockMock.Since invocations
func (mmSince *ClockMock) SinceBeforeCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSince.beforeSinceCounter)
}

// Calls returns a list of arguments used in each call to ClockMock.Since.
// The list is in the same order as the calls were made (i.e. recent calls have a higher index)
func (mmSince *mClockMockSince) Calls() []*ClockMockSinceParams {
	mmSince.mutex.RLock()

	argCopy := make([]*ClockMockSinceParams, len(mmSince.callArgs))
	copy(argCopy, mmSince.callArgs)

	mmSince.mutex.RUnlock()

	return argCopy
}

// MinimockSinceDone returns true if the count of the Since invocations corresponds
// the number of defined expectations
func (m *ClockMock) MinimockSinceDone() bool {
	for _, e := range m.SinceMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			return false
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SinceMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSinceCounter) < 1 {
		return false
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSince != nil && mm_atomic.LoadUint64(&m.afterSinceCounter) < 1 {
		return false
	}
	return true
}

// MinimockSinceInspect logs each unmet expectation
func (m *ClockMock) MinimockSinceInspect() {
	for _, e := range m.SinceMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			m.t.Errorf("Expected call to ClockMock.Since with params: %#v", *e.params)
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SinceMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSinceCounter) < 1 {
		if m.SinceMock.defaultExpectation.params == nil {
			m.t.Error("Expected call to ClockMock.Since")
		} else {
			m.t.Errorf("Expected call to ClockMock.Since with params: %#v", *m.SinceMock.defaultExpectation.params)
		}
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSince != nil && mm_atomic.LoadUint64(&m.afterSinceCounter) < 1 {
		m.t.Error("Expected call to ClockMock.Since")
	}
}

type mClockMockSinceMS struct {
	mock               *ClockMock
	defaultExpectation *ClockMockSinceMSExpectation
	expectations       []*ClockMockSinceMSExpectation

	callArgs []*ClockMockSinceMSParams
	mutex    sync.RWMutex
}

// ClockMockSinceMSExpectation specifies expectation struct of the Clock.SinceMS
type ClockMockSinceMSExpectation struct {
	mock    *ClockMock
	params  *ClockMockSinceMSParams
	results *ClockMockSinceMSResults
	Counter uint64
}

// ClockMockSinceMSParams contains parameters of the Clock.SinceMS
type ClockMockSinceMSParams struct {
	t1 time.Time
}

// ClockMockSinceMSResults contains results of the Clock.SinceMS
type ClockMockSinceMSResults struct {
	i1 int
}

// Expect sets up expected params for Clock.SinceMS
func (mmSinceMS *mClockMockSinceMS) Expect(t1 time.Time) *mClockMockSinceMS {
	if mmSinceMS.mock.funcSinceMS != nil {
		mmSinceMS.mock.t.Fatalf("ClockMock.SinceMS mock is already set by Set")
	}

	if mmSinceMS.defaultExpectation == nil {
		mmSinceMS.defaultExpectation = &ClockMockSinceMSExpectation{}
	}

	mmSinceMS.defaultExpectation.params = &ClockMockSinceMSParams{t1}
	for _, e := range mmSinceMS.expectations {
		if minimock.Equal(e.params, mmSinceMS.defaultExpectation.params) {
			mmSinceMS.mock.t.Fatalf("Expectation set by When has same params: %#v", *mmSinceMS.defaultExpectation.params)
		}
	}

	return mmSinceMS
}

// Inspect accepts an inspector function that has same arguments as the Clock.SinceMS
func (mmSinceMS *mClockMockSinceMS) Inspect(f func(t1 time.Time)) *mClockMockSinceMS {
	if mmSinceMS.mock.inspectFuncSinceMS != nil {
		mmSinceMS.mock.t.Fatalf("Inspect function is already set for ClockMock.SinceMS")
	}

	mmSinceMS.mock.inspectFuncSinceMS = f

	return mmSinceMS
}

// Return sets up results that will be returned by Clock.SinceMS
func (mmSinceMS *mClockMockSinceMS) Return(i1 int) *ClockMock {
	if mmSinceMS.mock.funcSinceMS != nil {
		mmSinceMS.mock.t.Fatalf("ClockMock.SinceMS mock is already set by Set")
	}

	if mmSinceMS.defaultExpectation == nil {
		mmSinceMS.defaultExpectation = &ClockMockSinceMSExpectation{mock: mmSinceMS.mock}
	}
	mmSinceMS.defaultExpectation.results = &ClockMockSinceMSResults{i1}
	return mmSinceMS.mock
}

//Set uses given function f to mock the Clock.SinceMS method
func (mmSinceMS *mClockMockSinceMS) Set(f func(t1 time.Time) (i1 int)) *ClockMock {
	if mmSinceMS.defaultExpectation != nil {
		mmSinceMS.mock.t.Fatalf("Default expectation is already set for the Clock.SinceMS method")
	}

	if len(mmSinceMS.expectations) > 0 {
		mmSinceMS.mock.t.Fatalf("Some expectations are already set for the Clock.SinceMS method")
	}

	mmSinceMS.mock.funcSinceMS = f
	return mmSinceMS.mock
}

// When sets expectation for the Clock.SinceMS which will trigger the result defined by the following
// Then helper
func (mmSinceMS *mClockMockSinceMS) When(t1 time.Time) *ClockMockSinceMSExpectation {
	if mmSinceMS.mock.funcSinceMS != nil {
		mmSinceMS.mock.t.Fatalf("ClockMock.SinceMS mock is already set by Set")
	}

	expectation := &ClockMockSinceMSExpectation{
		mock:   mmSinceMS.mock,
		params: &ClockMockSinceMSParams{t1},
	}
	mmSinceMS.expectations = append(mmSinceMS.expectations, expectation)
	return expectation
}

// Then sets up Clock.SinceMS return parameters for the expectation previously defined by the When method
func (e *ClockMockSinceMSExpectation) Then(i1 int) *ClockMock {
	e.results = &ClockMockSinceMSResults{i1}
	return e.mock
}

// SinceMS implements libtime.Clock
func (mmSinceMS *ClockMock) SinceMS(t1 time.Time) (i1 int) {
	mm_atomic.AddUint64(&mmSinceMS.beforeSinceMSCounter, 1)
	defer mm_atomic.AddUint64(&mmSinceMS.afterSinceMSCounter, 1)

	if mmSinceMS.inspectFuncSinceMS != nil {
		mmSinceMS.inspectFuncSinceMS(t1)
	}

	mm_params := &ClockMockSinceMSParams{t1}

	// Record call args
	mmSinceMS.SinceMSMock.mutex.Lock()
	mmSinceMS.SinceMSMock.callArgs = append(mmSinceMS.SinceMSMock.callArgs, mm_params)
	mmSinceMS.SinceMSMock.mutex.Unlock()

	for _, e := range mmSinceMS.SinceMSMock.expectations {
		if minimock.Equal(e.params, mm_params) {
			mm_atomic.AddUint64(&e.Counter, 1)
			return e.results.i1
		}
	}

	if mmSinceMS.SinceMSMock.defaultExpectation != nil {
		mm_atomic.AddUint64(&mmSinceMS.SinceMSMock.defaultExpectation.Counter, 1)
		mm_want := mmSinceMS.SinceMSMock.defaultExpectation.params
		mm_got := ClockMockSinceMSParams{t1}
		if mm_want != nil && !minimock.Equal(*mm_want, mm_got) {
			mmSinceMS.t.Errorf("ClockMock.SinceMS got unexpected parameters, want: %#v, got: %#v%s\n", *mm_want, mm_got, minimock.Diff(*mm_want, mm_got))
		}

		mm_results := mmSinceMS.SinceMSMock.defaultExpectation.results
		if mm_results == nil {
			mmSinceMS.t.Fatal("No results are set for the ClockMock.SinceMS")
		}
		return (*mm_results).i1
	}
	if mmSinceMS.funcSinceMS != nil {
		return mmSinceMS.funcSinceMS(t1)
	}
	mmSinceMS.t.Fatalf("Unexpected call to ClockMock.SinceMS. %v", t1)
	return
}

// SinceMSAfterCounter returns a count of finished ClockMock.SinceMS invocations
func (mmSinceMS *ClockMock) SinceMSAfterCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSinceMS.afterSinceMSCounter)
}

// SinceMSBeforeCounter returns a count of ClockMock.SinceMS invocations
func (mmSinceMS *ClockMock) SinceMSBeforeCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSinceMS.beforeSinceMSCounter)
}

// Calls returns a list of arguments used in each call to ClockMock.SinceMS.
// The list is in the same order as the calls were made (i.e. recent calls have a higher index)
func (mmSinceMS *mClockMockSinceMS) Calls() []*ClockMockSinceMSParams {
	mmSinceMS.mutex.RLock()

	argCopy := make([]*ClockMockSinceMSParams, len(mmSinceMS.callArgs))
	copy(argCopy, mmSinceMS.callArgs)

	mmSinceMS.mutex.RUnlock()

	return argCopy
}

// MinimockSinceMSDone returns true if the count of the SinceMS invocations corresponds
// the number of defined expectations
func (m *ClockMock) MinimockSinceMSDone() bool {
	for _, e := range m.SinceMSMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			return false
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SinceMSMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSinceMSCounter) < 1 {
		return false
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSinceMS != nil && mm_atomic.LoadUint64(&m.afterSinceMSCounter) < 1 {
		return false
	}
	return true
}

// MinimockSinceMSInspect logs each unmet expectation
func (m *ClockMock) MinimockSinceMSInspect() {
	for _, e := range m.SinceMSMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			m.t.Errorf("Expected call to ClockMock.SinceMS with params: %#v", *e.params)
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SinceMSMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSinceMSCounter) < 1 {
		if m.SinceMSMock.defaultExpectation.params == nil {
			m.t.Error("Expected call to ClockMock.SinceMS")
		} else {
			m.t.Errorf("Expected call to ClockMock.SinceMS with params: %#v", *m.SinceMSMock.defaultExpectation.params)
		}
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSinceMS != nil && mm_atomic.LoadUint64(&m.afterSinceMSCounter) < 1 {
		m.t.Error("Expected call to ClockMock.SinceMS")
	}
}

// MinimockFinish checks that all mocked methods have been called the expected number of times
func (m *ClockMock) MinimockFinish() {
	if !m.minimockDone() {
		m.MinimockNowInspect()

		m.MinimockSinceInspect()

		m.MinimockSinceMSInspect()
		m.t.FailNow()
	}
}

// MinimockWait waits for all mocked methods to be called the expected number of times
func (m *ClockMock) MinimockWait(timeout mm_time.Duration) {
	timeoutCh := mm_time.After(timeout)
	for {
		if m.minimockDone() {
			return
		}
		select {
		case <-timeoutCh:
			m.MinimockFinish()
			return
		case <-mm_time.After(10 * mm_time.Millisecond):
		}
	}
}

func (m *ClockMock) minimockDone() bool {
	done := true
	return done &&
		m.MinimockNowDone() &&
		m.MinimockSinceDone() &&
		m.MinimockSinceMSDone()
}
