// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20200918

import (
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
    tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
)

const APIVersion = "2020-09-18"

type Client struct {
    common.Client
}

// Deprecated
func NewClientWithSecretId(secretId, secretKey, region string) (client *Client, err error) {
    cpf := profile.NewClientProfile()
    client = &Client{}
    client.Init(region).WithSecretId(secretId, secretKey).WithProfile(cpf)
    return
}

func NewClient(credential *common.Credential, region string, clientProfile *profile.ClientProfile) (client *Client, err error) {
    client = &Client{}
    client.Init(region).
        WithCredential(credential).
        WithProfile(clientProfile)
    return
}


func NewCreateCameraAlertsRequest() (request *CreateCameraAlertsRequest) {
    request = &CreateCameraAlertsRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateCameraAlerts")
    return
}

func NewCreateCameraAlertsResponse() (response *CreateCameraAlertsResponse) {
    response = &CreateCameraAlertsResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 上报相机移动、遮挡等告警信息
// 
func (c *Client) CreateCameraAlerts(request *CreateCameraAlertsRequest) (response *CreateCameraAlertsResponse, err error) {
    if request == nil {
        request = NewCreateCameraAlertsRequest()
    }
    response = NewCreateCameraAlertsResponse()
    err = c.Send(request, response)
    return
}

func NewCreateCameraStateRequest() (request *CreateCameraStateRequest) {
    request = &CreateCameraStateRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateCameraState")
    return
}

func NewCreateCameraStateResponse() (response *CreateCameraStateResponse) {
    response = &CreateCameraStateResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 上报当前场内所有相机的当前状态
func (c *Client) CreateCameraState(request *CreateCameraStateRequest) (response *CreateCameraStateResponse, err error) {
    if request == nil {
        request = NewCreateCameraStateRequest()
    }
    response = NewCreateCameraStateResponse()
    err = c.Send(request, response)
    return
}

func NewCreateCaptureRequest() (request *CreateCaptureRequest) {
    request = &CreateCaptureRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateCapture")
    return
}

func NewCreateCaptureResponse() (response *CreateCaptureResponse) {
    response = &CreateCaptureResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 场内抓拍上报接口
func (c *Client) CreateCapture(request *CreateCaptureRequest) (response *CreateCaptureResponse, err error) {
    if request == nil {
        request = NewCreateCaptureRequest()
    }
    response = NewCreateCaptureResponse()
    err = c.Send(request, response)
    return
}

func NewCreateMultiBizAlertRequest() (request *CreateMultiBizAlertRequest) {
    request = &CreateMultiBizAlertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateMultiBizAlert")
    return
}

func NewCreateMultiBizAlertResponse() (response *CreateMultiBizAlertResponse) {
    response = &CreateMultiBizAlertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 集团广场的多经点位告警
func (c *Client) CreateMultiBizAlert(request *CreateMultiBizAlertRequest) (response *CreateMultiBizAlertResponse, err error) {
    if request == nil {
        request = NewCreateMultiBizAlertRequest()
    }
    response = NewCreateMultiBizAlertResponse()
    err = c.Send(request, response)
    return
}

func NewCreateProgramStateRequest() (request *CreateProgramStateRequest) {
    request = &CreateProgramStateRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateProgramState")
    return
}

func NewCreateProgramStateResponse() (response *CreateProgramStateResponse) {
    response = &CreateProgramStateResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 上报所有进程监控信息
func (c *Client) CreateProgramState(request *CreateProgramStateRequest) (response *CreateProgramStateResponse, err error) {
    if request == nil {
        request = NewCreateProgramStateRequest()
    }
    response = NewCreateProgramStateResponse()
    err = c.Send(request, response)
    return
}

func NewCreateServerStateRequest() (request *CreateServerStateRequest) {
    request = &CreateServerStateRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "CreateServerState")
    return
}

func NewCreateServerStateResponse() (response *CreateServerStateResponse) {
    response = &CreateServerStateResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 上报所有服务器硬件监控信息
func (c *Client) CreateServerState(request *CreateServerStateRequest) (response *CreateServerStateResponse, err error) {
    if request == nil {
        request = NewCreateServerStateRequest()
    }
    response = NewCreateServerStateResponse()
    err = c.Send(request, response)
    return
}

func NewDeleteMultiBizAlertRequest() (request *DeleteMultiBizAlertRequest) {
    request = &DeleteMultiBizAlertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DeleteMultiBizAlert")
    return
}

func NewDeleteMultiBizAlertResponse() (response *DeleteMultiBizAlertResponse) {
    response = &DeleteMultiBizAlertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 集团广场的多经点位消警
func (c *Client) DeleteMultiBizAlert(request *DeleteMultiBizAlertRequest) (response *DeleteMultiBizAlertResponse, err error) {
    if request == nil {
        request = NewDeleteMultiBizAlertRequest()
    }
    response = NewDeleteMultiBizAlertResponse()
    err = c.Send(request, response)
    return
}

func NewDeleteTaskRequest() (request *DeleteTaskRequest) {
    request = &DeleteTaskRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DeleteTask")
    return
}

func NewDeleteTaskResponse() (response *DeleteTaskResponse) {
    response = &DeleteTaskResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 删除集团广场对应的任务
func (c *Client) DeleteTask(request *DeleteTaskRequest) (response *DeleteTaskResponse, err error) {
    if request == nil {
        request = NewDeleteTaskRequest()
    }
    response = NewDeleteTaskResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeCamerasRequest() (request *DescribeCamerasRequest) {
    request = &DescribeCamerasRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeCameras")
    return
}

func NewDescribeCamerasResponse() (response *DescribeCamerasResponse) {
    response = &DescribeCamerasResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 获取集团广场对应的摄像头列表
func (c *Client) DescribeCameras(request *DescribeCamerasRequest) (response *DescribeCamerasResponse, err error) {
    if request == nil {
        request = NewDescribeCamerasRequest()
    }
    response = NewDescribeCamerasResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeConfigRequest() (request *DescribeConfigRequest) {
    request = &DescribeConfigRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeConfig")
    return
}

func NewDescribeConfigResponse() (response *DescribeConfigResponse) {
    response = &DescribeConfigResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 获取摄像头配置信息
// mac不为空返回指定相机配置
// mac为空返回对应GroupCode和MallId全量配置
func (c *Client) DescribeConfig(request *DescribeConfigRequest) (response *DescribeConfigResponse, err error) {
    if request == nil {
        request = NewDescribeConfigRequest()
    }
    response = NewDescribeConfigResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeImageRequest() (request *DescribeImageRequest) {
    request = &DescribeImageRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeImage")
    return
}

func NewDescribeImageResponse() (response *DescribeImageResponse) {
    response = &DescribeImageResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 实时获取底图接口
func (c *Client) DescribeImage(request *DescribeImageRequest) (response *DescribeImageResponse, err error) {
    if request == nil {
        request = NewDescribeImageRequest()
    }
    response = NewDescribeImageResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeMultiBizBaseImageRequest() (request *DescribeMultiBizBaseImageRequest) {
    request = &DescribeMultiBizBaseImageRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeMultiBizBaseImage")
    return
}

func NewDescribeMultiBizBaseImageResponse() (response *DescribeMultiBizBaseImageResponse) {
    response = &DescribeMultiBizBaseImageResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 获取多经点位底图
func (c *Client) DescribeMultiBizBaseImage(request *DescribeMultiBizBaseImageRequest) (response *DescribeMultiBizBaseImageResponse, err error) {
    if request == nil {
        request = NewDescribeMultiBizBaseImageRequest()
    }
    response = NewDescribeMultiBizBaseImageResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeTasksRequest() (request *DescribeTasksRequest) {
    request = &DescribeTasksRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeTasks")
    return
}

func NewDescribeTasksResponse() (response *DescribeTasksResponse) {
    response = &DescribeTasksResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 查询集团广场对应的任务列表
func (c *Client) DescribeTasks(request *DescribeTasksRequest) (response *DescribeTasksResponse, err error) {
    if request == nil {
        request = NewDescribeTasksRequest()
    }
    response = NewDescribeTasksResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeZonesRequest() (request *DescribeZonesRequest) {
    request = &DescribeZonesRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "DescribeZones")
    return
}

func NewDescribeZonesResponse() (response *DescribeZonesResponse) {
    response = &DescribeZonesResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 获取集团广场的点位列表
func (c *Client) DescribeZones(request *DescribeZonesRequest) (response *DescribeZonesResponse, err error) {
    if request == nil {
        request = NewDescribeZonesRequest()
    }
    response = NewDescribeZonesResponse()
    err = c.Send(request, response)
    return
}

func NewModifyMultiBizConfigRequest() (request *ModifyMultiBizConfigRequest) {
    request = &ModifyMultiBizConfigRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "ModifyMultiBizConfig")
    return
}

func NewModifyMultiBizConfigResponse() (response *ModifyMultiBizConfigResponse) {
    response = &ModifyMultiBizConfigResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 集团广场的多经点位配置更新
func (c *Client) ModifyMultiBizConfig(request *ModifyMultiBizConfigRequest) (response *ModifyMultiBizConfigResponse, err error) {
    if request == nil {
        request = NewModifyMultiBizConfigRequest()
    }
    response = NewModifyMultiBizConfigResponse()
    err = c.Send(request, response)
    return
}

func NewReportServiceRegisterRequest() (request *ReportServiceRegisterRequest) {
    request = &ReportServiceRegisterRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "ReportServiceRegister")
    return
}

func NewReportServiceRegisterResponse() (response *ReportServiceRegisterResponse) {
    response = &ReportServiceRegisterResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 上报服务注册自身的服务地址作为回调地址, 用于信息回传。
func (c *Client) ReportServiceRegister(request *ReportServiceRegisterRequest) (response *ReportServiceRegisterResponse, err error) {
    if request == nil {
        request = NewReportServiceRegisterRequest()
    }
    response = NewReportServiceRegisterResponse()
    err = c.Send(request, response)
    return
}

func NewSearchImageRequest() (request *SearchImageRequest) {
    request = &SearchImageRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("ump", APIVersion, "SearchImage")
    return
}

func NewSearchImageResponse() (response *SearchImageResponse) {
    response = &SearchImageResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 以图搜图
func (c *Client) SearchImage(request *SearchImageRequest) (response *SearchImageResponse, err error) {
    if request == nil {
        request = NewSearchImageRequest()
    }
    response = NewSearchImageResponse()
    err = c.Send(request, response)
    return
}
