package oidc

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestRefreshToken_String(t *testing.T) {
	t.Parallel()
	t.Run("redacted", func(t *testing.T) {
		assert := assert.New(t)
		const want = RedactedRefreshToken
		tk := RefreshToken("super secret token")
		assert.Equalf(want, tk.String(), "RefreshToken.String() = %v, want %v", tk.String(), want)
	})
}

func TestRefreshToken_MarshalJSON(t *testing.T) {
	t.Parallel()
	t.Run("redacted", func(t *testing.T) {
		assert, require := assert.New(t), require.New(t)
		want := fmt.Sprintf(`"%s"`, RedactedRefreshToken)
		tk := RefreshToken("super secret token")
		got, err := tk.MarshalJSON()
		require.NoError(err)
		assert.Equalf([]byte(want), got, "RefreshToken.MarshalJSON() = %s, want %s", got, want)
	})
}
