package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LongTermRetentionManagedInstanceBackupsClient is the the Azure SQL Database management API provides a RESTful set of
// web services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type LongTermRetentionManagedInstanceBackupsClient struct {
	BaseClient
}

// NewLongTermRetentionManagedInstanceBackupsClient creates an instance of the
// LongTermRetentionManagedInstanceBackupsClient client.
func NewLongTermRetentionManagedInstanceBackupsClient(subscriptionID string) LongTermRetentionManagedInstanceBackupsClient {
	return NewLongTermRetentionManagedInstanceBackupsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLongTermRetentionManagedInstanceBackupsClientWithBaseURI creates an instance of the
// LongTermRetentionManagedInstanceBackupsClient client using a custom endpoint.  Use this when interacting with an
// Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewLongTermRetentionManagedInstanceBackupsClientWithBaseURI(baseURI string, subscriptionID string) LongTermRetentionManagedInstanceBackupsClient {
	return LongTermRetentionManagedInstanceBackupsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Delete deletes a long term retention backup.
// Parameters:
// locationName - the location of the database.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// backupName - the backup name.
func (client LongTermRetentionManagedInstanceBackupsClient) Delete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result LongTermRetentionManagedInstanceBackupsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, locationName, managedInstanceName, databaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client LongTermRetentionManagedInstanceBackupsClient) DeletePreparer(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":          autorest.Encode("path", backupName),
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteSender(req *http.Request) (future LongTermRetentionManagedInstanceBackupsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByResourceGroup deletes a long term retention backup.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// backupName - the backup name.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.DeleteByResourceGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByResourceGroupPreparer(ctx, resourceGroupName, locationName, managedInstanceName, databaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "DeleteByResourceGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteByResourceGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "DeleteByResourceGroup", nil, "Failure sending request")
		return
	}

	return
}

// DeleteByResourceGroupPreparer prepares the DeleteByResourceGroup request.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":          autorest.Encode("path", backupName),
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByResourceGroupSender sends the DeleteByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteByResourceGroupSender(req *http.Request) (future LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteByResourceGroupResponder handles the response to the DeleteByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) DeleteByResourceGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a long term retention backup for a managed database.
// Parameters:
// locationName - the location of the database.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// backupName - the backup name.
func (client LongTermRetentionManagedInstanceBackupsClient) Get(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result ManagedInstanceLongTermRetentionBackup, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, locationName, managedInstanceName, databaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client LongTermRetentionManagedInstanceBackupsClient) GetPreparer(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":          autorest.Encode("path", backupName),
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) GetResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByResourceGroup gets a long term retention backup for a managed database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// backupName - the backup name.
func (client LongTermRetentionManagedInstanceBackupsClient) GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result ManagedInstanceLongTermRetentionBackup, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.GetByResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByResourceGroupPreparer(ctx, resourceGroupName, locationName, managedInstanceName, databaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "GetByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "GetByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "GetByResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetByResourceGroupPreparer prepares the GetByResourceGroup request.
func (client LongTermRetentionManagedInstanceBackupsClient) GetByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":          autorest.Encode("path", backupName),
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByResourceGroupSender sends the GetByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) GetByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetByResourceGroupResponder handles the response to the GetByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) GetByResourceGroupResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDatabase lists all long term retention backups for a managed database.
// Parameters:
// locationName - the location of the database.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByDatabase(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByDatabaseNextResults
	req, err := client.ListByDatabasePreparer(ctx, locationName, managedInstanceName, databaseName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByDatabase", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByDatabase", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByDatabasePreparer prepares the ListByDatabase request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByDatabasePreparer(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDatabaseSender sends the ListByDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByDatabaseResponder handles the response to the ListByDatabase request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByDatabaseResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDatabaseNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByDatabaseNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByDatabaseNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByDatabaseNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByDatabaseNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDatabaseComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByDatabaseComplete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDatabase(ctx, locationName, managedInstanceName, databaseName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByInstance lists the long term retention backups for a given managed instance.
// Parameters:
// locationName - the location of the database
// managedInstanceName - the name of the managed instance.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByInstance(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByInstance")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByInstanceNextResults
	req, err := client.ListByInstancePreparer(ctx, locationName, managedInstanceName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByInstance", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByInstanceSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByInstance", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByInstance", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByInstancePreparer prepares the ListByInstance request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByInstancePreparer(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByInstanceSender sends the ListByInstance request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByInstanceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByInstanceResponder handles the response to the ListByInstance request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByInstanceResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByInstanceNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByInstanceNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByInstanceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByInstanceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByInstanceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByInstanceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByInstanceComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByInstanceComplete(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByInstance")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByInstance(ctx, locationName, managedInstanceName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByLocation lists the long term retention backups for managed databases in a given location.
// Parameters:
// locationName - the location of the database.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByLocation")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByLocationNextResults
	req, err := client.ListByLocationPreparer(ctx, locationName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByLocation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByLocation", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByLocation", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLocationPreparer prepares the ListByLocation request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByLocationPreparer(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLocationSender sends the ListByLocation request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByLocationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLocationResponder handles the response to the ListByLocation request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByLocationResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLocationNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByLocationNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByLocationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByLocationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByLocationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLocationComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByLocation")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLocation(ctx, locationName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupDatabase lists all long term retention backups for a managed database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the managed database.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupDatabase")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupDatabaseNextResults
	req, err := client.ListByResourceGroupDatabasePreparer(ctx, resourceGroupName, locationName, managedInstanceName, databaseName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupDatabaseSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupDatabase", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByResourceGroupDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupDatabase", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupDatabasePreparer prepares the ListByResourceGroupDatabase request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupDatabasePreparer(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":        autorest.Encode("path", databaseName),
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupDatabaseSender sends the ListByResourceGroupDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupDatabaseResponder handles the response to the ListByResourceGroupDatabase request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupDatabaseResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupDatabaseNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByResourceGroupDatabaseNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupDatabaseNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupDatabaseNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupDatabaseNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupDatabaseComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupDatabase")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupDatabase(ctx, resourceGroupName, locationName, managedInstanceName, databaseName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupInstance lists the long term retention backups for a given managed instance.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// managedInstanceName - the name of the managed instance.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupInstance(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupInstance")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupInstanceNextResults
	req, err := client.ListByResourceGroupInstancePreparer(ctx, resourceGroupName, locationName, managedInstanceName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupInstance", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupInstanceSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupInstance", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByResourceGroupInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupInstance", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupInstancePreparer prepares the ListByResourceGroupInstance request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupInstancePreparer(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":        autorest.Encode("path", locationName),
		"managedInstanceName": autorest.Encode("path", managedInstanceName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupInstanceSender sends the ListByResourceGroupInstance request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupInstanceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupInstanceResponder handles the response to the ListByResourceGroupInstance request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupInstanceResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupInstanceNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByResourceGroupInstanceNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupInstanceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupInstanceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupInstanceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupInstanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupInstanceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupInstanceComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupInstanceComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupInstance")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupInstance(ctx, resourceGroupName, locationName, managedInstanceName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupLocation lists the long term retention backups for managed databases in a given location.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupLocation")
		defer func() {
			sc := -1
			if result.miltrblr.Response.Response != nil {
				sc = result.miltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupLocationNextResults
	req, err := client.ListByResourceGroupLocationPreparer(ctx, resourceGroupName, locationName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupLocation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupLocationSender(req)
	if err != nil {
		result.miltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupLocation", resp, "Failure sending request")
		return
	}

	result.miltrblr, err = client.ListByResourceGroupLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "ListByResourceGroupLocation", resp, "Failure responding to request")
		return
	}
	if result.miltrblr.hasNextLink() && result.miltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupLocationPreparer prepares the ListByResourceGroupLocation request.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupLocationPreparer(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":      autorest.Encode("path", locationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstanceBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupLocationSender sends the ListByResourceGroupLocation request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupLocationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupLocationResponder handles the response to the ListByResourceGroupLocation request. The method always
// closes the http.Response Body.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupLocationResponder(resp *http.Response) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupLocationNextResults retrieves the next set of results, if any.
func (client LongTermRetentionManagedInstanceBackupsClient) listByResourceGroupLocationNextResults(ctx context.Context, lastResults ManagedInstanceLongTermRetentionBackupListResult) (result ManagedInstanceLongTermRetentionBackupListResult, err error) {
	req, err := lastResults.managedInstanceLongTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupLocationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupLocationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupLocationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsClient", "listByResourceGroupLocationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupLocationComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionManagedInstanceBackupsClient) ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result ManagedInstanceLongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupLocation")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupLocation(ctx, resourceGroupName, locationName, onlyLatestPerDatabase, databaseState)
	return
}
